/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridMath;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.HovmollerViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.ColorScale;
import ucar.visad.display.Contour2DDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.XYDisplay;
import visad.AxisScale;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DDoubleSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.util.DataUtility;

public class HovmollerControl
extends GridDisplayControl {
    public static final int LON_DIM = 0;
    public static final int LAT_DIM = 1;
    private int averageDim = 1;
    private XYDisplay hovmollerDisplay;
    private FieldImpl fieldImpl;
    private DisplayableData dataDisplay;
    private Contour2DDisplayable contourDisplay;
    private boolean showAsContours = true;
    private Color foreground;
    private Color background;
    private static final String defaultTimeFormat = "MMM dd HH'Z'";
    private String timeFormat = "MMM dd HH'Z'";
    private HovmollerViewManager hovmollerView;
    private boolean reverseTime = true;

    public HovmollerControl() {
        this.setAttributeFlags(16);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (this.hovmollerView != null) {
            this.hovmollerView.initAfterUnPersistence(this.getIdv());
            this.hovmollerDisplay = this.hovmollerView.getHovmollerDisplay();
        } else {
            this.hovmollerView = new HovmollerViewManager(this.getViewContext(), new ViewDescriptor("hovmoller_of_" + this.paramName), "showControlLegend=false;wireframe=true;");
            this.hovmollerDisplay = this.hovmollerView.getHovmollerDisplay();
            this.hovmollerDisplay.setAspect(0.8, 1.0);
        }
        this.hovmollerDisplay.setYAxisType(RealType.Time);
        this.hovmollerDisplay.setXAxisType(this.getAverageDimension() == 1 ? RealType.Longitude : RealType.Latitude);
        if (this.foreground != null) {
            this.hovmollerView.setColors(this.foreground, this.background);
        }
        this.addViewManager(this.hovmollerView);
        if (this.showAsContours) {
            this.addAttributeFlags(4);
            this.dataDisplay = new Contour2DDisplayable("ts_color_" + this.paramName, true, true);
            this.dataDisplay.setVisible(true);
            this.contourDisplay = new Contour2DDisplayable("ts_contour_" + this.paramName);
            this.contourDisplay.setVisible(true);
            this.addDisplayable((Displayable)this.dataDisplay, this.hovmollerView, 42);
            this.addDisplayable((Displayable)this.contourDisplay, this.hovmollerView, 38);
        } else {
            this.dataDisplay = this.createDataDisplay();
            this.addDisplayable((Displayable)this.dataDisplay, this.hovmollerView, this.getDataDisplayFlags());
        }
        return this.setData(dataChoice);
    }

    protected int getDataDisplayFlags() {
        return 40;
    }

    protected DisplayableData createDataDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable dataDisplay = new Grid2DDisplayable("ts_color_" + this.paramName, true);
        dataDisplay.setTextureEnable(true);
        dataDisplay.setVisible(true);
        return dataDisplay;
    }

    public DisplayableData getDataDisplay() {
        return this.dataDisplay;
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.setData(dataChoice)) {
            return false;
        }
        this.fieldImpl = this.getGridDataInstance().getGrid();
        boolean isSequence = GridUtil.isTimeSequence(this.fieldImpl);
        if (!isSequence || this.fieldImpl.getDomainSet().getLength() <= 1) {
            throw new VisADException("Need more than one time to create a Time-Space Diagram");
        }
        this.loadData();
        this.setTimeAxisLabels((SampledSet)this.fieldImpl.getDomainSet());
        return true;
    }

    public void loadData() throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (this.fieldImpl == null) {
            return;
        }
        this.displayTSForCoord(this.fieldImpl, this.getAverageDimension());
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            this.loadData();
            this.hovmollerDisplay.draw();
        }
        catch (Exception exc) {
            HovmollerControl.logException("initDone", exc);
        }
    }

    protected void displayTSForCoord(FieldImpl fi, int NN) throws VisADException, RemoteException {
        int index;
        if (GridUtil.isVolume(fi)) {
            throw new VisADException("Need to select a level");
        }
        int averageIndex = NN;
        int spatialIndex = 1 - NN;
        Set timeSet = fi.getDomainSet();
        double[][] timeVals = timeSet.getDoubles();
        GriddedSet spatialDomain = (GriddedSet)GridUtil.getSpatialDomain(fi);
        int[] sizes = spatialDomain.getLengths();
        TupleType parmType = GridUtil.getParamType(fi);
        int numParms = parmType.getNumberOfRealComponents();
        RealType parm = parmType.getRealComponents()[0];
        RealType other = spatialIndex == 0 ? RealType.Longitude : RealType.Latitude;
        RealTupleType newDomainType = new RealTupleType(other, RealType.Time);
        FieldImpl data = GridMath.applyFunctionToAxis(fi, "average", averageIndex == 1 ? "Y" : "X");
        FunctionType newFieldType = new FunctionType(newDomainType, parm);
        int numTimes = timeVals[0].length;
        int numSpace = sizes[spatialIndex];
        int numOtherSpace = sizes[averageIndex];
        float[][] latlonalt = spatialDomain.getSamples();
        Unit spaceUnit = spatialDomain.getSetUnits()[spatialIndex];
        CoordinateSystem cs = spatialDomain.getCoordinateSystem();
        if (cs != null) {
            spatialIndex = cs.getReference().getIndex(other);
            latlonalt = cs.toReference(latlonalt, spatialDomain.getSetUnits());
            spaceUnit = cs.getReferenceUnits()[spatialIndex];
        }
        double[][] newDomainVals = new double[2][numTimes * numSpace];
        int l = 0;
        for (int j = 0; j < numTimes; ++j) {
            for (int i = 0; i < numSpace; ++i) {
                index = averageIndex == 1 ? i : i * numOtherSpace;
                newDomainVals[0][l] = latlonalt[spatialIndex][index];
                newDomainVals[1][l] = timeVals[0][j];
                ++l;
            }
        }
        Gridded2DDoubleSet newDomain = new Gridded2DDoubleSet((MathType)newDomainType, newDomainVals, numSpace, numTimes, (CoordinateSystem)null, new Unit[]{spaceUnit, timeSet.getSetUnits()[0]}, (ErrorEstimate[])null, false);
        float[][] newRangeVals = new float[numParms][numTimes * numSpace];
        index = 0;
        for (int i = 0; i < numTimes; ++i) {
            FlatField ff = (FlatField)data.getSample(i);
            float[][] vals = ff.getFloats(false);
            for (int j = 0; j < numParms; ++j) {
                if (averageIndex == 1) {
                    System.arraycopy(vals[j], 0, newRangeVals[j], index, numSpace);
                    continue;
                }
                for (int k = 0; k < numSpace; ++k) {
                    newRangeVals[j][index + k] = vals[j][k * numOtherSpace];
                }
            }
            index += numSpace;
        }
        FlatField hovData = new FlatField(newFieldType, newDomain);
        hovData.setSamples(newRangeVals, false);
        ((GridDisplayable)((Object)this.dataDisplay)).loadData(hovData);
        if (this.showAsContours) {
            RealType[] origTypes = parmType.getRealComponents();
            RealType[] parmTypes = new RealType[numParms];
            for (int i = 0; i < numParms; ++i) {
                RealType param = origTypes[i];
                parmTypes[i] = RealType.getRealType(param.getName() + "_color", param.getDefaultUnit());
            }
            RealTupleType colorType = new RealTupleType(parmTypes);
            FieldImpl hovDataOther = GridUtil.setParamType((FieldImpl)hovData, colorType, false);
            this.contourDisplay.loadData(hovDataOther);
        }
        this.setXAxisLabels(spatialDomain);
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(this.getTimeFormat(), "timeFormat", "Time Label Format", "Display");
        dsd.addPropertyValue(new Boolean(this.getReverseTime()), "reverseTime", "Latest Time at Bottom", "Display");
    }

    @Override
    public String getColorWidgetLabel() {
        return "Contour Line Color";
    }

    @Override
    protected String getDefaultDisplayListTemplate() {
        if (this.getGridDataInstance() == null) {
            return "%shortname%";
        }
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(this.getGridDataInstance().getGrid());
            float[][] ranges = this.getLatLonRanges(domainSet);
            CoordinateSystem cs = domainSet.getCoordinateSystem();
            int dimIndex = this.averageDim;
            if (cs != null) {
                dimIndex = cs.getReference().getIndex(this.averageDim == 1 ? RealType.Latitude : RealType.Longitude);
            }
            float high = ranges[dimIndex][1];
            float low = ranges[dimIndex][0];
            if (this.averageDim == 0) {
                float temp = high;
                high = low;
                low = temp;
            }
            DisplayConventions dc = this.getDisplayConventions();
            return "%shortname% - " + dc.formatLatLonCardinal(high, this.averageDim) + "-" + dc.formatLatLonCardinal(low, this.averageDim);
        }
        catch (VisADException ve) {
            return "%shortname%";
        }
    }

    private float[][] getLatLonRanges(GriddedSet domainSet) throws VisADException {
        CoordinateSystem cs = domainSet.getCoordinateSystem();
        float[] his = domainSet.getHi();
        float[] los = domainSet.getLow();
        int dimIndex = this.averageDim;
        float[][] ranges = null;
        if (cs != null) {
            float[][] latlons = cs.toReference(domainSet.getSamples());
            ranges = Misc.getRanges(latlons);
        } else {
            ranges = Misc.getRanges(domainSet.getSamples(false));
        }
        return ranges;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.centerBottom(this.hovmollerView.getContents(), this.doMakeWidgetComponent());
    }

    private void setTimeAxisValues() throws VisADException {
        if (this.getGridDataInstance() == null) {
            return;
        }
        SampledSet timeSet = (SampledSet)this.getGridDataInstance().getGrid().getDomainSet();
        this.setTimeAxisLabels(timeSet);
    }

    private void setXAxisValues() throws VisADException {
        if (this.getGridDataInstance() == null) {
            return;
        }
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(this.getGridDataInstance().getGrid());
        this.setXAxisLabels(domainSet);
    }

    private void setAxisLabels() throws VisADException {
        this.setXAxisValues();
        this.setTimeAxisValues();
    }

    @Override
    public void viewManagerChanged(String property) {
        try {
            this.setAxisLabels();
        }
        catch (Exception e) {
            HovmollerControl.logException("Problem setting labels", e);
        }
        super.viewManagerChanged(property);
    }

    private void setTimeAxisLabels(SampledSet timeSet) throws VisADException {
        try {
            int size;
            int k;
            if (timeSet == null) {
                return;
            }
            Real startTime = (Real)DataUtility.getSample(timeSet, 0).getComponent(0);
            double start = startTime.getValue();
            int numSteps = timeSet.getLength();
            Real endTime = (Real)DataUtility.getSample(timeSet, numSteps - 1).getComponent(0);
            double end = endTime.getValue();
            Hashtable<Double, String> timeLabels = new Hashtable<Double, String>();
            int step = numSteps < 5 ? 1 : timeSet.getLength() / 5;
            double majorTickSpacing = endTime.getValue() - startTime.getValue();
            String format = this.getTimeFormat();
            for (k = 0; k < numSteps; k += step) {
                Real r = (Real)DataUtility.getSample(timeSet, k).getComponent(0);
                double time = r.getValue();
                if (k == step) {
                    majorTickSpacing = time - start;
                }
                DateTime dt = new DateTime(r);
                timeLabels.put(new Double(time), dt.formattedString(format, DateTime.getFormatTimeZone()));
            }
            if (k - step < numSteps - step / 2) {
                DateTime dt = new DateTime(endTime);
                timeLabels.put(new Double(end), dt.formattedString(format, DateTime.getFormatTimeZone()));
            }
            if (this.getReverseTime()) {
                this.hovmollerDisplay.setYRange(end, start);
            } else {
                this.hovmollerDisplay.setYRange(start, end);
            }
            Font f = this.hovmollerView.getDisplayListFont();
            int n = size = f == null ? 12 : f.getSize();
            if (f != null && f.getName().equals("Default")) {
                f = null;
            }
            AxisScale timeScale = this.hovmollerDisplay.getYAxisScale();
            timeScale.setFont(f);
            timeScale.setLabelSize(size);
            timeScale.setSnapToBox(true);
            timeScale.setTickBase(start);
            timeScale.setMajorTickSpacing(majorTickSpacing);
            timeScale.setLabelTable(timeLabels);
            timeScale.setTitle("Time");
            AxisScale spaceScale = this.hovmollerDisplay.getXAxisScale();
            spaceScale.setSnapToBox(true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setXAxisLabels(GriddedSet spatialSet) throws VisADException {
        int size;
        double ratio;
        if (spatialSet == null) {
            return;
        }
        float[][] ranges = this.getLatLonRanges(spatialSet);
        CoordinateSystem cs = spatialSet.getCoordinateSystem();
        int dimIndex = 1 - this.averageDim;
        if (cs != null) {
            dimIndex = cs.getReference().getIndex(this.averageDim == 1 ? RealType.Longitude : RealType.Latitude);
        }
        double min = ranges[dimIndex][0];
        double max = ranges[dimIndex][1];
        double range = Math.abs(max - min);
        Hashtable<Double, String> xLabels = new Hashtable<Double, String>();
        double tens = 1.0;
        if (range < tens) {
            tens /= 10.0;
            while (range < tens) {
                tens /= 10.0;
            }
        } else {
            while (10.0 * tens <= range) {
                tens *= 10.0;
            }
        }
        if ((ratio = range / tens) < 2.0) {
            tens /= 5.0;
        } else if (ratio < 4.0) {
            tens /= 2.0;
        }
        double majorTickSpacing = tens;
        double[] hilo = Misc.computeTicks(max, min, 0.0, majorTickSpacing);
        double firstValue = hilo[0];
        double botval = hilo[0];
        double topval = hilo[hilo.length - 1];
        int numSteps = hilo.length;
        DisplayConventions dc = this.getDisplayConventions();
        for (int k = 0; k < hilo.length; ++k) {
            double val = hilo[k];
            xLabels.put(new Double(val), dc.formatLatLonCardinal(val, 1 - this.averageDim));
        }
        Font f = this.hovmollerView.getDisplayListFont();
        int n = size = f == null ? 12 : f.getSize();
        if (f != null && f.getName().equals("Default")) {
            f = null;
        }
        AxisScale xScale = this.hovmollerDisplay.getXAxisScale();
        xScale.setFont(f);
        xScale.setLabelSize(size);
        xScale.setSnapToBox(true);
        xScale.setTickBase(botval);
        double averageTickSpacing = (topval - botval) / (double)(numSteps - 1);
        xScale.setMajorTickSpacing(averageTickSpacing);
        xScale.setMinorTickSpacing(averageTickSpacing);
        xScale.setLabelTable(xLabels);
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JCheckBox toggle = new JCheckBox("Latest Time at Bottom", this.reverseTime);
        toggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HovmollerControl.this.reverseTime = ((JCheckBox)e.getSource()).isSelected();
                try {
                    HovmollerControl.this.setTimeAxisValues();
                }
                catch (VisADException ve) {
                    DisplayControlBase.userMessage("couldn't set time order");
                }
            }
        });
        final JTextField formatField = new JTextField(this.getTimeFormat());
        formatField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HovmollerControl.this.setTimeFormat(formatField.getText());
            }
        });
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Time: "), GuiUtils.centerRight(GuiUtils.leftCenter(GuiUtils.rLabel("Label Format: "), formatField), toggle)));
    }

    @Override
    protected void applyColor() throws VisADException, RemoteException {
        this.displayListUsesColor = false;
        super.applyColor();
    }

    @Override
    protected void getViewMenuItems(List items, boolean forMenuBar) {
        super.getViewMenuItems(items, forMenuBar);
        items.add("separator");
        if (forMenuBar) {
            JMenu hovMenu = this.hovmollerView.makeViewMenu();
            hovMenu.setText("Hovmoller View");
            items.add(hovMenu);
        }
    }

    @Override
    protected void doMakeColorScales() throws VisADException, RemoteException {
        this.colorScales = new ArrayList();
        if (this.colorScaleInfo == null) {
            this.colorScaleInfo = this.getDefaultColorScaleInfo();
        }
        ColorScale colorScale = new ColorScale(this.getColorScaleInfo());
        this.addDisplayable((Displayable)colorScale, this.hovmollerView, 8);
        this.colorScales.add(colorScale);
    }

    @Override
    public void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        if (this.hovmollerView != null) {
            jtp.add("Hovmoller View", this.hovmollerView.getPropertiesComponent());
        }
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.hovmollerView != null) {
            return this.hovmollerView.applyProperties();
        }
        return true;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        try {
            this.setTimeAxisValues();
        }
        catch (Exception exc) {
            HovmollerControl.logException("applyPreferences", exc);
        }
    }

    public void setShowAsContours(boolean yesorno) {
        this.showAsContours = yesorno;
    }

    public boolean getShowAsContours() {
        return this.showAsContours;
    }

    public void setAverageDimension(int dim) {
        this.averageDim = dim;
    }

    public int getAverageDimension() {
        return this.averageDim;
    }

    public void setTimeFormat(String format) {
        this.timeFormat = format;
        if (this.getHaveInitialized()) {
            try {
                this.setTimeAxisValues();
            }
            catch (VisADException ve) {
                HovmollerControl.logException("Unable to set time format", ve);
            }
        }
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setReverseTime(boolean yesorno) {
        this.reverseTime = yesorno;
        if (this.getHaveInitialized()) {
            try {
                this.setTimeAxisValues();
            }
            catch (VisADException ve) {
                HovmollerControl.logException("Unable to set time format", ve);
            }
        }
    }

    public boolean getReverseTime() {
        return this.reverseTime;
    }

    public void setHovmollerView(HovmollerViewManager value) {
        this.hovmollerView = value;
    }

    public HovmollerViewManager getHovmollerView() {
        return this.hovmollerView;
    }
}

