/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.control.AerologicalSoundingControl;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.GeoUtils;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.LineProbe;
import ucar.visad.functiontypes.AirTemperatureProfile;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class GriddedSoundingControl
extends AerologicalSoundingControl {
    private SoundingDataNode dataNode;
    private LineProbe probe;
    private DisplayableData gridLocs = new LineDrawing("GriddedSoundingControl gridLocs");
    private DisplayableData timesHolder;
    private Component widget;
    String listlabel = null;
    private boolean profilesVisibility = false;

    public GriddedSoundingControl() throws VisADException, RemoteException {
        super(false);
        this.probe = new LineProbe();
        this.probe.setVisible(true);
        this.setSounding(0);
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.init()) {
            return false;
        }
        this.setSpatialLoci(this.gridLocs);
        if (!this.setData(dataChoice)) {
            return false;
        }
        this.probe.addPropertyChangeListener("SelectorDisplay.position", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (GriddedSoundingControl.this.getActive() && GriddedSoundingControl.this.getHaveInitialized()) {
                    GriddedSoundingControl.this.lineProbeWasMoved();
                }
            }
        });
        this.probe.setPointSize(this.getDisplayScale());
        this.probe.setAutoSize(true);
        this.addDisplayable((Displayable)this.probe, 4);
        this.addDisplayable((Displayable)this.gridLocs, 4);
        this.dataNode = SoundingDataNode.getInstance(new Listener());
        this.dataNode.setData(this.getData(this.getDataInstance()));
        return true;
    }

    @Override
    public void initDone() {
        try {
            Misc.runInABit(10L, new Runnable(){

                @Override
                public void run() {
                    GriddedSoundingControl.this.lineProbeWasMoved();
                }
            });
        }
        catch (Exception ex) {
            GriddedSoundingControl.logException(ex);
        }
        super.initDone();
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        super.doRemove();
        this.gridLocs = null;
        this.dataNode = null;
        this.probe = null;
        this.widget = null;
    }

    private void resetProbePosition() {
        try {
            if (this.probe != null) {
                this.probe.setPosition(0.0, 0.0);
            }
        }
        catch (Exception exc) {
            GriddedSoundingControl.logException("Resetting probe position", exc);
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (this.probe != null) {
            JMenuItem mi = new JMenuItem("Reset Probe Position");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GriddedSoundingControl.this.resetProbePosition();
                }
            });
            items.add(mi);
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            super.timeChanged(time);
            if (time != null) {
                this.dataNode.setTime(new DateTime(time));
            }
            if (this.getProfilesVisibility()) {
                AnimationWidget aniWidget = this.getAnimationWidget();
                int idx = 0;
                if (aniWidget.getTimes() != null) {
                    int n = aniWidget.getTimes().length;
                    for (int i = 0; i < n; ++i) {
                        if (!new DateTime(time).equals(aniWidget.getTimeAtIndex(i))) continue;
                        idx = i;
                    }
                }
                this.aeroDisplay.setProfilesVisibility(true, idx);
                Set s = this.getDataTimeSet();
                if (s != null) {
                    double[][] samples = s.getDoubles();
                    DateTime dt = new DateTime(samples[0][idx + 1], s.getSetUnits()[0]);
                    DateTime dt1 = new DateTime(samples[0][idx], s.getSetUnits()[0]);
                    this.listlabel = dt1.dateString() + ":" + dt1.timeString() + " and " + dt.dateString() + ":" + dt.timeString();
                }
                this.updateDisplayList();
                this.updateHeaderLabel();
            }
        }
        catch (Exception ex) {
            GriddedSoundingControl.logException("timeValueChanged", ex);
        }
    }

    @Override
    protected String getSpatialLociLabel() {
        return "Grid points";
    }

    @Override
    Component getSpecificWidget() {
        return this.widget;
    }

    private void lineProbeWasMoved() {
        try {
            this.probeMoved(this.getPosition());
            this.doShare((Object)"DisplayControlImpl.SHARE_POSITION", this.getPosition());
        }
        catch (Exception e) {
            GriddedSoundingControl.logException("lineProbeWasMoved", e);
        }
    }

    public void setPosition(RealTuple p) throws VisADException, RemoteException {
        this.probe.setPosition(p);
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.probe != null ? this.probe.getPosition() : null;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (!dataId.equals("DisplayControlImpl.SHARE_POSITION")) {
            super.receiveShareData(from, dataId, data);
        } else {
            if (this.probe == null) {
                return;
            }
            try {
                this.probe.setPosition((RealTuple)data[0]);
            }
            catch (Exception ex) {
                GriddedSoundingControl.logException("receiveShareData:" + dataId, ex);
            }
        }
    }

    public void probeMoved(RealTuple pos) {
        if (!this.getHaveInitialized()) {
            return;
        }
        try {
            LatLonPoint llp = null;
            RealTupleType rttype = (RealTupleType)pos.getType();
            if (rttype.equals(RealTupleType.SpatialCartesian2DTuple) || rttype.equals(RealTupleType.SpatialCartesian3DTuple)) {
                llp = this.latLon(pos);
            } else if (rttype.equals(RealTupleType.SpatialEarth2DTuple) || rttype.equals(RealTupleType.SpatialEarth3DTuple)) {
                Real[] reals = pos.getRealComponents();
                llp = new LatLonTuple(reals[1], reals[0]);
            } else if (rttype.equals(RealTupleType.LatitudeLongitudeTuple) || rttype.equals(RealTupleType.LatitudeLongitudeAltitude)) {
                Real[] reals = pos.getRealComponents();
                llp = new LatLonTuple(reals[0], reals[1]);
            } else {
                throw new IllegalArgumentException("Can't convert position to navigable point");
            }
            if (llp != null) {
                this.dataNode.setLocation(llp);
            }
        }
        catch (Exception ex) {
            GriddedSoundingControl.logException("probeMoved", ex);
        }
    }

    @Override
    protected Set getDataTimeSet() throws RemoteException, VisADException {
        FieldImpl data;
        Set aniSet = null;
        if (this.dataNode != null && (data = (FieldImpl)this.getData(this.getDataInstance())) != null) {
            aniSet = GridUtil.getTimeSet(data);
        }
        return aniSet;
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%position%"));
        labels.addAll(Misc.newList("Probe Position"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        if (this.getLocation() != null) {
            patterns.add("%position%");
            values.add(this.getDisplayConventions().formatLatLonPoint(this.getLocation()));
        }
    }

    @Override
    protected void updateHeaderLabel() {
        Data d = this.getDisplayListData();
        if (d == null) {
            super.updateHeaderLabel();
        }
        Text text = null;
        if (d instanceof FieldImpl) {
            int index = this.getCurrentIndex();
            if (index >= 0) {
                try {
                    text = (Text)((FieldImpl)d).getSample(index, false);
                }
                catch (Exception exception) {}
            }
        } else {
            text = (Text)d;
        }
        if (text != null) {
            this.headerLabel.setText(text.toString());
        } else {
            super.updateHeaderLabel();
        }
    }

    @Override
    protected Data getDisplayListData() {
        Text data = null;
        Data d = super.getDisplayListData();
        TextType tt = TextType.getTextType("Display_List_Text");
        if (this.listlabel != null) {
            try {
                String label = "Skew-T ";
                data = new Text(tt, label + this.listlabel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        return d;
    }

    public Set subSetProfilesTimeSet(Set tset) throws Exception {
        List timeList = Util.toList(tset);
        int size = timeList.size();
        ArrayList<DateTime> subList = new ArrayList<DateTime>();
        for (int i = 0; i < size - 1; ++i) {
            Real r = (Real)timeList.get(i);
            DateTime dt = new DateTime(r);
            subList.add(dt);
        }
        return Util.makeTimeSet(subList);
    }

    public void setPairProfilesVisibility(boolean visible) throws Exception {
        Set timeset;
        this.profilesVisibility = visible;
        Set s = this.getDataTimeSet();
        int len = s.getLength();
        if (len < 2) {
            return;
        }
        AnimationWidget aniWidget = this.getAnimationWidget();
        aniWidget.gotoIndex(0);
        aniWidget.setRunning(false);
        if (visible) {
            timeset = this.subSetProfilesTimeSet(s);
            this.dataNode.setOutputTimes((SampledSet)timeset);
        } else {
            timeset = this.getDataTimeSet();
            this.dataNode.setOutputTimes((SampledSet)timeset);
        }
        this.aeroDisplay.setProfilesVisibility(visible, 0);
        if (visible) {
            if (s != null) {
                double[][] samples = s.getDoubles();
                DateTime dt = new DateTime(samples[0][1], s.getSetUnits()[0]);
                DateTime dt1 = new DateTime(samples[0][0], s.getSetUnits()[0]);
                this.listlabel = dt1.dateString() + ":" + dt1.timeString() + " and " + dt.dateString() + ":" + dt.timeString();
            }
        } else {
            this.listlabel = null;
        }
        this.updateDisplayList();
        this.updateHeaderLabel();
    }

    public boolean getProfilesVisibility() {
        return this.profilesVisibility;
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        double latRatio = 0.5;
        double lonRatio = 0.5;
        EarthLocationTuple el = null;
        double deltaLat = newBounds.getLatMax() - newBounds.getLatMin();
        double deltaLon = newBounds.getLonMax() - newBounds.getLonMin();
        LatLonPointImpl lowerLeft = newBounds.getLowerLeftPoint();
        double nlat = lowerLeft.getLatitude() + deltaLat * latRatio;
        double nlon = lowerLeft.getLongitude() + deltaLon * lonRatio;
        double nalt = 0.0;
        if (originalBounds == null) {
            GeoSelection gs = this.dataSelection.getGeoSelection();
            GeoLocationInfo ginfo = new GeoLocationInfo(newBounds);
            gs.setBoundingBox(ginfo);
            try {
                this.updateDataSelection(this.dataSelection);
                this.getDataInstance().setDataSelection(this.dataSelection);
                this.getDataInstance().reInitialize();
                this.dataNode.setData(this.getData(this.getDataInstance()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (el != null) {
                nalt = el.getAltitude().getValue();
            }
            if (nlon < 0.0) {
                nlon = GeoUtils.normalizeLongitude360(nlon);
            }
            EarthLocation newel = GriddedSoundingControl.makeEarthLocation(nlat, nlon, nalt);
            double[] ets = this.earthToBox(newel);
            this.setPosition(new RealTuple(new Real[]{new Real(RealType.XAxis, ets[0]), new Real(RealType.YAxis, ets[1])}));
            this.probeMoved(this.getPosition());
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }

    @Override
    public void viewpointChanged() {
        if (this.getMatchDisplayRegion() && this.reloadFromBounds) {
            try {
                NavigatedDisplay navDisplay = this.getMapDisplay();
                LatLonRect baseLLR = this.dataSelection.getGeoSelection().getLatLonRect();
                this.getViewManager().setProjectionFromData(false);
                Rectangle2D.Double bbox = navDisplay.getLatLonBox();
                LatLonPointImpl p1 = new LatLonPointImpl(((RectangularShape)bbox).getY(), ((RectangularShape)bbox).getX());
                LatLonRect newLLR = new LatLonRect(p1, ((RectangularShape)bbox).getHeight(), ((RectangularShape)bbox).getWidth());
                this.relocateDisplay(baseLLR, newLLR, false);
                this.reloadFromBounds = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }

    @Override
    public boolean hasMapProjection() {
        return true;
    }

    private class Listener
    implements SoundingDataNode.Listener {
        private Listener() throws VisADException, RemoteException {
        }

        @Override
        public void setTimeIndex(int index, SoundingDataNode source) throws VisADException, RemoteException {
            GriddedSoundingControl.this.setSounding(index);
        }

        @Override
        public void setTimes(SampledSet times, SoundingDataNode source) throws VisADException, RemoteException {
            RealType timeType = (RealType)((SetType)times.getType()).getDomain().getComponent(0);
            if (GriddedSoundingControl.this.timesHolder == null) {
                GriddedSoundingControl.this.timesHolder = new LineDrawing("times ref");
            }
            FieldImpl dummy = new FieldImpl(new FunctionType(timeType, AirTemperatureProfile.instance()), times);
            int n = times.getLength();
            for (int i = 0; i < n; ++i) {
                dummy.setSample(i, AirTemperatureProfile.instance().missingData());
            }
            GriddedSoundingControl.this.timesHolder.setData(dummy);
            if (GriddedSoundingControl.this.widget == null) {
                if (times.getLength() == 1) {
                    DateTime time = new DateTime(new Real(timeType, times.indexToDouble(new int[]{0})[0][0], times.getSetUnits()[0]));
                    GriddedSoundingControl.this.widget = GuiUtils.wrap(new JLabel(time.toString()));
                    GriddedSoundingControl.this.dataNode.setTime(time);
                    GriddedSoundingControl.this.setSounding(0);
                } else {
                    Animation animation = GriddedSoundingControl.this.getInternalAnimation(timeType);
                    GriddedSoundingControl.this.getSoundingView().setExternalAnimation(animation, GriddedSoundingControl.this.getAnimationWidget());
                    GriddedSoundingControl.this.aeroDisplay.addDisplayable(animation);
                    GriddedSoundingControl.this.aeroDisplay.addDisplayable(GriddedSoundingControl.this.timesHolder);
                    Box container = Box.createHorizontalBox();
                    container.add(GuiUtils.wrap(GriddedSoundingControl.this.getAnimationWidget().getContents(false)));
                    GriddedSoundingControl.this.widget = container;
                }
            }
        }

        @Override
        public void setLocation(LatLonPoint loc, SoundingDataNode source) throws VisADException, RemoteException {
            GriddedSoundingControl.this.setLocation(loc);
        }

        @Override
        public void setLocations(SampledSet locs, SoundingDataNode source) throws VisADException, RemoteException {
            GriddedSoundingControl.this.gridLocs.setData(locs);
        }

        @Override
        public void setProfiles(Field[] tempPros, Field[] dewPros, Field[] windPros, SoundingDataNode source) throws VisADException, RemoteException {
            GriddedSoundingControl.this.setSoundings(tempPros, dewPros, windPros);
        }
    }
}

