/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataTimeRange;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.gis.MapMaker;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.FlowDisplayControl;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.idv.control.drawing.DrawingCommand;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.drawing.SymbolGlyph;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.GeoUtils;
import ucar.visad.Util;
import ucar.visad.display.ColorScaleInfo;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.FieldImpl;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Linear3DSet;
import visad.Real;
import visad.RealTupleType;
import visad.SampledSet;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class GridTrajectoryControlNew
extends DrawingControl {
    protected JCheckBox enabledCbx;
    private String editorTitle = null;
    public static final DrawingCommand CMD_REMOVE = new DrawingCommand("Remove graphic", "remove all shape graphics", "/auxdata/ui/icons/Reshape16.gif");
    public static final String CMD_SETLEVELS = "cmd.setlevels";
    public static final String CMD_createTrj = "cmd.createTrj";
    DataChoice dataChoice;
    private JComboBox levelBox;
    private JComboBox levelxBox;
    private JComboBox levelyBox;
    private JLabel levelLabel;
    protected Object currentLevel;
    protected Object currentLevelx;
    protected Object currentLevely;
    protected Object bundleLevel = null;
    protected Object bundleLevelx = null;
    protected Object bundleLevely = null;
    protected Object[] currentLevels;
    private boolean levelEnabled = false;
    private Unit newZunit = CommonUnit.meter;
    private static final Data DUMMY_DATA = new Real(0.0);
    private Object MUTEX = new Object();
    CoordinateSystem pressToHeightCS;
    private JRadioButton pointsBtn;
    private JRadioButton hiddenBtn;
    private JRadioButton rectangleBtn;
    private JRadioButton closePolygonBtn;
    boolean isPoints = false;
    boolean isRectangle = false;
    boolean isSelector = true;
    boolean isClosePlgn = false;
    private JButton createTrjBtn;
    boolean createTrjBtnClicked = false;
    JPanel controlPane;
    private MyTrajectoryControl gridTrackControl;
    int trackLineWidth = 1;
    boolean trackArrowHead = false;
    Integer trackFormType = new Integer(0);
    float trackOffsetValue = 4.0f;
    int tracerType = 7;
    int smoothFactorValue = 10;
    Color trackColor = Color.red;
    private DataTimeRange trjDataTimeRange;
    ColorTable trjColorTable;
    Range trjColorRange;
    Range bundleColorRange = null;
    boolean is2DDC = false;
    ValueSliderWidget skipFactorWidget;
    int coordinateType = 2;
    Unit newUnit = null;
    boolean isBundle = false;
    private JCheckBox backwardCbx;
    private boolean backwardTrajectory = false;
    protected DataSelection dataSelection1;
    protected GridDataInstance gridDataInstance;
    private boolean useSpeedForColor = false;
    private boolean isStreamline = false;
    private boolean coloredByAnother = false;
    private boolean withTopo = false;
    private boolean is2D = false;
    private JRadioButton XYBtn;
    private JRadioButton YZBtn;
    private JRadioButton XZBtn;
    boolean isXY = false;
    boolean isYZ = false;
    boolean isXZ = false;

    public GridTrajectoryControlNew() {
        this.setLineWidth(2);
        this.reallySetAttributeFlags(33);
    }

    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }

    public boolean getColoredByAnother() {
        return this.coloredByAnother;
    }

    public void setUseSpeedForColor(boolean yesno) {
        this.useSpeedForColor = yesno;
    }

    public boolean getUseSpeedForColor() {
        return this.useSpeedForColor;
    }

    public void setIsStreamline(boolean yesno) {
        this.isStreamline = yesno;
    }

    public boolean getIsStreamline() {
        return this.isStreamline;
    }

    public void setWithTopo(boolean yesno) {
        this.withTopo = yesno;
    }

    public boolean getWithTopo() {
        return this.withTopo;
    }

    public void setIs2D(boolean yesno) {
        this.is2D = yesno;
    }

    public boolean getIs2D() {
        return this.is2D;
    }

    public boolean getIsXY() {
        return this.isXY;
    }

    public void setIsXY(boolean isxy) {
        this.isXY = isxy;
    }

    public boolean getIsXZ() {
        return this.isXZ;
    }

    public void setIsXZ(boolean isxz) {
        this.isXZ = isxz;
    }

    public boolean getIsYZ() {
        return this.isYZ;
    }

    public void setIsYZ(boolean isyz) {
        this.isYZ = isyz;
    }

    @Override
    protected void timeChanged(Real time) {
        this.gridTrackControl.timeChanged(time);
    }

    public int getTrackLineWidth() {
        return this.trackLineWidth;
    }

    public void setTrackLineWidth(int width) {
        this.trackLineWidth = width;
    }

    public DataTimeRange getTrjDataTimeRange() {
        return this.trjDataTimeRange;
    }

    public void setTrjDataTimeRange(DataTimeRange range) {
        if (range != null) {
            this.trjDataTimeRange = range;
            if (this.gridTrackControl != null) {
                this.gridTrackControl.setDataTimeRange(range);
            }
            super.setDataTimeRange(range);
        }
    }

    public Range getTrjColorRange() {
        return this.trjColorRange;
    }

    public void setTrjColorRange(Range crange) {
        this.trjColorRange = crange;
        if (crange != null) {
            this.trjColorRange = crange;
            if (this.gridTrackControl != null) {
                try {
                    this.gridTrackControl.setRange(crange);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                super.setRange(crange);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ColorTable getTrjColorTable() {
        return this.trjColorTable;
    }

    public void setTrjColorTable(ColorTable ctable) {
        if (ctable != null) {
            this.trjColorTable = ctable;
            if (this.gridTrackControl != null) {
                try {
                    this.gridTrackControl.setColorTable(ctable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                super.setColorTable(ctable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        MapViewManager mvm;
        this.isBundle = this.getIdv().getStateManager().isLoadingXml();
        super.init((DataChoice)null);
        this.gridTrackControl = new MyTrajectoryControl(this);
        this.dataSelection1 = this.getDataSelection();
        dataChoice.setDataSelection(this.dataSelection1);
        this.dataChoice = dataChoice;
        this.gridTrackControl.controlContext = this.getControlContext();
        this.gridTrackControl.setUsesTimeDriver(this.getUsesTimeDriver());
        this.gridTrackControl.updateDataSelection(this.dataSelection1);
        this.gridTrackControl.init(dataChoice);
        Object fromLevel = this.dataSelection1.getFromLevel();
        this.dataSelection1.setLevel(null);
        this.gridTrackControl.controlContext = this.getControlContext();
        this.initDisplayUnit();
        this.levelBox = this.gridTrackControl.doMakeLevelControl(null);
        this.levelBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals(GridTrajectoryControlNew.CMD_SETLEVELS)) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)event.getSource()).getSelectedItem();
                    GridTrajectoryControlNew.this.setLevel(select);
                }
            }
        });
        this.levelxBox = this.doMakeLevelControl(0, "cmd.setLevelsX");
        this.levelxBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals("cmd.setLevelsX")) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)event.getSource()).getSelectedItem();
                    GridTrajectoryControlNew.this.setLevelx(select);
                }
            }
        });
        this.levelyBox = this.doMakeLevelControl(0, "cmd.setLevelsY");
        this.levelyBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals("cmd.setLevelsY")) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)event.getSource()).getSelectedItem();
                    GridTrajectoryControlNew.this.setLevely(select);
                }
            }
        });
        this.levelLabel = GuiUtils.rLabel(this.getLevelsLabel());
        this.levelLabel.setDisplayedMnemonic(GuiUtils.charToKeyCode("L"));
        this.levelLabel.setLabelFor(this.levelBox);
        DataSelection tmpSelection = new DataSelection(0);
        Object[] levels = this.gridTrackControl.getGridDataInstance().getLevels();
        Gridded3DSet g3dset = this.gridTrackControl.getGridDataInstance().getDomainSet3D();
        SampledSet sampleset = this.gridTrackControl.getGridDataInstance().getSpatialDomain();
        Gridded2DSet g2dset = null;
        if (this.currentLevel == null) {
            this.currentLevel = fromLevel;
        }
        if (levels != null && levels.length > 0 && this.currentLevel == null) {
            this.currentLevel = levels[levels.length - 1];
        }
        if (levels != null) {
            int len = levels.length;
            fromLevel = levels[0].getValue() < levels[len - 1].getValue() ? levels[len - 1] : levels[0];
        } else if (sampleset != null && sampleset.getManifoldDimension() == 2) {
            g2dset = GridUtil.makeDomain2D((GriddedSet)sampleset);
        }
        MapProjection mapProjection = this.getDataProjectionForMenu();
        if (mapProjection != null && (mvm = this.getMapViewManager()) != null) {
            mvm.setMapProjection(mapProjection, true, this.getDisplayConventions().getMapProjectionLabel(mapProjection, this), true);
        }
        if (levels != null) {
            this.setLevels(levels, fromLevel);
            if (g3dset instanceof Linear3DSet) {
                this.setLevelsX(((Linear3DSet)g3dset).getX().getLength());
                this.setLevelsY(((Linear3DSet)g3dset).getY().getLength());
            } else {
                this.setLevelsX(g3dset.getLength(0));
                this.setLevelsY(g3dset.getLength(1));
            }
        } else if (g2dset != null) {
            if (fromLevel != null) {
                this.setLevels(new Object[]{fromLevel}, fromLevel);
            }
            this.setLevelsX(g2dset.getLength(0));
            this.setLevelsY(g2dset.getLength(1));
        }
        this.setDisplayActive();
        if (this.gridTrackControl.myDisplay == null) {
            this.gridTrackControl.myDisplay = (FlowDisplayable)this.gridTrackControl.createPlanDisplay();
        }
        this.setLineWidth(this.gridTrackControl.getLineWidth());
        this.addDisplayable((Displayable)this.gridTrackControl.myDisplay, this.getAttributeFlags());
        this.getViewAnimation();
        this.gridTrackControl.addDisplayable((Displayable)this.gridTrackControl.myDisplay, this.getAttributeFlags());
        this.createTrjBtn = this.isStreamline ? new JButton("Create Streamline") : new JButton("Create Trajectory");
        this.createTrjBtn.addActionListener(this);
        this.createTrjBtn.setActionCommand(CMD_createTrj);
        this.createTrjBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String cmd = actionEvent.getActionCommand();
                if (cmd.equals(GridTrajectoryControlNew.CMD_createTrj)) {
                    try {
                        GridTrajectoryControlNew.this.createTrjBtnClicked = true;
                        GridTrajectoryControlNew.this.removeGC();
                        GridTrajectoryControlNew.this.createTrajectory();
                    }
                    catch (Exception exr) {
                        DisplayControlBase.logException("Click create trajectory button", exr);
                    }
                }
            }
        });
        this.controlPane = new JPanel();
        this.controlPane.setPreferredSize(new Dimension(500, 350));
        if (!this.isBundle) {
            this.isXY = true;
        }
        return true;
    }

    public boolean reInit(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init((DataChoice)null);
        this.gridTrackControl = new MyTrajectoryControl(this);
        this.dataSelection1 = this.getDataSelection();
        dataChoice.setDataSelection(this.dataSelection1);
        this.dataChoice = dataChoice;
        this.gridTrackControl.controlContext = this.getControlContext();
        this.gridTrackControl.setUsesTimeDriver(this.getUsesTimeDriver());
        this.gridTrackControl.updateDataSelection(this.dataSelection1);
        this.gridTrackControl.init(dataChoice);
        this.gridTrackControl.controlContext = this.getControlContext();
        this.initDisplayUnit();
        this.setDisplayActive();
        this.addDisplayable((Displayable)this.gridTrackControl.myDisplay, this.getAttributeFlags());
        this.gridTrackControl.addDisplayable((Displayable)this.gridTrackControl.myDisplay, this.getAttributeFlags());
        return true;
    }

    @Override
    public void initDone() {
        MapViewManager mvm;
        super.initDone();
        MapProjection mapProjection = this.gridTrackControl.getDataProjection();
        if (mapProjection != null && (mvm = this.getMapViewManager()) != null) {
            mvm.setMapProjection(mapProjection, true, this.getDisplayConventions().getMapProjectionLabel(mapProjection, this), true);
        }
    }

    public JComboBox doMakeLevelControl(int len, String cmd) {
        JComboBox<Object> box;
        if (len > 0) {
            Object[] tfoList = new Object[len];
            for (int i = 0; i < len; ++i) {
                tfoList[i] = this.getLabeledReal(i);
            }
            box = new JComboBox<Object>(this.formatLevels(tfoList));
        } else {
            box = new JComboBox();
        }
        box.addActionListener(this);
        box.setEditable(true);
        box.setActionCommand(cmd);
        return box;
    }

    public void setLevelsX(int xlen) {
        this.setOkToFireEvents(false);
        if (this.levelxBox == null) {
            return;
        }
        this.levelxBox.setEnabled(false);
        Object[] tfoList = new Object[xlen];
        for (int i = 0; i < xlen; ++i) {
            tfoList[i] = this.getLabeledReal(new Real(i));
        }
        GuiUtils.setListData(this.levelxBox, tfoList);
        Object currentLevelX = tfoList[0];
        this.levelxBox.setSelectedItem(this.getLabeledReal(currentLevelX));
        this.setOkToFireEvents(true);
        this.levelxBox.setEnabled(true);
    }

    public void setLevelsY(int ylen) {
        this.setOkToFireEvents(false);
        if (this.levelyBox == null) {
            return;
        }
        this.levelyBox.setEnabled(false);
        Object[] tfoList = new Object[ylen];
        for (int i = 0; i < ylen; ++i) {
            tfoList[i] = this.getLabeledReal(new Real(i));
        }
        GuiUtils.setListData(this.levelyBox, tfoList);
        Object currentLevelX = tfoList[0];
        this.levelyBox.setSelectedItem(this.getLabeledReal(currentLevelX));
        this.setOkToFireEvents(true);
        this.levelyBox.setEnabled(true);
    }

    @Override
    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
        this.gridTrackControl.displayUnitChanged(oldUnit, newUnit);
        this.gridTrackControl.setNewDisplayUnit(newUnit, true);
        try {
            this.gridTrackControl.setSelectRange(this.gridTrackControl.getColorRangeFromData());
        }
        catch (Exception exc) {
            GridTrajectoryControlNew.logException("change unit", exc);
        }
        this.setDisplayUnit(newUnit);
    }

    public void createTrajectory() {
        Misc.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = GridTrajectoryControlNew.this.MUTEX;
                    synchronized (object) {
                        GridTrajectoryControlNew.this.showWaitCursor();
                        GridTrajectoryControlNew.this.createTrajectoryControl();
                    }
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Calculationing the grid trajectory", exc);
                }
                finally {
                    GridTrajectoryControlNew.this.showNormalCursor();
                }
            }
        });
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        if (this.is2D && this.getCurrentLevel() != null) {
            this.dataSelection = this.getDataSelection();
            this.dataSelection.setFromLevel(this.currentLevel);
            this.dataSelection.setToLevel(this.currentLevel);
        }
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
        if (!this.getIdv().getInteractiveMode()) {
            try {
                this.doMakeContents();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.createTrjBtnClicked) {
            this.currentLevel = this.getCurrentLevel();
            if (this.currentLevel != null && this.bundleLevel != null && !this.currentLevel.equals(this.bundleLevel)) {
                this.setLevel(this.bundleLevel);
                this.levelBox.setSelectedItem(this.bundleLevel);
            }
            if (this.currentLevelx != null && this.bundleLevelx != null && !this.currentLevelx.equals(this.bundleLevelx)) {
                this.setLevelx(this.bundleLevelx);
                this.levelxBox.setSelectedItem(this.bundleLevelx);
            }
            if (this.currentLevely != null && this.bundleLevely != null && !this.currentLevely.equals(this.bundleLevely)) {
                this.setLevely(this.bundleLevely);
                this.levelyBox.setSelectedItem(this.bundleLevely);
            }
            if (this.backwardTrajectory) {
                this.backwardCbx.doClick();
            }
            this.newUnit = this.getDisplayUnit();
            this.gridTrackControl.initAfterUnPersistence(vc, properties);
            double[] oldVM = this.gridTrackControl.getViewManager().getDisplayInitMatrix();
            this.createTrjBtn.doClick();
            this.gridTrackControl.getDataTimeRange(true).getTimeModeLabel();
            try {
                this.gridTrackControl.setLineWidth(this.getTrackLineWidth());
                this.gridTrackControl.setTrajOffset(this.getTrackOffsetValue());
                this.gridTrackControl.setColor(this.getTrackColor());
                this.gridTrackControl.setSmoothFactor(this.getSmoothFactorValue());
                this.gridTrackControl.setArrowHead(this.getTrackArrowHead());
                this.gridTrackControl.setColorTable(this.getTrjColorTable());
                this.doMakeColorScales();
                this.bundleColorRange = this.getTrjColorRange();
                this.gridTrackControl.getViewManager().setDisplayMatrix(oldVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLevels(Object[] levels, Object initLevel) {
        this.setOkToFireEvents(false);
        this.currentLevels = levels;
        boolean bl = this.levelEnabled = levels != null;
        if (this.levelBox == null) {
            return;
        }
        this.levelBox.setEnabled(this.levelEnabled);
        this.levelLabel.setEnabled(this.levelEnabled);
        GuiUtils.setListData(this.levelBox, this.formatLevels(levels));
        if (initLevel != null) {
            if (initLevel instanceof Real) {
                TwoFacedObject clevel = Util.labeledReal((Real)initLevel);
                this.levelBox.setSelectedItem(clevel);
            } else {
                this.levelBox.setSelectedItem(initLevel);
            }
        }
        this.setOkToFireEvents(true);
    }

    public void setLevel(Object r) {
        this.currentLevel = r;
    }

    public void setLevelx(Object r) {
        this.currentLevelx = r;
    }

    public void setLevely(Object r) {
        this.currentLevely = r;
    }

    private void moveUpDown(int delta) {
        int max;
        int selected = this.levelBox.getSelectedIndex();
        if (selected >= 0 && (selected += delta) >= (max = this.levelBox.getItemCount())) {
            selected = max - 1;
        }
        if (selected < 0) {
            selected = 0;
        }
        this.levelBox.setSelectedIndex(selected);
        if (selected >= 0) {
            int ct = this.levelBox.getItemCount();
            Object levelObj = this.levelBox.getSelectedItem();
            if (levelObj.toString().equals("All Levels")) {
                this.gridTrackControl.setTrajStartLevel(levelObj, selected);
            } else {
                this.gridTrackControl.setTrajStartLevel(levelObj, selected);
            }
        }
    }

    public String getLevelsLabel() {
        if (this.isStreamline) {
            return "Streamline Start Surface:";
        }
        return "Trajectory Start Surface:";
    }

    @Override
    protected void initDisplayUnit() {
        if (this.getDisplayUnit() == null) {
            this.setDisplayUnit(this.getDefaultDistanceUnit());
        }
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.clearCursor();
        if (this.glyphs != null) {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                ((DrawingGlyph)this.glyphs.get(i)).setBeenRemoved(true);
            }
        }
        this.glyphs = null;
        this.selectedGlyphs = null;
        this.displayHolder = null;
        super.doRemove();
    }

    @Override
    protected void getLegendLabels(List labels, int legendType) {
        if (this.editorTitle != null && this.editorTitle.length() > 0) {
            labels.add(this.editorTitle);
        } else {
            super.getLegendLabels(labels, legendType);
        }
    }

    @Override
    public void removeGlyph(DrawingGlyph glyph) {
        glyph.setBeenRemoved(true);
        this.glyphs.remove(glyph);
        this.selectedGlyphs.remove(glyph);
        try {
            this.displayHolder.removeDisplayable(glyph.getDisplayable());
        }
        catch (Exception exc) {
            GridTrajectoryControlNew.logException("Removing glyph", exc);
        }
    }

    protected String getColorParamName() {
        return this.paramName;
    }

    void createTrajectoryControl() throws VisADException, RemoteException, Exception {
        GriddedSet domainSet = (GriddedSet)this.gridTrackControl.getGridDataInstance().getSpatialDomain();
        CoordinateSystem cs = this.getNavigatedDisplay().getDisplayCoordinateSystem();
        MapProjectionDisplay mpd = (MapProjectionDisplay)this.getNavigatedDisplay();
        Object slevel = this.levelBox.getSelectedItem();
        int idx = this.levelBox.getSelectedIndex();
        this.gridTrackControl.loadVolumeData();
        if (this.isXY) {
            int ct = this.levelBox.getSelectedIndex();
            this.gridTrackControl.myDisplay.setTrajStartLevel(idx);
            this.gridTrackControl.myDisplay.setZskip(this.levelBox.getItemCount());
        }
        if ((!this.hiddenBtn.isSelected() || this.isBundle) && this.glyphs.size() > 0 && this.isXY) {
            Gridded2DSet domain2D = GridUtil.makeDomain2D(domainSet);
            boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
            int latIndex = isLatLon ? 0 : 1;
            int lonIndex = isLatLon ? 1 : 0;
            Real alt = null;
            alt = this.currentLevel != null ? GridUtil.getAltitude(domainSet, (Real)((TwoFacedObject)this.currentLevel).getId()) : new Real(0.0);
            float[][] geoVals = this.getEarthLocationPoints(latIndex, lonIndex, domain2D, alt, this.getSkipValue());
            float[][] setLocs = cs.toReference(geoVals);
            setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
            RealTupleType types = cs.getReference();
            this.gridTrackControl.myDisplay.setStartPoints(types, setLocs);
        } else if (this.isYZ) {
            float[][] domainLatLonAlt = GridUtil.getEarthLocationPoints(domainSet);
            boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
            int latIndex = isLatLon ? 1 : 0;
            int lonIndex = isLatLon ? 0 : 1;
            int numX = domainSet.getLengths()[0];
            int numY = domainSet.getLengths()[1];
            int numXY = numX * numY;
            int numP = this.is2D ? numY : numY * domainSet.getLengths()[2];
            float[][] geoVals = new float[3][numP];
            int xIndex = this.levelxBox.getSelectedIndex();
            if (this.is2D) {
                for (int j = 0; j < numY; ++j) {
                    int ii = j * (numX - 1) + j + xIndex;
                    geoVals[0][j] = domainLatLonAlt[lonIndex][ii];
                    geoVals[1][j] = domainLatLonAlt[latIndex][ii];
                    geoVals[2][j] = domainLatLonAlt[2][ii];
                }
            } else {
                for (int k = 0; k < domainSet.getLengths()[2]; ++k) {
                    for (int j = 0; j < numY; ++j) {
                        int ii = k * numXY + j * (numX - 1) + j + xIndex;
                        int jj = k * numY + j;
                        geoVals[0][jj] = domainLatLonAlt[lonIndex][ii];
                        geoVals[1][jj] = domainLatLonAlt[latIndex][ii];
                        geoVals[2][jj] = domainLatLonAlt[2][ii];
                    }
                }
            }
            if (this.getSkipValue() > 0) {
                int skipFactor = this.getSkipValue();
                int onum = numP / (skipFactor + 1) + 1;
                float[][] points0 = new float[3][onum];
                int i = 0;
                int j = 0;
                while (i < onum && j < numP) {
                    points0[0][i] = geoVals[0][j];
                    points0[1][i] = geoVals[1][j];
                    points0[2][i] = geoVals[2][j];
                    j = ++i * (skipFactor + 1);
                }
                this.setCurrentCommand(CMD_SELECT);
                this.hiddenBtn.doClick();
                float[][] setLocs = cs.toReference(points0);
                setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                RealTupleType types = cs.getReference();
                this.gridTrackControl.myDisplay.setStartPoints(types, setLocs);
            } else {
                float[][] setLocs = cs.toReference(geoVals);
                setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                RealTupleType types = cs.getReference();
                this.gridTrackControl.myDisplay.setStartPoints(types, setLocs);
            }
        } else if (this.isXZ) {
            float[][] domainLatLonAlt = GridUtil.getEarthLocationPoints(domainSet);
            boolean isLatLon = GridUtil.isLatLonOrder(domainSet);
            int latIndex = isLatLon ? 1 : 0;
            int lonIndex = isLatLon ? 0 : 1;
            int numX = domainSet.getLengths()[0];
            int numY = domainSet.getLengths()[1];
            int numXY = numX * numY;
            int numP = this.is2D ? numX : numX * domainSet.getLengths()[2];
            float[][] geoVals = new float[3][numP];
            int yIndex = this.levelyBox.getSelectedIndex();
            if (this.is2D) {
                for (int j = 0; j < numX; ++j) {
                    int ii = j + numX * yIndex;
                    geoVals[0][j] = domainLatLonAlt[lonIndex][ii];
                    geoVals[1][j] = domainLatLonAlt[latIndex][ii];
                    geoVals[2][j] = domainLatLonAlt[2][ii];
                }
            } else {
                for (int k = 0; k < domainSet.getLengths()[2]; ++k) {
                    for (int j = 0; j < numX; ++j) {
                        int ii = k * numXY + j + numX * yIndex;
                        int jj = k * numX + j;
                        geoVals[0][jj] = domainLatLonAlt[lonIndex][ii];
                        geoVals[1][jj] = domainLatLonAlt[latIndex][ii];
                        geoVals[2][jj] = domainLatLonAlt[2][ii];
                    }
                }
            }
            if (this.getSkipValue() > 0) {
                int skipFactor = this.getSkipValue();
                int onum = numP / (skipFactor + 1) + 1;
                float[][] points0 = new float[3][onum];
                int i = 0;
                int j = 0;
                while (i < onum && j < numP) {
                    points0[0][i] = geoVals[0][j];
                    points0[1][i] = geoVals[1][j];
                    points0[2][i] = geoVals[2][j];
                    j = ++i * (skipFactor + 1);
                }
                this.setCurrentCommand(CMD_SELECT);
                this.hiddenBtn.doClick();
                float[][] setLocs = cs.toReference(points0);
                setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                RealTupleType types = cs.getReference();
                this.gridTrackControl.myDisplay.setStartPoints(types, setLocs);
            } else {
                float[][] setLocs = cs.toReference(geoVals);
                setLocs[2] = mpd.scaleVerticalValues(setLocs[2]);
                RealTupleType types = cs.getReference();
                this.gridTrackControl.myDisplay.setStartPoints(types, setLocs);
            }
        } else {
            this.gridTrackControl.myDisplay.setStartPoints(null, null);
        }
        if (this.withTopo) {
            this.gridTrackControl.myDisplay.loadTopoData((FieldImpl)this.gridTrackControl.topoData);
        }
        this.gridTrackControl.myDisplay.setForward(!this.backwardCbx.isSelected());
        this.gridTrackControl.myDisplay.setArrowHead(this.gridTrackControl.getArrowHead());
        Range range = this.gridTrackControl.getGridDataInstance().getRange(this.gridTrackControl.getColorRangeIndex());
        this.gridTrackControl.myDisplay.resetTrojectories();
        this.controlPane.setVisible(true);
        this.controlPane.add(this.gridTrackControl.doMakeContents());
    }

    public float[][] getEarthLocationPoints(int latIndex, int lonIndex, SampledSet domain0, Real alt, int skipFactor) throws Exception {
        double clevel = 0.0;
        if (this.currentLevel instanceof Real) {
            clevel = ((Real)this.currentLevel).getValue();
        } else if (this.currentLevel instanceof TwoFacedObject) {
            Object oj = ((TwoFacedObject)this.currentLevel).getId();
            clevel = ((Real)oj).getValue();
        }
        if (this.pressToHeightCS == null) {
            this.pressToHeightCS = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
        }
        float z = this.is2DDC ? (float)clevel : (float)alt.getValue();
        if (this.currentCmd.getLabel().equals(GlyphCreatorCommand.CMD_SYMBOL.getLabel()) || this.glyphs != null && this.glyphs.size() > 0 && this.glyphs.get(0) instanceof SymbolGlyph) {
            int pointNum = this.glyphs.size();
            float[][] points = new float[3][pointNum];
            for (int i = 0; i < pointNum; ++i) {
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                points[0][i] = glyph.getLatLons()[0][0];
                points[1][i] = (float)LatLonPointImpl.lonNormal(glyph.getLatLons()[1][0]);
                points[2][i] = z;
            }
            this.setCurrentCommand(CMD_SELECT);
            this.hiddenBtn.doClick();
            return points;
        }
        if (this.glyphs.size() == 0) {
            return null;
        }
        Unit[] du = domain0.getSetUnits();
        MapMaker mapMaker = new MapMaker();
        for (DrawingGlyph glyph : this.glyphs) {
            float[][] lls = glyph.getLatLons();
            float[][] tmp = glyph.getLatLons();
            if (du[lonIndex].isConvertible(CommonUnit.radian)) {
                lls[1] = GeoUtils.normalizeLongitude(lls[1]);
            } else if (du[lonIndex].isConvertible(CommonUnits.KILOMETER)) {
                for (int i = 0; i < lls[1].length; ++i) {
                    lls[1][i] = (float)LatLonPointImpl.lonNormal(lls[1][i]);
                }
            }
            mapMaker.addMap(lls);
        }
        float[][][] latlons = GridUtil.findContainedLatLons((GriddedSet)domain0, mapMaker.getMaps());
        int num = 0;
        for (int i = 0; i < latlons.length; ++i) {
            num += latlons[i][0].length;
        }
        int onum = num / (skipFactor + 1) + 1;
        float[][] points = new float[3][num];
        int psize = 0;
        for (int k = 0; k < latlons.length; ++k) {
            int isize = latlons[k][0].length;
            for (int i = 0; i < isize; ++i) {
                points[0][i + psize] = latlons[k][0][i];
                points[1][i + psize] = (float)LatLonPointImpl.lonNormal(latlons[k][1][i]);
                points[2][i + psize] = z;
            }
            psize += isize;
        }
        if (skipFactor > 0) {
            float[][] points0 = new float[3][onum];
            int i = 0;
            int j = 0;
            while (i < onum && j < num) {
                points0[0][i] = points[0][j];
                points0[1][i] = points[1][j];
                points0[2][i] = points[2][j];
                j = ++i * (skipFactor + 1);
            }
            this.setCurrentCommand(CMD_SELECT);
            this.hiddenBtn.doClick();
            return points0;
        }
        return points;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.leftCenter(this.doMakeControlsPanel(), new JLabel(""));
    }

    @Override
    protected JComponent doMakeControlsPanel() {
        ArrayList widgets = new ArrayList();
        this.addControlWidgets(widgets);
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        GuiUtils.tmpFill = 2;
        JPanel comps = GuiUtils.doLayout(widgets, 2, GuiUtils.WT_NY, GuiUtils.WT_NN);
        Dimension ds = this.controlPane.getPreferredSize();
        comps.setPreferredSize(ds);
        return GuiUtils.topCenter(comps, this.controlPane);
    }

    @Override
    protected void addControlWidgets(List widgets) {
        JPanel levelSelector = GuiUtils.doLayout(new Component[]{this.levelBox}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel xSelector = GuiUtils.doLayout(new Component[]{this.levelxBox}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel ySelector = GuiUtils.doLayout(new Component[]{this.levelyBox}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        this.XYBtn = new JRadioButton("XY Plane:", this.isXY);
        this.YZBtn = new JRadioButton("YZ Plane:", this.isYZ);
        this.XZBtn = new JRadioButton("XZ Plane:", this.isXZ);
        Insets spacer = new Insets(0, 30, 0, 0);
        JPanel rightComp1 = GuiUtils.vbox(GuiUtils.left(GuiUtils.vbox(this.XYBtn, GuiUtils.inset((Component)levelSelector, spacer))), GuiUtils.left(GuiUtils.vbox(this.YZBtn, GuiUtils.inset((Component)xSelector, spacer))), GuiUtils.left(GuiUtils.vbox(this.XZBtn, GuiUtils.inset((Component)ySelector, spacer))));
        ActionListener listener1 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton source = (JRadioButton)e.getSource();
                if (source == GridTrajectoryControlNew.this.XYBtn) {
                    GridTrajectoryControlNew.this.isXY = true;
                    GridTrajectoryControlNew.this.isYZ = false;
                    GridTrajectoryControlNew.this.isXZ = false;
                    GridTrajectoryControlNew.this.levelBox.setSelectedIndex(GridTrajectoryControlNew.this.levelBox.getItemCount() - 1);
                } else if (source == GridTrajectoryControlNew.this.YZBtn) {
                    GridTrajectoryControlNew.this.isYZ = true;
                    GridTrajectoryControlNew.this.isXZ = false;
                    GridTrajectoryControlNew.this.isXY = false;
                    GridTrajectoryControlNew.this.removeAllGlyphs();
                } else if (source == GridTrajectoryControlNew.this.XZBtn) {
                    GridTrajectoryControlNew.this.isXZ = true;
                    GridTrajectoryControlNew.this.isXY = false;
                    GridTrajectoryControlNew.this.isYZ = false;
                    GridTrajectoryControlNew.this.removeAllGlyphs();
                }
                GridTrajectoryControlNew.this.enableInitAreaWidget();
            }
        };
        this.XYBtn.addActionListener(listener1);
        this.YZBtn.addActionListener(listener1);
        this.XZBtn.addActionListener(listener1);
        GuiUtils.buttonGroup(this.XYBtn, this.YZBtn, this.XZBtn);
        JComponent widgets0 = GuiUtils.formLayout(new Component[]{this.levelLabel, GuiUtils.left(rightComp1)});
        JButton unloadBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Cut16.gif", this, "removeAllGlyphs");
        unloadBtn.setToolTipText("Remove existing glyphs and trajectories");
        this.msgLabel = new JLabel();
        if (this.createTrjBtnClicked) {
            this.isPoints = this.getIsPoints();
            if (this.isPoints) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_SYMBOL);
            } else if (this.isRectangle) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_RECTANGLE);
            } else if (this.isClosePlgn) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
            } else {
                this.setCurrentCommand(CMD_SELECT);
            }
        } else {
            this.setCurrentCommand(CMD_SELECT);
        }
        this.skipFactorWidget = new ValueSliderWidget(this, 0, 10, "skipValue", this.getSkipWidgetLabel());
        this.skipFactorWidget.setEnabled(true);
        this.addRemovable(this.skipFactorWidget);
        this.pointsBtn = new JRadioButton("Points:", this.isPoints);
        this.rectangleBtn = new JRadioButton("Rectangle:", this.isRectangle);
        this.closePolygonBtn = new JRadioButton("ClosePolygon:", this.isClosePlgn);
        this.hiddenBtn = new JRadioButton("ClosePolygon:", this.isSelector);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton source = (JRadioButton)e.getSource();
                GridTrajectoryControlNew.this.coordinateType = 3;
                if (source == GridTrajectoryControlNew.this.pointsBtn) {
                    GridTrajectoryControlNew.this.setCurrentCommand(GlyphCreatorCommand.CMD_SYMBOL);
                    GridTrajectoryControlNew.this.isPoints = true;
                    GridTrajectoryControlNew.this.isClosePlgn = false;
                    GridTrajectoryControlNew.this.isRectangle = false;
                    GridTrajectoryControlNew.this.isSelector = false;
                    GridTrajectoryControlNew.this.skipFactorWidget.setValue(0.0f);
                    GridTrajectoryControlNew.this.skipFactorWidget.setEnabled(false);
                    GridTrajectoryControlNew.this.removeAllGlyphs();
                } else if (source == GridTrajectoryControlNew.this.rectangleBtn) {
                    GridTrajectoryControlNew.this.setCurrentCommand(GlyphCreatorCommand.CMD_RECTANGLE);
                    GridTrajectoryControlNew.this.isRectangle = true;
                    GridTrajectoryControlNew.this.isPoints = false;
                    GridTrajectoryControlNew.this.isClosePlgn = false;
                    GridTrajectoryControlNew.this.isSelector = false;
                    GridTrajectoryControlNew.this.skipFactorWidget.setEnabled(true);
                    GridTrajectoryControlNew.this.removeAllGlyphs();
                } else if (source == GridTrajectoryControlNew.this.closePolygonBtn) {
                    GridTrajectoryControlNew.this.setCurrentCommand(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
                    GridTrajectoryControlNew.this.isRectangle = false;
                    GridTrajectoryControlNew.this.isPoints = false;
                    GridTrajectoryControlNew.this.isSelector = false;
                    GridTrajectoryControlNew.this.isClosePlgn = true;
                    GridTrajectoryControlNew.this.skipFactorWidget.setEnabled(true);
                    GridTrajectoryControlNew.this.removeAllGlyphs();
                } else {
                    GridTrajectoryControlNew.this.setCurrentCommand(DrawingControl.CMD_SELECT);
                    GridTrajectoryControlNew.this.isSelector = true;
                    GridTrajectoryControlNew.this.isRectangle = false;
                    GridTrajectoryControlNew.this.isPoints = false;
                    GridTrajectoryControlNew.this.isClosePlgn = false;
                    GridTrajectoryControlNew.this.skipFactorWidget.setEnabled(true);
                }
                GridTrajectoryControlNew.this.setCoordType(GridTrajectoryControlNew.this.coordinateType);
            }
        };
        this.pointsBtn.addActionListener(listener);
        this.rectangleBtn.addActionListener(listener);
        this.closePolygonBtn.addActionListener(listener);
        this.hiddenBtn.addActionListener(listener);
        GuiUtils.buttonGroup(this.pointsBtn, this.rectangleBtn, this.closePolygonBtn, this.hiddenBtn);
        JPanel rightComp = GuiUtils.vbox(GuiUtils.left(this.pointsBtn), GuiUtils.left(this.closePolygonBtn), GuiUtils.left(this.rectangleBtn));
        this.backwardCbx = GuiUtils.makeCheckbox("", this, "backwardTrajectory");
        this.backwardCbx.setToolTipText("display the backward trajectory of air parcel");
        this.backwardCbx.setSelected(false);
        JLabel removeLabel = GuiUtils.rLabel("Remove Trajectory Initial Area:");
        if (this.isStreamline) {
            widgets.add(GuiUtils.rLabel(this.levelLabel.getText()));
            widgets.add(rightComp1);
            widgets.add(GuiUtils.rLabel("Streamline Initial Area:"));
            widgets.add(rightComp);
            widgets.add(GuiUtils.rLabel("Initial Area Skip Factor:  "));
            widgets.add(this.skipFactorWidget.getContents(false));
            widgets.add(GuiUtils.right(new JLabel("")));
            widgets.add(GuiUtils.hbox(this.createTrjBtn, GuiUtils.inset((Component)unloadBtn, spacer)));
        } else {
            widgets.add(GuiUtils.rLabel(this.levelLabel.getText()));
            widgets.add(rightComp1);
            widgets.add(GuiUtils.rLabel("Trajectory Initial Area:"));
            widgets.add(rightComp);
            widgets.add(GuiUtils.rLabel("Initial Area Skip Factor:  "));
            widgets.add(this.skipFactorWidget.getContents(false));
            widgets.add(GuiUtils.rLabel("Backward trajectory:"));
            widgets.add(this.backwardCbx);
            widgets.add(GuiUtils.right(new JLabel("")));
            widgets.add(GuiUtils.hbox(this.createTrjBtn, GuiUtils.inset((Component)unloadBtn, spacer)));
        }
        if (this.isXY) {
            this.XYBtn.setSelected(this.isXY);
        }
    }

    private void enableInitAreaWidget() {
        if (this.pointsBtn != null) {
            GuiUtils.enableTree(this.pointsBtn, this.isXY);
            GuiUtils.enableTree(this.closePolygonBtn, this.isXY);
            GuiUtils.enableTree(this.rectangleBtn, this.isXY);
            GuiUtils.enableTree(this.levelBox, this.isXY);
        }
    }

    private void enableInitPlaneWidget() {
        if (this.is2D) {
            GuiUtils.enableTree(this.levelBox, !this.is2D);
        }
    }

    @Override
    protected double getInitialZPosition() {
        Real alt = null;
        GriddedSet domainSet = (GriddedSet)this.gridTrackControl.getGridDataInstance().getSpatialDomain();
        try {
            alt = GridUtil.getAltitude(domainSet, (Real)((TwoFacedObject)this.currentLevel).getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (alt == null) {
            return 0.0;
        }
        return alt.getValue();
    }

    @Override
    public double getZPosition() {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        double[] rg = navDisplay.getVerticalRange();
        double z = this.getInitialZPosition();
        double zz = -1.0 + z / (rg[1] - rg[0]) * 2.0;
        return zz;
    }

    public void setBackwardTrajectory(boolean back) throws Exception {
        this.backwardTrajectory = back;
    }

    public boolean getBackwardTrajectory() throws Exception {
        return this.backwardTrajectory;
    }

    @Override
    protected boolean showLocationWidgets() {
        return true;
    }

    @Override
    public void applyColorToAll() {
        for (int i = 0; i < this.selectedGlyphs.size(); ++i) {
            ((DrawingGlyph)this.selectedGlyphs.get(i)).setColor(this.getColor());
        }
    }

    @Override
    public void setSkipValue(int value) {
        super.setSkipValue(value);
        if (this.skipFactorWidget != null) {
            this.skipFactorWidget.setValue(value);
        }
        if (this.gridTrackControl != null) {
            this.gridTrackControl.skipFactor = value;
        }
    }

    @Override
    public void removeAllGlyphs() {
        try {
            while (this.glyphs.size() > 0) {
                this.removeGlyph((DrawingGlyph)this.glyphs.get(0));
            }
            while (this.controlPane.getComponentCount() > 0) {
                this.controlPane.remove(0);
                this.controlPane.setVisible(false);
                if (this.gridTrackControl.myDisplay != null) {
                    this.gridTrackControl.myDisplay.setData(DUMMY_DATA);
                }
                this.createTrjBtnClicked = false;
            }
        }
        catch (Exception exc) {
            GridTrajectoryControlNew.logException("Removing drawings", exc);
        }
    }

    public void removeGC() {
        try {
            while (this.controlPane.getComponentCount() > 0) {
                this.controlPane.remove(0);
                this.controlPane.setVisible(false);
                if (this.gridTrackControl.myDisplay == null) continue;
                this.gridTrackControl.myDisplay.setData(DUMMY_DATA);
            }
        }
        catch (Exception exc) {
            GridTrajectoryControlNew.logException("Removing drawings", exc);
        }
    }

    private void clearCursor() {
        this.setCursor(null);
    }

    private void setCursor(int c) {
        this.setCursor(Cursor.getPredefinedCursor(c));
    }

    private void setCursor(Cursor c) {
        this.getViewManager().setCursorInDisplay(c);
    }

    @Override
    public int getCoordType() {
        return this.coordinateType;
    }

    public void setCurrentLevel(Object lvl) {
        this.currentLevel = lvl;
        this.bundleLevel = lvl;
    }

    public Object getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevelx(Object lvl) {
        this.currentLevelx = lvl;
        this.bundleLevelx = lvl;
    }

    public Object getCurrentLevelx() {
        return this.currentLevelx;
    }

    public void setCurrentLevely(Object lvl) {
        this.currentLevely = lvl;
        this.bundleLevely = lvl;
    }

    public Object getCurrentLevely() {
        return this.currentLevely;
    }

    public DrawingCommand getCurrentCmd() {
        return this.currentCmd;
    }

    public void setTrackArrowHead(boolean ah) {
        this.trackArrowHead = ah;
    }

    public boolean getTrackArrowHead() {
        return this.trackArrowHead;
    }

    public Integer getTrackFormType() {
        return this.trackFormType;
    }

    public void setTrackFormType(Integer ah) {
        this.trackFormType = ah;
    }

    public float getTrackOffsetValue() {
        return this.trackOffsetValue;
    }

    public void setTrackOffsetValue(float ah) {
        this.trackOffsetValue = ah;
    }

    public void setTracerType(int type) {
        this.tracerType = type;
    }

    public int getSmoothFactorValue() {
        return this.smoothFactorValue;
    }

    public void setSmoothFactorValue(int ah) {
        this.smoothFactorValue = ah;
    }

    public Color getTrackColor() {
        return this.trackColor;
    }

    public void setTrackColor(Color ah) {
        this.trackColor = ah;
    }

    public void setCurrentCmd(String command) {
        this.currentCmd = command.contains(GlyphCreatorCommand.CMD_RECTANGLE.getLabel()) ? GlyphCreatorCommand.CMD_RECTANGLE : (command.contains(GlyphCreatorCommand.CMD_SYMBOL.getLabel()) ? GlyphCreatorCommand.CMD_SYMBOL : (command.contains(GlyphCreatorCommand.CMD_CLOSEDPOLYGON.getLabel()) ? GlyphCreatorCommand.CMD_CLOSEDPOLYGON : this.getCurrentCmd()));
    }

    @Override
    public void setColorScaleInfo(ColorScaleInfo newInfo) throws VisADException, RemoteException {
        if (newInfo == null) {
            this.colorScaleInfo = null;
            return;
        }
        if (this.gridTrackControl != null) {
            this.gridTrackControl.colorScaleInfo = new ColorScaleInfo(newInfo);
            this.gridTrackControl.applyColorScaleInfo();
        }
        this.colorScaleInfo = new ColorScaleInfo(newInfo);
        this.applyColorScaleInfo();
    }

    @Override
    public Range getRangeToApply() throws RemoteException, VisADException {
        return this.gridTrackControl.getRange();
    }

    @Override
    public ColorScaleInfo getColorScaleInfo() {
        return this.colorScaleInfo;
    }

    public boolean getCreateTrjBtnClicked() {
        return this.createTrjBtnClicked;
    }

    public void setCreateTrjBtnClicked(boolean clicked) {
        this.createTrjBtnClicked = clicked;
    }

    public boolean getIsPoints() {
        return this.isPoints;
    }

    public void setIsPoints(boolean point) {
        this.isPoints = point;
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public void setCoordinateType(int type) {
        this.coordinateType = type;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        this.gridDataInstance = new GridDataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties(), null);
        return this.gridDataInstance;
    }

    public GridDataInstance getGridDataInstance() {
        if (this.gridDataInstance == null) {
            try {
                this.doMakeDataInstance(this.dataChoice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.gridDataInstance;
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        Data data;
        DataSelection ds = super.updateDataSelection(this.getDataSelection());
        DataChoice dataChoice = this.getDataChoice();
        if (dataChoice != null && (data = dataChoice.getData(ds)) != null) {
            this.processData(data);
        }
        while (this.controlPane.getComponentCount() > 0) {
            this.controlPane.remove(0);
            this.controlPane.setVisible(false);
            if (this.gridTrackControl.myDisplay != null) {
                this.gridTrackControl.myDisplay.setData(DUMMY_DATA);
            }
            this.createTrjBtnClicked = false;
        }
        this.reInit(dataChoice);
        try {
            this.gridTrackControl.setTrajFormType(this.getTrackFormType());
            this.gridTrackControl.setLineWidth(this.getTrackLineWidth());
            this.gridTrackControl.setTrajOffset(this.getTrackOffsetValue());
            this.gridTrackControl.setColor(this.getTrackColor());
            this.gridTrackControl.setSmoothFactor(this.getSmoothFactorValue());
            this.gridTrackControl.setArrowHead(this.getTrackArrowHead());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createTrjBtn.doClick();
    }

    public static class MyTrajectoryControl
    extends GridDisplayControl
    implements FlowDisplayControl {
        FlowDisplayable myDisplay;
        protected DataChoice datachoice;
        ValueSliderWidget trajLengthWidget;
        JComponent trajLengthComponent;
        JComponent smoothComponent;
        ValueSliderWidget smoothWidget;
        int smoothFactor = 10;
        int skipFactor = 0;
        boolean isThreeComponents = true;
        boolean arrowHead = false;
        protected final float scaleFactor = 0.02f;
        float flowScaleValue = 4.0f;
        float arrowHeadSizeValue = 0.5f;
        float trajOffsetValue = 4.0f;
        int tracerTypeValue = 8;
        private JComponent[] widthSliderComps;
        private Range flowRange;
        RangeDialog rangeDialog;
        private boolean useSpeedForColor = false;
        private boolean isStreamline = false;
        private boolean coloredByAnother = false;
        private int colorIndex = -1;
        private String[] trajFormLabels = new String[]{"Line", "Ribbon", "Cylinder", "Deform Ribbon", "Point", "Tracer"};
        private String[] tracerFormLabels = new String[]{"Arrow", "Sphere", "Dot"};
        private int[] trajForm = new int[]{0, 1, 2, 3, 4, 5};
        private int[] tracerForm = new int[]{7, 8, 9};
        JComponent trajFormComponent;
        private Integer trajFormType = new Integer(0);
        private int trajStartLevel = 0;
        private int trajSkipLevels = 0;
        private Range flowColorRange;
        GridTrajectoryControlNew gtc;
        boolean is2D = false;
        Data topoData = null;
        boolean isTracer = false;
        boolean isLine = true;
        JComboBox tracerFormBox = null;
        JComboBox vectorAHSizeBox;
        JCheckBox arrowCbx;
        private JComboBox levelBox;
        protected Object currentLevel;

        public MyTrajectoryControl(GridTrajectoryControlNew gtc) {
            this.gtc = gtc;
            this.useSpeedForColor = gtc.getUseSpeedForColor();
            this.coloredByAnother = gtc.getColoredByAnother();
            this.isStreamline = gtc.getIsStreamline();
            if (this.useSpeedForColor || this.coloredByAnother) {
                this.setAttributeFlags(1032);
            } else {
                this.setAttributeFlags(1028);
            }
            if (this.isStreamline) {
                this.trajFormLabels = new String[]{"Line", "Ribbon", "Cylinder"};
                this.trajForm = new int[]{0, 1, 2};
            }
        }

        public MyTrajectoryControl() {
            this.setAttributeFlags(1028);
        }

        @Override
        public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
            this.datachoice = dataChoice;
            if (dataChoice instanceof DerivedDataChoice) {
                DerivedDataChoice ddc = (DerivedDataChoice)dataChoice;
                List choices0 = ddc.getChoices();
                if (choices0.size() == 1) {
                    ddc = (DerivedDataChoice)choices0.get(0);
                    choices0 = ddc.getChoices();
                }
                if (choices0.size() == 3) {
                    DirectDataChoice udc = (DirectDataChoice)choices0.get(0);
                    DirectDataChoice vdc = (DirectDataChoice)choices0.get(1);
                    DirectDataChoice wdc = (DirectDataChoice)choices0.get(2);
                    List usTime = udc.getAllDateTimes();
                    List wsTime = wdc.getAllDateTimes();
                    List selectedTimes = this.getDataSelection().getTimes();
                    if (selectedTimes != null) {
                        int len = selectedTimes.size();
                        if (usTime.get((Integer)selectedTimes.get(0)) != wsTime.get((Integer)selectedTimes.get(0)) || usTime.get((Integer)selectedTimes.get(len - 1)) != wsTime.get((Integer)selectedTimes.get(len - 1))) {
                            this.userErrorMessage("w grid selected times are different from u grid ");
                            return false;
                        }
                    } else if (wdc.getSelectedDateTimes() != null) {
                        selectedTimes = wdc.getSelectedDateTimes();
                        int len = selectedTimes.size();
                        if (usTime.get(0) != wsTime.get(0) || usTime.get(len - 1) != wsTime.get(len - 1)) {
                            this.userErrorMessage("w grid selected times are different from u grid ");
                            return false;
                        }
                    }
                } else if (choices0.size() == 2) {
                    this.is2D = true;
                }
            }
            this.levelBox = this.doMakeLevelControl(null);
            this.levelBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (this.getOkToFireEvents()) {
                        TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                        int selectIdx = ((JComboBox)e.getSource()).getSelectedIndex();
                        if (select != null) {
                            int ct = ((JComboBox)e.getSource()).getItemCount();
                            if (select.toString().equals("All Levels")) {
                                this.setTrajStartLevel(select, selectIdx);
                            } else {
                                this.setTrajStartLevel(select, selectIdx);
                            }
                        }
                    }
                }
            });
            DataSelection tmpSelection = new DataSelection(this.gtc.getDataSelection());
            dataChoice.setDataSelection(tmpSelection);
            if (!this.setData(dataChoice)) {
                return false;
            }
            this.addDisplayable((Displayable)this.myDisplay, this.getAttributeFlags());
            return true;
        }

        @Override
        public String getLineWidthWidgetLabel() {
            return "Line Width/Point Size";
        }

        protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
            FlowDisplayable planDisplay = new FlowDisplayable("FlowPlanViewControl_vectors_" + (this.datachoice != null ? this.datachoice.toString() : ""), null);
            planDisplay.set3DFlow(true);
            planDisplay.setUseSpeedForColor(this.useSpeedForColor);
            planDisplay.setStreamline(this.isStreamline);
            planDisplay.setTrojectoriesEnabled(true, this.arrowHeadSizeValue, false);
            if (this.useSpeedForColor || this.coloredByAnother) {
                if (this.coloredByAnother) {
                    this.colorIndex = this.is2D ? 2 : 3;
                }
                this.addAttributedDisplayable(planDisplay, 8);
                this.addAttributedDisplayable(planDisplay, 1024);
            } else {
                this.addAttributedDisplayable(planDisplay);
            }
            return planDisplay;
        }

        FlowDisplayable getGridDisplay() {
            return this.myDisplay;
        }

        public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
            List dchoices;
            this.arrowCbx = new JCheckBox(" Arrow", this.arrowHead);
            this.arrowCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    arrowHead = ((JCheckBox)e.getSource()).isSelected();
                    if (arrowHead) {
                        this.getGridDisplay().setTracerType(7);
                        this.getGridDisplay().setArrowHead(arrowHead);
                        tracerFormBox.setSelectedIndex(0);
                    } else {
                        this.getGridDisplay().setArrowHead(arrowHead);
                    }
                    if (gtc != null) {
                        gtc.setTrackArrowHead(arrowHead);
                    }
                    this.getGridDisplay().resetTrojectories();
                }
            });
            if (this.getIsThreeComponents()) {
                this.trajLengthWidget = new ValueSliderWidget(this, 1, 21, "trajOffset", "LengthOffset");
                this.smoothWidget = new ValueSliderWidget(this, 11, 31, "smoothFactor", "smoothFactor");
                List trajFormList = TwoFacedObject.createList(this.trajForm, this.trajFormLabels);
                List tracerFormList = TwoFacedObject.createList(this.tracerForm, this.tracerFormLabels);
                JComboBox trajFormBox = new JComboBox();
                this.tracerFormBox = new JComboBox();
                GuiUtils.setListData(trajFormBox, trajFormList);
                GuiUtils.setListData(this.tracerFormBox, tracerFormList);
                trajFormBox.setSelectedItem(TwoFacedObject.findId(this.getTrajFormType(), trajFormList));
                trajFormBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                        this.setTrajFormType(select.getId().hashCode());
                        isTracer = select.getLabel() == "Tracer";
                        if (select.getLabel() == "Line") {
                            isLine = true;
                            arrowCbx.setSelected(arrowHead);
                        } else {
                            arrowCbx.setSelected(false);
                            isLine = false;
                        }
                        this.enableTracerCompnoentBox();
                        this.enableArrowCompnoentBox();
                    }
                });
                this.tracerFormBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                        this.setTracerType((Integer)select.getId());
                    }
                });
                String tracerformLabel = "Tracer Type: ";
                String tracersizeLabel = "Tracer Size: ";
                String formLabel = this.isStreamline ? "Streamline Form: " : "Trajectory Form: ";
                this.trajFormComponent = GuiUtils.hbox((Component)GuiUtils.rLabel(formLabel), GuiUtils.filler(), trajFormBox, GuiUtils.filler());
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(formLabel), GuiUtils.left(trajFormBox)));
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(tracerformLabel), GuiUtils.left(this.tracerFormBox)));
                this.trajLengthComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Length Offset: "), (Component)this.trajLengthWidget.getContents(false), this.arrowCbx);
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Length Offset: "), GuiUtils.left(GuiUtils.hbox(this.trajLengthWidget.getContents(false), this.arrowCbx))));
                this.vectorAHSizeBox = new JComboBox<String>(new String[]{"0.5", "1.0", "1.5", "2.0", "2.5", "3.0", "4"});
                this.vectorAHSizeBox.setToolTipText("Set the tracer size");
                this.vectorAHSizeBox.setMaximumSize(new Dimension(30, 16));
                this.vectorAHSizeBox.setEditable(true);
                this.vectorAHSizeBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String item = (String)((JComboBox)e.getSource()).getSelectedItem();
                        float selectsize = Float.parseFloat(item);
                        this.setArrowHeadSize(selectsize);
                    }
                });
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Arrow/Tracer Size: "), GuiUtils.left(this.vectorAHSizeBox)));
                if (this.isStreamline) {
                    this.smoothComponent = GuiUtils.hbox(GuiUtils.rLabel("Smooth Factor: "), this.smoothWidget.getContents(false));
                    controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Line Smooth Factor: "), GuiUtils.left(this.smoothWidget.getContents(false))));
                }
            }
            this.tracerFormBox.setSelectedIndex(0);
            this.enableTrajLengthBox();
            this.enableTracerCompnoentBox();
            this.enableArrowCompnoentBox();
            List timeL = this.getDataSelection().getTimes();
            if (timeL == null && this.getHadDataChoices() && (timeL = ((DataChoice)(dchoices = this.getMyDataChoices()).get(0)).getSelectedDateTimes()) != null && timeL.size() == 0) {
                timeL = ((DataChoice)dchoices.get(0)).getAllDateTimes();
            }
            super.getControlWidgets(controlWidgets);
        }

        public boolean getIsThreeComponents() {
            return this.isThreeComponents;
        }

        public void setStreamlines1() {
            if (this.getGridDisplay() != null) {
                int ct = this.levelBox.getItemCount();
                String tt = this.levelBox.getSelectedItem().toString();
                if (tt.equals("All Levels")) {
                    this.getGridDisplay().setZskip(1);
                } else {
                    this.getGridDisplay().setZskip(ct - 1);
                }
                this.getGridDisplay().setTrajStartLevel(this.trajStartLevel);
                this.getGridDisplay().setIsTrajectories(true);
                this.getGridDisplay().setTrojectoriesEnabled(true, this.arrowHeadSizeValue, false);
                this.enableTrajLengthBox();
            }
        }

        private void enableTrajLengthBox() {
            if (this.trajLengthComponent != null) {
                GuiUtils.enableTree(this.trajLengthComponent, true);
                GuiUtils.enableTree(this.trajFormComponent, true);
                GuiUtils.enableTree(this.levelBox, true);
            }
        }

        private void enableTracerCompnoentBox() {
            GuiUtils.enableTree(this.vectorAHSizeBox, this.isTracer | this.isLine);
            GuiUtils.enableTree(this.tracerFormBox, this.isTracer);
        }

        private void enableArrowCompnoentBox() {
            GuiUtils.enableTree(this.vectorAHSizeBox, this.isLine | this.isTracer);
            GuiUtils.enableTree(this.arrowCbx, this.isLine);
        }

        @Override
        public void setPointSize(float value) {
            super.setPointSize(value);
            if (this.myDisplay != null) {
                try {
                    this.myDisplay.setPointSize(this.getPointSize());
                }
                catch (Exception e) {
                    MyTrajectoryControl.logException("Setting point size", e);
                }
            }
        }

        public boolean getArrowHead() {
            return this.arrowHead;
        }

        public void setArrowHead(boolean ah) {
            this.arrowHead = ah;
            if (this.gtc != null) {
                this.gtc.setTrackArrowHead(ah);
            }
        }

        @Override
        protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
            if (!super.setData(choice) || this.getNavigatedDisplay() == null) {
                return false;
            }
            DataSelection tmpSelection = new DataSelection(this.getDataSelection());
            tmpSelection.setFromLevel(null);
            tmpSelection.setToLevel(null);
            DataChoice wchoice = null;
            this.is2D = this.gtc.is2D;
            if (this.coloredByAnother) {
                DerivedDataChoice derivedDataChoice = (DerivedDataChoice)((DerivedDataChoice)choice).getChoices().get(0);
                wchoice = this.is2D ? (DataChoice)derivedDataChoice.getChoices().get(0) : (DataChoice)derivedDataChoice.getChoices().get(2);
            } else {
                wchoice = this.is2D ? (DataChoice)((DerivedDataChoice)choice).getChoices().get(0) : (DataChoice)((DerivedDataChoice)choice).getChoices().get(2);
            }
            List levelsList = wchoice.getAllLevels(tmpSelection);
            Object[] levels = this.getGridDataInstance().getLevels();
            if (levels == null && levelsList != null && levelsList.size() > 0) {
                levels = levelsList.toArray(new Object[levelsList.size()]);
            }
            if (levels != null) {
                this.setLevels(levels);
            } else {
                this.is2D = true;
            }
            this.myDisplay = (FlowDisplayable)this.createPlanDisplay();
            this.myDisplay.setActive(false);
            this.myDisplay.setUseSpeedForColor(this.useSpeedForColor);
            this.myDisplay.setColoredByAnother(this.coloredByAnother);
            if (this.useSpeedForColor) {
                this.colorIndex = this.myDisplay.getSpeedTypeIndex();
            }
            if (this.coloredByAnother) {
                this.colorIndex = 3;
            }
            if (this.gtc.withTopo) {
                DataChoice topoChoice = (DataChoice)((DerivedDataChoice)choice).getChoices().get(3);
                this.topoData = topoChoice.getData(wchoice.getDataSelection());
            }
            if (this.useSpeedForColor || this.coloredByAnother) {
                this.setFlowColorRange();
            }
            this.myDisplay.setActive(true);
            return true;
        }

        public void setLevels(Object[] levels) {
            if (levels == null) {
                levels = this.getGridDataInstance().getLevels();
            }
            this.setOkToFireEvents(false);
            if (this.levelBox == null) {
                return;
            }
            this.levelBox.setEnabled(false);
            Object[] all = this.formatLevels(levels);
            GuiUtils.setListData(this.levelBox, this.formatLevels(levels));
            int len = levels.length;
            this.currentLevel = all[len - 1];
            this.trajStartLevel = ((Real)((TwoFacedObject)all[0]).getId()).getValue() < ((Real)((TwoFacedObject)all[len - 1]).getId()).getValue() ? len - 1 : 0;
            this.setTrajStartLevel(this.currentLevel, this.trajStartLevel);
            this.levelBox.setSelectedItem(this.getLabeledReal(this.currentLevel));
            this.setOkToFireEvents(true);
            this.levelBox.setEnabled(true);
        }

        @Override
        protected Object[] formatLevels(Object[] levels) {
            if (levels == null) {
                return null;
            }
            int len = levels.length;
            Object[] tfoList = new Object[len];
            for (int i = 0; i < len; ++i) {
                tfoList[i] = this.getLabeledReal(levels[i]);
            }
            return tfoList;
        }

        private void setFlowColorRange() throws RemoteException, VisADException {
            if (this.getGridDisplay() != null && this.getFlowRange() == null) {
                Range[] ranges = null;
                Data data = this.getGridDisplay().getData();
                if (data != null) {
                    int speedIndex;
                    ranges = GridUtil.getMinMax((FieldImpl)data);
                    double max = Double.NEGATIVE_INFINITY;
                    double min = Double.POSITIVE_INFINITY;
                    int startComp = 0;
                    int numComps = this.getIsThreeComponents() ? 3 : 2;
                    boolean isCartesian = this.getGridDisplay().isCartesianWind();
                    if (!isCartesian && (speedIndex = this.getGridDisplay().getSpeedTypeIndex()) != -1) {
                        startComp = speedIndex;
                        numComps = startComp + 1;
                    }
                    if ((this.useSpeedForColor || this.coloredByAnother) && ranges.length > numComps) {
                        Range compRange = ranges[ranges.length - 1];
                        max = Math.max(compRange.getMax(), max);
                        min = Math.min(compRange.getMin(), min);
                    } else {
                        for (int i = startComp; i < numComps; ++i) {
                            Range compRange = ranges[i];
                            max = Math.max(compRange.getMax(), max);
                            min = Math.min(compRange.getMin(), min);
                        }
                    }
                    if (!(this.useSpeedForColor || this.coloredByAnother || Double.isInfinite(max) || Double.isInfinite(min))) {
                        max = Math.max(max, -min);
                        min = isCartesian ? -max : 0.0;
                    }
                    this.flowColorRange = new Range(min, max);
                } else {
                    this.flowColorRange = new Range(-40.0, 40.0);
                }
            }
        }

        public void setFlowColorRange(Range colorRange) {
            this.flowColorRange = colorRange;
        }

        public Range getFlowColorRange() {
            return this.flowColorRange;
        }

        public Range getFlowRange() {
            return this.flowRange;
        }

        @Override
        protected boolean shouldAddControlListener() {
            return true;
        }

        public void setFlowRange(Range f) {
            this.flowRange = f;
            if (this.getGridDisplay() != null && this.flowRange != null) {
                try {
                    this.getGridDisplay().setFlowRange(this.flowRange);
                }
                catch (Exception excp) {
                    MyTrajectoryControl.logException("setFlowRange: ", excp);
                }
            }
            if (this.getHaveInitialized()) {
                this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
            }
        }

        @Override
        protected Container doMakeContents() throws VisADException, RemoteException {
            return this.doMakeWidgetComponent();
        }

        private void loadVolumeData() throws VisADException, RemoteException {
            FieldImpl grid;
            Trace.call1("VRC.loadVolumeData");
            FieldImpl newGrid = grid = this.getGridDataInstance().getGrid();
            if (this.gtc.getSkipValue() > 0) {
                newGrid = grid = GridUtil.subset(grid, this.gtc.getSkipValue());
            }
            Trace.call1("VRC.loadVolumeData.loadData");
            this.myDisplay.setColoredByAnother(this.coloredByAnother);
            this.myDisplay.loadData(newGrid);
            Trace.call2("VRC.loadVolumeData.loadData");
            Trace.call2("loadVolumeData");
        }

        @Override
        public void projectionChanged() {
            try {
                this.loadVolumeData();
            }
            catch (Exception exc) {
                MyTrajectoryControl.logException("loading volume data", exc);
            }
            super.projectionChanged();
        }

        @Override
        public boolean getIsRaster() {
            return false;
        }

        public float getFlowScale() {
            return this.flowScaleValue;
        }

        public void setFlowScale(float f) {
            this.flowScaleValue = f;
            if (this.getGridDisplay() != null) {
                try {
                    this.getGridDisplay().setFlowScale(this.getDisplayScale() * 0.02f * this.flowScaleValue);
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
        }

        public float getTrajOffset() {
            return this.trajOffsetValue;
        }

        public void setTrajOffset(float f) {
            this.trajOffsetValue = f;
            if (this.getGridDisplay() != null) {
                try {
                    if (this.gtc != null) {
                        this.gtc.setTrackOffsetValue(f);
                    }
                    this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
                    this.getGridDisplay().setStreamline(this.isStreamline);
                    this.getGridDisplay().resetTrojectories();
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
            if (this.trajLengthWidget != null) {
                this.trajLengthWidget.setValue(f);
            }
        }

        public void setTracerType(int type) {
            this.tracerTypeValue = type;
            if (this.getGridDisplay() != null) {
                try {
                    if (this.gtc != null) {
                        this.gtc.setTracerType(type);
                    }
                    this.getGridDisplay().setTracerType(type);
                    this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                    this.getGridDisplay().setStreamline(this.isStreamline);
                    this.getGridDisplay().resetTrojectories();
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
        }

        public void setArrowHeadSize(float f) {
            this.arrowHeadSizeValue = f;
            if (this.getGridDisplay() != null) {
                try {
                    this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
                    this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                    if (this.trajFormType == 0 || this.trajFormType == 5) {
                        this.getGridDisplay().resetTrojectories();
                    }
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
        }

        public float getArrowHeadSize() {
            return this.arrowHeadSizeValue;
        }

        public int getSmoothFactor() {
            return this.smoothFactor;
        }

        public void setSmoothFactor(int f) {
            this.smoothFactor = f;
            if (this.getGridDisplay() != null) {
                try {
                    if (this.gtc != null) {
                        this.gtc.setSmoothFactorValue(f);
                    }
                    this.getGridDisplay().setSmoothFactor(f);
                    this.getGridDisplay().setStreamline(this.isStreamline);
                    this.getGridDisplay().resetTrojectories();
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
            if (this.smoothWidget != null) {
                this.smoothWidget.setValue(f);
            }
        }

        public Integer getTrajFormType() {
            return this.trajFormType;
        }

        public void setTrajFormType(Integer trajForm) {
            this.trajFormType = trajForm;
            if (this.gtc != null) {
                this.gtc.setTrackFormType(this.trajFormType);
            }
            if (this.getGridDisplay() != null) {
                try {
                    this.getGridDisplay().setTrajFormType(trajForm);
                    this.getGridDisplay().setArrowHead(this.arrowHead);
                    this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                    if (trajForm == 0) {
                        this.getGridDisplay().setTracerType(7);
                        if (this.tracerFormBox != null) {
                            this.tracerFormBox.setSelectedIndex(0);
                        }
                    }
                    this.getGridDisplay().resetTrojectories();
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
        }

        public void setTrajStartLevel(Object startLevel, int idx) {
            this.trajStartLevel = idx;
            this.currentLevel = startLevel;
            int ct = this.levelBox.getItemCount();
            if (ct == 1) {
                ct = 2;
            }
            if (this.getGridDisplay() != null) {
                try {
                    this.getGridDisplay().setTrajStartLevel(idx);
                    this.getGridDisplay().setZskip(ct);
                    this.getGridDisplay().resetTrojectories();
                }
                catch (Exception ex) {
                    MyTrajectoryControl.logException("setFlowScale: ", ex);
                }
            }
        }

        public void setColoredByAnother(boolean yesno) {
            this.coloredByAnother = yesno;
        }

        public boolean getColoredByAnother() {
            return this.coloredByAnother;
        }

        public void setUseSpeedForColor(boolean yesno) {
            this.useSpeedForColor = yesno;
        }

        public boolean getUseSpeedForColor() {
            return this.useSpeedForColor;
        }

        @Override
        protected int getColorRangeIndex() {
            if (this.colorIndex >= 0) {
                return this.colorIndex;
            }
            return this.getIsThreeComponents() ? 3 : 2;
        }

        @Override
        public Range getRangeForColorTable() throws RemoteException, VisADException {
            if (this.getFlowColorRange() == null) {
                this.setFlowColorRange();
            }
            return this.getFlowColorRange();
        }

        private Range makeFlowRange(Range r) {
            if (this.haveMultipleFields()) {
                return r;
            }
            if (r == null) {
                return r;
            }
            double max = Math.max(Math.abs(r.getMax()), Math.abs(r.getMin()));
            return new Range(-max, max);
        }

        @Override
        protected boolean haveMultipleFields() {
            if (this.getGridDataInstance() == null) {
                return false;
            }
            return this.getGridDataInstance().getNumRealTypes() > (this.getIsThreeComponents() ? 3 : 2) || this.useSpeedForColor || this.coloredByAnother;
        }

        @Override
        public boolean showColorControlWidget() {
            return !this.useSpeedForColor && !this.coloredByAnother;
        }

        @Override
        public String getColorWidgetLabel() {
            return "Color";
        }

        @Override
        protected String getColorParamName() {
            if (this.useSpeedForColor) {
                return "windSpeed";
            }
            if (this.coloredByAnother) {
                if (this.getGridDataInstance() == null) {
                    return "ColoredByAnother";
                }
                String pname = this.getGridDataInstance().getRealTypeName(this.colorIndex);
                int eidx = pname.indexOf("[unit");
                if (eidx == -1) {
                    eidx = pname.lastIndexOf("_");
                }
                return pname.substring(0, eidx);
            }
            return super.getColorParamName();
        }

        @Override
        protected Range getInitialRange() throws RemoteException, VisADException {
            if (this.useSpeedForColor) {
                return this.flowRange;
            }
            if (this.coloredByAnother) {
                if (this.getGridDataInstance() == null) {
                    return null;
                }
                return this.getGridDataInstance().getRanges()[this.colorIndex];
            }
            return super.getInitialRange();
        }

        @Override
        public void setLineWidth(int width) throws RemoteException, VisADException {
            if (this.getGridDisplay() != null) {
                if (this.trajFormType == 4) {
                    this.setPointSize((float)width * 1.0f);
                } else if (this.trajFormType == 2) {
                    this.getGridDisplay().setTrajWidth((float)width * 0.01f);
                    this.getGridDisplay().resetTrojectories();
                } else if (this.trajFormType == 1 || this.trajFormType == 3) {
                    this.getGridDisplay().setRibbonWidth(width);
                    this.getGridDisplay().resetTrojectories();
                }
            }
            if (this.gtc != null) {
                this.gtc.setTrackLineWidth(width);
            }
            super.setLineWidth(width);
        }

        @Override
        public int getLineWidth() {
            return super.getLineWidth();
        }

        @Override
        public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
            this.setTrajFormType(this.gtc.getTrackFormType());
            int width = super.getLineWidth();
            if (this.myDisplay != null) {
                this.setTrajFormType(this.gtc.getTrackFormType());
                try {
                    this.setRange(this.gtc.getRange());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.trajFormType == 2) {
                    this.getGridDisplay().setTrajWidth((float)width * 0.01f);
                } else if (this.trajFormType == 1 || this.trajFormType == 3) {
                    this.getGridDisplay().setRibbonWidth(width);
                }
                this.setArrowHead(this.gtc.getTrackArrowHead());
                this.getGridDisplay().setArrowHead(this.gtc.getTrackArrowHead());
                this.getGridDisplay().resetTrojectories();
            }
        }

        @Override
        public void setColor(Color c) throws RemoteException, VisADException {
            super.setColor(c);
            if (this.gtc != null) {
                this.gtc.setTrackColor(c);
            }
        }

        @Override
        public Range getRange() throws RemoteException, VisADException {
            return super.getRange();
        }

        @Override
        public void setRange(Range nRange) throws RemoteException, VisADException {
            super.setRange(nRange);
            this.setFlowColorRange(nRange);
            if (this.gtc != null) {
                this.gtc.setRange(nRange);
            }
        }

        @Override
        public void setColorTable(ColorTable newColorTable) throws RemoteException, VisADException {
            if (newColorTable != super.getColorTable()) {
                super.setColorTable(newColorTable);
            }
            if (this.gtc != null && newColorTable != this.gtc.getTrjColorTable()) {
                this.gtc.setTrjColorTable(newColorTable);
            }
        }

        @Override
        public ColorTable getColorTable() {
            if (this.gtc != null && this.gtc.getTrjColorTable() != null) {
                return this.gtc.getTrjColorTable();
            }
            return super.getColorTable();
        }

        private boolean trackDataOk() throws VisADException, RemoteException {
            DataInstance dataInstance = this.gtc.getDataInstance();
            return dataInstance != null && dataInstance.dataOk();
        }

        public Object[] getLevels() {
            DataSelection tmpSelection = new DataSelection(this.getDataSelection());
            tmpSelection.setFromLevel(null);
            tmpSelection.setToLevel(null);
            DataChoice wchoice = null;
            if (this.coloredByAnother) {
                DerivedDataChoice derivedDataChoice = (DerivedDataChoice)((DerivedDataChoice)this.datachoice).getChoices().get(0);
                wchoice = this.is2D ? (DataChoice)derivedDataChoice.getChoices().get(0) : (DataChoice)derivedDataChoice.getChoices().get(2);
            } else {
                wchoice = this.is2D ? (DataChoice)((DerivedDataChoice)this.datachoice).getChoices().get(0) : (DataChoice)((DerivedDataChoice)this.datachoice).getChoices().get(2);
            }
            List levelsList = wchoice.getAllLevels(tmpSelection);
            Object[] levels = null;
            if (levelsList != null && levelsList.size() > 0) {
                levels = levelsList.toArray(new Object[levelsList.size()]);
            }
            if (levels == null) {
                levels = this.getGridDataInstance().getLevels();
            }
            return levels;
        }

        @Override
        protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
            DataSelection ds = this.getDataSelection();
            Object t = ds.getProperty("Use_Progressive_Resolution");
            if (t != null) {
                this.isProgressiveResolution = (Boolean)t;
            }
            this.gridDataInstance = new GridDataInstance(dataChoice, ds, this.getRequestProperties());
            return this.gridDataInstance;
        }

        @Override
        public GridDataInstance getGridDataInstance() {
            if (this.gridDataInstance == null) {
                try {
                    this.doMakeDataInstance(this.datachoice);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.gridDataInstance;
        }

        @Override
        public boolean getHaveInitialized() {
            return true;
        }
    }
}

