/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataTimeRange;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.gis.MapMaker;
import ucar.unidata.data.grid.DerivedGridFactory;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridTrajectory;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DrawingControl;
import ucar.unidata.idv.control.TrackControl;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.drawing.DrawingCommand;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.drawing.SymbolGlyph;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.GeoUtils;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.ColorScaleInfo;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.SelectRangeDisplayable;
import ucar.visad.display.StationModelDisplayable;
import ucar.visad.display.TrackDisplayable;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DoubleSet;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;

public class GridTrajectoryControl
extends DrawingControl {
    protected JCheckBox enabledCbx;
    private String editorTitle = null;
    public static final DrawingCommand CMD_REMOVE = new DrawingCommand("Remove graphic", "remove all shape graphics", "/auxdata/ui/icons/Reshape16.gif");
    public static final String CMD_SETLEVELS = "cmd.setlevels";
    public static final String CMD_createTrj = "cmd.createTrj";
    DataChoice dataChoice;
    private JButton levelUpBtn;
    private JButton levelDownBtn;
    private JComboBox levelBox;
    private JLabel levelLabel;
    protected Object currentLevel;
    protected Object bundleLevel = null;
    protected Object[] currentLevels;
    private boolean levelEnabled = false;
    private Unit zunit;
    private Unit newZunit = CommonUnit.meter;
    private static final Data DUMMY_DATA = new Real(0.0);
    private Object MUTEX = new Object();
    CoordinateSystem pressToHeightCS;
    private JRadioButton pointsBtn;
    private JRadioButton hiddenBtn;
    private JRadioButton rectangleBtn;
    private JRadioButton closePolygonBtn;
    boolean isPoints = true;
    boolean isRectangle = false;
    boolean isSelector = false;
    boolean isClosePlgn = true;
    private JButton createTrjBtn;
    boolean createTrjBtnClicked = false;
    JPanel controlPane;
    private MyTrackControl gridTrackControl;
    FieldImpl u;
    FieldImpl v;
    FieldImpl pw;
    FieldImpl s;
    int trackLineWidth = 1;
    private DataTimeRange trjDataTimeRange;
    ColorTable trjColorTable;
    Range trjColorRange;
    Range bundleColorRange = null;
    boolean is2DTraj = false;
    boolean is2DDC = false;
    ValueSliderWidget skipFactorWidget;
    int coordinateType = 3;
    Unit newUnit = null;
    boolean isBundle = false;
    private JCheckBox backwardCbx;
    private boolean backwardTrajectory = false;
    protected DataSelection dataSelection1;
    protected GridDataInstance gridDataInstance;

    public GridTrajectoryControl() {
        this.setLineWidth(2);
        this.reallySetAttributeFlags(41);
    }

    @Override
    protected void timeChanged(Real time) {
        this.gridTrackControl.timeChanged(time);
    }

    public int getTrackLineWidth() {
        return this.trackLineWidth;
    }

    public void setTrackLineWidth(int width) {
        this.trackLineWidth = width;
    }

    public DataTimeRange getTrjDataTimeRange() {
        return this.trjDataTimeRange;
    }

    public void setTrjDataTimeRange(DataTimeRange range) {
        if (range != null) {
            this.trjDataTimeRange = range;
            if (this.gridTrackControl != null) {
                this.gridTrackControl.setDataTimeRange(range);
            }
            super.setDataTimeRange(range);
        }
    }

    public Range getTrjColorRange() {
        return this.trjColorRange;
    }

    public void setTrjColorRange(Range crange) {
        this.trjColorRange = crange;
        if (crange != null) {
            this.trjColorRange = crange;
            if (this.gridTrackControl != null) {
                try {
                    this.gridTrackControl.setRange(crange);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                super.setRange(crange);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ColorTable getTrjColorTable() {
        return this.trjColorTable;
    }

    public void setTrjColorTable(ColorTable ctable) {
        if (ctable != null) {
            this.trjColorTable = ctable;
            if (this.gridTrackControl != null) {
                try {
                    this.gridTrackControl.setColorTable(ctable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                super.setColorTable(ctable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.isBundle = this.getIdv().getStateManager().isLoadingXml();
        super.init((DataChoice)null);
        this.gridTrackControl = new MyTrackControl(this);
        this.dataChoice = dataChoice;
        DerivedDataChoice ddc = (DerivedDataChoice)dataChoice;
        List choices0 = ddc.getChoices();
        DerivedDataChoice ddc0 = (DerivedDataChoice)choices0.get(0);
        Hashtable choices = ddc0.getUserSelectedChoices();
        DataInstance di = this.getDataInstance();
        int numChoices = choices.size();
        if (numChoices == 2) {
            this.is2DTraj = true;
        }
        DirectDataChoice udc = (DirectDataChoice)choices.get(new String("D1"));
        DirectDataChoice vdc = (DirectDataChoice)choices.get(new String("D2"));
        DirectDataChoice wdc = (DirectDataChoice)choices.get(new String("D3"));
        if (choices0.size() == 1) {
            return false;
        }
        DataChoice sdc = (DataChoice)choices0.get(1);
        this.addDataChoice(udc);
        this.addDataChoice(vdc);
        if (wdc != null) {
            this.addDataChoice(wdc);
        }
        this.dataSelection1 = this.getDataSelection();
        this.updateDataSelection(this.dataSelection1);
        Object fromLevel = this.dataSelection1.getFromLevel();
        this.dataSelection1.setLevel(null);
        this.u = (FieldImpl)udc.getData(this.dataSelection1);
        this.v = (FieldImpl)vdc.getData(this.dataSelection1);
        if (wdc != null) {
            this.pw = (FieldImpl)wdc.getData(this.dataSelection1);
        }
        if (sdc == null) {
            return false;
        }
        sdc.setDataSelection(this.dataSelection1);
        this.s = (FieldImpl)sdc.getData(null);
        GridDataInstance gdi = (GridDataInstance)this.doMakeDataInstance(sdc);
        this.setDataInstance(gdi);
        this.gridTrackControl.controlContext = this.getControlContext();
        if (this.getDisplayUnit().equals(this.getDefaultDistanceUnit())) {
            this.setDisplayUnit(gdi.getRawUnit(0));
        }
        this.initDisplayUnit();
        this.levelBox = this.gridTrackControl.doMakeLevelControl(null);
        this.levelBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals(GridTrajectoryControl.CMD_SETLEVELS)) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)event.getSource()).getSelectedItem();
                    GridTrajectoryControl.this.setLevel(select);
                }
            }
        });
        ImageIcon upIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelUp.gif");
        this.levelUpBtn = new JButton(upIcon);
        this.levelUpBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.levelUpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GridTrajectoryControl.this.moveUpDown(-1);
            }
        });
        ImageIcon downIcon = GuiUtils.getImageIcon("/ucar/unidata/idv/control/images/LevelDown.gif");
        this.levelDownBtn = new JButton(downIcon);
        this.levelDownBtn.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.levelDownBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                GridTrajectoryControl.this.moveUpDown(1);
            }
        });
        this.levelLabel = GuiUtils.rLabel(this.getLevelsLabel());
        this.levelLabel.setDisplayedMnemonic(GuiUtils.charToKeyCode("L"));
        this.levelLabel.setLabelFor(this.levelBox);
        DataSelection tmpSelection = new DataSelection(0);
        List levelsList = sdc.getAllLevels(tmpSelection);
        Object[] levels = null;
        if (levelsList != null && levelsList.size() > 0) {
            levels = levelsList.toArray(new Object[levelsList.size()]);
            SampledSet ss = GridUtil.getSpatialDomain(gdi.getGrid());
            this.zunit = ss.getSetUnits()[2];
        }
        if (levels == null) {
            GridUtil.getSpatialDomain(gdi.getGrid());
            levels = ((GridDataInstance)this.getDataInstance()).getLevels();
            this.zunit = ((GridDataInstance)this.getDataInstance()).getZUnit();
        }
        if (this.currentLevel == null) {
            this.currentLevel = fromLevel;
        }
        if (levels != null && levels.length > 0 && this.currentLevel == null) {
            this.currentLevel = levels[0];
        }
        this.setLevels(levels, fromLevel);
        this.setDisplayActive();
        if (!this.gridTrackControl.trackDataOk()) {
            ArrayList<DataChoice> dlist = new ArrayList<DataChoice>();
            dlist.add(sdc);
            this.gridTrackControl.appendDataChoices(dlist);
            if (!this.gridTrackControl.trackDataOk()) {
                return false;
            }
        }
        this.gridTrackControl.trackDisplay = new TrackDisplayable("track" + dataChoice);
        this.setLineWidth(this.gridTrackControl.trackWidth);
        this.addDisplayable((Displayable)this.gridTrackControl.trackDisplay, this.getAttributeFlags());
        this.gridTrackControl.selectRangeDisplay = new SelectRangeDisplayable();
        this.addDisplayable((Displayable)this.gridTrackControl.selectRangeDisplay, 256);
        this.getViewAnimation();
        this.gridTrackControl.indicator = new StationModelDisplayable("indicator");
        this.gridTrackControl.indicator.setScale(this.gridTrackControl.markerScale);
        this.gridTrackControl.indicator.setShouldUseAltitude(true);
        this.gridTrackControl.updateIndicator();
        this.addDisplayable(this.gridTrackControl.indicator);
        this.gridTrackControl.timesHolder = new LineDrawing("track_time" + dataChoice);
        this.gridTrackControl.timesHolder.setManipulable(false);
        this.gridTrackControl.timesHolder.setVisible(false);
        this.addDisplayable(this.gridTrackControl.timesHolder);
        this.gridTrackControl.addDisplayable((Displayable)this.gridTrackControl.trackDisplay, this.getAttributeFlags());
        this.gridTrackControl.addDisplayable((Displayable)this.gridTrackControl.selectRangeDisplay, 256);
        this.gridTrackControl.addDisplayable(this.gridTrackControl.indicator);
        this.gridTrackControl.addDisplayable(this.gridTrackControl.timesHolder);
        this.createTrjBtn = new JButton("Create Trajectory");
        this.createTrjBtn.addActionListener(this);
        this.createTrjBtn.setActionCommand(CMD_createTrj);
        this.createTrjBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String cmd = actionEvent.getActionCommand();
                if (cmd.equals(GridTrajectoryControl.CMD_createTrj)) {
                    try {
                        GridTrajectoryControl.this.createTrjBtnClicked = true;
                        GridTrajectoryControl.this.removeGC();
                        GridTrajectoryControl.this.createTrajectory();
                        GridTrajectoryControl.this.gridTrackControl.setLineWidth(GridTrajectoryControl.this.trackLineWidth);
                    }
                    catch (Exception exr) {
                        DisplayControlBase.logException("Click create trajectory button", exr);
                    }
                }
            }
        });
        this.controlPane = new JPanel();
        this.controlPane.setPreferredSize(new Dimension(300, 180));
        return true;
    }

    public boolean initData() throws VisADException, RemoteException {
        DerivedDataChoice ddc = (DerivedDataChoice)this.dataChoice;
        List choices0 = ddc.getChoices();
        DerivedDataChoice ddc0 = (DerivedDataChoice)choices0.get(0);
        Hashtable choices = ddc0.getUserSelectedChoices();
        DataInstance di = this.getDataInstance();
        int numChoices = choices.size();
        if (numChoices == 2) {
            this.is2DTraj = true;
        }
        DirectDataChoice udc = (DirectDataChoice)choices.get(new String("D1"));
        DirectDataChoice vdc = (DirectDataChoice)choices.get(new String("D2"));
        DirectDataChoice wdc = (DirectDataChoice)choices.get(new String("D3"));
        if (choices0.size() == 1) {
            return false;
        }
        DataChoice sdc = (DataChoice)choices0.get(1);
        this.addDataChoice(udc);
        this.addDataChoice(vdc);
        if (wdc != null) {
            this.addDataChoice(wdc);
        }
        this.dataSelection1 = this.getDataSelection();
        this.updateDataSelection(this.dataSelection1);
        Object fromLevel = this.dataSelection1.getFromLevel();
        this.dataSelection1.setLevel(null);
        this.u = (FieldImpl)udc.getData(this.dataSelection1);
        this.v = (FieldImpl)vdc.getData(this.dataSelection1);
        if (wdc != null) {
            this.pw = (FieldImpl)wdc.getData(this.dataSelection1);
        }
        if (sdc == null) {
            return false;
        }
        sdc.setDataSelection(this.dataSelection1);
        this.s = (FieldImpl)sdc.getData(null);
        GridDataInstance gdi = (GridDataInstance)this.doMakeDataInstance(sdc);
        this.setDataInstance(gdi);
        return true;
    }

    @Override
    public synchronized void dataChanged() {
        try {
            this.removeAllGlyphs();
            this.initData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
        this.gridTrackControl.displayUnitChanged(oldUnit, newUnit);
        this.gridTrackControl.setNewDisplayUnit(newUnit, true);
        try {
            this.gridTrackControl.setSelectRange(this.gridTrackControl.getColorRangeFromData());
            this.gridTrackControl.selectRangeDisplay.setDisplayUnit(newUnit);
        }
        catch (Exception exc) {
            GridTrajectoryControl.logException("change unit", exc);
        }
        this.setDisplayUnit(newUnit);
    }

    public void createTrajectory() {
        Misc.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = GridTrajectoryControl.this.MUTEX;
                    synchronized (object) {
                        GridTrajectoryControl.this.showWaitCursor();
                        if (!GridTrajectoryControl.this.is2DTraj) {
                            GridTrajectoryControl.this.createTrajectoryControl();
                        } else {
                            GridTrajectoryControl.this.create2DTrajectoryControl();
                        }
                    }
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Calculationing the grid trajectory", exc);
                }
                finally {
                    GridTrajectoryControl.this.showNormalCursor();
                }
            }
        });
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
        if (this.createTrjBtnClicked && this.getGlyphs() != null && this.glyphs.size() > 0) {
            this.currentLevel = this.getCurrentLevel();
            if (this.currentLevel != null && this.bundleLevel != null && !this.currentLevel.equals(this.bundleLevel)) {
                this.setLevel(this.bundleLevel);
                this.levelBox.setSelectedItem(this.bundleLevel);
            }
            this.newUnit = this.getDisplayUnit();
            this.createTrjBtn.doClick();
            this.gridTrackControl.setLineWidth(this.getTrackLineWidth());
            this.gridTrackControl.getDataTimeRange(true).getTimeModeLabel();
            try {
                this.gridTrackControl.setColorTable(this.getTrjColorTable());
                this.doMakeColorScales();
                this.bundleColorRange = this.getTrjColorRange();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getHaveInitialized() {
        return true;
    }

    public void setLevels(Object[] levels, Object initLevel) {
        this.setOkToFireEvents(false);
        this.currentLevels = levels;
        boolean bl = this.levelEnabled = levels != null;
        if (this.levelBox == null) {
            return;
        }
        this.levelBox.setEnabled(this.levelEnabled);
        this.levelUpBtn.setEnabled(this.levelEnabled);
        this.levelDownBtn.setEnabled(this.levelEnabled);
        this.levelLabel.setEnabled(this.levelEnabled);
        GuiUtils.setListData(this.levelBox, this.formatLevels(levels));
        if (initLevel != null) {
            if (initLevel instanceof Real) {
                TwoFacedObject clevel = Util.labeledReal((Real)initLevel);
                this.levelBox.setSelectedItem(clevel);
            } else {
                this.levelBox.setSelectedItem(initLevel);
            }
        }
        this.setOkToFireEvents(true);
    }

    public void setLevel(Object r) {
        this.currentLevel = r;
    }

    private void moveUpDown(int delta) {
        int max;
        int selected = this.levelBox.getSelectedIndex();
        if (selected >= 0 && (selected += delta) >= (max = this.levelBox.getItemCount())) {
            selected = max - 1;
        }
        if (selected < 0) {
            selected = 0;
        }
        this.levelBox.setSelectedIndex(selected);
    }

    public String getLevelsLabel() {
        return "Levels:";
    }

    @Override
    protected void initDisplayUnit() {
        if (this.getDisplayUnit() == null) {
            this.setDisplayUnit(this.getDefaultDistanceUnit());
        }
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.clearCursor();
        if (this.glyphs != null) {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                ((DrawingGlyph)this.glyphs.get(i)).setBeenRemoved(true);
            }
        }
        this.glyphs = null;
        this.selectedGlyphs = null;
        this.displayHolder = null;
        super.doRemove();
    }

    @Override
    protected void getLegendLabels(List labels, int legendType) {
        if (this.editorTitle != null && this.editorTitle.length() > 0) {
            labels.add(this.editorTitle);
        } else {
            super.getLegendLabels(labels, legendType);
        }
    }

    @Override
    public void removeGlyph(DrawingGlyph glyph) {
        glyph.setBeenRemoved(true);
        this.glyphs.remove(glyph);
        this.selectedGlyphs.remove(glyph);
        try {
            this.displayHolder.removeDisplayable(glyph.getDisplayable());
        }
        catch (Exception exc) {
            GridTrajectoryControl.logException("Removing glyph", exc);
        }
    }

    protected String getColorParamName() {
        return this.paramName;
    }

    void createTrajectoryControl() throws VisADException, RemoteException, Exception {
        FieldImpl w;
        Unit dUnit = ((FlatField)this.s.getSample(0)).getRangeUnits()[0][0];
        this.gridTrackControl.setDisplayUnit(dUnit);
        Unit rgUnit = ((FlatField)this.pw.getSample(0)).getRangeUnits()[0][0];
        if (Unit.canConvert(rgUnit, CommonUnits.METERS_PER_SECOND)) {
            w = this.pw;
        } else {
            FlatField pFI = DerivedGridFactory.createPressureGridFromDomain((FlatField)this.pw.getSample(0));
            FieldImpl hPI = DerivedGridFactory.convertPressureToHeight(pFI);
            w = DerivedGridFactory.convertPressureVelocityToHeightVelocity(this.pw, hPI, null);
        }
        Set timeSet = this.s.getDomainSet();
        int numTimes = timeSet.getLength();
        Unit timeUnit = timeSet.getSetUnits()[0];
        Unit paramUnit = ((FlatField)this.s.getSample(0)).getRangeUnits()[0][0];
        FunctionType rt = (FunctionType)((FlatField)this.s.getSample(0)).getType();
        String paramName = rt.getFlatRange().getRealComponents()[0].getName();
        double[] timeVals = timeSet.getDoubles()[0];
        SampledSet domain0 = GridUtil.getSpatialDomain(this.s);
        Gridded2DSet domain2D = GridUtil.makeDomain2D((GriddedSet)domain0);
        int skipFactor = (int)this.skipFactorWidget.getValue();
        if (skipFactor > 0) {
            GriddedSet domain1 = GridUtil.subsetDomain((GriddedSet)domain0, skipFactor, skipFactor, 1);
            domain2D = GridUtil.makeDomain2D(domain1);
        }
        double[] ttts = timeSet.getDoubles()[0];
        boolean normalizeLon = true;
        boolean isLatLon = GridUtil.isLatLonOrder(domain0);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        Real alt = null;
        alt = GridUtil.getAltitude(this.s, (Real)((TwoFacedObject)this.currentLevel).getId());
        float[][] geoVals = this.getEarthLocationPoints(latIndex, lonIndex, domain2D, alt);
        int numPoints = geoVals[0].length;
        List<GridTrajectory.TrajInfo> tj = GridTrajectory.calculateTrackPoints(this.u, this.v, w, this.s, ttts, geoVals, numPoints, numTimes, latIndex, lonIndex, true, normalizeLon, null, this.backwardTrajectory);
        int numParcels = numPoints;
        FunctionType ft = new FunctionType(RealType.Generic, new FunctionType(RealTupleType.SpatialEarth3DTuple, RealType.getRealType(paramName)));
        List<FlatField> tracks = GridTrajectory.createTracks(paramName, tj, timeSet, ft, paramUnit, numParcels);
        FlatField mergedTracks = DerivedGridFactory.mergeTracks(tracks);
        FunctionType fiType = new FunctionType(RealType.Time, mergedTracks.getType());
        DateTime endTime = new DateTime(timeVals[numTimes - 1], timeUnit);
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)mergedTracks, false);
        this.gridTrackControl.setData(fi);
        Range range = this.gridTrackControl.getGridDataInstance().getRange(this.gridTrackControl.getColorRangeIndex());
        this.gridTrackControl.setRange(range);
        Set[] rset = mergedTracks.getRangeSets();
        DoubleSet ds = (DoubleSet)rset[0];
        SetType st = (SetType)ds.getType();
        RealTupleType rtt = st.getDomain();
        RealType rt0 = rtt.getRealComponents()[0];
        super.setDataInstance(this.getDataInstance());
        this.gridTrackControl.selectRangeDisplay.setSelectRealType(rt0);
        this.paramName = paramName;
        this.controlPane.setVisible(true);
        this.controlPane.add(this.gridTrackControl.doMakeContents());
        Unit cUnit = this.getDisplayUnit();
        if (this.newUnit != null) {
            cUnit = this.newUnit;
        }
        this.gridTrackControl.displayUnitChanged(dUnit, cUnit);
        this.gridTrackControl.setNewDisplayUnit(cUnit, true);
        Range newRange = this.isBundle && this.bundleColorRange != null ? this.bundleColorRange : this.gridTrackControl.getColorRangeFromData();
        this.isBundle = false;
        this.gridTrackControl.setSelectRange(newRange);
        this.gridTrackControl.setRange(newRange);
    }

    void create2DTrajectoryControl() throws VisADException, RemoteException, Exception {
        SampledSet domain1;
        Unit dUnit = ((FlatField)this.s.getSample(0)).getRangeUnits()[0][0];
        this.gridTrackControl.setDisplayUnit(dUnit);
        Set timeSet = this.s.getDomainSet();
        int numTimes = timeSet.getLength();
        Unit timeUnit = timeSet.getSetUnits()[0];
        Unit paramUnit = ((FlatField)this.s.getSample(0)).getRangeUnits()[0][0];
        FunctionType rt = (FunctionType)((FlatField)this.s.getSample(0)).getType();
        String paramName = rt.getFlatRange().getRealComponents()[0].getName();
        double[] timeVals = timeSet.getDoubles()[0];
        SampledSet domain0 = GridUtil.getSpatialDomain(this.s);
        Gridded2DSet domain2D = GridUtil.makeDomain2D((GriddedSet)domain0);
        int skipFactor = (int)this.skipFactorWidget.getValue();
        if (skipFactor > 0) {
            domain1 = GridUtil.subsetDomain((GriddedSet)domain0, skipFactor, skipFactor, 1);
            domain2D = GridUtil.makeDomain2D((GriddedSet)domain1);
        }
        domain1 = GridUtil.getSpatialDomain(this.u);
        double[] ttts = timeSet.getDoubles()[0];
        boolean normalizeLon = true;
        boolean isLatLon = GridUtil.isLatLonOrder(domain0);
        int latIndex = isLatLon ? 0 : 1;
        int lonIndex = isLatLon ? 1 : 0;
        boolean haveAlt = true;
        if (domain0.getManifoldDimension() == 2 && domain1.getManifoldDimension() == 2) {
            this.is2DDC = true;
            haveAlt = false;
        }
        Real alt = null;
        if (!this.is2DDC) {
            alt = GridUtil.getAltitude(this.s, (Real)((TwoFacedObject)this.currentLevel).getId());
        }
        float[][] geoVals = this.getEarthLocationPoints(latIndex, lonIndex, domain2D, alt);
        int numPoints = geoVals[0].length;
        Real clevel = null;
        if (this.currentLevel instanceof Real) {
            clevel = (Real)this.currentLevel;
        } else if (this.currentLevel instanceof TwoFacedObject) {
            clevel = (Real)((TwoFacedObject)this.currentLevel).getId();
        }
        List<GridTrajectory.TrajInfo> tj = GridTrajectory.calculateTrackPoints(this.u, this.v, null, this.s, ttts, geoVals, numPoints, numTimes, latIndex, lonIndex, haveAlt, normalizeLon, clevel, this.backwardTrajectory);
        int numParcels = numPoints;
        FunctionType ft = new FunctionType(RealType.Generic, new FunctionType(RealTupleType.SpatialEarth3DTuple, RealType.getRealType(paramName)));
        List<FlatField> tracks = GridTrajectory.createTracks(paramName, tj, timeSet, ft, paramUnit, numParcels);
        FlatField mergedTracks = DerivedGridFactory.mergeTracks(tracks);
        FunctionType fiType = new FunctionType(RealType.Time, mergedTracks.getType());
        DateTime endTime = new DateTime(timeVals[numTimes - 1], timeUnit);
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)mergedTracks, false);
        this.gridTrackControl.setData(fi);
        Range range = this.gridTrackControl.getGridDataInstance().getRange(this.gridTrackControl.getColorRangeIndex());
        this.gridTrackControl.setRange(range);
        Set[] rset = mergedTracks.getRangeSets();
        DoubleSet ds = (DoubleSet)rset[0];
        SetType st = (SetType)ds.getType();
        RealTupleType rtt = st.getDomain();
        RealType rt0 = rtt.getRealComponents()[0];
        super.setDataInstance(this.getDataInstance());
        this.gridTrackControl.selectRangeDisplay.setSelectRealType(rt0);
        this.paramName = paramName;
        this.controlPane.setVisible(true);
        this.controlPane.add(this.gridTrackControl.doMakeContents());
        Unit cUnit = this.getDisplayUnit();
        if (this.newUnit != null) {
            cUnit = this.newUnit;
        }
        this.gridTrackControl.displayUnitChanged(dUnit, cUnit);
        this.gridTrackControl.setNewDisplayUnit(cUnit, true);
        Range newRange = this.isBundle && this.bundleColorRange != null ? this.bundleColorRange : this.gridTrackControl.getColorRangeFromData();
        this.isBundle = false;
        this.gridTrackControl.setSelectRange(newRange);
        this.gridTrackControl.setRange(newRange);
    }

    public float[][] getEarthLocationPoints(int latIndex, int lonIndex, SampledSet domain0, Real alt) throws Exception {
        double clevel = 0.0;
        if (this.currentLevel instanceof Real) {
            clevel = ((Real)this.currentLevel).getValue();
        } else if (this.currentLevel instanceof TwoFacedObject) {
            Object oj = ((TwoFacedObject)this.currentLevel).getId();
            clevel = ((Real)oj).getValue();
        }
        if (this.pressToHeightCS == null) {
            this.pressToHeightCS = DataUtil.getPressureToHeightCS("ucar.visad.quantities.AirPressure$StandardAtmosphereCoordinateSystem");
        }
        float z = this.is2DDC ? (float)clevel : (float)alt.getValue();
        if (this.currentCmd.getLabel().equals(GlyphCreatorCommand.CMD_SYMBOL.getLabel()) || this.glyphs.get(0) instanceof SymbolGlyph) {
            int pointNum = this.glyphs.size();
            float[][] points = new float[3][pointNum];
            for (int i = 0; i < pointNum; ++i) {
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                points[latIndex][i] = glyph.getLatLons()[0][0];
                points[lonIndex][i] = (float)LatLonPointImpl.lonNormal(glyph.getLatLons()[1][0]);
                points[2][i] = z;
            }
            this.setCurrentCommand(CMD_SELECT);
            this.hiddenBtn.doClick();
            return points;
        }
        if (this.glyphs.size() == 0) {
            return null;
        }
        Unit[] du = domain0.getSetUnits();
        MapMaker mapMaker = new MapMaker();
        for (DrawingGlyph glyph : this.glyphs) {
            float[][] lls = glyph.getLatLons();
            float[][] tmp = glyph.getLatLons();
            if (du[lonIndex].isConvertible(CommonUnit.radian)) {
                lls[1] = GeoUtils.normalizeLongitude(lls[1]);
            } else if (du[lonIndex].isConvertible(CommonUnits.KILOMETER)) {
                for (int i = 0; i < lls[1].length; ++i) {
                    lls[1][i] = (float)LatLonPointImpl.lonNormal(lls[1][i]);
                }
            }
            mapMaker.addMap(lls);
        }
        float[][][] latlons = GridUtil.findContainedLatLons((GriddedSet)domain0, mapMaker.getMaps());
        int num = 0;
        for (int i = 0; i < latlons.length; ++i) {
            num += latlons[i][0].length;
        }
        float[][] points = new float[3][num];
        int psize = 0;
        for (int k = 0; k < latlons.length; ++k) {
            int isize = latlons[k][0].length;
            for (int i = 0; i < isize; ++i) {
                points[latIndex][i + psize] = latlons[k][0][i];
                points[lonIndex][i + psize] = (float)LatLonPointImpl.lonNormal(latlons[k][1][i]);
                points[2][i + psize] = z;
            }
            psize += isize;
        }
        this.setCurrentCommand(CMD_SELECT);
        this.hiddenBtn.doClick();
        return points;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Controls", this.doMakeControlsPanel());
        return GuiUtils.centerBottom(tabbedPane, new JLabel(""));
    }

    @Override
    protected JComponent doMakeControlsPanel() {
        ArrayList widgets = new ArrayList();
        this.addControlWidgets(widgets);
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        JPanel comps = GuiUtils.doLayout(widgets, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        return GuiUtils.vbox((Component)comps, this.controlPane);
    }

    @Override
    protected void addControlWidgets(List widgets) {
        JPanel levelUpDown = GuiUtils.doLayout(new Component[]{this.levelUpBtn, this.levelDownBtn}, 1, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel levelSelector = GuiUtils.doLayout(new Component[]{this.levelBox, levelUpDown}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        JComponent widgets0 = GuiUtils.formLayout(new Component[]{this.levelLabel, GuiUtils.left(levelSelector)});
        JButton unloadBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Cut16.gif", this, "removeAllGlyphs");
        unloadBtn.setToolTipText("Remove existing glyphs and trajectories");
        this.msgLabel = new JLabel();
        if (this.createTrjBtnClicked) {
            this.isPoints = this.getIsPoints();
            if (this.isPoints) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_SYMBOL);
            } else if (this.isRectangle) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_RECTANGLE);
            } else if (this.isClosePlgn) {
                this.setCurrentCommand(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
            } else {
                this.setCurrentCommand(CMD_SELECT);
            }
        } else {
            this.setCurrentCommand(GlyphCreatorCommand.CMD_SYMBOL);
        }
        this.skipFactorWidget = new ValueSliderWidget(this, 0, 10, "skipValue", this.getSkipWidgetLabel());
        this.skipFactorWidget.setEnabled(false);
        this.addRemovable(this.skipFactorWidget);
        this.pointsBtn = new JRadioButton("Points:", this.isPoints);
        this.rectangleBtn = new JRadioButton("Rectangle:", this.isRectangle);
        this.closePolygonBtn = new JRadioButton("ClosePolygon:", this.isClosePlgn);
        this.hiddenBtn = new JRadioButton("ClosePolygon:", this.isSelector);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton source = (JRadioButton)e.getSource();
                GridTrajectoryControl.this.coordinateType = 3;
                if (source == GridTrajectoryControl.this.pointsBtn) {
                    GridTrajectoryControl.this.setCurrentCommand(GlyphCreatorCommand.CMD_SYMBOL);
                    GridTrajectoryControl.this.isPoints = true;
                    GridTrajectoryControl.this.isClosePlgn = false;
                    GridTrajectoryControl.this.isRectangle = false;
                    GridTrajectoryControl.this.isSelector = false;
                    GridTrajectoryControl.this.skipFactorWidget.setEnabled(false);
                    GridTrajectoryControl.this.removeAllGlyphs();
                } else if (source == GridTrajectoryControl.this.rectangleBtn) {
                    GridTrajectoryControl.this.setCurrentCommand(GlyphCreatorCommand.CMD_RECTANGLE);
                    GridTrajectoryControl.this.isRectangle = true;
                    GridTrajectoryControl.this.isPoints = false;
                    GridTrajectoryControl.this.isClosePlgn = false;
                    GridTrajectoryControl.this.isSelector = false;
                    GridTrajectoryControl.this.skipFactorWidget.setEnabled(true);
                    GridTrajectoryControl.this.removeAllGlyphs();
                } else if (source == GridTrajectoryControl.this.closePolygonBtn) {
                    GridTrajectoryControl.this.coordinateType = 1;
                    GridTrajectoryControl.this.setCurrentCommand(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
                    GridTrajectoryControl.this.isRectangle = false;
                    GridTrajectoryControl.this.isPoints = false;
                    GridTrajectoryControl.this.isSelector = false;
                    GridTrajectoryControl.this.isClosePlgn = true;
                    GridTrajectoryControl.this.skipFactorWidget.setEnabled(true);
                    GridTrajectoryControl.this.removeAllGlyphs();
                } else {
                    GridTrajectoryControl.this.setCurrentCommand(DrawingControl.CMD_SELECT);
                    GridTrajectoryControl.this.isSelector = true;
                    GridTrajectoryControl.this.isRectangle = false;
                    GridTrajectoryControl.this.isPoints = false;
                    GridTrajectoryControl.this.isClosePlgn = false;
                    GridTrajectoryControl.this.skipFactorWidget.setEnabled(false);
                }
                GridTrajectoryControl.this.setCoordType(GridTrajectoryControl.this.coordinateType);
            }
        };
        this.pointsBtn.addActionListener(listener);
        this.rectangleBtn.addActionListener(listener);
        this.closePolygonBtn.addActionListener(listener);
        this.hiddenBtn.addActionListener(listener);
        GuiUtils.buttonGroup(this.pointsBtn, this.rectangleBtn, this.closePolygonBtn, this.hiddenBtn);
        JPanel rightComp = GuiUtils.vbox(GuiUtils.left(this.pointsBtn), GuiUtils.left(this.closePolygonBtn), GuiUtils.left(this.rectangleBtn));
        this.backwardCbx = GuiUtils.makeCheckbox("", this, "backwardTrajectory");
        this.backwardCbx.setToolTipText("display the backward trajectory of air parcel");
        this.backwardCbx.setSelected(false);
        JLabel showLabel = GuiUtils.rLabel("Trajectory Initial Area:");
        JLabel removeLabel = GuiUtils.rLabel("Remove Trajectory Initial Area:");
        showLabel.setVerticalTextPosition(1);
        widgets.add(GuiUtils.topCenterBottom(widgets0, GuiUtils.topCenterBottom(GuiUtils.leftRight(GuiUtils.top(GuiUtils.inset((Component)showLabel, new Insets(10, 0, 0, 0))), GuiUtils.top(rightComp)), GuiUtils.top(GuiUtils.hbox(GuiUtils.rLabel("Initial Area Skip Factor:  "), this.skipFactorWidget.getContents(false))), GuiUtils.top(GuiUtils.hbox(GuiUtils.rLabel("Backward trajectory:"), GuiUtils.left(this.backwardCbx)))), GuiUtils.leftRight(GuiUtils.inset((Component)GuiUtils.wrap(this.createTrjBtn), 2), GuiUtils.right(unloadBtn))));
    }

    public void setBackwardTrajectory(boolean back) throws Exception {
        this.backwardTrajectory = back;
    }

    public boolean getBackwardTrajectory() throws Exception {
        return this.backwardTrajectory;
    }

    @Override
    protected boolean showLocationWidgets() {
        return true;
    }

    @Override
    public void applyColorToAll() {
        for (int i = 0; i < this.selectedGlyphs.size(); ++i) {
            ((DrawingGlyph)this.selectedGlyphs.get(i)).setColor(this.getColor());
        }
    }

    @Override
    public void setSkipValue(int value) {
        super.setSkipValue(value);
        if (this.skipFactorWidget != null) {
            this.skipFactorWidget.setValue(value);
        }
    }

    @Override
    public void removeAllGlyphs() {
        try {
            while (this.glyphs.size() > 0) {
                this.removeGlyph((DrawingGlyph)this.glyphs.get(0));
            }
            while (this.controlPane.getComponentCount() > 0) {
                this.controlPane.remove(0);
                this.controlPane.setVisible(false);
                if (this.gridTrackControl.trackDisplay != null) {
                    this.gridTrackControl.trackDisplay.setData(DUMMY_DATA);
                    this.gridTrackControl.indicator.setVisible(false);
                    this.gridTrackControl.timesHolder.setData(DUMMY_DATA);
                }
                this.createTrjBtnClicked = false;
            }
        }
        catch (Exception exc) {
            GridTrajectoryControl.logException("Removing drawings", exc);
        }
    }

    public void removeGC() {
        try {
            while (this.controlPane.getComponentCount() > 0) {
                this.controlPane.remove(0);
                this.controlPane.setVisible(false);
                if (this.gridTrackControl.trackDisplay == null) continue;
                this.gridTrackControl.trackDisplay.setData(DUMMY_DATA);
                this.gridTrackControl.indicator.setVisible(false);
                this.gridTrackControl.timesHolder.setData(DUMMY_DATA);
            }
        }
        catch (Exception exc) {
            GridTrajectoryControl.logException("Removing drawings", exc);
        }
    }

    private void clearCursor() {
        this.setCursor(null);
    }

    private void setCursor(int c) {
        this.setCursor(Cursor.getPredefinedCursor(c));
    }

    private void setCursor(Cursor c) {
        this.getViewManager().setCursorInDisplay(c);
    }

    @Override
    public int getCoordType() {
        return this.coordinateType;
    }

    public void setCurrentLevel(Object lvl) {
        this.currentLevel = lvl;
        this.bundleLevel = lvl;
    }

    public Object getCurrentLevel() {
        return this.currentLevel;
    }

    public DrawingCommand getCurrentCmd() {
        return this.currentCmd;
    }

    public void setCurrentCmd(String command) {
        this.currentCmd = command.contains(GlyphCreatorCommand.CMD_RECTANGLE.getLabel()) ? GlyphCreatorCommand.CMD_RECTANGLE : (command.contains(GlyphCreatorCommand.CMD_SYMBOL.getLabel()) ? GlyphCreatorCommand.CMD_SYMBOL : (command.contains(GlyphCreatorCommand.CMD_CLOSEDPOLYGON.getLabel()) ? GlyphCreatorCommand.CMD_CLOSEDPOLYGON : this.getCurrentCmd()));
    }

    @Override
    public void setColorScaleInfo(ColorScaleInfo newInfo) throws VisADException, RemoteException {
        if (newInfo == null) {
            this.colorScaleInfo = null;
            return;
        }
        if (this.gridTrackControl != null) {
            this.gridTrackControl.colorScaleInfo = new ColorScaleInfo(newInfo);
            this.gridTrackControl.applyColorScaleInfo();
        }
        this.colorScaleInfo = new ColorScaleInfo(newInfo);
        this.applyColorScaleInfo();
    }

    @Override
    public Range getRangeToApply() throws RemoteException, VisADException {
        return this.gridTrackControl.getRange();
    }

    @Override
    protected ColorTable getColorTableToApply() {
        return this.gridTrackControl.getColorTableToApply();
    }

    @Override
    public ColorScaleInfo getColorScaleInfo() {
        return this.colorScaleInfo;
    }

    public boolean getCreateTrjBtnClicked() {
        return this.createTrjBtnClicked;
    }

    public void setCreateTrjBtnClicked(boolean clicked) {
        this.createTrjBtnClicked = clicked;
    }

    public boolean getIsPoints() {
        return this.isPoints;
    }

    public void setIsPoints(boolean point) {
        this.isPoints = point;
    }

    public int getCoordinateType() {
        return this.coordinateType;
    }

    public void setCoordinateType(int type) {
        this.coordinateType = type;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        this.gridDataInstance = new GridDataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties(), null);
        return this.gridDataInstance;
    }

    public GridDataInstance getGridDataInstance() {
        if (this.gridDataInstance == null) {
            try {
                this.doMakeDataInstance(this.dataChoice);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.gridDataInstance;
    }

    public static class MyTrackControl
    extends TrackControl {
        private float markerScale = 1.0f;
        private Range lastRange;
        int trackWidth;
        GridTrajectoryControl gtc = null;
        FieldImpl trackGrid;

        public MyTrackControl(GridTrajectoryControl gtc) {
            this.setAttributeFlags(793);
            this.gtc = gtc;
            this.setUseTrackTimes(true);
            this.setTimeDeclutterEnabled(true);
        }

        public MyTrackControl() {
            this.setAttributeFlags(793);
            this.setUseTrackTimes(true);
            this.setTimeDeclutterEnabled(true);
        }

        @Override
        public boolean getHaveInitialized() {
            return true;
        }

        @Override
        protected int getTrackWidth() {
            if (this.gtc.createTrjBtnClicked) {
                return this.gtc.getTrackLineWidth();
            }
            return this.trackWidth;
        }

        @Override
        public void setLineWidth(int width) {
            super.setLineWidth(width);
            if (this.gtc != null) {
                this.gtc.setTrackLineWidth(width);
            }
        }

        @Override
        public void setDataTimeRange(DataTimeRange range) {
            if (range != super.getDataTimeRange()) {
                super.setDataTimeRange(range);
            }
            if (this.gtc != null && range != this.gtc.getTrjDataTimeRange()) {
                range.setStartOffsetMinutes(range.getStartOffsetMinutes());
                this.gtc.setTrjDataTimeRange(range);
            }
        }

        @Override
        public DataTimeRange getDataTimeRange() {
            if (this.gtc != null && this.gtc.getTrjDataTimeRange() != null) {
                return this.gtc.getTrjDataTimeRange();
            }
            return super.getDataTimeRange();
        }

        @Override
        public boolean getShowInLegend() {
            return false;
        }

        @Override
        public void setColorTable(ColorTable newColorTable) throws RemoteException, VisADException {
            if (newColorTable != super.getColorTable()) {
                super.setColorTable(newColorTable);
            }
            if (this.gtc != null && newColorTable != this.gtc.getTrjColorTable()) {
                this.gtc.setTrjColorTable(newColorTable);
            }
        }

        @Override
        public ColorTable getColorTable() {
            if (this.gtc != null && this.gtc.getTrjColorTable() != null) {
                return this.gtc.getTrjColorTable();
            }
            return super.getColorTable();
        }

        @Override
        public void setRange(Range nRange) throws RemoteException, VisADException {
            super.setRange(nRange);
            if (this.gtc != null && nRange != this.gtc.getTrjColorRange()) {
                this.gtc.setTrjColorRange(nRange);
            }
        }

        @Override
        public Range getRange() throws RemoteException, VisADException {
            if (this.gtc != null && this.gtc.getTrjColorRange() != null) {
                return this.gtc.getTrjColorRange();
            }
            return super.getRange();
        }

        protected boolean setData(FieldImpl fi) throws VisADException, RemoteException {
            if (this.trackDisplay == null) {
                return true;
            }
            this.trackGrid = fi;
            Unit newUnit = this.getDisplayUnit();
            this.setColorUnit(newUnit);
            if (newUnit != null && !newUnit.equals(this.getDisplayUnit()) && Unit.canConvert(newUnit, this.getRawDataUnit())) {
                this.trackDisplay.setDisplayUnit(newUnit);
                this.selectRangeDisplay.setDisplayUnit(newUnit);
            }
            FlatField ff = null;
            Object grid = null;
            if (this.trackDisplay != null) {
                this.trackDisplay.setData(DUMMY_DATA);
                this.indicator.setVisible(false);
                this.timesHolder.setData(DUMMY_DATA);
            }
            if (this.indicator != null) {
                this.indicator.setVisible(this.getMarkerVisible());
            }
            int len = fi.getLength();
            this.updateTimeSelectRange();
            ff = (FlatField)fi.getSample(0, false);
            this.trackDisplay.setTrack(ff);
            this.setTrackTimes();
            this.applyTimeRange();
            return true;
        }

        @Override
        public void applyTimeRange() {
            try {
                double endDate;
                GridDataInstance gridDataInstance;
                DataTimeRange dataTimeRange = this.getDataTimeRange();
                if (this.gtc != null) {
                    this.gtc.setTrjDataTimeRange(dataTimeRange);
                }
                if ((gridDataInstance = this.getGridDataInstance()) == null || dataTimeRange == null) {
                    return;
                }
                DateTime[] dts = gridDataInstance.getDateTimes();
                Unit dataTimeUnit = dts[0].getUnit();
                int size = dts.length;
                Real startReal = dts[0].getReal();
                Real endReal = dts[size - 1].getReal();
                Animation anime = this.getViewAnimation();
                Real aniValue = anime != null ? anime.getAniValue() : null;
                Real[] startEnd = this.getDataTimeRange().getTimeRange(startReal, endReal, aniValue);
                double startDate = startEnd[0].getValue(dataTimeUnit);
                if (!Misc.equals(this.lastRange, new Range(startDate, endDate = startEnd[1].getValue(dataTimeUnit)))) {
                    this.lastRange = new Range(startDate, endDate);
                    if (this.trackDisplay != null) {
                        this.trackDisplay.setSelectedRange(startDate, endDate);
                    }
                }
                double aniDate = aniValue != null && aniValue instanceof Real ? aniValue.getValue(dataTimeUnit) : endDate;
                DataTimeRange dtr = this.getDataTimeRange();
                dtr.setStartOffsetMinutes(this.getDataTimeRange().getStartOffsetMinutes());
                if (dtr != null && this.trackDisplay != null && this.getUseTrackTimes()) {
                    dtr.setEndMode(1);
                    this.trackDisplay.setSelectedRange(startDate, aniDate);
                }
            }
            catch (Exception e) {
                MyTrackControl.logException("applyTimeRange", e);
            }
        }

        private boolean trackDataOk() throws VisADException, RemoteException {
            DataInstance dataInstance = this.gtc.getDataInstance();
            return dataInstance != null && dataInstance.dataOk();
        }

        @Override
        public boolean isInitDone() {
            return true;
        }

        @Override
        protected boolean haveMultipleFields() {
            return false;
        }

        @Override
        protected FieldImpl getTrjGridDataInstance() {
            return this.trackGrid;
        }

        @Override
        public GridDataInstance getGridDataInstance() {
            return this.gtc.getGridDataInstance();
        }
    }
}

