/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.FlatFieldTable;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.TableNumberCellRenderer;
import ucar.unidata.util.GuiUtils;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.SampledSet;
import visad.Unit;
import visad.VisADException;

public class GridTableControl
extends GridDisplayControl {
    private FieldImpl field;
    private GuiUtils.CardLayoutPanel cardLayoutPanel = new GuiUtils.CardLayoutPanel();
    private JCheckBox nativeCoordsCbx;
    private boolean showNativeCoordinates = false;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init(dataChoice);
        this.setData(dataChoice);
        return true;
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            return false;
        }
        this.field = this.getGridDataInstance().getGrid();
        return true;
    }

    private void createTables() throws VisADException, RemoteException {
        ArrayList<DateTime> dates = new ArrayList<DateTime>();
        this.cardLayoutPanel.removeAll();
        if (GridUtil.isTimeSequence(this.field)) {
            SampledSet timeSet = (SampledSet)GridUtil.getTimeSet(this.field);
            double[][] times = timeSet.getDoubles(false);
            Unit timeUnit = timeSet.getSetUnits()[0];
            int numTimes = timeSet.getLength();
            for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
                DateTime dt = new DateTime(times[0][timeIdx], timeUnit);
                FlatField ff = (FlatField)this.field.getSample(timeIdx);
                if (ff == null) continue;
                dates.add(dt);
                FlatFieldTable table = new FlatFieldTable(ff, this.showNativeCoordinates);
                table.setDefaultRenderer(Number.class, new TableNumberCellRenderer());
                this.cardLayoutPanel.addCard(new JScrollPane(table));
            }
        } else {
            FlatFieldTable table = new FlatFieldTable((FlatField)this.field, this.showNativeCoordinates);
            table.setDefaultRenderer(Number.class, new TableNumberCellRenderer());
            this.cardLayoutPanel.addCard(new JScrollPane(table));
        }
        this.setAnimationSet(dates);
    }

    @Override
    public void timeChanged(Real time) {
        try {
            super.timeChanged(time);
            int current = this.getInternalAnimation(null).getCurrent();
            if (current >= 0) {
                this.cardLayoutPanel.show(current);
            }
        }
        catch (Exception exc) {
            GridTableControl.logException("Time changed", exc);
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.createTables();
        this.nativeCoordsCbx = new JCheckBox("Show native coordinates", this.getShowNativeCoordinates());
        this.nativeCoordsCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GridTableControl.this.showNativeCoordinates = GridTableControl.this.nativeCoordsCbx.isSelected();
                try {
                    GridTableControl.this.createTables();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Creating tables", exc);
                }
            }
        });
        return GuiUtils.topCenter(GuiUtils.leftRight(this.getAnimationWidget().getContents(), this.nativeCoordsCbx), this.cardLayoutPanel);
    }

    public void setShowNativeCoordinates(boolean value) {
        this.showNativeCoordinates = value;
    }

    public boolean getShowNativeCoordinates() {
        return this.showNativeCoordinates;
    }
}

