/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.idv.control.ContLevelDialog;
import ucar.unidata.idv.control.CrossSectionControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.RadarSweepControl;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.data.CalendarDateTime;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;

public abstract class GridDisplayControl
extends DisplayControlImpl {
    public static final String CMD_SETLEVELS = "cmd.setlevels";
    public static final String CMD_CONTOURDIALOG = "cmd.contourdialog";
    protected static LogUtil.LogCategory log_ = LogUtil.getLogInstance(GridDisplayControl.class.getName());
    protected boolean settingLevel = false;
    public static final String INITIAL_PROBE_EARTHLOCATION = "INITIAL_PROBE_EARTHLOCATION";
    private RealType topoType;
    protected GridDataInstance gridDataInstance;

    @Override
    protected boolean canDoProgressiveResolution() {
        return true;
    }

    public GridDataInstance getGridDataInstance() {
        return (GridDataInstance)this.getDataInstance();
    }

    protected Data getCursorReadoutData() throws Exception {
        return this.getData(this.getGridDataInstance());
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        Data data = this.getCursorReadoutData();
        if (data == null || !(data instanceof FieldImpl)) {
            return null;
        }
        FieldImpl field = (FieldImpl)data;
        if (field == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Real r = GridUtil.sampleToReal(field, el, animationValue, this.getSamplingModeValue(this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE)));
        if (r != null && !r.isMissing()) {
            result.add("<tr><td>" + this.getMenuLabel() + ":</td><td align=\"right\">" + this.formatForCursorReadout(r) + "</td></tr>");
        }
        return result;
    }

    @Override
    protected ColorTable getInitialColorTable() {
        return this.getDisplayConventions().getParamColorTable(this.getColorParamName());
    }

    protected boolean haveMultipleFields() {
        if (this.getGridDataInstance() == null) {
            return false;
        }
        return this.getGridDataInstance().getNumRealTypes() > 1;
    }

    @Override
    protected boolean isDisplayUnitAlsoColorUnit() {
        return !this.haveMultipleFields();
    }

    protected String getColorParamName() {
        if (this.haveMultipleFields() && this.getGridDataInstance() != null) {
            return this.getGridDataInstance().getDataChoice().getIndexedName(this.getColorRangeIndex());
        }
        return this.paramName;
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        Unit colorUnit = this.getColorUnit();
        Range range = this.getDisplayConventions().getParamRange(this.getColorParamName(), colorUnit);
        if (range != null || !this.haveMultipleFields()) {
            // empty if block
        }
        if (range == null && this.getGridDataInstance() != null) {
            range = this.getDataRangeInColorUnits();
        }
        return range;
    }

    protected Range getDataRangeInColorUnits() throws RemoteException, VisADException {
        if (this.getGridDataInstance() == null) {
            return null;
        }
        Unit colorUnit = this.getColorUnit();
        Range range = this.getGridDataInstance().getRange(this.getColorRangeIndex());
        Unit u = this.getGridDataInstance().getRawUnit(this.getColorRangeIndex());
        if (colorUnit != null && !Misc.equals(u, colorUnit) && Unit.canConvert(u, colorUnit)) {
            range = new Range(colorUnit.toThis(range.getMin(), u), colorUnit.toThis(range.getMax(), u));
        }
        return range;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        DataSelection ds = this.getDataSelection();
        Object t = ds.getProperty("Use_Progressive_Resolution");
        if (t != null) {
            this.isProgressiveResolution = (Boolean)t;
        }
        this.gridDataInstance = new GridDataInstance(dataChoice, ds, this.getRequestProperties());
        return this.gridDataInstance;
    }

    protected int getColorRangeIndex() {
        return 1;
    }

    @Override
    public Unit getRawDataUnit() {
        return this.getGridDataInstance() == null ? null : this.getGridDataInstance().getRawUnit(0);
    }

    protected ContourInfo getDefaultContourInfo() {
        return null;
    }

    protected void initializeDefaultContourInfo(ContourInfo contourInfo) {
    }

    @Override
    public ContourInfo getContourInfo() {
        ContourInfo contourInfo = super.getContourInfo();
        try {
            if (this.getControlContext() != null && this.getDisplayConventions() != null && contourInfo == null) {
                ContourInfo dflt = this.getDefaultContourInfo();
                contourInfo = this.getDisplayConventions().findDefaultContourInfo(this.paramName, null);
                if (contourInfo == null && this.getGridDataInstance() != null) {
                    contourInfo = this.getDisplayConventions().findContourInfo(this.paramName, this.getGridDataInstance().getRealType(0), this.getDisplayUnit(), this.getGridDataInstance().getRange(0), this.getDefaultContourInfo());
                }
                if (contourInfo != null) {
                    contourInfo.setLabelSize((int)this.getIdv().getStateManager().getPreferenceOrProperty("idv.contour.labelsize", 12.0));
                    contourInfo.setFont(ContLevelDialog.getContourFont(this.getIdv().getStateManager().getPreferenceOrProperty("idv.contour.labelfont")));
                    contourInfo.setAlignLabels(this.getIdv().getStateManager().getPreferenceOrProperty("idv.contour.alignlabel", true));
                }
                if (this.contourInfoParams != null) {
                    contourInfo.processParamString(this.contourInfoParams);
                }
                this.initializeDefaultContourInfo(contourInfo);
            }
        }
        catch (Exception exc) {
            GridDisplayControl.logException("setting contour info", exc);
        }
        return contourInfo;
    }

    @Override
    protected Unit getColorUnit() {
        Unit unit = super.getColorUnit();
        if (unit == null) {
            if (this.haveMultipleFields() && (unit = this.getDisplayConventions().getDisplayUnit(this.getColorParamName(), null)) == null && this.getGridDataInstance() != null) {
                unit = this.getGridDataInstance().getRawUnit(this.getColorRangeIndex());
            }
            if (unit == null) {
                unit = this.getDisplayUnit();
            }
            if (unit != null) {
                this.setUnitForColor(unit);
            }
        }
        return unit;
    }

    @Override
    public Unit getDisplayUnit() {
        Unit unit = super.getDisplayUnit();
        if (unit == null) {
            unit = this.getDisplayUnit(this.getRawDataUnit());
            this.setDisplayUnit(unit);
        }
        return unit;
    }

    public void setLevel(Object r) {
    }

    protected void setLevelFromUser(Object pl) throws VisADException, RemoteException {
        this.setLevel(pl);
    }

    @Override
    public Range getColorRangeFromData() {
        if (this.getGridDataInstance() != null) {
            return this.convertColorRange(this.getGridDataInstance().getRange(this.getColorRangeIndex()));
        }
        return null;
    }

    public Range convertColorRange(Range rawRange) {
        return this.convertColorRange(rawRange, this.getGridDataInstance().getRawUnit(this.getColorRangeIndex()));
    }

    public void setLevel(Object l, JComboBox levelBox) {
        if (!this.settingLevel) {
            this.settingLevel = true;
            if (levelBox != null) {
                levelBox.setSelectedItem(l);
            }
            this.settingLevel = false;
        }
    }

    public JButton doMakeContourLevelControl() {
        return GuiUtils.makeJButton("Contour", new Object[]{"-listener", this, "-tooltip", "Set contour levels", "-command", CMD_CONTOURDIALOG});
    }

    public JComboBox doMakeLevelControl() {
        Real[] levels = null;
        if (this.getGridDataInstance() != null) {
            Trace.call1("GDI.getLevels");
            levels = this.getGridDataInstance().getLevels();
            Trace.call2("GDI.getLevels");
        }
        return this.doMakeLevelControl(levels);
    }

    public JComboBox doMakeLevelControl(Object[] levels) {
        JComboBox<Object> box = levels != null ? new JComboBox<Object>(this.formatLevels(levels)) : new JComboBox();
        box.addActionListener(this);
        box.setEditable(true);
        box.setActionCommand(CMD_SETLEVELS);
        return box;
    }

    protected void addTopographyMap(int typeIndex) throws VisADException, RemoteException {
        NavigatedDisplay nd = this.getNavigatedDisplay();
        if (nd == null) {
            return;
        }
        if (this.topoType != null) {
            nd.removeVerticalMap(this.topoType);
        }
        this.topoType = this.getGridDataInstance().getRealType(typeIndex);
        nd.addVerticalMap(this.topoType);
    }

    protected void addTopographyMap(RealType type) throws VisADException, RemoteException {
        NavigatedDisplay nd = this.getNavigatedDisplay();
        if (nd == null) {
            return;
        }
        if (this.topoType != null) {
            nd.removeVerticalMap(this.topoType);
        }
        this.topoType = type;
        nd.addVerticalMap(this.topoType);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.getOkToFireEvents()) {
            return;
        }
        try {
            String cmd = event.getActionCommand();
            if (cmd.equals(CMD_SETLEVELS)) {
                if (this.settingLevel || !this.getHaveInitialized()) {
                    return;
                }
                final JComboBox box = (JComboBox)event.getSource();
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GridDisplayControl.this.setLevelFromBox(box);
                        }
                        catch (Exception exc) {
                            DisplayControlBase.logException("DisplayControl.actionPerformed", exc);
                        }
                    }
                });
                return;
            }
            super.actionPerformed(event);
        }
        catch (Exception exc) {
            GridDisplayControl.logException("DisplayControl.actionPerformed", exc);
        }
    }

    private void setLevelFromBox(JComboBox box) throws RemoteException, VisADException {
        Object levelValue = box.getSelectedItem();
        this.settingLevel = true;
        this.setLevelFromUser(levelValue);
        this.settingLevel = false;
    }

    @Override
    public MapProjection getDataProjection() {
        FieldImpl data;
        MapProjection mp = null;
        if (this.getGridDataInstance() != null && (data = this.getGridDataInstance().getGrid(false)) != null) {
            try {
                double[][] xy = null;
                mp = GridUtil.getNavigation(data);
                RealTupleType type = mp.getReference();
                if (mp instanceof TrivialMapProjection && type.getComponent(0).equals(RealType.Longitude) && type.getComponent(1).equals(RealType.Latitude) && mp.getDefaultMapArea().getX() > 180.0) {
                    Rectangle2D bounds = this.normalizeRectangle(mp.getDefaultMapArea());
                    mp = new TrivialMapProjection(mp.getReference(), bounds);
                }
            }
            catch (Exception e) {
                mp = null;
            }
        }
        return mp != null ? mp : super.getDataProjection();
    }

    public Rectangle2D normalizeRectangle(Rectangle2D bb) {
        if (bb == null) {
            return bb;
        }
        float x = (float)bb.getX();
        float y = (float)bb.getY();
        float width = (float)bb.getWidth();
        float height = (float)bb.getHeight();
        double normalizedMinLon = LatLonPointImpl.lonNormal(x);
        return new Rectangle2D.Float((float)normalizedMinLon, y, width, height);
    }

    @Override
    public void exportDisplayedData(String type) {
        if (!(this instanceof CrossSectionControl) && !(this instanceof RadarSweepControl)) {
            try {
                Data d = this.getDisplayedData();
                if (d == null) {
                    return;
                }
                if (d instanceof FieldImpl) {
                    JComboBox publishCbx = this.getIdv().getPublishManager().getSelector("nc.export");
                    String filename = FileManager.getWriteFile(FileManager.FILTER_NETCDF, ".nc", (JComponent)(publishCbx != null ? GuiUtils.top(publishCbx) : null));
                    if (filename == null) {
                        return;
                    }
                    GridUtil.exportGridToNetcdf((FieldImpl)d, filename);
                    this.getIdv().getPublishManager().publishContent(filename, null, publishCbx);
                }
            }
            catch (Exception e) {
                GridDisplayControl.logException("Unable to export the data", e);
            }
        } else {
            super.exportDisplayedData(type);
        }
    }

    @Override
    public void doExport(String what, String filename) throws Exception {
        if (what.contains("netcdf") && !(this instanceof CrossSectionControl) && !(this instanceof RadarSweepControl)) {
            try {
                Data d = this.getDisplayedData();
                if (d == null) {
                    return;
                }
                if (!filename.endsWith(".nc")) {
                    filename = filename + ".nc";
                }
                if (d instanceof FieldImpl) {
                    GridUtil.exportGridToNetcdf((FieldImpl)d, filename);
                }
            }
            catch (Exception e) {
                GridDisplayControl.logException("Unable to export the data", e);
            }
        }
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    protected String applyForecastHourMacro(String t, DateTime currentTime) {
        if (this.hasForecastHourMacro(t)) {
            String v = "";
            CalendarDateTime fTime = (CalendarDateTime)this.getDataChoice().getAllDateTimes().get(0);
            if (currentTime != null && fTime != null) {
                try {
                    double diff = currentTime.getValue(CommonUnit.secondsSinceTheEpoch) - fTime.getValue(CommonUnit.secondsSinceTheEpoch);
                    v = (int)(diff / 60.0 / 60.0) + "";
                }
                catch (Exception exc) {
                    System.err.println("Error:" + exc);
                    exc.printStackTrace();
                }
            }
            return t.replace("%fhour2%", v).replace("%fhour%", v + "H");
        }
        return t;
    }
}

