/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.SoundingDataNode;
import ucar.visad.functiontypes.AirTemperatureProfile;
import ucar.visad.functiontypes.CartesianHorizontalWindOfPressure;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.quantities.AirPressure;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.georef.LatLonPoint;

abstract class Grid3DSoundingDataNode
extends SoundingDataNode {
    private ProfileMaker tempMaker;
    private ProfileMaker dewMaker;
    private ProfileMaker windMaker;
    protected Field field;

    Grid3DSoundingDataNode(SoundingDataNode.Listener listener) throws VisADException, RemoteException {
        super(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setData(Data data) throws VisADException, RemoteException {
        Field grid3d = null;
        Boolean ensble = GridUtil.hasEnsemble((FieldImpl)data);
        if (ensble.booleanValue()) {
            FieldImpl sample = (FieldImpl)((FieldImpl)data).getSample(0);
            grid3d = (Field)sample.getSample(0, false);
        } else {
            grid3d = (Field)((Field)data).getSample(0);
        }
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            this.field = (Field)data;
            this.tempMaker = new ProfileMaker(AirTemperatureProfile.instance(), (Gridded3DSet)grid3d.getDomainSet(), grid3d.getDefaultRangeUnits()[0]);
            this.dewMaker = new ProfileMaker(this.tempMaker, DewPointProfile.instance(), grid3d.getDefaultRangeUnits()[1]);
            if (grid3d.getDefaultRangeUnits().length > 2) {
                this.windMaker = new ProfileMaker(this.tempMaker, CartesianHorizontalWindOfPressure.instance(), new Unit[]{grid3d.getDefaultRangeUnits()[2], grid3d.getDefaultRangeUnits()[3]});
            }
        }
        this.setField((Field)data);
        this.setOutputTimes();
        this.setOutputProfiles();
        this.setOutputTimeIndex();
        this.setOutputLocations();
    }

    void setField(Field field) throws VisADException, RemoteException {
    }

    abstract void setOutputTimeIndex() throws VisADException, RemoteException;

    abstract void setOutputProfiles() throws VisADException, RemoteException;

    final Field makeTempProfile(float[] values) throws VisADException, RemoteException {
        return this.tempMaker.makeProfile(values);
    }

    final Field makeDewProfile(float[] values) throws VisADException, RemoteException {
        return this.dewMaker.makeProfile(values);
    }

    final Field makeWindProfile(float[][] values) throws VisADException, RemoteException {
        return this.windMaker == null ? null : this.windMaker.makeProfile(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLocation(LatLonPoint loc) throws VisADException, RemoteException {
        if (loc == null) {
            throw new NullPointerException();
        }
        boolean notify = false;
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            if (!loc.equals(this.inLoc)) {
                this.inLoc = loc;
                notify = true;
            }
        }
        if (notify) {
            this.setOutputLocation();
            this.setOutputProfiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setTime(DateTime time) throws VisADException, RemoteException {
        if (time == null) {
            throw new NullPointerException();
        }
        boolean notify = false;
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            if (!time.equals(this.inTime)) {
                this.inTime = time;
                notify = true;
            }
        }
        if (notify) {
            this.setOutputTimeIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOutputTimes() throws VisADException, RemoteException {
        SampledSet times = null;
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            if (this.field != null) {
                times = (SampledSet)this.field.getDomainSet();
            }
        }
        if (times != null) {
            this.setOutputTimes(times);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOutputLocations() throws VisADException, RemoteException {
        SampledSet locs = null;
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            if (this.field != null) {
                locs = (SampledSet)((Field)this.field.getSample(0)).getDomainSet();
            }
        }
        if (locs != null) {
            this.setOutputLocations(locs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setOutputLocation() throws VisADException, RemoteException {
        LatLonPoint loc = null;
        Grid3DSoundingDataNode grid3DSoundingDataNode = this;
        synchronized (grid3DSoundingDataNode) {
            if (this.inLoc != null) {
                loc = this.inLoc;
            }
        }
        if (loc != null) {
            this.setOutputLocation(loc);
        }
    }

    private static final class ProfileMaker {
        private final Set outDom;
        private final Unit[] rangeUnits;
        private final FunctionType funcType;

        ProfileMaker(FunctionType funcType, Gridded3DSet inDom, Unit rangeUnit) throws VisADException, RemoteException {
            this(funcType, inDom, new Unit[]{rangeUnit});
        }

        ProfileMaker(FunctionType funcType, Gridded3DSet inDom, Unit[] rangeUnits) throws VisADException, RemoteException {
            if (funcType == null) {
                throw new NullPointerException();
            }
            this.funcType = funcType;
            float[] levelSamples = inDom.getSamples()[2];
            int xySize = inDom.getManifoldDimension() == 1 ? 1 : inDom.getLength(0) * inDom.getLength(1);
            int zSize = inDom.getManifoldDimension() == 1 ? inDom.getLength() : inDom.getLength(2);
            int numBad = 0;
            for (int i = 0; i < zSize; ++i) {
                if (levelSamples[i * xySize] == levelSamples[i * xySize]) continue;
                ++numBad;
            }
            float[] levs = new float[zSize - numBad];
            int j = 0;
            for (int i = 0; i < zSize; ++i) {
                if (levelSamples[i * xySize] != levelSamples[i * xySize]) continue;
                levs[j++] = levelSamples[i * xySize];
            }
            Object levels = new float[][]{levs};
            Unit verticalUnit = inDom.getSetUnits()[2];
            if (((SetType)inDom.getType()).getDomain().getComponent(2).equals(RealType.Altitude)) {
                levels = Set.doubleToFloat(AirPressure.getStandardAtmosphereCS().fromReference(Set.floatToDouble(levels), new Unit[]{verticalUnit}));
                verticalUnit = AirPressure.getStandardAtmosphereCS().getCoordinateSystemUnits()[0];
            }
            this.outDom = new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])levels, levels[0].length, null, new Unit[]{verticalUnit}, null);
            this.rangeUnits = rangeUnits;
        }

        ProfileMaker(ProfileMaker that, FunctionType funcType, Unit rangeUnit) {
            if (funcType == null) {
                throw new NullPointerException();
            }
            if (rangeUnit == null) {
                throw new NullPointerException();
            }
            this.outDom = that.outDom;
            this.rangeUnits = new Unit[]{rangeUnit};
            this.funcType = funcType;
        }

        ProfileMaker(ProfileMaker that, FunctionType funcType, Unit[] rangeUnits) {
            if (funcType == null) {
                throw new NullPointerException();
            }
            if (rangeUnits == null) {
                throw new NullPointerException();
            }
            this.outDom = that.outDom;
            this.rangeUnits = rangeUnits;
            this.funcType = funcType;
        }

        Field makeProfile(float[] values) throws VisADException, RemoteException {
            FlatField field = new FlatField(this.funcType, this.outDom, (CoordinateSystem[])null, (Set[])null, this.rangeUnits);
            field.setSamples(new float[][]{values});
            return field;
        }

        Field makeProfile(float[][] values) throws VisADException, RemoteException {
            FlatField field = new FlatField(CartesianHorizontalWindOfPressure.instance(), this.outDom, (CoordinateSystem[])null, (Set[])null, this.rangeUnits);
            field.setSamples(values);
            return field;
        }
    }
}

