/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.ShapeUtility;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.PointProbe;
import ucar.visad.display.TextDisplayable;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;

public class Grid2DReadoutProbe
extends GridDisplayControl {
    public static final String SHARE_PROFILE = "LineProbeControl.SHARE_PROFILE";
    protected PointProbe probe;
    private RealTuple initPosition;
    private String marker;
    private float pointSize = 1.0f;
    protected String positionText;
    private static final TupleType TUPTYPE = Grid2DReadoutProbe.makeTupleType();
    private DataReference positionRef = null;
    private Color currentColor = Color.MAGENTA;
    private RealTuple currentPosition = null;
    private Tuple locationValue = null;
    private TextDisplayable valueDisplay = null;
    private FlatField image = null;
    private RealTupleType earthTupleType = null;
    private boolean isLonLat = true;
    private DisplayMaster master;
    private DecimalFormat numFmt;

    public Grid2DReadoutProbe(FlatField grid2d, DisplayMaster master) throws VisADException, RemoteException {
        this.earthTupleType = Grid2DReadoutProbe.check2DEarthTuple(grid2d);
        if (this.earthTupleType != null) {
            this.isLonLat = this.earthTupleType.equals(RealTupleType.SpatialEarth2DTuple);
        }
        this.setAttributeFlags(4);
        this.initSharable();
        this.currentPosition = new RealTuple(RealTupleType.Generic2D);
        this.positionRef = new DataReferenceImpl(this.hashCode() + "_positionRef");
        this.valueDisplay = Grid2DReadoutProbe.createValueDisplayer(this.currentColor);
        this.image = grid2d;
        this.master = master;
        master.addDisplayable(this.valueDisplay);
        this.setSharing(true);
        master.getDisplay().addDisplayListener(new DisplayListener(){

            @Override
            public void displayChanged(DisplayEvent de) {
                if (de.getId() == 7) {
                    try {
                        RealTuple position = Grid2DReadoutProbe.this.getPosition();
                        Grid2DReadoutProbe.this.doShare((Object)"DisplayControlImpl.SHARE_POSITION", position);
                    }
                    catch (Exception e) {
                        DisplayControlBase.logException("doMoveProfile", e);
                    }
                }
            }
        });
        this.numFmt = new DecimalFormat();
        this.numFmt.setMaximumFractionDigits(2);
    }

    public void doMakeProbe() throws VisADException, RemoteException {
        this.doMakeProbe(this.getColor());
    }

    public void doMakeProbe(Color c) throws VisADException, RemoteException {
    }

    public void doMakeProbe(ViewDescriptor view) throws VisADException, RemoteException {
    }

    public void doMakeProbe(Color probeColor, DisplayMaster master) throws VisADException, RemoteException {
        this.probe = null;
        this.probe = this.initPosition != null ? new PointProbe(this.initPosition) : new PointProbe(this.getInitialLinePosition());
        this.initPosition = this.probe.getPosition();
        this.probe.setColor(probeColor);
        this.probe.setVisible(true);
        this.probe.addPropertyChangeListener(this);
        this.probe.setPointSize(1.0f);
        if (this.marker != null) {
            // empty if block
        }
        this.probe.setAutoSize(true);
        master.addDisplayable(this.probe);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            this.doMoveProbe();
        } else {
            super.propertyChange(evt);
        }
    }

    public void resetProbePosition() {
        try {
            this.setProbePosition(0.0, 0.0);
        }
        catch (Exception exc) {
            Grid2DReadoutProbe.logException("Resetting probe position", exc);
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (this.probe != null) {
            JMenuItem mi = new JMenuItem("Reset Probe Position");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Grid2DReadoutProbe.this.resetProbePosition();
                }
            });
            items.add(mi);
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    public void setProbePosition(RealTuple xy) throws VisADException, RemoteException {
        this.probe.setPosition(xy);
    }

    public void setProbePosition(double x, double y) throws VisADException, RemoteException {
        this.setProbePosition(new RealTuple(new Real[]{new Real(RealType.XAxis, x), new Real(RealType.YAxis, y)}));
    }

    public void setPosition(RealTuple p) {
        this.initPosition = p;
    }

    public RealTuple getPosition() throws VisADException, RemoteException {
        return this.probe != null ? this.probe.getPosition() : null;
    }

    public RealTuple getInitialPosition() {
        return this.initPosition;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals("DisplayControlImpl.SHARE_POSITION")) {
            if (this.probe == null) {
                return;
            }
            try {
                this.probe.setPosition((RealTuple)data[0]);
                this.probePositionChanged(this.getPosition());
            }
            catch (Exception e) {
                Grid2DReadoutProbe.logException("receiveShareData:" + dataId, e);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    protected void doMoveProbe() {
        try {
            RealTuple position = this.getPosition();
            this.probePositionChanged(position);
        }
        catch (Exception e) {
            Grid2DReadoutProbe.logException("doMoveProfile", e);
        }
    }

    protected void probePositionChanged(RealTuple newPos) {
        if (!this.currentPosition.equals(newPos)) {
            this.updatePosition(newPos);
            this.updateLocationValue();
            this.currentPosition = newPos;
        }
    }

    protected void updatePosition(RealTuple position) {
        double[] vals = position.getValues();
        try {
            EarthLocationTuple elt = (EarthLocationTuple)this.boxToEarth(new double[]{vals[0], vals[1], 1.0});
            this.positionRef.setData(elt.getLatLonPoint());
        }
        catch (Exception e) {
            LogUtil.logException("HydraImageProbe.updatePosition", e);
        }
    }

    private void updateLocationValue() {
        Tuple tup = null;
        try {
            RealTuple location = (RealTuple)this.positionRef.getData();
            if (location == null) {
                return;
            }
            if (this.image == null) {
                return;
            }
            double[] vals = location.getValues();
            if (vals[1] < -180.0) {
                vals[1] = vals[1] + 360.0;
            }
            if (vals[1] > 180.0) {
                vals[1] = vals[1] - 360.0;
            }
            if (this.earthTupleType != null) {
                RealTuple lonLat = new RealTuple(RealTupleType.SpatialEarth2DTuple, new double[]{vals[1], vals[0]});
                RealTuple latLon = new RealTuple(RealTupleType.LatitudeLongitudeTuple, new double[]{vals[0], vals[1]});
                RealTuple rtup = lonLat;
                if (!this.isLonLat) {
                    rtup = latLon;
                }
                Real val = null;
                Data dat = this.image.evaluate(rtup, 100, 202);
                if (((FunctionType)this.image.getType()).getRange() instanceof RealTupleType) {
                    RealTuple tmp = (RealTuple)dat;
                    val = tmp.getRealComponents()[0];
                } else {
                    val = (Real)dat;
                }
                float fval = (float)val.getValue();
                tup = new Tuple(TUPTYPE, new Data[]{lonLat, new Text(TextType.Generic, this.numFmt.format(fval))});
            }
            this.valueDisplay.setData(tup);
        }
        catch (Exception e) {
            LogUtil.logException("HydraImageProbe.updateLocationValue", e);
        }
        if (tup != null) {
            this.locationValue = tup;
        }
    }

    @Override
    public NavigatedDisplay getNavigatedDisplay() {
        return (NavigatedDisplay)this.master;
    }

    public static RealTupleType check2DEarthTuple(FlatField field) {
        RealTupleType ref;
        FunctionType ftype = (FunctionType)field.getType();
        RealTupleType domain = ftype.getDomain();
        if (domain.equals(RealTupleType.SpatialEarth2DTuple) || domain.equals(RealTupleType.LatitudeLongitudeTuple)) {
            return domain;
        }
        CoordinateSystem cs = domain.getCoordinateSystem();
        if (cs != null && ((ref = cs.getReference()).equals(RealTupleType.SpatialEarth2DTuple) || ref.equals(RealTupleType.LatitudeLongitudeTuple))) {
            return ref;
        }
        return null;
    }

    private static TextDisplayable createValueDisplayer(Color color) throws VisADException, RemoteException {
        DecimalFormat fmt = new DecimalFormat();
        fmt.setMaximumIntegerDigits(3);
        fmt.setMaximumFractionDigits(1);
        TextDisplayable td = new TextDisplayable(TextType.Generic);
        td.setLineWidth(2.0f);
        td.setColor(color);
        td.setTextSize(1.75f);
        return td;
    }

    private static TupleType makeTupleType() {
        TupleType t = null;
        try {
            t = new TupleType(new MathType[]{RealTupleType.SpatialEarth2DTuple, TextType.Generic});
        }
        catch (Exception e) {
            LogUtil.logException("HydraImageProbe.makeTupleType", e);
        }
        return t;
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        try {
            this.probePositionChanged(this.getPosition());
        }
        catch (Exception exc) {
            Grid2DReadoutProbe.logException("projectionChanged", exc);
        }
    }

    public JMenu doMakeProbeMenu(JMenu probeMenu) {
        JMenu posMenu = new JMenu("Position");
        probeMenu.add(posMenu);
        posMenu.add(GuiUtils.makeMenuItem("Reset Probe Position", this, "resetProbePosition"));
        JMenu sizeMenu = new JMenu("Size");
        probeMenu.add(sizeMenu);
        sizeMenu.add(GuiUtils.makeMenuItem("Increase", this, "increaseProbeSize"));
        sizeMenu.add(GuiUtils.makeMenuItem("Decrease", this, "decreaseProbeSize"));
        JMenu shapeMenu = new JMenu("Probe Shape");
        probeMenu.add(shapeMenu);
        for (int i = 0; i < ShapeUtility.SHAPES.length; ++i) {
            TwoFacedObject tof = ShapeUtility.SHAPES[i];
            String lbl = tof.toString();
            if (Misc.equals(tof.getId(), this.marker)) {
                lbl = ">" + lbl;
            }
            JMenuItem mi = GuiUtils.makeMenuItem(lbl, this, "setMarker", tof.getId());
            shapeMenu.add(mi);
        }
        GuiUtils.limitMenuSize(shapeMenu, "Shape Group ", 10);
        return probeMenu;
    }

    public void increaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        this.pointSize = this.probe.getPointScale();
        this.setPointSize(this.pointSize + this.pointSize * 0.5f);
    }

    public void decreaseProbeSize() {
        if (this.probe == null) {
            return;
        }
        this.pointSize = this.probe.getPointScale();
        this.pointSize -= this.pointSize * 0.5f;
        if (this.pointSize < 0.1f) {
            this.pointSize = 0.1f;
        }
        this.setPointSize(this.pointSize);
    }

    @Override
    public void setPointSize(float value) {
        this.pointSize = value;
        if (this.probe != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setPointSize(this.pointSize);
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                Grid2DReadoutProbe.logException("Increasing probe size", exc);
            }
        }
    }

    @Override
    public float getPointSize() {
        return this.pointSize;
    }

    public RealTuple getGridCenterPosition() throws VisADException, RemoteException {
        LatLonPoint rt;
        RealTuple xyz;
        RealTuple pos = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{0.0, 0.0});
        if (this.getGridDataInstance() != null && (xyz = this.earthToBoxTuple(new EarthLocationTuple(rt = GridUtil.getCenterLatLonPoint(this.getGridDataInstance().getGrid()), new Real(RealType.Altitude, 0.0)))) != null) {
            pos = new RealTuple(new Real[]{(Real)xyz.getComponent(0), (Real)xyz.getComponent(1)});
        }
        return pos;
    }

    public RealTuple getInitialLinePosition() throws VisADException, RemoteException {
        double[] center = new double[]{0.0, 0.0};
        return new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{center[0], center[1]});
    }

    public void setMarker(String value) {
        this.marker = value;
        if (this.probe != null && this.marker != null) {
            try {
                this.probe.setAutoSize(false);
                this.probe.setAutoSize(true);
            }
            catch (Exception exc) {
                Grid2DReadoutProbe.logException("Setting marker", exc);
            }
        }
    }

    public String getMarker() {
        return this.marker;
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%position%"));
        labels.addAll(Misc.newList("Probe Position"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add("%position%");
        values.add(this.positionText);
    }

    @Override
    protected void updateLegendLabel() {
        super.updateLegendLabel();
        String template = this.getDisplayListTemplate();
        if (template.contains("%position%")) {
            this.updateDisplayList();
        }
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add(this.positionText);
    }
}

