/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ucar.unidata.idv.control.FlowDisplayControl;
import ucar.unidata.idv.control.TimeHeightControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.display.WindBarbDisplayable;
import visad.CommonUnit;
import visad.FieldImpl;
import visad.RealTuple;
import visad.VisADException;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class FlowTimeHeightControl
extends TimeHeightControl
implements FlowDisplayControl {
    private int skipValue = 0;
    JComponent barbSizeBox;
    boolean isStreamlines = false;
    boolean isWindBarbs = false;
    boolean isThreeComponents = false;
    protected final float scaleFactor = 0.02f;
    float flowScaleValue = 2.0f;

    public FlowTimeHeightControl() {
        this.setAttributeFlags(4);
    }

    @Override
    public String getColorWidgetLabel() {
        return "Color";
    }

    FlowDisplayable getGridDisplay() {
        return (FlowDisplayable)this.getDataDisplay();
    }

    @Override
    protected DisplayableData createDataDisplay() throws VisADException, RemoteException {
        FlowDisplayable dataDisplay;
        if (this.isWindBarbs) {
            dataDisplay = new WindBarbDisplayable("wb_color_" + this.paramName, null);
        } else {
            dataDisplay = new FlowDisplayable("wv_color_" + this.paramName, null);
            dataDisplay.setStreamlinesEnabled(this.isStreamlines);
        }
        dataDisplay.setAdjustFlow(false);
        this.addAttributedDisplayable(dataDisplay);
        return dataDisplay;
    }

    @Override
    public void initDone() {
        super.initDone();
        this.setFlowScale(this.flowScaleValue);
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        this.barbSizeBox = GuiUtils.createValueBox(this, "cmd.barbsize", (int)this.flowScaleValue, Misc.createIntervalList(0, 10, 1), true);
        JPanel extra = GuiUtils.hbox(this.barbSizeBox, GuiUtils.filler());
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Vector size: "), extra));
        this.enableBarbSizeBox();
        super.getControlWidgets(controlWidgets);
    }

    @Override
    protected int getDataDisplayFlags() {
        return 32;
    }

    private void enableBarbSizeBox() {
        this.barbSizeBox.setEnabled(!this.isStreamlines);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        try {
            if (cmd.equals("cmd.barbsize")) {
                this.setFlowScale(GuiUtils.getBoxValue((JComboBox)e.getSource()));
            } else {
                super.actionPerformed(e);
            }
        }
        catch (NumberFormatException nfe) {
            this.userErrorMessage("Incorrect number format");
        }
    }

    public void setStreamlines(boolean v) {
        this.isStreamlines = v;
    }

    public boolean getStreamlines() {
        return this.isStreamlines;
    }

    public void setWindbarbs(boolean v) {
        this.isWindBarbs = v;
    }

    public boolean getWindbarbs() {
        return this.isWindBarbs;
    }

    public void setIsThreeComponents(boolean v) {
        this.isThreeComponents = v;
    }

    public boolean getIsThreeComponents() {
        return this.isThreeComponents;
    }

    public void setScaleFactor(float s) {
    }

    public float getFlowScale() {
        return this.flowScaleValue;
    }

    public void setFlowScale(float f) {
        this.flowScaleValue = f;
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setFlowScale(this.flowScaleValue * 0.02f);
        }
    }

    @Override
    public void loadProfile(RealTuple position) throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        if (position == null) {
            return;
        }
        LatLonPoint llp = this.getPositionLL(position);
        int orient = llp.getLatitude().getValue(CommonUnit.degree) > 0.0 ? 0 : 1;
        ((FlowDisplayable)this.getDataDisplay()).setBarbOrientation(orient);
        super.loadProfile((LatLonTuple)llp);
    }

    @Override
    protected void displayTHForCoord(FieldImpl fi, int NN) throws VisADException, RemoteException {
        ((FlowDisplayable)this.getDataDisplay()).loadData(fi);
    }
}

