/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.grid.DerivedGridFactory;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.FlowDisplayControl;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.ThreeDSize;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.display.WindBarbDisplayable;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.Real;
import visad.RealTuple;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;

public class FlowPlanViewControl
extends PlanViewControl
implements FlowDisplayControl {
    ValueSliderWidget barbSizeWidget;
    JComponent sizeComponent;
    ValueSliderWidget trajLengthWidget;
    JComponent trajLengthComponent;
    ValueSliderWidget cvectorLengthWidget;
    JComponent cvectorLengthComponent;
    ValueSliderWidget vectorAHSizeWidget;
    ValueSliderWidget skipFactorWidget;
    JComponent densityComponent;
    JSlider densitySlider;
    JLabel flowRangeLabel;
    private JLabel densityLabel;
    private JRadioButton streamlinesBtn;
    private JRadioButton vectorBtn;
    private JRadioButton trajectoryBtn;
    private JRadioButton cvectorBtn;
    boolean isStreamlines = false;
    boolean isVectors = true;
    boolean isTrajectories = false;
    boolean isCVectors = false;
    boolean isWindBarbs = false;
    boolean isThreeComponents = false;
    boolean autoSize = false;
    boolean arrowHead = false;
    protected final float scaleFactor = 0.02f;
    float flowScaleValue = 4.0f;
    float vectorLengthValue = 2.0f;
    float arrowHeadSizeValue = 1.0f;
    float trajOffsetValue = 4.0f;
    float streamlineDensity = 1.0f;
    private JComponent[] widthSliderComps;
    private Range flowRange;
    RangeDialog rangeDialog;
    private boolean useSpeedForColor = false;
    private boolean coloredByAnother = false;
    private int colorIndex = -1;
    JCheckBox arrowCbx;
    JComboBox trajFormBox;
    private static final String[] trajFormLabels = new String[]{"Line", "Ribbon", "Cylinder", "Deform Ribbon"};
    private static final int[] trajForm = new int[]{0, 1, 2, 3};
    JComponent trajFormComponent;
    private Integer trajFormType = new Integer(0);
    private Range flowColorRange;
    public static final String MACRO_MAXSPEED = "%maxspeed%";
    String maxspeedString = null;

    public FlowPlanViewControl() {
        this.setAttributeFlags(1028);
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        this.setFlowScale(this.flowScaleValue);
    }

    @Override
    public String getColorWidgetLabel() {
        return "Color";
    }

    FlowDisplayable getGridDisplay() {
        return (FlowDisplayable)this.getPlanDisplay();
    }

    @Override
    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        FlowDisplayable planDisplay;
        if (this.isWindBarbs) {
            planDisplay = new WindBarbDisplayable("FlowPlanViewControl_windbarbs_" + (this.datachoice != null ? this.datachoice.toString() : ""), null);
        } else {
            planDisplay = new FlowDisplayable("FlowPlanViewControl_vectors_" + (this.datachoice != null ? this.datachoice.toString() : ""), null);
            if (this.getMultipleIsTopography()) {
                planDisplay.setIgnoreExtraParameters(true);
            }
            planDisplay.set3DFlow(true);
        }
        planDisplay.setUseSpeedForColor(this.useSpeedForColor);
        planDisplay.setColoredByAnother(this.coloredByAnother);
        planDisplay.setStreamlinesEnabled(this.isStreamlines);
        planDisplay.setStreamlineDensity(this.streamlineDensity);
        planDisplay.setAutoScale(this.autoSize);
        if (this.isCVectors) {
            planDisplay.setTrojectoriesEnabled(this.isCVectors, this.arrowHeadSizeValue, true);
        } else {
            planDisplay.setTrojectoriesEnabled(this.isTrajectories, this.arrowHeadSizeValue, false);
        }
        this.addAttributedDisplayable(planDisplay);
        return planDisplay;
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        DerivedDataChoice ddc;
        List choices0;
        Trace.call1("FlowPlanView.setData");
        if (dataChoice instanceof DerivedDataChoice && (choices0 = (ddc = (DerivedDataChoice)dataChoice).getChoices()).size() == 3 && choices0.get(0) instanceof DirectDataChoice) {
            DirectDataChoice udc = (DirectDataChoice)choices0.get(0);
            DirectDataChoice vdc = (DirectDataChoice)choices0.get(1);
            DirectDataChoice wdc = (DirectDataChoice)choices0.get(2);
            ThreeDSize us = (ThreeDSize)udc.getProperty("prop.gridsize");
            ThreeDSize ws = (ThreeDSize)wdc.getProperty("prop.gridsize");
            if (us.getSizeZ() != ws.getSizeZ()) {
                this.userErrorMessage("Grid sizes are different: " + ws + "\n from " + us);
                return false;
            }
        }
        FlowDisplayable fd = this.getGridDisplay();
        fd.setActive(false);
        boolean result = super.setData(dataChoice);
        if (this.getDisplayName().contains("Colored by Another") && this.coloredByAnother) {
            this.colorIndex = 2;
        }
        if (!result) {
            Trace.call2("FlowPlanView.setData");
            return false;
        }
        if (!this.getWindbarbs()) {
            this.setFlowRange();
        }
        if (!this.useSpeedForColor) {
            boolean bl = this.useSpeedForColor = !fd.isCartesianWind();
        }
        if (this.useSpeedForColor) {
            this.colorIndex = 2;
        }
        if (this.isTrajectories) {
            fd.setTrajFormType(this.getTrajFormType());
        }
        this.setFlowScale(this.flowScaleValue);
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setArrowHead(this.arrowHead);
            this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
            this.getGridDisplay().setVectorLength(this.vectorLengthValue);
            this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
        }
        fd.setActive(true);
        Trace.call2("FlowPlanView.setData");
        return true;
    }

    public void setColoredByAnother(boolean yesno) {
        this.coloredByAnother = yesno;
    }

    public boolean getColoredByAnother() {
        return this.coloredByAnother;
    }

    public void setUseSpeedForColor(boolean yesno) {
        this.useSpeedForColor = yesno;
    }

    public boolean getUseSpeedForColor() {
        return this.useSpeedForColor;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        List dchoices;
        this.skipFactorWidget = new ValueSliderWidget(this, 0, 10, "skipValue", this.getSkipWidgetLabel());
        this.addRemovable(this.skipFactorWidget);
        this.barbSizeWidget = new ValueSliderWidget(this, 1, 21, "flowScale", "Size");
        this.addRemovable(this.barbSizeWidget);
        JCheckBox autoSizeCbx = new JCheckBox("Autosize", this.autoSize);
        this.arrowCbx = new JCheckBox("Arrow", this.arrowHead);
        autoSizeCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPlanViewControl.this.autoSize = ((JCheckBox)e.getSource()).isSelected();
                FlowPlanViewControl.this.getGridDisplay().setAutoScale(FlowPlanViewControl.this.autoSize);
            }
        });
        this.arrowCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlowPlanViewControl.this.arrowHead = ((JCheckBox)e.getSource()).isSelected();
                FlowPlanViewControl.this.getGridDisplay().setArrowHead(FlowPlanViewControl.this.arrowHead);
                FlowPlanViewControl.this.getGridDisplay().resetTrojectories();
            }
        });
        this.sizeComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Size: "), (Component)this.barbSizeWidget.getContents(false), autoSizeCbx);
        if (!this.getIsThreeComponents()) {
            this.streamlinesBtn = new JRadioButton("Streamlines:", this.isStreamlines);
            this.vectorBtn = new JRadioButton(this.isWindBarbs ? "Wind Barbs:" : "Vectors:", this.isVectors);
            this.trajLengthWidget = new ValueSliderWidget(this, 1, 21, "trajOffset", "LengthOffset");
            List trajFormList = TwoFacedObject.createList(trajForm, trajFormLabels);
            this.trajFormBox = new JComboBox();
            GuiUtils.setListData(this.trajFormBox, trajFormList);
            this.trajFormBox.setSelectedItem(TwoFacedObject.findId(this.getTrajFormType(), trajFormList));
            this.trajFormBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                    FlowPlanViewControl.this.setTrajFormType(select.getId().hashCode());
                }
            });
            this.trajFormComponent = GuiUtils.hbox((Component)GuiUtils.rLabel("Trajecotry Form: "), GuiUtils.filler(), (Component)this.trajFormBox, GuiUtils.filler());
            this.trajLengthComponent = GuiUtils.hbox((Component)this.trajFormComponent, (Component)GuiUtils.rLabel("Length Offset: "), (Component)this.trajLengthWidget.getContents(false), this.arrowCbx);
            this.cvectorLengthWidget = new ValueSliderWidget(this, 1, 21, "VectorLength", "Curly Vector Length");
            this.cvectorLengthComponent = GuiUtils.hbox(GuiUtils.rLabel("Vector Length: "), this.cvectorLengthWidget.getContents(false));
            this.trajectoryBtn = new JRadioButton("Trajectories:", this.isTrajectories);
            this.cvectorBtn = new JRadioButton("Curly Vectors:", this.isCVectors);
            this.trajectoryBtn.setToolTipText("Require mininmum four time steps for this display");
            this.cvectorBtn.setToolTipText("Require mininmum four time steps for this display");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JRadioButton source = (JRadioButton)e.getSource();
                    if (source == FlowPlanViewControl.this.streamlinesBtn) {
                        FlowPlanViewControl.this.isStreamlines = true;
                        FlowPlanViewControl.this.isVectors = false;
                        FlowPlanViewControl.this.isTrajectories = false;
                        FlowPlanViewControl.this.isCVectors = false;
                    } else if (source == FlowPlanViewControl.this.trajectoryBtn) {
                        FlowPlanViewControl.this.isTrajectories = true;
                        FlowPlanViewControl.this.isStreamlines = false;
                        FlowPlanViewControl.this.isVectors = false;
                        FlowPlanViewControl.this.isCVectors = false;
                    } else if (source == FlowPlanViewControl.this.cvectorBtn) {
                        FlowPlanViewControl.this.isCVectors = true;
                        FlowPlanViewControl.this.isTrajectories = false;
                        FlowPlanViewControl.this.isStreamlines = false;
                        FlowPlanViewControl.this.isVectors = false;
                    } else {
                        FlowPlanViewControl.this.isVectors = true;
                        FlowPlanViewControl.this.isStreamlines = false;
                        FlowPlanViewControl.this.isTrajectories = false;
                        FlowPlanViewControl.this.isCVectors = false;
                    }
                    FlowPlanViewControl.this.setStreamlines();
                }
            };
            this.streamlinesBtn.addActionListener(listener);
            this.vectorBtn.addActionListener(listener);
            this.trajectoryBtn.addActionListener(listener);
            this.cvectorBtn.addActionListener(listener);
            GuiUtils.buttonGroup(this.streamlinesBtn, this.vectorBtn, this.trajectoryBtn, this.cvectorBtn);
            this.densityLabel = GuiUtils.rLabel("Density: ");
            this.densityComponent = this.doMakeDensityComponent();
            this.enableDensityComponents();
            Insets spacer = new Insets(0, 30, 0, 0);
            JPanel rightComp = GuiUtils.vbox(GuiUtils.left(GuiUtils.vbox(this.vectorBtn, GuiUtils.inset((Component)this.sizeComponent, spacer))), GuiUtils.left(GuiUtils.vbox(this.streamlinesBtn, GuiUtils.inset((Component)GuiUtils.hbox(this.densityLabel, this.densityComponent), spacer))), GuiUtils.left(GuiUtils.vbox(this.trajectoryBtn, GuiUtils.inset((Component)this.trajLengthComponent, spacer))), GuiUtils.left(GuiUtils.vbox(this.cvectorBtn, GuiUtils.inset((Component)this.cvectorLengthComponent, spacer))));
            JLabel showLabel = GuiUtils.rLabel("Show:");
            showLabel.setVerticalTextPosition(1);
            controlWidgets.add(new WrapperWidget(this, GuiUtils.top(GuiUtils.inset((Component)showLabel, new Insets(10, 0, 0, 0))), GuiUtils.left(GuiUtils.top(rightComp))));
        } else {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getSizeLabel()), GuiUtils.left(this.sizeComponent)));
        }
        this.vectorAHSizeWidget = new ValueSliderWidget(this, 0, 40, "ArrowHeadSize", "Arrow Head Size", 10.0f);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Arrow Scale: "), this.vectorAHSizeWidget.getContents(false)));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Skip:"), GuiUtils.left(GuiUtils.hbox(GuiUtils.rLabel("XY:  "), this.skipFactorWidget.getContents(false)))));
        if (!this.getWindbarbs()) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Range:"), this.doMakeFlowRangeComponent()));
        }
        this.enableBarbSizeBox();
        this.enableTrajLengthBox();
        this.enableCVectorLengthBox();
        List timeL = this.getDataSelection().getTimes();
        if (timeL == null && this.getHadDataChoices() && (timeL = ((DataChoice)(dchoices = this.getMyDataChoices()).get(0)).getSelectedDateTimes()) != null && timeL.size() == 0) {
            timeL = ((DataChoice)dchoices.get(0)).getAllDateTimes();
        }
        if (timeL != null && timeL.size() < 4) {
            GuiUtils.enableTree(this.cvectorBtn, false);
            GuiUtils.enableTree(this.trajectoryBtn, false);
        }
        super.getControlWidgets(controlWidgets);
    }

    protected JComponent doMakeDensityComponent() {
        int sliderPos = (int)(this.getStreamlineDensity() * 100.0f);
        int DENSITY_MIN = 10;
        int DENSITY_MAX = 500;
        sliderPos = Math.min(Math.max(sliderPos, DENSITY_MIN), DENSITY_MAX);
        this.densitySlider = GuiUtils.makeSlider(DENSITY_MIN, DENSITY_MAX, sliderPos, this, "densitySliderChanged");
        this.densitySlider.setToolTipText("Control the density of the streamlines");
        return GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Low "), this.densitySlider, GuiUtils.lLabel(" High"), GuiUtils.filler()}, 4, GuiUtils.WT_NYNY, GuiUtils.WT_N);
    }

    protected JComponent doMakeFlowRangeComponent() {
        this.setFlowRangeLabel();
        JButton editButton = GuiUtils.getImageButton("/ucar/unidata/idv/images/edit.gif", this.getClass());
        editButton.setToolTipText("Range used for scaling the vector size");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (FlowPlanViewControl.this.rangeDialog == null) {
                    FlowPlanViewControl.this.rangeDialog = new RangeDialog(FlowPlanViewControl.this, FlowPlanViewControl.this.flowRange, "Set the range of data for sizing vectors", "setFlowRange");
                    FlowPlanViewControl.this.addRemovable(FlowPlanViewControl.this.rangeDialog);
                }
                FlowPlanViewControl.this.rangeDialog.showDialog();
                FlowPlanViewControl.this.setFlowRangeLabel();
            }
        });
        return GuiUtils.hbox(this.flowRangeLabel, editButton);
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        try {
            if (dataId.equals("FlowDisplayControl.SHARE_FLOWRANGE")) {
                this.setFlowRange((Range)data[0]);
            } else if (dataId.equals("FlowDisplayControl.SHARE_FLOWRANGE")) {
                this.setFlowScale(((Float)data[0]).floatValue());
            } else {
                super.receiveShareData(from, dataId, data);
            }
        }
        catch (Exception exc) {
            FlowPlanViewControl.logException("Error processing shared state: " + dataId, exc);
        }
    }

    private void setFlowRangeLabel() {
        Range r;
        if (this.flowRangeLabel == null) {
            this.flowRangeLabel = new JLabel(" ", 4);
        }
        if ((r = this.getFlowRange()) != null) {
            this.flowRangeLabel.setText(" " + r.formatMin() + " to " + r.formatMax());
        } else {
            this.flowRangeLabel.setText(" Undefined");
        }
    }

    public void densitySliderChanged(int value) {
        try {
            this.setStreamlineDensity((float)((double)value / 100.0), true);
        }
        catch (Exception exc) {
            FlowPlanViewControl.logException("Setting streamline density ", exc);
        }
    }

    private void enableDensityComponents() {
        if (this.densityComponent != null) {
            GuiUtils.enableTree(this.densityComponent, this.isStreamlines);
        }
        if (this.densityLabel != null) {
            GuiUtils.enableTree(this.densityLabel, this.isStreamlines);
        }
    }

    private void enableBarbSizeBox() {
        if (this.sizeComponent != null) {
            GuiUtils.enableTree(this.sizeComponent, this.isVectors);
        }
    }

    private void enableTrajLengthBox() {
        if (this.trajLengthComponent != null) {
            GuiUtils.enableTree(this.trajLengthComponent, this.isTrajectories);
        }
    }

    private void enableCVectorLengthBox() {
        if (this.cvectorLengthComponent != null) {
            GuiUtils.enableTree(this.cvectorLengthComponent, this.isCVectors);
        }
    }

    private String getSizeLabel() {
        return this.isWindBarbs ? "Barb Size: " : "Vector Size: ";
    }

    @Override
    protected void addTopographyMap() throws VisADException, RemoteException {
        this.addTopographyMap(this.isThreeComponents ? 3 : 2);
    }

    public void setStreamlines() {
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setStreamlinesEnabled(this.isStreamlines);
            if (this.isCVectors) {
                this.trajFormType = 0;
                this.trajFormBox.setSelectedIndex(0);
                this.getGridDisplay().setTrajFormType(0);
                this.getGridDisplay().setIsTrajectories(true);
                this.getGridDisplay().setTrojectoriesEnabled(this.isCVectors, true, this.arrowHeadSizeValue, true);
                this.arrowHead = true;
            } else if (this.isTrajectories) {
                this.arrowHead = this.arrowCbx.isSelected();
                this.getGridDisplay().setArrowHead(this.arrowHead);
                this.getGridDisplay().setTrajFormType(this.trajFormType);
                this.getGridDisplay().setIsTrajectories(true);
                this.getGridDisplay().setTrojectoriesEnabled(this.isTrajectories, false, this.arrowHeadSizeValue, false);
            } else {
                this.getGridDisplay().setTrajFormType(0);
                this.getGridDisplay().setIsTrajectories(false);
                this.getGridDisplay().setTrojectoriesEnabled(false, false, this.arrowHeadSizeValue, false);
            }
            this.enableBarbSizeBox();
            this.enableDensityComponents();
            this.enableTrajLengthBox();
            this.enableCVectorLengthBox();
        }
        if (this.streamlinesBtn != null) {
            this.streamlinesBtn.setSelected(this.isStreamlines);
            this.vectorBtn.setSelected(this.isVectors);
            this.trajectoryBtn.setSelected(this.isTrajectories);
            this.cvectorBtn.setSelected(this.isCVectors);
        }
    }

    public void setStreamlines(boolean v) {
        this.isStreamlines = v;
    }

    public void setTrajectories(boolean v) {
        this.isTrajectories = v;
    }

    public void setVectors(boolean v) {
        this.isVectors = v;
    }

    public void setCVectors(boolean v) {
        this.isCVectors = v;
    }

    public boolean getStreamlines() {
        return this.isStreamlines;
    }

    public boolean getTrajectories() {
        return this.isTrajectories;
    }

    public boolean getCVectors() {
        return this.isCVectors;
    }

    public boolean getVectors() {
        return this.isVectors;
    }

    @Override
    public void setSkipValue(int value) {
        super.setSkipValue(value);
        FlowDisplayable fd = this.getGridDisplay();
        if (this.skipFactorWidget != null) {
            this.skipFactorWidget.setValue(value);
        }
        if (fd != null) {
            fd.setUseSpeedForColor(this.useSpeedForColor);
            fd.setColoredByAnother(this.coloredByAnother);
            if (this.useSpeedForColor || this.coloredByAnother) {
                this.colorIndex = 2;
            }
        }
    }

    public void setWindbarbs(boolean v) {
        this.isWindBarbs = v;
    }

    public boolean getWindbarbs() {
        return this.isWindBarbs;
    }

    public void setIsThreeComponents(boolean v) {
        this.isThreeComponents = v;
    }

    public boolean getIsThreeComponents() {
        return this.isThreeComponents;
    }

    public void setScaleFactor(float s) {
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(new Double(this.flowScaleValue), "flowScale", "Scale", "Display");
        dsd.addPropertyValue(new Double(this.trajOffsetValue), "trajOffset", "Offset Length", "Display");
        dsd.addPropertyValue(new Integer(this.trajFormType), "trajFormType", "Traj Form", "Display");
        dsd.addPropertyValue(new Integer(this.getSkipValue()), "skipValue", "Skip Factor", "Display");
        dsd.addPropertyValue(new Double(this.getStreamlineDensity()), "streamlineDensity", "Streamline Density", "Display");
        dsd.addPropertyValue(this.flowRange, "flowRange", "Flow Field Range", "Display");
        dsd.addPropertyValue(new Boolean(this.getStreamlines()), "streamlines", "Show Streamlines", "Display");
        dsd.addPropertyValue(new Boolean(this.getTrajectories()), "trajectory", "Show Trajectory", "Display");
        dsd.addPropertyValue(new Boolean(this.getCVectors()), "curlyvector", "Show Curly Vector", "Display");
        dsd.addPropertyValue(new Boolean(this.getAutoSize()), "autoSize", "Autosize", "Display");
    }

    public boolean getAutoSize() {
        return this.autoSize;
    }

    public void setAutoSize(boolean auto) {
        this.autoSize = auto;
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setAutoScale(this.autoSize);
        }
    }

    public boolean getArrowHead() {
        return this.arrowHead;
    }

    public void setArrowHead(boolean arrow) {
        this.arrowHead = arrow;
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setArrowHead(this.arrowHead);
        }
    }

    public float getFlowScale() {
        return this.flowScaleValue;
    }

    public void setFlowScale(float f) {
        this.flowScaleValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setFlowScale(this.getDisplayScale() * 0.02f * this.flowScaleValue);
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.getHaveInitialized()) {
            this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
        }
        if (this.barbSizeWidget != null) {
            this.barbSizeWidget.setValue(f);
        }
    }

    public void setTrajOffset(float f) {
        this.trajOffsetValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajOffset(this.trajOffsetValue);
                this.getGridDisplay().resetTrojectories();
                this.getGridDisplay().setArrowHead(this.arrowHead);
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.trajLengthWidget != null) {
            this.trajLengthWidget.setValue(f);
        }
    }

    public void setVectorLength(float f) {
        this.vectorLengthValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.arrowHead = true;
                this.getGridDisplay().setArrowHead(this.arrowHead);
                this.getGridDisplay().setVectorLength(this.vectorLengthValue);
                this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                this.getGridDisplay().resetTrojectories();
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.cvectorLengthWidget != null) {
            this.cvectorLengthWidget.setValue(f);
        }
    }

    public void setArrowHeadSize(float f) {
        this.arrowHeadSizeValue = f;
        if (this.getGridDisplay() != null) {
            try {
                this.getGridDisplay().setTrajOffset(this.vectorLengthValue);
                this.getGridDisplay().setArrowHeadSize(this.arrowHeadSizeValue);
                if (this.isTrajectories || this.isCVectors) {
                    this.getGridDisplay().resetTrojectories();
                }
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("setFlowScale: ", ex);
            }
        }
        if (this.vectorAHSizeWidget != null) {
            this.vectorAHSizeWidget.setValue(f);
        }
    }

    public float getVectorLength() {
        return this.vectorLengthValue;
    }

    public float getArrowHeadSize() {
        return this.arrowHeadSizeValue;
    }

    public float getTrajOffset() {
        return this.trajOffsetValue;
    }

    public Range getFlowRange() {
        return this.flowRange;
    }

    public void setFlowRange(Range f) {
        this.flowRange = f;
        if (this.getGridDisplay() != null && this.flowRange != null && !this.getWindbarbs()) {
            try {
                this.getGridDisplay().setFlowRange(this.flowRange);
            }
            catch (Exception excp) {
                FlowPlanViewControl.logException("setFlowRange: ", excp);
            }
        }
        this.setFlowRangeLabel();
        if (this.getHaveInitialized()) {
            this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
        }
    }

    public float getStreamlineDensity() {
        return this.streamlineDensity;
    }

    public void setStreamlineDensity(float f) {
        this.setStreamlineDensity(f, false);
    }

    public void setStreamlineDensity(float f, boolean fromSlider) {
        this.streamlineDensity = f;
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setStreamlineDensity(f);
        }
        if (!fromSlider && this.densitySlider != null) {
            this.densitySlider.setValue((int)(f * 100.0f));
        }
    }

    @Override
    protected boolean haveMultipleFields() {
        if (this.getGridDataInstance() == null) {
            return false;
        }
        return this.getGridDataInstance().getNumRealTypes() > (this.getIsThreeComponents() ? 3 : 2) && !this.getMultipleIsTopography() || this.useSpeedForColor;
    }

    @Override
    protected int getColorRangeIndex() {
        if (this.colorIndex >= 0) {
            return this.colorIndex;
        }
        if (this.getMultipleIsTopography()) {
            return 0;
        }
        return this.getIsThreeComponents() ? 3 : 2;
    }

    @Override
    protected String getColorParamName() {
        if (this.useSpeedForColor) {
            return "windSpeed";
        }
        if (this.coloredByAnother) {
            return this.getGridDataInstance().getRealTypeName(this.colorIndex);
        }
        return super.getColorParamName();
    }

    @Override
    protected Range getInitialRange() throws RemoteException, VisADException {
        if (this.useSpeedForColor) {
            return this.flowRange;
        }
        if (this.coloredByAnother) {
            return this.getGridDataInstance().getRanges()[this.colorIndex];
        }
        return super.getInitialRange();
    }

    private void setFlowRange() throws RemoteException, VisADException {
        if (this.getGridDisplay() != null) {
            if (this.getFlowRange() == null) {
                Range[] ranges = null;
                Data data = this.getGridDisplay().getData();
                if (data != null) {
                    int speedIndex;
                    ranges = GridUtil.getMinMax((FieldImpl)data);
                    double max = Double.NEGATIVE_INFINITY;
                    double min = Double.POSITIVE_INFINITY;
                    int startComp = 0;
                    int numComps = this.getIsThreeComponents() ? 3 : 2;
                    boolean isCartesian = this.getGridDisplay().isCartesianWind();
                    if (!isCartesian && (speedIndex = this.getGridDisplay().getSpeedTypeIndex()) != -1) {
                        startComp = speedIndex;
                        numComps = startComp + 1;
                    }
                    for (int i = startComp; i < numComps; ++i) {
                        Range compRange = ranges[i];
                        max = Math.max(compRange.getMax(), max);
                        min = Math.min(compRange.getMin(), min);
                    }
                    if (this.useSpeedForColor || this.coloredByAnother) {
                        Range compRange;
                        this.flowColorRange = compRange = ranges[ranges.length - 1];
                    }
                    if (!Double.isInfinite(max) && !Double.isInfinite(min)) {
                        max = Math.max(max, -min);
                        min = isCartesian ? -max : 0.0;
                    }
                    this.setFlowRange(new Range(min, max));
                } else {
                    this.setFlowRange(new Range(-40.0, 40.0));
                }
            } else {
                this.getGridDisplay().setFlowRange(this.flowRange);
            }
        }
    }

    @Override
    public Range getRangeForColorTable() throws RemoteException, VisADException {
        if (this.getFlowColorRange() == null) {
            this.setFlowRange();
        }
        return this.flowColorRange;
    }

    @Override
    public boolean showColorControlWidget() {
        return !this.haveMultipleFields() && !this.useSpeedForColor && !this.coloredByAnother;
    }

    public void setFlowColorRange(Range colorRange) {
        this.flowColorRange = colorRange;
    }

    public Range getFlowColorRange() {
        return this.flowColorRange;
    }

    @Override
    public Range getRange() throws RemoteException, VisADException {
        return super.getRange();
    }

    @Override
    public void setRange(Range nRange) throws RemoteException, VisADException {
        super.setRange(nRange);
        this.setFlowColorRange(nRange);
    }

    @Override
    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        if (this.currentSlice == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        RealTuple r = GridUtil.sampleToRealTuple(this.currentSlice, el, animationValue, this.getSamplingModeValue(this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE)));
        if (r != null) {
            ReadoutInfo readoutInfo = new ReadoutInfo(this, r, el, animationValue);
            readoutInfo.setUnit(this.getDisplayUnit());
            readoutInfo.setRange(this.getRange());
            samples.add(readoutInfo);
        }
        if (r != null && !Util.allMissing(r)) {
            result.add("<tr><td>" + this.getMenuLabel() + ":</td><td  align=\"right\">" + this.formatForCursorReadout(r) + (this.currentLevel != null ? "@" + this.currentLevel : "") + "</td></tr>");
        }
        return result;
    }

    protected String formatForCursorReadout(RealTuple rt) throws VisADException, RemoteException {
        String result;
        Unit displayUnit = this.getDisplayUnit();
        Unit unit = null;
        if (Util.allMissing(rt)) {
            result = "missing";
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < rt.getDimension(); ++i) {
                double value;
                Real r = (Real)rt.getComponent(i);
                if (displayUnit != null) {
                    value = r.getValue(displayUnit);
                    unit = displayUnit;
                } else {
                    value = r.getValue();
                    unit = r.getUnit();
                }
                builder.append(Misc.format(value));
                if (i == rt.getDimension() - 1) continue;
                builder.append("/");
            }
            builder.append("[");
            builder.append(unit);
            builder.append("]");
            result = builder.toString();
            int length = result.length();
            result = StringUtil.padLeft(result, 8 * (20 - length), "&nbsp;");
        }
        return result;
    }

    public Integer getTrajFormType() {
        return this.trajFormType;
    }

    public void setTrajFormType(Integer trajForm) {
        this.trajFormType = trajForm;
        if (this.isTrajectories && this.getGridDisplay() != null) {
            try {
                int width = this.getLineWidth();
                this.getGridDisplay().setTrajFormType(trajForm);
                this.getGridDisplay().setArrowHead(this.arrowHead);
                this.getGridDisplay().setRibbonWidth(width);
                this.getGridDisplay().setTrajWidth((float)width * 0.01f);
                this.getGridDisplay().resetTrojectories();
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("setTrajFormType: ", ex);
            }
        }
    }

    @Override
    public void setLineWidth(int width) throws RemoteException, VisADException {
        int n = width = width < 1 ? 1 : width;
        if (this.isTrajectories) {
            if (this.trajFormType == 2) {
                this.getGridDisplay().setTrajWidth((float)width * 0.01f);
            } else if (this.trajFormType == 1 || this.trajFormType == 3) {
                this.getGridDisplay().setRibbonWidth(width);
            }
            this.getGridDisplay().resetTrojectories();
        }
        super.setLineWidth(width);
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList(MACRO_MAXSPEED));
        labels.addAll(Misc.newList("Max Speed"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add(MACRO_MAXSPEED);
        if (this.currentLevel == null) {
            values.add("");
        } else {
            try {
                if (this.maxspeedString == null && this.currentSlice != null) {
                    FieldImpl ff = (FieldImpl)this.currentSlice.getSample(0);
                    Range[] a = this.getSpeedRange(ff);
                    if (a == null) {
                        values.add("");
                    } else {
                        this.maxspeedString = "" + this.getDisplayConventions().format(a[0].max) + this.getDisplayUnit();
                        values.add(this.maxspeedString);
                    }
                } else if (this.currentSlice == null) {
                    values.add("");
                } else if (this.maxspeedString != null) {
                    values.add(this.maxspeedString);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Range[] getSpeedRange(FieldImpl ff) {
        Range[] a = null;
        try {
            FlatField uGrid = (FlatField)DerivedGridFactory.getUComponent(ff);
            FlatField vGrid = (FlatField)DerivedGridFactory.getVComponent(ff);
            FlatField wsgridFI = (FlatField)uGrid.multiply(uGrid).add(vGrid.multiply(vGrid)).sqrt();
            a = GridUtil.getMinMax(wsgridFI);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a;
    }

    @Override
    protected void timeChanged(Real time) {
        block5: {
            try {
                super.timeChanged(time);
                String dlTemplate = this.getDisplayListTemplate();
                if (!dlTemplate.contains(MACRO_MAXSPEED)) break block5;
                List<DateTime> dlist = GridUtil.getDateTimeList(this.currentSlice);
                int index = dlist.indexOf((DateTime)time);
                FieldImpl ff = (FieldImpl)this.currentSlice.getSample(index);
                Range[] a = this.getSpeedRange(ff);
                if (index >= 0) {
                    try {
                        this.maxspeedString = "" + this.getDisplayConventions().format(a[0].max) + this.getDisplayUnit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.updateDisplayList();
            }
            catch (Exception ex) {
                FlowPlanViewControl.logException("timeValueChanged", ex);
            }
        }
    }
}

