/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.CrossSectionControl;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.FlowDisplayControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Range;
import ucar.unidata.util.Trace;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.FlowDisplayable;
import ucar.visad.display.WindBarbDisplayable;
import visad.FieldImpl;
import visad.VisADException;

public class FlowCrossSectionControl
extends CrossSectionControl
implements FlowDisplayControl {
    boolean isWindBarbs = false;
    protected final float scaleFactor = 0.02f;
    float flowScaleValue = 4.0f;
    boolean isThreeComponents = false;
    JLabel flowRangeLabel;
    private Range flowRange;
    ValueSliderWidget barbSizeWidget;
    ValueSliderWidget skipFactorWidget;
    RangeDialog rangeDialog;

    public FlowCrossSectionControl() {
        this.setAttributeFlags(9220);
    }

    @Override
    public void initDone() {
        super.initDone();
        this.setFlowScale(this.flowScaleValue);
        ((FlowDisplayable)this.getXSDisplay()).setAdjustFlow(this.getIsThreeComponents());
    }

    @Override
    protected void loadData(FieldImpl fieldImpl) throws VisADException, RemoteException {
        if (this.getFlowRange() == null && !this.getWindbarbs()) {
            this.setFlowRange(fieldImpl);
        }
        if (this.startLocation != null && this.getWindbarbs()) {
            if (this.startLocation.getLatitude().getValue() >= 0.0) {
                ((FlowDisplayable)this.getVerticalCSDisplay()).setBarbOrientation(0);
            } else {
                ((FlowDisplayable)this.getVerticalCSDisplay()).setBarbOrientation(1);
            }
        }
        super.loadData(fieldImpl);
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(new Double(this.flowScaleValue), "flowScale", "Scale", "Display");
        dsd.addPropertyValue(this.flowRange, "flowRange", "Flow Field Range", "Display");
        dsd.addPropertyValue(new Integer(this.getSkipValue()), "skipValue", "Skip Factor", "Display");
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        Trace.call1("FlowCrossSection.setData");
        boolean result = super.setData(dataChoice);
        if (!result) {
            Trace.call2("FlowCrossSection.setData");
            return false;
        }
        if (this.getFlowRange() == null && !this.getWindbarbs()) {
            this.setFlowRange((FieldImpl)null);
        }
        this.setFlowScale(this.flowScaleValue);
        Trace.call2("FlowCrossSection.setData");
        return true;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Color";
    }

    FlowDisplayable getGridDisplay() {
        return (FlowDisplayable)this.getXSDisplay();
    }

    @Override
    protected DisplayableData createXSDisplay() throws VisADException, RemoteException {
        FlowDisplayable displayable = this.isWindBarbs ? new WindBarbDisplayable("wb_cs_color_" + this.paramName, null) : new FlowDisplayable("wv_cs_color_" + this.paramName, null);
        this.addAttributedDisplayable(displayable);
        return displayable;
    }

    @Override
    protected DisplayableData createVCSDisplay() throws VisADException, RemoteException {
        FlowDisplayable displayable = this.isWindBarbs ? new WindBarbDisplayable("wb_xs_color_" + this.paramName, null) : new FlowDisplayable("wv_xs_color_" + this.paramName, null);
        this.addAttributedDisplayable(displayable);
        return displayable;
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        this.barbSizeWidget = new ValueSliderWidget(this, 1, 21, "flowScale", "Scale: ");
        this.addRemovable(this.barbSizeWidget);
        this.skipFactorWidget = new ValueSliderWidget(this, 0, 10, "skipValue", this.getSkipWidgetLabel());
        this.addRemovable(this.skipFactorWidget);
        JPanel extra = GuiUtils.hbox(GuiUtils.rLabel("Scale:  "), this.barbSizeWidget.getContents(false));
        if (!this.getWindbarbs()) {
            extra = GuiUtils.hbox((Component)extra, GuiUtils.hbox(GuiUtils.filler(), this.doMakeFlowRangeComponent()));
        }
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getSizeLabel()), GuiUtils.left(extra)));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Skip:"), GuiUtils.left(GuiUtils.hbox(GuiUtils.rLabel("Horizontal:  "), this.skipFactorWidget.getContents(false)))));
        super.getControlWidgets(controlWidgets);
    }

    private String getSizeLabel() {
        return this.getWindbarbs() ? "Barb Size: " : "Vector Size: ";
    }

    protected JComponent doMakeFlowRangeComponent() {
        this.setFlowRangeLabel();
        JButton editButton = GuiUtils.getImageButton("/ucar/unidata/idv/images/edit.gif", this.getClass());
        editButton.setToolTipText("Range used for scaling the vector size");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (FlowCrossSectionControl.this.rangeDialog == null) {
                    FlowCrossSectionControl.this.rangeDialog = new RangeDialog(FlowCrossSectionControl.this, FlowCrossSectionControl.this.flowRange, "Set the range of data for sizing vectors", "setFlowRange");
                    FlowCrossSectionControl.this.addRemovable(FlowCrossSectionControl.this.rangeDialog);
                }
                FlowCrossSectionControl.this.rangeDialog.showDialog();
                FlowCrossSectionControl.this.setFlowRangeLabel();
            }
        });
        return GuiUtils.hbox(this.flowRangeLabel, editButton);
    }

    public float getFlowScale() {
        return this.flowScaleValue;
    }

    public void setFlowScale(float f) {
        this.flowScaleValue = f;
        if (this.getHaveInitialized()) {
            if (this.getGridDisplay() != null) {
                this.getGridDisplay().setFlowScale(this.flowScaleValue * 0.02f);
                ((FlowDisplayable)this.getVerticalCSDisplay()).setFlowScale(this.flowScaleValue * 0.02f);
            }
            this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
        }
        if (this.barbSizeWidget != null) {
            this.barbSizeWidget.setValue(f);
        }
    }

    public void setWindbarbs(boolean v) {
        this.isWindBarbs = v;
    }

    public boolean getWindbarbs() {
        return this.isWindBarbs;
    }

    @Override
    public void setSkipValue(int value) {
        super.setSkipValue(value);
        if (this.skipFactorWidget != null) {
            this.skipFactorWidget.setValue(value);
        }
        if (this.getCrossSectionSelector() != null) {
            this.crossSectionChanged();
        }
    }

    @Override
    protected boolean haveMultipleFields() {
        if (this.getGridDataInstance() == null) {
            return false;
        }
        return this.getGridDataInstance().getNumRealTypes() > (this.getIsThreeComponents() ? 3 : 2);
    }

    public void setIsThreeComponents(boolean v) {
        this.isThreeComponents = v;
    }

    public boolean getIsThreeComponents() {
        return this.isThreeComponents;
    }

    @Override
    protected int getColorRangeIndex() {
        return this.getIsThreeComponents() ? 3 : 2;
    }

    public Range getFlowRange() {
        return this.flowRange;
    }

    public void setFlowRange(Range f) {
        this.flowRange = f;
        if (this.getHaveInitialized()) {
            if (this.getGridDisplay() != null && this.flowRange != null && !this.getWindbarbs()) {
                try {
                    this.getGridDisplay().setFlowRange(this.flowRange);
                    ((FlowDisplayable)this.getVerticalCSDisplay()).setFlowRange(this.flowRange);
                }
                catch (Exception excp) {
                    FlowCrossSectionControl.logException("setFlowRange: ", excp);
                }
            }
            this.setFlowRangeLabel();
            this.doShare((Object)"FlowDisplayControl.SHARE_FLOWRANGE", this.flowRange);
        }
    }

    private void setFlowRange(FieldImpl data) throws RemoteException, VisADException {
        if (this.getGridDisplay() != null && !this.getWindbarbs()) {
            if (this.getFlowRange() == null) {
                Range[] ranges = null;
                if (data == null) {
                    data = (FieldImpl)this.getGridDisplay().getData();
                }
                if (data != null) {
                    ranges = GridUtil.getMinMax(data);
                    double max = Double.NEGATIVE_INFINITY;
                    double min = Double.POSITIVE_INFINITY;
                    int numComps = this.getIsThreeComponents() ? 3 : 2;
                    for (int i = 0; i < numComps; ++i) {
                        Range compRange = ranges[i];
                        max = Math.max(compRange.getMax(), max);
                        min = Math.min(compRange.getMin(), min);
                    }
                    if (!Double.isInfinite(max) && !Double.isInfinite(min)) {
                        max = Math.max(max, -min);
                        min = -max;
                    }
                    this.setFlowRange(new Range(min, max));
                } else {
                    this.setFlowRange(new Range(-40.0, 40.0));
                }
            } else {
                this.getGridDisplay().setFlowRange(this.flowRange.getMin(), this.flowRange.getMax());
            }
        }
    }

    @Override
    public Range getColorRangeFromData() {
        Range r = super.getColorRangeFromData();
        return this.makeFlowRange(r);
    }

    private Range makeFlowRange(Range r) {
        if (this.haveMultipleFields()) {
            return r;
        }
        if (r == null) {
            return r;
        }
        double max = Math.max(Math.abs(r.getMax()), Math.abs(r.getMin()));
        return new Range(-max, max);
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        try {
            if (dataId.equals("FlowDisplayControl.SHARE_FLOWRANGE")) {
                this.setFlowRange((Range)data[0]);
            } else if (dataId.equals("FlowDisplayControl.SHARE_FLOWRANGE")) {
                this.setFlowScale(((Float)data[0]).floatValue());
            } else {
                super.receiveShareData(from, dataId, data);
            }
        }
        catch (Exception exc) {
            FlowCrossSectionControl.logException("Error processing shared state: " + dataId, exc);
        }
    }

    private void setFlowRangeLabel() {
        Range r;
        if (this.flowRangeLabel == null) {
            this.flowRangeLabel = new JLabel("Range: ", 4);
        }
        if ((r = this.getFlowRange()) != null) {
            this.flowRangeLabel.setText("Range: " + r.formatMin() + " to " + r.formatMax());
        } else {
            this.flowRangeLabel.setText("Range: Undefined");
        }
    }

    @Override
    public boolean showColorControlWidget() {
        return true;
    }
}

