/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.ui.TableSorter;
import ucar.visad.Util;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.VisADException;

public class FlatFieldTable
extends JTable {
    private TableModel model = null;
    private FlatField displayedFlatField;
    private double[][] rangeData;
    private float[][] domainData;
    private int numDomainCols;
    private int numRangeCols;
    private String[] columnNames;

    public FlatFieldTable(FlatField ff, boolean showNativeCoordinates) throws VisADException, RemoteException {
        this.rangeData = ff.getValues(false);
        SampledSet ss = GridUtil.getSpatialDomain(ff);
        this.domainData = ss.getSamples(true);
        this.numDomainCols = this.domainData.length;
        this.numRangeCols = this.rangeData.length;
        this.columnNames = new String[this.numDomainCols + this.numRangeCols];
        if (ss.getCoordinateSystem() != null && !showNativeCoordinates) {
            this.domainData = ss.getCoordinateSystem().toReference(this.domainData);
            this.columnNames[0] = "Latitude";
            this.columnNames[1] = "Longitude";
            if (this.domainData.length > 2) {
                this.columnNames[2] = "Altitude";
            }
        } else {
            SetType t = (SetType)ss.getType();
            RealTupleType rtt = t.getDomain();
            MathType[] comps = rtt.getComponents();
            this.columnNames[0] = Util.cleanTypeName(comps[0]);
            this.columnNames[1] = Util.cleanTypeName(comps[1]);
            if (this.domainData.length > 2) {
                this.columnNames[2] = Util.cleanTypeName(comps[2]);
            }
        }
        RealType[] comps = ((FunctionType)ff.getType()).getRealComponents();
        for (int i = 0; i < comps.length; ++i) {
            this.columnNames[this.numDomainCols + i] = Util.cleanTypeName(comps[i]) + " [" + comps[i].getDefaultUnit() + "]";
        }
        this.model = new MyFlatField();
        TableSorter sorter = new TableSorter(this.model);
        this.model = sorter;
        JTableHeader header = this.getTableHeader();
        header.setToolTipText("Click to sort");
        sorter.setTableHeader(this.getTableHeader());
        this.setModel(this.model);
        this.setAutoResizeMode(2);
        this.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.getTableHeader().setReorderingAllowed(false);
    }

    public class MyFlatField
    extends AbstractTableModel {
        MyFlatField() {
        }

        @Override
        public int getColumnCount() {
            return FlatFieldTable.this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return FlatFieldTable.this.domainData[0].length;
        }

        @Override
        public String getColumnName(int col) {
            return FlatFieldTable.this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col < FlatFieldTable.this.numDomainCols) {
                return new Float(FlatFieldTable.this.domainData[col][row]);
            }
            return new Double(FlatFieldTable.this.rangeData[col - FlatFieldTable.this.numDomainCols][row]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

