/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import org.python.util.PythonInterpreter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.drawing.DrawingCommand;
import ucar.unidata.idv.control.drawing.DrawingGlyph;
import ucar.unidata.idv.control.drawing.FrontGlyph;
import ucar.unidata.idv.control.drawing.GlyphCreatorCommand;
import ucar.unidata.idv.control.drawing.HighLowGlyph;
import ucar.unidata.idv.control.drawing.ImageGlyph;
import ucar.unidata.idv.control.drawing.MovieGlyph;
import ucar.unidata.idv.control.drawing.PolyGlyph;
import ucar.unidata.idv.control.drawing.ShapeGlyph;
import ucar.unidata.idv.control.drawing.SymbolGlyph;
import ucar.unidata.idv.control.drawing.TextGlyph;
import ucar.unidata.ui.FineLineBorder;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.Animation;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.display.FrontDrawer;
import visad.Data;
import visad.DateTime;
import visad.DisplayEvent;
import visad.Gridded1DSet;
import visad.Real;
import visad.Set;
import visad.SingletonSet;
import visad.Text;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;

public class DrawingControl
extends DisplayControlImpl {
    public static final String ATTR_USETIMESINANIMATION = "usetimesinanimation";
    public static final String ATTR_FRONTDISPLAY = "frontdisplay";
    public static final String TAG_EDITOR = "editor";
    public static final String ATTR_EDITABLE = "editable";
    public static final String ATTR_TITLE = "title";
    public static final PatternFileFilter FILTER_XGRF = new PatternFileFilter(".+\\.xgrf", "IDV Drawing files (*.xgrf)");
    public static final String SUFFIX_XGRF = ".xgrf";
    static Cursor deleteCursor;
    public static final String SHARE_LINES = "DrawingControl.SHARE_LINES";
    public static final int FLAG_FILLED = 2;
    public static final int FLAG_FULLLATLON = 4;
    public static final int FLAG_STRAIGHT = 8;
    public static final DrawingCommand CMD_SELECT;
    public static final DrawingCommand CMD_MOVE;
    public static final DrawingCommand CMD_STRETCH;
    private boolean enabled = true;
    private boolean frontDisplay = false;
    protected JCheckBox enabledCbx;
    private boolean editable = true;
    private String editorTitle = null;
    private int coordType = 3;
    private int lineWidth = 1;
    private int fontSize = 12;
    private JComboBox fontBox;
    private JTextField scaleFld;
    private JPanel zPositionPanel;
    private JComboBox justificationBox;
    private JComboBox vertJustificationBox;
    private JComboBox fontSizeBox;
    private JCheckBox filledCbx;
    private boolean filled = false;
    protected JCheckBox straightCbx;
    private boolean straight = false;
    private JCheckBox fullLatLonCbx;
    private boolean fullLatLon = false;
    private JCheckBox useTimeCbx;
    private boolean useTime = false;
    private JCheckBox ignoreTimeCbx;
    private boolean ignoreTime = false;
    private String clipboardXml;
    JLabel msgLabel;
    GlyphTable glyphTable;
    GlyphTableModel glyphTableModel;
    protected List glyphs = new ArrayList();
    protected List selectedGlyphs = new ArrayList();
    CompositeDisplayable displayHolder;
    DrawingGlyph currentGlyph;
    protected DrawingCommand currentCmd = GlyphCreatorCommand.CMD_SMOOTHPOLYGON;
    private Object lastProjection;
    private boolean displayOnly = false;
    private String glyphJython;
    private boolean showFronts = false;
    private int shapeColumns = 10;
    private boolean skipNextMouseReleased = false;
    private JCheckBox loadAsMapData;
    private double frontScale = 1.0;
    private int autoScrollCnt = 0;
    protected DataChoice datachoice = null;

    public DrawingControl() {
        this.setAttributeFlags(32);
    }

    @Override
    protected long getControlChangeSleepTime() {
        return 250L;
    }

    public String formatDistance(Real distance) throws VisADException, RemoteException {
        return this.getDisplayConventions().formatDistance(distance.getValue(this.getDistanceUnit())) + " " + this.getDistanceUnit();
    }

    public Unit getDistanceUnit() {
        return this.getDisplayUnit();
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.setColor(Color.red);
        if (deleteCursor == null) {
            deleteCursor = Toolkit.getDefaultToolkit().createCustomCursor(GuiUtils.getImage("/auxdata/ui/icons/Cut16.gif"), new Point(0, 0), "Custom Delete");
        }
        this.dataSelection = this.getDataSelection();
        this.initDisplayUnit();
        this.displayHolder = new CompositeDisplayable();
        this.displayHolder.setUseTimesInAnimation(this.getUseTimesInAnimation());
        this.addDisplayable(this.displayHolder);
        List oldGlyphs = this.glyphs;
        this.glyphs = new ArrayList();
        this.setDisplayInactive();
        for (int i = 0; i < oldGlyphs.size(); ++i) {
            DrawingGlyph glyph = (DrawingGlyph)oldGlyphs.get(i);
            glyph.initFromBundle(this);
            this.addGlyph(glyph);
        }
        this.setDisplayActive();
        this.getViewAnimation();
        this.checkGlyphTimes();
        if (dataChoice != null) {
            this.datachoice = dataChoice;
            Data data = dataChoice.getData(this.dataSelection);
            if (data != null) {
                this.editable = false;
                this.displayOnly = true;
                this.processData(data);
            }
        }
        return true;
    }

    protected void initDisplayUnit() {
        if (this.getDisplayUnit() == null) {
            this.setDisplayUnit(this.getDefaultDistanceUnit());
        }
    }

    @Override
    protected boolean shouldAddDisplayListener() {
        return true;
    }

    @Override
    protected void handleWindowClosing() {
        try {
            this.clearCursor();
            this.clearSelection();
        }
        catch (Exception exc) {
            DrawingControl.logException("Clearing the selection on window closing", exc);
        }
        super.handleWindowClosing();
    }

    @Override
    public void close() {
        try {
            this.clearSelection();
        }
        catch (Exception exc) {
            DrawingControl.logException("Clearing the selection on window closing", exc);
        }
        super.close();
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            this.checkGlyphTimes();
        }
        catch (Exception exc) {
            DrawingControl.logException("Property change", exc);
        }
        super.timeChanged(time);
    }

    protected void processData(Data data) throws VisADException, RemoteException {
        if (data instanceof Text) {
            String contents = ((Text)data).getValue();
            Element root = null;
            try {
                root = XmlUtil.getRoot(contents);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (root != null) {
                this.processXml(root, true);
                this.checkGlyphTimes();
            }
        }
    }

    @Override
    protected void resetData() throws VisADException, RemoteException {
        DataChoice dataChoice = this.getDataChoice();
        if (dataChoice != null) {
            this.removeAllGlyphs();
            Data data = dataChoice.getData(null);
            if (data != null) {
                this.processData(data);
            }
        }
    }

    private void processXml(Element root, boolean initialXml) throws VisADException, RemoteException {
        ArrayList times = new ArrayList();
        this.setDisplayInactive();
        NodeList elements = XmlUtil.getElements(root);
        if (!this.getWasUnPersisted()) {
            this.setUseTimesInAnimation(XmlUtil.getAttribute((Node)root, ATTR_USETIMESINANIMATION, this.getUseTimesInAnimation()));
        }
        this.frontDisplay = XmlUtil.getAttribute((Node)root, ATTR_FRONTDISPLAY, this.frontDisplay);
        if (this.displayHolder != null) {
            this.displayHolder.setUseTimesInAnimation(this.getUseTimesInAnimation());
        }
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            DrawingGlyph glyph = null;
            if (child.getTagName().equals("polygon")) {
                glyph = new PolyGlyph();
            } else if (child.getTagName().equals("front")) {
                glyph = new FrontGlyph();
            } else if (child.getTagName().equals("symbol")) {
                glyph = new SymbolGlyph();
            } else if (child.getTagName().equals("high")) {
                glyph = new HighLowGlyph(true);
            } else if (child.getTagName().equals("low")) {
                glyph = new HighLowGlyph(false);
            } else if (child.getTagName().equals("text")) {
                glyph = new TextGlyph();
            } else if (child.getTagName().equals("image")) {
                glyph = new ImageGlyph();
            } else if (child.getTagName().equals("movie")) {
                glyph = new MovieGlyph();
            } else if (child.getTagName().equals("shape")) {
                glyph = new ShapeGlyph();
            } else {
                if (child.getTagName().equals(TAG_EDITOR)) {
                    if (!initialXml) continue;
                    this.editable = XmlUtil.getAttribute((Node)child, ATTR_EDITABLE, this.editable);
                    this.editorTitle = XmlUtil.getAttribute((Node)child, ATTR_TITLE, (String)null);
                    continue;
                }
                System.err.println("Unknown shape tag:" + child.getTagName());
            }
            if (glyph == null) continue;
            glyph.initFromXml(this, child);
            this.addGlyph(glyph);
            List glyphTimes = glyph.getTimeValues();
            if (glyphTimes == null) continue;
            for (int timeIdx = 0; timeIdx < glyphTimes.size(); ++timeIdx) {
                Object dttm = glyphTimes.get(timeIdx);
                if (times.contains(dttm)) continue;
                times.add(dttm);
            }
        }
        if (initialXml && times.size() > 0) {
            this.setAnimationSet(times);
        }
        this.setDisplayActive();
    }

    private void checkGlyphTimes() {
        try {
            if (!this.getDisplayVisibility()) {
                return;
            }
            if (this.ignoreTimeCbx == null || !this.ignoreTimeCbx.isSelected()) {
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    ((DrawingGlyph)this.glyphs.get(i)).checkTimeVisibility();
                }
            } else {
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    ((DrawingGlyph)this.glyphs.get(i)).setVisible(true);
                }
            }
        }
        catch (Exception e) {
            DrawingControl.logException("Setting glyph visiblity", e);
        }
    }

    @Override
    public void toggleVisibilityForVectorGraphicsRendering(int rasterMode) throws Exception {
        if (rasterMode == 0) {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                glyph.oldVisibility = glyph.isVisible();
                if (!glyph.oldVisibility) continue;
                glyph.setVisible(glyph.getIsRaster());
            }
        } else if (rasterMode == 1) {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                if (!glyph.oldVisibility) continue;
                glyph.setVisible(!glyph.getIsRaster());
            }
        } else {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                glyph.setVisible(glyph.oldVisibility);
            }
        }
    }

    public boolean shouldBeVisible(DrawingGlyph tg) {
        return this.getDisplayVisibility();
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        super.setDisplayVisibility(on);
        for (int i = 0; i < this.glyphs.size(); ++i) {
            DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
            glyph.checkVisibility();
        }
        if (this.getHaveInitialized()) {
            this.checkGlyphTimes();
        }
    }

    protected boolean addGlyph(DrawingGlyph glyph) {
        try {
            Displayable displayable = glyph.getDisplayable();
            displayable.setUseTimesInAnimation(this.getUseTimesInAnimation());
            this.displayHolder.addDisplayable(displayable);
            if (!glyph.initFinal()) {
                return false;
            }
            this.glyphs.add(glyph);
            if (this.glyphTable != null) {
                this.glyphTable.glyphsChanged();
            }
        }
        catch (Exception e) {
            DrawingControl.logException("Adding glyph", e);
            return false;
        }
        return true;
    }

    public void glyphChanged(DrawingGlyph glyph) {
        if (this.glyphTable != null) {
            this.glyphTable.repaint();
        }
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        this.clearCursor();
        if (this.glyphs != null) {
            for (int i = 0; i < this.glyphs.size(); ++i) {
                ((DrawingGlyph)this.glyphs.get(i)).setBeenRemoved(true);
            }
        }
        this.glyphs = null;
        this.selectedGlyphs = null;
        this.displayHolder = null;
        super.doRemove();
    }

    @Override
    protected void getLegendLabels(List labels, int legendType) {
        if (this.editorTitle != null && this.editorTitle.length() > 0) {
            labels.add(this.editorTitle);
        } else {
            super.getLegendLabels(labels, legendType);
        }
    }

    protected DrawingGlyph createGlyph(DisplayEvent event, boolean mousePress) throws VisADException, RemoteException {
        DrawingGlyph glyph = null;
        if (this.currentCmd instanceof GlyphCreatorCommand) {
            GlyphCreatorCommand gcc = (GlyphCreatorCommand)this.currentCmd;
            if (gcc.getNeedsMouse() && !mousePress) {
                return null;
            }
            if (!gcc.getNeedsMouse() && mousePress) {
                return null;
            }
            glyph = gcc.createGlyph(this, event);
        }
        if (glyph == null) {
            return null;
        }
        String name = glyph.getName();
        if (name == null || name.length() == 0) {
            name = this.getGlyphNameDefault(glyph) + " " + (this.glyphs.size() + 1);
            glyph.setName(name);
        }
        if (!glyph.initFromUser(this, event)) {
            return null;
        }
        if (!this.addGlyph(glyph)) {
            return null;
        }
        this.setCurrentGlyph(glyph, glyph.handleCreation(event));
        if (this.currentGlyph != null) {
            if (this.currentGlyph instanceof TextGlyph) {
                this.setCursor(2);
            } else {
                this.setCursor(12);
            }
        }
        return glyph;
    }

    private void setCurrentGlyph(DrawingGlyph glyphWeHad, DrawingGlyph glyph) {
        try {
            if (glyphWeHad != null && glyphWeHad != glyph && glyphWeHad.getBeingCreated()) {
                try {
                    this.setSelection(glyphWeHad);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.currentGlyph = glyph;
            if (this.currentGlyph == null) {
                this.setCursor();
            } else if (Misc.equals(this.currentCmd, CMD_STRETCH) && this.currentGlyph instanceof ImageGlyph) {
                this.msgLabel.setText("Drag: reshape; Drag/Ctrl: unconstrained");
            }
        }
        catch (Exception e) {
            DrawingControl.logException("Setting current drawing glyph", e);
        }
    }

    @Override
    public void viewpointChanged() {
        super.viewpointChanged();
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        try {
            long t1 = System.currentTimeMillis();
            if (this.glyphs != null) {
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    ((DrawingGlyph)this.glyphs.get(i)).viewpointChanged();
                }
            }
            long l = System.currentTimeMillis();
        }
        catch (Exception e) {
            DrawingControl.logException("Handling projection change event", e);
        }
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        try {
            if (this.glyphs != null) {
                for (int i = 0; i < this.glyphs.size(); ++i) {
                    ((DrawingGlyph)this.glyphs.get(i)).projectionChanged();
                }
            }
        }
        catch (Exception e) {
            DrawingControl.logException("Handling projection change event", e);
        }
    }

    protected boolean canHandleEvents() {
        if (this.displayOnly || !this.getEnabled() || !this.editable || !this.getHaveInitialized() || this.getMakeWindow() && !this.getWindowVisible()) {
            return false;
        }
        return this.isGuiShown();
    }

    public void doFlythrough() throws VisADException, RemoteException {
        for (int i = 0; i < this.selectedGlyphs.size(); ++i) {
            if (!(this.selectedGlyphs.get(i) instanceof PolyGlyph)) continue;
            ((PolyGlyph)this.selectedGlyphs.get(i)).doFlythrough();
            break;
        }
    }

    @Override
    public void handleDisplayChanged(DisplayEvent event) {
        int id = event.getId();
        if (id == 21 && this.currentGlyph == null) {
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        if (!this.canHandleEvents()) {
            return;
        }
        try {
            if (id == 16) {
                if (inputEvent instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)inputEvent;
                    if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
                        this.setSelection(this.glyphs, false);
                        return;
                    }
                    if (keyEvent.getKeyCode() == 88 && keyEvent.isControlDown()) {
                        this.doCut();
                        return;
                    }
                    if (keyEvent.getKeyCode() == 70 && keyEvent.isControlDown()) {
                        this.doFlythrough();
                        return;
                    }
                    if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                        this.clipboardXml = this.toXml(this.selectedGlyphs);
                        return;
                    }
                    if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown()) {
                        if (this.clipboardXml != null) {
                            this.doImportXml(this.clipboardXml);
                        }
                        return;
                    }
                    if (GuiUtils.isDeleteEvent(keyEvent) && this.currentGlyph != null && this.currentCmd.equals(CMD_STRETCH)) {
                        this.setSelection(this.currentGlyph);
                        this.currentGlyph.doDeletePoint(event);
                    }
                    if (keyEvent.getKeyCode() == 80 && keyEvent.isControlDown()) {
                        this.doProperties(this.selectedGlyphs);
                        return;
                    }
                }
                if (this.currentGlyph != null) {
                    this.setCurrentGlyph(this.currentGlyph, this.currentGlyph.handleKeyPressed(event));
                }
            }
            if ((event.getModifiers() & 1) != 0) {
                return;
            }
            if (id == 21) {
                if (this.currentGlyph != null) {
                    this.setCurrentGlyph(this.currentGlyph, this.currentGlyph.handleMouseMoved(event));
                }
                return;
            }
            this.setCursor();
            if (id == 1) {
                if (!DrawingControl.isLeftButtonDown(event)) {
                    return;
                }
                DrawingGlyph closestGlyph = this.closestGlyph(event);
                if (closestGlyph != null && closestGlyph.mousePressed(event)) {
                    this.skipNextMouseReleased = true;
                    return;
                }
                if (this.currentCmd.equals(CMD_SELECT)) {
                    if (closestGlyph != null) {
                        closestGlyph.mousePressed(event);
                        this.setCurrentGlyph(this.currentGlyph, null);
                        this.setSelection(Misc.newList(closestGlyph), inputEvent.isControlDown());
                    } else {
                        this.clearSelection();
                    }
                    return;
                }
                if (this.currentCmd.equals(CMD_MOVE)) {
                    closestGlyph = this.closestGlyph(event, true);
                    if (closestGlyph != null) {
                        this.setCurrentGlyph(this.currentGlyph, closestGlyph);
                        closestGlyph.initMove(event);
                    }
                    return;
                }
                if (this.currentCmd.equals(CMD_STRETCH)) {
                    closestGlyph = this.closestGlyph(event, true);
                    if (closestGlyph != null) {
                        this.setCurrentGlyph(this.currentGlyph, closestGlyph);
                        closestGlyph.initStretch(event);
                    }
                    return;
                }
                if (this.currentGlyph == null) {
                    DrawingGlyph drawingGlyph = this.createGlyph(event, true);
                } else {
                    this.setCurrentGlyph(this.currentGlyph, this.currentGlyph.handleMousePressed(event));
                }
            } else if (id == 18) {
                if (!DrawingControl.isLeftButtonDown(event)) {
                    return;
                }
                int x = event.getX();
                int y = event.getY();
                Rectangle bounds = this.getScreenBounds();
                int pad = 5;
                if ((x > bounds.width + pad || y > bounds.height + pad || x < -pad || y < -pad) && this.autoScrollCnt++ > 10) {
                    EarthLocation el = this.screenToEarth(x, y);
                    this.getNavigatedDisplay().center(el, false);
                    this.autoScrollCnt = 0;
                }
                if (this.currentGlyph == null) {
                    return;
                }
                Real distance = this.currentGlyph.getDistance();
                if (distance != null) {
                    Unit distanceUnit = this.getDistanceUnit();
                    this.msgLabel.setText(" Distance: " + this.formatDistance(distance));
                }
                if (this.currentCmd.equals(CMD_MOVE)) {
                    this.setSelection(this.currentGlyph);
                    this.currentGlyph.doMove(event);
                    if (this.glyphTable != null) {
                        this.glyphTable.repaint();
                    }
                    return;
                }
                if (this.currentCmd.equals(CMD_STRETCH)) {
                    this.setSelection(this.currentGlyph);
                    this.currentGlyph.doStretch(event);
                    if (this.glyphTable != null) {
                        this.glyphTable.repaint();
                    }
                    return;
                }
                this.setCurrentGlyph(this.currentGlyph, this.currentGlyph.handleMouseDragged(event));
            } else if (id == 7) {
                if (this.skipNextMouseReleased) {
                    this.skipNextMouseReleased = false;
                    return;
                }
                if (!DrawingControl.isLeftButtonDown(event)) {
                    return;
                }
                if (this.currentGlyph == null) {
                    this.createGlyph(event, false);
                } else if (!this.currentGlyph.isValid()) {
                    this.removeGlyph(this.currentGlyph);
                    this.setCurrentGlyph(this.currentGlyph, null);
                } else {
                    DrawingGlyph glyphNow = this.currentGlyph;
                    this.setSelection(this.currentGlyph);
                    DrawingGlyph nextGlyph = this.currentGlyph.handleMouseReleased(event);
                    this.setCurrentGlyph(this.currentGlyph, nextGlyph);
                    if (nextGlyph == null) {
                        this.doneMovingGlyph(glyphNow);
                    }
                }
            }
        }
        catch (Exception e) {
            DrawingControl.logException("Handling display event changed", e);
        }
    }

    protected void doneMovingGlyph(DrawingGlyph glyph) {
    }

    public DrawingGlyph closestGlyph(DisplayEvent event) {
        return this.closestGlyph(event, false);
    }

    public DrawingGlyph closestGlyph(DisplayEvent event, boolean forMove) {
        try {
            DrawingGlyph closestGlyph = null;
            VisADRay ray = this.getNavigatedDisplay().getRay(event.getX(), event.getY());
            double[] box1 = new double[]{0.0, 0.0};
            double[] box2 = new double[]{100.0, 0.0};
            double[] location = this.toBox(event);
            double[] vector = this.getNavigatedDisplay().getRayDirection(event.getX(), event.getY());
            Component comp = this.displayHolder.getDisplayMaster().getDisplayComponent();
            Rectangle bounds = comp.getBounds();
            double[] ul = this.screenToBox(0, 0);
            double[] lr = this.screenToBox((int)bounds.getWidth(), (int)bounds.getHeight());
            double diagonal = DrawingGlyph.distanceBetween(ul, lr);
            double minDistance = diagonal * 0.05;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                double tmpDistance;
                DrawingGlyph glyph = (DrawingGlyph)this.glyphs.get(i);
                if (!glyph.isVisible() || !glyph.isSelectable() || forMove && !glyph.getEditable() || !((tmpDistance = glyph.distance(location, vector)) < minDistance)) continue;
                minDistance = tmpDistance;
                closestGlyph = glyph;
            }
            return closestGlyph;
        }
        catch (Exception exc) {
            DrawingControl.logException("Closest glyph", exc);
            return null;
        }
    }

    public void removeGlyph(DrawingGlyph glyph) {
        glyph.setBeenRemoved(true);
        this.glyphs.remove(glyph);
        this.selectedGlyphs.remove(glyph);
        if (this.glyphTable != null) {
            this.glyphTable.glyphsChanged();
        }
        try {
            this.displayHolder.removeDisplayable(glyph.getDisplayable());
        }
        catch (Exception exc) {
            DrawingControl.logException("Removing glyph", exc);
        }
    }

    private void clearSelection() throws VisADException, RemoteException {
        this.setSelection(new ArrayList(), false);
    }

    private void clearSelection(List newSelection) throws VisADException, RemoteException {
        ArrayList tmp = new ArrayList(this.selectedGlyphs);
        for (int i = 0; i < tmp.size(); ++i) {
            DrawingGlyph g = (DrawingGlyph)tmp.get(i);
            if (newSelection != null && newSelection.contains(g)) continue;
            g.setSelected(false);
            this.selectedGlyphs.remove(g);
        }
        this.selectionChanged();
    }

    protected void selectionChanged() {
        if (this.glyphTable != null) {
            this.glyphTable.selectionChanged();
        }
    }

    public void setSelection(DrawingGlyph glyph) throws VisADException, RemoteException {
        this.setSelection(Misc.newList(glyph), false);
    }

    public void setSelection(List newSelection, boolean addTo) throws VisADException, RemoteException {
        if (newSelection.equals(this.selectedGlyphs)) {
            return;
        }
        ArrayList oldSelection = new ArrayList(this.selectedGlyphs);
        this.setDisplayInactive();
        if (!addTo) {
            this.clearSelection(newSelection);
        }
        for (int i = 0; i < newSelection.size(); ++i) {
            DrawingGlyph g = (DrawingGlyph)newSelection.get(i);
            if (!g.isVisible() || this.selectedGlyphs.contains(g)) continue;
            this.selectedGlyphs.add(g);
            g.setSelected(true);
        }
        if (!oldSelection.equals(this.selectedGlyphs)) {
            this.selectionChanged();
        }
        this.setDisplayActive();
    }

    public boolean isSelected(DrawingGlyph glyph) {
        return this.selectedGlyphs.contains(glyph);
    }

    protected void doCut() throws VisADException, RemoteException {
        this.setDisplayInactive();
        ArrayList tmp = new ArrayList(this.selectedGlyphs);
        ArrayList<DrawingGlyph> cutGlyphs = new ArrayList<DrawingGlyph>();
        for (int i = 0; i < tmp.size(); ++i) {
            DrawingGlyph g = (DrawingGlyph)tmp.get(i);
            if (!g.isVisible()) continue;
            this.removeGlyph(g);
            cutGlyphs.add(g);
        }
        this.clipboardXml = this.toXml(cutGlyphs);
        this.selectionChanged();
        this.setDisplayActive();
    }

    public void doProperties(final List glyphs) throws VisADException, RemoteException {
        if (glyphs.size() > 0 && glyphs.size() < 4) {
            Misc.runInABit(1L, new Runnable(){

                @Override
                public void run() {
                    DrawingControl.this.doPropertiesInner(glyphs);
                }
            });
        }
    }

    private void doPropertiesInner(List glyphs) {
        try {
            for (int i = 0; i < glyphs.size(); ++i) {
                ((DrawingGlyph)glyphs.get(i)).setProperties();
            }
        }
        catch (Exception exc) {
            DrawingControl.logException("Do properties", exc);
        }
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        super.receiveShareData(from, dataId, data);
    }

    protected void setCurrentCommand(DrawingCommand command) {
        if (this.filledCbx != null) {
            this.filledCbx.setEnabled(command.isCapable(2));
            this.fullLatLonCbx.setEnabled(command.isCapable(4));
        }
        if (this.straightCbx != null) {
            this.straightCbx.setEnabled(command.isCapable(8));
        }
        this.setCurrentGlyph(this.currentGlyph, null);
        this.currentCmd = command;
        this.setCursor();
        this.msgLabel.setText(command.getMessage());
    }

    private void setCursor() {
        if (this.enabledCbx == null || this.currentCmd == null) {
            return;
        }
        if (!this.enabledCbx.isSelected() || !this.canHandleEvents()) {
            this.clearCursor();
            return;
        }
        if (this.currentCmd.equals(CMD_MOVE)) {
            this.setCursor(12);
        } else if (this.currentCmd.equals(CMD_STRETCH)) {
            this.setCursor(13);
        } else {
            this.clearCursor();
        }
    }

    protected JPanel makeButtonPanel(List commands, ButtonGroup bg) {
        ArrayList<JToggleButton> buttons = new ArrayList<JToggleButton>();
        for (int i = 0; i < commands.size(); ++i) {
            final DrawingCommand cmd = (DrawingCommand)commands.get(i);
            JToggleButton btn = GuiUtils.getToggleButton(cmd.getIconPath(), 4, 4);
            btn.setToolTipText(cmd.getLabel());
            bg.add(btn);
            if (Misc.equals(this.currentCmd, cmd)) {
                btn.setSelected(true);
                this.msgLabel.setText(cmd.getMessage());
                this.setCurrentCommand(cmd);
            }
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DrawingControl.this.setCurrentCommand(cmd);
                }
            });
            buttons.add(btn);
        }
        if (buttons.size() > this.shapeColumns) {
            return GuiUtils.colGrid(GuiUtils.getComponentArray(buttons), this.shapeColumns);
        }
        return GuiUtils.hflow(buttons, 4, 0);
    }

    protected List getShapeCommands() {
        ArrayList<DrawingCommand> commands = new ArrayList<DrawingCommand>();
        commands.add(GlyphCreatorCommand.CMD_SMOOTHPOLYGON);
        commands.add(GlyphCreatorCommand.CMD_CLOSEDPOLYGON);
        commands.add(GlyphCreatorCommand.CMD_RECTANGLE);
        commands.add(GlyphCreatorCommand.CMD_DIAMOND);
        commands.add(GlyphCreatorCommand.CMD_ARROW);
        commands.add(GlyphCreatorCommand.CMD_HARROW);
        commands.add(GlyphCreatorCommand.CMD_VARROW);
        commands.add(GlyphCreatorCommand.CMD_TEXT);
        commands.add(GlyphCreatorCommand.CMD_WAYPOINT);
        commands.add(GlyphCreatorCommand.CMD_IMAGE);
        commands.add(GlyphCreatorCommand.CMD_MOVIE);
        commands.add(GlyphCreatorCommand.CMD_SYMBOL);
        this.shapeColumns = commands.size();
        if (this.showFronts) {
            commands.add(GlyphCreatorCommand.CMD_HIGH);
            commands.add(GlyphCreatorCommand.CMD_LOW);
            for (int i = 0; i < FrontDrawer.BASETYPES.length; ++i) {
                final String type = FrontDrawer.BASETYPES[i];
                String label = FrontDrawer.getLabel(type).toLowerCase();
                String icon = "/auxdata/ui/icons/ColdFront16.gif";
                if (type.equals("WARM_FRONT")) {
                    icon = "/auxdata/ui/icons/WarmFront16.gif";
                } else if (type.equals("OCCLUDED_FRONT")) {
                    icon = "/auxdata/ui/icons/OccludedFront16.gif";
                } else if (type.equals("STATIONARY_FRONT")) {
                    icon = "/auxdata/ui/icons/StationaryFront16.gif";
                } else if (type.equals("TROUGH")) {
                    icon = "/auxdata/ui/icons/Trough16.gif";
                } else if (type.equals("WAVE_LINE")) {
                    icon = "/auxdata/ui/icons/WaveLine.png";
                }
                commands.add(new GlyphCreatorCommand("Create " + StringUtil.getAnOrA(label) + " " + label, "Click and drag: create " + StringUtil.getAnOrA(label) + " " + label, icon, 8){

                    @Override
                    public DrawingGlyph createGlyph(DrawingControl control, DisplayEvent event) throws VisADException, RemoteException {
                        return new FrontGlyph(control, event, type, !DrawingControl.this.getStraight());
                    }
                });
            }
        }
        return commands;
    }

    protected JComponent doMakeShapesPanel() {
        JPanel contents = GuiUtils.inset((Component)this.doMakeTablePanel(), 4);
        if (this.displayOnly) {
            this.zPositionPanel = GuiUtils.hgrid(this.doMakeZPositionSlider(), GuiUtils.filler());
            contents = GuiUtils.centerBottom(contents, GuiUtils.label("Z Position: ", this.zPositionPanel));
            return GuiUtils.centerBottom(contents, this.msgLabel);
        }
        return contents;
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JTabbedPane tabbedPane = new JTabbedPane();
        if (this.frontDisplay) {
            tabbedPane.add("Fronts", this.doMakeShapesPanel());
        } else {
            if (!this.editable) {
                return GuiUtils.topCenter(this.doMakeControlsPanel(), this.doMakeShapesPanel());
            }
            tabbedPane.add("Controls", GuiUtils.top(this.doMakeControlsPanel()));
            if (this.editable) {
                tabbedPane.add("Style", GuiUtils.top(this.doMakeStylePanel()));
            }
            tabbedPane.add("Shapes", this.doMakeShapesPanel());
        }
        return GuiUtils.centerBottom(tabbedPane, this.msgLabel);
    }

    @Override
    public void zSliderChanged(double value) {
        super.zSliderChanged(value);
        if (this.displayOnly) {
            try {
                this.applyZPosition(this.glyphs);
            }
            catch (Exception exc) {
                DrawingControl.logException("Setting z position", exc);
            }
        }
    }

    protected JComponent doMakeControlsPanel() {
        JComponent titleLabel = null;
        titleLabel = this.editorTitle != null ? new JLabel(this.editorTitle) : new JPanel();
        if (!this.editable) {
            return titleLabel;
        }
        ArrayList widgets = new ArrayList();
        this.addControlWidgets(widgets);
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        JPanel comps = GuiUtils.doLayout(widgets, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        return GuiUtils.top(GuiUtils.topCenter(titleLabel, comps));
    }

    protected void addControlWidgets(List widgets) {
        this.msgLabel = new JLabel("");
        this.msgLabel.setBorder(new FineLineBorder(1));
        int[] coords = new int[]{0, 1, 2, 3};
        String[] coordLabels = new String[]{"X/Y/Z", "X/Y", "Lat/Lon/Alt", "Lat/Lon"};
        ArrayList<TwoFacedObject> coordItems = new ArrayList<TwoFacedObject>();
        TwoFacedObject coordTfo = null;
        for (int i = 0; i < coords.length; ++i) {
            TwoFacedObject tfo = new TwoFacedObject((Object)coordLabels[i], coords[i]);
            if (coords[i] == this.coordType) {
                coordTfo = tfo;
            }
            coordItems.add(tfo);
        }
        this.zPositionPanel = GuiUtils.hgrid(this.doMakeZPositionSlider(), GuiUtils.filler());
        final JComboBox coordBox = new JComboBox();
        GuiUtils.setListData(coordBox, coordItems);
        if (coordTfo != null) {
            coordBox.setSelectedItem(coordTfo);
        }
        coordBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TwoFacedObject tfo = (TwoFacedObject)coordBox.getSelectedItem();
                DrawingControl.this.coordType = (Integer)tfo.getId();
                DrawingControl.this.checkZSliderEnabled();
            }
        });
        this.filledCbx = new JCheckBox("Filled", this.filled);
        this.straightCbx = new JCheckBox("Straight", this.straight);
        this.fullLatLonCbx = new JCheckBox("Full Lat/Lon", this.fullLatLon);
        this.useTimeCbx = new JCheckBox("Draw In Current Time", this.useTime);
        this.ignoreTimeCbx = new JCheckBox("Show All", this.ignoreTime);
        this.ignoreTimeCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DrawingControl.this.checkGlyphTimes();
            }
        });
        this.enabledCbx = new JCheckBox("Enabled", this.enabled);
        this.enabledCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DrawingControl.this.setCursor();
            }
        });
        this.makeModePanel(widgets);
        if (this.showLocationWidgets()) {
            widgets.add(GuiUtils.rLabel("Coordinates:"));
            widgets.add(GuiUtils.left(GuiUtils.flow(new Component[]{coordBox, this.fullLatLonCbx})));
        }
        widgets.add(GuiUtils.rLabel("Z Position:"));
        widgets.add(this.zPositionPanel);
        this.checkZSliderEnabled();
        if (this.showTimeWidgets()) {
            widgets.add(GuiUtils.rLabel("Time:"));
            widgets.add(GuiUtils.left(GuiUtils.flow(new Component[]{this.useTimeCbx, this.ignoreTimeCbx})));
        }
    }

    @Override
    protected double getInitialZPosition() {
        return super.getInitialZPosition() + 0.005;
    }

    protected void makeModePanel(List widgets) {
        List commands = Misc.newList(CMD_SELECT, CMD_MOVE, CMD_STRETCH);
        List shapes = this.getShapeCommands();
        ButtonGroup bg = new ButtonGroup();
        widgets.add(GuiUtils.rLabel("Mode:"));
        widgets.add(GuiUtils.leftCenter(this.makeButtonPanel(commands, bg), GuiUtils.left(this.enabledCbx)));
        widgets.add(GuiUtils.rLabel("Shapes:"));
        if (this.showFilledCbx()) {
            widgets.add(GuiUtils.leftCenter(this.makeButtonPanel(shapes, bg), GuiUtils.left(GuiUtils.hbox(this.filledCbx, this.straightCbx))));
        } else {
            widgets.add(GuiUtils.left(this.makeButtonPanel(shapes, bg)));
        }
    }

    protected JComponent doMakeTablePanel() {
        this.glyphTableModel = new GlyphTableModel();
        this.glyphTable = new GlyphTable(this.glyphTableModel);
        JScrollPane sp = GuiUtils.makeScrollPane(this.glyphTable, 200, 100);
        sp.setPreferredSize(new Dimension(200, 100));
        JPanel tablePanel = GuiUtils.center(sp);
        this.glyphTable.selectionChanged();
        return tablePanel;
    }

    protected JComponent doMakeStylePanel() {
        ArrayList<JComponent> styleWidgets = new ArrayList<JComponent>();
        Color c = this.getColor();
        if (c == null) {
            c = Color.red;
        }
        GuiUtils.ColorSwatch colorSwatch = new GuiUtils.ColorSwatch(c, "Set color", true){

            @Override
            public void setBackground(Color newColor) {
                super.setBackground(newColor);
                try {
                    DrawingControl.this.setColor(newColor);
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Setting color", exc);
                }
            }
        };
        colorSwatch.setMinimumSize(new Dimension(20, 20));
        colorSwatch.setPreferredSize(new Dimension(20, 20));
        GuiUtils.ColorSwatch colorCbx = colorSwatch;
        JComboBox widthComp = DrawingControl.doMakeLineWidthBox(this.lineWidth);
        widthComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox theBox = (JComboBox)e.getSource();
                DrawingControl.this.setLineWidth((Integer)theBox.getSelectedItem());
            }
        });
        this.fontBox = GuiUtils.doMakeFontBox(new Font("Dialog", 0, 12));
        this.fontSizeBox = GuiUtils.doMakeFontSizeBox(12);
        this.justificationBox = new JComboBox(new Vector(Misc.newList("Left", "Center", "Right")));
        this.vertJustificationBox = new JComboBox(new Vector(Misc.newList("Bottom", "Center", "Top")));
        JPanel fontPanel = GuiUtils.flow(new Component[]{this.fontBox, new JLabel("Size: "), this.fontSizeBox});
        JPanel justPanel = GuiUtils.flow(new Component[]{this.justificationBox, this.vertJustificationBox});
        styleWidgets.add(GuiUtils.rLabel("Color:"));
        styleWidgets.add(GuiUtils.left(GuiUtils.hflow(Misc.newList(colorCbx, GuiUtils.filler(10, 5), GuiUtils.rLabel("Line Width:  "), GuiUtils.left(widthComp)), 4, 0)));
        styleWidgets.add(GuiUtils.rLabel("Font:"));
        styleWidgets.add(GuiUtils.left(fontPanel));
        styleWidgets.add(GuiUtils.rLabel("Justification:"));
        styleWidgets.add(GuiUtils.left(justPanel));
        if (this.getShowFronts()) {
            this.scaleFld = new JTextField("" + this.frontScale, 5);
            styleWidgets.add(GuiUtils.rLabel("Front Scale:"));
            styleWidgets.add(GuiUtils.left(this.scaleFld));
        }
        GuiUtils.tmpInsets = new Insets(4, 4, 0, 4);
        return GuiUtils.doLayout(styleWidgets, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
    }

    protected void checkZSliderEnabled() {
        boolean posEnabled = this.coordType == 1 || this.coordType == 3;
    }

    protected boolean showFilledCbx() {
        return true;
    }

    protected boolean showTimeWidgets() {
        return true;
    }

    protected boolean showLocationWidgets() {
        return true;
    }

    public ColorTable getRGBColorTable() {
        return this.getDisplayConventions().getParamColorTable("image");
    }

    public static JComboBox doMakeLineWidthBox(int lineWidth) {
        int[] widths = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        Vector<Integer> values = new Vector<Integer>();
        for (int i = 0; i < widths.length; ++i) {
            values.add(new Integer(widths[i]));
        }
        JComboBox box = new JComboBox(values);
        box.setSelectedItem(new Integer(lineWidth));
        box.setToolTipText("Change width of lines");
        return box;
    }

    public int getCoordType() {
        return this.coordType;
    }

    protected void setCoordType(int c) {
        this.coordType = c;
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (!this.editable || this.displayOnly) {
            super.getEditMenuItems(items, forMenuBar);
            return;
        }
        items.add(GuiUtils.makeMenuItem("Remove All", this, "removeAllGlyphs"));
        if (!this.checkFlag(1)) {
            items.add(GuiUtils.makeMenuItem("Apply Color to Selected", this, "applyColorToAll"));
            items.add(GuiUtils.makeMenuItem("Apply Z Position to Selected", this, "applyZPosition", this.selectedGlyphs));
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void getFileMenuItems(List items, boolean forMenuBar) {
        super.getFileMenuItems(items, forMenuBar);
        this.addFileMenuItems(items, forMenuBar);
    }

    protected void addFileMenuItems(List items, boolean forMenuBar) {
        items.add("separator");
        JMenuItem mi = new JMenuItem("Export Drawing...");
        items.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DrawingControl.this.doExport();
            }
        });
        if (!this.displayOnly) {
            mi = new JMenuItem("Import Drawing...");
            items.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    DrawingControl.this.doImport();
                }
            });
        }
    }

    private void doImport() {
        try {
            String filename = FileManager.getReadFile(FILTER_XGRF);
            if (filename == null) {
                return;
            }
            Element root = XmlUtil.getRoot(filename, this.getClass());
            this.processXml(root, false);
        }
        catch (Exception exc) {
            DrawingControl.logException("Importing drawing", exc);
        }
    }

    private void doImportXml(String xml) {
        try {
            Element root = XmlUtil.getRoot(xml);
            this.processXml(root, false);
        }
        catch (Exception exc) {
            DrawingControl.logException("Importing drawing", exc);
        }
    }

    private void doExport() {
        try {
            String filename;
            this.loadAsMapData = null;
            Boolean okayMap = true;
            for (int i = 0; i < this.glyphs.size(); ++i) {
                if (((DrawingGlyph)this.glyphs.get(i)).getTagName() == "polygon") continue;
                okayMap = false;
            }
            if (okayMap.booleanValue()) {
                this.loadAsMapData = new JCheckBox("Load polygons as map data", false);
                this.loadAsMapData.setToolTipText("Load polygons in this xgrf file back in as map data");
            }
            if ((filename = FileManager.getWriteFile(FILTER_XGRF, SUFFIX_XGRF, (JComponent)GuiUtils.top(this.loadAsMapData))) == null) {
                return;
            }
            String xml = this.toXml(this.glyphs);
            if (xml == null) {
                return;
            }
            IOUtil.writeFile(filename, xml);
            if (this.loadAsMapData != null && this.loadAsMapData.isSelected()) {
                this.getIdv().makeOneDataSource(filename, "FILE.MAPFILE", null);
            }
        }
        catch (Exception exc) {
            DrawingControl.logException("Exporting drawing", exc);
        }
    }

    private String toXml(List glyphs) {
        try {
            Document doc = XmlUtil.getDocument("<shapes></shapes>");
            Element root = doc.getDocumentElement();
            for (int i = 0; i < glyphs.size(); ++i) {
                DrawingGlyph g = (DrawingGlyph)glyphs.get(i);
                root.appendChild(g.getElement(doc));
            }
            return XmlUtil.toStringWithHeader(root);
        }
        catch (Exception exc) {
            DrawingControl.logException("Exporting drawing", exc);
            return null;
        }
    }

    public void applyColorToAll() {
        for (int i = 0; i < this.selectedGlyphs.size(); ++i) {
            ((DrawingGlyph)this.selectedGlyphs.get(i)).setColor(this.getColor());
        }
    }

    public void applyZPosition(List glyphs) throws VisADException, RemoteException {
        for (int i = 0; i < glyphs.size(); ++i) {
            DrawingGlyph glyph = (DrawingGlyph)glyphs.get(i);
            if (!glyph.isInFlatSpace()) continue;
            glyph.setZPosition((float)this.getZPosition());
            glyph.updateLocation();
        }
    }

    public void removeAllGlyphs() {
        try {
            while (this.glyphs.size() > 0) {
                this.removeGlyph((DrawingGlyph)this.glyphs.get(0));
            }
        }
        catch (Exception exc) {
            DrawingControl.logException("Removing drawings", exc);
        }
        this.selectionChanged();
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    public DateTime[] getAllTimes() throws VisADException, RemoteException {
        DateTime[] times = null;
        Animation animation = this.getViewAnimation();
        if (animation == null) {
            return times;
        }
        Set timeSet = animation.getSet();
        if (timeSet == null) {
            return times;
        }
        if (timeSet instanceof Gridded1DSet) {
            return CalendarDateTime.timeSetToArray((Gridded1DSet)timeSet);
        }
        return new DateTime[]{new DateTime((Real)((SingletonSet)timeSet).getData().getComponent(0))};
    }

    public Real getCurrentTime() throws VisADException, RemoteException {
        Animation animation = this.getViewAnimation();
        if (animation == null) {
            return null;
        }
        if (animation.getNumSteps() == 0) {
            return null;
        }
        Real r = animation.getAniValue();
        if (r.isMissing()) {
            return null;
        }
        return r;
    }

    public Set getAnimationSet() throws VisADException, RemoteException {
        Animation animation = this.getViewAnimation();
        if (animation == null) {
            return null;
        }
        return animation.getSet();
    }

    public Real getTimeForGlyph() throws VisADException, RemoteException {
        if (this.useTimeCbx == null) {
            return null;
        }
        if (!this.useTimeCbx.isSelected()) {
            return null;
        }
        Animation animation = this.getViewAnimation();
        if (animation == null) {
            return null;
        }
        if (animation.getNumSteps() == 0) {
            return null;
        }
        Real r = animation.getAniValue();
        if (r.isMissing()) {
            return null;
        }
        return r;
    }

    public String getJustification() {
        if (this.justificationBox == null) {
            return "Left";
        }
        return ((String)this.justificationBox.getSelectedItem()).toLowerCase();
    }

    public String getVerticalJustification() {
        if (this.vertJustificationBox == null) {
            return "Bottom";
        }
        return ((String)this.vertJustificationBox.getSelectedItem()).toLowerCase();
    }

    public Font getFont() {
        if (this.fontBox == null) {
            return null;
        }
        Font font = (Font)((TwoFacedObject)this.fontBox.getSelectedItem()).getId();
        int fontSize = (Integer)this.fontSizeBox.getSelectedItem();
        return font.deriveFont((float)fontSize);
    }

    public void setLines(UnionSet lines) {
    }

    public void setActive(boolean b) {
    }

    public void setGlyphs(List value) {
        this.glyphs = value;
    }

    public List getGlyphs() {
        if (this.displayOnly) {
            return new ArrayList();
        }
        return this.glyphs;
    }

    public void setIgnoreTime(boolean value) {
        this.ignoreTime = value;
    }

    public boolean getIgnoreTime() {
        if (this.ignoreTimeCbx != null) {
            return this.ignoreTimeCbx.isSelected();
        }
        return this.ignoreTime;
    }

    public void setUseTime(boolean value) {
        this.useTime = value;
    }

    public boolean getUseTime() {
        if (this.useTimeCbx != null) {
            return this.useTimeCbx.isSelected();
        }
        return this.useTime;
    }

    public void setEditable(boolean value) {
        this.editable = value;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public boolean getEnabled() {
        if (this.enabledCbx != null) {
            return this.enabledCbx.isSelected();
        }
        return this.enabled;
    }

    public void setEditorTitle(String value) {
        this.editorTitle = value;
    }

    public String getEditorTitle() {
        return this.editorTitle;
    }

    private void clearCursor() {
        this.setCursor(null);
    }

    private void setCursor(int c) {
        this.setCursor(Cursor.getPredefinedCursor(c));
    }

    private void setCursor(Cursor c) {
        this.getViewManager().setCursorInDisplay(c);
    }

    public void setFilled(boolean value) {
        this.filled = value;
    }

    public boolean getFilled() {
        if (this.filledCbx != null) {
            return this.filledCbx.isSelected();
        }
        return this.filled;
    }

    public void setStraight(boolean value) {
        this.straight = value;
    }

    public boolean getStraight() {
        if (this.straightCbx != null) {
            return this.straightCbx.isSelected();
        }
        return this.straight;
    }

    public void setFullLatLon(boolean value) {
        this.fullLatLon = value;
    }

    public boolean getFullLatLon() {
        if (this.fullLatLonCbx != null) {
            return this.fullLatLonCbx.isSelected();
        }
        return this.fullLatLon;
    }

    public void evaluateGlyphJython(DrawingGlyph glyph, String jython) {
        this.glyphJython = jython;
        PythonInterpreter interpreter = this.getControlContext().getJythonManager().createInterpreter();
        interpreter.set("glyph", glyph);
        interpreter.set("control", this);
        interpreter.exec(jython);
    }

    public void setGlyphJython(String value) {
        this.glyphJython = value;
    }

    public String getGlyphJython() {
        return this.glyphJython;
    }

    protected String getGlyphNameDefault(DrawingGlyph glyph) {
        return "Glyph";
    }

    public void setShowFronts(boolean value) {
        this.showFronts = value;
    }

    public boolean getShowFronts() {
        return this.showFronts;
    }

    public void setFrontScale(double value) {
        this.frontScale = value;
    }

    public double getFrontScale() {
        if (this.scaleFld != null) {
            return Double.parseDouble(this.scaleFld.getText().trim());
        }
        return this.frontScale;
    }

    public void setFrontDisplay(boolean value) {
        this.frontDisplay = value;
    }

    public boolean getFrontDisplay() {
        return this.frontDisplay;
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        String magStr;
        super.addLabelMacros(template, patterns, values);
        if (this.datachoice != null && (magStr = (String)this.datachoice.getProperty("KMLWARNING")) != null) {
            this.setExtraLabelTemplate("%longname%");
        }
    }

    @Override
    protected String getDefaultDisplayListTemplate() {
        String magStr;
        if (this.datachoice != null && (magStr = (String)this.datachoice.getProperty("KMLWARNING")) != null) {
            return "%shortname% - %longname%";
        }
        return super.getDefaultDisplayListTemplate();
    }

    static {
        CMD_SELECT = new DrawingCommand("Select", "Click to select; CTRL+x to cut; CTRL+P to set properties", "/ucar/unidata/ui/drawing/images/pointer.gif");
        CMD_MOVE = new DrawingCommand("Move or stretch graphic", "Drag: move graphic; Control-Drag: stretch graphic", "/auxdata/ui/icons/Move16.gif");
        CMD_STRETCH = new DrawingCommand("Stretch graphic", "Drag: reshape graphic", "/auxdata/ui/icons/Reshape16.gif");
    }

    public class GlyphTableModel
    extends AbstractTableModel {
        boolean ignoreChanges = false;

        @Override
        public void fireTableStructureChanged() {
            if (!this.ignoreChanges) {
                super.fireTableStructureChanged();
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            if (DrawingControl.this.glyphs == null) {
                return 0;
            }
            return DrawingControl.this.glyphs.size();
        }

        @Override
        public int getColumnCount() {
            if (!DrawingControl.this.editable) {
                return 3;
            }
            return 4;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= DrawingControl.this.glyphs.size()) {
                return "";
            }
            DrawingGlyph glyph = (DrawingGlyph)DrawingControl.this.glyphs.get(row);
            if (column == 0) {
                String name = glyph.getName();
                if (!glyph.getVisibleFlag()) {
                    name = name + " (hidden)";
                }
                return name;
            }
            if (column == 1) {
                return glyph.getDescription();
            }
            if (!DrawingControl.this.editable) {
                return glyph.getExtraDescription();
            }
            if (column == 2) {
                int type = glyph.getCoordType();
                for (int i = 0; i < DrawingGlyph.COORD_TYPES.length; ++i) {
                    if (type != DrawingGlyph.COORD_TYPES[i]) continue;
                    return DrawingGlyph.COORD_LABELS[i];
                }
                return "";
            }
            return glyph.getExtraDescription();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            if (column == 1) {
                return "Type";
            }
            if (column == 2) {
                return "Coordinates";
            }
            if (column == 3) {
                return "Properties";
            }
            if (!DrawingControl.this.editable) {
                return "";
            }
            return "";
        }
    }

    public class GlyphTable
    extends JTable {
        GlyphTableModel myTableModel;

        public GlyphTable(GlyphTableModel tableModel) {
            super(tableModel);
            this.setSelectionMode(2);
            this.setToolTipText("<html>Double Click to  show properties<br>Delete to delete</html>");
            this.myTableModel = tableModel;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    int[] rows;
                    if (ke.getKeyCode() == 70 && ke.isControlDown()) {
                        rows = GlyphTable.this.getSelectedRows();
                        int row = -1;
                        for (int i = 0; i < rows.length; ++i) {
                            DrawingGlyph glyph;
                            row = rows[i];
                            if (row < 0 || row >= DrawingControl.this.glyphs.size() || !((glyph = (DrawingGlyph)DrawingControl.this.glyphs.get(row)) instanceof PolyGlyph)) continue;
                            try {
                                ((PolyGlyph)glyph).doFlythrough();
                            }
                            catch (Exception exc) {
                                DisplayControlBase.logException("", exc);
                            }
                            return;
                        }
                    }
                    if (GuiUtils.isDeleteEvent(ke)) {
                        rows = GlyphTable.this.getSelectedRows();
                        ArrayList tmpGlyphs = new ArrayList(DrawingControl.this.glyphs);
                        boolean orig = DrawingControl.this.glyphTableModel.ignoreChanges;
                        DrawingControl.this.glyphTableModel.ignoreChanges = true;
                        int row = -1;
                        for (int i = 0; i < rows.length; ++i) {
                            row = rows[i];
                            if (row < 0 || row >= tmpGlyphs.size()) continue;
                            DrawingGlyph glyph = (DrawingGlyph)tmpGlyphs.get(row);
                            DrawingControl.this.removeGlyph(glyph);
                        }
                        DrawingControl.this.glyphTableModel.ignoreChanges = orig;
                        DrawingControl.this.glyphTableModel.fireTableStructureChanged();
                        if (row >= 0) {
                            if (--row < 0) {
                                row = 0;
                            }
                            if (row < DrawingControl.this.glyphs.size()) {
                                GlyphTable.this.setRowSelectionInterval(row, row);
                            }
                        }
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        return;
                    }
                    int row = GlyphTable.this.rowAtPoint(e.getPoint());
                    if (row < 0 || row >= DrawingControl.this.glyphs.size()) {
                        return;
                    }
                    try {
                        DrawingGlyph glyph = (DrawingGlyph)DrawingControl.this.glyphs.get(row);
                        if (e.getClickCount() > 1) {
                            DrawingControl.this.doProperties(Misc.newList(glyph));
                        }
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("", exc);
                    }
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.myTableModel == null) {
                return;
            }
            if (this.myTableModel.ignoreChanges) {
                return;
            }
            boolean orig = DrawingControl.this.glyphTableModel.ignoreChanges;
            DrawingControl.this.glyphTableModel.ignoreChanges = true;
            int[] rows = this.getSelectedRows();
            ArrayList<DrawingGlyph> selected = new ArrayList<DrawingGlyph>();
            for (int i = 0; i < rows.length; ++i) {
                DrawingGlyph glyph;
                int row = rows[i];
                if (row < 0 || row >= DrawingControl.this.glyphs.size() || !(glyph = (DrawingGlyph)DrawingControl.this.glyphs.get(row)).isSelectable()) continue;
                selected.add(glyph);
            }
            try {
                DrawingControl.this.setSelection(selected, false);
            }
            catch (Exception exc) {
                DisplayControlBase.logException("setting selection", exc);
            }
            DrawingControl.this.glyphTableModel.ignoreChanges = orig;
        }

        public void glyphsChanged() {
            DrawingControl.this.glyphTableModel.fireTableStructureChanged();
            this.selectionChanged();
        }

        protected void selectionChanged() {
            if (DrawingControl.this.glyphTableModel.ignoreChanges) {
                return;
            }
            boolean orig = DrawingControl.this.glyphTableModel.ignoreChanges;
            DrawingControl.this.glyphTableModel.ignoreChanges = true;
            this.clearSelection();
            for (int row = 0; row < DrawingControl.this.glyphs.size(); ++row) {
                DrawingGlyph glyph = (DrawingGlyph)DrawingControl.this.glyphs.get(row);
                if (!DrawingControl.this.isSelected(glyph)) continue;
                this.getSelectionModel().addSelectionInterval(row, row);
            }
            DrawingControl.this.glyphTableModel.ignoreChanges = orig;
        }
    }
}

