/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.ColorScaleDialog;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.idv.ui.ContourInfoDialog;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PropertyValue;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.visad.display.ColorScaleInfo;
import visad.Real;
import visad.Unit;

public class DisplaySettingsDialog {
    IntegratedDataViewer idv;
    JDialog dialog;
    private DisplayControlImpl display;
    private List<PropertyValueWrapper> propertyValues = new ArrayList<PropertyValueWrapper>();
    private JButton applyBtn;
    List<DisplayWrapper> displayWrappers;
    List displays;
    private JPanel propertiesHolder;
    private JScrollPane propertiesSP;
    private JComponent contents;
    private JMenuBar menuBar;
    private JList displaysList;
    private JList displaySettingsList;
    private static Font FONT_NORMAL;
    private static Font FONT_SELECTED;
    private static HashSet logSeen;

    public DisplaySettingsDialog(IntegratedDataViewer idv, DisplayControlImpl display) {
        this(idv, display, true);
    }

    public DisplaySettingsDialog(IntegratedDataViewer idv, DisplayControlImpl display, boolean showDialog) {
        this.idv = idv;
        this.displays = idv.getDisplayControls();
        if (display == null && this.displays.size() > 0) {
            display = (DisplayControlImpl)this.displays.get(0);
        }
        this.contents = this.doMakeContents();
        if (display != null) {
            this.setDisplay(display);
        }
        if (showDialog) {
            this.showDialog();
        }
    }

    public DisplaySettingsDialog(IntegratedDataViewer idv) {
        this(idv, null);
    }

    public DisplaySettingsDialog(DisplayControlImpl display) {
        this(display.getIdv(), display);
    }

    public List<PropertyValue> getPropertyValues() {
        ArrayList<PropertyValue> props = new ArrayList<PropertyValue>();
        for (int i = 0; i < this.propertyValues.size(); ++i) {
            PropertyValueWrapper prop = this.propertyValues.get(i);
            props.add(prop.propertyValue);
        }
        return props;
    }

    public void setDisplay(DisplayControlImpl display) {
        this.display = display;
        this.propertyValues = new ArrayList<PropertyValueWrapper>();
        display.addDisplaySettings(this);
        if (this.dialog != null) {
            this.dialog.setTitle("Display Settings -- " + display.getTitle());
        }
        if (display != null && this.displaysList != null) {
            this.displaysList.setSelectedValue(display, true);
        }
        this.updatePropertiesComponent();
    }

    public void addPropertyValue(Object object, String propName, String label, String category) {
        PropertyValue propertyValue = new PropertyValue(propName, label, object, category);
        this.propertyValues.add(new PropertyValueWrapper(propertyValue));
    }

    private void showDialog() {
        Window f = GuiUtils.getWindow(this.display.getContents());
        this.dialog = GuiUtils.createDialog(f, "", true);
        LogUtil.registerWindow(this.dialog);
        if (this.display != null) {
            this.dialog.setTitle("Display Settings -- " + this.display.getTitle());
        }
        this.dialog.getContentPane().add(this.contents);
        this.dialog.pack();
        if (f != null) {
            GuiUtils.showDialogNearSrc(f, this.dialog);
        } else {
            this.dialog.setLocation(new Point(200, 200));
            this.dialog.setVisible(true);
        }
    }

    private JComponent doMakeContents() {
        ArrayList<JCheckBox> comps;
        String label;
        this.displayWrappers = new ArrayList<DisplayWrapper>();
        ArrayList<String> viewLabels = new ArrayList<String>();
        Hashtable<Object, Object> viewMap = new Hashtable<Object, Object>();
        int viewCnt = 0;
        for (int i = 0; i < this.displays.size(); ++i) {
            DisplayControlImpl dci = (DisplayControlImpl)this.displays.get(i);
            DisplayWrapper dw = new DisplayWrapper(dci);
            this.displayWrappers.add(dw);
            ViewManager vm = dci.getDefaultViewManager();
            if (vm == null) {
                label = "No View";
            } else {
                label = (String)viewMap.get(vm);
                if (label == null) {
                    ++viewCnt;
                    label = vm.getName();
                }
                if (label == null || label.trim().length() == 0) {
                    label = "View " + viewCnt;
                }
                viewMap.put(vm, label);
            }
            comps = (ArrayList<JCheckBox>)viewMap.get(label);
            if (comps == null) {
                viewLabels.add(label);
                comps = new ArrayList<JCheckBox>();
                viewMap.put(label, comps);
            }
            comps.add(dw.cbx);
        }
        ArrayList<JPanel> displayComps = new ArrayList<JPanel>();
        Insets compInsets = new Insets(0, 15, 0, 0);
        Insets labelInsets = new Insets(5, 5, 0, 0);
        for (int i = 0; i < viewLabels.size(); ++i) {
            label = (String)viewLabels.get(i);
            comps = (List)viewMap.get(label);
            displayComps.add(GuiUtils.inset((Component)new JLabel(label), labelInsets));
            for (int compIdx = 0; compIdx < comps.size(); ++compIdx) {
                displayComps.add(GuiUtils.inset((Component)((JComponent)comps.get(compIdx)), compInsets));
            }
        }
        JPanel displaysComp = GuiUtils.vbox(displayComps);
        final JButton selectBtn = new JButton("Display Groups");
        selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DisplaySettingsDialog.this.popupDisplayGroupMenu(selectBtn);
            }
        });
        this.applyBtn = GuiUtils.makeButton("Apply>>", this, "doApply");
        JButton okBtn = GuiUtils.makeButton("OK", this, "doOk");
        JButton cancelBtn = GuiUtils.makeButton("Close", this, "doCancel");
        JButton saveBtn = GuiUtils.makeButton("Save", this, "doSave");
        this.propertiesHolder = new JPanel(new BorderLayout());
        int listHeight = 250;
        int listWidth = 200;
        this.displaysList = new JList(new Vector(this.displays));
        this.displaysList.setSelectionMode(0);
        this.displaysList.setBackground(null);
        JScrollPane displaysSP = GuiUtils.makeScrollPane(GuiUtils.top(this.displaysList), listWidth, listHeight);
        displaysSP.setPreferredSize(new Dimension(listWidth, listHeight));
        if (this.display != null) {
            this.displaysList.setSelectedValue(this.display, true);
        }
        this.displaysList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DisplayControlImpl display = (DisplayControlImpl)DisplaySettingsDialog.this.displaysList.getSelectedValue();
                if (display != null) {
                    DisplaySettingsDialog.this.displaySettingsList.clearSelection();
                    DisplaySettingsDialog.this.setDisplay(display);
                }
            }
        });
        this.displaySettingsList = new JList<DisplaySetting>(new Vector<DisplaySetting>(this.idv.getResourceManager().getDisplaySettings()));
        this.displaySettingsList.setBackground(null);
        this.displaySettingsList.setSelectionMode(0);
        JScrollPane displaySettingsSP = GuiUtils.makeScrollPane(GuiUtils.top(this.displaySettingsList), listWidth, listHeight);
        displaySettingsSP.setPreferredSize(new Dimension(listWidth, listHeight));
        this.displaySettingsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DisplaySetting displaySetting = (DisplaySetting)DisplaySettingsDialog.this.displaySettingsList.getSelectedValue();
                if (displaySetting != null) {
                    DisplaySettingsDialog.this.displaysList.clearSelection();
                    DisplaySettingsDialog.this.applyDisplaySetting(displaySetting);
                }
            }
        });
        JPanel propertiesComp = GuiUtils.inset((Component)this.propertiesHolder, 5);
        this.propertiesSP = GuiUtils.makeScrollPane(GuiUtils.top(propertiesComp), 300, 300);
        JScrollPane rightSP = GuiUtils.makeScrollPane(GuiUtils.top(displaysComp), 300, 300);
        this.propertiesSP.setPreferredSize(new Dimension(300, 300));
        rightSP.setPreferredSize(new Dimension(300, 300));
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JButton buttons = cancelBtn;
        JPanel sourceComp = GuiUtils.topCenter(new JLabel("Source"), GuiUtils.doLayout(new Component[]{new JLabel("Displays"), displaysSP, new JLabel("Saved Settings"), displaySettingsSP}, 1, GuiUtils.WT_Y, GuiUtils.WT_NYNY));
        JTabbedPane sourcePane = new JTabbedPane();
        sourcePane.addTab("Displays", displaysSP);
        sourcePane.addTab("Saved Settings", displaySettingsSP);
        sourceComp = GuiUtils.topCenter(new JLabel("Source"), sourcePane);
        JPanel propComp = GuiUtils.topCenter(new JLabel("Properties"), this.propertiesSP);
        JPanel targetComp = GuiUtils.topCenter(new JLabel("Target Displays"), rightSP);
        JPanel applyContents = GuiUtils.doLayout(new Component[]{sourceComp, propComp, GuiUtils.wrap(this.applyBtn), targetComp}, 4, new double[]{1.0, 1.25, 0.0, 1.0}, GuiUtils.WT_Y);
        applyContents = GuiUtils.centerBottom(applyContents, GuiUtils.wrap(buttons));
        applyContents = GuiUtils.inset((Component)applyContents, 5);
        ArrayList<JMenu> menus = new ArrayList<JMenu>();
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = GuiUtils.makeDynamicMenu("Select", this, "showSelectMenu");
        menus.add(fileMenu);
        menus.add(editMenu);
        fileMenu.add(GuiUtils.makeMenuItem("Save Selected Properties", this, "doSave"));
        this.menuBar = GuiUtils.makeMenuBar(menus);
        applyContents = GuiUtils.topCenter(this.menuBar, applyContents);
        return applyContents;
    }

    public void showSelectMenu(JMenu menu) {
        ControlDescriptor cd = this.idv.getControlDescriptor(this.display.getDisplayId());
        List dataSources = this.display.getDataSources();
        String dataSourceName = "";
        String dataSourceKey = null;
        if (dataSources != null && dataSources.size() > 0) {
            dataSourceName = DataSourceImpl.getNameForDataSource((DataSource)dataSources.get(0), 20, true);
            dataSourceKey = "withthisdata";
        }
        String[] keys = new String[]{"this", "all", "class:" + this.display.getClass().getName(), "category:" + this.display.getDisplayCategory(), dataSourceKey, this.display.getShortParamName() != null ? "withthisfield" : null, "withdata", "withthisview", "special"};
        String[] labels = new String[]{"This display", "All displays", "Displays of type: " + cd.getDescription(), "Displays with category: " + this.display.getDisplayCategory(), "Displays with data source: " + dataSourceName, "Displays with this field: " + this.display.getShortParamName(), "Displays with any data", "Displays in view", "Special displays"};
        for (int i = 0; i < keys.length; ++i) {
            final String key = keys[i];
            if (key == null) continue;
            JMenuItem mi = new JMenuItem(labels[i]);
            menu.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    List selected = DisplaySettingsDialog.this.display.findDisplays(key, DisplaySettingsDialog.this.displays);
                    for (int i = 0; i < DisplaySettingsDialog.this.displays.size(); ++i) {
                        DisplayWrapper dw = DisplaySettingsDialog.this.displayWrappers.get(i);
                        dw.cbx.setSelected(selected.contains(dw.dci));
                    }
                }
            });
        }
    }

    private void popupDisplayGroupMenu(JComponent comp) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ControlDescriptor cd = this.idv.getControlDescriptor(this.display.getDisplayId());
        List dataSources = this.display.getDataSources();
        String dataSourceName = "";
        String dataSourceKey = null;
        if (dataSources != null && dataSources.size() > 0) {
            dataSourceName = DataSourceImpl.getNameForDataSource((DataSource)dataSources.get(0), 20, true);
            dataSourceKey = "withthisdata";
        }
        String[] keys = new String[]{"this", "all", "class:" + this.display.getClass().getName(), "category:" + this.display.getDisplayCategory(), dataSourceKey, this.display.getShortParamName() != null ? "withthisfield" : null, "withdata", "withthisview", "special"};
        String[] labels = new String[]{"This display", "All displays", "Displays of type: " + cd.getDescription(), "Displays with category: " + this.display.getDisplayCategory(), "Displays with data source: " + dataSourceName, "Displays with this field: " + this.display.getShortParamName(), "Displays with any data", "Displays in view", "Special displays"};
        for (int i = 0; i < keys.length; ++i) {
            final String key = keys[i];
            if (key == null) continue;
            JMenuItem mi = new JMenuItem(labels[i]);
            items.add(mi);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    List selected = DisplaySettingsDialog.this.display.findDisplays(key, DisplaySettingsDialog.this.displays);
                    for (int i = 0; i < DisplaySettingsDialog.this.displays.size(); ++i) {
                        DisplayWrapper dw = DisplaySettingsDialog.this.displayWrappers.get(i);
                        dw.cbx.setSelected(selected.contains(dw.dci));
                    }
                }
            });
        }
        JPopupMenu popup = GuiUtils.makePopupMenu(items);
        popup.show(comp, 0, comp.getBounds().height);
    }

    private void updatePropertiesComponent() {
        ArrayList<String> cats = new ArrayList<String>();
        Hashtable<String, ArrayList<JPanel>> catMap = new Hashtable<String, ArrayList<JPanel>>();
        for (int i = 0; i < this.propertyValues.size(); ++i) {
            PropertyValueWrapper prop = this.propertyValues.get(i);
            ArrayList<JPanel> catComps = (ArrayList<JPanel>)catMap.get(prop.getCategory());
            if (catComps == null) {
                catComps = new ArrayList<JPanel>();
                catMap.put(prop.getCategory(), catComps);
                cats.add(prop.getCategory());
            }
            catComps.add(GuiUtils.leftRight(prop.getCheckbox(), prop.changeBtn));
        }
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int catIdx = 0; catIdx < cats.size(); ++catIdx) {
            String cat = (String)cats.get(catIdx);
            List catComps = (List)catMap.get(cat);
            comps.add(new JLabel(cat));
            Insets inset = new Insets(0, 10, 0, 0);
            for (int compIdx = 0; compIdx < catComps.size(); ++compIdx) {
                JComponent comp = (JComponent)catComps.get(compIdx);
                comps.add(GuiUtils.inset((Component)comp, inset));
            }
        }
        this.propertiesHolder.removeAll();
        this.propertiesHolder.add("Center", GuiUtils.vbox(comps));
        this.propertiesHolder.validate();
        this.propertiesHolder.repaint();
        this.propertiesSP.validate();
        this.propertiesSP.getViewport().scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    public void doSave() {
        ArrayList<PropertyValue> propList = new ArrayList<PropertyValue>();
        for (int i = 0; i < this.propertyValues.size(); ++i) {
            PropertyValueWrapper prop = this.propertyValues.get(i);
            if (!prop.getCheckbox().isSelected()) continue;
            propList.add(new PropertyValue(prop.propertyValue));
        }
        DisplaySetting.doSave(this.idv, this.dialog, propList, this.display);
        Object selected = this.displaySettingsList.getSelectedValue();
        this.displaySettingsList.setListData(new Vector<DisplaySetting>(this.idv.getResourceManager().getDisplaySettings()));
        if (selected != null) {
            this.displaySettingsList.setSelectedValue(selected, true);
        }
    }

    public void applyDisplaySetting(DisplaySetting displaySetting) {
        if (this.dialog != null) {
            this.dialog.setTitle("Display Settings -- " + displaySetting);
        }
        ArrayList<PropertyValue> newProps = new ArrayList<PropertyValue>(displaySetting.getPropertyValues());
        for (int propIdx = 0; propIdx < this.propertyValues.size(); ++propIdx) {
            PropertyValueWrapper oldProp = this.propertyValues.get(propIdx);
            boolean gotOne = false;
            for (int newPropIdx = 0; newPropIdx < newProps.size(); ++newPropIdx) {
                PropertyValue newProp = (PropertyValue)newProps.get(newPropIdx);
                if (!Misc.equals(newProp.getName(), oldProp.getName())) continue;
                gotOne = true;
                oldProp.propertyValue.setValue(newProp.getValue());
                oldProp.setCheckboxLabel();
                newProps.remove(newPropIdx);
                break;
            }
            oldProp.getCheckbox().setSelected(gotOne);
        }
        if (newProps.size() > 0) {
            for (int i = 0; i < newProps.size(); ++i) {
                PropertyValue newProp = new PropertyValue((PropertyValue)newProps.get(i));
                this.propertyValues.add(new PropertyValueWrapper(newProp, true));
            }
            this.updatePropertiesComponent();
        }
    }

    public static List makeDisplaySettingsMenuItems(List<DisplaySetting> displaySettings, Object object, String method, String labelPrefix) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        Hashtable<String, JMenu> catMenus = new Hashtable<String, JMenu>();
        for (int i = 0; i < displaySettings.size(); ++i) {
            DisplaySetting displaySetting = displaySettings.get(i);
            String label = displaySetting.getName();
            List<String> toks = StringUtil.split(label, ">", true, true);
            String catSoFar = "";
            JMenu parentMenu = null;
            for (int tokIdx = 0; tokIdx < toks.size() - 1; ++tokIdx) {
                String cat = toks.get(tokIdx);
                JMenu catMenu = (JMenu)catMenus.get(catSoFar = catSoFar + "-" + cat);
                if (catMenu == null) {
                    catMenu = new JMenu(cat);
                    catMenus.put(catSoFar, catMenu);
                    if (parentMenu == null) {
                        items.add(catMenu);
                    } else {
                        parentMenu.add(catMenu);
                    }
                }
                parentMenu = catMenu;
            }
            if (toks.size() > 0) {
                label = toks.get(toks.size() - 1);
            }
            JMenuItem mi = GuiUtils.makeMenuItem(labelPrefix + label, object, method, displaySetting);
            if (parentMenu == null) {
                items.add(mi);
                continue;
            }
            parentMenu.add(mi);
        }
        return items;
    }

    public void doCancel() {
        this.dialog.dispose();
    }

    public void doOk() {
        this.doApply();
        this.doCancel();
    }

    public void doApply() {
        final ArrayList<DisplayControlImpl> selectedDisplays = new ArrayList<DisplayControlImpl>();
        for (int i = 0; i < this.displayWrappers.size(); ++i) {
            DisplayWrapper dw = this.displayWrappers.get(i);
            if (!dw.cbx.isSelected()) continue;
            selectedDisplays.add(dw.dci);
        }
        final ArrayList<PropertyValue> propList = new ArrayList<PropertyValue>();
        for (int i = 0; i < this.propertyValues.size(); ++i) {
            PropertyValueWrapper prop = this.propertyValues.get(i);
            if (!prop.getCheckbox().isSelected()) continue;
            propList.add(prop.propertyValue);
        }
        this.applyBtn.setEnabled(false);
        this.display.showWaitCursor();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                DisplaySettingsDialog.applyPropertyValues(selectedDisplays, propList);
                DisplaySettingsDialog.this.display.showNormalCursor();
                DisplaySettingsDialog.this.applyBtn.setEnabled(true);
            }
        });
    }

    private static void applyPropertyValues(List selectedDisplays, List props) {
        try {
            for (int displayIdx = 0; displayIdx < selectedDisplays.size(); ++displayIdx) {
                DisplayControlImpl display = (DisplayControlImpl)selectedDisplays.get(displayIdx);
                display.applyPropertyValues(props);
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Applying properties", exc);
            return;
        }
    }

    public static String getValueLabel(Object v) {
        if (v == null) {
            return "null";
        }
        if (v instanceof Color) {
            Color c = (Color)v;
            return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
        }
        if (v instanceof ContourInfo) {
            ContourInfo ci = (ContourInfo)v;
            return ci.getInterval() + "/" + ci.getBase() + "/" + ci.getMin() + "/" + ci.getMax();
        }
        if (v instanceof ColorScaleInfo) {
            ColorScaleInfo csi = (ColorScaleInfo)v;
            return (csi.getIsVisible() ? "visible" : "not visible") + " " + csi.getPlacement();
        }
        return v.toString();
    }

    static {
        logSeen = new HashSet();
    }

    public class PropertyValueWrapper {
        PropertyValue propertyValue;
        private JCheckBox cbx;
        private JComponent changeBtn;

        public PropertyValueWrapper(PropertyValue propertyValue) {
            this(propertyValue, false);
        }

        public PropertyValueWrapper(PropertyValue propertyValue, boolean cbxValue) {
            this.propertyValue = propertyValue;
            this.getCheckbox().setSelected(cbxValue);
        }

        private boolean canChange(Object v) {
            return v instanceof String || v instanceof Double || v instanceof Integer || v instanceof Float || v instanceof Range || v instanceof ContourInfo || v instanceof Color || v instanceof ColorScaleInfo || v instanceof Unit || v instanceof Real || v instanceof ColorTable;
        }

        public void changeProperty() {
            Object v = this.propertyValue.getValue();
            if (v instanceof Boolean) {
                Boolean b = (Boolean)v;
                if (b.booleanValue()) {
                    this.changeValueTo(new Boolean(false));
                } else {
                    this.changeValueTo(new Boolean(true));
                }
                this.cbx.setSelected(true);
                return;
            }
            if (v instanceof ColorTable) {
                ArrayList items = new ArrayList();
                DisplaySettingsDialog.this.idv.getColorTableManager().makeColorTableMenu(new ObjectListener(null){

                    @Override
                    public void actionPerformed(ActionEvent ae, Object data) {
                        PropertyValueWrapper.this.changeValueTo(data);
                        PropertyValueWrapper.this.cbx.setSelected(true);
                    }
                }, items);
                GuiUtils.showPopupMenu(items, this.changeBtn);
            }
            if (this.canChange(v)) {
                this.changeValue();
                return;
            }
        }

        public JCheckBox getCheckbox() {
            if (this.cbx == null) {
                this.cbx = new JCheckBox("", false);
                this.setCheckboxLabel();
                String icon = null;
                Object v = this.propertyValue.getValue();
                if (this.propertyValue.getValue() instanceof Boolean) {
                    icon = "/auxdata/ui/icons/Refresh16.gif";
                } else if (this.canChange(v)) {
                    icon = "/auxdata/ui/icons/Settings16.png";
                }
                if (icon == null) {
                    this.changeBtn = new JPanel();
                } else {
                    this.changeBtn = GuiUtils.makeImageButton(icon, this, "changeProperty", null);
                    this.changeBtn.setToolTipText("Change value");
                }
            }
            return this.cbx;
        }

        public void changeValue() {
            block30: {
                Object value = this.propertyValue.getValue();
                if (value instanceof Range) {
                    Range r = (Range)value;
                    JTextField rangeMinField = new JTextField(r.getMin() + "", 10);
                    JTextField rangeMaxField = new JTextField(r.getMax() + "", 10);
                    List comps = Misc.newList(new JLabel("From: "), rangeMinField, new JLabel("To: "), rangeMaxField);
                    JPanel contents = GuiUtils.inset((Component)GuiUtils.hflow(comps), 5);
                    if (!GuiUtils.showOkCancelDialog(DisplaySettingsDialog.this.dialog, "Change " + this.propertyValue.getLabel(), GuiUtils.inset((Component)contents, 5), null)) {
                        return;
                    }
                    Range newRange = new Range(Misc.parseNumber(rangeMinField.getText()), Misc.parseNumber(rangeMaxField.getText()));
                    this.propertyValue.setValue(newRange);
                } else if (value instanceof ColorScaleInfo) {
                    ColorScaleInfo csi = new ColorScaleInfo((ColorScaleInfo)value);
                    ColorScaleDialog csd = new ColorScaleDialog(null, "Color Scale Properties", csi, true);
                    if (!csd.getOk()) {
                        return;
                    }
                    this.propertyValue.setValue(new ColorScaleInfo(csd.getInfo()));
                } else {
                    if (value instanceof Real) {
                        try {
                            Real r = (Real)this.propertyValue.getValue();
                            String s = "" + r.getValue();
                            while (true) {
                                try {
                                    s = GuiUtils.getInput("Enter new value for " + this.propertyValue.getLabel(), "Value: ", s, r.getUnit() + "");
                                    if (s == null) {
                                        return;
                                    }
                                    double d = Misc.parseDouble(s);
                                    this.propertyValue.setValue(r.cloneButValue(d));
                                    break block30;
                                }
                                catch (NumberFormatException nfe) {
                                    LogUtil.userErrorMessage("Bad number format: " + s);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Exception exc) {
                            LogUtil.logException("Setting value", exc);
                            return;
                        }
                    }
                    if (value instanceof ContourInfo) {
                        ContourInfo ci;
                        ContourInfoDialog cid = new ContourInfoDialog("Change " + this.propertyValue.getLabel(), false);
                        if (!cid.showDialog(ci = new ContourInfo((ContourInfo)this.propertyValue.getValue()))) {
                            return;
                        }
                        this.propertyValue.setValue(ci);
                    } else if (value instanceof String || value instanceof Double || value instanceof Integer || value instanceof Float) {
                        String newString = GuiUtils.getInput("Enter new value for " + this.propertyValue.getLabel(), "Value: ", value.toString());
                        if (newString == null) {
                            return;
                        }
                        Object newValue = newString.trim();
                        if (value instanceof Double) {
                            newValue = new Double(newString);
                        } else if (value instanceof Float) {
                            newValue = new Float(newString);
                        } else if (value instanceof Integer) {
                            newValue = new Integer(newString);
                        }
                        this.propertyValue.setValue(newValue);
                    } else if (value instanceof Unit) {
                        Unit newUnit = DisplaySettingsDialog.this.idv.getDisplayConventions().selectUnit((Unit)value, null);
                        if (newUnit == null) {
                            return;
                        }
                        this.propertyValue.setValue(newUnit);
                    } else if (value instanceof Color) {
                        Color c = JColorChooser.showDialog(this.changeBtn, "Select Color", (Color)value);
                        if (c == null) {
                            return;
                        }
                        this.propertyValue.setValue(c);
                    } else {
                        return;
                    }
                }
            }
            this.cbx.setSelected(true);
            this.setCheckboxLabel();
            GuiUtils.showWidget(this.cbx);
        }

        public void changeValueTo(Object o) {
            this.propertyValue.setValue(o);
            this.setCheckboxLabel();
        }

        public void setCheckboxLabel() {
            Object value = this.propertyValue.getValue();
            String svalue = DisplaySettingsDialog.getValueLabel(value);
            if (svalue.length() > 20) {
                svalue = svalue.substring(0, 19) + "...";
            }
            this.cbx.setText(this.propertyValue.getLabel() + " (" + svalue + ")");
            this.cbx.setToolTipText("<html>Select this to apply the value:<br><i>" + value + "</i><br>Right click to edit.</html>");
        }

        public String getCategory() {
            return this.propertyValue.getCategory();
        }

        public String getName() {
            return this.propertyValue.getName();
        }
    }

    private class DisplayWrapper {
        JCheckBox cbx;
        DisplayControlImpl dci;

        public DisplayWrapper(DisplayControlImpl display) {
            this.dci = display;
            this.cbx = new JCheckBox(this.dci.getTitle());
        }

        public String toString() {
            return this.dci.getLabel();
        }
    }
}

