/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PropertyValue;
import ucar.unidata.util.StringUtil;

public class DisplaySetting {
    private String name;
    private List<PropertyValue> propertyValues;
    private boolean isLocal;
    private Hashtable applicableToControls;
    private static String lastCat;
    private static String lastName;

    public DisplaySetting() {
    }

    public DisplaySetting(String name, List<PropertyValue> propertyValues) {
        this.name = name;
        this.propertyValues = propertyValues;
    }

    public boolean applicableTo(ControlDescriptor cd) {
        if (this.applicableToControls == null || this.applicableToControls.size() == 0) {
            return true;
        }
        return this.applicableToControls.get(cd.getControlId()) != null;
    }

    public boolean changeName(IntegratedDataViewer idv, JDialog dialog) {
        String name = this.getNameWithoutCategory();
        String cat = this.getCategory();
        Object[] result = DisplaySetting.getNewName(idv, null, cat, name, null);
        if (result == null) {
            return false;
        }
        String newName = (String)result[0];
        if (newName.equals(this.getName())) {
            return false;
        }
        DisplaySetting existing = idv.getResourceManager().findDisplaySetting(newName);
        if (existing != null) {
            idv.getResourceManager().removeDisplaySetting(existing);
        }
        this.setName(newName);
        idv.getResourceManager().displaySettingChanged(this);
        return true;
    }

    public static void doSave(IntegratedDataViewer idv, JDialog dialog, List<PropertyValue> propList, DisplayControlImpl display) {
        String lbl;
        Object[] result;
        ControlDescriptor cd = null;
        if (display != null) {
            cd = idv.getControlDescriptor(display.getDisplayId());
        }
        if ((result = DisplaySetting.getNewName(idv, dialog, lastCat, lastName, lbl = cd != null ? "Applicable only to displays of type: " + cd : null)) == null) {
            return;
        }
        boolean only = (Boolean)result[1];
        String name = (String)result[0];
        DisplaySetting existing = idv.getResourceManager().findDisplaySetting(name);
        if (existing != null) {
            existing.setPropertyValues(propList);
            idv.getResourceManager().displaySettingChanged(existing);
        } else {
            existing = new DisplaySetting(name, propList);
            idv.getResourceManager().addDisplaySetting(existing);
        }
        if (cd != null) {
            if (only) {
                existing.setOnlyApplicableTo(cd);
            } else {
                existing.clearOnlyApplicableTo();
            }
        }
    }

    private static Object[] getNewName(IntegratedDataViewer idv, JDialog dialog, String dfltCategory, String dfltName, String cbxLabel) {
        JCheckBox cbx = new JCheckBox(cbxLabel != null ? cbxLabel : "");
        Vector<String> categories = new Vector<String>();
        List<DisplaySetting> displaySettings = idv.getResourceManager().getDisplaySettings();
        categories.add("");
        for (int i = 0; i < displaySettings.size(); ++i) {
            DisplaySetting displaySetting = displaySettings.get(i);
            String cat = displaySetting.getCategory();
            if (cat == null || categories.contains(cat)) continue;
            categories.add(cat);
        }
        JComboBox catBox = new JComboBox(categories);
        catBox.setEditable(true);
        if (dfltCategory != null) {
            catBox.setSelectedItem(dfltCategory);
        }
        JTextField fld = new JTextField("", 20);
        if (dfltName != null) {
            fld.setText(dfltName);
        }
        catBox.setToolTipText("Use '>' for sub-categories");
        JPanel contents = GuiUtils.vbox((Component)GuiUtils.inset((Component)new JLabel("Please enter a display settings name"), 5), GuiUtils.hbox((Component)GuiUtils.label(" Category: ", catBox), GuiUtils.label("  Name: ", fld)));
        if (cbxLabel != null) {
            contents = GuiUtils.vbox((Component)contents, cbx);
        }
        String name = null;
        DisplaySetting existing = null;
        while (true) {
            if (!GuiUtils.showOkCancelDialog(dialog, "Save Display Settings", GuiUtils.inset((Component)contents, 5), null)) {
                return null;
            }
            String cat = catBox.getSelectedItem().toString().trim();
            name = fld.getText().trim();
            if (name.length() == 0) {
                if (GuiUtils.showOkCancelDialog(dialog, "Save Display Settings", GuiUtils.inset((Component)new JLabel("Please enter a name"), 5), null)) continue;
                return null;
            }
            lastCat = cat;
            lastName = name;
            if (cat.length() > 0) {
                name = cat + ">" + name;
            }
            name = DisplaySetting.cleanName(name);
            existing = idv.getResourceManager().findDisplaySetting(name);
            if (existing == null || GuiUtils.askYesNo("Display Setting", "<html>A display setting with the name:<br><i>&nbsp;&nbsp; " + name + "</i><br>exists. Do you want to overwrite it</html>?")) break;
        }
        return new Object[]{name, new Boolean(cbx.isSelected())};
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getCategory() {
        int idx = this.getName().lastIndexOf(">");
        if (idx >= 0) {
            return this.getName().substring(0, idx).trim();
        }
        return null;
    }

    public String getNameWithoutCategory() {
        int idx = this.name.lastIndexOf(">");
        if (idx < 0) {
            return this.name;
        }
        return this.name.substring(idx + 1, this.name.length());
    }

    public static String cleanName(String name) {
        List<String> toks = StringUtil.split(name, ">", true, true);
        return StringUtil.join(">", toks);
    }

    public String getName() {
        return this.name;
    }

    public void setPropertyValues(List<PropertyValue> value) {
        this.propertyValues = value;
    }

    public List<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DisplaySetting)) {
            return false;
        }
        DisplaySetting that = (DisplaySetting)o;
        return Misc.equals(this.name, that.name);
    }

    public void setIsLocal(boolean value) {
        this.isLocal = value;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public String toString() {
        if (this.isLocal) {
            return this.name + " <local>";
        }
        return this.name;
    }

    public void clearOnlyApplicableTo() {
        this.applicableToControls = null;
    }

    public void setOnlyApplicableTo(ControlDescriptor cd) {
        this.applicableToControls = new Hashtable();
        this.applicableToControls.put(cd.getControlId(), new Boolean(true));
    }

    public void setApplicableToControls(Hashtable value) {
        this.applicableToControls = value;
    }

    public Hashtable getApplicableToControls() {
        return this.applicableToControls;
    }

    static {
        lastName = "";
    }
}

