/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import ucar.nc2.time.Calendar;
import ucar.unidata.collab.Sharable;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.data.DataCancelException;
import ucar.unidata.data.DataChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataTimeRange;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.GeoSelectionPanel;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.ControlDescriptor;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.DisplayInfo;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.NavigatedViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.ViewContext;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.ColorScaleDialog;
import ucar.unidata.idv.control.ColorTableWidget;
import ucar.unidata.idv.control.ContourWidget;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySetting;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.FlaggedDisplayable;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.RangeWidget;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.SelectRangeWidget;
import ucar.unidata.idv.control.ValueSliderWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.idv.control.ZSlider;
import ucar.unidata.idv.ui.DataSelectionWidget;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.idv.ui.DataTreeDialog;
import ucar.unidata.idv.ui.IdvComponentHolder;
import ucar.unidata.idv.ui.IdvWindow;
import ucar.unidata.ui.DndImageButton;
import ucar.unidata.ui.Help;
import ucar.unidata.ui.ImageUtils;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Msg;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.PropertyValue;
import ucar.unidata.util.Prototypable;
import ucar.unidata.util.Range;
import ucar.unidata.util.Removable;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.GlobeDisplay;
import ucar.unidata.view.geoloc.MapProjectionDisplay;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.unidata.xml.XmlObjectStore;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationWidget;
import ucar.visad.display.ColorScale;
import ucar.visad.display.ColorScaleInfo;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.DisplayUtil;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.TextDisplayable;
import visad.CommonUnit;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.TextType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.MapProjection;
import visad.util.DataUtility;

public abstract class DisplayControlImpl
extends DisplayControlBase
implements DisplayControl,
ActionListener,
ItemListener,
DataChangeListener,
HyperlinkListener,
DisplayListener,
PropertyChangeListener,
ControlListener,
Prototypable {
    private static final double CURRENT_VERSION = 2.2;
    protected double version = 0.0;
    protected static final double ZFUDGE = 0.005;
    private static Hashtable allCategories = new Hashtable();
    private boolean useTimesInAnimation = true;
    private boolean doCursorReadout = true;
    private boolean expandedInTabs = false;
    private boolean showInTabs = true;
    private boolean versionWasSet = false;
    private Hashtable timeLabels;
    private DateTime currentTime;
    private DateTime firstTime;
    private boolean listeningForTimes = false;
    private Animation viewAnimation;
    private Animation internalAnimation;
    private AnimationInfo animationInfo;
    private AnimationWidget animationWidget;
    private IdvComponentHolder componentHolder;
    private int attributeFlags = 0;
    private boolean inDataChangeCall = false;
    private boolean okToFireEvent = true;
    protected boolean settingVisibility = false;
    protected final String DISPLAY_LIST_NAME = "Display_List_Text";
    private boolean hasBeenRemoved = false;
    private volatile boolean haveInitialized = false;
    private boolean initializationDone = false;
    private boolean lockVisibiltyToggle = false;
    private boolean showInDisplayList = true;
    private boolean canDoRemoveAll = true;
    private JComponent bottomLegendComponent;
    private JButton bottomLegendButton;
    private Color legendForeground;
    private Color legendBackground;
    private List lockButtons = new ArrayList();
    private JComponent sideLegendComponent;
    private JLabel sideLegendLabel;
    private List labelsToUpdate = new ArrayList();
    private JTextArea legendTextArea;
    private JPanel legendTextPanel;
    private ValueSliderWidget lww;
    private ValueSliderWidget sww;
    private List visibilityCbs = new ArrayList();
    private boolean isRaster = false;
    private JPanel mainPanel;
    private Container contents;
    private JComponent outerContents = null;
    private IdvWindow myWindow;
    private Window detailsFrame;
    private JEditorPane detailsEditor;
    private WindowAdapter windowListener;
    private boolean myWindowVisible = false;
    private int windowX = 50;
    private int windowY = 100;
    private Dimension windowSize;
    private Dimension mainPanelSize;
    private boolean makeWindow = true;
    private boolean showInLegend = true;
    protected Unit displayUnit;
    private Unit colorUnit;
    protected String initNoteText;
    protected JTextArea noteTextArea;
    protected JComponent noteWrapper;
    protected boolean showNoteText = false;
    private JPanel sideLegendButtonPanel;
    private JPanel bottomLegendButtonPanel;
    protected String resolutionReadout = null;
    protected DataSelection dataSelection;
    protected Hashtable requestProperties;
    Hashtable transientProperties = new Hashtable();
    private String displayCategory;
    protected List sharables;
    protected List displayMasters;
    protected ViewManager defaultViewManager;
    protected List viewManagers;
    protected String defaultView = null;
    String viewManagerClassNames = null;
    protected ContourInfo contourInfo;
    protected String contourInfoParams;
    private ColorTable colorTable;
    private String colorTableName = null;
    private Color color;
    private Color displayListColor;
    protected boolean displayListUsesColor = false;
    private JComboBox colorComboBox;
    private Range colorRange;
    private Range selectRange;
    private boolean selectRangeEnabled = false;
    private double zPosition = Double.MIN_VALUE;
    private int lineWidth = 1;
    protected ColorTableWidget ctw;
    protected List colorScales;
    protected Hashtable displayListTable = new Hashtable();
    protected ContourWidget contourWidget;
    protected SelectRangeWidget selectRangeWidget;
    private List colorSwatches = new ArrayList();
    private String defaultSamplingMode = DEFAULT_SAMPLING_MODE;
    private String displayName = "Display";
    protected String helpUrl = null;
    protected String paramName;
    private String displayListTemplate;
    private String legendLabelTemplate;
    private String extraLabelTemplate = null;
    private JTextField legendLabelTemplateFld;
    private JTextField displayListTemplateFld;
    private JTextArea extraLabelTemplateFld;
    private String id;
    private List myDataChoices;
    private List initDataChoices;
    private boolean hadDataChoices = false;
    private String originalDataChoicesLabel = "";
    private String templateName;
    protected boolean instantiatedWithNoData = false;
    private List dataInstances = new ArrayList();
    private String displayId;
    protected List categories;
    private boolean isVisible = true;
    protected ColorScaleInfo colorScaleInfo = null;
    protected ControlContext controlContext;
    private List displays = new ArrayList();
    List displayables;
    private boolean collapseLegend = false;
    private Object MUTEX_CONTROLCHANGE = new Object();
    private Object LEGEND_MUTEX = new Object();
    private boolean controlChangePending = false;
    private long lastCheckControlChangeTime;
    private long lastControlChangeTime;
    private Rectangle2D lastBounds;
    private List propertyChangeListeners;
    private boolean useFastRendering = false;
    private boolean wasUnPersisted = false;
    private boolean isTimeDriver = false;
    private boolean usesTimeDriver = false;
    private float colorDimness = 1.0f;
    private JTextField categoryFld;
    private JTextField idFld;
    private GeoSelectionPanel geoSelectionPanel;
    private DataSelectionWidget dataSelectionWidget;
    private ColorScaleDialog csd;
    private DataTimeRange dataTimeRange;
    private Hashtable methodNameToSettingsMap = new Hashtable();
    protected JSlider skipSlider;
    private ZSlider zPositionSlider;
    private int skipValue = 0;
    private List initialSettings;
    private int textureQuality = 10;
    private JSlider textureSlider = null;
    private float pointSize = 1.0f;
    private ProjectionControl projectionControlListeningTo;
    private LocalDisplay displayControlListeningTo;
    private List<Removable> removables = new ArrayList<Removable>();
    private int visbilityAnimationPause = -1;
    private JTextField visbilityAnimationPauseFld;
    private static final String[] smootherLabels = new String[]{"None", "5 point", "9 point", "Gaussian Weighted", "Cressman Weighted", "Circular Aperture", "Rectangular Aperture"};
    private static final String[] smoothers = new String[]{"None", "SM5S", "SM9S", "GWFS", "CRES", "CIRC", "RECT"};
    private int smoothingFactor = 6;
    private String smoothingType = "None";
    public boolean isProgressiveResolution = false;
    public boolean reloadFromBounds = false;
    public boolean matchDisplayRegion = false;
    private TimeZone displayListTimeZone = null;
    private static File captureDir;
    private Hashtable cachedData;

    public DisplayControlImpl() {
        this.setSharing(false);
        this.setShareGroup("DisplayControl");
    }

    public DisplayControlImpl(ControlContext controlContext) {
        this();
        this.controlContext = controlContext;
    }

    @Override
    public final void initBasic(String displayId, List categories, Hashtable properties) {
        this.displayId = displayId;
        this.categories = categories;
        if (properties != null) {
            this.applyProperties(properties);
        }
    }

    @Override
    public final void init(String displayId, List categories, List choices, ControlContext controlContext, String properties, DataSelection dataSelection) throws VisADException, RemoteException {
        this.init(displayId, categories, choices, controlContext, StringUtil.parsePropertiesString(properties), dataSelection);
    }

    @Override
    public final void init(String displayId, List categories, List choices, ControlContext controlContext, Hashtable properties, DataSelection dataSelection) throws VisADException, RemoteException {
        NavigatedDisplay navDisplay;
        DataChoice dc;
        DataSelection ds;
        List cdcs;
        if (this.haveInitialized) {
            return;
        }
        this.initSharable();
        this.displayId = displayId;
        this.categories = categories;
        this.controlContext = controlContext;
        this.dataSelection = dataSelection;
        if (this.dataSelection == null) {
            this.dataSelection = new DataSelection();
        }
        this.setMatchDisplayRegion(this.dataSelection.getGeoSelection(true).getUseViewBounds());
        if (!this.wasUnPersisted) {
            this.useFastRendering = this.getInitialFastRendering();
        }
        this.setDataChoices(choices);
        this.usesTimeDriver = this.dataSelection.getProperty("Use_Display_Driver_Times", false);
        if (!this.isTimeDriver) {
            this.isTimeDriver = this.dataSelection.getProperty("As_Display_Driver_Times", false);
            if (this.isTimeDriver) {
                ViewManager vm = this.getViewManager();
                vm.ensureOnlyOneTimeDriver(this);
            }
        }
        if (properties != null) {
            this.applyProperties(properties);
        }
        if (this.checkFlag(4) && this.color == null) {
            this.getDisplayConventions();
            this.color = DisplayConventions.getColor();
        }
        this.defaultSamplingMode = this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE);
        if (this.hasBeenRemoved) {
            return;
        }
        if (this.initialSettings != null) {
            try {
                for (int i = 0; i < this.initialSettings.size(); ++i) {
                    this.applyDisplaySetting((DisplaySetting)this.initialSettings.get(i));
                }
                this.initialSettings = null;
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Initializing with settings", exc);
            }
        }
        this.updateDataSelection(this.dataSelection);
        if (!this.init(this.myDataChoices)) {
            this.displayControlFailed();
            if (this.getProperty("control.ignoreerrors", false)) {
                this.addToControlContext();
            }
            return;
        }
        if (this.myDataChoices != null && this.myDataChoices.size() > 0 && this.myDataChoices.get(0) instanceof DerivedDataChoice && (cdcs = ((DerivedDataChoice)this.myDataChoices.get(0)).getChoices()).size() > 0 && (ds = (dc = (DataChoice)cdcs.get(0)).getDataSelection()) != null) {
            List<DateTime> dtimes = ds.getTimeDriverTimes();
            this.usesTimeDriver = ds.getProperty("Use_Display_Driver_Times", false);
        }
        if (this.hasBeenRemoved) {
            return;
        }
        if (this.getIdv().getInteractiveMode()) {
            Trace.call1("DisplayControlImpl.init doMakeWindow");
            this.doMakeWindow();
            Trace.call2("DisplayControlImpl.init doMakeWindow");
        }
        this.addToControlContext();
        this.instantiateAttributes();
        this.haveInitialized = true;
        if (!this.isVisible) {
            this.setDisplayVisibility(false);
        }
        this.applyAttributesToDisplayables();
        if (this.hasBeenRemoved) {
            return;
        }
        Trace.call1("DisplayControlImpl.init insertDisplayables");
        if (!this.insertDisplayables()) {
            return;
        }
        Trace.call2("DisplayControlImpl.init insertDisplayables");
        if (this.hasBeenRemoved) {
            return;
        }
        if (this.makeWindow) {
            this.myWindow = this.createIdvWindow();
            if (this.myWindow != null) {
                this.initWindow(this.myWindow);
            }
        }
        if (this.shouldAddDisplayListener() && (navDisplay = this.getNavigatedDisplay()) != null && this.displayControlListeningTo != null) {
            this.displayControlListeningTo = navDisplay.getDisplay();
            this.displayControlListeningTo.addDisplayListener(this);
        }
        if (this.shouldAddControlListener() && (navDisplay = this.getNavigatedDisplay()) != null) {
            try {
                this.lastBounds = this.calculateRectangle();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.projectionControlListeningTo = navDisplay.getDisplay().getProjectionControl();
            this.projectionControlListeningTo.addControlListener(this);
            if (this.displayControlListeningTo == null) {
                this.displayControlListeningTo = navDisplay.getDisplay();
                this.displayControlListeningTo.addDisplayListener(this);
            }
        }
        if (this.shouldAddAnimationListener()) {
            this.getSomeAnimation();
        }
        this.initDone();
        if (this.componentHolder != null) {
            this.componentHolder.displayControlHasInitialized();
        }
        this.initializationDone = true;
        if (this.animationWidget != null) {
            this.animationWidget.setSharing(this.animationInfo.getShared());
        }
        this.doInitialUpdateLegendAndList();
    }

    protected void doInitialUpdateLegendAndList() {
        this.updateLegendAndList();
    }

    protected void addToControlContext() {
        this.controlContext.addDisplayControl(this);
    }

    @Override
    public void initAsTemplate() {
        this.defaultView = null;
    }

    @Override
    public void initAsPrototype() {
        this.defaultView = null;
        this.colorTable = null;
        this.colorTableName = null;
        this.displayUnit = null;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties) {
        this.initAfterUnPersistence(vc, properties, null);
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        if (!this.versionWasSet) {
            this.showInTabs = !this.myWindowVisible;
        }
        this.wasUnPersisted = true;
        if (this.haveInitialized) {
            return;
        }
        try {
            int i;
            this.initSharable();
            this.controlContext = vc;
            List dataSources = this.getControlContext().getAllDataSources();
            if (this.initDataChoices == null && this.hadDataChoices) {
                if (preSelectedDataChoices != null) {
                    this.initDataChoices = preSelectedDataChoices;
                } else if (this.originalDataChoicesLabel != null && this.getObjectStore().get("idv.autoselectdata", false)) {
                    for (i = 0; i < dataSources.size(); ++i) {
                        DataSource dataSource = (DataSource)dataSources.get(i);
                        DataChoice dataChoice = dataSource.findDataChoice(this.originalDataChoicesLabel);
                        if (dataChoice == null) continue;
                        this.initDataChoices = Misc.newList(dataChoice);
                        break;
                    }
                }
                if (this.initDataChoices == null) {
                    String label = "<html>Please select data for: <i>" + this.getDisplayName() + "</i>";
                    if (this.originalDataChoicesLabel != null && this.originalDataChoicesLabel.length() > 0) {
                        label = label + "<br>Original field: <i>" + this.originalDataChoicesLabel + "</i>";
                    }
                    DataOperand operand = new DataOperand(this.originalDataChoicesLabel, label, this.categories, false);
                    DataTreeDialog dataDialog = new DataTreeDialog(this.getIdv(), null, Misc.newList(operand), dataSources, this.myDataChoices);
                    List choices = dataDialog.getSelected();
                    if (choices != null && choices.size() > 0) {
                        this.initDataChoices = (List)choices.get(0);
                    }
                }
                if (this.initDataChoices == null) {
                    this.displayControlFailed();
                    return;
                }
                this.instantiatedWithNoData = true;
                this.initializeWithNewData();
            }
            if (this.initDataChoices != null) {
                for (i = 0; i < this.initDataChoices.size(); ++i) {
                    ((DataChoice)this.initDataChoices.get(i)).initAfterUnPersistence(properties);
                }
            }
            if (this.displayListTemplate == null && this.legendLabelTemplate != null) {
                this.displayListTemplate = this.legendLabelTemplate + " " + "%timestamp%";
            }
            this.init(this.getDisplayId(), this.getCategories(), this.initDataChoices, this.getControlContext(), properties, this.getDataSelection());
            this.initDataChoices = null;
        }
        catch (DataCancelException dce) {
            this.displayControlFailed();
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Initializing after unpersistence", exc);
        }
    }

    public boolean init(List choices) throws VisADException, RemoteException {
        if (choices != null && choices.size() > 0) {
            return this.init((DataChoice)choices.get(0));
        }
        return this.init((DataChoice)null);
    }

    public boolean init(DataChoice choice) throws VisADException, RemoteException {
        return true;
    }

    public void initDone() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList();
        }
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        this.propertyChangeListeners.remove(listener);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.propertyChangeListeners == null) {
            return;
        }
        for (int i = 0; i < this.propertyChangeListeners.size(); ++i) {
            PropertyChangeListener listener = (PropertyChangeListener)this.propertyChangeListeners.get(i);
            listener.propertyChange(event);
        }
    }

    protected boolean hasTimeMacro(String t) {
        if (t == null) {
            return false;
        }
        return UtcDate.containsTimeMacro(t) || this.hasForecastHourMacro(t);
    }

    protected boolean shouldAddAnimationListener() {
        return this.hasTimeMacro(this.getLegendLabelTemplate()) || this.hasTimeMacro(this.getExtraLabelTemplate()) || this.hasTimeMacro(this.getDisplayListTemplate());
    }

    protected boolean shouldAddDisplayListener() {
        return false;
    }

    protected boolean shouldAddControlListener() {
        return false;
    }

    public boolean getHaveInitialized() {
        return this.haveInitialized;
    }

    protected GraphicsConfiguration getGraphicsConfiguration(boolean is3D, boolean useStereo) {
        Point p = null;
        if (!this.getShowInTabs() && this.myWindow != null) {
            p = this.myWindow.getLocation();
        }
        GraphicsDevice d = this.getIdv().getIdvUIManager().getScreen(p);
        return DisplayUtil.getPreferredConfig(d, is3D, useStereo);
    }

    protected void applyAttributesToDisplayables() throws VisADException, RemoteException {
        this.deactivateDisplays();
        this.applyColor();
        this.applyDisplayUnit();
        if (!this.isDisplayUnitAlsoColorUnit()) {
            this.applyColorUnit();
        }
        this.applyContourInfo();
        this.applyRange();
        this.applySelectRange();
        this.applyColorTable();
        this.applyZPosition();
        this.applyUseFastRendering();
        this.applyLineWidth();
        this.applySkipFactor();
        this.applyTextureQuality();
        this.applySmoothing();
        this.activateDisplays();
    }

    protected void addAttributeFlags(int f) {
        this.attributeFlags |= f;
    }

    protected void setAttributeFlags(int f) {
        this.attributeFlags |= f;
    }

    protected void reallySetAttributeFlags(int f) {
        this.attributeFlags = f;
    }

    protected boolean checkFlag(int f) {
        return (this.attributeFlags & f) != 0;
    }

    protected int getAttributeFlags() {
        return this.attributeFlags;
    }

    protected void addAttributedDisplayable(Displayable d) {
        this.addAttributedDisplayable(d, this.attributeFlags);
    }

    protected void addAttributedDisplayable(Displayable d, int attributeFlags) {
        this.addAttributedDisplayable(d, attributeFlags, 0);
    }

    protected void addAttributedDisplayable(Displayable d, int attributeFlags, int notGlobalFlags) {
        if (this.displayables == null) {
            this.displayables = new ArrayList();
        }
        this.displayables.add(new FlaggedDisplayable(d, attributeFlags | notGlobalFlags));
        this.setAttributeFlags(attributeFlags);
        if (this.getHaveInitialized()) {
            try {
                this.applyAttributesToDisplayables();
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Applying graphics attributes to displayables for display:" + this.toString(), exc);
            }
        }
    }

    protected void applyContourInfo() throws VisADException, RemoteException {
        ContourInfo contourInfo = this.getContourInfo();
        if (contourInfo == null || this.displayables == null) {
            return;
        }
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(2)) continue;
            fd.displayable.setContourInfo(contourInfo);
        }
    }

    protected void applyColorScaleInfo() throws VisADException, RemoteException {
        ColorScaleInfo tmpColorScaleInfo;
        if (this.colorScaleInfo == null) {
            return;
        }
        tmpColorScaleInfo.setIsVisible((tmpColorScaleInfo = new ColorScaleInfo(this.colorScaleInfo)).getIsVisible() && this.getDisplayVisibility());
        if (this.colorScales == null) {
            if (tmpColorScaleInfo.getIsVisible() && this.getHaveInitialized()) {
                this.doMakeColorScales();
            }
            return;
        }
        int n = this.colorScales.size();
        for (int i = 0; i < n; ++i) {
            ColorScale scale = (ColorScale)this.colorScales.get(i);
            scale.setColorScaleInfo(tmpColorScaleInfo);
        }
    }

    protected void colorUnitChanged(Unit oldUnit, Unit newUnit) {
    }

    protected void applyColorUnit() throws VisADException, RemoteException {
        Unit unitForColor = this.getUnitForColor();
        if (unitForColor == null || this.displayables == null) {
            return;
        }
        for (Object displayable : this.displayables) {
            FlaggedDisplayable fd = (FlaggedDisplayable)displayable;
            if (!fd.ok(64)) continue;
            try {
                fd.displayable.setColorUnit(unitForColor);
            }
            catch (Exception exception) {}
        }
    }

    protected void displayUnitChanged(Unit oldUnit, Unit newUnit) {
    }

    public Unit getRawDataUnit() {
        return null;
    }

    protected void applyDisplayUnit() throws VisADException, RemoteException {
        this.applyDisplayUnit(true);
    }

    private void applyDisplayUnit(boolean firstTime) throws VisADException, RemoteException {
        if (this.displayUnit == null || this.displayables == null) {
            return;
        }
        boolean unitIsBad = false;
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(32)) continue;
            try {
                fd.displayable.setDisplayUnit(this.displayUnit);
                continue;
            }
            catch (Exception excp) {
                unitIsBad = true;
                break;
            }
        }
        if (unitIsBad) {
            this.displayUnit = null;
            if (firstTime) {
                this.displayUnit = this.getDisplayUnit(this.getRawDataUnit());
                this.applyDisplayUnit(false);
            }
        }
    }

    protected ColorTable getColorTableToApply() {
        if (this.colorTable == null) {
            this.colorTable = this.getOldColorTableOrInitialColorTable();
        }
        return this.colorTable;
    }

    protected void applyColorTable() throws VisADException, RemoteException {
        if (this.displayables == null) {
            return;
        }
        ColorTable colorTableToUse = this.getColorTableToApply();
        if (colorTableToUse == null) {
            if (this.colorScaleInfo != null) {
                this.colorScaleInfo.setColorPalette(null);
                this.applyColorScaleInfo();
            }
            return;
        }
        float[][] table = null;
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(8)) continue;
            if (table == null) {
                table = this.getColorTableForDisplayable(colorTableToUse);
                if (this.colorDimness < 0.1f) {
                    this.colorDimness = 0.1f;
                }
                if (this.colorDimness < 1.0f) {
                    int len = table[0].length;
                    int size = table.length;
                    float[][] newTable = new float[size][len];
                    for (int rgbIdx = 0; rgbIdx < size; ++rgbIdx) {
                        for (int m = 0; m < len; ++m) {
                            newTable[rgbIdx][m] = rgbIdx >= 3 ? table[rgbIdx][m] : this.colorDimness * table[rgbIdx][m];
                        }
                    }
                    table = newTable;
                }
            }
            fd.displayable.setColorPalette(table);
        }
        if (table != null) {
            if (this.ctw != null) {
                if (table.length == 3) {
                    this.ctw.setColorPalette(new float[][]{table[0], table[1], table[2]});
                } else {
                    this.ctw.setColorPalette(new float[][]{table[0], table[1], table[2], table[3]});
                }
            }
            if (this.colorScaleInfo != null) {
                this.colorScaleInfo.setColorPalette(table);
                this.applyColorScaleInfo();
            }
        }
    }

    public void resetDimness() {
        this.colorDimness = 1.0f;
    }

    public void setColorDimmer() throws VisADException, RemoteException {
        this.colorDimness -= 0.2f;
        this.applyColorTable();
    }

    public void setColorBrighter() throws VisADException, RemoteException {
        this.colorDimness += 0.2f;
        if (this.colorDimness > 1.0f) {
            this.colorDimness = 1.0f;
        }
        this.applyColorTable();
    }

    protected void applyColor() throws VisADException, RemoteException {
        if (this.displayables == null) {
            return;
        }
        this.deactivateDisplays();
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(4)) continue;
            if (this.color == null) {
                this.getDisplayConventions();
                this.color = DisplayConventions.getColor();
            }
            fd.displayable.setColor(this.color);
        }
        if (this.displayListUsesColor) {
            this.setDisplayListColor(this.color, false);
        }
        this.activateDisplays();
    }

    protected void applyRange() throws VisADException, RemoteException {
        Range range = null;
        if (this.displayables == null) {
            return;
        }
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(8)) continue;
            if (range == null) {
                range = this.getRangeToApply();
            }
            if (range == null) {
                return;
            }
            fd.displayable.setRangeForColor(range);
        }
    }

    protected void applySelectRange() throws VisADException, RemoteException {
        Range range = null;
        if (this.displayables == null) {
            return;
        }
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(256)) continue;
            if (range == null) {
                range = this.getSelectRange();
            }
            if (range == null) {
                return;
            }
            Range theRange = range;
            if (!this.selectRangeEnabled) {
                theRange = new Range(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
            fd.displayable.setSelectedRange(theRange);
        }
    }

    protected void applyZPosition() throws VisADException, RemoteException {
        if (this.displayables == null || !this.useZPosition()) {
            return;
        }
        this.deactivateDisplays();
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(128)) continue;
            fd.displayable.setConstantPosition(this.getVerticalValue(this.getZPosition()), this.getNavigatedDisplay().getDisplayAltitudeType());
        }
        this.activateDisplays();
    }

    protected void applyLineWidth() throws VisADException, RemoteException {
        if (this.displayables == null) {
            return;
        }
        this.deactivateDisplays();
        int n = this.displayables.size();
        for (int i = 0; i < n; ++i) {
            FlaggedDisplayable fd = (FlaggedDisplayable)this.displayables.get(i);
            if (!fd.ok(1024)) continue;
            fd.displayable.setLineWidth(this.getLineWidth());
        }
        this.activateDisplays();
    }

    public float[][] getColorTableForDisplayable(ColorTable ct) {
        return ct.getAlphaTable();
    }

    Range getRangeFromColorTable() {
        if (this.colorTable != null) {
            return this.colorTable.getRange();
        }
        return null;
    }

    Range getColorRangeFromData() {
        return null;
    }

    public void addToRangeMenu(RangeWidget rw, List items) {
    }

    public void addToRangeMenu(ColorTableWidget cw, List items) {
    }

    public void addToRangeMenu(RangeDialog selectRangeWidget, List items) {
    }

    protected void parseProperties(String properties) {
        if (properties == null) {
            return;
        }
        this.applyProperties(StringUtil.parsePropertiesString(properties));
    }

    public void setInitialSettings(List settings) {
        this.initialSettings = settings;
    }

    public void applyProperties(Hashtable properties) {
        if (properties == null) {
            return;
        }
        Enumeration keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = properties.get(key);
            this.setProperty(key, value);
        }
    }

    public void applyDisplaySetting(DisplaySetting displaySetting) throws Exception {
        this.applyPropertyValues(displaySetting.getPropertyValues());
    }

    public void applyPropertyValues(List props) throws Exception {
        for (int i = 0; i < props.size(); ++i) {
            PropertyValue prop = (PropertyValue)props.get(i);
            Misc.setProperty((Object)this, prop.getName(), prop.getValue(), false);
        }
        this.updateLegendAndList();
        this.notifyViewManagersOfChange();
    }

    @Override
    public boolean getCanDoRemoveAll() {
        return this.canDoRemoveAll;
    }

    public void setCanDoRemoveAll(boolean v) {
        this.canDoRemoveAll = v;
    }

    public boolean getShowNoteText() {
        return this.showNoteText;
    }

    public void setShowNoteText(boolean n) {
        this.showNoteText = n;
        if (this.showNoteText) {
            this.showNoteTextArea();
        } else {
            this.removeNoteTextArea();
        }
    }

    public String getNoteText() {
        return this.noteTextArea != null ? this.noteTextArea.getText() : null;
    }

    public void setNoteText(String n) {
        this.initNoteText = n;
        if (this.noteTextArea != null) {
            this.noteTextArea.setText(n);
        }
    }

    public void toggleNoteTextArea() {
        if (this.showNoteText) {
            this.removeNoteTextArea();
        } else {
            this.showNoteTextArea();
        }
        this.showNoteText = !this.showNoteText;
    }

    protected void redoGuiLayout() {
        if (this.mainPanel == null) {
            return;
        }
        this.mainPanel.invalidate();
        this.mainPanel.validate();
        JFrame frame = GuiUtils.getFrame(this.mainPanel);
        if (frame != null) {
            frame.pack();
        }
    }

    private void removeNoteTextArea() {
        if (this.noteWrapper != null) {
            this.mainPanel.remove(this.noteWrapper);
            this.redoGuiLayout();
        }
    }

    private void showNoteTextArea() {
        if (this.noteTextArea == null) {
            this.noteTextArea = new JTextArea(5, 30);
            if (this.initNoteText != null) {
                this.noteTextArea.setText(this.initNoteText);
            }
            JScrollPane sp = new JScrollPane(this.noteTextArea, 22, 30);
            JViewport vp = sp.getViewport();
            vp.setViewSize(new Dimension(60, 30));
            this.noteWrapper = GuiUtils.inset((Component)sp, 4);
        }
        if (this.mainPanel != null) {
            this.addNoteText(this.mainPanel, this.noteWrapper);
            this.redoGuiLayout();
        }
    }

    public boolean isInTransectView() {
        ViewManager vm = this.getViewManager();
        return vm != null && vm instanceof TransectViewManager;
    }

    protected void addNoteText(JPanel mainPanel, JComponent noteWrapper) {
        mainPanel.add("South", noteWrapper);
    }

    protected void setProperty(String name, Object value) {
        try {
            Util.propertySet(this, name, value, false);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting property:" + name + " value= " + value, exc);
        }
    }

    protected void addDisplayMaster(DisplayMaster s) {
        if (this.displayMasters == null) {
            this.displayMasters = new ArrayList();
        }
        this.displayMasters.add(s);
    }

    protected void addViewManager(ViewManager s) {
        if (this.viewManagers == null) {
            this.viewManagers = new ArrayList();
        }
        this.viewManagers.add(s);
    }

    protected void clearViewManagers() {
        if (this.viewManagers == null) {
            return;
        }
        List tmp = this.viewManagers;
        this.viewManagers = null;
        for (int i = 0; i < tmp.size(); ++i) {
            ((ViewManager)tmp.get(i)).destroy();
        }
    }

    public void addSharable(SharableImpl s) {
        if (this.sharables == null) {
            this.sharables = new ArrayList();
        }
        this.sharables.add(s);
    }

    protected void initializeWithNewData() {
    }

    @Override
    public final void displayChanged(DisplayEvent event) {
        NavigatedDisplay navDisplay;
        if (!this.getHaveInitialized()) {
            return;
        }
        int id = event.getId();
        if (id == 12 && this.shouldAddControlListener() && (navDisplay = this.getNavigatedDisplay()) != null) {
            if (this.projectionControlListeningTo != null) {
                this.projectionControlListeningTo.removeControlListener(this);
            }
            this.projectionControlListeningTo = navDisplay.getDisplay().getProjectionControl();
            this.projectionControlListeningTo.addControlListener(this);
        }
        this.handleDisplayChanged(event);
    }

    public void handleDisplayChanged(DisplayEvent event) {
    }

    protected boolean boundsClose(double a, double b) {
        if (a == b) {
            return true;
        }
        if (b == 0.0) {
            return false;
        }
        double diff = Math.abs((a - b) / b);
        return diff < 0.01;
    }

    @Override
    public void controlChanged(ControlEvent event) {
        if (!this.getHaveInitialized()) {
            return;
        }
        this.checkBoundsChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBoundsChange() {
        Rectangle2D newBounds = this.calculateRectangle();
        if (Misc.equals(newBounds, this.lastBounds)) {
            return;
        }
        if (this.lastBounds != null && newBounds != null && this.boundsClose(this.lastBounds.getX(), newBounds.getX()) && this.boundsClose(this.lastBounds.getY(), newBounds.getY()) && this.boundsClose(this.lastBounds.getWidth(), newBounds.getWidth()) && this.boundsClose(this.lastBounds.getHeight(), newBounds.getHeight())) {
            return;
        }
        this.lastBounds = newBounds;
        Object object = this.MUTEX_CONTROLCHANGE;
        synchronized (object) {
            this.lastControlChangeTime = System.currentTimeMillis();
            if (this.controlChangePending) {
                return;
            }
            this.controlChangePending = true;
            this.lastCheckControlChangeTime = this.lastControlChangeTime;
            Misc.runInABit(this.getControlChangeSleepTime(), new Runnable(){

                @Override
                public void run() {
                    NavigatedDisplay navDisplay = DisplayControlImpl.this.getNavigatedDisplay();
                    while (navDisplay.getIsAnimating() || DisplayControlImpl.this.lastControlChangeTime != DisplayControlImpl.this.lastCheckControlChangeTime) {
                        DisplayControlImpl.this.lastCheckControlChangeTime = DisplayControlImpl.this.lastControlChangeTime;
                        Misc.sleep(DisplayControlImpl.this.getControlChangeSleepTime());
                    }
                    DisplayControlImpl.this.viewpointChanged();
                    DisplayControlImpl.this.controlChangePending = false;
                }
            });
        }
    }

    protected long getControlChangeSleepTime() {
        return 500L;
    }

    public void viewpointChanged() {
        if (this.getMatchDisplayRegion() && this.reloadFromBounds) {
            this.loadDataFromViewBounds();
            this.reloadFromBounds = false;
        }
    }

    protected void loadDataFromViewBounds() {
        NavigatedDisplay nd = this.getNavigatedDisplay();
        if (nd != null) {
            GeoSelection geoSelection = this.getDataSelection().getGeoSelection(true);
            this.getViewManager().setProjectionFromData(false);
            try {
                Rectangle2D.Double bbox = nd.getLatLonBox();
                Rectangle sbox = nd.getScreenBounds();
                geoSelection.setScreenBound(sbox);
                geoSelection.setLatLonRect(bbox);
                geoSelection.setUseViewBounds(true);
                this.getDataSelection().setGeoSelection(geoSelection);
                EarthLocation el = nd.screenToEarthLocation((int)(((RectangularShape)sbox).getWidth() / 2.0), (int)(((RectangularShape)sbox).getHeight() / 2.0));
                LatLonPointImpl llpi = new LatLonPointImpl(el.getLatitude().getValue(), el.getLongitude().getValue());
                this.getDataSelection().putProperty("centerPosition", llpi);
                this.dataChanged();
                this.saveProjection();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.initializationDone && this.getActive() && evt.getPropertyName().equals("aniValue")) {
            Animation animation = null;
            if (evt.getSource() != null && evt.getSource() instanceof Animation) {
                animation = (Animation)evt.getSource();
            }
            if (animation == null) {
                Animation animation2 = animation = this.internalAnimation != null ? this.internalAnimation : this.viewAnimation;
            }
            if (animation != null) {
                this.timeChanged(animation.getAniValue());
            }
        }
    }

    @Override
    public void firstFrameDone() {
        this.reDisplayColorScales();
    }

    @Override
    public List getDataChoices() {
        if (this.controlContext != null && !this.controlContext.getPersistenceManager().getSaveDataSources()) {
            return null;
        }
        return this.myDataChoices;
    }

    public List getMyDataChoices() {
        return this.myDataChoices;
    }

    public List getInitDataChoices() {
        if (this.controlContext != null && !this.controlContext.getPersistenceManager().getSaveDataSources()) {
            return null;
        }
        return this.myDataChoices;
    }

    public void setInitDataChoices(List l) {
        this.initDataChoices = l;
    }

    public void setPersistedVisadData(List l) {
    }

    public boolean addDataChoice(DataChoice c) {
        if (this.myDataChoices == null) {
            this.myDataChoices = new ArrayList();
        }
        if (!this.myDataChoices.contains(c)) {
            this.myDataChoices.add(c);
            c.addDataChangeListener(this);
            return true;
        }
        return false;
    }

    public void removeDataChoice(DataChoice dataChoice) {
        if (this.myDataChoices == null) {
            this.myDataChoices = new ArrayList();
        }
        this.myDataChoices.remove(dataChoice);
        dataChoice.removeDataChangeListener(this);
    }

    public void setDataChoices(List newList) {
        this.removeListenerFromDataChoices();
        this.myDataChoices = newList;
        this.addListenerToDataChoices(this.myDataChoices);
    }

    public void appendDataChoices(List newDataChoices) {
        if (this.myDataChoices == null) {
            this.myDataChoices = new ArrayList();
        }
        this.myDataChoices.addAll(newDataChoices);
        this.addListenerToDataChoices(newDataChoices);
    }

    @Override
    public DataChoice getDataChoice() {
        List tmp = this.myDataChoices;
        if (tmp == null || tmp.size() == 0) {
            return null;
        }
        return (DataChoice)tmp.get(0);
    }

    @Override
    public synchronized void dataChanged() {
        if (!this.getHaveInitialized()) {
            return;
        }
        this.showWaitCursor();
        try {
            this.inDataChangeCall = true;
            this.resetData();
            List infos = this.getDisplayInfos();
            int i = 0;
            if (i < infos.size()) {
                DisplayInfo displayInfo = (DisplayInfo)infos.get(i);
                displayInfo.getViewManager().displayDataChanged(this);
            }
            this.inDataChangeCall = false;
        }
        catch (Exception exc) {
            this.inDataChangeCall = false;
            DisplayControlImpl.logException("Handling new data for display: " + this.toString(), exc);
        }
        this.updateLegendAndList();
        this.showNormalCursor();
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        try {
            if (dataId.equals("DisplayControlImpl.SHARE_COLORTABLE")) {
                this.setColorTable((ColorTable)data[0], false);
            } else if (dataId.equals("DisplayControlImpl.SHARE_COLORSCALE")) {
                this.colorScaleInfo = (ColorScaleInfo)data[0];
                this.applyColorScaleInfo();
            } else if (dataId.equals("DisplayControlImpl.SHARE_DISPLAYUNIT")) {
                this.setNewDisplayUnit((Unit)data[0], true);
            } else if (dataId.equals("DisplayControlImpl.SHARE_VISIBILITY")) {
                this.setDisplayVisibility((Boolean)data[0], false);
            } else if (dataId.equals("DisplayControlImpl.SHARE_SKIPVALUE")) {
                this.skipValue = (Integer)data[0];
                this.applySkipFactor();
            } else {
                super.receiveShareData(from, dataId, data);
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Error processing shared state: " + dataId, exc);
        }
    }

    protected void resetData() throws VisADException, RemoteException {
        this.setData(this.myDataChoices);
    }

    private void instantiateAttributes() throws VisADException, RemoteException {
        if (this.checkFlag(2)) {
            this.setContourInfo(this.getContourInfo());
        }
        if (this.checkFlag(8)) {
            if (!this.getHaveInitialized() && this.colorTable != null) {
                this.setColorTable(this.colorTable);
            } else {
                this.setColorTable(this.getOldColorTableOrInitialColorTable());
            }
            Range newRange = null;
            if (this.getHaveInitialized()) {
                newRange = this.getInitialRange();
            } else if (this.getRange() == null) {
                Range range = newRange = this.getRange() == null ? this.getInitialRange() : this.getRange();
            }
            if (newRange != null) {
                this.setRange(newRange);
            }
            if (this.colorScales == null) {
                this.doMakeColorScales();
            }
        }
    }

    protected void addNewData(List newChoices) throws VisADException, RemoteException {
        boolean needToInstantiateAttributes = true;
        if (newChoices.size() == this.myDataChoices.size()) {
            boolean allOk = true;
            for (int i = 0; i < newChoices.size(); ++i) {
                DataChoice oldDataChoice;
                DataChoice newDataChoice = (DataChoice)newChoices.get(i);
                if (newDataChoice.basicallyEquals(oldDataChoice = (DataChoice)this.myDataChoices.get(i)) || Misc.equals(newDataChoice.getName(), oldDataChoice.getName())) continue;
                allOk = false;
                break;
            }
            if (allOk) {
                needToInstantiateAttributes = false;
            }
        }
        this.setDataChoices(newChoices);
        this.setData(this.myDataChoices);
        if (needToInstantiateAttributes) {
            this.displayUnit = null;
            this.colorUnit = null;
            this.colorRange = null;
            this.selectRange = null;
            this.instantiateAttributes();
        }
        this.updateLegendAndList();
        this.setProjectionInView(true);
    }

    protected boolean setData(List newChoices) throws VisADException, RemoteException {
        boolean ok = this.myDataChoices != null && this.myDataChoices.size() > 0 ? this.setData((DataChoice)this.myDataChoices.get(0)) : this.setData((DataChoice)null);
        if (ok) {
            // empty if block
        }
        return ok;
    }

    protected boolean checkIfDataOk(DataInstance di) throws VisADException, RemoteException {
        try {
            return di.dataOk();
        }
        catch (DataCancelException dce) {
            return false;
        }
    }

    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        if (this.inDataChangeCall && this.getDataInstance() != null) {
            this.updateDataInstance(this.getDataInstance()).reInitialize();
            return true;
        }
        return this.initializeDataInstance(dataChoice);
    }

    private boolean initializeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        DataInstance di = this.doMakeDataInstance(dataChoice);
        if (this.cachedData != null) {
            Object id = dataChoice.getId();
            Data data = (Data)this.cachedData.get(id);
            if (data == null) {
                System.err.println("null bytes");
            } else {
                di.setTheData(data);
            }
        }
        if (di == null || !this.checkIfDataOk(di)) {
            return false;
        }
        this.setDataInstance(di);
        this.setTitle(this.getTitle());
        return true;
    }

    protected Range getInitialRange() throws RemoteException, VisADException {
        return null;
    }

    protected ColorTable getInitialColorTable() {
        return this.getDisplayConventions().getParamColorTable(this.paramName);
    }

    protected void revertToDefaultColorTable() {
        try {
            this.setDisplayInactive();
            this.setColorTable(this.getInitialColorTable());
            this.setRange(this.getInitialRange());
            this.setDisplayActive();
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Resetting color table", exc);
        }
    }

    protected void revertToDefaultRange() {
        try {
            this.setRange(this.getInitialRange());
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Resetting range", exc);
        }
    }

    protected final ColorTable getOldColorTableOrInitialColorTable() {
        if (this.colorTableName != null && this.controlContext != null) {
            try {
                ColorTable tmpCt = this.controlContext.getColorTableManager().getColorTable(this.colorTableName);
                this.colorTableName = null;
                return tmpCt;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getInitialColorTable();
    }

    public void setCategories(List c) {
        this.categories = c;
    }

    @Override
    public List getCategories() {
        return this.categories;
    }

    public void showWaitCursor() {
        this.getControlContext().showWaitCursor();
    }

    public void showNormalCursor() {
        this.getControlContext().showNormalCursor();
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPropertyDisplayName() {
        return this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String theId) {
        this.displayId = theId;
    }

    protected void clearDataInstance() {
        this.dataInstances = new ArrayList();
    }

    protected void setDataInstance(DataInstance dataInstance) {
        this.dataInstances = Misc.newList(dataInstance);
        this.setParamName(this.getDataInstance().getDataChoice().getName());
    }

    public DataInstance getDataInstance() {
        return this.getDataInstance(true);
    }

    public DataInstance getDataInstance(boolean forceCreation) {
        if (this.dataInstances == null || this.dataInstances.size() == 0) {
            try {
                if (forceCreation && this.myDataChoices != null && this.myDataChoices.size() == 1) {
                    if (!this.initializeDataInstance((DataChoice)this.myDataChoices.get(0))) {
                        return null;
                    }
                    if (this.dataInstances == null || this.dataInstances.size() == 0) {
                        return null;
                    }
                    return (DataInstance)this.dataInstances.get(0);
                }
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Creating data instance for display: " + this.toString(), exc);
            }
            return null;
        }
        try {
            DataInstance dataInstance = (DataInstance)this.dataInstances.get(0);
            return dataInstance;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public Data getData(DataInstance dataInstance) throws VisADException, RemoteException {
        return this.updateDataInstance(dataInstance).getData();
    }

    public FieldImpl getGrid(GridDataInstance dataInstance) throws VisADException, RemoteException {
        return this.getGrid(dataInstance, false);
    }

    public FieldImpl getGrid(GridDataInstance dataInstance, boolean copy) throws VisADException, RemoteException {
        return this.updateGridDataInstance(dataInstance).getGrid(copy);
    }

    protected GridDataInstance updateGridDataInstance(GridDataInstance dataInstance) throws VisADException, RemoteException {
        return (GridDataInstance)this.updateDataInstance(dataInstance);
    }

    protected DataInstance updateDataInstance(DataInstance dataInstance) throws VisADException, RemoteException {
        if (!this.getIdv().getUseTimeDriver()) {
            return dataInstance;
        }
        dataInstance.setDataSelection(this.updateDataSelection(dataInstance.getDataSelection()));
        return dataInstance;
    }

    protected DataSelection updateDataSelection(DataSelection dataSelection) throws VisADException, RemoteException {
        GeoSelection geoSelection = dataSelection.getGeoSelection(true);
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        Rectangle sbox = navDisplay.getScreenBounds();
        geoSelection.setScreenBound(sbox);
        boolean levelChanged = dataSelection.getProperty("levelChanged", false);
        if (this.getMatchDisplayRegion() && !levelChanged) {
            this.getViewManager().setProjectionFromData(false);
            Rectangle2D.Double bbox = navDisplay.getLatLonBox();
            geoSelection.setLatLonRect(bbox);
            geoSelection.setUseViewBounds(true);
            dataSelection.setGeoSelection(geoSelection);
            EarthLocation el = navDisplay.screenToEarthLocation((int)(((RectangularShape)sbox).getWidth() / 2.0), (int)(((RectangularShape)sbox).getHeight() / 2.0));
            LatLonPointImpl llpi = new LatLonPointImpl(el.getLatitude().getValue(), el.getLongitude().getValue());
            dataSelection.putProperty("centerPosition", llpi);
        }
        if (levelChanged) {
            dataSelection.removeProperty("levelChanged");
        }
        if (!this.getIdv().getUseTimeDriver()) {
            return dataSelection;
        }
        if (this.defaultView != null) {
            dataSelection.putProperty("Default_View", this.defaultView);
        }
        if (this.getIsTimeDriver() || !this.getUsesTimeDriver()) {
            if (!this.getUsesTimeDriver()) {
                dataSelection.setTheTimeDriverTimes(null);
                dataSelection.putProperty("Use_Display_Driver_Times", this.getUsesTimeDriver());
            }
            return dataSelection;
        }
        ViewManager vm = this.getViewManager();
        if (vm == null) {
            return dataSelection;
        }
        List<DateTime> times = vm.getTimeDriverTimes();
        dataSelection.putProperty("Use_Display_Driver_Times", true);
        dataSelection.setTheTimeDriverTimes(times);
        return dataSelection;
    }

    public void setDisplayAreaSubset(String n) {
        List dataSources = this.getIdv().getAllDataSources();
        List<ViewManager> vms = this.getIdv().getVMManager().getViewManagers();
        if (vms.size() > 1) {
            return;
        }
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            DataSelection ds = dataSource.getDataSelection();
            DataSelection ds1 = this.getDataSelection();
            ds.setGeoSelection(ds1.getGeoSelection());
            ds.setFromLevel(null);
            ds.setToLevel(null);
            ((DataSourceImpl)dataSource).setDataSelection(ds);
        }
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public ControlContext getViewer() {
        return this.controlContext;
    }

    public void setViewer(ControlContext controlContext) {
        this.controlContext = controlContext;
    }

    public ViewContext getViewContext() {
        return (ViewContext)this.controlContext;
    }

    public ControlContext getControlContext() {
        return this.controlContext;
    }

    public IntegratedDataViewer getIdv() {
        return this.getControlContext().getIdv();
    }

    public DisplayConventions getDisplayConventions() {
        return this.getControlContext().getDisplayConventions();
    }

    @Override
    public String getLabel() {
        return this.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public JFrame getWindow() {
        if (this.myWindow != null) {
            return this.myWindow.getFrame();
        }
        return null;
    }

    protected String getTitle() {
        return StringUtil.join("; ", this.getLegendLabels(0), true);
    }

    public void setTitle(String title) {
        if (this.myWindow != null) {
            this.myWindow.setTitle(title);
        } else if (this.outerContents != null) {
            this.getIdv().getIdvUIManager().displayControlChanged(this);
        }
    }

    protected void updateLegendLabel() {
        int i;
        List labels;
        if (!this.haveInitialized) {
            return;
        }
        if (this.controlContext == null) {
            return;
        }
        this.setTitle(this.getTitle());
        if (this.bottomLegendButton != null) {
            String bottomLegend = StringUtil.join("; ", this.getLegendLabels(0), true);
            this.bottomLegendButton.setText(bottomLegend);
        }
        if ((labels = this.getLegendLabels(1)).size() > 0) {
            String tmp = labels.get(0).toString();
            for (i = 0; i < this.labelsToUpdate.size(); ++i) {
                ((JLabel)this.labelsToUpdate.get(i)).setText(tmp);
            }
        }
        if (this.legendTextArea != null) {
            String otherText = "";
            for (i = 1; i < labels.size(); ++i) {
                String label = (String)labels.get(i);
                if (label == null || label.length() == 0) continue;
                if (otherText.length() != 0) {
                    otherText = otherText + "\n";
                }
                otherText = otherText + label;
            }
            if (otherText.length() > 0) {
                this.legendTextArea.setVisible(true);
            } else {
                this.legendTextArea.setVisible(false);
            }
            this.legendTextArea.setText(otherText);
        }
    }

    protected void updateLegendAndList() {
        if (!this.haveInitialized) {
            return;
        }
        this.updateLegendLabel();
        this.updateDisplayList();
    }

    protected void updateDisplayList() {
        if (!this.haveInitialized) {
            return;
        }
        Data d = this.getDisplayListData();
        if (d != null && this.displayListTable != null) {
            try {
                Enumeration e = this.displayListTable.elements();
                while (e.hasMoreElements()) {
                    ((DisplayableData)e.nextElement()).setData(d);
                }
            }
            catch (VisADException ve) {
                DisplayControlImpl.logException("Setting display list data", ve);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public Data getDataForDisplayList() {
        return this.getDisplayListData();
    }

    protected Data getDisplayListData() {
        DataImpl data = null;
        try {
            String template = this.applyMacrosToTemplate(this.getDisplayListTemplate(), false);
            Set s = this.getDataTimeSet();
            Calendar cal = null;
            if (s instanceof CalendarDateTimeSet) {
                cal = ((CalendarDateTimeSet)s).getCalendar();
            }
            TextType tt = TextType.getTextType("Display_List_Text");
            if (s != null) {
                FunctionType ft = new FunctionType(((SetType)s.getType()).getDomain(), tt);
                FieldImpl fi = new FieldImpl(ft, s);
                double[][] samples = s.getDoubles();
                samples = Unit.convertTuple(samples, s.getSetUnits(), new Unit[]{CommonUnit.secondsSinceTheEpoch});
                List fhour = null;
                for (int i = 0; i < s.getLength(); ++i) {
                    CalendarDateTime dt = new CalendarDateTime(samples[0][i], cal);
                    TimeZone tz = CalendarDateTime.getFormatTimeZone();
                    if (this.displayListTimeZone != null && tz != this.displayListTimeZone) {
                        CalendarDateTime.setFormatTimeZone(this.displayListTimeZone);
                    }
                    String label = UtcDate.applyTimeMacro(template, (DateTime)dt, this.getIdv().getPreferenceManager().getDefaultTimeZone());
                    if (i == 0 && this.hasForecastHourMacro(label)) {
                        String rtime = (String)this.getDataChoice().getProperty("RUNTIME");
                        if (rtime == null && this.getDataChoice() instanceof DerivedDataChoice) {
                            DataChoice childChoice = (DataChoice)((DerivedDataChoice)this.getDataChoice()).getChoices().get(0);
                            while (childChoice instanceof DerivedDataChoice) {
                                childChoice = (DataChoice)((DerivedDataChoice)childChoice).getChoices().get(0);
                            }
                            rtime = (String)childChoice.getProperty("RUNTIME");
                        }
                        if (rtime != null && rtime.length() > 0) {
                            fhour = StringUtil.parseFloatListString(rtime);
                        }
                    }
                    if (this.hasForecastHourMacro(label) && fhour != null && fhour.size() == s.getLength()) {
                        String v = "";
                        float fh = ((Float)fhour.get(i)).floatValue();
                        v = fh == (float)Math.round(fh) ? (int)fh + "" : fh + "";
                        label = label.replace("%fhour2%", v).replace("%fhour%", v + "H");
                    } else {
                        label = this.applyForecastHourMacro(label, dt);
                    }
                    Text t = new Text(tt, label);
                    fi.setSample(i, (Data)t, false);
                }
                data = fi;
            } else {
                String label = UtcDate.applyTimeMacro(template, null);
                label = this.applyForecastHourMacro(label, null);
                data = new Text(tt, label);
            }
        }
        catch (VisADException ve) {
            DisplayControlImpl.logException("Getting display list data", ve);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return data;
    }

    @Override
    public DisplayableData getDisplayListDisplayable(ViewManager view) {
        if (this.hasBeenRemoved) {
            return null;
        }
        DisplayableData displayListDisplayable = null;
        if (this.displayListTable == null) {
            return null;
        }
        try {
            displayListDisplayable = (DisplayableData)this.displayListTable.get(view);
            if (displayListDisplayable == null) {
                displayListDisplayable = this.createDisplayListDisplayable(view);
                this.displayListTable.put(view, displayListDisplayable);
            }
            this.checkTimestampLabel(null);
            this.updateDisplayList();
            this.setDisplayListProperties(displayListDisplayable, view);
        }
        catch (VisADException ve) {
            DisplayControlImpl.logException("Getting display list displayable", ve);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return displayListDisplayable;
    }

    protected void setDisplayListProperties(DisplayableData d, ViewManager view) throws VisADException, RemoteException {
        int size;
        Font f = view.getDisplayListFont();
        int n = size = f == null ? 12 : f.getSize();
        if (f != null && f.getName().equals("Default")) {
            f = null;
        }
        ((TextDisplayable)d).setFont(f);
        ((TextDisplayable)d).setTextSize((float)size / 12.0f);
        if (view.getDisplayListColor() != null) {
            d.setColor(view.getDisplayListColor());
            this.displayListUsesColor = false;
        }
    }

    private final List getLegendLabels(int legendType) {
        ArrayList labels = new ArrayList();
        this.getLegendLabels(labels, legendType);
        return labels;
    }

    @Override
    public JComponent getLegendButtons(int legendType) {
        if (legendType == 1) {
            if (this.sideLegendButtonPanel == null) {
                this.sideLegendButtonPanel = GuiUtils.hbox((Component)this.makeLockButton(), (Component)this.makeRemoveButton(), 2);
                this.sideLegendButtonPanel.setBackground(null);
            }
            return this.sideLegendButtonPanel;
        }
        if (this.bottomLegendButtonPanel == null) {
            this.bottomLegendButtonPanel = GuiUtils.hbox((Component)this.makeLockButton(), (Component)this.makeRemoveButton(), 2);
            this.bottomLegendButtonPanel.setBackground(null);
        }
        return this.bottomLegendButtonPanel;
    }

    protected String getShortParamName() {
        return this.paramName;
    }

    protected String getLongParamName() {
        DataChoice dataChoice = this.getDataChoice();
        return dataChoice == null ? null : dataChoice.getDescription();
    }

    public List getDataSources() {
        ArrayList dataSources = new ArrayList();
        if (this.myDataChoices != null) {
            for (Object myDataChoice : this.myDataChoices) {
                DataChoice dc = (DataChoice)myDataChoice;
                dc.getDataSources(dataSources);
            }
        }
        return dataSources;
    }

    protected void addLabelMacros(String template, List patterns, List values) {
        List dataSources = this.getDataSources();
        Hashtable<DataSource, DataSource> seen = new Hashtable<DataSource, DataSource>();
        String dataSourceName = null;
        for (int i = 0; i < dataSources.size(); ++i) {
            DataSource dataSource = (DataSource)dataSources.get(i);
            if (seen.get(dataSource) != null) continue;
            seen.put(dataSource, dataSource);
            String name = DataSelector.getNameForDataSource(dataSource);
            dataSourceName = dataSourceName == null ? name : ";" + name;
        }
        patterns.add("%displayname%");
        values.add(this.getDisplayName());
        patterns.add("%shortname%");
        values.add(this.getShortParamName());
        patterns.add("%longname%");
        values.add(this.getLongParamName());
        patterns.add("%datasourcename%");
        values.add(dataSourceName);
        if (this.displayUnit != null) {
            patterns.add("%displayunit%");
            values.add("" + this.displayUnit);
        }
        patterns.add("%resolution%");
        if (this.resolutionReadout == null || this.resolutionReadout.isEmpty()) {
            values.add("");
        } else {
            values.add(this.resolutionReadout);
        }
    }

    protected void getLegendLabels(List labels, int legendType) {
        labels.add(this.applyMacrosToTemplate(this.getLegendLabelTemplate(), true));
        if (this.extraLabelTemplate != null && this.extraLabelTemplate.length() > 0) {
            labels.addAll(StringUtil.split(this.applyMacrosToTemplate(this.extraLabelTemplate, true), "\n", true, true));
        }
    }

    private String applyMacrosToTemplate(String template, boolean timeOk) {
        ArrayList patterns = new ArrayList();
        ArrayList values = new ArrayList();
        this.addLabelMacros(template, patterns, values);
        if (timeOk && this.hasTimeMacro(template)) {
            if (this.firstTime == null || this.currentTime == null) {
                this.checkTimestampLabel(null);
            }
            if (UtcDate.containsTimeMacro(template)) {
                template = UtcDate.applyTimeMacro(template, this.currentTime, this.getIdv().getPreferenceManager().getDefaultTimeZone());
            }
            template = this.applyForecastHourMacro(template, this.currentTime);
        }
        return StringUtil.replaceList(template, patterns, values);
    }

    protected String applyForecastHourMacro(String t, DateTime currentTime) {
        if (this.hasForecastHourMacro(t)) {
            String v = "";
            if (this.firstTime == null) {
                this.checkTimestampLabel(null);
            }
            if (this.firstTime != null && currentTime != null) {
                try {
                    double diff = currentTime.getValue(CommonUnit.secondsSinceTheEpoch) - this.firstTime.getValue(CommonUnit.secondsSinceTheEpoch);
                    v = (int)(diff / 60.0 / 60.0) + "";
                }
                catch (Exception exc) {
                    System.err.println("Error:" + exc);
                    exc.printStackTrace();
                }
            }
            return t.replace("%fhour2%", v).replace("%fhour%", v + "H");
        }
        return t;
    }

    protected boolean hasForecastHourMacro(String t) {
        return t.matches(".*(%fhour%|%fhour2%).*");
    }

    @Override
    public String getMenuLabel() {
        String l1;
        List labels = this.getLegendLabels(1);
        if (labels.size() > 0) {
            return labels.get(0).toString();
        }
        String string = l1 = this.paramName == null ? "" : this.paramName;
        if (l1.length() > 20) {
            l1 = l1.substring(0, 19) + "... ";
        }
        return l1 + " " + this.getDisplayName();
    }

    @Override
    public void toFront() {
        if (this.myWindow != null && this.makeWindow) {
            if (this.myWindow.getState() == 1) {
                this.myWindow.setState(0);
            }
            this.myWindow.toFront();
        }
    }

    protected boolean removeOnWindowClose() {
        return this.getObjectStore().get("DisplayControl.RemoveOnWindowClose", false);
    }

    public void guiImported() {
        IdvWindow tmp = this.myWindow;
        this.myWindow = null;
        if (tmp != null) {
            tmp.dispose();
            this.setMakeWindow(false);
        }
    }

    public void guiExported() {
        if (this.myWindow != null) {
            return;
        }
        this.setMakeWindow(true);
        this.myWindow = this.createIdvWindow();
        if (this.myWindow != null) {
            this.myWindow.setTitle(this.getTitle());
            this.myWindow.setContents(this.outerContents);
            this.myWindow.show();
        }
    }

    protected IdvWindow createIdvWindow() {
        ImageIcon icon;
        String iconLoc;
        if (!this.getIdv().okToShowWindows()) {
            return null;
        }
        this.myWindow = new IdvWindow(this.getTitle(), this.getIdv());
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (DisplayControlImpl.this.myWindow == null) {
                    return;
                }
                DisplayControlImpl.this.handleWindowClosing();
            }
        };
        this.myWindow.addWindowListener(this.windowListener);
        ControlDescriptor cd = this.getIdv().getControlDescriptor(this.displayId);
        if (cd != null && (iconLoc = cd.getIcon()) != null && (icon = GuiUtils.getImageIcon(iconLoc, this.getIdv().getClass())) != null) {
            this.myWindow.setIconImage(icon.getImage());
        }
        return this.myWindow;
    }

    protected DisplayableData createDisplayListDisplayable(ViewManager view) throws VisADException, RemoteException {
        Data d;
        TextDisplayable dt = new TextDisplayable(this.getTitle(), TextType.getTextType("Display_List_Text"), true);
        dt.setUseTimesInAnimation(false);
        if (this.displayListColor == null) {
            if (view.getDisplayListColor() != null) {
                this.displayListColor = view.getDisplayListColor();
            } else if (this.color != null) {
                this.displayListColor = this.color;
                this.displayListUsesColor = true;
            } else {
                this.getDisplayConventions();
                this.displayListColor = DisplayConventions.getColor();
            }
        }
        ((Displayable)dt).setColor(this.displayListColor);
        ((DisplayableData)dt).setVisible(this.getDisplayVisibility());
        if (this.firstTime == null) {
            this.checkTimestampLabel(null);
        }
        if ((d = this.getDisplayListData()) != null) {
            dt.setData(d);
        }
        return dt;
    }

    protected void doMakeWindow() throws VisADException, RemoteException {
        if (this.outerContents != null) {
            return;
        }
        if (this.contents == null) {
            this.contents = this.doMakeContents();
        }
        this.mainPanel = GuiUtils.center(GuiUtils.inset((Component)this.contents, 3));
        if (this.showNoteText) {
            this.showNoteTextArea();
        }
        DndImageButton dndBtn = new DndImageButton(this, "control");
        this.outerContents = GuiUtils.topCenter(this.doMakeMenuBar(), this.mainPanel);
        Msg.translateTree(this.outerContents, true);
    }

    protected boolean isGuiShown() {
        if (this.mainPanel != null) {
            try {
                this.mainPanel.getLocationOnScreen();
            }
            catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    protected JMenuBar doMakeMenuBar() {
        DndImageButton dndBtn = new DndImageButton(this, "control");
        List menus = this.doMakeMenuBarMenus(new ArrayList());
        JMenuBar menuBar = new JMenuBar();
        for (Object menu : menus) {
            menuBar.add((JMenu)menu);
        }
        return menuBar;
    }

    public void captureWindow() {
        int returnVal;
        String name = this.getClass().getName();
        int idx = name.lastIndexOf(".");
        name = name.substring(idx + 1);
        name = name + ".jpg";
        JTextField nameFld = new JTextField(name, 15);
        nameFld.setCaretPosition(0);
        FileManager.MyFileChooser chooser = new FileManager.MyFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setAccessory(GuiUtils.top(GuiUtils.hbox((Component)new JLabel("Name:"), (Component)nameFld, 5)));
        if (captureDir != null) {
            chooser.setCurrentDirectory(captureDir);
        }
        if ((returnVal = chooser.showOpenDialog(null)) != 0) {
            return;
        }
        captureDir = chooser.getSelectedFile();
        name = nameFld.getText().trim();
        String path = IOUtil.joinDir(captureDir.toString(), name);
        try {
            ImageUtils.writeImageToFile(this.outerContents, path);
            System.out.println("Write to:" + path);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Capturing window", exc);
        }
    }

    protected void setMainPanelDimensions() throws Exception {
        this.doMakeWindow();
        boolean needToResize = this.mainPanel.getSize().width == 0 || this.mainPanel.getSize().height == 0;
        this.mainPanel.invalidate();
        if (needToResize) {
            JFrame frame = GuiUtils.getFrame(this.mainPanel);
            if (frame != null) {
                if (this.mainPanelSize != null) {
                    this.mainPanel.setSize(this.mainPanelSize);
                }
                frame.pack();
                if (this.mainPanelSize != null) {
                    frame.setSize(this.mainPanelSize);
                }
            } else {
                JFrame f = new JFrame();
                if (this.mainPanelSize != null) {
                    this.mainPanel.setSize(this.mainPanelSize);
                    this.mainPanel.setMinimumSize(this.mainPanelSize);
                    this.mainPanel.setPreferredSize(this.mainPanelSize);
                }
                f.getContentPane().add(this.mainPanel);
                f.pack();
            }
        }
    }

    public Image getImage() throws Exception {
        return this.getImage(null);
    }

    public ViewManager getViewManagerForCapture(String what) throws Exception {
        System.err.println("base for capture:" + this.getClass().getName());
        return null;
    }

    public Image getImage(String what) throws Exception {
        if (what != null) {
            System.err.println("Unknown image capture component:" + what);
        }
        this.setMainPanelDimensions();
        if (!this.getIdv().getArgsManager().getIsOffScreen()) {
            GuiUtils.showComponentInTabs(this.mainPanel);
        }
        return ImageUtils.getImage(this.mainPanel);
    }

    protected List doMakeMenuBarMenus(List menus) {
        if (menus == null) {
            menus = new ArrayList<JMenu>();
        }
        final JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(GuiUtils.charToKeyCode("F"));
        final JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic(GuiUtils.charToKeyCode("E"));
        final JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(GuiUtils.charToKeyCode("V"));
        final JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(GuiUtils.charToKeyCode("H"));
        ArrayList extras = new ArrayList();
        this.getExtraMenus(extras, true);
        menus.add(fileMenu);
        menus.add(editMenu);
        menus.add(viewMenu);
        if (!extras.isEmpty()) {
            for (int i = 0; i < extras.size(); ++i) {
                menus.add((JMenu)extras.get(i));
            }
        }
        menus.add(helpMenu);
        fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                DisplayControlImpl.this.makeFileMenu(fileMenu);
            }
        });
        viewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                DisplayControlImpl.this.makeViewMenu(viewMenu);
            }
        });
        editMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                DisplayControlImpl.this.makeEditMenu(editMenu);
            }
        });
        helpMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                DisplayControlImpl.this.makeHelpMenu(helpMenu);
            }
        });
        return menus;
    }

    public XmlObjectStore getStore() {
        if (this.controlContext == null) {
            return null;
        }
        return this.controlContext.getObjectStore();
    }

    protected void handleWindowClosing() {
        boolean remove = this.removeOnWindowClose();
        if (!remove && this.getDisplayInfos().size() == 0) {
            remove = this.getStore().get("idv.displaycontrol.standalone.removeonclose", false);
            if (this.getStore().get("idv.displaycontrol.standalone.removeonclose.ask", false)) {
                JCheckBox askCbx = new JCheckBox("Don't show this window again", false);
                JPanel contents = GuiUtils.vbox(new JLabel("<html><b>NOTE:</b> This display control has no other components.<p>Do you want to remove it or just close the window?</html>"), GuiUtils.filler(), askCbx);
                contents = GuiUtils.inset((Component)contents, 10, 5);
                int result = GuiUtils.makeDialog(this.getWindow(), "Remove Or Close?", contents, this.getWindow(), new String[]{"Remove the Display", "Close the Window"});
                remove = result == 0;
                this.getStore().put("idv.displaycontrol.standalone.removeonclose", remove);
                this.getStore().put("idv.displaycontrol.standalone.removeonclose.ask", !askCbx.isSelected());
                this.getStore().save();
            }
        }
        if (remove) {
            Misc.run(this, "doRemove");
        } else if (this.myWindow != null && this.windowListener != null) {
            this.myWindow.removeWindowListener(this.windowListener);
            this.myWindow = null;
        }
    }

    public Component getOuterContents() {
        return this.outerContents;
    }

    public JComponent getMainPanel() {
        return this.mainPanel;
    }

    public void setMakeWindow(boolean value) {
        this.makeWindow = value;
    }

    public boolean getMakeWindow() {
        return this.makeWindow;
    }

    public void setWindowSize(Dimension value) {
        this.windowSize = value;
    }

    public Dimension getWindowSize() {
        if (this.myWindow != null) {
            return this.myWindow.getSize();
        }
        return null;
    }

    public Dimension getMainPanelSize() {
        if (this.mainPanel != null) {
            return this.mainPanel.getSize();
        }
        return null;
    }

    public void setMainPanelSize(Dimension s) {
        this.mainPanelSize = s;
    }

    public void setWindowX(int x) {
        this.windowX = x;
    }

    public int getWindowX() {
        return this.myWindow != null ? this.myWindow.getLocation().x : 50;
    }

    public void setWindowY(int y) {
        this.windowY = y;
    }

    public int getWindowY() {
        return this.myWindow != null ? this.myWindow.getLocation().y : 100;
    }

    @Override
    public void show() {
        this.popup(null);
        if (this.myWindow != null && this.makeWindow) {
            this.controlContext.showWindow(this, this.myWindow);
        }
    }

    @Override
    public void toggleWindow() {
        if (this.makeWindow) {
            if (this.getWindowVisible()) {
                this.hide();
            } else {
                this.popup(this.sideLegendLabel);
            }
        } else if (this.outerContents != null) {
            GuiUtils.showComponentInTabs(this.outerContents);
        }
    }

    public void hide() {
        if (this.myWindow != null) {
            this.myWindow.setVisible(false);
        }
    }

    public void initWindow(final IdvWindow window) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    if (DisplayControlImpl.this.hasBeenRemoved) {
                        return;
                    }
                    if (DisplayControlImpl.this.outerContents == null) {
                        return;
                    }
                    window.setTitle(DisplayControlImpl.this.getTitle());
                    window.setContents(DisplayControlImpl.this.outerContents);
                    if (DisplayControlImpl.this.windowSize != null) {
                        window.setWindowBounds(new Rectangle(DisplayControlImpl.this.windowX, DisplayControlImpl.this.windowY, ((DisplayControlImpl)DisplayControlImpl.this).windowSize.width, ((DisplayControlImpl)DisplayControlImpl.this).windowSize.height));
                    } else {
                        window.setLocation(DisplayControlImpl.this.windowX, DisplayControlImpl.this.windowY);
                    }
                    DisplayControlImpl.this.controlContext.showWindow(DisplayControlImpl.this, window);
                    if (!DisplayControlImpl.this.myWindowVisible) return;
                }
                catch (Exception exc) {
                    System.err.println("ERROR:" + DisplayControlImpl.this.hasBeenRemoved);
                    System.err.println("oops: " + exc);
                    exc.printStackTrace();
                }
            }
        });
    }

    public boolean getWindowVisible() {
        return this.myWindow != null && this.myWindow.isShowing();
    }

    public boolean shouldWindowBeVisible() {
        return this.myWindowVisible;
    }

    public void setWindowVisible(boolean v) {
        this.myWindowVisible = v;
        if (this.myWindow != null) {
            if (this.myWindowVisible) {
                this.show();
            } else {
                this.hide();
            }
        }
    }

    protected String getChangeParameterLabel() {
        return "Change Parameter...";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String url = e.getURL() == null ? e.getDescription() : e.getURL().toString();
            this.controlContext.handleAction(url, null);
        }
    }

    private String getActualHelpUrl() {
        if (this.helpUrl != null) {
            return this.helpUrl;
        }
        return "idv.controls." + this.displayId;
    }

    public boolean hasMapProjection() {
        return this.hasDisplayWithData();
    }

    private boolean hasDisplayWithData() {
        boolean hasDisplayWithData = false;
        try {
            List infos = this.getDisplayInfos();
            for (Object info1 : infos) {
                DisplayInfo info = (DisplayInfo)info1;
                Data data = info.getDisplayable().getData();
                if (data == null || !(data instanceof FieldImpl)) continue;
                hasDisplayWithData = true;
                break;
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Inserting displayables", exc);
        }
        return hasDisplayWithData;
    }

    private void makeEditMenu(JMenu menu) {
        menu.removeAll();
        ArrayList items = new ArrayList();
        this.getEditMenuItems(items, true);
        GuiUtils.makeMenu(menu, items);
        Msg.translateTree(menu);
    }

    private void makeViewMenu(JMenu menu) {
        menu.removeAll();
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        this.getViewMenuItems(items, true);
        this.getIdv().getIdvUIManager().addViewMenuItems(this, items);
        if (this.componentHolder != null) {
            items.add(GuiUtils.makeMenuItem("Undock", this.componentHolder, "undockControl"));
        }
        GuiUtils.makeMenu(menu, items);
        Msg.translateTree(menu);
    }

    public void reloadDataSource() throws RemoteException, VisADException {
        List dataSources = Misc.makeUnique(this.getDataSources());
        for (int i = 0; i < dataSources.size(); ++i) {
            ((DataSource)dataSources.get(i)).reloadData();
        }
    }

    public void reloadDataSourceInThread() throws RemoteException, VisADException {
        Misc.run(this, "reloadDataSource");
    }

    protected void getLastFileMenuItems(List items) {
        if (this.myDataChoices != null && this.myDataChoices.size() > 0) {
            items.add("separator");
            items.add(GuiUtils.makeMenuItem("Reload Data", this, "reloadDataSourceInThread"));
        }
        if (this.makeWindow) {
            items.add("separator");
            items.add(GuiUtils.makeMenuItem(this.getWindowVisible() ? "Close Window" : "Show Window", this, "toggleWindow"));
        }
    }

    private void makeFileMenu(JMenu menu) {
        menu.removeAll();
        ArrayList<Object> items = new ArrayList<Object>();
        this.getFileMenuItems(items, true);
        ArrayList saveItems = new ArrayList();
        this.getSaveMenuItems(saveItems, true);
        items.add("separator");
        items.add(GuiUtils.makeMenu(new JMenu("Save"), saveItems));
        this.getLastFileMenuItems(items);
        GuiUtils.makeMenu(menu, items);
        Msg.translateTree(menu);
    }

    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        if (!items.isEmpty()) {
            items.add("separator");
        }
        if (this.canSaveDataInCache()) {
            items.add(GuiUtils.makeMenuItem("Save Data in Cache...", this, "saveDataChoiceInCache"));
        }
        if (this.canExportData()) {
            items.add(GuiUtils.makeMenuItem("Export Displayed Data to NetCDF...", this, "exportDisplayedData", ".nc", true));
        }
        if (this.myDataChoices != null && this.haveParameterDefaults() && this.myDataChoices.size() == 1) {
            items.add(GuiUtils.makeMenuItem("Save As Parameter Defaults", this, "saveAsParameterDefaults"));
        }
        items.addAll(GuiUtils.makeMenuItems(this, new String[][]{{"Save Display as Favorite...", "saveAsFavorite", null, "Save this display, without its data, as a favorite template"}, {"Save Display as Bundle...", "saveAsTemplate", null, "Save this display, without its data, as a template"}}));
    }

    private void makeHelpMenu(JMenu menu) {
        menu.removeAll();
        ArrayList items = new ArrayList();
        this.getHelpMenuItems(items, true);
        GuiUtils.makeMenu(menu, items);
        Msg.translateTree(menu);
    }

    public List getEditMenuItems(List items) {
        this.getEditMenuItems(items, false);
        return items;
    }

    public List getFileMenuItems(List items) {
        this.getFileMenuItems(items, false);
        return items;
    }

    public List getViewMenuItems(List items) {
        this.getViewMenuItems(items, false);
        return items;
    }

    protected void getEditMenuItems(List items, boolean forMenuBar) {
        boolean addedSeparator = false;
        if (this.ctw != null) {
            if (items.size() > 0 && !addedSeparator) {
                items.add("separator");
            }
            addedSeparator = true;
            items.add(this.ctw.makeMenu());
        }
        if (this.checkFlag(4)) {
            if (items.size() > 0 && !addedSeparator) {
                items.add("separator");
            }
            addedSeparator = true;
            items.add(this.doMakeChangeColorMenu());
        }
        boolean addedChangeSeparator = false;
        if (this.checkFlag(16)) {
            if (!addedChangeSeparator) {
                items.add("separator");
            }
            addedChangeSeparator = true;
            items.add(this.doMakeChangeParameterMenuItem());
        }
        if (this.checkFlag(32) && this.displayUnit != null) {
            if (!addedChangeSeparator) {
                items.add("separator");
            }
            addedChangeSeparator = true;
            items.add(GuiUtils.makeMenuItem("Change Display Unit...", this, "changeDisplayUnit"));
        }
        if (this.checkFlag(64) && this.colorUnit != null) {
            if (!addedChangeSeparator) {
                items.add("separator");
            }
            addedChangeSeparator = true;
            items.add(GuiUtils.makeMenuItem("Change Color Unit...", this, "changeColorUnit"));
        }
        if (this.checkFlag(2)) {
            if (!addedChangeSeparator) {
                items.add("separator");
            }
            addedChangeSeparator = true;
            items.add(GuiUtils.makeMenuItem("Change Contours...", this, "showContourPropertiesDialog"));
        }
        if (!items.isEmpty()) {
            items.add("separator");
        }
        JMenu sharingMenu = new JMenu("Sharing");
        items.add(sharingMenu);
        sharingMenu.add(GuiUtils.makeCheckboxMenuItem("Sharing On", this, "sharing", null));
        sharingMenu.add(GuiUtils.makeMenuItem("Set Share Group", this, "showSharableDialog"));
        if (!items.isEmpty()) {
            items.add("separator");
        }
        items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Display Settings...", this, "showDisplaySettingsDialog"), "/auxdata/ui/icons/Settings16.png"));
        items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Properties...", this, "showProperties"), "/auxdata/ui/icons/information.png"));
    }

    protected boolean haveParameterDefaults() {
        return this.ctw != null || this.checkFlag(32) && this.displayUnit != null || this.checkFlag(2);
    }

    @Override
    public Set getTimeSet() throws RemoteException, VisADException {
        return this.getDataTimeSet();
    }

    protected Set getDataTimeSet() throws RemoteException, VisADException {
        Set aniSet = null;
        List infos = this.getDisplayInfos();
        for (Object info : infos) {
            DisplayInfo displayInfo = (DisplayInfo)info;
            Animation animation = displayInfo.getViewManager().getAnimation();
            if (animation == null) continue;
            RealType aniType = animation.getAnimationRealType();
            Set set = displayInfo.getDisplayable().getAnimationSet(aniType, true);
            if (set == null) continue;
            aniSet = aniSet == null ? set : aniSet.merge1DSets(set);
        }
        return aniSet;
    }

    protected boolean haveDataTimes() {
        try {
            return this.getDataTimeSet() != null;
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Checking for times", exc);
            return false;
        }
    }

    private JButton makeMacroPopup(final JTextComponent field, final String pref, final String property) {
        final JButton popupBtn = new JButton("Add Macro");
        popupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DisplayControlImpl.this.showMacroPopup(popupBtn, field, pref, property);
            }
        });
        return popupBtn;
    }

    private void showMacroPopup(JButton popupBtn, final JTextComponent field, String pref, String property) {
        ArrayList<Object> macroItems = new ArrayList<Object>();
        ArrayList names = new ArrayList();
        ArrayList labels = new ArrayList();
        this.getMacroNames(names, labels);
        for (int i = 0; i < names.size(); ++i) {
            JMenuItem btn = new JMenuItem(labels.get(i).toString());
            btn.addActionListener(new ObjectListener(names.get(i)){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int selectEnd;
                    String text = field.getText();
                    int caret = field.getCaretPosition();
                    int selectStart = field.getSelectionStart();
                    if (selectStart != (selectEnd = field.getSelectionEnd())) {
                        text = text.substring(0, selectStart) + text.substring(selectEnd);
                        caret = Math.max(0, caret - (selectEnd - selectStart));
                    }
                    if (caret >= text.length()) {
                        field.setText(text + this.theObject);
                    } else {
                        field.setText(text.substring(0, caret) + this.theObject + text.substring(caret));
                    }
                }
            });
            macroItems.add(btn);
        }
        if (pref != null) {
            macroItems.add("separator");
            macroItems.add(GuiUtils.makeMenuItem("Use as default for this type of display", this, "setLabelAsPreference", new Object[]{field, pref + "." + this.displayId}));
            macroItems.add(GuiUtils.makeMenuItem("Use as default for all displays with data", this, "setLabelAsPreference", new Object[]{field, pref + ".data"}));
            macroItems.add(GuiUtils.makeMenuItem("Use as default for all displays without data", this, "setLabelAsPreference", new Object[]{field, pref + ".nodata"}));
        }
        JPopupMenu macroPopup = GuiUtils.makePopupMenu(macroItems);
        macroPopup.show(popupBtn, 0, popupBtn.getBounds().height);
    }

    protected List findDisplays(String key) {
        List displays = this.getIdv().getDisplayControls();
        return this.findDisplays(key, displays);
    }

    protected List findDisplays(String key, List displays) {
        ArrayList<DisplayControlImpl> result = new ArrayList<DisplayControlImpl>();
        if (key == null || key.length() == 0 || key.equals("all")) {
            return displays;
        }
        if (key.equals("this")) {
            result.add(this);
            return result;
        }
        ViewManager vm = this.getDefaultViewManager();
        for (int i = 0; i < displays.size(); ++i) {
            DisplayControlImpl control = (DisplayControlImpl)displays.get(i);
            if (key.startsWith("class:")) {
                String className = key.substring(6);
                if (!control.getClass().getName().equals(className)) continue;
                result.add(control);
                continue;
            }
            if (key.startsWith("withthisview")) {
                if (!Misc.equals(vm, control.getDefaultViewManager())) continue;
                result.add(control);
                continue;
            }
            if (key.startsWith("category:")) {
                String value = key.substring(9);
                if (!Misc.equals(value, control.getDisplayCategory())) continue;
                result.add(control);
                continue;
            }
            if (key.equals("withdata")) {
                if (control.getShortParamName() == null) continue;
                result.add(control);
                continue;
            }
            if (key.equals("special")) {
                if (control.getShortParamName() != null) continue;
                result.add(control);
                continue;
            }
            if (key.equals("withthisdata")) {
                if (!Misc.equals(this.getDataSources(), control.getDataSources())) continue;
                result.add(control);
                continue;
            }
            if (key.equals("withthisfield")) {
                if (!this.getShortParamName().equals(control.getShortParamName())) continue;
                result.add(control);
                continue;
            }
            if (i != 0) continue;
            System.err.println("unknown key:" + key);
        }
        return result;
    }

    private void popupCategoryMenu(JTextField categoryFld, JButton categoryBtn) {
        ArrayList<JMenuItem> categoryItems = new ArrayList<JMenuItem>();
        Enumeration keys = allCategories.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            categoryItems.add(GuiUtils.makeMenuItem(key, categoryFld, "setText", key));
        }
        JPopupMenu categoryPopup = GuiUtils.makePopupMenu(categoryItems);
        categoryPopup.show(categoryBtn, 0, categoryBtn.getBounds().height);
    }

    public void showProperties() {
        JTabbedPane jtp = new JTabbedPane();
        this.addPropertiesComponents(jtp);
        JDialog propertiesDialog = GuiUtils.createDialog("Properties -- " + this.getTitle(), true);
        ActionListener listener = event -> {
            String cmd = event.getActionCommand();
            if ((cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) && !this.applyProperties()) {
                return;
            }
            if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                propertiesDialog.dispose();
            }
        };
        Window f = GuiUtils.getWindow(this.contents);
        JPanel buttons = GuiUtils.makeApplyOkCancelButtons(listener);
        JPanel propContents = GuiUtils.inset((Component)GuiUtils.centerBottom(jtp, buttons), 5);
        Msg.translateTree(jtp, true);
        propertiesDialog.getContentPane().add(propContents);
        propertiesDialog.pack();
        if (f != null) {
            GuiUtils.showDialogNearSrc(f, propertiesDialog);
        } else {
            propertiesDialog.setVisible(true);
        }
    }

    protected void addPropertiesComponents(JTabbedPane jtp) {
        DataSourceImpl dataSource;
        DataChoice dataChoice;
        List allTimes;
        int width = 20;
        ArrayList<Component> comps = new ArrayList<Component>();
        final JTextField catFld = this.categoryFld = new JTextField(this.displayCategory, width);
        final JButton categoryBtn = new JButton("<<");
        categoryBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DisplayControlImpl.this.popupCategoryMenu(catFld, categoryBtn);
            }
        });
        comps.add(GuiUtils.rLabel("Display Category:"));
        comps.add(this.categoryFld);
        comps.add(GuiUtils.left(categoryBtn));
        this.legendLabelTemplateFld = new JTextField(this.getLegendLabelTemplate(), width);
        this.legendLabelTemplateFld.setToolTipText("Enter your own label");
        JButton popupBtn = this.makeMacroPopup(this.legendLabelTemplateFld, "idv.legendlabel.template", "legendLabelTemplate");
        comps.add(GuiUtils.rLabel("Legend Label:"));
        comps.add(this.legendLabelTemplateFld);
        comps.add(popupBtn);
        this.extraLabelTemplateFld = new JTextArea(this.extraLabelTemplate, 3, 25);
        this.extraLabelTemplateFld.setToolTipText("Enter extra legend labels");
        popupBtn = this.makeMacroPopup(this.extraLabelTemplateFld, "idv.extralabel.template", "extraLabelTemplate");
        JScrollPane sp = new JScrollPane(this.extraLabelTemplateFld, 22, 30);
        comps.add(GuiUtils.top(GuiUtils.rLabel("Extra Legend Labels:")));
        comps.add(sp);
        comps.add(popupBtn);
        this.displayListTemplateFld = new JTextField(this.displayListTemplate, width);
        JPanel colorSwatch = GuiUtils.wrap(new JLabel("     "));
        colorSwatch.setBackground(this.getDisplayListColor());
        colorSwatch.setToolTipText("Click to change display list color");
        final JPanel theColorSwatch = colorSwatch;
        colorSwatch.addMouseListener(new ObjectListener(null){

            @Override
            public void mouseClicked(MouseEvent me) {
                DisplayControlImpl.this.popupDisplayListColorMenu(theColorSwatch);
                theColorSwatch.setBackground(DisplayControlImpl.this.getDisplayListColor());
                theColorSwatch.invalidate();
                if (theColorSwatch.getParent() != null) {
                    theColorSwatch.getParent().validate();
                }
            }
        });
        this.displayListTemplateFld.setToolTipText("Enter your own display list label");
        popupBtn = this.makeMacroPopup(this.displayListTemplateFld, "idv.displaylist.template", "displayListTemplate");
        comps.add(GuiUtils.rLabel("Display Label:"));
        comps.add(GuiUtils.centerRight(this.displayListTemplateFld, colorSwatch));
        comps.add(popupBtn);
        this.idFld = new JTextField(this.id, width);
        comps.add(GuiUtils.rLabel("Id:"));
        comps.add(this.idFld);
        comps.add(new JLabel(" (for scripting)"));
        this.visbilityAnimationPauseFld = new JTextField("" + this.visbilityAnimationPause, 5);
        this.visbilityAnimationPauseFld.setToolTipText("Number of seconds this display should be shown when in visibiltiy animation mode");
        JPanel settingsPanel = this.getSettingsPanel();
        if (settingsPanel != null) {
            comps.add(GuiUtils.filler());
            comps.add(GuiUtils.topLeft(settingsPanel));
            comps.add(GuiUtils.filler());
        }
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        GuiUtils.setHFill();
        JPanel contents = GuiUtils.doLayout(comps, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        jtp.add("Settings", GuiUtils.top(contents));
        if (this.checkFlag(8)) {
            this.csd = new ColorScaleDialog(this, "Color Scale Properties", this.getColorScaleInfo(), false);
            jtp.add("Color Scale", GuiUtils.top(this.csd.getContents()));
        }
        GeoSelection geoSelection = null;
        List selectedTimes = null;
        if (this.dataSelection != null) {
            geoSelection = this.dataSelection.getGeoSelection(true);
            if (this.dataSelection.hasTimes()) {
                selectedTimes = this.dataSelection.getTimes();
            }
        }
        this.dataSelectionWidget = null;
        if (this.myDataChoices.size() == 1 && (allTimes = (dataChoice = (DataChoice)this.myDataChoices.get(0)).getAllDateTimes()) != null && allTimes.size() > 0) {
            this.dataSelectionWidget = new DataSelectionWidget(this.getIdv());
            jtp.add("Times", this.dataSelectionWidget.getTimesList());
            this.dataSelectionWidget.setTimes(allTimes, selectedTimes);
            if (selectedTimes != null) {
                this.dataSelectionWidget.setUseAllTimes(false);
            }
        }
        List dataSources = Misc.makeUnique(this.getDataSources());
        this.geoSelectionPanel = null;
        if (dataSources.size() == 1 && (dataSource = (DataSourceImpl)dataSources.get(0)).canDoGeoSelection()) {
            this.geoSelectionPanel = dataSource.doMakeGeoSelectionPanel(true, geoSelection);
            jtp.add("Spatial Subset", this.geoSelectionPanel);
        }
    }

    public void setDisplayListTimeZone(String timeZoneStr) {
        this.displayListTimeZone = TimeZone.getTimeZone(timeZoneStr);
        this.updateDisplayList();
        this.displayListTimeZone = null;
    }

    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        ColorTable ct;
        dsd.addPropertyValue(this.getDisplayCategory(), "displayCategory", "Display Category", "Labels");
        dsd.addPropertyValue(this.getLegendLabelTemplate(), "legendLabelTemplate", "Legend Label", "Labels");
        dsd.addPropertyValue(this.getExtraLabelTemplate(), "extraLabelTemplate", "Extra Legend Labels", "Labels");
        dsd.addPropertyValue(this.getDisplayListTemplate(), "displayListTemplate", "Display Label", "Labels");
        if (this.displayUnit != null) {
            dsd.addPropertyValue(this.displayUnit, "settingsDisplayUnit", "Display Unit", "Display");
        }
        if ((ct = this.getColorTable()) != null) {
            dsd.addPropertyValue(ct, "colorTable", "Color Table", "Display");
        }
        if (this.colorRange != null) {
            dsd.addPropertyValue(this.colorRange, "range", "Color Range", "Display");
        }
        if (this.selectRangeEnabled && this.selectRange != null) {
            dsd.addPropertyValue(this.selectRange, "selectRange", "Data Range", "Display");
        }
        if (this.contourInfo != null) {
            dsd.addPropertyValue(this.contourInfo, "contourInfo", "Contour Settings", "Display");
        }
        if (this.colorScaleInfo != null) {
            dsd.addPropertyValue(this.colorScaleInfo, "colorScaleInfo", "Color Scale Settings", "Display");
        }
        if (this.checkFlag(1024)) {
            dsd.addPropertyValue(new Integer(this.lineWidth), "lineWidth", "Line Width", "Display");
        }
        if (this.checkFlag(2048)) {
            dsd.addPropertyValue(new Integer(this.skipValue), "skipValue", "Skip Value", "Display");
        }
        if (this.checkFlag(128) && this.useZPosition()) {
            dsd.addPropertyValue(new Double(this.getZPosition()), "zPosition", "Vertical Position", "Display");
        }
        if (this.checkFlag(4) && this.color != null) {
            dsd.addPropertyValue(this.color, "color", this.getColorWidgetLabel(), "Display");
        }
        if (this.checkFlag(4096)) {
            dsd.addPropertyValue(new Integer(this.textureQuality), "textureQuality", this.getTextureQualityLabel(), "Display");
        }
        if (this.checkFlag(8192)) {
            dsd.addPropertyValue(this.getSmoothingType(), "smoothingType", "Smoothing Type", "Display");
            dsd.addPropertyValue(new Integer(this.getSmoothingFactor()), "smoothingFactor", "Smoothing Factor", "Display");
        }
        dsd.addPropertyValue(new Boolean(this.getDisplayVisibility()), "displayVisibility", "Visibility", "Flags");
        dsd.addPropertyValue(new Boolean(this.getLockVisibilityToggle()), "lockVisibilityToggle", "Lock Visibility Toggle", "Flags");
        dsd.addPropertyValue(new Boolean(this.getShowInDisplayList()), "showInDisplayList", "Show In Display List", "Flags");
        dsd.addPropertyValue(new Boolean(this.getUseFastRendering()), "useFastRendering", "Use Fast Rendering", "Flags");
        dsd.addPropertyValue(new Boolean(this.getUseTimesInAnimation()), "useTimesInAnimation", "Use Times In Animation", "Flags");
        dsd.addPropertyValue(new Boolean(this.getDoCursorReadout()), "doCursorReadout", "Include In Cursor Readout", "Flags");
        dsd.addPropertyValue(new Boolean(this.getCanDoRemoveAll()), "canDoRemoveAll", "Remove on Remove All", "Flags");
        dsd.addPropertyValue(new Boolean(this.getShowNoteText()), "showNoteText", "Show Note Text", "Flags");
        if (this.getIdv().getUseTimeDriver()) {
            dsd.addPropertyValue(new Boolean(this.getIsTimeDriver()), "isTimeDriver", "Drive Times with this Display", "Flags");
            dsd.addPropertyValue(new Boolean(this.getUsesTimeDriver()), "usesTimeDriver", "Use Time Driver Times", "Flags");
        }
    }

    public void setLabelAsPreference(Object[] obj) {
        JTextComponent field = (JTextComponent)obj[0];
        String pref = (String)obj[1];
        this.getStore().put(pref, (Object)field.getText().trim());
        this.getStore().save();
    }

    public void showDisplaySettingsDialog() {
        DisplaySettingsDialog displaySettingsDialog = new DisplaySettingsDialog(this);
    }

    protected JPanel getSettingsPanel() {
        ArrayList comps = new ArrayList();
        this.addCheckBoxSettings(comps, this.methodNameToSettingsMap);
        if (comps.size() > 4) {
            return GuiUtils.left(GuiUtils.doLayout(comps, 2, GuiUtils.WT_N, GuiUtils.WT_N));
        }
        return GuiUtils.left(GuiUtils.vbox(comps));
    }

    protected void addCheckBoxSettings(List comps, Hashtable methodNameToSettingsMap) {
        JCheckBox cbx = new JCheckBox("Lock Visibility Toggle", this.getLockVisibilityToggle());
        methodNameToSettingsMap.put("setLockVisibilityToggle", cbx);
        comps.add(cbx);
        if (this.getDisplayInfos().size() > 0) {
            cbx = new JCheckBox("Show In Display List", this.getShowInDisplayList());
            methodNameToSettingsMap.put("setShowInDisplayList", cbx);
            comps.add(cbx);
        }
        if (this.shouldApplyFastRendering()) {
            cbx = new JCheckBox("Use Fast Rendering", this.getUseFastRendering());
            methodNameToSettingsMap.put("setUseFastRendering", cbx);
            comps.add(cbx);
        }
        if (this.haveDataTimes()) {
            cbx = new JCheckBox("Use Times In Animation", this.getUseTimesInAnimation());
            methodNameToSettingsMap.put("setUseTimesInAnimation", cbx);
            comps.add(cbx);
        }
        cbx = new JCheckBox("Remove on Remove All", this.getCanDoRemoveAll());
        methodNameToSettingsMap.put("setCanDoRemoveAll", cbx);
        comps.add(cbx);
        cbx = new JCheckBox("Include in cursor readout", this.getDoCursorReadout());
        methodNameToSettingsMap.put("setDoCursorReadout", cbx);
        comps.add(cbx);
        cbx = new JCheckBox("Show Note Text", this.getShowNoteText());
        methodNameToSettingsMap.put("setShowNoteText", cbx);
        comps.add(cbx);
    }

    public final boolean applyProperties() {
        try {
            List selectedTimes;
            List oldSelectedTimes;
            GeoSelection oldGeoSelection;
            GeoSelection newGeoSelection;
            if (!this.doApplyProperties()) {
                return false;
            }
            boolean needToReloadData = false;
            if (this.geoSelectionPanel != null && !Misc.equals(newGeoSelection = this.geoSelectionPanel.getEnabled() ? this.geoSelectionPanel.getGeoSelection() : null, oldGeoSelection = this.getDataSelection().getGeoSelection(true))) {
                this.getDataSelection().setGeoSelection(newGeoSelection);
                this.setMatchDisplayRegion(newGeoSelection.getUseViewBounds());
                needToReloadData = true;
            }
            if (this.dataSelectionWidget != null && !Misc.equals(oldSelectedTimes = this.getDataSelection().getTimes(), selectedTimes = this.dataSelectionWidget.getSelectedDateTimes())) {
                this.getDataSelection().setTimes(selectedTimes);
                needToReloadData = true;
            }
            if (needToReloadData) {
                this.reloadDataSourceInThread();
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Applying properties", exc);
            return false;
        }
        this.updateLegendAndList();
        this.notifyViewManagersOfChange();
        return true;
    }

    public boolean doApplyProperties() {
        if (this.csd != null && !this.csd.doApply()) {
            return false;
        }
        if (this.idFld == null) {
            return true;
        }
        this.setId(this.idFld.getText());
        this.visbilityAnimationPause = Integer.parseInt(this.visbilityAnimationPauseFld.getText().trim());
        this.setDisplayCategory(this.categoryFld.getText());
        this.setDisplayListTemplate(this.displayListTemplateFld.getText());
        this.setExtraLabelTemplate(this.extraLabelTemplateFld.getText().trim());
        this.setLegendLabelTemplate(this.legendLabelTemplateFld.getText());
        if (this.hasTimeMacro(this.legendLabelTemplate) || this.hasTimeMacro(this.extraLabelTemplate) || this.hasTimeMacro(this.getDisplayListTemplate())) {
            try {
                if (this.internalAnimation == null && this.viewAnimation == null) {
                    this.getSomeAnimation();
                }
                if (this.internalAnimation != null) {
                    this.timeChanged(this.internalAnimation.getAniValue());
                } else if (this.viewAnimation != null) {
                    this.timeChanged(this.viewAnimation.getAniValue());
                }
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Getting animation", exc);
            }
        }
        try {
            Enumeration keys = this.methodNameToSettingsMap.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                JCheckBox cbx = (JCheckBox)this.methodNameToSettingsMap.get(key);
                boolean flag = cbx.isSelected();
                Method theMethod = Misc.findMethod(this.getClass(), key, new Class[]{Boolean.TYPE});
                theMethod.invoke((Object)this, new Boolean(flag));
            }
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error:" + exc);
        }
        return true;
    }

    public void showContourPropertiesDialog() {
        if (this.contourWidget != null) {
            this.contourWidget.showContourPropertiesDialog();
        }
    }

    public void showColorScaleDialog() {
        ColorScaleDialog csd = new ColorScaleDialog(this, "Color Scale Properties", this.getColorScaleInfo(), true);
    }

    protected void getMacroNames(List names, List labels) {
        boolean haveData = this.getShortParamName() != null;
        names.add("%displayname%");
        labels.add("Display Name");
        if (haveData) {
            names.addAll(Misc.newList("%shortname%", "%longname%", "%datasourcename%"));
            labels.addAll(Misc.newList("Field Short Name", "Field Long Name", "Data Source Name"));
        }
        if (this.displayUnit != null) {
            names.add("%displayunit%");
            labels.add("Display Unit");
        }
        if (this.haveDataTimes()) {
            names.add("%timestamp%");
            labels.add("Time Stamp");
            names.add("%fhour%");
            labels.add("Forecast Hour");
            names.add("%fhour2%");
            labels.add("Forecast Hour (value only)");
        }
        if (this.canDoProgressiveResolution()) {
            names.addAll(Misc.newList("%resolution%"));
            labels.addAll(Misc.newList("Resolution"));
        }
    }

    public void doExport(String what, String filename) throws Exception {
    }

    public void saveAsParameterDefaults() {
        this.getIdv().getParamDefaultsEditor().saveDefaults(this);
    }

    public void saveAsFavorite() {
        this.controlContext.getPersistenceManager().saveDisplayControlFavorite(this, this.templateName);
    }

    public void saveAsTemplate() {
        this.controlContext.getPersistenceManager().saveDisplayControl(this);
    }

    public void saveAsPrototype() {
        this.getIdv().getPersistenceManager().writePrototype(this);
    }

    public void clearPrototype() {
        this.getIdv().getPersistenceManager().clearPrototype(this.getClass());
    }

    public void displayableToFront() {
        try {
            List infos = this.getDisplayInfos();
            for (int i = 0; i < infos.size(); ++i) {
                ((DisplayInfo)infos.get(i)).getDisplayable().toFront();
            }
            this.getIdv().toFront(this);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Moving to front", exc);
        }
    }

    protected void getViewMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeCheckboxMenuItem("Visible", this, "displayVisibility", null));
        items.add(GuiUtils.makeCheckboxMenuItem("Lock Visibility", this, "lockVisibilityToggle", null));
        if (this.getDisplayInfos().size() > 0) {
            items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Bring to Front", this, "displayableToFront"), "/auxdata/ui/icons/shape_move_front.png"));
            ViewManager vm = this.getViewManager();
            if (vm != null) {
                items.add(GuiUtils.makeMenuItem("Show View Window", vm, "toFront"));
            }
        }
        if (this.haveDataTimes()) {
            JCheckBoxMenuItem jcmi = GuiUtils.makeCheckboxMenuItem("Use Times In Animation", this, "useTimesInAnimation", null);
            if (this.getIdv().getUseTimeDriver()) {
                JMenu jm = new JMenu("Times");
                jm.add(jcmi);
                jm.add(GuiUtils.makeCheckboxMenuItem("Drive Times with this Display", this, "isTimeDriver", null));
                jm.add(GuiUtils.makeCheckboxMenuItem("Uses Time Driver Times", this, "usesTimeDriver", this.usesTimeDriver, null));
                items.add(jm);
            } else {
                items.add(jcmi);
            }
        }
        if (this.getDisplayInfos().size() > 0) {
            JMenu dlMenu = new JMenu("Display List");
            dlMenu.add(GuiUtils.makeCheckboxMenuItem("Show In Display List", this, "showInDisplayList", null));
            dlMenu.add(GuiUtils.makeMenu("Display List Color", this.makeChangeColorMenuItems("setDisplayListColor", this.displayListColor)));
            items.add(dlMenu);
        }
        if (this.hasMapProjection()) {
            items.add("separator");
            JMenuItem mi = new JMenuItem(this.getDataProjectionLabel());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DisplayControlImpl.this.setProjectionInView(false);
                }
            });
            items.add(mi);
            mi = new JMenuItem("Center on Display");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DisplayControlImpl.this.centerOnDisplay();
                }
            });
            items.add(mi);
            if (this.canDoProgressiveResolution()) {
                items.add(GuiUtils.makeCheckboxMenuItem("Enable Adaptive Resolution", this, "isProgressiveResolution", null));
                items.add(GuiUtils.makeCheckboxMenuItem("Match Display Region", this, "matchDisplayRegion", null));
            }
        }
    }

    protected String getDataProjectionLabel() {
        return "Use Data Projection";
    }

    protected void getFileMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("Remove Display", this, "doRemove"), "/auxdata/ui/icons/delete.png"));
    }

    public void saveDataChoiceInCache() {
        try {
            if (this.dataInstances == null || this.dataInstances.size() != 1) {
                return;
            }
            DataInstance dataInstance = (DataInstance)this.dataInstances.get(0);
            Data data = dataInstance.getData();
            this.getIdv().saveInCache(dataInstance.getDataChoice(), data, this.dataSelection);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Saving data to cache", exc);
        }
    }

    protected void getExtraMenus(List menus, boolean forMenuBar) {
    }

    protected void getHelpMenuItems(List items, boolean forMenuBar) {
        items.add(GuiUtils.makeMenuItem("Details", this, "showDetails"));
        items.add(GuiUtils.setIcon(GuiUtils.makeMenuItem("User's Guide", this, "showHelp"), "/auxdata/ui/icons/help.png"));
    }

    public void showDetails() {
        if (this.detailsFrame == null) {
            Component[] comps = GuiUtils.showHtmlDialog(this.getLegendToolTip(), "Details for " + this.getTitle(), this);
            this.detailsFrame = (Window)comps[0];
            this.detailsEditor = (JEditorPane)comps[1];
        } else {
            this.detailsFrame.setVisible(true);
            this.detailsEditor.setText(this.getLegendToolTip());
        }
    }

    public List getHelpIds() {
        ArrayList<String> helpIds = new ArrayList<String>();
        if (this.helpUrl != null) {
            helpIds.add(this.helpUrl);
        }
        if (this.displayId != null) {
            helpIds.add("idv.controls." + this.displayId);
        }
        Class<?> myClass = this.getClass();
        while (!myClass.equals(DisplayControlImpl.class)) {
            helpIds.add("idv.controls." + Misc.getClassName(myClass).toLowerCase());
            myClass = myClass.getSuperclass();
        }
        return helpIds;
    }

    @Override
    public void showHelp() {
        if (!Help.getDefaultHelp().gotoTarget(this.getHelpIds())) {
            DisplayControlImpl.userMessage("No help available for this display control");
        }
    }

    public boolean isInViewManager() {
        if (this.displays == null) {
            return false;
        }
        return !this.displays.isEmpty();
    }

    @Override
    public void saveImage(String filename) {
        List v = this.getDisplayInfos();
        if (v.size() >= 1) {
            DisplayInfo info = (DisplayInfo)v.get(0);
            info.getViewManager().writeImage(filename);
        }
    }

    @Override
    public void writeTestArchive(String archiveName) {
        try {
            int i;
            archiveName = archiveName + "_" + this.displayId;
            String guiImageFile = archiveName + "_gui.png";
            this.toFront();
            Misc.sleep(200L);
            System.err.println("Writing image:" + guiImageFile);
            ImageUtils.writeImageToFile(this.outerContents, guiImageFile);
            int displayCnt = 1;
            if (this.viewManagers != null) {
                for (i = 0; i < this.viewManagers.size(); ++i) {
                    String displayImageFile = archiveName + "_display_" + displayCnt + ".png";
                    ++displayCnt;
                    System.err.println("Writing image:" + displayImageFile);
                    ViewManager viewManager = (ViewManager)this.viewManagers.get(i);
                    GuiUtils.showComponentInTabs(viewManager.getComponent());
                    viewManager.writeImage(displayImageFile, true);
                }
            }
            if (this.displayMasters != null) {
                this.toFront();
                int n = this.displayMasters.size();
                for (i = 0; i < n; ++i) {
                    String displayImageFile = archiveName + "_display_" + displayCnt + ".png";
                    ++displayCnt;
                    System.err.println("Writing image:" + displayImageFile);
                    ((DisplayMaster)this.displayMasters.get(i)).saveCurrentDisplay(new File(displayImageFile), false, true);
                }
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Writing image", exc);
        }
    }

    @Override
    public void projectionChanged() {
        this.reDisplayColorScales();
        try {
            this.applyZPosition();
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Applying z position", exc);
        }
        if (this.getMatchDisplayRegion()) {
            this.reloadFromBounds = true;
            this.lastBounds = null;
            this.checkBoundsChange();
        }
    }

    @Override
    public void transectChanged() {
    }

    @Override
    public void viewManagerChanged(String property) {
        if (property.equals("MapViewManager.SHARE_PROJECTION")) {
            this.projectionChanged();
        } else if (property.equals("View.PerspectiveView") || property.equals("View.ComponentResized")) {
            this.reDisplayColorScales();
        }
        if (property.equals("NavigatedViewManager.SHARE_RUBBERBAND")) {
            this.reloadFromBounds = true;
        }
    }

    private void reDisplayColorScales() {
        if (this.colorScales != null && !this.colorScales.isEmpty()) {
            for (int i = 0; i < this.colorScales.size(); ++i) {
                ((ColorScale)this.colorScales.get(i)).reDisplay();
            }
        }
    }

    public MapProjection getDataProjectionForMenu() {
        return this.getDataProjection();
    }

    @Override
    public MapProjection getDataProjection() {
        MapProjection mp = null;
        List v = this.getDisplayInfos();
        try {
            int n = v.size();
            for (int i = 0; i < n; ++i) {
                DisplayInfo info = (DisplayInfo)v.get(i);
                Data data = info.getDisplayable().getData();
                if (data == null || !(data instanceof FieldImpl)) continue;
                try {
                    mp = GridUtil.getNavigation((FieldImpl)data);
                }
                catch (Exception e) {
                    mp = null;
                }
                if (mp == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DisplayControlImpl.logException("Getting projection from data", e);
        }
        return mp;
    }

    public visad.georef.LatLonPoint getDisplayCenter() throws RemoteException, VisADException {
        MapProjection mapProjection = this.getDataProjection();
        if (mapProjection != null) {
            return mapProjection.getCenterLatLon();
        }
        return null;
    }

    protected void setProjectionInView(boolean useViewPreference) {
        this.setProjectionInView(useViewPreference, false);
    }

    protected void setProjectionInView(boolean useViewPreference, boolean maintainViewpoint) {
        MapProjection mp;
        MapViewManager mvm = this.getMapViewManager();
        ViewManager vm = this.getDefaultViewManager();
        if (mvm == null) {
            return;
        }
        MapProjection mapProjection = mp = useViewPreference ? this.getDataProjection() : this.getDataProjectionForMenu();
        if (mp == null) {
            return;
        }
        mvm.setMapProjection(mp, true, this.getDisplayConventions().getMapProjectionLabel(mp, this), useViewPreference, true, maintainViewpoint);
    }

    protected void setProjectionInView(MapViewManager mvm, boolean useViewPreference, boolean maintainViewpoint) {
        MapProjection mp;
        if (mvm == null) {
            return;
        }
        MapProjection mapProjection = mp = useViewPreference ? this.getDataProjection() : this.getDataProjectionForMenu();
        if (mp == null) {
            return;
        }
        mvm.setMapProjection(mp, true, this.getDisplayConventions().getMapProjectionLabel(mp, this), useViewPreference, true, maintainViewpoint);
    }

    protected void centerOnDisplay() {
        MapViewManager mvm = this.getMapViewManager();
        if (mvm == null) {
            return;
        }
        MapProjection mp = this.getDataProjection();
        if (mp == null) {
            return;
        }
        try {
            mvm.center(mp);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Centering display", exc);
        }
    }

    public MapProjection getMapViewProjection() {
        MapViewManager mvm = this.getMapViewManager();
        if (mvm == null) {
            return null;
        }
        return mvm.getMainProjection();
    }

    private boolean insertDisplayables() {
        try {
            DisplayInfo info;
            List displayInfos = this.getDisplayInfos();
            boolean addOk = true;
            Hashtable<ViewManager, ArrayList<DisplayInfo>> vmMap = new Hashtable<ViewManager, ArrayList<DisplayInfo>>();
            ArrayList<ViewManager> vms = new ArrayList<ViewManager>();
            for (Object displayInfo : displayInfos) {
                info = (DisplayInfo)displayInfo;
                ViewManager vm = info.getViewManager();
                if (vm == null) continue;
                ArrayList<DisplayInfo> infos = (ArrayList<DisplayInfo>)vmMap.get(vm);
                if (infos == null) {
                    infos = new ArrayList<DisplayInfo>();
                    vmMap.put(vm, infos);
                    vms.add(vm);
                }
                infos.add(info);
            }
            for (ViewManager vm : vms) {
                List infos = (List)vmMap.get(vm);
                vm.addDisplayInfos(infos);
            }
            for (Object displayInfo : displayInfos) {
                info = (DisplayInfo)displayInfo;
                if (info.getDisplayableAdded()) continue;
                this.removeDisplayInfo(info);
                addOk = false;
            }
            if (!addOk) {
                this.doRemove();
                return false;
            }
            this.activateDisplay(displayInfos);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Inserting displayables", exc);
        }
        return true;
    }

    private void activateDisplay(List displayList) throws RemoteException, VisADException {
        for (Object aDisplayList : displayList) {
            DisplayInfo info = (DisplayInfo)aDisplayList;
            info.activateDisplay();
        }
    }

    protected void activateDisplays() throws RemoteException, VisADException {
        this.activateDisplay(this.getDisplayInfos());
    }

    protected void deactivateDisplays() throws RemoteException, VisADException {
        List displayList = this.getDisplayInfos();
        for (Object aDisplayList : displayList) {
            DisplayInfo info = (DisplayInfo)aDisplayList;
            info.deactivateDisplay();
        }
    }

    protected DisplayInfo findDisplayInfo(Displayable displayable) {
        List displayList = this.getDisplayInfos();
        if (displayList == null) {
            return null;
        }
        for (Object aDisplayList : displayList) {
            DisplayInfo info = (DisplayInfo)aDisplayList;
            if (info.getDisplayable() != displayable) continue;
            return info;
        }
        return null;
    }

    public void removeDisplayable(Displayable displayable) throws RemoteException, VisADException {
        DisplayInfo info = this.findDisplayInfo(displayable);
        if (info != null) {
            this.removeDisplayInfo(info);
        }
    }

    protected void removeDisplayables() throws RemoteException, VisADException {
        this.removeDisplayables(false);
    }

    protected void removeDisplayables(boolean andDestroyThem) throws RemoteException, VisADException {
        List displayList = this.getDisplayInfos();
        this.displays = new ArrayList();
        for (Object aDisplayList : displayList) {
            DisplayInfo info = (DisplayInfo)aDisplayList;
            Displayable displayable = info.getDisplayable();
            if (displayable != null) {
                displayable.removePropertyChangeListener(this);
            }
            info.removeDisplayable();
            if (displayable == null || !andDestroyThem) continue;
            displayable.destroyDisplayable();
        }
    }

    private void removeDisplayInfo(DisplayInfo info) throws RemoteException, VisADException {
        this.displays.remove(info);
        if (info.getDisplayable() != null) {
            info.getDisplayable().removePropertyChangeListener(this);
        }
        info.removeDisplayable();
    }

    @Override
    public void viewManagerDestroyed(ViewManager viewManager) throws VisADException, RemoteException {
        this.doRemove();
    }

    public void addRemovable(Removable removable) {
        this.removables.add(removable);
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        if (this.hasBeenRemoved) {
            return;
        }
        this.hasBeenRemoved = true;
        if (this.componentHolder != null) {
            this.componentHolder.removeDisplayControl(this);
            this.componentHolder = null;
        }
        if (this.detailsFrame != null) {
            this.detailsFrame.dispose();
            this.detailsFrame = null;
        }
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "prop.removed", this, null));
        this.propertyChangeListeners = null;
        if (this.displayControlListeningTo != null) {
            this.displayControlListeningTo.removeDisplayListener(this);
            this.displayControlListeningTo = null;
        }
        if (this.projectionControlListeningTo != null) {
            this.projectionControlListeningTo.removeControlListener(this);
            this.projectionControlListeningTo = null;
        }
        if (this.myWindow != null && this.windowListener != null) {
            this.myWindow.removeWindowListener(this.windowListener);
        }
        if (this.viewAnimation != null) {
            this.viewAnimation.removePropertyChangeListener(this);
            this.viewAnimation = null;
        }
        if (this.internalAnimation != null) {
            this.internalAnimation.removePropertyChangeListener(this);
            this.internalAnimation = null;
        }
        this.displayUnit = null;
        this.colorUnit = null;
        this.getControlContext().removeDisplayControl(this);
        this.removeDisplayables(true);
        this.disposeOfWindow();
        this.removeSharable();
        if (this.animationWidget != null) {
            this.animationWidget.destroy();
            this.animationWidget = null;
        }
        if (this.sharables != null) {
            for (Object sharable : this.sharables) {
                ((SharableImpl)sharable).removeSharable();
            }
            this.sharables = null;
        }
        for (Removable removable : this.removables) {
            removable.doRemove();
        }
        this.removables = null;
        if (this.displayMasters != null) {
            for (Object displayMaster : this.displayMasters) {
                ((DisplayMaster)displayMaster).destroy();
            }
            this.displayMasters = null;
        }
        this.clearViewManagers();
        this.defaultViewManager = null;
        this.removeListenerFromDataChoices();
        if (this.contents != null) {
            this.contents = null;
        }
        if (this.outerContents != null) {
            this.outerContents = null;
        }
        this.bottomLegendComponent = null;
        this.mainPanel = null;
        this.myDataChoices = null;
        this.dataInstances = null;
        this.initDataChoices = null;
        this.dataSelection = null;
        this.displays = null;
        this.displayListTable.clear();
        this.displayListTable = null;
        this.ctw = null;
        this.selectRangeWidget = null;
        this.contourWidget = null;
        this.lww = null;
        this.sww = null;
    }

    private void addListenerToDataChoices(List choices) {
        if (choices == null) {
            return;
        }
        ArrayList tmpChoices = new ArrayList(choices);
        for (Object tmpChoice : tmpChoices) {
            ((DataChoice)tmpChoice).addDataChangeListener(this);
        }
    }

    private void removeListenerFromDataChoices() {
        if (this.myDataChoices == null) {
            return;
        }
        ArrayList tmpDataChoices = new ArrayList(this.myDataChoices);
        for (Object tmpDataChoice : tmpDataChoices) {
            ((DataChoice)tmpDataChoice).removeDataChangeListener(this);
        }
    }

    @Override
    public boolean getActive() {
        return !this.hasBeenRemoved;
    }

    protected Container doMakeContents() throws VisADException, RemoteException {
        return GuiUtils.wrap(this.doMakeWidgetComponent());
    }

    protected void setContents(Container c) {
        this.contents = c;
    }

    protected Container getContents() {
        return this.contents;
    }

    public void resetViewManager(String oldViewId, String newViewId) {
        if (Misc.equals(oldViewId, this.defaultView)) {
            this.defaultView = newViewId;
        }
    }

    public void setDefaultView(String s) {
        this.defaultView = s;
    }

    @Override
    public final List getCursorReadout(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        if (!this.getDoCursorReadout()) {
            return null;
        }
        try {
            List l = this.getCursorReadoutInner(el, animationValue, animationStep, samples);
            return l;
        }
        catch (Exception exc) {
            LogUtil.consoleMessage("Error getting cursor readout");
            LogUtil.consoleMessage(LogUtil.getStackTrace(exc));
            this.setDoCursorReadout(false);
            return null;
        }
    }

    protected List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        return null;
    }

    protected final List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep) {
        return null;
    }

    protected String formatForCursorReadout(Real r) throws VisADException, RemoteException {
        String result;
        Unit displayUnit = this.getDisplayUnit();
        if (r.isMissing()) {
            result = "missing";
        } else {
            Unit unit;
            double value;
            if (displayUnit != null) {
                value = r.getValue(displayUnit);
                unit = displayUnit;
            } else {
                value = r.getValue();
                unit = r.getUnit();
            }
            result = Misc.format(value);
            result = result + "[" + unit + "]";
            int length = result.length();
            result = StringUtil.padLeft(result, 8 * (20 - length), "&nbsp;");
        }
        return result;
    }

    public void setInitialViewManager(ViewManager viewManager) {
        this.defaultViewManager = viewManager;
    }

    public String getDefaultView() {
        ViewManager vm = this.getDefaultViewManager();
        if (!(this.controlContext.getPersistenceManager().getSaveViewState() || this.controlContext.getPersistenceManager().getSaveDataSources() || this.controlContext.getPersistenceManager().getSaveData() || this.controlContext.getPersistenceManager().getSaveJython())) {
            return null;
        }
        if (vm != null && vm.getViewDescriptor() != null) {
            return vm.getViewDescriptor().getName();
        }
        return null;
    }

    @Override
    public ViewManager getDefaultViewManager() {
        if (this.displays == null) {
            return null;
        }
        int n = this.displays.size();
        for (int i = 0; i < n; ++i) {
            DisplayInfo info = (DisplayInfo)this.displays.get(i);
            ViewManager vm = info.getViewManager();
            if (this.viewManagers != null && this.viewManagers.contains(vm)) continue;
            return vm;
        }
        return null;
    }

    public ViewDescriptor getDefaultViewDescriptor() {
        ViewDescriptor vd = this.defaultView == null ? new ViewDescriptor(ViewDescriptor.LASTACTIVE) : new ViewDescriptor(this.defaultView);
        if (this.viewManagerClassNames != null) {
            vd.setClassNames(StringUtil.split(this.viewManagerClassNames, ",", true, true));
        }
        return vd;
    }

    public ViewManager addDisplayable(Displayable d) {
        return this.addDisplayable(d, this.getDefaultViewDescriptor());
    }

    public ViewManager addDisplayable(Displayable theDisplay, int attributeFlag) {
        ViewManager vm = this.addDisplayable(theDisplay, this.getDefaultViewDescriptor());
        this.addAttributedDisplayable(theDisplay, attributeFlag);
        return vm;
    }

    public ViewManager addDisplayable(Displayable theDisplay, ViewManager viewManager, int flag) {
        this.addDisplayable(theDisplay, viewManager);
        this.addAttributedDisplayable(theDisplay, flag);
        return viewManager;
    }

    public ViewManager addDisplayable(Displayable theDisplay, ViewDescriptor viewDescriptor, int flag) {
        ViewManager vm = this.addDisplayable(theDisplay, viewDescriptor);
        this.addAttributedDisplayable(theDisplay, flag);
        return vm;
    }

    public ViewManager addDisplayable(Displayable theDisplay, ViewDescriptor viewDescriptor) {
        ViewManager viewManager = this.getViewManager(viewDescriptor);
        this.addDisplayable(theDisplay, viewManager);
        return viewManager;
    }

    public DisplayInfo addDisplayable(Displayable theDisplay, ViewManager viewManager) {
        if (!this.haveInitialized || this.defaultView == null) {
            // empty if block
        }
        try {
            theDisplay.setUseFastRendering(this.shouldApplyFastRendering() && viewManager.getUseFastRendering(this.useFastRendering));
            theDisplay.setUseTimesInAnimation(this.useTimesInAnimation);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting fast rendering:" + this.useFastRendering, exc);
        }
        DisplayInfo info = new DisplayInfo(this, viewManager, theDisplay);
        this.displays.add(info);
        if (this.haveInitialized) {
            try {
                info.addDisplayable();
                if (!info.getDisplayableAdded()) {
                    this.removeDisplayInfo(info);
                } else {
                    info.activateDisplay();
                }
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Adding displayables", exc);
            }
        }
        return info;
    }

    public List getDisplayInfos() {
        if (this.displays == null) {
            return new ArrayList();
        }
        return new ArrayList(this.displays);
    }

    protected JComponent doMakeWidgetComponent() {
        try {
            ArrayList<ControlWidget> controlWidgets = new ArrayList<ControlWidget>();
            this.getControlWidgets(controlWidgets);
            List widgetComponents = ControlWidget.fillList(controlWidgets);
            GuiUtils.tmpInsets = new Insets(4, 8, 4, 8);
            GuiUtils.tmpFill = 2;
            JPanel p = GuiUtils.doLayout(widgetComponents, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
            return p;
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Making the widget component", exc);
            return new JLabel("Error");
        }
    }

    public void zSliderChanged(double value) {
        try {
            this.setZPosition(value);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting z position", exc);
        }
    }

    protected JSlider doMakeTextureSlider() {
        if (this.textureSlider == null) {
            this.textureSlider = GuiUtils.makeSlider(1, 21, this.textureQuality, this, "setTextureQuality");
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            labels.put(new Integer(1), GuiUtils.lLabel("High"));
            labels.put(new Integer(10), GuiUtils.cLabel("Medium"));
            labels.put(new Integer(21), GuiUtils.rLabel("Low"));
            this.textureSlider.setLabelTable(labels);
            this.textureSlider.setPaintLabels(true);
        }
        return this.textureSlider;
    }

    protected JComponent doMakeZPositionSlider() {
        int sliderPos = (int)(this.getZPosition() * 100.0);
        this.zPositionSlider = new ZSlider(this.getZPosition()){

            @Override
            public void valueHasBeenSet() {
                DisplayControlImpl.this.zSliderChanged(this.getValue());
            }
        };
        return this.zPositionSlider.getContents();
    }

    protected String getZPositionSliderLabel() {
        return "Vertical Position:";
    }

    public void getControlWidgets(List<ControlWidget> controlWidgets) throws VisADException, RemoteException {
        if (this.checkFlag(2)) {
            this.contourWidget = new ContourWidget(this, this.getContourInfo());
            controlWidgets.add(this.contourWidget);
            this.addRemovable(this.contourWidget);
        }
        if (this.checkFlag(8)) {
            controlWidgets.add(this.getColorTableWidget(this.getRangeForColorTable()));
        }
        if (this.checkFlag(128) && this.useZPosition()) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getZPositionSliderLabel()), this.doMakeZPositionSlider()));
        }
        if (this.checkFlag(4) && this.showColorControlWidget()) {
            if (this.color == null) {
                this.getDisplayConventions();
                this.color = DisplayConventions.getColor();
            }
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getColorWidgetLabel() + ":"), GuiUtils.left(this.doMakeColorControl(this.color))));
        }
        if (this.checkFlag(256)) {
            controlWidgets.add(this.getSelectRangeWidget(this.getSelectRange()));
        }
        if (this.checkFlag(512)) {
            this.addTimeModeWidget(controlWidgets);
        }
        if (this.checkFlag(1024)) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getLineWidthWidgetLabel() + ":"), this.getLineWidthWidget().getContents(false)));
        }
        if (this.checkFlag(2048)) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getSkipWidgetLabel() + ":"), this.doMakeSkipFactorSlider()));
        }
        if (this.checkFlag(4096)) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel(this.getTextureQualityLabel() + ":"), this.doMakeTextureSlider()));
        }
        if (this.checkFlag(8192)) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Smoothing:"), this.doMakeSmoothingWidget()));
        }
    }

    protected void addTimeModeWidget(List controlWidgets) {
        JPanel timeModePanel = GuiUtils.leftCenter(GuiUtils.wrap(GuiUtils.makeImageButton("/auxdata/ui/icons/calendar_edit.png", this, "showTimeRangeDialog")), GuiUtils.inset((Component)this.getDataTimeRange(true).getTimeModeLabel(), new Insets(0, 10, 0, 0)));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Time Mode:"), timeModePanel));
    }

    public String getColorWidgetLabel() {
        return "Selector Color";
    }

    public String getLineWidthWidgetLabel() {
        return "Line Width";
    }

    public String getSkipWidgetLabel() {
        return "Skip";
    }

    protected boolean isDisplayUnitAlsoColorUnit() {
        return true;
    }

    protected boolean setNewDisplayUnit(Unit newUnit, boolean applyToDisplayable) {
        if (newUnit == null) {
            return true;
        }
        if (!this.getHaveInitialized()) {
            this.setDisplayUnit(newUnit);
            return true;
        }
        Unit oldUnit = this.getDisplayUnit();
        try {
            if (this.isDisplayUnitAlsoColorUnit() && !this.setNewColorUnit(newUnit, false)) {
                return false;
            }
            this.setDisplayUnit(newUnit);
            ContourInfo contourInfo = this.getContourInfo();
            if (contourInfo != null && oldUnit != null) {
                ContourInfo newContourInfo = new ContourInfo(contourInfo);
                double oldRange = newContourInfo.getMax() - newContourInfo.getMin();
                int howMany = (double)newContourInfo.getInterval() != 0.0 ? (int)(oldRange / (double)newContourInfo.getInterval()) : 0;
                newContourInfo.setBase((float)newUnit.toThis(newContourInfo.getBase(), oldUnit));
                newContourInfo.setMin((float)newUnit.toThis(newContourInfo.getMin(), oldUnit));
                newContourInfo.setMax((float)newUnit.toThis(newContourInfo.getMax(), oldUnit));
                double newRange = newContourInfo.getMax() - newContourInfo.getMin();
                if (howMany > 0) {
                    newContourInfo.setInterval((float)(newRange / (double)howMany));
                } else {
                    newContourInfo.setInterval((float)newUnit.toThis(newContourInfo.getInterval(), oldUnit));
                }
                this.setContourInfo(newContourInfo);
            }
            if (applyToDisplayable) {
                this.applyDisplayUnit();
            }
            this.updateListOrLegendWithMacro("%displayunit%");
            this.displayUnitChanged(oldUnit, newUnit);
            if (!this.applyProperties()) {
                return false;
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.userMessage("Error setting unit from: " + oldUnit + " to: " + newUnit + "\n" + exc);
            this.setDisplayUnit(oldUnit);
            return false;
        }
        return true;
    }

    private void updateListOrLegendWithMacro(String macro) {
        boolean legendUpdate;
        boolean listUpdate = this.getDisplayListTemplate().indexOf(macro) >= 0;
        boolean bl = legendUpdate = this.getLegendLabelTemplate().indexOf(macro) >= 0 || this.getExtraLabelTemplate().indexOf(macro) >= 0;
        if (legendUpdate && listUpdate) {
            this.updateLegendAndList();
        } else if (listUpdate) {
            this.updateDisplayList();
        } else if (legendUpdate) {
            this.updateLegendLabel();
        }
    }

    protected boolean setNewColorUnit(Unit newUnit, boolean applyToDisplayable) {
        if (newUnit == null) {
            return true;
        }
        if (!this.getHaveInitialized()) {
            this.setUnitForColor(newUnit);
            return true;
        }
        Unit oldUnit = this.getUnitForColor();
        try {
            Range newRange;
            this.setUnitForColor(newUnit);
            Range currentRange = this.getRange();
            if (currentRange != null && (newRange = oldUnit != null ? new Range(newUnit.toThis(currentRange.getMin(), oldUnit), newUnit.toThis(currentRange.getMax(), oldUnit)) : this.getInitialRange()) != null) {
                this.setRange(newRange);
            }
            if (applyToDisplayable) {
                this.applyColorUnit();
            }
            this.colorUnitChanged(oldUnit, newUnit);
        }
        catch (Exception exc) {
            this.setUnitForColor(oldUnit);
            DisplayControlImpl.userMessage("Error setting unit: " + exc);
            return false;
        }
        return true;
    }

    protected Unit getDisplayUnit(Unit rawUnit) {
        if (this.displayUnit == null) {
            this.displayUnit = this.getDisplayConventions().getDisplayUnit(this.paramName, rawUnit);
        }
        return this.displayUnit;
    }

    public Unit getDisplayUnit() {
        return this.displayUnit;
    }

    public void setSettingsDisplayUnit(Unit newUnit) {
        this.setNewDisplayUnit(newUnit, true);
    }

    protected void setDisplayUnit(Unit newUnit) {
        this.displayUnit = newUnit;
    }

    public String getDisplayUnitName() {
        return this.displayUnit == null ? null : this.displayUnit.toString();
    }

    public void setDisplayUnitName(String name) {
        if (name == null) {
            this.displayUnit = null;
        } else {
            try {
                this.displayUnit = Util.parseUnit(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Unit getDefaultDistanceUnit() {
        return this.controlContext.getPreferenceManager().getDefaultDistanceUnit();
    }

    protected void setUnitForColor(Unit newUnit) {
        if (this.isDisplayUnitAlsoColorUnit()) {
            this.displayUnit = newUnit;
            this.colorUnit = newUnit;
        } else {
            this.colorUnit = newUnit;
        }
    }

    protected Unit getUnitForColor() {
        if (this.colorUnit == null && this.isDisplayUnitAlsoColorUnit()) {
            return this.displayUnit;
        }
        return this.colorUnit;
    }

    protected Unit getColorUnit() {
        return this.colorUnit;
    }

    protected void setColorUnit(Unit unit) {
        this.colorUnit = unit;
    }

    public String getColorUnitName() {
        return this.colorUnit == null ? null : this.colorUnit.toString();
    }

    public void setColorUnitName(String name) {
        if (name == null) {
            this.colorUnit = null;
        } else {
            try {
                this.colorUnit = Util.parseUnit(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showTimeRangeDialog() {
        if (!this.getDataTimeRange(true).showDialog()) {
            return;
        }
        Misc.run(this, "applyTimeRange");
    }

    public void applyTimeRange() {
    }

    protected void popupDataDialog(String dialogMessage, Component from) {
        this.popupDataDialog(dialogMessage, from, false);
    }

    protected void popupDataDialog(String dialogMessage, Component from, boolean multiples) {
        this.popupDataDialog(dialogMessage, from, multiples, this.categories);
    }

    protected void popupDataDialog(String dialogMessage, Component from, boolean multiples, List categories) {
        List<DataChoice> choices = this.selectDataChoices(dialogMessage, from, multiples, categories);
        if (choices == null || choices.size() == 0) {
            return;
        }
        final List clonedList = DataChoice.cloneDataChoices((List)((Object)choices.get(0)));
        this.dataSelection = ((DataChoice)clonedList.get(0)).getDataSelection();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                try {
                    DisplayControlImpl.this.addNewData(clonedList);
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Selecting new data", exc);
                }
            }
        });
    }

    protected List<DataChoice> selectDataChoices(String dialogMessage, Component from, boolean multiples, List categories) {
        if (categories == null) {
            categories = this.getCategories();
        }
        DataOperand dataOperand = new DataOperand(dialogMessage, dialogMessage, categories, multiples);
        DataTreeDialog dataDialog = new DataTreeDialog(this.getIdv(), from, Misc.newList(dataOperand), this.getControlContext().getAllDataSources(), this.myDataChoices);
        return dataDialog.getSelected();
    }

    public DataSelection getDataSelection() {
        if (this.dataSelection == null) {
            this.dataSelection = new DataSelection();
        }
        return this.dataSelection;
    }

    public void setDataSelection(DataSelection newDataSelection) {
        this.dataSelection = newDataSelection;
    }

    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        return new DataInstance(dataChoice, this.getDataSelection(), this.getRequestProperties());
    }

    protected Hashtable getRequestProperties() {
        if (this.requestProperties == null) {
            this.requestProperties = Misc.newHashtable("prop.requester", this);
        }
        return this.requestProperties;
    }

    protected void processRequestProperties() {
        if (this.requestProperties == null) {
            return;
        }
        this.timeLabels = (Hashtable)this.requestProperties.get("prop.timelabels");
        if (this.timeLabels == null) {
            return;
        }
        if (this.listeningForTimes) {
            return;
        }
    }

    private boolean checkTimestampLabel(Real time) {
        boolean hasTimestamp = this.shouldAddAnimationListener();
        if (!hasTimestamp) {
            return false;
        }
        if (time == null) {
            try {
                Animation animation = this.getSomeAnimation();
                if (animation != null) {
                    time = animation.getAniValue();
                }
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Getting animation", exc);
                return false;
            }
        }
        if (time == null) {
            return false;
        }
        try {
            Set timeSet = this.getDataTimeSet();
            if (timeSet == null) {
                this.currentTime = null;
                this.firstTime = null;
            } else {
                this.currentTime = new DateTime(time);
                Unit setUnit = timeSet.getSetUnits()[0];
                if (Unit.canConvert(time.getUnit(), setUnit)) {
                    double timeVal;
                    int index;
                    Data firstSetTime;
                    if (timeSet.getLength() > 0 && (firstSetTime = timeSet.__getitem__(0)) instanceof Real) {
                        double firstTimeValue = ((Real)firstSetTime).getValue(this.currentTime.getUnit());
                        this.firstTime = new DateTime(time.cloneButValue(firstTimeValue));
                    }
                    if ((index = timeSet.doubleToIndex(new double[][]{{timeVal = time.getValue(setUnit)}})[0]) >= 0) {
                        DateTime dataTime;
                        RealTuple rt = DataUtility.getSample(timeSet, index);
                        this.currentTime = dataTime = new DateTime((Real)rt.getComponent(0));
                    }
                }
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting time string", exc);
        }
        return true;
    }

    protected void timeChanged(Real time) {
        if (!this.getHaveInitialized() || !this.getActive()) {
            return;
        }
        if (this.checkTimestampLabel(time)) {
            this.updateLegendLabel();
        }
        if (this.timeLabels == null) {
            return;
        }
    }

    @Override
    public JComponent getLegendLabel(int legendType) {
        switch (legendType) {
            case 1: {
                if (this.sideLegendLabel == null) {
                    this.getSideLegendComponent();
                }
                return this.sideLegendLabel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JComponent getLegendComponent(int legendType) {
        Object object = this.LEGEND_MUTEX;
        synchronized (object) {
            switch (legendType) {
                case 1: {
                    if (this.sideLegendComponent == null) {
                        this.sideLegendComponent = this.doMakeSideLegendComponent();
                    }
                    return this.sideLegendComponent;
                }
                case 0: {
                    if (this.bottomLegendComponent == null) {
                        this.bottomLegendComponent = this.doMakeBottomLegendComponent();
                        this.applyLegendForeground();
                    }
                    return this.bottomLegendComponent;
                }
            }
            return null;
        }
    }

    private JComponent getBottomLegendComponent() {
        return this.getLegendComponent(0);
    }

    private JComponent getSideLegendComponent() {
        return this.getLegendComponent(1);
    }

    protected JComponent doMakeSideLegendComponent() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        List labels = this.getLegendLabels(1);
        this.legendTextArea = new JTextArea("");
        GuiUtils.applyDefaultFont(this.legendTextArea);
        this.legendTextArea.setEditable(false);
        this.sideLegendLabel = new SideLegendLabel(this, " ");
        this.labelsToUpdate.add(this.sideLegendLabel);
        comps.add(this.sideLegendLabel);
        comps.add(this.legendTextArea);
        for (int lblIdx = 0; lblIdx < comps.size(); ++lblIdx) {
            JComponent comp = (JComponent)comps.get(lblIdx);
            if (lblIdx == 0) {
                comp.setToolTipText("<html>Click to show the control window.<br>Control-Click to center display.<br>Right click to show menu.<br>Click and drag to move display.</html>");
            } else {
                comp.setToolTipText("<html>Right click to show menu.</html>");
            }
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    if (SwingUtilities.isRightMouseButton(event)) {
                        DisplayControlImpl.this.showLegendMenu((JComponent)event.getSource(), event);
                    }
                }
            });
        }
        this.legendTextPanel = new JPanel(new BorderLayout());
        this.legendTextArea.setBackground(this.legendTextPanel.getBackground());
        this.legendTextPanel.add(this.legendTextArea);
        this.updateLegendLabel();
        JPanel legendPanel = this.legendTextPanel;
        JComponent extraLegend = this.getExtraLegendComponent(1);
        String iconPath = null;
        if (this.getDataChoice() != null) {
            iconPath = this.getDataChoice().getProperty("Prop.LegendIcon", null);
        }
        JPanel iconLbl = null;
        if (iconPath != null) {
            iconLbl = GuiUtils.inset((Component)GuiUtils.left(GuiUtils.getImageLabel(iconPath, this.getClass())), 2);
        }
        JPanel colorSwatch = null;
        if (this.showColorControlWidget() && this.checkFlag(4)) {
            colorSwatch = GuiUtils.wrap(new JLabel("     "));
            this.colorSwatches.add(colorSwatch);
            colorSwatch.setBackground(this.color);
            final JPanel theColorSwatch = colorSwatch;
            colorSwatch.setToolTipText("Click to change color");
            colorSwatch.addMouseListener(new ObjectListener(null){

                @Override
                public void mouseClicked(MouseEvent me) {
                    DisplayControlImpl.this.popupColorMenu(theColorSwatch);
                }
            });
            final JLabel colorSwatchLabel = new JLabel(this.getColorWidgetLabel() + ": ");
            colorSwatchLabel.setToolTipText("Click to change color");
            colorSwatchLabel.addMouseListener(new ObjectListener(null){

                @Override
                public void mouseClicked(MouseEvent me) {
                    DisplayControlImpl.this.popupColorMenu(colorSwatchLabel);
                }
            });
            colorSwatch = GuiUtils.left(GuiUtils.hbox(colorSwatchLabel, colorSwatch));
        }
        if (iconLbl != null || extraLegend != null || colorSwatch != null) {
            extraLegend = iconLbl != null ? GuiUtils.vbox((Component)iconLbl, colorSwatch) : GuiUtils.vbox(extraLegend, colorSwatch);
            legendPanel = GuiUtils.vbox((Component)legendPanel, GuiUtils.inset((Component)extraLegend, new Insets(1, 0, 0, 0)));
            legendPanel.setBackground(Color.blue);
        }
        if (GuiUtils.getDefaultFont() == null) {
            GuiUtils.setFontOnTree(legendPanel, GuiUtils.buttonFont.deriveFont(10.0f));
        } else {
            GuiUtils.setFontOnTree(legendPanel, GuiUtils.getDefaultFont());
        }
        return legendPanel;
    }

    @Override
    public JLabel makeLegendLabel() {
        SideLegendLabel comp = new SideLegendLabel(this, this.getMenuLabel());
        this.labelsToUpdate.add(comp);
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    DisplayControlImpl.this.showLegendMenu((JComponent)event.getSource(), event);
                }
            }
        });
        return comp;
    }

    private void popupColorMenu(JComponent comp) {
        JPopupMenu popup = GuiUtils.makePopupMenu(this.makeChangeColorMenuItems());
        popup.show(comp, 0, comp.getHeight());
    }

    private void popupDisplayListColorMenu(JComponent comp) {
        JPopupMenu popup = GuiUtils.makePopupMenu(this.makeChangeColorMenuItems("setDisplayListColor", this.getDisplayListColor()));
        popup.show(comp, 0, comp.getHeight());
    }

    protected List makeChangeColorMenuItems() {
        return this.makeChangeColorMenuItems("setColor", this.color);
    }

    private List makeChangeColorMenuItems(final String methodName, final Color color) {
        ArrayList<Object> items = new ArrayList<Object>();
        Vector colors = this.getDisplayConventions().getColorNameList();
        for (Object aColor : colors) {
            String colorName = aColor.toString();
            final Color menuColor = this.getDisplayConventions().getColor(colorName);
            JMenuItem mi = new JMenuItem(colorName.substring(0, 1).toUpperCase() + colorName.substring(1) + "  "){

                @Override
                public void paint(Graphics g) {
                    super.paint(g);
                    Rectangle b = this.getBounds();
                    if (Misc.equals(menuColor, color)) {
                        g.setColor(Color.white);
                        g.fillRect(b.width - b.height, 0, b.height, b.height);
                        g.setColor(Color.black);
                        g.drawRect(b.width - b.height, 0, b.height - 1, b.height - 1);
                    }
                    g.setColor(menuColor);
                    int w = b.height;
                    g.fillRect(b.width - w + 3, 3, w - 6, w - 6);
                }
            };
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    try {
                        Method theMethod = Misc.findMethod(DisplayControlImpl.this.getClass(), methodName, new Class[]{menuColor.getClass()});
                        if (theMethod == null) {
                            throw new NoSuchMethodException("unknown method " + methodName);
                        }
                        theMethod.invoke((Object)DisplayControlImpl.this, menuColor);
                    }
                    catch (Exception exc) {
                        DisplayControlBase.logException("Setting color", exc);
                    }
                }
            });
            items.add(mi);
        }
        items.add("separator");
        items.add(GuiUtils.makeMenuItem("Custom Color", this, "showColorDialog", methodName));
        return items;
    }

    protected void showLegendMenu(JComponent comp, MouseEvent event) {
        List items = this.getControlMenus(comp);
        JPopupMenu menu = GuiUtils.makePopupMenu(items);
        menu.show(comp, event.getX(), event.getY());
    }

    @Override
    public List getControlMenus(JComponent comp) {
        ArrayList<Object> fileItems = new ArrayList<Object>();
        ArrayList viewItems = new ArrayList();
        ArrayList helpItems = new ArrayList();
        ArrayList editItems = new ArrayList();
        ArrayList extraMenus = new ArrayList();
        this.getFileMenuItems(fileItems, false);
        ArrayList saveItems = new ArrayList();
        this.getSaveMenuItems(saveItems, true);
        fileItems.add("separator");
        fileItems.add(GuiUtils.makeMenu(new JMenu("Save"), saveItems));
        this.getLastFileMenuItems(fileItems);
        this.getViewMenuItems(viewItems, false);
        this.getIdv().getIdvUIManager().addViewMenuItems(this, viewItems);
        this.getEditMenuItems(editItems, false);
        this.getExtraMenus(extraMenus, false);
        this.getHelpMenuItems(helpItems, false);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(GuiUtils.makeMenu("File", fileItems));
        items.add(GuiUtils.makeMenu("Edit", editItems));
        items.add(GuiUtils.makeMenu("View", viewItems));
        if (!extraMenus.isEmpty()) {
            for (int i = 0; i < extraMenus.size(); ++i) {
                items.add(extraMenus.get(i));
            }
        }
        items.add(GuiUtils.makeMenu("Help", helpItems));
        if (comp != null) {
            items.add(0, GuiUtils.makeMenuItem("Control Window", this, "popup", comp));
            items.add(1, "separator");
        }
        return items;
    }

    public void changeDisplayUnit() {
        Unit newUnit = null;
        do {
            if ((newUnit = this.getDisplayConventions().selectUnit(this.displayUnit, null)) != null) continue;
            return;
        } while (!this.setNewDisplayUnit(newUnit, true));
        this.doShareExternal("DisplayControlImpl.SHARE_DISPLAYUNIT", newUnit);
    }

    public void changeColorUnit() {
        Unit newUnit = this.getDisplayConventions().selectUnit(this.colorUnit, null);
        if (newUnit != null) {
            this.setNewColorUnit(newUnit, true);
        }
    }

    protected JMenu doMakeChangeColorMenu() {
        return this.doMakeChangeColorMenu(this.getColorWidgetLabel());
    }

    protected JMenu doMakeChangeColorMenu(String name) {
        return GuiUtils.makeMenu(name != null ? name : this.getColorWidgetLabel(), this.makeChangeColorMenuItems());
    }

    protected JMenuItem doMakeChangeParameterMenuItem() {
        final JMenuItem selectChoices = new JMenuItem(this.getChangeParameterLabel());
        selectChoices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DisplayControlImpl.this.popupDataDialog("<html>Choose Parameter</html>", selectChoices);
            }
        });
        return selectChoices;
    }

    protected String getLegendToolTip() {
        StringBuffer sb = new StringBuffer("<html>");
        sb.append("<b>&nbsp; Display: " + StringUtil.join("; ", this.getLegendLabels(0)) + "</b><p>");
        sb.append(this.getDetailsContents());
        return sb.toString();
    }

    protected String getDetailsContents() {
        if (this.myDataChoices == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("");
        boolean didone = false;
        for (int i = 0; i < this.myDataChoices.size(); ++i) {
            if (i == 0) {
                sb.append(" <br> <b>&nbsp;Data:</b><ul>");
            }
            didone = true;
            DataChoice dc = (DataChoice)this.myDataChoices.get(i);
            sb.append("<li> &nbsp;");
            sb.append(dc.getFullDescription());
            sb.append(" &nbsp;");
        }
        if (didone) {
            sb.append("</ul>");
        }
        if (this.dataSelection != null) {
            List times;
            GeoSelection geoSelection = this.dataSelection.getGeoSelection();
            if (geoSelection != null) {
                sb.append("Geo selection:").append(geoSelection);
                sb.append("<br>\n");
            }
            if ((times = this.dataSelection.getTimes()) != null && times.size() > 0) {
                sb.append("Selected times:").append(StringUtil.join(" ", times));
            }
        }
        if (LogUtil.getDebugMode()) {
            this.getDebugDetails(sb);
        }
        return sb.toString();
    }

    public void debug(String msg) {
    }

    protected void getDebugDetails(StringBuffer sb) {
        if (this.dataInstances != null) {
            try {
                sb.append("<p>Data Types:<br>");
                for (Object dataInstance1 : this.dataInstances) {
                    DataInstance dataInstance = (DataInstance)dataInstance1;
                    Data data = dataInstance.getData();
                    sb.append("<b>").append(data.getType().toString()).append("<br>");
                }
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Making debug details", exc);
            }
        }
    }

    protected JComponent doMakeBottomLegendComponent() {
        this.bottomLegendButton = new JButton("                    ");
        this.bottomLegendButton.setToolTipText("Left click to toggle visiblity. Right click to show menu.");
        this.bottomLegendButton.setBorder(BorderFactory.createEmptyBorder());
        this.bottomLegendButton.setFont(GuiUtils.buttonFont);
        this.bottomLegendButton.setHorizontalAlignment(2);
        this.bottomLegendButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event)) {
                    DisplayControlImpl.this.showLegendMenu((JComponent)event.getSource(), event);
                }
            }
        });
        this.bottomLegendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayControlImpl.this.setDisplayVisibility(!DisplayControlImpl.this.isVisible);
            }
        });
        this.bottomLegendButton.addActionListener(this);
        JPanel colorSwatch = GuiUtils.wrap(new JLabel("     "));
        this.colorSwatches.add(colorSwatch);
        if (this.color != null) {
            colorSwatch.setBackground(this.color);
        }
        JComponent extraLegend = this.getExtraLegendComponent(0);
        this.updateLegendLabel();
        if (extraLegend != null) {
            return GuiUtils.centerRight(GuiUtils.centerRight(this.bottomLegendButton, extraLegend), colorSwatch);
        }
        return GuiUtils.centerRight(this.bottomLegendButton, colorSwatch);
    }

    protected boolean showColorScales(boolean show) {
        try {
            if (this.colorScales == null) {
                if (!show) {
                    return false;
                }
                this.doMakeColorScales();
            }
            for (Object colorScale : this.colorScales) {
                this.setDisplayableVisibility((Displayable)colorScale, show);
            }
            return true;
        }
        catch (Exception exc) {
            DisplayControlImpl.userMessage("Error showing ColorScale: " + exc);
            return false;
        }
    }

    protected void doMakeColorScales() throws VisADException, RemoteException {
        if (this.colorScaleInfo == null) {
            this.colorScaleInfo = this.getDefaultColorScaleInfo();
        }
        if (!this.colorScaleInfo.getIsVisible() || !this.getDisplayVisibility()) {
            return;
        }
        this.colorScales = new ArrayList();
        List v = this.getViewManagers();
        for (int i = 0; i < v.size(); ++i) {
            ColorScale colorScale = new ColorScale(this.colorScaleInfo);
            this.addDisplayable((Displayable)colorScale, (ViewManager)v.get(i), 8);
            this.setDisplayableVisibility(colorScale, this.colorScaleInfo.getIsVisible());
            this.colorScales.add(colorScale);
        }
    }

    protected ColorScaleInfo getDefaultColorScaleInfo() {
        ColorScaleInfo info = new ColorScaleInfo(this.paramName, 0, this.colorTable != null ? this.getColorTable().getColorTable() : (float[][])null);
        info.setPlacement("Top");
        info.setLabelColor(ColorScale.DEFAULT_LABEL_COLOR);
        info.setIsVisible(false);
        info.setUnit(this.getDisplayUnit());
        ViewManager vm = this.getDefaultViewManager();
        Font f = null;
        if (vm != null) {
            f = vm.getDisplayListFont();
        }
        info.setLabelFont(f);
        return info;
    }

    private boolean hasExternalView() {
        List v = this.getDisplayInfos();
        return v.size() > 0;
    }

    private void newViewManager() {
        this.moveTo(this.getViewManager(new ViewDescriptor()));
    }

    @Override
    public void moveTo(ViewManager newViewManager) {
        this.defaultViewManager = newViewManager;
        if (this.defaultViewManager != null && this.defaultViewManager.getViewDescriptor() != null) {
            this.defaultView = this.defaultViewManager.getViewDescriptor().getName();
        }
        List displayList = this.getDisplayInfos();
        try {
            boolean didone = false;
            for (Object aDisplayList : displayList) {
                DisplayInfo info = (DisplayInfo)aDisplayList;
                if (info.getViewManager() == newViewManager) continue;
                didone = true;
                info.moveTo(newViewManager);
            }
            if (didone) {
                this.activateDisplay(displayList);
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Moving to a new view", exc);
        }
        newViewManager.controlMoved(this);
    }

    @Override
    public void setLegendForeground(Color fg) {
        this.legendForeground = fg;
        this.applyLegendForeground();
    }

    @Override
    public void setLegendBackground(Color bg) {
        this.legendBackground = bg;
        GuiUtils.setBackgroundOnTree(this.getBottomLegendComponent(), bg);
        if (this.color != null) {
            for (Object colorSwatche : this.colorSwatches) {
                ((JComponent)colorSwatche).setBackground(this.color);
            }
        }
    }

    protected void showColorSwatches(boolean on) {
        for (Object colorSwatche : this.colorSwatches) {
            JComponent swatch = (JComponent)colorSwatche;
            swatch.setVisible(on);
            swatch.invalidate();
            if (swatch.getParent() == null) continue;
            swatch.getParent().validate();
        }
    }

    private void applyLegendForeground() {
        Color fg = this.isVisible ? (this.legendForeground != null ? this.legendForeground : Color.black) : Color.gray;
        if (this.bottomLegendComponent != null) {
            GuiUtils.setForegroundOnTree(this.bottomLegendComponent, fg);
        }
    }

    protected void notifyViewManagersOfChange() {
        List viewManagers = this.getViewManagers();
        for (Object viewManager : viewManagers) {
            ((ViewManager)viewManager).displayControlChanged(this);
        }
    }

    public void setShowInDisplayList(boolean value) {
        this.showInDisplayList = value;
        this.notifyViewManagersOfChange();
    }

    @Override
    public boolean getShowInDisplayList() {
        return this.showInDisplayList;
    }

    @Override
    public boolean getLockVisibilityToggle() {
        return this.lockVisibiltyToggle;
    }

    @Override
    public void setLockVisibilityToggle(boolean lockVisibilityToggle) {
        this.lockVisibiltyToggle = lockVisibilityToggle;
        for (Object lockButton : this.lockButtons) {
            this.updateLockButton((JButton)lockButton);
        }
    }

    @Override
    public boolean getDisplayVisibility() {
        return this.isVisible;
    }

    @Override
    public void toggleVisibilityForVectorGraphicsRendering(int rasterMode) throws Exception {
        if (rasterMode == 0) {
            this.setDisplayVisibility(this.getIsRaster());
        } else if (rasterMode == 1) {
            this.setDisplayVisibility(!this.getIsRaster());
        } else {
            this.setDisplayVisibility(true);
        }
    }

    public boolean getIsRaster() {
        return this.isRaster;
    }

    public void setIsRaster(boolean isRaster) {
        this.isRaster = isRaster;
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        this.setDisplayVisibility(on, true);
    }

    private void setDisplayVisibility(boolean on, boolean shouldShare) {
        if (this.settingVisibility) {
            return;
        }
        this.isVisible = on;
        if (!this.getHaveInitialized()) {
            return;
        }
        this.settingVisibility = true;
        this.applyLegendForeground();
        try {
            for (Object visibilityCb : this.visibilityCbs) {
                ((AbstractButton)visibilityCb).setSelected(on);
            }
            List displayList = this.getDisplayInfos();
            for (Object aDisplayList : displayList) {
                DisplayInfo info = (DisplayInfo)aDisplayList;
                Displayable displayable = info.getDisplayable();
                if (this.isVisible) {
                    if (!info.getUltimateVisible()) continue;
                    displayable.setVisible(true);
                    continue;
                }
                displayable.setVisible(false);
            }
            if (this.colorScales != null) {
                boolean shouldBeVisible = this.getColorScaleInfo().getIsVisible();
                for (Object colorScale : this.colorScales) {
                    ColorScale scale = (ColorScale)colorScale;
                    if (!on) {
                        scale.setVisible(false);
                        continue;
                    }
                    scale.setVisible(shouldBeVisible);
                }
            }
            if (this.displayListTable != null) {
                Enumeration e = this.displayListTable.elements();
                while (e.hasMoreElements()) {
                    DisplayableData d = (DisplayableData)e.nextElement();
                    d.setVisible(on);
                }
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting visibility of the display", exc);
        }
        this.settingVisibility = false;
        if (shouldShare) {
            this.doShareExternal("DisplayControlImpl.SHARE_VISIBILITY", this.isVisible);
        }
        List viewManagers = this.getViewManagers();
        for (Object viewManager : viewManagers) {
            ((ViewManager)viewManager).displayControlVisibilityChanged(this);
        }
    }

    protected void setDisplayableVisiblity(Displayable d, boolean visible) throws RemoteException, VisADException {
        this.setDisplayableVisibility(d, visible);
    }

    protected boolean canSaveDataInCache() {
        return this.dataInstances != null && this.dataInstances.size() == 1;
    }

    protected void setDisplayableVisibility(Displayable d, boolean visible) throws RemoteException, VisADException {
        List displayList = this.getDisplayInfos();
        int n = displayList.size();
        for (int i = 0; i < n; ++i) {
            DisplayInfo info = (DisplayInfo)displayList.get(i);
            Displayable displayable = info.getDisplayable();
            if (displayable != d) continue;
            info.setUltimateVisible(visible);
            if (visible) {
                d.setVisible(this.isVisible);
                break;
            }
            d.setVisible(false);
            break;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
    }

    public void displayControlFailed() {
        try {
            if (!this.getProperty("control.ignoreerrors", false)) {
                this.doRemove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.myWindow != null) {
            this.myWindow.setVisible(false);
        }
        if (!this.isInViewManager()) {
            try {
                this.doRemove();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void disposeOfWindow() {
        if (this.myWindow != null) {
            final IdvWindow tmpWindow = this.myWindow;
            this.myWindow = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tmpWindow.setVisible(false);
                    tmpWindow.dispose();
                }
            });
        }
    }

    public void popup(Component src) {
        Window f = GuiUtils.getWindow(this.contents);
        if (f != null && !this.makeWindow) {
            GuiUtils.showComponentInTabs(this.contents);
        } else {
            this.makeWindow = true;
            if (this.myWindow == null) {
                this.myWindow = this.createIdvWindow();
                if (this.myWindow != null) {
                    this.initWindow(this.myWindow);
                }
            }
            if (src != null) {
                GuiUtils.showDialogNearSrc(src, this.myWindow != null ? this.myWindow.getComponent() : null);
            } else {
                GuiUtils.showWidget(this.myWindow.getComponent());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.okToFireEvent) {
            return;
        }
        String cmd = event.getActionCommand();
        try {
            if (cmd.equals("cmd.remove")) {
                try {
                    this.doRemove();
                }
                catch (Exception exc) {
                    DisplayControlImpl.logException("Removing the display", exc);
                }
            }
            if (cmd.equals("cmd.thispopup")) {
                this.popup((Component)event.getSource());
                return;
            }
            if (cmd.equals("cmd.colors")) {
                JComboBox box = (JComboBox)event.getSource();
                String colorName = (String)box.getSelectedItem();
                if (colorName != null) {
                    Color newColor = this.getDisplayConventions().getColor(colorName);
                    this.setColor(newColor);
                }
                return;
            }
            if (cmd.equals("cmd.colortbl")) {
                JComboBox box = (JComboBox)event.getSource();
                ColorTable newColorTable = (ColorTable)box.getSelectedItem();
                if (newColorTable != null) {
                    this.setColorTable(newColorTable);
                }
                return;
            }
            log_.debug("Got unhandled cmd:" + cmd);
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Handling the action:" + cmd, exc);
        }
    }

    public boolean inGlobeDisplay() {
        return this.getNavigatedDisplay() instanceof GlobeDisplay;
    }

    public NavigatedDisplay getMapDisplay() {
        return this.getNavigatedDisplay();
    }

    public boolean isDisplay3D() {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay != null) {
            return this.getNavigatedDisplay().getDisplayMode() == 0;
        }
        return false;
    }

    public DisplayRealType getDisplayAltitudeType() {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay != null) {
            return navDisplay.getDisplayAltitudeType();
        }
        return null;
    }

    @Override
    public NavigatedDisplay getNavigatedDisplay() {
        ViewManager vm = this.getViewManager();
        if (vm == null || !(vm instanceof NavigatedViewManager)) {
            return null;
        }
        return ((NavigatedViewManager)vm).getNavigatedDisplay();
    }

    public void setDisplayInactive() {
        try {
            NavigatedDisplay display = this.getNavigatedDisplay();
            if (display != null) {
                display.setDisplayInactive();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDisplayActive() {
        try {
            NavigatedDisplay display = this.getNavigatedDisplay();
            if (display != null) {
                display.setDisplayActive();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void xxxsetDisplayActive(boolean active) throws RemoteException, VisADException {
        NavigatedDisplay display = this.getNavigatedDisplay();
        if (display != null) {
            // empty if block
        }
    }

    public MapViewManager getMapViewManager() {
        List displayList = this.getDisplayInfos();
        for (Object aDisplayList : displayList) {
            DisplayInfo info = (DisplayInfo)aDisplayList;
            ViewManager vm = info.getViewManager();
            if (!(vm instanceof MapViewManager)) continue;
            return (MapViewManager)vm;
        }
        return null;
    }

    public DisplayMaster getDisplayMaster(Displayable displayable) {
        ViewManager viewManager = this.getViewManager(displayable);
        return viewManager != null ? viewManager.getMaster() : null;
    }

    public ViewManager getViewManager(Displayable displayable) {
        List displayList = this.getDisplayInfos();
        int n = displayList.size();
        for (int i = 0; i < n; ++i) {
            DisplayInfo info = (DisplayInfo)displayList.get(i);
            if (info.getDisplayable() != displayable) continue;
            return info.getViewManager();
        }
        return null;
    }

    @Override
    public ViewManager getViewManager() {
        if (this.defaultViewManager != null) {
            if (this.defaultViewManager.getIsDestroyed()) {
                this.defaultViewManager = null;
                this.defaultView = null;
            } else {
                return this.defaultViewManager;
            }
        }
        this.defaultViewManager = this.getViewManager(this.getDefaultViewDescriptor());
        return this.defaultViewManager;
    }

    public ViewManager getViewManager(ViewDescriptor viewDescriptor) {
        if (this.defaultViewManager != null && this.defaultViewManager.getIsDestroyed()) {
            this.defaultViewManager = null;
        }
        if (viewDescriptor.equals(this.getDefaultViewDescriptor()) && this.defaultViewManager != null) {
            return this.defaultViewManager;
        }
        this.debug("new vm-1");
        ViewManager vm = this.getControlContext().getViewManager(viewDescriptor, true, null);
        this.debug("new vm-2");
        return vm;
    }

    @Override
    public JCheckBox doMakeVisibilityControl(String label) {
        final JCheckBox cb = new JCheckBox(label, this.isVisible);
        this.visibilityCbs.add(cb);
        cb.setToolTipText("Toggle visibility on/off");
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                DisplayControlImpl.this.setDisplayVisibility(cb.isSelected());
            }
        });
        return cb;
    }

    public JButton doMakeRemoveControl(String tooltip) {
        return GuiUtils.makeJButton("Remove display", new Object[]{"-listener", this, "-tooltip", tooltip, "-command", "cmd.remove"});
    }

    public void showColorDialog() {
        this.showColorDialog("setColor");
    }

    public void showColorDialog(String methodName) {
        Color newColor = JColorChooser.showDialog(null, "Choose Color", this.color);
        if (newColor != null) {
            try {
                Method theMethod = Misc.findMethod(this.getClass(), methodName, new Class[]{newColor.getClass()});
                if (theMethod == null) {
                    throw new NoSuchMethodException("unknown method " + methodName);
                }
                theMethod.invoke((Object)this, newColor);
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Setting color with:" + methodName, exc);
            }
        }
    }

    public void setColor(Color c) throws RemoteException, VisADException {
        this.color = c;
        if (this.color != null) {
            for (int i = 0; i < this.colorSwatches.size(); ++i) {
                ((JComponent)this.colorSwatches.get(i)).setBackground(this.color);
            }
            if (this.colorComboBox != null) {
                this.okToFireEvent = false;
                this.colorComboBox.setSelectedItem(this.getDisplayConventions().getColorName(c));
                this.okToFireEvent = true;
            }
        }
        if (this.getHaveInitialized()) {
            this.applyColor();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public Range getRangeToApply() throws RemoteException, VisADException {
        return this.getRange();
    }

    public Range getRange() throws RemoteException, VisADException {
        if (this.colorRange == null) {
            this.colorRange = this.getInitialRange();
        }
        return this.colorRange;
    }

    public Range getSelectRange() throws RemoteException, VisADException {
        if (this.selectRange == null) {
            this.selectRange = this.getColorRangeFromData();
        }
        return this.selectRange;
    }

    public Range getRangeForColorTable() throws RemoteException, VisADException {
        return this.getRange();
    }

    public void setRange(String whichColortable, Range newRange) throws RemoteException, VisADException {
        this.setRange(newRange);
    }

    public void setColorTable(String whichColorTable, ColorTable newColorTable) throws RemoteException, VisADException {
        this.setColorTable(newColorTable);
    }

    protected void revertToDefaultColorTable(String whichColorTable) {
        this.revertToDefaultColorTable();
    }

    protected void revertToDefaultRange(String whichColorTable) {
        this.revertToDefaultRange();
    }

    public void setRange(Range newRange) throws RemoteException, VisADException {
        this.colorRange = newRange;
        if (this.colorRange != null) {
            if (this.ctw != null) {
                this.ctw.setRange(this.colorRange);
            }
            if (this.getHaveInitialized()) {
                this.applyRange();
            }
        }
    }

    public void setSelectRange(Range newRange) throws RemoteException, VisADException {
        this.selectRange = newRange;
        if (this.selectRange != null) {
            if (this.selectRangeWidget != null) {
                this.selectRangeWidget.setRange(this.selectRange);
                if (!this.selectRangeWidget.getSelectRangeEnabled()) {
                    return;
                }
            }
            if (this.getHaveInitialized()) {
                this.applySelectRange();
            }
        }
    }

    private void setColorTable(ColorTable newColorTable, boolean fromUser) throws RemoteException, VisADException {
        if (this.colorTable != null && newColorTable != null) {
            if (this.colorTable.equalsTable(newColorTable)) {
                return;
            }
            if (!this.colorTable.getName().equals(newColorTable.getName())) {
                this.resetDimness();
            }
        } else {
            this.resetDimness();
        }
        if (newColorTable == null) {
            this.colorTable = null;
            return;
        }
        this.colorTable = new ColorTable(newColorTable);
        if (this.ctw != null) {
            this.ctw.setColorTable(this.colorTable);
        }
        if (this.getHaveInitialized()) {
            this.deactivateDisplays();
            this.applyColorTable();
            if (fromUser) {
                this.doShare((Object)"DisplayControlImpl.SHARE_COLORTABLE", this.colorTable);
            }
            this.activateDisplays();
        }
    }

    public void setColorTableName(String n) {
        this.colorTableName = n;
        if (this.haveInitialized) {
            ColorTable ct = this.controlContext.getColorTableManager().getColorTable(this.colorTableName);
            try {
                this.setColorTable(ct);
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Setting color table", exc);
            }
        }
    }

    public void setColorTable(ColorTable newColorTable) throws RemoteException, VisADException {
        this.setColorTable(newColorTable, true);
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    public void setDisplayListColor(Color newColor) throws RemoteException, VisADException {
        this.setDisplayListColor(newColor, true);
    }

    protected void setDisplayListColor(Color newColor, boolean fromUser) throws RemoteException, VisADException {
        Enumeration e = this.displayListTable.elements();
        while (e.hasMoreElements()) {
            ((DisplayableData)e.nextElement()).setColor(newColor);
        }
        this.displayListColor = newColor;
        if (fromUser) {
            this.displayListUsesColor = false;
        }
    }

    public Color getDisplayListColor() {
        return this.displayListColor;
    }

    protected JComponent getExtraLegendComponent(int legendType) {
        if (this.ctw != null) {
            return this.ctw.getLegendPanel(legendType);
        }
        return null;
    }

    public ColorTableWidget getColorTableWidget(Range r) throws VisADException, RemoteException {
        if (this.ctw == null) {
            if (this.colorTable == null) {
                this.colorTable = this.getOldColorTableOrInitialColorTable();
            }
            this.ctw = new ColorTableWidget(this, this.controlContext.getColorTableManager(), this.colorTable != null ? this.colorTable : this.controlContext.getColorTableManager().getDefaultColorTable(), r);
            this.addRemovable(this.ctw);
        } else if (r != null) {
            this.ctw.setRange(r);
        }
        return this.ctw;
    }

    public SelectRangeWidget getSelectRangeWidget(Range r) throws VisADException, RemoteException {
        if (this.selectRangeWidget == null) {
            this.selectRangeWidget = new SelectRangeWidget(this, r);
            this.addRemovable(this.selectRangeWidget);
        }
        return this.selectRangeWidget;
    }

    public ValueSliderWidget getLineWidthWidget() throws VisADException, RemoteException {
        if (this.lww == null) {
            this.lww = new ValueSliderWidget(this, 1, 10, "lineWidth", this.getLineWidthWidgetLabel());
            this.addRemovable(this.lww);
        }
        return this.lww;
    }

    public Component doMakeColorControl() {
        return this.doMakeColorControl(null);
    }

    public Component doMakeColorControl(Color color) {
        String colorName;
        this.colorComboBox = new JComboBox(this.getDisplayConventions().getColorNameList());
        if (color != null && (colorName = this.getDisplayConventions().getColorName(color)) != null) {
            this.colorComboBox.setSelectedItem(colorName);
        }
        this.colorComboBox.addActionListener(this);
        this.colorComboBox.setActionCommand("cmd.colors");
        return this.colorComboBox;
    }

    public double getVerticalValue(double value) {
        double[] range;
        DisplayRealType drt;
        boolean hasRange;
        double returnValue = value;
        double d = value < -1.0 ? -1.0 : (returnValue = value > 1.0 ? 1.0 : value);
        if (this.getNavigatedDisplay() != null && (hasRange = (drt = this.getNavigatedDisplay().getDisplayAltitudeType()).getRange(range = new double[2]))) {
            double pcnt = (returnValue - -1.0) / 2.0;
            returnValue = Math.min(range[0] + (range[1] - range[0]) * pcnt, range[1]);
        }
        return returnValue;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public boolean getProperty(String name, boolean dflt) {
        return this.getControlContext().getProperty(name, dflt);
    }

    public String getProperty(String name, String dflt) {
        return this.getControlContext().getProperty(name, dflt);
    }

    public XmlObjectStore getObjectStore() {
        return this.getControlContext().getObjectStore();
    }

    public void setOkToFireEvents(boolean v) {
        this.okToFireEvent = v;
    }

    public boolean getOkToFireEvents() {
        return this.okToFireEvent;
    }

    public void setContourInfoParams(String s) {
        this.contourInfoParams = s;
    }

    public void setContourInfo(ContourInfo newInfo) throws VisADException, RemoteException {
        if (newInfo == null) {
            this.contourInfo = null;
            return;
        }
        this.contourInfo = new ContourInfo(newInfo);
        if (this.contourWidget != null) {
            this.contourWidget.setContourInfo(newInfo);
        }
        this.applyContourInfo();
    }

    public ContourInfo getContourInfo() {
        return this.contourInfo;
    }

    public void setSharedColorScaleInfo(ColorScaleInfo newInfo) throws VisADException, RemoteException {
        if (newInfo == null) {
            return;
        }
        newInfo = new ColorScaleInfo(newInfo);
        if (this.colorScaleInfo != null) {
            newInfo.setPlacement(this.colorScaleInfo.getPlacement());
            newInfo.setOrientation(this.colorScaleInfo.getOrientation());
        }
        this.colorScaleInfo = newInfo;
        this.applyColorScaleInfo();
    }

    public void setColorScaleInfo(ColorScaleInfo newInfo) throws VisADException, RemoteException {
        if (newInfo == null) {
            this.colorScaleInfo = null;
            return;
        }
        this.colorScaleInfo = new ColorScaleInfo(newInfo);
        this.applyColorScaleInfo();
    }

    public ColorScaleInfo getColorScaleInfo() {
        if (this.colorScaleInfo == null) {
            this.colorScaleInfo = this.getDefaultColorScaleInfo();
        }
        return this.colorScaleInfo;
    }

    public Hashtable getCachedData() {
        return null;
    }

    public void setCachedData(Hashtable cache) {
        this.cachedData = cache;
    }

    public void setDataInstances(List l) {
        this.dataInstances = l;
    }

    public float getDisplayScale() throws VisADException, RemoteException {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay != null) {
            return navDisplay.getDisplayScale();
        }
        return 1.0f;
    }

    public String getDefaultSamplingMode() {
        return this.defaultSamplingMode;
    }

    public void setDefaultSamplingMode(String newMode) {
        this.defaultSamplingMode = newMode;
    }

    public int getSamplingModeValue() {
        return this.getSamplingModeValue(this.defaultSamplingMode);
    }

    public int getSamplingModeValue(String samplingMode) {
        return Misc.equals(samplingMode, "Weighted Average") ? 101 : 100;
    }

    public String getSamplingModeName(int mode) {
        return mode == 101 ? "Weighted Average" : "Nearest Neighbor";
    }

    public int getDefaultSamplingModeValue() {
        return this.getSamplingModeValue(this.defaultSamplingMode == null ? DEFAULT_SAMPLING_MODE : this.defaultSamplingMode);
    }

    @Override
    public void setDisplayCategory(String value) {
        this.displayCategory = value;
        if (this.displayCategory != null) {
            allCategories.put(this.displayCategory, this.displayCategory);
        }
    }

    @Override
    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public List getViewManagers() {
        List displayList = this.getDisplayInfos();
        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
        for (int i = 0; i < displayList.size(); ++i) {
            DisplayInfo info = (DisplayInfo)displayList.get(i);
            ViewManager vm = info.getViewManager();
            if (viewManagers.contains(vm)) continue;
            viewManagers.add(vm);
        }
        return viewManagers;
    }

    public void setColorScaleVisible(boolean viz) throws VisADException, RemoteException {
        this.getColorScaleInfo().setIsVisible(viz);
        this.applyColorScaleInfo();
    }

    public void setHadDataChoices(boolean value) {
        this.hadDataChoices = value;
    }

    public boolean getHadDataChoices() {
        return this.myDataChoices != null && this.myDataChoices.size() > 0;
    }

    public void setOriginalDataChoicesLabel(String s) {
        this.originalDataChoicesLabel = s;
    }

    public String getOriginalDataChoicesLabel() {
        if (this.controlContext != null && !this.controlContext.getPersistenceManager().getSaveDataSources() && this.myDataChoices != null && this.myDataChoices.size() > 0) {
            return "" + this.myDataChoices.get(0);
        }
        return "";
    }

    public void setTemplateName(String value) {
        this.templateName = value;
    }

    public String getTemplateName() {
        if (this.controlContext != null) {
            return this.controlContext.getPersistenceManager().getCurrentTemplateName();
        }
        return null;
    }

    public void setNameFromUser(String value) {
        this.legendLabelTemplate = value;
    }

    public void setName(String value) {
        this.id = value;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setCollapseLegend(boolean value) {
        this.collapseLegend = value;
    }

    @Override
    public boolean getCollapseLegend() {
        return this.collapseLegend;
    }

    @Override
    public Object getTransientProperty(Object key) {
        return this.transientProperties.get(key);
    }

    @Override
    public void putTransientProperty(Object key, Object value) {
        this.transientProperties.put(key, value);
    }

    @Override
    public void applyPreferences() {
        this.updateLegendAndList();
    }

    public void setZPosition(double value) throws RemoteException, VisADException {
        this.setZPosition(value, false);
    }

    public void setZPosition(double value, boolean fromSlider) throws RemoteException, VisADException {
        this.zPosition = value;
        if (this.getHaveInitialized()) {
            this.applyZPosition();
        }
        if (this.zPositionSlider != null && !fromSlider) {
            this.zPositionSlider.setValue(value);
        }
    }

    public void setLineWidth(int value) throws RemoteException, VisADException {
        this.lineWidth = value;
        if (this.getHaveInitialized()) {
            this.applyLineWidth();
        }
        if (this.lww != null) {
            this.lww.setValue(value);
        }
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    protected double getInitialZPosition() {
        double retVal = -1.0;
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay != null) {
            DisplayRealType drt = navDisplay.getDisplayAltitudeType();
            double[] range = new double[2];
            boolean hasRange = drt.getRange(range);
            double defVal = drt.getDefaultValue();
            if (hasRange) {
                double pcnt = Math.abs((defVal - range[0]) / Math.abs(range[1] - range[0]));
                retVal = -1.0 + 2.0 * pcnt;
            }
        }
        return retVal;
    }

    public double getZPosition() {
        if (this.zPosition == Double.MIN_VALUE) {
            this.zPosition = this.getInitialZPosition();
        }
        return this.zPosition;
    }

    protected void updateAnimation() {
        if (this.internalAnimation != null) {
            this.internalAnimation.reCalculateAnimationSet();
        }
        if (this.viewAnimation != null) {
            this.viewAnimation.reCalculateAnimationSet();
        }
    }

    public Animation getSomeAnimation() throws VisADException, RemoteException {
        return this.getAnimation();
    }

    public Animation getAnimation() throws VisADException, RemoteException {
        return this.getAnimation(false, null);
    }

    protected Animation getAnimation(boolean createOurOwn) throws VisADException, RemoteException {
        return this.getAnimation(createOurOwn, null);
    }

    protected Animation getAnimation(RealType timeType) throws VisADException, RemoteException {
        return this.getAnimation(true, timeType);
    }

    protected Animation getAnimation(boolean createOurOwn, RealType timeType) throws VisADException, RemoteException {
        if (createOurOwn) {
            return this.getInternalAnimation(timeType);
        }
        if (this.internalAnimation != null) {
            return this.internalAnimation;
        }
        return this.getViewAnimation();
    }

    public Animation getViewAnimation() throws VisADException, RemoteException {
        if (this.viewAnimation == null) {
            ViewManager viewManager = null;
            if (this.viewManagers != null && this.viewManagers.size() > 0) {
                viewManager = (ViewManager)this.viewManagers.get(0);
                this.viewAnimation = viewManager.getAnimation();
            }
            if (this.viewAnimation == null) {
                viewManager = this.getViewManager();
                if (viewManager == null) {
                    return null;
                }
                this.viewAnimation = viewManager.getAnimation();
            }
            if (this.viewAnimation == null) {
                return null;
            }
            this.viewAnimation.addPropertyChangeListener(this);
        }
        return this.viewAnimation;
    }

    protected Animation getInternalAnimation() throws VisADException, RemoteException {
        return this.getInternalAnimation(null);
    }

    protected Animation getInternalAnimation(RealType timeType) throws VisADException, RemoteException {
        if (this.internalAnimation != null) {
            return this.internalAnimation;
        }
        this.internalAnimation = timeType == null ? new Animation() : new Animation(timeType);
        this.internalAnimation.addPropertyChangeListener(this);
        return this.internalAnimation;
    }

    public AnimationWidget getAnimationWidget() throws VisADException, RemoteException {
        if (this.animationWidget == null) {
            if (this.animationInfo == null) {
                this.animationInfo = (AnimationInfo)this.getIdv().getPersistenceManager().getPrototype(AnimationInfo.class);
                if (this.animationInfo == null) {
                    this.animationInfo = new AnimationInfo();
                }
            }
            this.animationWidget = new AnimationWidget(null, null, this.animationInfo);
            Animation animation = this.getInternalAnimation();
            animation.setAnimationInfo(this.animationInfo);
            if (!this.initializationDone) {
                this.animationWidget.setSharing(false);
            }
            this.animationWidget.setAnimation(animation);
        }
        return this.animationWidget;
    }

    @Override
    public boolean isInitDone() {
        return this.initializationDone;
    }

    public void setShowInLegend(boolean value) {
        this.showInLegend = value;
    }

    @Override
    public boolean getShowInLegend() {
        return this.showInLegend;
    }

    protected boolean shouldApplyFastRendering() {
        return true;
    }

    protected boolean getDefaultFastRendering() {
        return true;
    }

    protected boolean getInitialFastRendering() {
        return this.controlContext.getObjectStore().get("idv.fastrender", this.getDefaultFastRendering());
    }

    private void applyUseFastRendering() {
        if (!this.shouldApplyFastRendering()) {
            return;
        }
        if (this.haveInitialized) {
            List displayList = this.getDisplayInfos();
            int n = displayList.size();
            for (int i = 0; i < n; ++i) {
                DisplayInfo info = (DisplayInfo)displayList.get(i);
                try {
                    Displayable displayable = info.getDisplayable();
                    if (displayable == null) continue;
                    displayable.setUseFastRendering(info.getViewManager().getUseFastRendering(this.useFastRendering));
                    continue;
                }
                catch (Exception exc) {
                    DisplayControlImpl.logException("Setting fast rendering to: " + this.useFastRendering, exc);
                }
            }
        }
    }

    public void setUseFastRendering(boolean value) {
        this.useFastRendering = value;
        this.applyUseFastRendering();
    }

    public boolean getUseFastRendering() {
        return this.useFastRendering;
    }

    protected void setAnimationSet(List dateTimes) throws VisADException, RemoteException {
        CalendarDateTimeSet set = null;
        if (dateTimes != null && !dateTimes.isEmpty()) {
            DateTime[] timeArray = new DateTime[dateTimes.size()];
            for (int i = 0; i < timeArray.length; ++i) {
                timeArray[i] = (DateTime)dateTimes.get(i);
            }
            set = CalendarDateTime.makeTimeSet(timeArray);
        }
        this.getAnimationWidget().setBaseTimes(set);
    }

    public void setAnimationInfo(AnimationInfo value) {
        this.animationInfo = value;
    }

    public AnimationInfo getAnimationInfo() {
        if (this.animationWidget != null) {
            return this.animationWidget.getAnimationInfo();
        }
        return this.animationInfo;
    }

    protected JButton makeLockButton() {
        JButton lockBtn = new JButton(ICON_LOCK);
        lockBtn.setContentAreaFilled(false);
        lockBtn.setBorder(BorderFactory.createEmptyBorder());
        this.lockButtons.add(lockBtn);
        this.updateLockButton(lockBtn);
        lockBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DisplayControlImpl.this.setLockVisibilityToggle(!DisplayControlImpl.this.getLockVisibilityToggle());
            }
        });
        return lockBtn;
    }

    protected void updateLockButton(JButton lockBtn) {
        boolean isLocked = this.getLockVisibilityToggle();
        lockBtn.setIcon(isLocked ? ICON_LOCK : ICON_UNLOCK);
        lockBtn.setToolTipText(Msg.msg("When locked this display control is not affected by the visibility toggling"));
    }

    protected JButton makeRemoveButton() {
        JButton removeBtn = GuiUtils.getImageButton(ICON_REMOVE);
        removeBtn.setToolTipText("Remove the display");
        removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    DisplayControlImpl.this.doRemove();
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Removing display", exc);
                }
            }
        });
        removeBtn.setBackground(null);
        return removeBtn;
    }

    public void setViewManagerClassNames(String value) {
        this.viewManagerClassNames = value;
    }

    public String getViewManagerClassNames() {
        return this.viewManagerClassNames;
    }

    public void setColorDimness(float value) {
        this.colorDimness = value;
    }

    public float getColorDimness() {
        return this.colorDimness;
    }

    public void setDataTimeRange(DataTimeRange value) {
        this.dataTimeRange = value;
    }

    public DataTimeRange getDataTimeRange() {
        return this.dataTimeRange;
    }

    public DataTimeRange getDataTimeRange(boolean createIfNeeded) {
        if (createIfNeeded && this.dataTimeRange == null) {
            this.dataTimeRange = new DataTimeRange();
        }
        return this.dataTimeRange;
    }

    public void setUseTimesInAnimation(boolean value) {
        this.useTimesInAnimation = value;
        try {
            if (this.haveInitialized) {
                List infos = this.getDisplayInfos();
                int n = infos.size();
                for (int i = 0; i < n; ++i) {
                    DisplayInfo info = (DisplayInfo)infos.get(i);
                    info.getDisplayable().setUseTimesInAnimation(value);
                }
            }
        }
        catch (Exception exc) {
            DisplayControlImpl.logException("Setting use times in animation", exc);
        }
    }

    public boolean getUseTimesInAnimation() {
        return this.useTimesInAnimation;
    }

    public Range convertColorRange(Range rawRange, Unit rawUnit) {
        return this.convertRange(rawRange, rawUnit, this.getUnitForColor());
    }

    public Range convertRange(Range rawRange, Unit rawUnit, Unit outUnit) {
        return Util.convertRange(rawRange, rawUnit, outUnit);
    }

    @Override
    public void setExpandedInTabs(boolean value) {
        this.expandedInTabs = value;
    }

    @Override
    public boolean getExpandedInTabs() {
        return this.expandedInTabs;
    }

    @Override
    public void setShowInTabs(boolean value) {
        this.showInTabs = value;
    }

    @Override
    public boolean getShowInTabs() {
        return this.showInTabs;
    }

    @Override
    public boolean shouldBeDocked() {
        return this.getShowInTabs() && this.componentHolder == null;
    }

    @Override
    public boolean canBeDocked() {
        return this.componentHolder == null;
    }

    public void setVersion(double value) {
        this.versionWasSet = true;
        this.version = value;
    }

    public double getVersion() {
        return 2.2;
    }

    protected boolean getWasUnPersisted() {
        return this.wasUnPersisted;
    }

    public void setDisplayListTemplate(String value) {
        this.displayListTemplate = value;
    }

    public String getDisplayListTemplate() {
        if (this.displayListTemplate == null) {
            boolean haveData = this.getShortParamName() != null;
            this.displayListTemplate = this.getStore().get("idv.displaylist.template." + this.displayId, (String)null);
            if (this.displayListTemplate == null) {
                String pref = "idv.displaylist.template" + (haveData ? ".data" : ".nodata");
                this.displayListTemplate = this.getStore().get(pref, this.getDefaultDisplayListTemplate());
            }
        }
        return this.displayListTemplate;
    }

    protected String getDefaultDisplayListTemplate() {
        return this.getShortParamName() != null ? "%shortname% - %displayname% %timestamp%" : "%displayname%";
    }

    public void setLegendLabelTemplate(String value) {
        this.legendLabelTemplate = value;
    }

    public String getLegendLabelTemplate() {
        if (this.legendLabelTemplate == null) {
            boolean haveData = this.getShortParamName() != null;
            this.legendLabelTemplate = this.getStore().get("idv.legendlabel.template." + this.displayId, (String)null);
            if (this.legendLabelTemplate == null) {
                String pref = "idv.legendlabel.template" + (haveData ? ".data" : ".nodata");
                this.legendLabelTemplate = this.getStore().get(pref, haveData ? "%shortname% - " + "%displayname%" : MACRO_DISPLAYNAME);
            }
        }
        return this.legendLabelTemplate;
    }

    public void setLegendLabel(String label) {
    }

    public void setExtraLabelTemplate(String value) {
        this.extraLabelTemplate = value;
    }

    public String getExtraLabelTemplate() {
        if (this.extraLabelTemplate == null) {
            boolean haveData = this.getShortParamName() != null;
            this.extraLabelTemplate = this.getStore().get("idv.extralabel.template." + this.displayId, (String)null);
            if (this.extraLabelTemplate == null) {
                String pref = "idv.extralabel.template" + (haveData ? ".data" : ".nodata");
                this.extraLabelTemplate = this.getStore().get(pref, (String)null);
            }
            if (this.extraLabelTemplate == null && this.canDoProgressiveResolution()) {
                this.extraLabelTemplate = "%resolution%";
            }
        }
        if (this.extraLabelTemplate == null) {
            this.extraLabelTemplate = "";
        }
        return this.extraLabelTemplate;
    }

    public void setSelectRangeEnabled(boolean value) {
        if (value == this.selectRangeEnabled) {
            return;
        }
        this.selectRangeEnabled = value;
        if (this.getHaveInitialized()) {
            try {
                this.applySelectRange();
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Applying selection range", exc);
            }
        }
    }

    public boolean getSelectRangeEnabled() {
        return this.selectRangeEnabled;
    }

    public boolean canExportData() {
        return false;
    }

    protected Data getDisplayedData() throws VisADException, RemoteException {
        return null;
    }

    public void exportDisplayedData(String type) {
        try {
            Data d = this.getDisplayedData();
            if (d == null) {
                return;
            }
            if (Util.exportAsNetcdf(d)) {
                DisplayControlImpl.userMessage("<html>The displayed data has been exported.<p>Note: this facility is experimental. The exported NetCDF file is not CF compliant and cannot be used within the IDV</html>");
            }
        }
        catch (Exception e) {
            DisplayControlImpl.logException("Unable to export the data", e);
        }
    }

    protected boolean useZPosition() {
        return this.isDisplay3D() || this.isInTransectView();
    }

    protected void applySkipFactor() {
    }

    public void setSkipValue(int value) {
        this.skipValue = value;
        if (this.getHaveInitialized()) {
            this.applySkipFactor();
            this.doShare((Object)"DisplayControlImpl.SHARE_SKIPVALUE", new Integer(this.skipValue));
        }
    }

    public int getSkipValue() {
        return this.skipSlider == null ? this.skipValue : this.skipSlider.getValue();
    }

    protected Component doMakeSkipFactorSlider() {
        this.skipSlider = new JSlider(0, 10, this.skipValue);
        this.skipSlider.setPaintTicks(true);
        this.skipSlider.setPaintLabels(true);
        this.skipSlider.setToolTipText("Change sampling factor");
        this.skipSlider.setMajorTickSpacing(5);
        this.skipSlider.setMinorTickSpacing(1);
        this.skipSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DisplayControlImpl.this.skipSlider.getValueIsAdjusting()) {
                    return;
                }
                Misc.run(new Runnable(){

                    @Override
                    public void run() {
                        DisplayControlImpl.this.applySkipFactor();
                    }
                });
            }
        });
        return GuiUtils.hgrid(this.skipSlider, GuiUtils.filler());
    }

    protected void checkImageSize(FieldImpl image) {
        try {
            int maxSize = this.getStore().get("idv.data.image.maxsize", -1);
            if (maxSize > 0) {
                int[] lengths = ((GriddedSet)GridUtil.getSpatialDomain(image)).getLengths();
                int sizeX = lengths[0];
                int sizeY = lengths[1];
                int skipValue = this.getSkipValue();
                if (skipValue == 0) {
                    while (sizeX * sizeY > maxSize) {
                        sizeX /= ++skipValue + 1;
                        sizeY /= skipValue + 1;
                    }
                    if (this.skipSlider != null) {
                        this.skipSlider.setValue(skipValue);
                    }
                    this.skipValue = skipValue;
                }
            }
        }
        catch (Exception e) {
            DisplayControlImpl.logException("checkImageSize: ", e);
        }
    }

    public void setComponentHolder(IdvComponentHolder value) {
        this.componentHolder = value;
        if (this.componentHolder != null) {
            // empty if block
        }
    }

    public IdvComponentHolder getComponentHolder() {
        return this.componentHolder;
    }

    public boolean showColorControlWidget() {
        return false;
    }

    public void setDoCursorReadout(boolean value) {
        this.doCursorReadout = value;
    }

    public boolean getDoCursorReadout() {
        return this.doCursorReadout;
    }

    public void setTextureQuality(int quality) {
        this.textureQuality = quality;
        if (this.getHaveInitialized()) {
            try {
                this.applyTextureQuality();
            }
            catch (Exception exc) {
                DisplayControlImpl.logException("Applying z position", exc);
            }
        }
    }

    public int getTextureQuality() {
        return this.textureQuality;
    }

    public String getTextureQualityLabel() {
        return "Texture Quality";
    }

    protected void applyTextureQuality() throws VisADException, RemoteException {
    }

    protected void applySmoothing() throws VisADException, RemoteException {
    }

    private JComponent doMakeSmoothingWidget() {
        this.sww = new ValueSliderWidget(this, 1, 19, "smoothingFactor", "Factor", 1.0f, true, "Amount of smoothing or radius in grid units (larger number = greater smoothing");
        final JComponent swwContents = this.sww.getContents(true);
        this.addRemovable(this.sww);
        GuiUtils.enableTree(swwContents, this.useSmoothingFactor());
        List smootherList = TwoFacedObject.createList(smoothers, smootherLabels);
        JComboBox smootherBox = new JComboBox();
        GuiUtils.setListData(smootherBox, smootherList);
        smootherBox.setSelectedItem(TwoFacedObject.findId(this.getSmoothingType(), smootherList));
        smootherBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TwoFacedObject select = (TwoFacedObject)((JComboBox)e.getSource()).getSelectedItem();
                DisplayControlImpl.this.setSmoothingType((String)select.getId());
                GuiUtils.enableTree(swwContents, DisplayControlImpl.this.useSmoothingFactor());
            }
        });
        JPanel smoothWidgets = GuiUtils.left(GuiUtils.hbox(smootherBox, GuiUtils.filler(), swwContents));
        return smoothWidgets;
    }

    public boolean useSmoothingFactor() {
        String type = this.getSmoothingType();
        return !type.equals("None") && !type.equals("SM5S") && !type.equals("SM9S");
    }

    public int getSmoothingFactor() {
        return this.smoothingFactor;
    }

    public String getSmoothingType() {
        return this.smoothingType;
    }

    public void setSmoothingFactor(int val) {
        this.smoothingFactor = val;
        if (this.sww != null) {
            this.sww.setValue(val);
        }
        if (this.getHaveInitialized()) {
            try {
                this.applySmoothing();
            }
            catch (Exception e) {
                DisplayControlImpl.logException("Error applying smoothing factor", e);
            }
        }
    }

    public void setSmoothingType(String type) {
        this.smoothingType = type;
        if (this.getHaveInitialized()) {
            try {
                this.applySmoothing();
            }
            catch (Exception e) {
                DisplayControlImpl.logException("Error applying smoothing type", e);
            }
        }
    }

    public void setPointSize(float value) {
        this.pointSize = value;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public JComponent doMakePointSizeWidget() {
        final JTextField pointSizeFld = new JTextField("" + this.getPointSize(), 5);
        pointSizeFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    DisplayControlImpl.this.setPointSize(Float.parseFloat(pointSizeFld.getText().trim()));
                }
                catch (Exception exc) {
                    DisplayControlBase.logException("Error parsing size:" + pointSizeFld.getText(), exc);
                }
            }
        });
        return pointSizeFld;
    }

    public void setVisbilityAnimationPause(int value) {
        this.visbilityAnimationPause = value;
    }

    @Override
    public int getVisbilityAnimationPause() {
        return this.visbilityAnimationPause;
    }

    public void setIsTimeDriver(boolean value) {
        this.isTimeDriver = value;
        if (this.haveInitialized && value) {
            ViewManager vm = this.getViewManager();
            vm.ensureOnlyOneTimeDriver(this);
        }
    }

    @Override
    public boolean getIsTimeDriver() {
        return this.isTimeDriver;
    }

    public void setUsesTimeDriver(boolean value) {
        this.usesTimeDriver = value;
        if (this.getDataSelection() != null) {
            this.getDataSelection().putProperty("Use_Display_Driver_Times", value);
        }
    }

    public boolean getUsesTimeDriver() {
        return this.usesTimeDriver;
    }

    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds) {
        this.relocateDisplay(originalBounds, newBounds, false);
    }

    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        GeoSelection gs;
        if (this.dataSelection == null) {
            this.getDataSelection();
        }
        if ((gs = this.dataSelection.getGeoSelection()) == null) {
            gs = new GeoSelection();
        }
        GeoLocationInfo ginfo = new GeoLocationInfo(newBounds);
        gs.setBoundingBox(ginfo);
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay instanceof MapProjectionDisplay) {
            float[][] values = new float[2][2];
            values[0][0] = (float)newBounds.getLatMax();
            values[0][1] = (float)newBounds.getLatMin();
            values[1][0] = (float)newBounds.getLonMax();
            values[1][1] = (float)newBounds.getLonMin();
            try {
                Gridded2DSet region = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, values, 2);
                ((MapProjectionDisplay)navDisplay).setMapRegion(region);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LatLonPoint[] getLatLonPoints(double[][] xyPoints) {
        LatLonPoint[] latlonPoints = new LatLonPoint[xyPoints[0].length];
        if (this.inGlobeDisplay()) {
            for (int i = 0; i < xyPoints.length; ++i) {
                latlonPoints[i] = new LatLonPointImpl(xyPoints[0][i], xyPoints[1][i]);
            }
            return latlonPoints;
        }
        NavigatedDisplay navDisplay = this.getMapDisplay();
        for (int i = 0; i < xyPoints.length; ++i) {
            EarthLocation llpoint = navDisplay.getEarthLocation(xyPoints[0][i], xyPoints[1][i], 0.0);
            latlonPoints[i] = new LatLonPointImpl(llpoint.getLatitude().getValue(), llpoint.getLongitude().getValue());
        }
        return latlonPoints;
    }

    public boolean getShoulDoProgressiveResolution() {
        boolean shouldDo = this.canDoProgressiveResolution() && this.getIsProgressiveResolution();
        MapViewManager mvm = this.getMapViewManager();
        if (mvm != null) {
            shouldDo = shouldDo && mvm.getUseProgressiveResolution();
        }
        return shouldDo;
    }

    protected boolean canDoProgressiveResolution() {
        return false;
    }

    public boolean getIsProgressiveResolution() {
        return this.isProgressiveResolution;
    }

    public void setIsProgressiveResolution(boolean isPG) {
        this.isProgressiveResolution = isPG;
        if (this.dataSelection != null) {
            this.dataSelection.putProperty("Use_Progressive_Resolution", this.isProgressiveResolution);
        }
    }

    public boolean getMatchDisplayRegion() {
        return this.matchDisplayRegion;
    }

    public void setMatchDisplayRegion(boolean useDR) {
        this.matchDisplayRegion = useDR;
        if (this.dataSelection != null) {
            this.dataSelection.getGeoSelection(true).setUseViewBounds(useDR);
        }
    }

    public void saveProjection() {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        navDisplay.getDisplay().getProjectionControl().saveProjection();
    }

    public static class SideLegendLabel
    extends DndImageButton {
        DisplayControlImpl myControl;
        Cursor oldCursor;
        boolean mouseDown = false;
        boolean mouseIn = false;
        Color color;

        public SideLegendLabel(DisplayControlImpl displayControl, String text) {
            super(text, displayControl, "control");
            this.myControl = displayControl;
            this.color = GuiUtils.decodeColor("#005aff", Color.red);
            this.setForeground(this.color);
            GuiUtils.applyDefaultFont(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (!myControl.getHaveInitialized()) {
                        return;
                    }
                    if (GuiUtils.isControlKey(event)) {
                        myControl.centerOnDisplay();
                        return;
                    }
                    if (SwingUtilities.isRightMouseButton(event)) {
                        return;
                    }
                    myControl.popup(this);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    mouseDown = true;
                    this.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    mouseDown = false;
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    mouseIn = true;
                    this.setForeground(color);
                    oldCursor = this.getCursor();
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mouseIn = false;
                    if (oldCursor != null) {
                        this.setCursor(oldCursor);
                    }
                    this.repaint();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            Rectangle b = this.getBounds();
            if (this.mouseDown) {
                g.setColor(Color.gray);
                g.drawRect(0, 0, b.width - 1, b.height - 1);
            }
            if (this.mouseIn) {
                // empty if block
            }
            g.setColor(this.color);
            super.paint(g);
            String text = this.getText();
            Font font = g.getFont();
            FontMetrics fm = g.getFontMetrics(font);
            int width = fm.stringWidth(text);
            int y = (this.getHeight() + fm.getHeight()) / 2 - 2;
            g.drawLine(3, y, width + 3, y);
        }
    }
}

