/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.idv.ui.IdvUIManager;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import visad.DisplayEvent;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public abstract class DisplayControlBase
extends SharableImpl {
    public static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DisplayControlBase.class.getName());
    protected static ImageIcon ICON_LOCK = IdvUIManager.ICON_LOCK;
    protected static ImageIcon ICON_UNLOCK = IdvUIManager.ICON_UNLOCK;
    public static ImageIcon ICON_REMOVE = IdvUIManager.ICON_REMOVE;
    public static final String PROP_REMOVED = "prop.removed";
    public static final String PREF_LEGENDLABEL_TEMPLATE = "idv.legendlabel.template";
    public static final String PREF_EXTRALABEL_TEMPLATE = "idv.extralabel.template";
    public static final String PREF_DISPLAYLIST_TEMPLATE = "idv.displaylist.template";
    public static final String MACRO_SHORTNAME = "%shortname%";
    public static final String MACRO_STATION = "%station%";
    public static final String MACRO_RESOLUTION = "%resolution%";
    public static final String MACRO_LONGNAME = "%longname%";
    public static final String MACRO_VALUE = "%value%";
    public static final String MACRO_POSITION = "%position%";
    public static final String MACRO_DATASOURCENAME = "%datasourcename%";
    public static final String MACRO_DISPLAYNAME = "%displayname%";
    public static final String MACRO_DISPLAYUNIT = "%displayunit%";
    public static final String MACRO_TIMESTAMP = "%timestamp%";
    public static final String MACRO_FHOUR = "%fhour%";
    public static final String MACRO_FHOUR2 = "%fhour2%";
    public static final String CMD_COLORS = "cmd.colors";
    public static final String CMD_REMOVE = "cmd.remove";
    public static final String CMD_POPUP = "cmd.thispopup";
    public static final String CMD_COLORTABLE = "cmd.colortbl";
    public static final String CMD_BARBSIZE = "cmd.barbsize";
    public static final String CMD_INTERVAL = "cmd.interval";
    public static final String CMD_LEVEL = "cmd.level";
    public static final String CMD_LINEWIDTH = "cmd.linewidth";
    public static final String WEIGHTED_AVERAGE = "Weighted Average";
    public static final String NEAREST_NEIGHBOR = "Nearest Neighbor";
    protected static String DEFAULT_SAMPLING_MODE = "Weighted Average";
    public static final String APPEARANCE_IDV = "idv";
    public static final String APPEARANCE_DARK = "dark";
    public static final String APPEARANCE_LIGHT = "light";
    protected static final Insets GRID_INSETS = new Insets(4, 4, 4, 4);
    public static final String SHARE_POSITION = "DisplayControlImpl.SHARE_POSITION";
    public static final String SHARE_TRANSECT = "DisplayControlImpl.SHARE_TRANSECT";
    public static final String SHARE_DISPLAYUNIT = "DisplayControlImpl.SHARE_DISPLAYUNIT";
    public static final String SHARE_VISIBILITY = "DisplayControlImpl.SHARE_VISIBILITY";
    public static final String SHARE_COLORTABLE = "DisplayControlImpl.SHARE_COLORTABLE";
    public static final String SHARE_COLORSCALE = "DisplayControlImpl.SHARE_COLORSCALE";
    public static final String SHARE_COLOR = "DisplayControlImpl.SHARE_COLOR";
    public static final String SHARE_SELECTRANGE = "DisplayControlImpl.SHARE_SELECTRANGE";
    public static final String SHARE_CHOICES = "DisplayControlImpl.SHARE_CHOICES";
    public static final String SHARE_SKIPVALUE = "DisplayControlImpl.SHARE_SKIPVALUE";
    public static final int FLAG_CONTOUR = 2;
    public static final int FLAG_COLOR = 4;
    public static final int FLAG_COLORTABLE = 8;
    public static final int FLAG_DATACONTROL = 16;
    public static final int FLAG_DISPLAYUNIT = 32;
    public static final int FLAG_COLORUNIT = 64;
    public static final int FLAG_ZPOSITION = 128;
    public static final int FLAG_SELECTRANGE = 256;
    public static final int FLAG_TIMERANGE = 512;
    public static final int FLAG_LINEWIDTH = 1024;
    public static final int FLAG_SKIPFACTOR = 2048;
    public static final int FLAG_TEXTUREQUALITY = 4096;
    public static final int FLAG_SMOOTHING = 8192;
    public static final int FLAG_GRIDTRAJECTORY = 1;
    public static final int FLAG_NONE = 0;
    public static final int DEFAULT_POINT_SIZE = 5;
    public static final String LABEL_NONE = "None";
    public static final String FIND_THIS = "this";
    public static final String FIND_ALL = "all";
    public static final String FIND_CLASS = "class:";
    public static final String FIND_CATEGORY = "category:";
    public static final String FIND_WITHDATA = "withdata";
    public static final String FIND_WITHTHISDATA = "withthisdata";
    public static final String FIND_WITHTHISFIELD = "withthisfield";
    public static final String FIND_SPECIAL = "special";
    public static final String FIND_WITHTHISVIEW = "withthisview";
    public static final String SETTINGS_GROUP_DISPLAY = "Display";
    public static final String SETTINGS_GROUP_FLAGS = "Flags";
    private Hashtable tmpProperties;

    public Object getTmpProperty(Object key) {
        if (this.tmpProperties != null) {
            return this.tmpProperties.get(key);
        }
        return null;
    }

    public void putTmpProperty(Object key, Object value) {
        if (this.tmpProperties == null) {
            this.tmpProperties = new Hashtable();
        }
        this.tmpProperties.put(key, value);
    }

    public Object removeTmpProperty(Object key) {
        if (this.tmpProperties != null) {
            return this.tmpProperties.remove(key);
        }
        return null;
    }

    public static void setStations(List stationList, JComboBox box) {
        DisplayControlBase.setStations(stationList, box, true);
    }

    public static void setStations(List stationList, JComboBox box, boolean addMessage) {
        ArrayList<Object> tfos = new ArrayList<Object>();
        int size = 30;
        for (int i = 0; i < stationList.size(); ++i) {
            tfos.add(DisplayControlBase.createStationTfo(stationList.get(i)));
        }
        if (addMessage) {
            tfos.add(0, "--Select a location--");
        }
        GuiUtils.setListData(box, tfos);
    }

    public static TwoFacedObject createStationTfo(Object o) {
        String label;
        int size = 35;
        if (o instanceof NamedStationImpl) {
            label = ((NamedStationImpl)o).getName();
            String id = ((NamedStationImpl)o).getID();
            if (id != null && !Misc.equals(id, label)) {
                label = label + " (" + id + ")";
            }
        } else {
            label = o.toString();
        }
        label = label.length() > size ? label.substring(0, size - 1) : StringUtil.padRight(label, size);
        return new TwoFacedObject((Object)label, o);
    }

    public static NamedStationImpl getSelectedStation(JComboBox box) {
        Object item = box.getSelectedItem();
        if (item == null || item instanceof String) {
            return null;
        }
        if (item instanceof TwoFacedObject) {
            return (NamedStationImpl)((TwoFacedObject)item).getId();
        }
        return (NamedStationImpl)item;
    }

    public static boolean isLeftButtonDown(DisplayEvent event) {
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent == null) {
            return false;
        }
        int mods = inputEvent.getModifiers();
        return (mods & 0x10) != 0;
    }

    public abstract NavigatedDisplay getNavigatedDisplay();

    public EarthLocation toEarth(DisplayEvent event) throws VisADException, RemoteException {
        NavigatedDisplay d = this.getNavigatedDisplay();
        return d == null ? null : d.getEarthLocation(this.toBox(event));
    }

    public EarthLocation boxToEarth(double[] boxCoords) throws VisADException, RemoteException {
        return this.boxToEarth(boxCoords, true);
    }

    public EarthLocation boxToEarth(double[] boxCoords, boolean setZToZeroIfOverhead) throws VisADException, RemoteException {
        return this.boxToEarth(boxCoords[0], boxCoords[1], boxCoords[2], setZToZeroIfOverhead);
    }

    public EarthLocation boxToEarth(double x, double y, double z) throws VisADException, RemoteException {
        return this.boxToEarth(x, y, z, true);
    }

    public EarthLocation boxToEarth(double x, double y, double z, boolean setZToZeroIfOverhead) throws VisADException, RemoteException {
        NavigatedDisplay d = this.getNavigatedDisplay();
        return d == null ? null : d.getEarthLocation(x, y, z, setZToZeroIfOverhead);
    }

    public List boxToEarth(List boxPoints) throws VisADException, RemoteException {
        ArrayList<EarthLocation> els = new ArrayList<EarthLocation>();
        for (int i = 0; i < boxPoints.size(); ++i) {
            els.add(this.boxToEarth((double[])boxPoints.get(i)));
        }
        return els;
    }

    public List earthToBox(List earthLocations) throws VisADException, RemoteException {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        for (int i = 0; i < earthLocations.size(); ++i) {
            pts.add(this.earthToBox((EarthLocation)earthLocations.get(i)));
        }
        return pts;
    }

    public double[] earthToBox(EarthLocation el) throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getSpatialCoordinates(el, null);
    }

    public RealTuple earthToBoxTuple(EarthLocation el) throws VisADException, RemoteException {
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay == null) {
            return null;
        }
        return navDisplay.getSpatialCoordinates(el);
    }

    public static EarthLocation makeEarthLocation(double lat, double lon, double alt) throws VisADException, RemoteException {
        return new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt));
    }

    public double[] toBox(DisplayEvent event) throws VisADException, RemoteException {
        return this.screenToBox(event.getX(), event.getY());
    }

    public double[] screenToBox(int screenX, int screenY) throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getSpatialCoordinatesFromScreen(screenX, screenY);
    }

    public double[] screenToBox(int screenX, int screenY, double zPosition) throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getSpatialCoordinatesFromScreen(screenX, screenY, zPosition);
    }

    public double[] getScreenCenter() throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getScreenCenter();
    }

    public int[] boxToScreen(double[] xyz) throws VisADException, RemoteException {
        return this.getNavigatedDisplay().getScreenCoordinates(xyz);
    }

    public EarthLocation screenToEarth(int screenX, int screenY) throws VisADException, RemoteException {
        return this.boxToEarth(this.screenToBox(screenX, screenY));
    }

    public int[] earthToScreen(EarthLocation el) throws VisADException, RemoteException {
        return this.boxToScreen(this.earthToBox(el));
    }

    Rectangle getScreenBounds() {
        NavigatedDisplay d = this.getNavigatedDisplay();
        if (d == null) {
            return null;
        }
        Component comp = d.getDisplayComponent();
        return comp == null ? null : comp.getBounds();
    }

    protected Rectangle2D calculateRectangle() {
        try {
            Rectangle2D.Double box = this.getNavigatedDisplay().getVisadBox();
            if (!box.isEmpty()) {
                double deltaWidth = 0.05 * box.width;
                double deltaHeight = 0.05 * box.height;
                double newX = box.x - deltaWidth;
                double newY = box.y - deltaHeight;
                box.setRect(newX, newY, box.width + 2.0 * deltaWidth, box.height + 2.0 * deltaHeight);
            }
            return box;
        }
        catch (Exception excp) {
            DisplayControlBase.logException("calculating Rectangle ", excp);
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void userMessage(String msg) {
        LogUtil.userMessage(msg);
    }

    public void userErrorMessage(String message) {
        LogUtil.userErrorMessage(message);
    }

    public static void logException(Exception exc) {
        DisplayControlBase.logException("", exc);
    }

    public static void logException(String desc, Exception exc) {
        LogUtil.printException(log_, desc, exc);
    }

    protected Object[] formatLevels(Object[] levels) {
        if (levels == null) {
            return null;
        }
        Object[] tfoList = new Object[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            tfoList[i] = this.getLabeledReal(levels[i]);
        }
        return tfoList;
    }

    protected TwoFacedObject getLabeledReal(Object level) {
        if (level == null) {
            return (TwoFacedObject)level;
        }
        if (level instanceof TwoFacedObject) {
            Object lev = ((TwoFacedObject)level).getId();
            if (lev instanceof Real) {
                return (TwoFacedObject)level;
            }
        } else {
            if (level instanceof Real) {
                return Util.labeledReal((Real)level);
            }
            if (level instanceof String) {
                String tmp = (String)level;
                if ((tmp = tmp.trim()).startsWith("#")) {
                    tmp = tmp.substring(1);
                }
                try {
                    double value = Misc.parseValue(tmp);
                    return new TwoFacedObject((Object)tmp, new Real(value));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        DisplayControlBase.userMessage("Unable to handle a level of type " + level.getClass().getName() + " level=" + level);
        return null;
    }

    protected Real getLevelReal(Object level) {
        if (level == null) {
            return (Real)level;
        }
        if (level instanceof TwoFacedObject) {
            Object lev = ((TwoFacedObject)level).getId();
            if (lev instanceof Real) {
                return (Real)lev;
            }
        } else {
            if (level instanceof Real) {
                return (Real)level;
            }
            if (level instanceof String) {
                try {
                    return Util.toReal(level.toString());
                }
                catch (Exception e) {
                    System.err.println("error parsing level: " + level + " " + e);
                }
            }
        }
        DisplayControlBase.userMessage("Unable to handle a level of type " + level.getClass().getName() + " level=" + level);
        return null;
    }
}

