/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.CrossSectionControl;
import ucar.unidata.idv.control.RangeWidget;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.TrackDisplayable;
import ucar.visad.display.XSDisplay;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Length;
import visad.AxisScale;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;

public class DataTransectControl
extends CrossSectionControl {
    private Range lineRange;
    private JLabel rangeLabel;
    int lineWidth = 2;

    public DataTransectControl() {
        this.setAttributeFlags(52);
    }

    @Override
    protected void createCrossSectionSelector() throws VisADException, RemoteException {
        NavigatedDisplay mapDisplay = this.getNavigatedDisplay();
        double[] right = mapDisplay.getScreenUpperRight();
        double[] center = mapDisplay.getScreenCenter();
        right[1] = center[1];
        double width = right[0] - center[0];
        EarthLocationTuple loc1 = (EarthLocationTuple)mapDisplay.getEarthLocation(center[0], center[1], 0.0, false);
        EarthLocationTuple loc2 = (EarthLocationTuple)mapDisplay.getEarthLocation(center[0] + 0.6 * width, right[1], 0.0, false);
        this.createCrossSectionSelector(loc1, loc2);
    }

    @Override
    protected int getSelectorAttributeFlags() {
        return 132;
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Line Width: "), this.doMakeWidthSlider()));
    }

    private Component doMakeWidthSlider() {
        final JLabel lineWidthLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft("" + this.getLineWidth(), 3));
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slide = (JSlider)e.getSource();
                if (slide.getValueIsAdjusting()) {
                    return;
                }
                DataTransectControl.this.setLineWidth(slide.getValue());
                lineWidthLbl.setText(StringUtil.padLeft("" + DataTransectControl.this.getLineWidth(), 3));
            }
        };
        JComponent[] sliderComps = GuiUtils.makeSliderPopup(1, 20, this.getLineWidth(), listener);
        JSlider slider = (JSlider)sliderComps[1];
        sliderComps[0].setToolTipText("Change Line Width");
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.setToolTipText("Change width of line");
        slider.setMajorTickSpacing(5);
        slider.setMinorTickSpacing(1);
        slider.setSnapToTicks(true);
        return GuiUtils.left(GuiUtils.hbox((Component)lineWidthLbl, (Component)new JLabel(" "), sliderComps[0]));
    }

    @Override
    protected DisplayableData createVCSDisplay() throws VisADException, RemoteException {
        TrackDisplayable line = new TrackDisplayable("dcs_" + this.paramName);
        line.setLineWidth(this.lineWidth);
        this.addAttributedDisplayable(line, 8);
        return line;
    }

    @Override
    protected DisplayableData createXSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("dcs_" + this.paramName, true);
        display.setLineWidth(this.lineWidth);
        this.addAttributedDisplayable(display, 8);
        return display;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.init(dataChoice)) {
            return false;
        }
        this.getCrossSectionViewManager().getXSDisplay().setName("Data Cross Section ");
        return true;
    }

    @Override
    protected void load2DData(FieldImpl twoDData) throws VisADException, RemoteException {
        if (twoDData == null) {
            return;
        }
        try {
            Range[] range = GridUtil.getMinMax(twoDData);
            this.lineRange = range[0];
            Unit dataUnit = null;
            if (this.getGridDataInstance() != null) {
                dataUnit = this.getGridDataInstance().getRawUnit(0);
            }
            if (!Misc.equals(this.displayUnit, dataUnit)) {
                this.lineRange = this.convertRange(this.lineRange, dataUnit, this.getDisplayUnit());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getVerticalAxisRange() == null) {
            this.setVerticalAxisRange(this.getRange());
        }
        ((TrackDisplayable)this.getVerticalCSDisplay()).setTrack(twoDData);
    }

    @Override
    public Range getLineRange() {
        return this.lineRange;
    }

    @Override
    public void addToRangeMenu(final RangeWidget rw, List items) {
        super.addToRangeMenu(rw, items);
        if (this.lineRange == null) {
            return;
        }
        JMenuItem mi = new JMenuItem("From Line");
        items.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                rw.setRangeDialog(DataTransectControl.this.convertColorRange(DataTransectControl.this.lineRange));
            }
        });
    }

    @Override
    protected void applyDisplayUnit() throws VisADException, RemoteException {
        super.applyDisplayUnit();
        this.getCrossSectionViewManager().getXSDisplay().setYDisplayUnit(this.getDisplayUnit());
    }

    @Override
    protected void applyRange() throws VisADException, RemoteException {
        super.applyRange();
        XSDisplay xsDisplay = this.getCrossSectionViewManager().getXSDisplay();
        xsDisplay.setYDisplayUnit(this.getDisplayUnit());
        if (!this.getAutoScaleYAxis()) {
            this.setYAxisRange(xsDisplay, this.getVerticalAxisRange());
        }
    }

    @Override
    protected String getCrossSectionViewLabel() {
        return "Data Transect";
    }

    @Override
    protected void updateViewParameters() throws VisADException, RemoteException {
        super.updateViewParameters();
        XSDisplay xsDisplay = this.getCrossSectionViewManager().getXSDisplay();
        if (this.getGridDataInstance() != null) {
            xsDisplay.setYAxisType(this.getGridDataInstance().getRealType(0));
            this.applyRange();
            AxisScale yAxis = xsDisplay.getYAxisScale();
            yAxis.setTitle(this.paramName);
            yAxis.setColor(Color.blue);
            yAxis.setSnapToBox(true);
        }
    }

    @Override
    protected void setYAxisRange(XSDisplay display, Range range) throws VisADException, RemoteException {
        if (range == null) {
            range = this.getVerticalAxisRange();
        }
        if (range == null) {
            range = this.getRange();
        }
        if (range != null) {
            display.setYRange(range.getMin(), range.getMax());
        }
    }

    @Override
    protected GriddedSet make2DDomainSet(GriddedSet domainSet) throws VisADException, RemoteException {
        int sizeX = domainSet.getLengths()[0];
        CoordinateSystem transform = domainSet.getCoordinateSystem();
        int lonIndex = GridUtil.isLatLonOrder(domainSet) ? 1 : 0;
        int latIndex = 1 - lonIndex;
        float[][] transformed = domainSet.getSamples();
        transformed = CoordinateSystem.transformCoordinates(lonIndex == 0 ? RealTupleType.SpatialEarth2DTuple : RealTupleType.LatitudeLongitudeTuple, (CoordinateSystem)null, new Unit[]{CommonUnit.degree, CommonUnit.degree}, (ErrorEstimate[])null, ((SetType)domainSet.getType()).getDomain(), transform, domainSet.getSetUnits(), (ErrorEstimate[])null, transformed, false);
        float[][] plane = new float[][]{this.createXFromLatLon(new float[][]{transformed[0], transformed[1]}, sizeX, lonIndex)};
        RealType xType = null;
        if (this.crossSectionView != null) {
            XSDisplay xs = this.crossSectionView.getXSDisplay();
            xType = xs.getXAxisType();
        } else {
            xType = Length.getRealType();
        }
        Gridded1DSet csDS = new Gridded1DSet((MathType)new RealTupleType(xType), (float[][])plane, plane[0].length, (CoordinateSystem)null, new Unit[]{CommonUnits.KILOMETER}, (ErrorEstimate[])null);
        return csDS;
    }

    @Override
    public void setLineWidth(int width) {
        try {
            if (this.getVerticalCSDisplay() != null) {
                this.getVerticalCSDisplay().setLineWidth(width);
            }
            if (this.getXSDisplay() != null) {
                this.getXSDisplay().setLineWidth(width);
            }
            this.lineWidth = width;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }
}

