/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.gis.Transect;
import ucar.unidata.data.grid.GridDataInstance;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.ControlContext;
import ucar.unidata.idv.CrossSectionViewManager;
import ucar.unidata.idv.MapViewManager;
import ucar.unidata.idv.TransectViewManager;
import ucar.unidata.idv.VerticalXSDisplay;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.RangeDialog;
import ucar.unidata.idv.control.ReadoutInfo;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.Coord;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.view.geoloc.NavigatedDisplay;
import ucar.visad.Util;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.CrossSectionSelector;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.GridDisplayable;
import ucar.visad.display.XSDisplay;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Length;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.util.DataUtility;

public abstract class CrossSectionControl
extends GridDisplayControl
implements DisplayableData.DragAdapter {
    public static final String SHARE_XSLINE = "DisplayControlImpl.SHARE_TRANSECT";
    protected DisplayableData vcsDisplay;
    protected DisplayableData xsDisplay;
    protected CrossSectionSelector csSelector;
    private RealTuple initStartPoint;
    private RealTuple initEndPoint;
    private double initLat1 = Double.NaN;
    private double initLon1 = Double.NaN;
    private double initLat2 = Double.NaN;
    private double initLon2 = Double.NaN;
    private double initAlt = 16000.0;
    private boolean lineVisible = true;
    protected CrossSectionViewManager crossSectionView;
    private Container viewContents;
    private boolean autoScaleYAxis = true;
    private boolean allowAutoScale = true;
    private Color foreground;
    private Color background;
    private double[] displayMatrix;
    private AnimationInfo animationInfo = new AnimationInfo();
    protected CoordinateSystem coordTrans;
    private boolean autoUpdate = true;
    protected int sizeX;
    protected int sizeY;
    protected boolean displayIs3D = false;
    protected boolean dataIs3D = false;
    protected Coord startCoord;
    protected Coord endCoord;
    private String positionText;
    protected EarthLocation startLocation;
    protected EarthLocation endLocation;
    private LatLonPointImpl workLLP = new LatLonPointImpl();
    private LatLonPointImpl startLLP = new LatLonPointImpl();
    private JLabel locationLabel;
    private String ANIMATE_TOP_BOTTOM = "Top to Bottom";
    private String ANIMATE_BOTTOM_TOP = "Bottom to Top";
    private String ANIMATE_LEFT_RIGHT = "Left to Right";
    private String ANIMATE_RIGHT_LEFT = "Right to Left";
    private Transect lastTransect;
    private Range verticalAxisRange = null;
    LatLonWidget startLLW;
    LatLonWidget endLLW;
    private JLabel rangeLabel;
    private JCheckBox autoscaleCbx;
    private JButton rdButton;
    private List levelsList;
    private String OldSmoothingType = "None";
    private int OldSmoothingFactor = 0;
    int skipValue = 0;
    Range dataVerticalRange = null;

    public CrossSectionControl() {
        this.setAttributeFlags(52);
    }

    protected abstract DisplayableData createXSDisplay() throws VisADException, RemoteException;

    protected abstract DisplayableData createVCSDisplay() throws VisADException, RemoteException;

    public GridDisplayable getGridDisplayable() {
        return (GridDisplayable)((Object)this.xsDisplay);
    }

    public DisplayableData getVerticalCSDisplay() {
        return this.vcsDisplay;
    }

    public DisplayableData getXSDisplay() {
        return this.xsDisplay;
    }

    public CrossSectionSelector getCrossSectionSelector() {
        return this.csSelector;
    }

    @Override
    public void initAfterUnPersistence(ControlContext vc, Hashtable properties, List preSelectedDataChoices) {
        boolean matchDisplayRegion;
        if (this.version < 2.2 && this.getZPosition() == -1.0) {
            try {
                this.setZPosition(0.95);
            }
            catch (Exception exc) {
                CrossSectionControl.logException("Setting z position", exc);
            }
        }
        if (matchDisplayRegion = this.getIdv().getStateManager().getProperty("idv.usedisplayarea", false)) {
            this.setStartPoint(null);
            this.setEndPoint(null);
        }
        super.initAfterUnPersistence(vc, properties, preSelectedDataChoices);
    }

    protected CrossSectionViewManager getCrossSectionViewManager() {
        return this.crossSectionView;
    }

    @Override
    public ViewManager getViewManagerForCapture(String what) throws Exception {
        this.setMainPanelDimensions();
        if (!this.getIdv().getArgsManager().getIsOffScreen()) {
            GuiUtils.showComponentInTabs(this.getMainPanel());
        }
        return this.getCrossSectionViewManager();
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        XSDisplay csvxsDisplay;
        this.displayIs3D = this.isDisplay3D();
        this.levelsList = dataChoice.getAllLevels(null);
        this.xsDisplay = this.createXSDisplay();
        this.vcsDisplay = this.createVCSDisplay();
        if (!this.setData(dataChoice)) {
            return false;
        }
        this.vcsDisplay.setVisible(true);
        if (this.crossSectionView != null) {
            this.crossSectionView.initAfterUnPersistence(this.getIdv());
        } else {
            this.crossSectionView = new CrossSectionViewManager(this.getViewContext(), new ViewDescriptor("CrossSectionView"), "showControlLegend=false;showScales=true", this.animationInfo);
            this.crossSectionView.setIsShared(false);
            this.crossSectionView.setAniReadout(false);
            if (this.displayMatrix != null) {
                csvxsDisplay = this.crossSectionView.getXSDisplay();
                csvxsDisplay.setProjectionMatrix(this.displayMatrix);
            }
        }
        csvxsDisplay = this.crossSectionView.getXSDisplay();
        this.addViewManager(this.crossSectionView);
        this.setYAxisRange(csvxsDisplay, this.verticalAxisRange);
        csvxsDisplay.setXDisplayUnit(this.getDefaultDistanceUnit());
        csvxsDisplay.setYDisplayUnit(csvxsDisplay.getYDisplayUnit());
        if (this.haveMultipleFields()) {
            this.addDisplayable((Displayable)this.vcsDisplay, this.crossSectionView, 72);
        } else {
            this.addDisplayable((Displayable)this.vcsDisplay, this.crossSectionView);
        }
        if (this.displayIs3D) {
            if (this.haveMultipleFields()) {
                this.addDisplayable((Displayable)this.xsDisplay, 72);
            } else {
                this.addDisplayable(this.xsDisplay);
            }
        }
        ViewManager vm = this.getViewManager();
        this.createCrossSectionSelector();
        if (vm instanceof MapViewManager) {
            if (this.csSelector != null) {
                this.csSelector.setPointSize(this.getDisplayScale());
                this.csSelector.setAutoSize(true);
                this.csSelector.setVisible(this.lineVisible);
                this.addDisplayable((Displayable)this.csSelector, this.getSelectorAttributeFlags());
            } else {
                System.err.println("NO CS SELECTOR " + this.getClass().getName());
            }
        } else if (vm instanceof TransectViewManager) {
            this.xsDisplay.setAdjustFlow(false);
            this.setUseFastRendering(true);
        }
        this.loadDataFromLine();
        return true;
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(this.getVerticalAxisRange(), "verticalAxisRange", "Vertical Scale", "Display");
        if (this.getAllowAutoScale()) {
            dsd.addPropertyValue(new Boolean(this.getAutoScaleYAxis()), "autoScaleYAxis", "Auto-Scale", "Display");
        }
    }

    @Override
    public List getCursorReadoutInner(EarthLocation el, Real animationValue, int animationStep, List<ReadoutInfo> samples) throws Exception {
        if (!this.isInTransectView()) {
            return null;
        }
        return null;
    }

    protected int getSelectorAttributeFlags() {
        return 132;
    }

    @Override
    public MapProjection getDataProjection() {
        FieldImpl data;
        MapProjection mp = null;
        if (this.getGridDataInstance() != null && (data = this.getGridDataInstance().getGrid(false)) != null) {
            try {
                double[][] xy = null;
                mp = GridUtil.getNavigation(data);
                RealTupleType type = mp.getReference();
                if (mp instanceof TrivialMapProjection && type.getComponent(0).equals(RealType.Longitude) && type.getComponent(1).equals(RealType.Latitude) && mp.getDefaultMapArea().getX() > 180.0) {
                    Rectangle2D bounds = this.normalizeRectangle(mp.getDefaultMapArea());
                    mp = new TrivialMapProjection(mp.getReference(), bounds);
                }
            }
            catch (Exception e) {
                mp = null;
            }
        }
        return mp != null ? mp : super.getDataProjection();
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            RealTuple start = this.initStartPoint;
            RealTuple end = this.initEndPoint;
            if (start == null && this.initLat1 == this.initLat1 && this.initLon1 == this.initLon1) {
                start = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{this.initLon1, this.initLat1, this.initAlt});
            }
            if (end == null && this.initLat2 == this.initLat2 && this.initLon2 == this.initLon2) {
                end = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{this.initLon2, this.initLat2, this.initAlt});
            }
            if (this.csSelector != null) {
                if (this.inGlobeDisplay()) {
                    this.csSelector.setInterpolateLinePoints(true);
                }
                if (this.startCoord != null && this.endCoord != null) {
                    EarthLocation startLoc = this.boxToEarth(new double[]{this.startCoord.getX(), this.startCoord.getY(), this.startCoord.getZ()});
                    EarthLocation endLoc = this.boxToEarth(new double[]{this.endCoord.getX(), this.endCoord.getY(), this.endCoord.getZ()});
                    this.setPosition(startLoc, endLoc);
                } else if (start == null) {
                    MapProjection mp = this.getDataProjection();
                    Rectangle2D rect = mp.getDefaultMapArea();
                    LatLonPoint startLLP = mp.getLatLon(new double[][]{{rect.getX()}, {rect.getCenterY()}});
                    LatLonPoint endLLP = mp.getLatLon(new double[][]{{rect.getX() + rect.getWidth()}, {rect.getCenterY()}});
                    if (startLLP.getLatitude().isMissing() || startLLP.getLongitude().isMissing() || endLLP.getLatitude().isMissing() || endLLP.getLongitude().isMissing()) {
                        startLLP = mp.getLatLon(new double[][]{{rect.getCenterX() - rect.getWidth() / 10.0}, {rect.getCenterY() - rect.getHeight() / 10.0}});
                        endLLP = mp.getLatLon(new double[][]{{rect.getCenterX() + rect.getWidth() / 10.0}, {rect.getCenterY() + rect.getHeight() / 10.0}});
                    }
                    EarthLocationTuple startLoc = new EarthLocationTuple(startLLP.getLatitude().getValue(), startLLP.getLongitude().getValue(), 0.0);
                    EarthLocationTuple endLoc = new EarthLocationTuple(endLLP.getLatitude().getValue(), endLLP.getLongitude().getValue(), 0.0);
                    this.setPosition(startLoc, endLoc);
                } else {
                    this.csSelector.setPosition(start, end);
                }
                this.csSelector.getStartSelectorPoint().setDragAdapter(this);
                this.csSelector.getEndSelectorPoint().setDragAdapter(this);
            }
            this.reScale();
            this.loadDataFromLine();
            this.updateViewParameters();
        }
        catch (Exception e) {
            CrossSectionControl.logException("Initializing the csSelector", e);
        }
        this.csSelector.addPropertyChangeListener(this);
        this.updatePositionWidget();
    }

    @Override
    public boolean handleDragDirect(VisADRay ray, boolean first, int mouseModifiers) {
        return true;
    }

    @Override
    public boolean handleAddPoint(float[] x) {
        return true;
    }

    @Override
    public void doExport(String what, String filename) throws Exception {
        throw new IllegalArgumentException("doExport not implemented");
    }

    public EarthLocation boxToEarth(RealTuple tuple) throws RemoteException, VisADException {
        return this.boxToEarth(((Real)tuple.getComponent(0)).getValue(), ((Real)tuple.getComponent(1)).getValue(), tuple.getDimension() > 2 ? ((Real)tuple.getComponent(2)).getValue() : 0.0);
    }

    @Override
    public boolean constrainDragPoint(float[] position) {
        try {
            double altitude = this.getSelectorAltitude();
            EarthLocation pt = this.boxToEarth(position[0], position[1], position[2], false);
            double[] xyz = this.earthToBox(new EarthLocationTuple(pt.getLatitude().getValue(), pt.getLongitude().getValue(), altitude));
            if (this.inGlobeDisplay()) {
                position[0] = (float)xyz[0];
                position[1] = (float)xyz[1];
                position[2] = (float)xyz[2];
            } else {
                position[2] = (float)xyz[2];
            }
            return true;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    protected void getMacroNames(List names, List labels) {
        super.getMacroNames(names, labels);
        names.addAll(Misc.newList("%position%"));
        labels.addAll(Misc.newList("Cross Section Position"));
    }

    @Override
    protected void addLabelMacros(String template, List patterns, List values) {
        super.addLabelMacros(template, patterns, values);
        patterns.add("%position%");
        values.add(this.positionText);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            this.crossSectionChanged();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        if (this.viewContents != null) {
            Container parent = this.viewContents.getParent();
            if (parent != null) {
                parent.remove(this.viewContents);
            }
            this.viewContents = null;
        }
    }

    @Override
    public void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        if (this.crossSectionView != null) {
            jtp.add(this.getCrossSectionViewLabel(), this.crossSectionView.getPropertiesComponent());
        }
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.crossSectionView != null && this.crossSectionView.isPropsComponentInstantiated()) {
            return this.crossSectionView.applyProperties();
        }
        return true;
    }

    private String fmt(double latlon) {
        return this.getDisplayConventions().formatLatLon(latlon);
    }

    private void updatePositionWidget() {
        try {
            if (this.startLLW == null) {
                return;
            }
            EarthLocation[] coords = this.getLineCoords();
            this.startLLW.setLatLon(this.fmt(coords[0].getLatitude().getValue()), this.fmt(coords[0].getLongitude().getValue()));
            this.endLLW.setLatLon(this.fmt(coords[1].getLatitude().getValue()), this.fmt(coords[1].getLongitude().getValue()));
        }
        catch (Exception exc) {
            CrossSectionControl.logException("Error setting position ", exc);
        }
    }

    private void setPositionFromWidget() {
        try {
            this.setPosition(new EarthLocationTuple(new Real(RealType.Latitude, this.startLLW.getLat()), new Real(RealType.Longitude, this.startLLW.getLon()), new Real(RealType.Altitude, this.getSelectorAltitude())), new EarthLocationTuple(new Real(RealType.Latitude, this.endLLW.getLat()), new Real(RealType.Longitude, this.endLLW.getLon()), new Real(RealType.Altitude, this.getSelectorAltitude())));
        }
        catch (Exception exc) {
            CrossSectionControl.logException("Error setting position ", exc);
        }
    }

    @Override
    public Container doMakeContents() {
        try {
            MyTabbedPane tab = new MyTabbedPane();
            tab.add("Display", GuiUtils.inset((Component)this.getDisplayTabComponent(), 5));
            tab.add("Settings", GuiUtils.inset((Component)GuiUtils.top(this.doMakeWidgetComponent()), 5));
            tab.setSelectedIndex(1);
            GuiUtils.handleHeavyWeightComponentsInTabs(tab);
            return tab;
        }
        catch (Exception exc) {
            CrossSectionControl.logException("doMakeContents", exc);
            return null;
        }
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        if (this.isInTransectView()) {
            items.add(GuiUtils.makeCheckboxMenuItem("Auto-Update", this, "autoUpdate", null));
        }
        super.getEditMenuItems(items, forMenuBar);
    }

    protected JComponent getDisplayTabComponent() {
        ActionListener llListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CrossSectionControl.this.setPositionFromWidget();
            }
        };
        this.startLLW = new LatLonWidget("Lat: ", "Lon: ", llListener);
        this.endLLW = new LatLonWidget("Lat: ", "Lon: ", llListener);
        JPanel locationComp = GuiUtils.hbox(new Component[]{GuiUtils.rLabel("Location:"), GuiUtils.filler(5, 5), this.startLLW, GuiUtils.cLabel("  To  "), this.endLLW}, 3);
        this.viewContents = this.crossSectionView.getContents();
        if (this.foreground != null) {
            this.crossSectionView.setColors(this.foreground, this.background);
        }
        this.crossSectionView.setContentsBorder(null);
        return GuiUtils.centerBottom(this.viewContents, GuiUtils.left(locationComp));
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Vertical Scale:"), GuiUtils.left(this.doMakeVerticalRangeWidget())));
    }

    private Component doMakeVerticalRangeWidget() {
        this.rangeLabel = new JLabel("  Range: ");
        this.rdButton = new JButton("Change");
        this.rdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RangeDialog rd = new RangeDialog(CrossSectionControl.this, CrossSectionControl.this.getVerticalAxisRange(), "Change Vertical Axis Range", "setVerticalAxisRange");
                rd.showDialog();
                Range r = CrossSectionControl.this.getVerticalAxisRange();
                CrossSectionControl.this.rangeLabel.setText("  Range: " + CrossSectionControl.this.getDisplayConventions().format(r.getMin()) + "/" + CrossSectionControl.this.getDisplayConventions().format(r.getMax()));
            }
        });
        JPanel c = GuiUtils.hbox(this.rdButton, this.rangeLabel);
        if (this.getAllowAutoScale()) {
            this.autoscaleCbx = GuiUtils.makeCheckbox("Auto-scale?", this, "autoScaleYAxis");
            c = GuiUtils.leftRight(c, this.autoscaleCbx);
            if (this.autoscaleCbx.isSelected()) {
                this.rdButton.setEnabled(false);
            }
        }
        return c;
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        Unit newUnit;
        if (!super.setData(dataChoice)) {
            return false;
        }
        this.dataIs3D = this.getGridDataInstance().is3D();
        if (this.dataIs3D) {
            this.sizeX = this.getGridDataInstance().getSizeX();
            this.sizeY = this.getGridDataInstance().getSizeY();
            this.coordTrans = this.getGridDataInstance().getThreeDCoordTrans();
        } else {
            GriddedSet domainSet = (GriddedSet)this.getGridDataInstance().getSpatialDomain();
            this.sizeX = domainSet.getLengths()[0];
            this.sizeY = domainSet.getLengths()[1];
            this.coordTrans = domainSet.getCoordinateSystem();
        }
        if (this.xsDisplay == null) {
            this.xsDisplay = this.createXSDisplay();
            this.vcsDisplay = this.createVCSDisplay();
        }
        this.getGridDisplayable().setColoredByAnother(this.haveMultipleFields());
        if (this.getVerticalCSDisplay() instanceof GridDisplayable) {
            ((GridDisplayable)((Object)this.getVerticalCSDisplay())).setColoredByAnother(this.haveMultipleFields());
        }
        if (this.isTopography(this.getRawDataUnit()) && !this.dataIs3D) {
            this.addTopographyMap();
        }
        if (this.getHaveInitialized()) {
            this.loadDataFromLine();
        }
        if ((newUnit = this.getDisplayUnit()) != null && !newUnit.equals(this.getRawDataUnit()) && Unit.canConvert(newUnit, this.getRawDataUnit())) {
            this.xsDisplay.setDisplayUnit(newUnit);
            this.vcsDisplay.setDisplayUnit(newUnit);
        }
        if (this.getHaveInitialized()) {
            this.updateViewParameters();
        }
        this.setXAxisTitle();
        String magStr = (String)dataChoice.getProperty("MAG");
        if (dataChoice instanceof DerivedDataChoice) {
            DerivedDataChoice dchoice = (DerivedDataChoice)dataChoice;
            List dlist = dchoice.getChoices();
            DataChoice dc = (DataChoice)dlist.get(0);
            magStr = (String)dc.getProperty("MAG");
        }
        this.resolutionReadout = magStr != null && !magStr.isEmpty() ? magStr : null;
        return true;
    }

    protected void updateViewParameters() throws VisADException, RemoteException {
        CrossSectionViewManager vm = this.getCrossSectionViewManager();
        if (vm != null) {
            vm.setDisplayTitle("of " + this.getGridDataInstance().getDataChoice().toString());
        }
    }

    public void setStartCoord(Coord c) {
        this.startCoord = c;
    }

    public void setEndCoord(Coord c) {
        this.endCoord = c;
    }

    @Override
    public void relocateDisplay(LatLonRect originalBounds, LatLonRect newBounds, boolean useDataProjection) {
        super.relocateDisplay(originalBounds, newBounds, useDataProjection);
        double latRatio1 = 0.5;
        double lonRatio1 = 0.5;
        double latRatio2 = 0.5;
        double lonRatio2 = 0.5;
        NavigatedDisplay nd = this.getNavigatedDisplay();
        if (nd != null) {
            GeoSelection geoSelection = this.getDataSelection().getGeoSelection(true);
            this.getViewManager().setProjectionFromData(false);
            try {
                Rectangle2D.Double bbox = nd.getLatLonBox();
                Rectangle sbox = nd.getScreenBounds();
                geoSelection.setScreenBound(sbox);
                geoSelection.setLatLonRect(bbox);
                geoSelection.setUseViewBounds(true);
                this.getDataSelection().setGeoSelection(geoSelection);
                this.dataChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double deltaLat = newBounds.getLatMax() - newBounds.getLatMin();
        double deltaLon = newBounds.getLonMax() - newBounds.getLonMin();
        double nlat1 = newBounds.getLatMin() + deltaLat * latRatio1;
        double nlon1 = newBounds.getCenterLon() - Math.abs(deltaLon) * lonRatio1;
        double nlat2 = newBounds.getLatMin() + deltaLat * latRatio2;
        double nlon2 = newBounds.getCenterLon() + Math.abs(deltaLon) * lonRatio2;
        try {
            RealTuple start = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{nlon1, nlat1, this.getSelectorAltitude()});
            RealTuple end = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{nlon2, nlat2, this.getSelectorAltitude()});
            if (this.csSelector == null) {
                this.createCrossSectionSelector1(start, end);
            } else {
                this.csSelector.setPosition(start, end);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createCrossSectionSelector() throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector(new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{0.0, 0.0, 0.0}), new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{0.0, 0.0, 0.0}));
    }

    protected void createCrossSectionSelector(EarthLocation loc1, EarthLocation loc2) throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector(new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{loc1.getLongitude().getValue(), loc2.getLatitude().getValue(), 0.0}), new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{loc1.getLongitude().getValue(), loc2.getLatitude().getValue(), 0.0}));
    }

    protected void createCrossSectionSelector1(RealTuple start, RealTuple end) throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector(start, end);
    }

    private RealTuple getXYPosition(double x, double y, double z, boolean convert) throws VisADException, RemoteException {
        Coord to = convert ? this.convertToDisplay(new Coord(x, y, z)) : new Coord(x, y, z);
        RealTuple xyTuple = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{to.getX(), to.getY()});
        return xyTuple;
    }

    public Coord convertToDisplay(Coord from) throws VisADException, RemoteException {
        double[][] dArrayArray;
        SampledSet domain = GridUtil.getSpatialDomain(this.getGridDataInstance().getGrid());
        boolean latfirst = GridUtil.isLatLonOrder(domain);
        float[][] domainCoords = domain.getSamples(false);
        int lonindex = latfirst ? 1 : 0;
        int latindex = 1 - lonindex;
        int elem = from.getIntX() + (from.getIntY() + from.getIntZ() * this.sizeY) * this.sizeX;
        if (this.dataIs3D) {
            double[][] dArrayArray2 = new double[3][];
            dArrayArray2[0] = new double[]{domainCoords[0][elem]};
            dArrayArray2[1] = new double[]{domainCoords[1][elem]};
            dArrayArray = dArrayArray2;
            dArrayArray2[2] = new double[]{domainCoords[2][elem]};
        } else {
            double[][] dArrayArray3 = new double[2][];
            dArrayArray3[0] = new double[]{domainCoords[0][elem]};
            dArrayArray = dArrayArray3;
            dArrayArray3[1] = new double[]{domainCoords[1][elem]};
        }
        Object llarr = dArrayArray;
        if (this.coordTrans != null) {
            llarr = this.coordTrans.toReference((double[][])llarr, domain.getSetUnits());
        } else {
            Unit[] unitArray;
            if (this.dataIs3D) {
                Unit[] unitArray2 = new Unit[3];
                unitArray2[0] = CommonUnit.degree;
                unitArray2[1] = CommonUnit.degree;
                unitArray = unitArray2;
                unitArray2[2] = CommonUnit.meter;
            } else {
                Unit[] unitArray3 = new Unit[2];
                unitArray3[0] = CommonUnit.degree;
                unitArray = unitArray3;
                unitArray3[1] = CommonUnit.degree;
            }
            Unit[] toUnits = unitArray;
            llarr = Unit.convertTuple(llarr, domain.getSetUnits(), toUnits, false);
        }
        double lat = llarr[latindex][0];
        double lon = llarr[lonindex][0];
        double alt = this.dataIs3D ? llarr[2][0] : 0.0;
        float low = domain.getLow()[lonindex];
        float hi = domain.getHi()[lonindex];
        Unit[] units = domain.getSetUnits();
        if (this.coordTrans == null) {
            try {
                low = (float)units[lonindex].toThat(low, CommonUnit.degree);
                hi = (float)units[lonindex].toThat(hi, CommonUnit.degree);
            }
            catch (Exception exc) {
                System.err.println("Caught error:" + exc);
            }
            while ((float)lon < low && (float)lon < hi) {
                lon += 360.0;
            }
            while ((float)lon > hi && (float)lon > low) {
                lon -= 360.0;
            }
        }
        RealTuple visadTup = this.earthToBoxTuple(new EarthLocationTuple(lat, lon, alt));
        return new Coord(((Real)visadTup.getComponent(0)).getValue(), ((Real)visadTup.getComponent(1)).getValue(), ((Real)visadTup.getComponent(2)).getValue());
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals(SHARE_XSLINE)) {
            if (this.csSelector == null) {
                return;
            }
            try {
                this.csSelector.setPosition((RealTuple)data[0], (RealTuple)data[1]);
            }
            catch (Exception e) {
                CrossSectionControl.logException("Error in receiveShareData: " + dataId, e);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    @Override
    protected void applyZPosition() throws VisADException, RemoteException {
        RealTuple start;
        super.applyZPosition();
        if (this.csSelector != null && Util.isEarthCoordinates(start = this.csSelector.getStartPoint())) {
            EarthLocation[] startEnd = this.getLineCoords();
            this.setPosition(startEnd[0], startEnd[1]);
        }
    }

    protected void setPosition(EarthLocation startLoc, EarthLocation endLoc) throws VisADException, RemoteException {
        RealTuple start = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{startLoc.getLongitude().getValue(), startLoc.getLatitude().getValue(), this.getSelectorAltitude()});
        RealTuple end = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{endLoc.getLongitude().getValue(), endLoc.getLatitude().getValue(), this.getSelectorAltitude()});
        this.csSelector.setPosition(start, end);
    }

    public double getSelectorAltitude() {
        double[] range;
        double z = this.getZPosition();
        double altitude = 16000.0;
        NavigatedDisplay navDisplay = this.getNavigatedDisplay();
        if (navDisplay != null && ((range = navDisplay.getVerticalRange())[0] != 0.0 || range[1] != 0.0)) {
            double pcntOfZRange = Math.abs((z - -1.0) / 2.0);
            altitude = range[0] + pcntOfZRange * (range[1] - range[0]);
        }
        return altitude;
    }

    public void crossSectionChanged() {
        try {
            this.loadDataFromLine();
            this.updateLegendLabel();
            this.updatePositionWidget();
            CrossSectionSelector cs = this.getCrossSectionSelector();
            this.doShare((Object)SHARE_XSLINE, new Object[]{cs.getStartPoint(), cs.getEndPoint()});
        }
        catch (Exception exc) {
            CrossSectionControl.logException("Error in crossSectionChanged ", exc);
        }
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
        try {
            this.loadDataFromLine();
        }
        catch (Exception exc) {
            CrossSectionControl.logException("projectionChanged", exc);
        }
    }

    @Override
    public void viewpointChanged() {
        if (this.autoUpdate && this.isInTransectView()) {
            this.loadDataFromTransect();
        } else if (this.getMatchDisplayRegion() && this.reloadFromBounds) {
            try {
                NavigatedDisplay navDisplay = this.getMapDisplay();
                LatLonRect baseLLR = this.dataSelection.getGeoSelection().getLatLonRect();
                LatLonRect newLLR = navDisplay.getLatLonRect();
                this.relocateDisplay(baseLLR, newLLR, false);
                this.reloadFromBounds = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void getViewMenuItems(List menus, boolean forMenuBar) {
        super.getViewMenuItems(menus, forMenuBar);
        menus.add("separator");
        if (forMenuBar) {
            JMenu csvMenu = this.crossSectionView.makeViewMenu();
            csvMenu.setText(this.getCrossSectionViewLabel());
            menus.add(csvMenu);
        }
    }

    protected String getCrossSectionViewLabel() {
        return "Cross Section";
    }

    private void loadDataFromTransect() {
        try {
            ViewManager vm = this.getViewManager();
            Transect transect = ((TransectViewManager)vm).getAxisTransect();
            if (Misc.equals(transect, this.lastTransect)) {
                return;
            }
            this.loadDataFromLine();
        }
        catch (Exception exc) {
            CrossSectionControl.logException("Loading data from transect", exc);
        }
    }

    @Override
    protected boolean shouldAddControlListener() {
        return true;
    }

    @Override
    public void transectChanged() {
        super.transectChanged();
        try {
            this.loadDataFromLine();
        }
        catch (Exception exc) {
            CrossSectionControl.logException("projectionChanged", exc);
        }
    }

    protected EarthLocation[] getLineCoords() throws VisADException, RemoteException {
        if (this.isInTransectView()) {
            ViewManager vm = this.getViewManager();
            Transect transect = ((TransectViewManager)vm).getTransect(true);
            if (transect.getPoints().size() == 2) {
                transect = ((TransectViewManager)vm).getAxisTransect();
            }
            this.lastTransect = transect;
            List points = transect.getPoints();
            EarthLocation[] llPoints = new EarthLocation[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                LatLonPointImpl llp = (LatLonPointImpl)points.get(i);
                llPoints[i] = CrossSectionControl.makeEarthLocation(llp.getLatitude(), llp.getLongitude(), 0.0);
            }
            return llPoints;
        }
        if (this.csSelector != null) {
            double z2;
            RealTuple start = this.csSelector.getStartPoint();
            RealTuple end = this.csSelector.getEndPoint();
            double x1 = ((Real)start.getComponent(0)).getValue();
            double y1 = ((Real)start.getComponent(1)).getValue();
            double x2 = ((Real)end.getComponent(0)).getValue();
            double y2 = ((Real)end.getComponent(1)).getValue();
            double z1 = start.getDimension() < 3 ? 0.0 : ((Real)start.getComponent(2)).getValue();
            double d = z2 = end.getDimension() < 3 ? 0.0 : ((Real)end.getComponent(2)).getValue();
            if (Util.isEarthCoordinates(start)) {
                return new EarthLocation[]{new EarthLocationTuple(y1, x1, 0.0), new EarthLocationTuple(y2, x2, 0.0)};
            }
            return new EarthLocation[]{this.boxToEarth(new double[]{x1, y1, 0.0}), this.boxToEarth(new double[]{x2, y2, 0.0})};
        }
        return null;
    }

    protected void loadDataFromLine() throws VisADException, RemoteException {
        if (!this.getHaveInitialized()) {
            return;
        }
        EarthLocation[] elArray = this.getLineCoords();
        if (elArray == null) {
            System.err.println(this.getClass().getName());
        }
        this.startLocation = elArray[0];
        this.endLocation = elArray[1];
        if (this.startLocation.equals(this.endLocation)) {
            return;
        }
        ArrayList<LatLonPoint> points = new ArrayList<LatLonPoint>(elArray.length);
        for (int i = 0; i < elArray.length; ++i) {
            points.add(elArray[i].getLatLonPoint());
        }
        GridDataInstance gdi = this.getGridDataInstance();
        FieldImpl slice = gdi.sliceAlongLatLonLine(points, this.getSamplingModeValue(this.getObjectStore().get("DisplayControlImpl.SamplingMode", DEFAULT_SAMPLING_MODE)));
        if (this.checkFlag(8192) && !this.getSmoothingType().equals("None")) {
            slice = GridUtil.smooth(slice, this.getSmoothingType(), this.getSmoothingFactor());
        }
        if (this.getSkipValue() > 0) {
            slice = GridUtil.subset(slice, this.getSkipValue() + 1, 1);
        }
        this.showWaitCursor();
        this.loadData(slice);
        this.showNormalCursor();
    }

    protected void loadData(FieldImpl fieldImpl) throws VisADException, RemoteException {
        FieldImpl twoDData = this.make2DData(fieldImpl);
        if (twoDData == null) {
            return;
        }
        this.getGridDisplayable().loadData(fieldImpl);
        this.load2DData(twoDData);
        this.reScale();
        this.updateLocationLabel();
    }

    protected void load2DData(FieldImpl twoDData) throws VisADException, RemoteException {
        ((GridDisplayable)((Object)this.vcsDisplay)).loadData(twoDData);
    }

    @Override
    protected void applySmoothing() throws VisADException, RemoteException {
        if (this.checkFlag(8192) && (!this.getSmoothingType().equals(this.OldSmoothingType) || this.getSmoothingFactor() != this.OldSmoothingFactor)) {
            this.OldSmoothingType = this.getSmoothingType();
            this.OldSmoothingFactor = this.getSmoothingFactor();
            this.loadDataFromLine();
        }
    }

    private void setXAxisTitle() {
        if (this.crossSectionView != null) {
            ((VerticalXSDisplay)this.crossSectionView.getXSDisplay()).setXAxisTitle();
        }
    }

    protected void reScale() throws VisADException, RemoteException {
        if (this.getAutoScaleYAxis()) {
            this.crossSectionView.getXSDisplay().autoScaleYAxis();
        } else {
            this.setYAxisRange(this.crossSectionView.getXSDisplay(), this.getVerticalAxisRange());
        }
        this.crossSectionView.getXSDisplay().reScale();
        if (this.rangeLabel != null && this.autoscaleCbx != null) {
            try {
                Range r = this.getDataVerticalRange();
                if (!this.autoscaleCbx.isSelected()) {
                    r = this.getVerticalAxisRange();
                } else if (this.getLineRange() != null) {
                    r = this.getLineRange();
                }
                this.rangeLabel.setText("  Range: " + this.getDisplayConventions().format(r.getMin()) + "/" + this.getDisplayConventions().format(r.getMax()));
                this.rangeLabel.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setVerticalAxisRange(Range range) {
        this.verticalAxisRange = range;
        if (this.crossSectionView != null) {
            try {
                this.setYAxisRange(this.crossSectionView.getXSDisplay(), range);
            }
            catch (Exception exc) {
                CrossSectionControl.logException("Setting Y Axis Range: ", exc);
            }
        }
    }

    public Range getVerticalAxisRange() {
        return this.verticalAxisRange;
    }

    protected void setYAxisRange(XSDisplay display, Range range) throws VisADException, RemoteException {
        if (range == null) {
            NavigatedDisplay mapDisplay = this.getNavigatedDisplay();
            if (mapDisplay == null) {
                return;
            }
            double[] vals = mapDisplay.getVerticalRange();
            range = new Range(vals[0], vals[1]);
            display.setYDisplayUnit(mapDisplay.getVerticalRangeUnit());
            this.verticalAxisRange = range;
        }
        display.setYRange(range.getMin(), range.getMax());
    }

    protected FieldImpl make2DData(FieldImpl xsectSequence) throws VisADException, RemoteException {
        FieldImpl grid2D = null;
        GriddedSet domainSet = null;
        if (GridUtil.isConstantSpatialDomain(xsectSequence)) {
            domainSet = (GriddedSet)GridUtil.getSpatialDomain(xsectSequence);
            if (domainSet == null) {
                return null;
            }
            GriddedSet newDomain = this.make2DDomainSet(domainSet);
            if (newDomain == null) {
                return null;
            }
            grid2D = GridUtil.setSpatialDomain(xsectSequence, newDomain);
        } else {
            Set timeSet = GridUtil.getTimeSet(xsectSequence);
            int numTimes = timeSet.getLength();
            Data[] newSamples = new FieldImpl[numTimes];
            FunctionType newType = null;
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl sample = (FieldImpl)xsectSequence.getSample(i);
                if (sample.isMissing()) continue;
                domainSet = (GriddedSet)GridUtil.getSpatialDomain(sample);
                GriddedSet newDomain = this.make2DDomainSet(domainSet);
                newSamples[i] = GridUtil.setSpatialDomain(sample, newDomain);
                if (newType != null) continue;
                newType = new FunctionType(DataUtility.getDomainType(timeSet), ((DataImpl)newSamples[i]).getType());
            }
            if (newType != null) {
                grid2D = new FieldImpl(newType, timeSet);
                grid2D.setSamples(newSamples, false, false);
            }
        }
        this.dataVerticalRange = this.getCrossSectionVerticalRange(domainSet);
        return grid2D;
    }

    public Range getCrossSectionVerticalRange(GriddedSet domainSet) throws VisADException {
        float[][] elp = GridUtil.getEarthLocationPoints(domainSet);
        float[] values = null;
        if (elp.length == 2) {
            values = elp[1];
        } else if (elp.length == 3) {
            values = elp[2];
        }
        float pMin = values[0];
        float pMax = values[0];
        for (float value : values) {
            if (pMax < value) {
                pMax = value;
            }
            if (!(pMin > value)) continue;
            pMin = value;
        }
        Range result = new Range(pMin, pMax);
        return result;
    }

    public Range getDefaultVerticalRange() {
        return new Range(0.0, 16000.0);
    }

    public Range getDataVerticalRange() {
        return this.dataVerticalRange;
    }

    protected GriddedSet make2DDomainSet(GriddedSet domainSet) throws VisADException, RemoteException {
        int[] lengths = domainSet.getLengths();
        if (lengths.length == 0 || this.dataIs3D && lengths.length < 2) {
            return null;
        }
        int sizeX = lengths[0];
        int sizeZ = this.dataIs3D ? lengths[1] : 1;
        CoordinateSystem transform = domainSet.getCoordinateSystem();
        int lonIndex = GridUtil.isLatLonOrder(domainSet) ? 1 : 0;
        int latIndex = 1 - lonIndex;
        float[][] transformed = domainSet.getSamples(true);
        transformed = this.dataIs3D ? CoordinateSystem.transformCoordinates(lonIndex == 0 ? RealTupleType.SpatialEarth3DTuple : RealTupleType.LatitudeLongitudeAltitude, (CoordinateSystem)null, new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter}, (ErrorEstimate[])null, ((SetType)domainSet.getType()).getDomain(), transform, domainSet.getSetUnits(), (ErrorEstimate[])null, transformed, false) : CoordinateSystem.transformCoordinates(lonIndex == 0 ? RealTupleType.SpatialEarth2DTuple : RealTupleType.LatitudeLongitudeTuple, (CoordinateSystem)null, new Unit[]{CommonUnit.degree, CommonUnit.degree}, (ErrorEstimate[])null, ((SetType)domainSet.getType()).getDomain(), transform, domainSet.getSetUnits(), (ErrorEstimate[])null, transformed, false);
        float[] xVals = this.createXFromLatLon(new float[][]{transformed[0], transformed[1]}, sizeX, lonIndex);
        float[][] plane = new float[2][domainSet.getLength()];
        int index = 0;
        for (int i = 0; i < sizeZ; ++i) {
            for (int j = 0; j < sizeX; ++j) {
                plane[0][index] = xVals[j];
                plane[1][index] = this.dataIs3D ? transformed[2][index] : 0.0f;
                ++index;
            }
        }
        RealType xType = null;
        if (this.crossSectionView != null) {
            XSDisplay xs = this.crossSectionView.getXSDisplay();
            xType = xs.getXAxisType();
        } else {
            xType = Length.getRealType();
        }
        RealTupleType xzRTT = new RealTupleType(xType, RealType.Altitude);
        Gridded2DSet vcsG2DS = this.dataIs3D ? new Gridded2DSet(xzRTT, plane, sizeX, sizeZ, null, new Unit[]{CommonUnits.KILOMETER, CommonUnit.meter}, null, false, false) : new Gridded2DSet((MathType)xzRTT, plane, sizeX, (CoordinateSystem)null, new Unit[]{CommonUnits.KILOMETER, CommonUnit.meter}, (ErrorEstimate[])null, false);
        return vcsG2DS;
    }

    @Override
    protected String getZPositionSliderLabel() {
        return "Selector Position:";
    }

    @Override
    public void setAnimationInfo(AnimationInfo value) {
        this.animationInfo = value;
    }

    @Override
    public AnimationInfo getAnimationInfo() {
        if (this.crossSectionView != null) {
            return this.crossSectionView.getAnimationInfo();
        }
        return this.animationInfo;
    }

    protected float[] createXFromLatLon(float[][] latlon, int numNeeded, int lonIndex) {
        int latIndex = 1 - lonIndex;
        float startLon = latlon[lonIndex][0];
        float startLat = latlon[latIndex][0];
        this.startLLP.set(startLat, startLon);
        float initXVal = 0.0f;
        float bigDelta = 0.0f;
        boolean hitJump = false;
        float[] xVals = new float[numNeeded];
        float prevLon = startLon;
        for (int i = 1; i < numNeeded; ++i) {
            float lon = latlon[lonIndex][i];
            float lat = latlon[latIndex][i];
            bigDelta = lon - prevLon;
            if ((double)bigDelta > 180.0) {
                hitJump = true;
                lon -= 360.0f;
            }
            this.workLLP.set(lat, lon);
            xVals[i] = xVals[i - 1] + (float)Bearing.calculateBearing(this.startLLP, this.workLLP).getDistance();
            this.startLLP.set(this.workLLP);
            prevLon = lon;
        }
        return xVals;
    }

    @Override
    public void applyPreferences() {
        super.applyPreferences();
        if (this.crossSectionView != null) {
            ((VerticalXSDisplay)this.crossSectionView.getXSDisplay()).setXDisplayUnit(this.getIdv().getPreferenceManager().getDefaultDistanceUnit());
        }
    }

    protected void addTopographyMap() throws VisADException, RemoteException {
        this.addTopographyMap(0);
    }

    protected void updateLocationLabel() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getDisplayConventions().formatEarthLocation(this.startLocation, false, false));
        buf.append("  to  ");
        buf.append(this.getDisplayConventions().formatEarthLocation(this.endLocation, false, false));
        this.positionText = buf.toString();
        if (this.locationLabel == null) {
            return;
        }
        this.locationLabel.setText(this.positionText);
    }

    public void setAllowAutoScale(boolean value) {
        this.allowAutoScale = value;
        if (!this.allowAutoScale) {
            this.autoScaleYAxis = false;
        }
    }

    public boolean getAllowAutoScale() {
        return this.allowAutoScale;
    }

    public void setAutoScaleYAxis(boolean value) {
        this.autoScaleYAxis = value;
        try {
            this.loadDataFromLine();
        }
        catch (Exception exc) {
            CrossSectionControl.logException("Loading data from line", exc);
        }
        if (this.autoscaleCbx != null) {
            this.autoscaleCbx.setSelected(value);
            if (this.autoscaleCbx.isSelected()) {
                this.rdButton.setEnabled(false);
                if (this.rangeLabel != null) {
                    Range r = this.getDataVerticalRange();
                    if (this.getLineRange() != null) {
                        r = this.getLineRange();
                    }
                    this.rangeLabel.setText("  Range: " + this.getDisplayConventions().format(r.getMin()) + "/" + this.getDisplayConventions().format(r.getMax()));
                }
            } else {
                this.rdButton.setEnabled(true);
                if (this.rangeLabel != null) {
                    Range r = this.getVerticalAxisRange();
                    this.rangeLabel.setText("  Range: " + this.getDisplayConventions().format(r.getMin()) + "/" + this.getDisplayConventions().format(r.getMax()));
                }
            }
        }
    }

    public boolean getAutoScaleYAxis() {
        return this.autoScaleYAxis;
    }

    public Range getLineRange() {
        return null;
    }

    private boolean isTopography(Unit u) throws VisADException {
        if (u == null) {
            return false;
        }
        return Unit.canConvert(u, CommonUnit.meter) || Unit.canConvert(u, GeopotentialAltitude.getGeopotentialMeter());
    }

    public void setAutoUpdate(boolean value) {
        this.autoUpdate = value;
    }

    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public void setCrossSectionView(CrossSectionViewManager value) {
        this.crossSectionView = value;
    }

    public CrossSectionViewManager getCrossSectionView() {
        return this.crossSectionView;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setDisplayMatrix(double[] value) {
        this.displayMatrix = value;
    }

    @Override
    public boolean canExportData() {
        return true;
    }

    @Override
    protected Data getDisplayedData() throws VisADException, RemoteException {
        if (this.xsDisplay == null || this.xsDisplay.getData() == null) {
            return null;
        }
        return this.xsDisplay.getData();
    }

    @Override
    protected double getInitialZPosition() {
        return 0.95;
    }

    public void setStartPoint(RealTuple p) {
        this.initStartPoint = p;
        if (this.csSelector != null) {
            try {
                this.csSelector.setStartPoint(this.initStartPoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RealTuple getStartPoint() throws VisADException, RemoteException {
        return this.csSelector != null ? this.csSelector.getStartPoint() : null;
    }

    public void setEndPoint(RealTuple p) {
        this.initEndPoint = p;
        if (this.csSelector != null) {
            try {
                this.csSelector.setEndPoint(this.initEndPoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public RealTuple getEndPoint() throws VisADException, RemoteException {
        return this.csSelector != null ? this.csSelector.getEndPoint() : null;
    }

    public void setLineVisible(boolean value) {
        this.lineVisible = value;
    }

    public boolean getLineVisible() {
        return this.lineVisible;
    }

    public void setInitAlt(double value) {
        this.initAlt = value;
    }

    public void setInitLat2(double value) {
        this.initLat2 = value;
    }

    public void setInitLon2(double value) {
        this.initLon2 = value;
    }

    public void setInitLat1(double value) {
        this.initLat1 = value;
    }

    public void setInitLon1(double value) {
        this.initLon1 = value;
    }

    private class MyTabbedPane
    extends JTabbedPane
    implements ChangeListener {
        boolean painted = false;

        public MyTabbedPane() {
            this.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!CrossSectionControl.this.getActive() || !CrossSectionControl.this.getHaveInitialized()) {
                return;
            }
            if (CrossSectionControl.this.crossSectionView == null || CrossSectionControl.this.crossSectionView.getContents() == null) {
                return;
            }
            if (this.getSelectedIndex() == 0) {
                CrossSectionControl.this.crossSectionView.getContents().setVisible(true);
            } else {
                CrossSectionControl.this.crossSectionView.getContents().setVisible(false);
            }
        }

        @Override
        public void paint(Graphics g) {
            if (!this.painted) {
                this.painted = true;
                this.setSelectedIndex(1);
                this.setSelectedIndex(0);
                this.repaint();
            }
            super.paint(g);
        }
    }
}

