/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import ucar.unidata.idv.control.ContLevelDialog;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import visad.Unit;

public class ContourWidget
extends ControlWidget {
    private ContourInfo contourInfo;
    private JLabel label = new JLabel("Contour:", 4);
    private JLabel rhLabel = new JLabel(" ");
    private JButton button;

    public ContourWidget(DisplayControlImpl control, ContourInfo contourInfo) {
        super(control);
        this.setContourInfo(contourInfo);
        this.button = new JButton("Change");
        this.button.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.showContourPropertiesDialog();
    }

    public void showContourPropertiesDialog() {
        Unit unit = this.getDisplayControl().getDisplayUnit();
        ContLevelDialog contDialog = new ContLevelDialog(this.displayControl, "Contour Properties Editor", unit);
        contDialog.showDialog(new ContourInfo(this.contourInfo));
    }

    public void setContourInfo(ContourInfo ci) {
        this.contourInfo = ci;
        if (ci != null) {
            Unit unit = this.getDisplayControl().getDisplayUnit();
            String unitString = "";
            if (unit != null) {
                unitString = " " + unit.toString() + " ";
            }
            this.rhLabel.setText("Interval: " + (ci.getIntervalDefined() ? this.getDisplayControl().getDisplayConventions().format(ci.getInterval()) + unitString : "Irregular"));
        }
    }

    public JButton getButton() {
        return this.button;
    }

    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void fillList(List l, int columns) {
        l.add(this.label);
        l.add(GuiUtils.doLayout(new Component[]{this.button, new Label(" "), this.rhLabel}, 3, GuiUtils.WT_NNY, GuiUtils.WT_N));
    }
}

