/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.ContourInfo;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.Contour2DDisplayable;
import ucar.visad.display.DisplayableData;
import visad.Unit;
import visad.VisADException;

public class ContourPlanViewControl
extends PlanViewControl {
    private Contour2DDisplayable contourDisplay;
    private boolean isColorFill = false;
    private boolean colorByMember = true;

    public ContourPlanViewControl() {
        this.setAttributeFlags(8234);
    }

    @Override
    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        this.contourDisplay = new Contour2DDisplayable("plan_" + this.paramName, true, this.isColorFill);
        this.addAttributedDisplayable(this.contourDisplay);
        return this.contourDisplay;
    }

    public boolean getColorFill() {
        return this.isColorFill;
    }

    Contour2DDisplayable getContourDisplay() {
        return (Contour2DDisplayable)this.getPlanDisplay();
    }

    @Override
    public ContourInfo getContourInfo() {
        ContourInfo contourInfo = super.getContourInfo();
        if (contourInfo != null) {
            contourInfo.setIsFilled(this.isColorFill);
        }
        return contourInfo;
    }

    @Override
    protected ContourInfo getDefaultContourInfo() {
        if (this.isColorFill) {
            ContourInfo contourInfo = new ContourInfo(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
            contourInfo.setIsFilled(true);
            contourInfo.setIsLabeled(false);
            this.colorByMember = false;
            return contourInfo;
        }
        return null;
    }

    @Override
    public boolean getIsRaster() {
        return this.isColorFill;
    }

    @Override
    protected void initializeDefaultContourInfo(ContourInfo contourInfo) {
        if (this.isColorFill || this.haveEnsemble) {
            contourInfo.setIsLabeled(false);
        }
    }

    @Override
    public void projectionChanged() {
        super.projectionChanged();
    }

    public void setColorFill(boolean v) {
        this.isColorFill = v;
    }

    @Override
    protected boolean setData(DataChoice data) throws VisADException, RemoteException {
        return super.setData(data);
    }

    @Override
    protected boolean haveMultipleFields() {
        return super.haveMultipleFields() || this.haveEnsemble && this.colorByMember && !this.isColorFill;
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        if (this.haveEnsemble && !this.isColorFill) {
            JCheckBox toggle = new JCheckBox("Color by Member", this.colorByMember);
            toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ContourPlanViewControl.this.colorByMember = ((JCheckBox)e.getSource()).isSelected();
                        ContourPlanViewControl.this.getContourDisplay().setColoredByAnother(ContourPlanViewControl.this.haveMultipleFields());
                        ContourPlanViewControl.this.getContourDisplay().loadData(ContourPlanViewControl.this.getSliceForDisplay(ContourPlanViewControl.this.getCurrentSlice()));
                    }
                    catch (Exception ve) {
                        DisplayControlBase.logException("colorByMember", ve);
                    }
                }
            });
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Ensembles:"), GuiUtils.leftCenter(toggle, GuiUtils.filler())));
        }
    }

    @Override
    protected void applySmoothing() throws VisADException, RemoteException {
        if (this.checkFlag(8192)) {
            super.applySmoothing();
            this.applyDisplayUnit();
        }
    }

    @Override
    protected String getColorParamName() {
        if (this.haveEnsemble) {
            if (this.isColorFill) {
                return this.paramName;
            }
            return GridUtil.ENSEMBLE_TYPE.getName();
        }
        if (this.haveMultipleFields() && this.getGridDataInstance() != null) {
            return this.getGridDataInstance().getDataChoice().getIndexedName(this.getColorRangeIndex());
        }
        return this.paramName;
    }

    public void setColorByMember(boolean yesorno) {
        this.colorByMember = yesorno;
    }

    public boolean getColorByMember() {
        return this.colorByMember;
    }

    @Override
    protected Unit getColorUnit() {
        if (this.colorByMember) {
            return null;
        }
        return super.getColorUnit();
    }
}

