/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ucar.unidata.idv.control.ControlWidget;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.RangeColorPreview;
import ucar.unidata.idv.control.RangeWidget;
import ucar.unidata.ui.colortable.ColorTableEditor;
import ucar.unidata.ui.colortable.ColorTableManager;
import ucar.unidata.util.ColorTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.Range;
import ucar.unidata.util.Removable;
import visad.VisADException;

public class ColorTableWidget
extends ControlWidget
implements PropertyChangeListener,
RangeWidget,
Removable {
    private String whichColorTable = "default";
    private ColorTableEditor myEditor;
    Range range;
    List colorPreviews = new ArrayList();
    ColorTable colorTable;
    ColorTable oldTable;
    Range oldRange;
    JButton popupBtn;
    private JTextField rangeMinField;
    private JTextField rangeMaxField;
    private JButton rangePopupBtn;
    private final String CMD_RANGE_DEFAULT = "cmd.range.default";
    private final String CMD_RANGE_DATA = "cmd.range.data";
    private final String CMD_RANGE_COLORTABLE = "cmd.range.colortable";
    private ColorTableManager colorTableManager;

    public ColorTableWidget(DisplayControlImpl theDisplayControl, ColorTableManager colorTableManager, ColorTable ct, Range r) throws RemoteException, VisADException {
        super(theDisplayControl);
        this.colorTableManager = colorTableManager;
        this.init(theDisplayControl, ct, r);
    }

    public ColorTableWidget(DisplayControlImpl theDisplayControl, ColorTable ct) throws RemoteException, VisADException {
        super(theDisplayControl);
        this.init(theDisplayControl, ct, null);
    }

    private void init(DisplayControlImpl theDisplayControl, ColorTable ct, Range r) throws RemoteException, VisADException {
        this.colorTable = new ColorTable(ct);
        if (this.colorTable == null) {
            this.colorTable = this.colorTableManager.getDefaultColorTable();
        }
        this.setRange(r);
        this.popupBtn = new JButton(this.colorTable.getName());
        this.popupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorTableWidget.this.showMenu(ColorTableWidget.this.popupBtn);
            }
        });
    }

    private JComponent doMakePreview(boolean forMain, int legendType) {
        try {
            MyColorPreview preview = new MyColorPreview(this, this.colorTable.getColorList(), forMain, legendType);
            this.colorPreviews.add(preview);
            preview.setRange(this.range, this.displayControl.getColorUnit());
            return preview.doMakeContents();
        }
        catch (Exception exc) {
            this.logException("Creating preview panel", exc);
            return new JPanel();
        }
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.myEditor != null) {
            this.myEditor.doClose();
            this.myEditor = null;
        }
    }

    public JComponent getLegendPanel(int legendType) {
        return this.doMakePreview(false, legendType);
    }

    private void handleNewRange(Range newRange) {
        if (Misc.equals(this.range, newRange)) {
            return;
        }
        this.setRange(newRange);
        try {
            this.displayControl.setRange(this.whichColorTable, this.range);
        }
        catch (Exception exc2) {
            this.logException("propertyChange", exc2);
        }
    }

    public void setRangeFromPopup(String cmd) {
        Range r = null;
        if (cmd.equals("cmd.range.colortable")) {
            ColorTable originalCT = this.colorTableManager.getColorTable(this.colorTable.getName());
            if (originalCT != null) {
                r = originalCT.getRange();
            }
        } else if (cmd.equals("cmd.range.data")) {
            r = this.getDisplayControl().getColorRangeFromData();
        } else if (cmd.equals("cmd.range.default")) {
            try {
                r = this.getDisplayControl().getInitialRange();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setRangeDialog(r);
    }

    @Override
    public void setRangeDialog(Range r) {
        if (r != null) {
            this.rangeMinField.setText(this.getDisplayConventions().format(r.getMin()));
            this.rangeMaxField.setText(this.getDisplayConventions().format(r.getMax()));
        }
    }

    public void rangePopup() {
        try {
            Range ctRange = null;
            ColorTable originalCT = this.colorTableManager.getColorTable(this.colorTable.getName());
            if (originalCT != null) {
                ctRange = originalCT.getRange();
            }
            ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
            items.add(GuiUtils.makeMenuItem("Default Range", this, "setRangeFromPopup", "cmd.range.default"));
            items.add(GuiUtils.makeMenuItem("From All Data", this, "setRangeFromPopup", "cmd.range.data"));
            if (ctRange != null) {
                items.add(GuiUtils.makeMenuItem("From Color Table", this, "setRangeFromPopup", "cmd.range.colortable"));
            }
            this.getDisplayControl().addToRangeMenu((RangeWidget)this, items);
            JPopupMenu popup = GuiUtils.makePopupMenu(items);
            Dimension d = this.rangePopupBtn.getSize();
            popup.show(this.rangePopupBtn, 0, d.height);
        }
        catch (Exception exc) {
            this.logException("Range popup", exc);
        }
    }

    public void showChangeRangeDialog() {
        this.rangePopupBtn = GuiUtils.makeButton("Use Predefined", this, "rangePopup");
        this.rangeMinField = new JTextField("" + this.getDisplayConventions().format(this.range.getMin()), 6);
        this.rangeMaxField = new JTextField("" + this.getDisplayConventions().format(this.range.getMax()), 6);
        List comps = Misc.newList(new JLabel("New Range    From: "), this.rangeMinField, new JLabel("To: "), this.rangeMaxField, GuiUtils.inset((Component)this.rangePopupBtn, new Insets(0, 5, 0, 0)));
        final JDialog dialog = new JDialog((Frame)null, "Change Range", true);
        JPanel contents = GuiUtils.inset((Component)GuiUtils.hflow(comps), 5);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String cmd = event.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
                    try {
                        Range newRange = new Range(Misc.parseNumber(ColorTableWidget.this.rangeMinField.getText()), Misc.parseNumber(ColorTableWidget.this.rangeMaxField.getText()));
                        ColorTableWidget.this.handleNewRange(newRange);
                    }
                    catch (NumberFormatException pe) {
                        LogUtil.userMessage("Invalid numeric format");
                        return;
                    }
                }
                if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        };
        this.rangeMinField.addActionListener(listener);
        this.rangeMaxField.addActionListener(listener);
        this.rangeMinField.setActionCommand(GuiUtils.CMD_OK);
        this.rangeMaxField.setActionCommand(GuiUtils.CMD_OK);
        dialog.getContentPane().add(GuiUtils.centerBottom(contents, GuiUtils.makeApplyOkCancelButtons(listener)));
        dialog.pack();
        GuiUtils.showDialogNearSrc(this.popupBtn, dialog);
    }

    public void doEdit() {
        this.colorTable.setRange(this.range);
        this.oldTable = new ColorTable(this.colorTable);
        this.oldRange = new Range(this.range);
        if (this.myEditor != null) {
            this.myEditor.show();
        } else {
            this.myEditor = this.colorTableManager.edit(this.colorTable, this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("prop.colortable")) {
            ColorTable newTable = (ColorTable)e.getNewValue();
            try {
                this.displayControl.setColorTable(this.whichColorTable, newTable);
            }
            catch (Exception exc) {
                this.logException("actionPerformed", exc);
            }
        } else if (e.getPropertyName().equals("prop.range")) {
            this.handleNewRange((Range)e.getNewValue());
        } else if (e.getPropertyName().equals("prop.close")) {
            this.myEditor = null;
        } else if (e.getPropertyName().equals("prop.cancel")) {
            // empty if block
        }
    }

    private void colorTableSelected(ColorTable ct) {
        this.colorTable = ct;
        if (this.colorTable.getRange() != null) {
            // empty if block
        }
        this.popupBtn.setText(this.colorTable.getName());
        if (this.myEditor != null) {
            this.myEditor.setColorTable(this.colorTable);
        }
        try {
            this.displayControl.setColorTable(this.whichColorTable, this.colorTable);
        }
        catch (Exception e) {
            this.logException("actionPerformed", e);
        }
    }

    public void showMenu(Component from) {
        JPopupMenu popup = GuiUtils.makePopupMenu(this.makeMenuItems());
        Dimension d = from.getSize();
        popup.show(from, 0, d.height);
    }

    public JMenu makeMenu() {
        return GuiUtils.makeMenu("Color Table", (List)this.makeMenuItems());
    }

    public void doUseDefault() {
        this.displayControl.revertToDefaultColorTable(this.whichColorTable);
        if (this.myEditor != null && this.colorTable != null) {
            this.myEditor.setColorTable(this.colorTable);
        }
    }

    public void setTransparency(Integer v) {
        try {
            float trans = (float)(100 - v) / 100.0f;
            this.colorTable = new ColorTable(this.colorTable);
            this.colorTable.setTransparency(trans);
            this.displayControl.setColorTable(this.whichColorTable, this.colorTable);
            if (this.myEditor != null && this.colorTable != null) {
                this.myEditor.setColorTable(this.colorTable);
            }
        }
        catch (Exception exc) {
            this.logException("Setting transparency on color table", exc);
        }
    }

    public ArrayList makeMenuItems() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(GuiUtils.makeMenuItem("Edit Color Table", this, "doEdit"));
        l.add(GuiUtils.makeMenuItem("Change Range...", this, "showChangeRangeDialog"));
        l.add(GuiUtils.makeMenuItem("Use Default", this, "doUseDefault"));
        l.add("separator");
        JMenu transMenu = new JMenu("Transparency");
        l.add(transMenu);
        int[] values = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
        for (int i = 0; i < values.length; ++i) {
            transMenu.add(GuiUtils.makeMenuItem(values[i] + "%", this, "setTransparency", new Integer(values[i])));
        }
        if (this.displayControl.getColorDimness() >= 0.1f) {
            l.add(GuiUtils.makeMenuItem("Dimmer", this.displayControl, "setColorDimmer"));
        }
        if (this.displayControl.getColorDimness() < 1.0f) {
            l.add(GuiUtils.makeMenuItem("Brighter", this.displayControl, "setColorBrighter"));
        }
        l.add("separator");
        this.colorTableManager.makeColorTableMenu(new ObjectListener(null){

            @Override
            public void actionPerformed(ActionEvent ae, Object data) {
                ColorTableWidget.this.colorTableSelected((ColorTable)data);
            }
        }, l);
        return l;
    }

    protected void revertToDefaultRange() {
        this.displayControl.revertToDefaultRange(this.whichColorTable);
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range r) {
        if (Misc.equals(r, this.range)) {
            return;
        }
        this.range = r != null ? new Range(r) : null;
        for (int i = 0; i < this.colorPreviews.size(); ++i) {
            ((MyColorPreview)this.colorPreviews.get(i)).setRange(this.range, this.displayControl.getColorUnit());
        }
        if (this.myEditor != null) {
            this.myEditor.setRange(r);
        }
    }

    public void setColorPalette(float[][] palette) throws RemoteException, VisADException {
        ColorTable ct = new ColorTable("", "", palette);
        for (int i = 0; i < this.colorPreviews.size(); ++i) {
            MyColorPreview colorPreview = (MyColorPreview)this.colorPreviews.get(i);
            colorPreview.setColors(ct.getColorList());
        }
    }

    public void setColorTable(ColorTable colorTable) throws RemoteException, VisADException {
        this.colorTable = colorTable;
        for (int i = 0; i < this.colorPreviews.size(); ++i) {
            MyColorPreview colorPreview = (MyColorPreview)this.colorPreviews.get(i);
            colorPreview.setColors(colorTable.getColorList());
        }
        this.popupBtn.setText(colorTable.getName());
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    @Override
    public void fillList(List l, int columns) {
        JLabel label = GuiUtils.rLabel("Color Table:");
        int keyCode = GuiUtils.charToKeyCode("T");
        if (keyCode != -1) {
            label.setDisplayedMnemonic(keyCode);
        }
        label.setLabelFor(this.popupBtn);
        l.add(label);
        GuiUtils.tmpFill = 2;
        JPanel p = GuiUtils.doLayout(new Component[]{this.popupBtn, new Label(" "), GuiUtils.left(this.doMakePreview(true, 0))}, 3, GuiUtils.WT_NNY, GuiUtils.WT_N);
        l.add(p);
    }

    private static class MyColorPreview
    extends RangeColorPreview
    implements KeyListener {
        private ColorTableWidget ctw;
        private ColorTableWidget parentWidget = null;
        private boolean mouseIn = false;

        public MyColorPreview(ColorTableWidget ctw, List<Color> colors, boolean forMain, int legendType) {
            super(colors, ctw.getDisplayConventions(), legendType, forMain);
            this.ctw = ctw;
            this.setToolTipText("<html>Click to focus<br>Right click to show menu<br>Control-r: Revert to default range<br>Right arrow: shift range up<br>Left arrow: shift range down<br>Up arrow: expand range <br>Down arrow: shrink range");
            this.addKeyListener(this);
        }

        @Override
        public String getToolTipText() {
            if (this.mouseIn) {
                // empty if block
            }
            return super.getToolTipText();
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.mouseIn = true;
            super.mouseEntered(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            this.mouseIn = false;
            super.mouseExited(event);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            double delta = 0.01 * this.range.getSpan();
            if (delta > 2.0) {
                delta = (int)delta;
            }
            Range newRange = null;
            if (e.getKeyCode() == 38) {
                newRange = new Range(this.range.getMin() - delta, this.range.getMax() + delta);
            } else if (e.getKeyCode() == 40) {
                newRange = new Range(this.range.getMin() + delta, this.range.getMax() - delta);
            } else if (e.getKeyCode() == 37) {
                newRange = new Range(this.range.getMin() - delta, this.range.getMax() - delta);
            } else if (e.getKeyCode() == 39) {
                newRange = new Range(this.range.getMin() + delta, this.range.getMax() + delta);
            }
            if (newRange != null) {
                this.ctw.handleNewRange(newRange);
                this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.requestFocus();
            if (SwingUtilities.isRightMouseButton(event)) {
                if (this.parentWidget == null) {
                    this.ctw.showMenu(this);
                } else {
                    this.parentWidget.showMenu(this);
                }
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (this.parentWidget == null) {
                this.ctw.showMenu(this);
            }
        }
    }
}

