/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.ui.FontSelector;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.visad.display.ColorScaleInfo;

public class ColorScaleDialog
implements ActionListener {
    private static final String[] positions = new String[]{"Top", "Bottom", "Left", "Right"};
    private FontSelector fontSelector = null;
    private boolean ok = false;
    private JPanel contents;
    private JDialog dialog;
    private ColorScaleInfo myInfo;
    private JComboBox orientationBox;
    private JComboBox placementBox;
    private GuiUtils.ColorSwatch colorSwatch;
    private JCheckBox visibilityCbx;
    private JCheckBox unitCbx;
    private JCheckBox labelVisibilityCbx;
    private JCheckBox alphaCbx;
    private DisplayControlImpl displayControl;

    public ColorScaleDialog(DisplayControlImpl displayControl, String title, ColorScaleInfo info, boolean showDialog) {
        this.displayControl = displayControl;
        this.myInfo = new ColorScaleInfo(info);
        if (showDialog) {
            this.dialog = GuiUtils.createDialog(displayControl != null ? displayControl.getWindow() : null, title, true);
        }
        this.doMakeContents(showDialog);
        String place = this.myInfo.getPlacement();
        if (place != null) {
            this.placementBox.setSelectedItem(place);
        }
        this.visibilityCbx.setSelected(this.myInfo.getIsVisible());
        this.unitCbx.setSelected(this.myInfo.isUnitVisible());
        this.labelVisibilityCbx.setSelected(this.myInfo.getLabelVisible());
        this.alphaCbx.setSelected(this.myInfo.getUseAlpha());
        if (showDialog) {
            this.dialog.setVisible(true);
        }
    }

    public JComponent getContents() {
        return this.contents;
    }

    protected void dispose() {
        this.displayControl = null;
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
    }

    protected boolean doApply() {
        String place = (String)this.placementBox.getSelectedItem();
        if (place != null) {
            this.myInfo.setPlacement(place);
        }
        this.myInfo.setLabelColor(this.colorSwatch.getSwatchColor());
        this.myInfo.setIsVisible(this.visibilityCbx.isSelected());
        this.myInfo.setUnitVisible(this.unitCbx.isSelected());
        this.myInfo.setLabelVisible(this.labelVisibilityCbx.isSelected());
        this.myInfo.setUseAlpha(this.alphaCbx.isSelected());
        this.myInfo.setLabelFont(this.fontSelector.getFont());
        try {
            if (this.displayControl != null) {
                this.myInfo.setUnit(this.displayControl.getDisplayUnit());
                this.displayControl.setColorScaleInfo(new ColorScaleInfo(this.getInfo()));
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        catch (Exception exc) {
            LogUtil.logException("Setting color scale info", exc);
            return false;
        }
    }

    private void doMakeContents(boolean showDialog) {
        this.placementBox = new JComboBox<String>(positions);
        this.colorSwatch = new GuiUtils.ColorSwatch(this.myInfo.getLabelColor(), "Color Scale Label Color");
        final JComponent colorComp = this.colorSwatch.getSetPanel();
        this.visibilityCbx = new JCheckBox("", this.myInfo.getIsVisible());
        this.unitCbx = new JCheckBox("Show Unit", this.myInfo.isUnitVisible());
        this.alphaCbx = new JCheckBox("", this.myInfo.getUseAlpha());
        this.fontSelector = new FontSelector(0, false, false);
        this.fontSelector.setFont(this.myInfo.getLabelFont());
        this.labelVisibilityCbx = new JCheckBox("Visible", this.myInfo.getLabelVisible());
        this.labelVisibilityCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean showLabel = ((JCheckBox)e.getSource()).isSelected();
                GuiUtils.enableTree(ColorScaleDialog.this.fontSelector.getComponent(), showLabel);
                GuiUtils.enableTree(colorComp, showLabel);
            }
        });
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        this.contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Visible: "), this.visibilityCbx, GuiUtils.rLabel("Position: "), GuiUtils.leftRight(this.placementBox, GuiUtils.filler()), GuiUtils.rLabel("Labels: "), GuiUtils.leftRight(this.labelVisibilityCbx, GuiUtils.filler()), GuiUtils.filler(), GuiUtils.leftRight(this.unitCbx, GuiUtils.filler()), GuiUtils.filler(), GuiUtils.leftRight(GuiUtils.rLabel("Font: "), this.fontSelector.getComponent()), GuiUtils.filler(), GuiUtils.leftRight(GuiUtils.rLabel("Color: "), GuiUtils.leftRight(colorComp, GuiUtils.filler()))}, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        this.contents = GuiUtils.leftRight(this.contents, GuiUtils.filler());
        if (showDialog) {
            JPanel buttons = this.displayControl != null ? GuiUtils.makeApplyOkCancelButtons(this) : GuiUtils.makeOkCancelButtons(this);
            this.dialog.getContentPane().add(GuiUtils.centerBottom(this.contents, buttons));
            GuiUtils.packInCenter(this.dialog);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if ((cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) && !this.doApply()) {
            return;
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.ok = false;
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.ok = true;
        }
        if (cmd.equals(GuiUtils.CMD_CANCEL) || cmd.equals(GuiUtils.CMD_OK)) {
            this.dialog.setVisible(false);
        }
    }

    public ColorScaleInfo getInfo() {
        return this.myInfo;
    }

    private Font getDisplayListFont() {
        int size;
        if (this.displayControl == null) {
            return null;
        }
        Font f = this.displayControl.getViewManager().getDisplayListFont();
        int n = size = f == null ? 12 : f.getSize();
        if (f != null && f.getName().equals("Default")) {
            f = null;
        }
        return f;
    }

    public boolean getOk() {
        return this.ok;
    }
}

