/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.CrossSectionViewManager;
import ucar.unidata.idv.DisplayConventions;
import ucar.unidata.idv.control.ColorCrossSectionControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.visad.display.CrossSectionSelector;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.XSDisplay;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Length;
import visad.AxisScale;
import visad.Data;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class ColorRhiControl
extends ColorCrossSectionControl {
    protected float beamAz;
    private float lastLoadedAz = Float.NaN;
    protected boolean autorotateOn = false;
    protected JLabel stationLabel = new JLabel("   ");
    private EarthLocation centerPoint;
    private double defaultLen = 1.0;
    private double currentCSLineLen = 0.2;
    private int timestamp = 0;
    private double R = 6371.01;
    private String OldSmoothingType = "None";
    private int OldSmoothingFactor = 0;
    private Container viewContents;

    public ColorRhiControl() {
        this.setAttributeFlags(60);
    }

    @Override
    public void initDone() {
        try {
            this.setRequestProperties();
            XSDisplay xsDisplay = this.crossSectionView.getXSDisplay();
            this.getCrossSectionViewManager().setNewDisplayTitle("RHI  Azimuth: " + this.getDisplayConventions().formatAngle(this.beamAz));
            if (this.getVerticalAxisRange() == null) {
                this.setVerticalAxisRange(new Range(0.0, 20000.0));
            }
            this.updateAxisLabels();
            this.loadDataFromLine();
            FieldImpl fieldImpl = (FieldImpl)this.getGridDataInstance().getGrid().getSample(0);
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
            Unit xUnit = domainSet.getSetUnits()[0];
            String unitlabel = xUnit.toString();
            if (unitlabel.equalsIgnoreCase("1000.0 m")) {
                unitlabel = "km";
            }
            this.updateCenterPoint();
        }
        catch (Exception e) {
            ColorRhiControl.logException("Initializing the csSelector", e);
        }
        this.csSelector.addPropertyChangeListener(this);
    }

    private void updateAxisLabels() {
        try {
            XSDisplay xsDisplay = this.crossSectionView.getXSDisplay();
            AxisScale yScale = xsDisplay.getYAxisScale();
            yScale.setMajorTickSpacing((int)(this.getVerticalAxisRange().getMax() / 5.0));
            yScale.setMinorTickSpacing(yScale.getMajorTickSpacing() / 5.0);
            yScale.setTitle("Altitude MSL (m)");
            yScale.setSnapToBox(true);
            yScale.createStandardLabels(this.getVerticalAxisRange().getMax(), 0.0, 0.0, yScale.getMajorTickSpacing());
            yScale.setGridLinesVisible(true);
            xsDisplay.setXRange(0.0, 400.0);
            AxisScale xScale = xsDisplay.getXAxisScale();
            xScale.setMajorTickSpacing(100.0);
            xScale.setMinorTickSpacing(50.0);
            xScale.setSnapToBox(true);
            xScale.createStandardLabels(400.0, 0.0, 0.0, 100.0);
            xScale.setSnapToBox(true);
            xScale.setGridLinesVisible(true);
        }
        catch (Exception e) {
            ColorRhiControl.logException("updating axis labels", e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("SelectorDisplay.position")) {
            this.crossSectionChanged();
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected boolean setData(DataChoice choice) throws VisADException, RemoteException {
        if (!super.setData(choice)) {
            return false;
        }
        this.updateCenterPoint();
        return true;
    }

    @Override
    protected String getCrossSectionViewLabel() {
        return "RHI";
    }

    protected void updateCenterPoint() throws VisADException, RemoteException {
        GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(this.getGridDataInstance().getGrid());
        Radar3DCoordinateSystem transform = (Radar3DCoordinateSystem)domainSet.getCoordinateSystem();
        float stationLat = transform.getCenterPoint()[0];
        float stationLon = transform.getCenterPoint()[1];
        float stationEl = transform.getCenterPoint()[2];
        this.startLocation = this.centerPoint = new EarthLocationTuple(stationLat, stationLon, stationEl);
        List choices = this.getDataChoices();
        String staname = ((DataChoice)choices.get(0)).getName();
        this.stationLabel.setText(staname.substring(0, 4).trim() + "  (" + this.getDisplayConventions().formatEarthLocation(this.centerPoint, true) + ")");
        this.setCSLineLength(this.defaultLen);
    }

    @Override
    public void crossSectionChanged() {
        try {
            this.beamAz = (float)this.getCSSAzimuth();
            this.setRequestProperties();
            this.loadDataFromLine();
            List choices = this.getDataChoices();
            this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)choices.get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.beamAz));
            this.doShare((Object)"DisplayControlImpl.SHARE_TRANSECT", this);
        }
        catch (Exception exc) {
            ColorRhiControl.logException("crossSectionChanged", exc);
        }
    }

    private boolean setCSLineLength(double len) {
        if (this.csSelector == null) {
            return false;
        }
        Object center = null;
        try {
            double[] box;
            double x1 = 0.0;
            double y1 = 0.0;
            if (this.centerPoint != null && (box = this.earthToBox(this.centerPoint)) != null) {
                x1 = box[0];
                y1 = box[1];
            }
            RealTuple start = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x1, y1});
            double dx2 = len * Math.cos(Math.toRadians(90.0 - (double)this.beamAz));
            double dy2 = len * Math.sin(Math.toRadians(90.0 - (double)this.beamAz));
            RealTuple newend = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x1 + dx2, y1 + dy2});
            this.endLocation = this.boxToEarth(new double[]{x1 + dx2, y1 + dy2, 0.0});
            this.csSelector.setPosition(start, newend);
        }
        catch (Exception e) {
            ColorRhiControl.logException("setCSLineLength:", e);
            return false;
        }
        return true;
    }

    protected void centerLinePosition() throws VisADException, RemoteException {
        RealTuple start = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{0.0, 0.0});
        this.csSelector.setPosition(start, this.csSelector.getEndPoint());
        this.beamAz = (float)this.getCSSAzimuth();
        List choices = this.getDataChoices();
        this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)choices.get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.beamAz));
        this.setRequestProperties();
    }

    protected void autorotateLine() {
        Misc.run(new Runnable(){

            @Override
            public void run() {
                ColorRhiControl.this.runAuto(++ColorRhiControl.this.timestamp);
            }
        });
    }

    private void runAuto(int ts) {
        int requestedSleepDelay = 500;
        int sleepDelay = 500;
        this.beamAz = (float)this.getCSSAzimuth();
        while (this.getActive()) {
            try {
                long millis = System.currentTimeMillis();
                this.shiftSelectorToAzimuth(this.beamAz + 1.0f);
                this.beamAz = (float)this.getCSSAzimuth();
                if (!this.getActive()) break;
                this.loadDataFromLine();
                this.getCrossSectionViewManager().setNewDisplayTitle(((DataChoice)this.getDataChoices().get(0)).getName() + " Azimuth " + this.getDisplayConventions().formatAngle(this.beamAz));
                int timeUsed = (int)(System.currentTimeMillis() - millis);
                if (timeUsed > sleepDelay) {
                    sleepDelay = timeUsed + 250;
                } else if (timeUsed < requestedSleepDelay - 250) {
                    sleepDelay = requestedSleepDelay;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.currentThread();
                Thread.sleep(sleepDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.autorotateOn && ts == this.timestamp) continue;
            break;
        }
    }

    private double getCSLineLength() {
        System.out.println("  2. cd sel len is " + this.currentCSLineLen);
        try {
            if (this.csSelector == null) {
                return 0.0;
            }
            RealTuple start = this.csSelector.getStartPoint();
            RealTuple end = this.csSelector.getEndPoint();
            double x1 = ((Real)start.getComponent(0)).getValue();
            double y1 = ((Real)start.getComponent(1)).getValue();
            double x2 = ((Real)end.getComponent(0)).getValue();
            double y2 = ((Real)end.getComponent(1)).getValue();
            return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        }
        catch (Exception e) {
            ColorRhiControl.logException("getCSLineLength", e);
            return 0.0;
        }
    }

    private void shiftSelectorToAzimuth(float newazimuth) {
        Object center = null;
        try {
            if (this.csSelector == null) {
                return;
            }
            RealTuple start = this.csSelector.getStartPoint();
            RealTuple end = this.csSelector.getEndPoint();
            double x1 = ((Real)start.getComponent(0)).getValue();
            double y1 = ((Real)start.getComponent(1)).getValue();
            double x2 = ((Real)end.getComponent(0)).getValue();
            double y2 = ((Real)end.getComponent(1)).getValue();
            double h = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double x3 = h * Math.cos(Math.toRadians(90.0 - (double)newazimuth));
            double y3 = h * Math.sin(Math.toRadians(90.0 - (double)newazimuth));
            RealTuple newend = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{x1 + x3, y1 + y3});
            this.csSelector.setPosition(start, newend);
        }
        catch (Exception e) {
            ColorRhiControl.logException("shiftSelectorToAzimuth:", e);
        }
    }

    public void resetBeamAz(float c) {
        this.beamAz = c;
        this.shiftSelectorToAzimuth(this.beamAz);
        try {
            this.loadDataFromLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setRequestProperties();
        this.getCrossSectionViewManager().setNewDisplayTitle("Radar RHI  Azimuth " + this.getDisplayConventions().formatAngle(this.beamAz));
    }

    @Override
    protected DisplayableData createXSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_col" + this.paramName, true);
        display.setTextureEnable(true);
        this.addAttributedDisplayable(display, 8200);
        return display;
    }

    @Override
    protected DisplayableData createVCSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_" + this.paramName, true);
        display.setTextureEnable(true);
        this.addAttributedDisplayable(display, 8200);
        return display;
    }

    @Override
    public String getColorWidgetLabel() {
        return "Selector Line Color";
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        final JButton rotatebutton = new JButton("Start");
        rotatebutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!ColorRhiControl.this.autorotateOn) {
                        ColorRhiControl.this.autorotateOn = true;
                        ColorRhiControl.this.autorotateLine();
                        rotatebutton.setText("Stop");
                    } else {
                        ColorRhiControl.this.autorotateOn = false;
                        rotatebutton.setText("Start");
                    }
                }
                catch (Exception ve) {
                    DisplayControlBase.logException(" autorotate rhi ", ve);
                }
            }
        });
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Autorotate RHI:"), GuiUtils.left(rotatebutton)));
    }

    protected JComponent getDisplayTabComponent_old() {
        JComponent comp = super.getDisplayTabComponent();
        return GuiUtils.centerBottom(comp, GuiUtils.left(GuiUtils.label("Station: ", this.stationLabel)));
    }

    @Override
    protected JComponent getDisplayTabComponent() {
        this.viewContents = this.crossSectionView.getContents();
        this.crossSectionView.setContentsBorder(null);
        return GuiUtils.centerBottom(this.viewContents, GuiUtils.left(GuiUtils.label("Station: ", this.stationLabel)));
    }

    public void setAutorotateOn(boolean v) {
        this.autorotateOn = v;
    }

    public boolean getAutorotateOn() {
        return this.autorotateOn;
    }

    public void setBeamAz(float az) {
        this.beamAz = az;
    }

    @Override
    public void setEndPoint(RealTuple p) {
        if (p.getLength() != 1) {
            return;
        }
        float az = (float)p.getValues()[0];
        this.resetBeamAz(az);
    }

    public void setBeamAzimuth(float az) {
        this.beamAz = az;
    }

    public float getBeamAzimuth() {
        return this.beamAz;
    }

    @Override
    protected void createCrossSectionSelector() throws VisADException, RemoteException {
        this.csSelector = new CrossSectionSelector();
        this.csSelector.setZValue(0.99);
        this.csSelector.dontShowStartPoint();
        this.csSelector.dontShowMiddlePoint();
        this.csSelector.setStartPointFixed(true);
        this.csSelector.setStartPointVisible(false);
        this.csSelector.setMidPointVisible(false);
        this.setCSLineLength(this.defaultLen);
        this.setRequestProperties();
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals("DisplayControlImpl.SHARE_TRANSECT")) {
            if (this.csSelector == null) {
                return;
            }
            ColorRhiControl fromControl = (ColorRhiControl)data[0];
            try {
                CrossSectionSelector cs = fromControl.getCrossSectionSelector();
                this.csSelector.setPosition(cs.getStartPoint(), cs.getEndPoint());
                this.loadDataFromLine();
            }
            catch (Exception e) {
                ColorRhiControl.logException("receiveShareData:" + dataId, e);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    private double getCSSAzimuth() {
        RealTuple start = this.csSelector.getStartPoint();
        RealTuple end = this.csSelector.getEndPoint();
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 1.0;
        double y2 = 0.0;
        try {
            x1 = ((Real)start.getComponent(0)).getValue();
            y1 = ((Real)start.getComponent(1)).getValue();
            x2 = ((Real)end.getComponent(0)).getValue();
            y2 = ((Real)end.getComponent(1)).getValue();
        }
        catch (Exception e) {
            ColorRhiControl.logException("az from csSelector", e);
        }
        double deltax = x2 - x1;
        double deltay = y2 - y1;
        double az = 90.0 - Math.toDegrees(Math.atan2(deltay, deltax));
        if (az < 0.0) {
            az += 360.0;
        }
        this.beamAz = (float)az;
        this.updateLegendLabel();
        return az;
    }

    @Override
    public void getLegendLabels(List labels, int legendType) {
        super.getLegendLabels(labels, legendType);
        labels.add("Azimuth: " + this.getDisplayConventions().formatAngle(this.beamAz));
    }

    @Override
    protected void updateLegendLabel() {
        super.updateLegendLabel();
        CrossSectionViewManager csvm = this.getCrossSectionViewManager();
        List dataChoices = this.getDataChoices();
        DisplayConventions dc = this.getDisplayConventions();
        if (csvm != null && dataChoices != null && dataChoices.size() > 0 && dc != null) {
            csvm.setNewDisplayTitle(((DataChoice)dataChoices.get(0)).getName() + " Azimuth " + dc.formatAngle(this.beamAz));
        }
    }

    @Override
    protected void loadDataFromLine() throws VisADException, RemoteException {
        if (!this.getHaveInitialized() || this.lastLoadedAz == this.beamAz && this.getSmoothingType().equals(this.OldSmoothingType)) {
            return;
        }
        this.getGridDataInstance().reInitialize();
        FieldImpl grid = this.getGridDataInstance().getGrid();
        if (grid == null) {
            return;
        }
        if (this.checkFlag(8192) && !this.getSmoothingType().equals("None")) {
            grid = GridUtil.smooth(grid, this.getSmoothingType(), this.getSmoothingFactor());
        }
        this.showWaitCursor();
        this.loadData(grid);
        this.showNormalCursor();
        this.lastLoadedAz = this.beamAz;
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        props.put("Level2RadarDataSource.azimuth", new Float(this.beamAz));
        return props;
    }

    protected void setRequestProperties() {
        this.getRequestProperties().put("Level2RadarDataSource.azimuth", new Float(this.beamAz));
    }

    @Override
    protected FieldImpl make2DData(FieldImpl inputfieldImpl) throws VisADException, RemoteException {
        FieldImpl fi = null;
        GriddedSet domainSet = null;
        boolean istimeSequence = GridUtil.isTimeSequence(inputfieldImpl);
        if (istimeSequence) {
            Set timeSet = inputfieldImpl.getDomainSet();
            int numTimes = timeSet.getLength();
            RealTupleType timeType = ((FunctionType)inputfieldImpl.getType()).getDomain();
            for (int ti = 0; ti < numTimes; ++ti) {
                FieldImpl one3DFI = (FieldImpl)inputfieldImpl.getSample(ti);
                FieldImpl one2DFI = this.make2DDataAtOneTime(one3DFI);
                if (domainSet == null) {
                    domainSet = (GriddedSet)GridUtil.getSpatialDomain(one2DFI);
                }
                if (ti == 0) {
                    FunctionType fiFunction = new FunctionType(timeType, (FunctionType)one2DFI.getType());
                    fi = new FieldImpl(fiFunction, timeSet);
                }
                if (one2DFI == null) continue;
                fi.setSample(ti, (Data)one2DFI, false);
            }
        } else {
            fi = this.make2DDataAtOneTime(inputfieldImpl);
        }
        this.dataVerticalRange = this.getCrossSectionVerticalRange(domainSet);
        return fi;
    }

    private FieldImpl make2DDataAtOneTime(FieldImpl inputfieldImpl) throws VisADException, RemoteException {
        FieldImpl fi = null;
        Object testff = null;
        Set indexSet = null;
        int numBeams = 1;
        if (inputfieldImpl.getDomainDimension() == 1) {
            indexSet = inputfieldImpl.getDomainSet();
            numBeams = indexSet.getLength();
        }
        for (int bi = 0; bi < numBeams; ++bi) {
            FieldImpl fieldImpl = (FieldImpl)inputfieldImpl.getSample(bi);
            if (fieldImpl.isMissing()) continue;
            float[][] signalVals = fieldImpl.getFloats(false);
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(fieldImpl);
            Radar3DCoordinateSystem transform = (Radar3DCoordinateSystem)domainSet.getCoordinateSystem();
            float stationElev = transform.getCenterPoint()[2];
            float[][] domainSamples = domainSet.getSamples(false);
            float[] ranges = domainSamples[0];
            float[] azimuths = domainSamples[1];
            float[] elevs = domainSamples[2];
            float[][] plane = new float[2][domainSet.getLength()];
            for (int i = 0; i < plane[0].length; ++i) {
                float dx;
                double range = ranges[i];
                double elevation = Math.toRadians(elevs[i]);
                plane[0][i] = dx = (float)(range * Math.cos(elevation));
                plane[1][i] = 1000.0f * (float)(range * Math.sin(elevation)) + stationElev + 1000.0f * (float)((double)(dx * dx) / 12742.0);
            }
            RealType xType = null;
            if (this.crossSectionView != null) {
                XSDisplay xs = this.crossSectionView.getXSDisplay();
                xType = xs.getXAxisType();
            } else {
                xType = Length.getRealType();
            }
            RealTupleType xzRTT = new RealTupleType(xType, RealType.Altitude);
            int sizeX = domainSet.getLengths()[0];
            int sizeZ = domainSet.getLengths()[1];
            Unit zUnit = transform == null ? domainSet.getSetUnits()[2] : transform.getReferenceUnits()[2];
            Gridded2DSet oneBeamG2DS = new Gridded2DSet(xzRTT, plane, sizeX, sizeZ, null, new Unit[]{CommonUnits.KILOMETER, zUnit}, null, false, false);
            RealTupleType oneBeamMT = (RealTupleType)this.getGridDataInstance().getRangeType();
            FunctionType oneBeamFT = new FunctionType(xzRTT, oneBeamMT);
            FlatField oneBeamFF = new FlatField(oneBeamFT, oneBeamG2DS);
            oneBeamFF.setSamples(signalVals, false);
            if (bi == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, oneBeamFF.getType());
                Integer1DSet intSet = new Integer1DSet(numBeams);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(bi, (Data)oneBeamFF, false);
                continue;
            }
            fi.setSample(bi, (Data)oneBeamFF, false);
        }
        return fi;
    }

    @Override
    public boolean getAllowSmoothing() {
        return false;
    }

    @Override
    public boolean getAllowAutoScale() {
        return false;
    }

    @Override
    public boolean getAutoScaleYAxis() {
        return false;
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Radar Projection";
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }
}

