/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import ucar.unidata.collab.Sharable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import ucar.visad.display.GridDisplayable;
import visad.FieldImpl;
import visad.GriddedSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocationTuple;

public class ColorRadarVolumeControl
extends GridDisplayControl {
    public static final String SHARE_VOLUME = "ColorRadarVolumeControl.SHARE_VOLUME";
    public static final String RADAR_VOLUME = "Radar volume scan";
    private DisplayableData mainDisplay;
    private boolean displayIs3D = false;
    private FieldImpl fieldImpl = null;
    private JLabel stationLabel = new JLabel("   ");

    public ColorRadarVolumeControl() {
        this.setAttributeFlags(312);
    }

    protected DisplayableData createMainDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("radar_volume" + this.paramName, true);
        display.setUseRGBTypeForSelect(true);
        return display;
    }

    public GridDisplayable getGridDisplayable() {
        return (GridDisplayable)((Object)this.mainDisplay);
    }

    public DisplayableData getMainDisplay() {
        return this.mainDisplay;
    }

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        this.displayIs3D = this.isDisplay3D();
        this.setRequestProperties();
        this.mainDisplay = this.createMainDisplay();
        this.mainDisplay.setPointSize(this.getPointSize());
        if (!this.setData(dataChoice)) {
            return false;
        }
        this.addDisplayable((Displayable)this.mainDisplay, 264);
        return true;
    }

    public void setLabelFromData() {
        try {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(this.getGridDataInstance().getGrid());
            Radar3DCoordinateSystem transform = (Radar3DCoordinateSystem)domainSet.getCoordinateSystem();
            float stationLat = transform.getCenterPoint()[0];
            float stationLon = transform.getCenterPoint()[1];
            float stationEl = transform.getCenterPoint()[2];
            List choices = this.getDataChoices();
            String staname = ((DataChoice)choices.get(0)).getName();
            EarthLocationTuple centerPoint = new EarthLocationTuple(stationLat, stationLon, stationEl);
            this.stationLabel.setText(staname.substring(0, 3) + " " + this.getDisplayConventions().formatEarthLocation(centerPoint, true));
        }
        catch (Exception e) {
            ColorRadarVolumeControl.logException("setLabelFromData ", e);
        }
    }

    @Override
    public Container doMakeContents() {
        try {
            return GuiUtils.doLayout(new Component[]{this.doMakeWidgetComponent()}, 1, GuiUtils.WT_Y, GuiUtils.WT_YN);
        }
        catch (Exception exc) {
            ColorRadarVolumeControl.logException("doMakeContents", exc);
            return null;
        }
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Station:"), this.stationLabel));
        controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Point Size:"), GuiUtils.left(this.doMakePointSizeWidget())));
    }

    @Override
    public void setPointSize(float value) {
        super.setPointSize(value);
        if (this.mainDisplay != null) {
            try {
                this.mainDisplay.setPointSize(this.getPointSize());
            }
            catch (Exception e) {
                ColorRadarVolumeControl.logException("Setting point size", e);
            }
        }
    }

    @Override
    protected Hashtable getRequestProperties() {
        if (this.requestProperties == null) {
            this.requestProperties = Misc.newHashtable(RADAR_VOLUME, new Float(0.0f));
        }
        return this.requestProperties;
    }

    protected void setRequestProperties() {
        if (this.requestProperties == null) {
            this.requestProperties = Misc.newHashtable(RADAR_VOLUME, new Float(0.0f));
        } else {
            this.requestProperties.clear();
            this.requestProperties.put(RADAR_VOLUME, new Float(0.0f));
        }
    }

    @Override
    protected boolean setData(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!super.setData(dataChoice)) {
            return false;
        }
        Unit newUnit = this.getDisplayUnit();
        if (newUnit != null && !newUnit.equals(this.getRawDataUnit()) && Unit.canConvert(newUnit, this.getRawDataUnit())) {
            this.mainDisplay.setDisplayUnit(newUnit);
        }
        this.loadDataFromGrid();
        this.setLabelFromData();
        return true;
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals(SHARE_VOLUME)) {
            ColorRadarVolumeControl fromControl = (ColorRadarVolumeControl)data[0];
            try {
                this.loadDataFromGrid();
            }
            catch (Exception e) {
                ColorRadarVolumeControl.logException("receiveShareData:" + dataId, e);
            }
            return;
        }
        super.receiveShareData(from, dataId, data);
    }

    private void loadDataFromGrid() throws VisADException, RemoteException {
        this.fieldImpl = this.getGridDataInstance().getGrid();
        this.loadData(this.fieldImpl);
    }

    private void loadData(FieldImpl fieldImpl) throws VisADException, RemoteException {
        this.getGridDisplayable().loadData(fieldImpl);
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }
}

