/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplaySettingsDialog;
import ucar.unidata.idv.control.PlanViewControl;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import visad.VisADException;
import visad.util.Util;

public class ColorPlanViewControl
extends PlanViewControl {
    boolean isSmoothed = false;
    boolean allowSmoothing = true;

    public ColorPlanViewControl() {
        this.setAttributeFlags(12584);
    }

    Grid2DDisplayable getGridDisplay() {
        return (Grid2DDisplayable)this.getPlanDisplay();
    }

    @Override
    protected DisplayableData createPlanDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable gridDisplay = new Grid2DDisplayable("ColorPlanViewControl_" + (this.datachoice != null ? this.datachoice.toString() : ""), true);
        gridDisplay.setPointSize(this.getPointSize());
        gridDisplay.setPolygonMode(this.polygonMode);
        gridDisplay.setTextureEnable(!this.isSmoothed);
        this.addAttributedDisplayable(gridDisplay);
        gridDisplay.setUseRGBTypeForSelect(true);
        gridDisplay.setCurvedSize(this.getTextureQuality());
        return gridDisplay;
    }

    @Override
    protected void applyTextureQuality() throws VisADException, RemoteException {
        if (this.getGridDisplay() != null) {
            this.getGridDisplay().setCurvedSize(this.getTextureQuality());
        }
    }

    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        JComboBox polyModeCombo = null;
        if (Util.canDoJava3D()) {
            polyModeCombo = this.getPolyModeComboBox();
        }
        if (this.getAllowSmoothing()) {
            JCheckBox toggle = new JCheckBox("", this.isSmoothed);
            toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ColorPlanViewControl.this.isSmoothed = ((JCheckBox)e.getSource()).isSelected();
                        ColorPlanViewControl.this.getGridDisplay().setTextureEnable(!ColorPlanViewControl.this.isSmoothed);
                    }
                    catch (Exception ve) {
                        DisplayControlBase.logException("setSmoothed", ve);
                    }
                }
            });
            if (polyModeCombo != null) {
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Display:"), GuiUtils.left(GuiUtils.hbox(new Component[]{GuiUtils.rLabel("Shade Colors:"), toggle, new JLabel("  Mode: "), polyModeCombo, new JLabel("  Point Size: "), this.doMakePointSizeWidget()}))));
            } else {
                controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Shade Colors:"), GuiUtils.leftCenter(toggle, GuiUtils.filler())));
            }
        } else if (polyModeCombo != null) {
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Display Mode:"), GuiUtils.left(polyModeCombo)));
        }
    }

    @Override
    protected void addDisplaySettings(DisplaySettingsDialog dsd) {
        super.addDisplaySettings(dsd);
        dsd.addPropertyValue(new Boolean(this.isSmoothed), "smoothed", "Colors Shaded", "Display");
    }

    public void setSmoothed(boolean v) {
        this.isSmoothed = v;
    }

    public boolean getSmoothed() {
        return this.isSmoothed;
    }

    public void setAllowSmoothing(boolean v) {
        this.allowSmoothing = v;
    }

    public boolean getAllowSmoothing() {
        return this.allowSmoothing;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }
}

