/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.JCheckBox;
import ucar.unidata.idv.control.CrossSectionControl;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.WrapperWidget;
import ucar.unidata.util.GuiUtils;
import ucar.visad.display.DisplayableData;
import ucar.visad.display.Grid2DDisplayable;
import visad.VisADException;

public class ColorCrossSectionControl
extends CrossSectionControl {
    boolean isSmoothed = false;
    boolean allowSmoothing = true;

    @Override
    protected DisplayableData createXSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_col" + this.paramName, true);
        display.setTextureEnable(!this.isSmoothed);
        display.setUseRGBTypeForSelect(true);
        this.addAttributedDisplayable(display, 264);
        return display;
    }

    @Override
    protected DisplayableData createVCSDisplay() throws VisADException, RemoteException {
        Grid2DDisplayable display = new Grid2DDisplayable("vcs_" + this.paramName, true);
        display.setTextureEnable(!this.isSmoothed);
        display.setUseRGBTypeForSelect(true);
        this.addAttributedDisplayable(display, 264);
        return display;
    }

    @Override
    public void getControlWidgets(List controlWidgets) throws VisADException, RemoteException {
        super.getControlWidgets(controlWidgets);
        if (this.getAllowSmoothing()) {
            JCheckBox toggle = new JCheckBox("", this.isSmoothed);
            toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ColorCrossSectionControl.this.isSmoothed = ((JCheckBox)e.getSource()).isSelected();
                        ((Grid2DDisplayable)ColorCrossSectionControl.this.getXSDisplay()).setTextureEnable(!ColorCrossSectionControl.this.isSmoothed);
                        ((Grid2DDisplayable)ColorCrossSectionControl.this.getVerticalCSDisplay()).setTextureEnable(!ColorCrossSectionControl.this.isSmoothed);
                    }
                    catch (Exception ve) {
                        DisplayControlBase.logException("setSmoothed", ve);
                    }
                }
            });
            controlWidgets.add(new WrapperWidget(this, GuiUtils.rLabel("Shade Colors:"), toggle));
        }
    }

    public void setSmoothed(boolean v) {
        this.isSmoothed = v;
    }

    public boolean getSmoothed() {
        return this.isSmoothed;
    }

    public void setAllowSmoothing(boolean v) {
        this.allowSmoothing = v;
        if (!this.allowSmoothing) {
            this.setSmoothed(false);
        }
    }

    public boolean getAllowSmoothing() {
        return this.allowSmoothing;
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }
}

