/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.display.PointProbe;
import visad.DateTime;
import visad.Real;
import visad.VisADException;

public class ChatLogControl
extends DisplayControlImpl {
    private JTable table;
    private AbstractTableModel tableModel;
    String filename;
    String textContents;
    List rawLines;
    List lines;
    List dates;
    private String year;
    private String timezone;
    private static String[] colNames = new String[]{"Date", "User", "Message"};

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        if (!this.setData(dataChoice)) {
            return false;
        }
        try {
            this.textContents = IOUtil.readContents(dataChoice.getStringId());
        }
        catch (Exception exc) {
            ChatLogControl.logException("Reading chat file:" + dataChoice.getStringId(), exc);
            return false;
        }
        this.filename = dataChoice.getStringId();
        if (!this.parseText()) {
            return false;
        }
        PointProbe probe = new PointProbe(0.0, 0.0, 0.0);
        probe.setVisible(false);
        this.addDisplayable(probe);
        return true;
    }

    private boolean parseText() {
        this.rawLines = StringUtil.split(this.textContents, "\n", true, true);
        this.lines = new ArrayList();
        this.dates = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("MMM d H:m:s yyyy-Z");
        Pattern pattern = Pattern.compile("([^<]+)<([^>]+)>(.*)");
        try {
            for (int i = 0; i < this.rawLines.size(); ++i) {
                String line = (String)this.rawLines.get(i);
                if (line.startsWith("***")) {
                    Pattern pattern2 = Pattern.compile("BEGIN.*(\\d\\d\\d\\d)$");
                    Matcher m = pattern2.matcher(line);
                    if (!m.find()) continue;
                    this.year = m.group(1);
                    continue;
                }
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (this.year == null) {
                    JTextField yearFld = new JTextField("2005", 8);
                    JTextField tzFld = new JTextField("GMT", 8);
                    GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
                    String exampleLine = StringUtil.replace(StringUtil.replace(line, "<", "&lt;"), ">", "&gt;");
                    JPanel panel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Year:"), yearFld, GuiUtils.rLabel("Timezone:"), tzFld}, 2, GuiUtils.WT_NN, GuiUtils.WT_N);
                    panel = GuiUtils.vbox(GuiUtils.inset((Component)GuiUtils.lLabel("Please enter the year and  timezone of the chat log"), 4), GuiUtils.inset((Component)GuiUtils.lLabel("<html>First line: <i>" + exampleLine + "</i>"), 4), panel);
                    if (!GuiUtils.showOkCancelDialog(null, "Chat Log Information", panel, null)) {
                        return false;
                    }
                    this.year = yearFld.getText().trim();
                    this.timezone = tzFld.getText().trim();
                }
                Date v = sdf.parse(matcher.group(1).trim() + " " + this.year + "-" + this.timezone);
                DateTime dttm = new DateTime(v);
                this.dates.add(dttm);
                this.lines.add(Misc.newList(dttm.toString(), matcher.group(2), matcher.group(3)));
            }
            this.setAnimationSet(this.dates);
        }
        catch (Exception exc) {
            ChatLogControl.logException("Error processing log", exc);
        }
        return true;
    }

    @Override
    protected void timeChanged(Real time) {
        try {
            int theIndex = this.getInternalAnimation(null).getCurrent();
            if (theIndex >= 0) {
                this.table.setRowSelectionInterval(theIndex, theIndex);
                GuiUtils.makeRowVisible(this.table, theIndex);
            }
        }
        catch (Exception exc) {
            ChatLogControl.logException("Error handling time change", exc);
        }
    }

    @Override
    protected String getTitle() {
        if (this.filename != null) {
            return this.filename;
        }
        return super.getTitle();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        this.tableModel = new AbstractTableModel(){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public int getRowCount() {
                return ChatLogControl.this.lines.size();
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }

            @Override
            public Object getValueAt(int row, int column) {
                List rowData;
                if (row < ChatLogControl.this.lines.size() && column < (rowData = (List)ChatLogControl.this.lines.get(row)).size()) {
                    return rowData.get(column);
                }
                return "";
            }

            @Override
            public String getColumnName(int column) {
                return colNames[column];
            }
        };
        this.table = new JTable(this.tableModel);
        int width = 300;
        int height = 400;
        JScrollPane scroller = GuiUtils.makeScrollPane(this.table, width, height);
        scroller.setBorder(BorderFactory.createLoweredBevelBorder());
        scroller.setPreferredSize(new Dimension(width, height));
        return GuiUtils.topCenter(GuiUtils.left(this.getAnimationWidget().getContents()), scroller);
    }

    public void setYear(String value) {
        this.year = value;
    }

    public String getYear() {
        return this.year;
    }

    public void setTimezone(String value) {
        this.timezone = value;
    }

    public String getTimezone() {
        return this.timezone;
    }
}

