/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.rmi.RemoteException;
import java.util.Hashtable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.idv.control.ColorPlanViewControl;
import visad.CommonUnit;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class CappiControl
extends ColorPlanViewControl {
    private static Real[] cappiLevels = null;

    public CappiControl() {
        this.setAttributeFlags(40);
    }

    @Override
    public void initDone() {
        super.initDone();
        this.updateLabels();
    }

    @Override
    protected Hashtable getRequestProperties() {
        Hashtable props = super.getRequestProperties();
        if (this.currentLevel == null) {
            this.currentLevel = CappiControl.getCappiLevels()[0];
        }
        props.put("Level2RadarDataSource.cappilevel", this.currentLevel);
        return props;
    }

    @Override
    public void setLevels(Object[] levels) {
        super.setLevels(CappiControl.getCappiLevels());
    }

    @Override
    protected boolean shouldShowZSelector() {
        return false;
    }

    @Override
    public void loadDataAtLevel(Object level) throws VisADException, RemoteException {
        super.loadDataAtLevel(level);
        this.updateLabels();
    }

    private void updateLabels() {
        this.setLevelReadoutLabel("Current level: " + this.formatLevel(this.currentLevel));
        this.updateLegendAndList();
    }

    private static Real[] getCappiLevels() {
        if (cappiLevels == null) {
            try {
                double[] levels = new double[]{1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0, 12000.0, 14000.0, 16000.0};
                cappiLevels = new Real[levels.length];
                for (int i = 0; i < levels.length; ++i) {
                    CappiControl.cappiLevels[i] = new Real(RealType.Altitude, levels[i], CommonUnit.meter);
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        return cappiLevels;
    }

    @Override
    protected DataInstance doMakeDataInstance(DataChoice dataChoice) throws RemoteException, VisADException {
        if (this.currentLevel == null) {
            this.currentLevel = this.getDataSelection().getFromLevel();
            if (this.currentLevel == null) {
                this.currentLevel = CappiControl.getCappiLevels()[0];
            }
        }
        this.getDataSelection().setLevel(this.currentLevel);
        return super.doMakeDataInstance(dataChoice);
    }

    @Override
    protected String getDataProjectionLabel() {
        return "Use Radar Projection";
    }

    @Override
    protected boolean canDoProgressiveResolution() {
        return false;
    }
}

