/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.idv.control.GridDisplayControl;
import ucar.unidata.util.GuiUtils;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SingletonSet;
import visad.VisADException;

public abstract class BaseImageControl
extends GridDisplayControl {
    protected static FieldImpl emptyRGBImage = null;
    protected static FieldImpl emptyImage = null;
    public static FieldImpl EMPTY_RGB_IMAGE = null;
    public static FieldImpl EMPTY_IMAGE = null;
    private float alpha = 1.0f;

    @Override
    protected String getDataProjectionLabel() {
        return "Use Native Image Projection";
    }

    protected FieldImpl getWorkingImage(FieldImpl image) throws VisADException {
        if (this.getSkipValue() <= 0) {
            return image;
        }
        return GridUtil.subset(image, this.getSkipValue() + 1);
    }

    @Override
    public String getSkipWidgetLabel() {
        return "Pixel Sampling";
    }

    protected JComponent doMakeAlphaSlider() {
        JSlider alphaSlider = GuiUtils.makeSlider(0, 100, 100 - (int)(this.getAlpha() * 100.0f), this, "setInverseAlphaFromSlider");
        JPanel transLabel = GuiUtils.leftRight(GuiUtils.lLabel("0%"), GuiUtils.rLabel("100%"));
        return GuiUtils.vbox(alphaSlider, transLabel);
    }

    public void setAlpha(float f) {
        this.alpha = f;
    }

    public float getAlpha() {
        return this.alpha;
    }

    protected void setAlphaFromSlider(float newAlpha) {
        try {
            this.alpha = newAlpha;
        }
        catch (Exception e) {
            BaseImageControl.logException("Setting alpha value", e);
        }
    }

    public void setInverseAlphaFromSlider(int sliderValue) {
        sliderValue = 100 - sliderValue;
        this.setAlphaFromSlider((float)((double)sliderValue / 100.0));
    }

    protected boolean showSkipFactorSlider() {
        return this.checkFlag(2048);
    }

    @Override
    public boolean getIsRaster() {
        return true;
    }

    static {
        try {
            RealType line = RealType.YAxis;
            RealType element = RealType.XAxis;
            RealType band = RealType.getRealType("band");
            RealType red = RealType.getRealType("r");
            RealType green = RealType.getRealType("g");
            RealType blue = RealType.getRealType("b");
            RealTupleType rgb = new RealTupleType(red, green, blue);
            RealTupleType domain = new RealTupleType(element, line);
            domain.setDefaultSet(new SingletonSet(new RealTuple(domain, new Real[]{new Real(element), new Real(line)}, null)));
            FlatField ff = new FlatField(new FunctionType(domain, band));
            emptyImage = ff;
            EMPTY_IMAGE = ff;
            FlatField ffRGB = new FlatField(new FunctionType(domain, rgb));
            emptyRGBImage = ffRGB;
            EMPTY_RGB_IMAGE = ffRGB;
        }
        catch (Exception ex) {
            System.out.println("Couldn't create empty set: " + ex);
        }
    }
}

