/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.ui.AudioPlayer;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import visad.VisADException;

public class AudioControl
extends DisplayControlImpl {
    private boolean saveAudio = false;
    private AudioPlayer audioPlayer;
    private byte[] audioBytes;
    private String recordFilename = "";
    private String playFilename = "";
    private AudioFormat audioFormat;
    private TargetDataLine targetDataLine;
    private JButton recordBtn;
    private boolean amRecording = false;
    private JTextField playFileField;
    private JTextField recordFileField;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        super.init(dataChoice);
        this.audioPlayer = new AudioPlayer();
        if (this.audioBytes != null) {
            try {
                String uid = "audio_" + Misc.getUniqueId();
                String file = this.getControlContext().getObjectStore().getTmpFile(uid);
                IOUtil.writeBytes(new File(file), this.audioBytes);
                this.audioPlayer.setFile(file);
            }
            catch (Exception exc) {
                AudioControl.logException("Saving audio bytes", exc);
            }
        } else if (dataChoice != null && this.playFilename.length() == 0) {
            this.playFilename = dataChoice.getStringId();
            this.audioPlayer.setFile(this.playFilename);
        }
        return true;
    }

    @Override
    public void initDone() {
        if (this.playFilename.trim().length() > 0) {
            this.audioPlayer.startPlaying();
        }
        super.initDone();
    }

    @Override
    public void doRemove() throws RemoteException, VisADException {
        super.doRemove();
        if (this.audioPlayer != null) {
            this.audioPlayer.close();
            this.audioPlayer = null;
        }
    }

    @Override
    protected String getTitle() {
        if (this.playFilename != null) {
            return IOUtil.getFileTail(this.playFilename);
        }
        return super.getTitle();
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.playFileField = new JTextField(this.playFilename, 30);
        JPanel filePanel = GuiUtils.label("File: ", GuiUtils.centerRight(this.playFileField, GuiUtils.makeButton("Select", this, "selectPlayFile")));
        tabbedPane.add("Play", GuiUtils.inset((Component)GuiUtils.topCenter(filePanel, this.audioPlayer), 5));
        tabbedPane.add("Record", GuiUtils.inset((Component)this.doMakeRecordContents(), 5));
        return tabbedPane;
    }

    private JComponent doMakeRecordContents() {
        this.recordFileField = new JTextField(this.recordFilename, 30);
        JPanel filePanel = GuiUtils.label("File: ", GuiUtils.centerRight(this.recordFileField, GuiUtils.makeButton("Select", this, "selectRecordFile")));
        this.recordBtn = GuiUtils.makeButton("Start Recording", this, "handleRecordBtn");
        JPanel buttons = GuiUtils.hbox(this.recordBtn, GuiUtils.makeCheckbox("Save file in bundle", this, "saveAudio"));
        return GuiUtils.top(GuiUtils.left(GuiUtils.vbox((Component)filePanel, buttons)));
    }

    public void handleRecordBtn() {
        if (this.amRecording) {
            this.stopRecording();
        } else {
            this.audioPlayer.stopPlaying();
            Misc.run(this, "startRecording");
        }
    }

    public void stopRecording() {
        if (!this.amRecording) {
            return;
        }
        this.amRecording = false;
        this.recordBtn.setText("Start Recording");
        if (this.targetDataLine != null) {
            this.targetDataLine.stop();
            this.targetDataLine.close();
        }
    }

    private AudioFormat getAudioFormat() {
        float sampleRate = 8000.0f;
        int sampleSizeInBits = 8;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void selectRecordFile() {
        PatternFileFilter filter = new PatternFileFilter(".+\\.au,.+\\.wav,.+\\.aiff", "Audio files");
        String filename = FileManager.getWriteFile(filter, ".au");
        if (filename == null) {
            return;
        }
        this.recordFileField.setText(filename);
        this.playFileField.setText(filename);
        this.audioPlayer.setFile(this.getPlayFilename());
    }

    public void selectPlayFile() {
        PatternFileFilter filter = new PatternFileFilter(".+\\.au,.+\\.wav,.+\\.aiff", "Audio files");
        String filename = FileManager.getReadFile(filter);
        if (filename == null) {
            return;
        }
        this.playFileField.setText(filename);
        this.audioPlayer.setFile(this.getPlayFilename());
    }

    public void startRecording() {
        try {
            if (this.getRecordFilename().length() == 0) {
                this.selectRecordFile();
            }
            if (this.getRecordFilename().length() == 0) {
                return;
            }
            this.amRecording = true;
            this.recordBtn.setText("Stop Recording");
            this.audioPlayer.setFile(this.getRecordFilename());
            this.updateLegendLabel();
            this.audioFormat = this.getAudioFormat();
            DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(dataLineInfo);
            String ext = IOUtil.getFileExtension(this.getRecordFilename()).toLowerCase();
            AudioFileFormat.Type fileType = null;
            fileType = ext.equals(".aifc") ? AudioFileFormat.Type.AIFC : (ext.equals(".aiff") ? AudioFileFormat.Type.AIFF : (ext.equals(".snd") ? AudioFileFormat.Type.SND : (ext.equals(".wav") ? AudioFileFormat.Type.WAVE : AudioFileFormat.Type.AU)));
            File audioFile = new File(this.getRecordFilename());
            this.targetDataLine.open(this.audioFormat);
            this.targetDataLine.start();
            AudioSystem.write(new AudioInputStream(this.targetDataLine), fileType, audioFile);
        }
        catch (Exception e) {
            AudioControl.logException("Error capturing audio", e);
        }
    }

    public void setRecordFilename(String value) {
        this.recordFilename = value;
    }

    public String getRecordFilename() {
        if (this.recordFileField != null) {
            this.recordFilename = this.recordFileField.getText().trim();
        }
        return this.recordFilename;
    }

    public void setPlayFilename(String value) {
        this.playFilename = value;
    }

    public String getPlayFilename() {
        if (this.playFileField != null) {
            this.playFilename = this.playFileField.getText().trim();
        }
        return this.playFilename;
    }

    public void setSaveAudio(boolean value) {
        this.saveAudio = value;
    }

    public boolean getSaveAudio() {
        return this.saveAudio;
    }

    public void setAudioBytes(byte[] value) {
        this.audioBytes = value;
    }

    public byte[] getAudioBytes() throws IOException {
        if (this.recordFilename == null || this.recordFilename.length() == 0 || !this.saveAudio) {
            return null;
        }
        File f = new File(this.recordFilename);
        if (!f.exists()) {
            return null;
        }
        return IOUtil.readBytes(new FileInputStream(f));
    }
}

