/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import ucar.unidata.data.DataChoice;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.Animation;
import ucar.visad.display.CompositeDisplayable;
import visad.DateTime;
import visad.Real;
import visad.VisADException;

public class AnimationTextControl
extends DisplayControlImpl
implements HyperlinkListener {
    private DateTime currentTime;
    private List textList = new ArrayList();
    private JEditorPane editor;
    private JTextField subjectFld;
    private JComboBox timeBox;
    private boolean ignoreBoxEvents = false;
    private JCheckBox listenCbx;
    private boolean listenOnAnimation = true;

    @Override
    public boolean init(DataChoice dataChoice) throws VisADException, RemoteException {
        CompositeDisplayable holder = new CompositeDisplayable();
        this.addDisplayable(holder);
        return true;
    }

    @Override
    public void initDone() {
        super.initDone();
        try {
            Animation animation = this.getViewAnimation();
            if (animation != null) {
                this.setTime(animation.getAniValue());
            }
        }
        catch (Exception exc) {
            AnimationTextControl.logException("initDone", exc);
        }
    }

    private DatedText findDatedText(DateTime dttm) throws VisADException {
        if (dttm == null) {
            return null;
        }
        Date date = Util.makeDate(dttm);
        for (int i = 0; i < this.textList.size(); ++i) {
            DatedText datedObject = (DatedText)this.textList.get(i);
            if (!datedObject.getDate().equals(date)) continue;
            return datedObject;
        }
        return null;
    }

    private void setDatedText(DatedText dt) {
        try {
            this.ignoreBoxEvents = true;
            DatedText oldDT = this.findDatedText(this.currentTime);
            if (oldDT != null) {
                oldDT.setText(this.editor.getText());
                oldDT.setSubject(this.subjectFld.getText());
            }
            if (dt == null) {
                this.editor.setText("");
                this.subjectFld.setText("");
                this.timeBox.setSelectedItem("none");
                this.currentTime = null;
            } else {
                this.editor.setText(dt.getText());
                this.subjectFld.setText(dt.getSubject());
                this.timeBox.setSelectedItem(dt);
                try {
                    this.currentTime = dt.getDateTime();
                }
                catch (Exception exc) {
                    AnimationTextControl.logException("Time changed", exc);
                }
            }
        }
        catch (Exception exc) {
            AnimationTextControl.logException("Changing times", exc);
        }
        this.ignoreBoxEvents = false;
    }

    private void setTime(Real time) {
        try {
            if (Misc.equals(time, this.currentTime)) {
                return;
            }
            if (time == null || time != null && !(time instanceof DateTime)) {
                this.setDatedText(null);
                return;
            }
            DatedText newDT = this.findDatedText((DateTime)time);
            if (newDT == null) {
                newDT = new DatedText(Util.makeDate((DateTime)time));
                this.textList.add(newDT);
                this.textList = DatedObject.sort(this.textList, true);
                this.ignoreBoxEvents = true;
                GuiUtils.setListData(this.timeBox, this.textList);
                this.ignoreBoxEvents = false;
            }
            this.setDatedText(newDT);
        }
        catch (Exception exc) {
            AnimationTextControl.logException("Time changed", exc);
        }
    }

    @Override
    protected void timeChanged(Real time) {
        if (this.getListenOnAnimation()) {
            this.setTime(time);
        }
        super.timeChanged(time);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
    }

    public void goToNextTime() {
        int index = this.timeBox.getSelectedIndex();
        if (index < this.textList.size() - 1) {
            this.timeBox.setSelectedIndex(index + 1);
        }
    }

    public void goToPrevTime() {
        int index = this.timeBox.getSelectedIndex();
        if (index >= 1) {
            this.timeBox.setSelectedIndex(index - 1);
        }
    }

    @Override
    public Container doMakeContents() {
        this.subjectFld = new JTextField();
        this.editor = new JEditorPane();
        this.editor.addKeyListener(new KeyAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    if (e.getKeyCode() == 78) {
                        AnimationTextControl.this.goToNextTime();
                        return;
                    }
                }
                if (!e.isControlDown()) return;
                if (e.getKeyCode() != 80) return;
                AnimationTextControl.this.goToPrevTime();
            }
        });
        this.editor.setToolTipText("Control-n: go to next time; Control-p: Go to previous time");
        this.editor.setEditable(true);
        this.editor.addHyperlinkListener(this);
        this.editor.setContentType("text/html");
        this.listenCbx = new JCheckBox("Synchronize with animation", this.listenOnAnimation);
        this.listenCbx.setToolTipText("Change text display when animation changes");
        JScrollPane scroller = GuiUtils.makeScrollPane(this.editor, 300, 200);
        scroller.setPreferredSize(new Dimension(300, 200));
        this.timeBox = new JComboBox();
        this.timeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (AnimationTextControl.this.ignoreBoxEvents) {
                    return;
                }
                Object item = AnimationTextControl.this.timeBox.getSelectedItem();
                if (item == null || !(item instanceof DatedText)) {
                    item = null;
                }
                AnimationTextControl.this.setDatedText((DatedText)item);
            }
        });
        this.ignoreBoxEvents = true;
        GuiUtils.setListData(this.timeBox, this.textList);
        this.ignoreBoxEvents = false;
        JButton deleteBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Delete16.gif", this, "deleteCurrent");
        deleteBtn.setToolTipText("Delete current time step");
        JPanel footer = GuiUtils.leftRight(GuiUtils.hbox(deleteBtn, GuiUtils.label("Time: ", this.timeBox)), GuiUtils.inset((Component)this.listenCbx, new Insets(0, 20, 0, 0)));
        return GuiUtils.topCenterBottom(GuiUtils.label("Subject: ", this.subjectFld), scroller, GuiUtils.inset((Component)footer, 3));
    }

    public void deleteCurrent() {
        try {
            DatedText oldDT = this.findDatedText(this.currentTime);
            if (oldDT != null) {
                this.textList.remove(oldDT);
                this.ignoreBoxEvents = true;
                GuiUtils.setListData(this.timeBox, this.textList);
                this.ignoreBoxEvents = false;
                if (this.textList.size() > 0) {
                    this.setDatedText((DatedText)this.textList.get(0));
                } else {
                    this.setDatedText(null);
                }
            }
        }
        catch (Exception exc) {
            AnimationTextControl.logException("Deleting time step", exc);
        }
    }

    @Override
    protected boolean shouldAddAnimationListener() {
        return true;
    }

    public void setTextList(List value) {
        this.textList = value;
    }

    public List getTextList() {
        try {
            DatedText oldDT = this.findDatedText(this.currentTime);
            if (oldDT != null) {
                oldDT.setText(this.editor.getText());
                oldDT.setSubject(this.subjectFld.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.textList;
    }

    public void setListenOnAnimation(boolean value) {
        this.listenOnAnimation = value;
        if (this.listenCbx != null) {
            this.listenCbx.setSelected(value);
        }
    }

    public boolean getListenOnAnimation() {
        if (this.listenCbx != null) {
            return this.listenCbx.isSelected();
        }
        return this.listenOnAnimation;
    }

    public static class DatedText
    extends DatedObject {
        private String subject = "";

        public DatedText() {
        }

        public DatedText(Date date) {
            super(date, "");
        }

        public String getText() {
            return (String)this.getObject();
        }

        protected void setText(String text) {
            super.setObject(text);
        }

        public DateTime getDateTime() throws VisADException {
            return new DateTime(this.getDate());
        }

        public void setSubject(String value) {
            this.subject = value;
        }

        public String getSubject() {
            return this.subject;
        }

        @Override
        public String toString() {
            return this.getDate() + "";
        }
    }
}

