/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.control;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import ucar.unidata.idv.HodographViewManager;
import ucar.unidata.idv.SoundingViewManager;
import ucar.unidata.idv.ViewDescriptor;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.control.DisplayControlBase;
import ucar.unidata.idv.control.DisplayControlImpl;
import ucar.unidata.idv.control.SoundingTable;
import ucar.unidata.idv.control.TableNumberCellRenderer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.view.sounding.AerologicalCellNetwork;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.AerologicalDisplay;
import ucar.unidata.view.sounding.AerologicalDisplayConstants;
import ucar.unidata.view.sounding.AerologicalReadoutTable;
import ucar.unidata.view.sounding.CellNetwork;
import ucar.unidata.view.sounding.Hodograph3DDisplay;
import ucar.unidata.view.sounding.ParcelMode;
import ucar.unidata.view.sounding.PseudoAdiabaticDisplayable;
import ucar.unidata.view.sounding.RealEvaluatorCell;
import ucar.unidata.view.sounding.Sounding;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableDataRef;
import ucar.visad.functiontypes.AirTemperatureProfile;
import ucar.visad.functiontypes.CartesianHorizontalWindOfPressure;
import ucar.visad.functiontypes.DewPointProfile;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.PolarHorizontalWind;
import visad.ActionImpl;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ReferenceException;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.util.DataUtility;

public abstract class AerologicalSoundingControl
extends DisplayControlImpl
implements AerologicalDisplayConstants {
    protected SoundingViewManager soundingView;
    protected HodographViewManager hodoView;
    protected AerologicalDisplay aeroDisplay;
    protected Hodograph3DDisplay hodoDisplay;
    protected SoundingTable soundingTable;
    protected JLabel headerLabel;
    private JPanel readoutPanel;
    private JCheckBox showUVCbx;
    private PseudoAdiabaticDisplayable parcelPath;
    private DisplayableDataRef parVirtTempPath;
    private DisplayableDataRef envVirtTempPath;
    private boolean trajectoryActive = false;
    private boolean virtTempActive = false;
    private int parcelModeIndex = 0;
    private CellNetwork proEvalNet;
    private AerologicalCellNetwork aeroCellNet;
    private DataReferenceImpl tempProRef;
    private DataReferenceImpl dewProRef;
    private DataReferenceImpl windProRef;
    private Field[] tempProfiles;
    private Field[] dewProfiles;
    private Field[] windProfiles;
    private int currIndex = 0;
    private boolean spatialLociVisible;
    private Displayable spatialLoci;
    private String displayType = "skewT";
    private static float[] MANDATORY_LEVEL_VALUES = new float[]{1000.0f, 925.0f, 850.0f, 700.0f, 500.0f, 400.0f, 300.0f, 250.0f, 200.0f, 150.0f, 100.0f};
    private static final String ALL_LEVELS = "All";
    private static final String MANDATORY_LEVELS = "Mandatory Levels";
    private String windBarbSpacing = "All";
    private DataReferenceImpl cursorPresRef;
    private DataReferenceImpl pointerPresRef;
    private DataReferenceImpl cursorTempRef;
    private DataReferenceImpl cursorWindRef;
    private DataReferenceImpl pointerTempRef;
    private AerologicalReadoutTable readoutTable;
    private LatLonPoint location;
    private boolean haveWinds = false;
    private boolean haveDewpoints = true;
    private boolean haveUAndVWinds = false;
    private boolean showUAndVWinds = false;
    private JTabbedPane viewTabs;
    private List<MyActionImpl> actions = new ArrayList<MyActionImpl>();
    private static ParcelModeInfo[] parcelModeInfos = new ParcelModeInfo[]{new ParcelModeInfo("Bottom of Sounding", ParcelMode.BOTTOM), new ParcelModeInfo("Below Cursor", ParcelMode.LAYER), new ParcelModeInfo("At Cursor Pressure", ParcelMode.PRESSURE), new ParcelModeInfo("At Cursor (Press,Temp)", ParcelMode.POINT)};

    AerologicalSoundingControl(boolean lociVisible) throws VisADException, RemoteException {
        this.setAttributeFlags(4);
        this.spatialLociVisible = lociVisible;
    }

    boolean init() throws VisADException, RemoteException {
        if (this.soundingView != null) {
            this.displayType = this.soundingView.getChartType();
        }
        this.aeroDisplay = AerologicalDisplay.getInstance(this.displayType, this.getGraphicsConfiguration(true, false));
        this.hodoDisplay = new Hodograph3DDisplay();
        if (this.soundingView != null) {
            this.soundingView.setSoundingDisplay(this.aeroDisplay);
            this.soundingView.initAfterUnPersistence(this.getIdv());
        } else {
            this.soundingView = new SoundingViewManager(this.getViewContext(), this.aeroDisplay, new ViewDescriptor("SoundingView"), "showControlLegend=false;wireframe=false;aniReadout=false;chartType=" + this.displayType);
        }
        if (this.hodoView != null) {
            this.hodoView.setHodographDisplay(this.hodoDisplay);
            this.hodoView.initAfterUnPersistence(this.getIdv());
        } else {
            this.hodoView = new HodographViewManager(this.getViewContext(), this.hodoDisplay, new ViewDescriptor("SoundingView"), "showControlLegend=false;wireframe=false;aniReadout=false;");
        }
        this.addViewManager(this.soundingView);
        this.addViewManager(this.hodoView);
        this.soundingTable = new SoundingTable(this);
        this.soundingTable.setDefaultRenderer(Number.class, new TableNumberCellRenderer());
        this.soundingTable.setShowUVComps(this.showUAndVWinds);
        this.headerLabel = new JLabel(" ", 2);
        this.tempProRef = new DataReferenceImpl("TemperatureProfile");
        this.dewProRef = new DataReferenceImpl("DewPointProfile");
        this.windProRef = new DataReferenceImpl("WindProfile");
        this.dewProRef.setData(DewPointProfile.instance().missingData());
        this.tempProRef.setData(AirTemperatureProfile.instance().missingData());
        this.windProRef.setData(CartesianHorizontalWindOfPressure.instance().missingData());
        this.cursorPresRef = new DataReferenceImpl("CursorPressure");
        this.pointerPresRef = new DataReferenceImpl("PointerPressure");
        this.cursorTempRef = new DataReferenceImpl("CursorTemperature");
        this.cursorWindRef = new DataReferenceImpl("CursorWind");
        this.pointerTempRef = new DataReferenceImpl("pointerTemperature");
        DataReferenceImpl minPresRef = new DataReferenceImpl("MinimumPressure");
        minPresRef.setData(this.aeroDisplay.getMinimumPressure());
        this.cursorPresRef.setData(AirPressure.getRealType().missingData());
        this.pointerPresRef.setData(AirPressure.getRealType().missingData());
        this.cursorTempRef.setData(AirTemperature.getRealType().missingData());
        this.cursorWindRef.setData(CartesianHorizontalWind.getRealTupleType().missingData());
        this.pointerTempRef.setData(AirTemperature.getRealType().missingData());
        this.aeroCellNet = new AerologicalCellNetwork(this.tempProRef, this.dewProRef, this.cursorPresRef, this.cursorTempRef, minPresRef, this.windProRef);
        this.setParcelMode(this.parcelModeIndex);
        this.parcelPath = new PseudoAdiabaticDisplayable(this.aeroCellNet.getDryTrajectoryRef(), this.aeroCellNet.getWetTrajectoryRef());
        this.parcelPath.setLineWidth(2.0f);
        this.parcelPath.setColor(Color.pink);
        this.addDisplayable((Displayable)this.parcelPath, this.soundingView);
        this.parVirtTempPath = new DisplayableDataRef(this.aeroCellNet.getParcelVirtualTemperatureProfileRef());
        this.parVirtTempPath.setLineWidth(2.0f);
        this.parVirtTempPath.setLineStyle(1);
        this.parVirtTempPath.setColor(Color.pink);
        this.addDisplayable((Displayable)this.parVirtTempPath, this.soundingView);
        this.envVirtTempPath = new DisplayableDataRef(this.aeroCellNet.getEnvironmentVirtualTemperatureProfileRef());
        this.envVirtTempPath.setLineWidth(2.0f);
        this.envVirtTempPath.setLineStyle(1);
        this.envVirtTempPath.setColor(Color.red);
        this.addDisplayable((Displayable)this.envVirtTempPath, this.soundingView);
        this.readoutTable = new AerologicalReadoutTable();
        this.aeroDisplay.addPropertyChangeListener(this);
        this.actions.add(new MyActionImpl("ProfileTemperature", this.readoutTable, this.aeroCellNet.getProfileTemperatureRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setProfileTemperature(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("ProfileDewPoint", this.readoutTable, this.aeroCellNet.getProfileDewPointRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setProfileDewPoint(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("ProfileMixingRatio", this.readoutTable, this.aeroCellNet.getProfileMixingRatioRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setProfileMixingRatio(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LclPressure", this.readoutTable, this.aeroCellNet.getLclPressureRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLclPressure(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LclTemperature", this.readoutTable, this.aeroCellNet.getLclTemperatureRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLclTemperature(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("CAPE", this.readoutTable, this.aeroCellNet.getCapeRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setCape(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LFC", this.readoutTable, this.aeroCellNet.getLfcRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLfc(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LfcTemperature", this.readoutTable, this.aeroCellNet.getLfcTemperatureRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLfcTemperature(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LNB", this.readoutTable, this.aeroCellNet.getLnbRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLnb(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("LnbTemperature", this.readoutTable, this.aeroCellNet.getLnbTemperatureRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setLnbTemperature(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("CIN", this.readoutTable, this.aeroCellNet.getCinRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setCin(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.proEvalNet = new CellNetwork();
        RealEvaluatorCell proTempAtPointPres = new RealEvaluatorCell(this.tempProRef, this.pointerPresRef, this.cursorTempRef.getData());
        this.proEvalNet.add(proTempAtPointPres);
        RealEvaluatorCell proDewAtPointPres = new RealEvaluatorCell(this.dewProRef, this.pointerPresRef, this.cursorTempRef.getData());
        this.proEvalNet.add(proDewAtPointPres);
        RealEvaluatorCell proWindAtPointPres = new RealEvaluatorCell(this.windProRef, this.pointerPresRef, this.cursorWindRef.getData());
        this.proEvalNet.add(proWindAtPointPres);
        this.proEvalNet.configure();
        this.actions.add(new MyActionImpl("PointerProfileTemperature", this.readoutTable, proTempAtPointPres.getOutputRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setProfileTemperature(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("PointerProfileDewPoint", this.readoutTable, proDewAtPointPres.getOutputRef()){

            @Override
            public void doAction() {
                try {
                    this.readoutTable.setProfileDewPoint(this.getReal());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.actions.add(new MyActionImpl("PointerProfileWind", this.readoutTable, proWindAtPointPres.getOutputRef()){

            @Override
            public void doAction() {
                try {
                    RealTuple spdDir = (RealTuple)this.getDataReference().getData();
                    if (!PolarHorizontalWind.getRealTupleType().equals((RealTupleType)spdDir.getType())) {
                        spdDir = PolarHorizontalWind.newRealTuple(spdDir);
                    }
                    this.readoutTable.setProfileWindSpeed((Real)spdDir.getComponent(0));
                    this.readoutTable.setProfileWindDirection((Real)spdDir.getComponent(1));
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        this.readoutPanel = new JPanel();
        this.readoutPanel.setLayout(new BorderLayout());
        this.readoutPanel.add(this.readoutTable);
        this.aeroDisplay.draw();
        this.hodoDisplay.draw();
        this.setTrajectoryActive(this.trajectoryActive);
        this.setVirtTempActive(this.virtTempActive);
        return true;
    }

    @Override
    protected void getSaveMenuItems(List items, boolean forMenuBar) {
        super.getSaveMenuItems(items, forMenuBar);
        items.add(GuiUtils.makeMenuItem("Export Sounding Table to File...", this, "exportTableToCsv"));
    }

    public void exportTableToCsv() {
        if (this.soundingTable == null) {
            return;
        }
        String header = "";
        if (this.headerLabel != null) {
            header = this.headerLabel.getText();
        }
        GuiUtils.exportAsCsv(header, this.soundingTable.getModel(), true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        try {
            if (event.getPropertyName().equals("cursorPressure")) {
                Real pressure = (Real)event.getNewValue();
                this.cursorPresRef.setData(pressure);
                this.readoutTable.setPressure(pressure);
            } else if (event.getPropertyName().equals("pointerPressure")) {
                Real pressure = (Real)event.getNewValue();
                this.pointerPresRef.setData(pressure);
                this.readoutTable.setPressure(pressure);
            } else if (event.getPropertyName().equals("cursorTemperature")) {
                Real temp = (Real)event.getNewValue();
                this.cursorTempRef.setData(temp);
                this.readoutTable.setBackgroundTemperature(temp);
            } else if (event.getPropertyName().equals("pointerTemperature")) {
                Real temp = (Real)event.getNewValue();
                this.readoutTable.setBackgroundTemperature(temp);
            } else {
                super.propertyChange(event);
            }
        }
        catch (Exception e) {
            AerologicalSoundingControl.logException(e);
        }
    }

    @Override
    public void addPropertiesComponents(JTabbedPane jtp) {
        super.addPropertiesComponents(jtp);
        if (this.soundingView != null) {
            jtp.add("Sounding Chart", this.soundingView.getPropertiesComponent());
        }
        if (this.hodoView != null) {
            jtp.add("Hodograph", this.hodoView.getPropertiesComponent());
        }
    }

    @Override
    public boolean doApplyProperties() {
        if (!super.doApplyProperties()) {
            return false;
        }
        if (this.soundingView != null) {
            return this.soundingView.applyProperties();
        }
        return true;
    }

    @Override
    public void doRemove() throws VisADException, RemoteException {
        super.doRemove();
        if (this.actions != null) {
            for (MyActionImpl action : this.actions) {
                action.doRemove();
            }
            this.actions = null;
        }
        this.soundingView = null;
        this.aeroDisplay = null;
        this.hodoView = null;
        this.hodoDisplay = null;
        this.soundingTable = null;
        this.headerLabel = null;
        this.readoutPanel = null;
        this.parcelPath = null;
        this.parVirtTempPath = null;
        this.envVirtTempPath = null;
        this.proEvalNet = null;
        this.aeroCellNet = null;
        this.tempProRef = null;
        this.dewProRef = null;
        this.windProRef = null;
        this.tempProfiles = null;
        this.dewProfiles = null;
        this.windProfiles = null;
    }

    protected void setSpatialLoci(Displayable loci) {
        this.spatialLoci = loci;
        try {
            this.setSpatialLociVisible(this.spatialLociVisible);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSpatialLociVisible(boolean visible) throws VisADException, RemoteException {
        this.spatialLociVisible = visible;
        if (this.spatialLoci != null) {
            this.spatialLoci.setVisible(this.getDisplayVisibility() && this.spatialLociVisible);
        }
    }

    @Override
    public void setDisplayVisibility(boolean on) {
        if (this.settingVisibility) {
            return;
        }
        if (!this.getHaveInitialized()) {
            return;
        }
        super.setDisplayVisibility(on);
        try {
            this.setSpatialLociVisible(this.spatialLociVisible);
            this.setTrajectoryActive(this.trajectoryActive);
            this.setVirtTempActive(this.virtTempActive);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getSpatialLociVisible() {
        return this.spatialLociVisible;
    }

    public int getCurrentIdx() {
        return this.currIndex;
    }

    void setSounding(int index) throws VisADException, RemoteException {
        if (this.tempProfiles != null) {
            try {
                this.aeroDisplay.setProfileVisible(this.currIndex, false);
                this.aeroDisplay.setProfileVisible(index, true);
                if (this.haveWinds) {
                    this.hodoDisplay.setProfileVisible(this.currIndex, false);
                }
                if (this.haveWinds) {
                    this.hodoDisplay.setProfileVisible(index, true);
                }
                try {
                    this.aeroDisplay.setActiveSounding(index);
                    if (this.haveWinds) {
                        this.hodoDisplay.setActiveWindProfile(index);
                    }
                    Sounding s = this.aeroDisplay.getActiveSounding();
                    this.setSounding(s.getTemperatureField(), s.getDewPointField(), this.windProfiles[index]);
                    this.currIndex = index;
                }
                catch (VisADException ex) {
                    this.aeroDisplay.setProfileVisible(index, false);
                    if (this.haveWinds) {
                        this.hodoDisplay.setProfileVisible(index, false);
                    }
                    throw ex;
                }
                catch (RemoteException ex) {
                    this.aeroDisplay.setProfileVisible(index, false);
                    if (this.haveWinds) {
                        this.hodoDisplay.setProfileVisible(index, false);
                    }
                    throw ex;
                }
                this.soundingTable.setCurrentSounding(this.currIndex);
            }
            catch (VisADException ex) {
                Sounding s = this.aeroDisplay.getActiveSounding();
                this.setSounding(s.getTemperatureField(), s.getDewPointField(), this.windProfiles[this.currIndex]);
                throw ex;
            }
            catch (RemoteException ex) {
                Sounding s = this.aeroDisplay.getActiveSounding();
                this.setSounding(this.tempProfiles[this.currIndex], this.dewProfiles[this.currIndex], this.windProfiles[this.currIndex]);
                throw ex;
            }
            this.updateHeaderLabel();
        }
    }

    public int getCurrentIndex() {
        return this.currIndex;
    }

    private void setSounding(Field tempPro, Field dewPro, Field windPro) throws VisADException, RemoteException {
        this.dewProRef.setData(dewPro);
        this.tempProRef.setData(tempPro);
        this.windProRef.setData(windPro);
        this.updateLegendAndList();
    }

    protected synchronized void setSoundings(Field[] tempPros, Field[] dewPros, Field[] windPros) throws VisADException, RemoteException {
        int i;
        int n = tempPros.length;
        if (this.tempProfiles == null) {
            this.tempProfiles = (Field[])tempPros.clone();
            this.dewProfiles = (Field[])dewPros.clone();
            this.windProfiles = (Field[])windPros.clone();
        } else {
            this.tempProfiles = new Field[n];
            this.dewProfiles = new Field[n];
            this.windProfiles = new Field[n];
            System.arraycopy(tempPros, 0, this.tempProfiles, 0, n);
            System.arraycopy(dewPros, 0, this.dewProfiles, 0, n);
            System.arraycopy(windPros, 0, this.windProfiles, 0, n);
        }
        Field[] tableSoundings = new Field[n];
        this.hodoDisplay.clear();
        for (i = 0; i < n; ++i) {
            if (i == 0 && this.windProfiles[i] != null) {
                this.haveWinds = true;
                RealTupleType windTuple = DataUtility.getFlatRangeType(this.windProfiles[i]);
                if (Unit.canConvert(((RealType)windTuple.getComponent(0)).getDefaultUnit(), CommonUnit.meterPerSecond) && Unit.canConvert(((RealType)windTuple.getComponent(1)).getDefaultUnit(), CommonUnit.meterPerSecond)) {
                    this.haveUAndVWinds = true;
                }
            }
            if (this.dewProfiles[i] == null) {
                this.haveDewpoints = false;
            }
            if (this.showUVCbx != null) {
                this.showUVCbx.setEnabled(this.haveWinds);
            }
            this.aeroDisplay.addProfile(i, this.tempProfiles[i], this.dewProfiles[i], this.windProfiles[i]);
            if (this.haveWinds) {
                this.hodoDisplay.addProfile(i, this.windProfiles[i]);
            }
            if (!this.haveWinds) {
                if (!this.haveDewpoints) {
                    tableSoundings[i] = FieldImpl.combine(new Field[]{this.tempProfiles[i]}, true);
                    continue;
                }
                tableSoundings[i] = FieldImpl.combine(new Field[]{this.tempProfiles[i], this.dewProfiles[i]}, true);
                continue;
            }
            tableSoundings[i] = FieldImpl.combine(new Field[]{this.tempProfiles[i], this.dewProfiles[i], this.windProfiles[i]}, true);
        }
        for (i = 0; i < n; ++i) {
            this.aeroDisplay.setProfileVisible(i, false);
        }
        this.aeroDisplay.setProfileVisible(this.currIndex, true);
        if (this.haveWinds) {
            this.hodoDisplay.setProfileVisible(this.currIndex, true);
        }
        this.soundingTable.setSoundings(tableSoundings);
        this.soundingTable.setCurrentSounding(this.currIndex);
        if (this.viewTabs != null) {
            this.viewTabs.setEnabledAt(this.viewTabs.indexOfTab("Hodograph"), this.haveWinds);
        }
        this.setSounding(this.currIndex);
    }

    protected final String xxxgetTitle() {
        return "SkewT";
    }

    public final synchronized boolean getTrajectoryActive() {
        return this.trajectoryActive;
    }

    public final synchronized void setTrajectoryActive(boolean active) throws VisADException, RemoteException {
        this.trajectoryActive = active;
        if (this.parcelPath != null) {
            this.parcelPath.setVisible(this.trajectoryActive);
        }
        if (this.parVirtTempPath != null) {
            this.parVirtTempPath.setVisible(this.trajectoryActive && this.virtTempActive);
        }
    }

    public final synchronized boolean getVirtTempActive() {
        return this.virtTempActive;
    }

    public final synchronized void setVirtTempActive(boolean active) throws VisADException, RemoteException {
        this.virtTempActive = active;
        if (this.envVirtTempPath != null) {
            this.envVirtTempPath.setVisible(this.virtTempActive);
        }
        if (this.parVirtTempPath != null) {
            this.parVirtTempPath.setVisible(this.trajectoryActive && this.virtTempActive);
        }
    }

    public final synchronized ParcelMode getParcelMode() {
        return parcelModeInfos[this.parcelModeIndex].mode;
    }

    public final synchronized void setParcelMode(ParcelMode mode) throws VisADException, RemoteException {
        for (int i = 0; i < parcelModeInfos.length; ++i) {
            if (parcelModeInfos[i].mode != mode) continue;
            this.setParcelMode(i);
            break;
        }
    }

    private void setParcelMode(int i) throws VisADException, RemoteException {
        if (i >= 0 && i < parcelModeInfos.length) {
            if (this.aeroCellNet != null) {
                this.aeroCellNet.setParcelMode(parcelModeInfos[i].mode);
            }
            this.parcelModeIndex = i;
        }
    }

    @Override
    protected Container doMakeContents() throws VisADException, RemoteException {
        JCheckBox trajBox = new JCheckBox("Parcel Path", this.trajectoryActive);
        trajBox.setToolTipText("Display Parcel's Pseudoadiabatic Path");
        trajBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    AerologicalSoundingControl.this.setTrajectoryActive(event.getStateChange() == 1);
                }
                catch (Exception e) {
                    DisplayControlBase.logException(e);
                }
            }
        });
        JCheckBox virtTempBox = new JCheckBox("Virtual Temperature", this.virtTempActive);
        virtTempBox.setToolTipText("Display Virtual Temperatures");
        virtTempBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    AerologicalSoundingControl.this.setVirtTempActive(event.getStateChange() == 1);
                }
                catch (Exception e) {
                    DisplayControlBase.logException(e);
                }
            }
        });
        JCheckBox pairProfilesBox = GuiUtils.makeCheckbox("", this, "pairProfilesVisibility");
        pairProfilesBox.setSelected(false);
        final JComboBox<ParcelModeInfo> parcelModeBox = new JComboBox<ParcelModeInfo>(parcelModeInfos);
        parcelModeBox.setToolTipText("Parcel Determination Mode");
        parcelModeBox.setSelectedIndex(this.parcelModeIndex);
        parcelModeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    AerologicalSoundingControl.this.setParcelMode(parcelModeBox.getSelectedIndex());
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        String[] spacings = new String[]{ALL_LEVELS, MANDATORY_LEVELS, "10", "25", "50", "100"};
        final JComboBox<String> spacingBox = new JComboBox<String>(spacings);
        spacingBox.setToolTipText("Wind Barb Spacing");
        spacingBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String tmp = (String)spacingBox.getSelectedItem();
                    AerologicalSoundingControl.this.setWindLevels(tmp);
                    AerologicalSoundingControl.this.windBarbSpacing = tmp;
                }
                catch (Exception ex) {
                    DisplayControlBase.logException(ex);
                }
            }
        });
        spacingBox.setSelectedItem(this.windBarbSpacing);
        JCheckBox showBox = new JCheckBox(this.getSpatialLociLabel(), this.spatialLociVisible);
        showBox.setToolTipText("Show Spatial Loci of Soundings in Main, 3-D Window");
        showBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                try {
                    AerologicalSoundingControl.this.setSpatialLociVisible(event.getStateChange() == 1);
                }
                catch (Exception e) {
                    DisplayControlBase.logException(e);
                }
            }
        });
        ArrayList<JCheckBox> lineControls = new ArrayList<JCheckBox>();
        lineControls.add(GuiUtils.makeCheckbox("Dry Adiabats", this.soundingView, "dryAdiabatVisibility"));
        lineControls.add(GuiUtils.makeCheckbox("Saturation Adiabats", this.soundingView, "saturationAdiabatVisibility"));
        lineControls.add(GuiUtils.makeCheckbox("Mixing Ratio", this.soundingView, "saturationMixingRatioVisibility"));
        JPanel lines = GuiUtils.left(GuiUtils.vbox(lineControls));
        GuiUtils.tmpInsets = new Insets(4, 4, 4, 4);
        JPanel comboBoxes = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Parcel mode:"), parcelModeBox, GuiUtils.filler(), GuiUtils.rLabel("Wind spacing:"), spacingBox, GuiUtils.lLabel("(hPa)"), GuiUtils.rLabel("Consecutive Profiles:"), pairProfilesBox, GuiUtils.filler()}, 3, GuiUtils.WT_N, GuiUtils.WT_N);
        JPanel checkBoxes = GuiUtils.vbox(trajBox, virtTempBox, showBox);
        JPanel viewOptions = GuiUtils.doLayout(new Component[]{lines, checkBoxes, GuiUtils.top(comboBoxes)}, 3, GuiUtils.WT_N, GuiUtils.WT_N);
        Component specificWidget = this.getSpecificWidget();
        JScrollPane bottomComp = new JScrollPane(viewOptions, 20, 30);
        JSplitPane soundingComp = GuiUtils.vsplit((Component)this.soundingView.getContents(), (Component)bottomComp, 0.75);
        soundingComp.setOneTouchExpandable(true);
        JScrollPane sp = new JScrollPane(this.readoutPanel, 20, 30);
        sp.setViewportBorder(BorderFactory.createBevelBorder(1));
        JScrollPane left = specificWidget != null ? GuiUtils.centerBottom(sp, specificWidget) : sp;
        JScrollPane leftSP = new JScrollPane(left, 20, 30);
        leftSP.setPreferredSize(new Dimension(250, 100));
        this.viewTabs = new JTabbedPane();
        this.viewTabs.add("Sounding Chart", soundingComp);
        this.viewTabs.add("Hodograph", this.hodoView.getComponent());
        JScrollPane tableSP = new JScrollPane(this.soundingTable, 20, 30);
        tableSP.setViewportBorder(BorderFactory.createBevelBorder(1));
        this.showUVCbx = GuiUtils.makeCheckbox("Show U and V", this, "showUAndVWinds");
        this.showUVCbx.setEnabled(this.haveWinds);
        JPanel tableComp = GuiUtils.topCenter(GuiUtils.right(this.showUVCbx), tableSP);
        this.viewTabs.add("Table", tableComp);
        GuiUtils.handleHeavyWeightComponentsInTabs(this.viewTabs);
        this.viewTabs.setSelectedIndex(0);
        this.viewTabs.setEnabledAt(this.viewTabs.indexOfTab("Hodograph"), this.haveWinds);
        JSplitPane spl = GuiUtils.hsplit((Component)leftSP, (Component)this.viewTabs, 0.4);
        spl.setOneTouchExpandable(true);
        JPanel contents = GuiUtils.topCenter(this.headerLabel, spl);
        return contents;
    }

    Component getSpecificWidget() throws VisADException, RemoteException {
        return null;
    }

    protected String getSpatialLociLabel() {
        return "Spatial Loci";
    }

    protected final LatLonPoint getLocation() {
        return this.location;
    }

    final void setLocation(LatLonPoint loc) throws VisADException, RemoteException {
        this.location = loc;
        double lat = loc.getLatitude().getValue();
        this.aeroDisplay.setBarbOrientation(lat >= 0.0 ? 0 : 1);
    }

    protected void updateHeaderLabel() {
        if (this.location != null) {
            double lat = this.location.getLatitude().getValue();
            double lon = this.location.getLongitude().getValue();
            this.headerLabel.setText(" Lat: " + this.getDisplayConventions().format(lat) + "  Lon: " + this.getDisplayConventions().format(lon));
        } else {
            this.headerLabel.setText("       ");
        }
    }

    final LatLonPoint latLon(RealTuple xy) throws VisADException, RemoteException {
        EarthLocationTuple elt;
        LatLonPoint latLon = null;
        Real[] reals = xy.getRealComponents();
        if (this.getControlContext() != null && (elt = (EarthLocationTuple)this.boxToEarth(new double[]{reals[0].getValue(), reals[1].getValue(), xy.getDimension() == 3 ? reals[0].getValue() : 1.0})) != null) {
            latLon = elt.getLatLonPoint();
        }
        return latLon;
    }

    final RealTuple xY(LatLonPoint latLon) throws VisADException, RemoteException {
        RealTuple xy = null;
        if (this.getControlContext() != null) {
            RealTuple xyz = this.earthToBoxTuple(new EarthLocationTuple(latLon.getLatitude(), latLon.getLongitude(), new Real(RealType.Altitude, 0.0)));
            xy = new RealTuple(RealTupleType.SpatialCartesian2DTuple, new Real[]{(Real)xyz.getComponent(0), (Real)xyz.getComponent(1)}, null);
        }
        return xy;
    }

    @Override
    protected void getEditMenuItems(List items, boolean forMenuBar) {
        JMenuItem mi = new JMenuItem("Reset sounding");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AerologicalSoundingControl.this.resetProfile(AerologicalSoundingControl.this.currIndex);
            }
        });
        items.add(mi);
        super.getEditMenuItems(items, forMenuBar);
    }

    @Override
    protected void getViewMenuItems(List menus, boolean forMenuBar) {
        super.getViewMenuItems(menus, forMenuBar);
        if (forMenuBar) {
            JMenu svMenu = this.soundingView.makeViewMenu();
            svMenu.setText("Sounding Chart");
            menus.add(svMenu);
            JMenu hvMenu = this.hodoView.makeViewMenu();
            hvMenu.setText("Hodograph");
            menus.add(hvMenu);
        }
    }

    private JRadioButtonMenuItem makeDisplayTypeMenu(String type) {
        JRadioButtonMenuItem rmi = new JRadioButtonMenuItem(AerologicalSoundingControl.getTypeLabel(type), this.isDisplayType(type));
        rmi.setActionCommand(type);
        rmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButtonMenuItem myRmi = (JRadioButtonMenuItem)e.getSource();
                AerologicalSoundingControl.this.setDisplayType(myRmi.getActionCommand());
                AerologicalSoundingControl.this.setDisplayName(myRmi.getText());
                AerologicalSoundingControl.this.updateLegendAndList();
            }
        });
        return rmi;
    }

    public boolean isDisplayType(String type) {
        return this.getDisplayType().equals(type);
    }

    private void resetProfile(int index) {
        try {
            this.aeroDisplay.setOriginalProfiles(index);
            if (this.haveWinds) {
                this.hodoDisplay.setOriginalProfile(index);
            }
            this.setSounding(index);
        }
        catch (Exception excp) {
            AerologicalSoundingControl.logException("Unable to reset sounding", excp);
        }
    }

    public void setDisplayType(String type) {
        try {
            if (this.getHaveInitialized()) {
                this.aeroDisplay.setCoordinateSystem(type);
            }
            this.displayType = type;
        }
        catch (Exception e) {
            LogUtil.printMessage("setDisplayType got " + e.toString());
        }
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getWindBarbSpacing() {
        return this.windBarbSpacing;
    }

    public void setWindBarbSpacing(String newSpacing) {
        try {
            if (this.getHaveInitialized()) {
                this.setWindLevels(newSpacing);
            }
            this.windBarbSpacing = newSpacing;
        }
        catch (Exception e) {
            LogUtil.printMessage("setWindBarbSpacing got " + e.toString());
        }
    }

    private void setWindLevels(String windInterval) {
        AerologicalCoordinateSystem acs = this.aeroDisplay.getCoordinateSystem();
        Real minP = acs.getMinimumPressure();
        Real maxP = acs.getMaximumPressure();
        RealType pRT = (RealType)minP.getType();
        Unit pUnit = minP.getUnit();
        Gridded1DSet spacingSet = null;
        float[] vals = null;
        if (windInterval == MANDATORY_LEVELS) {
            vals = MANDATORY_LEVEL_VALUES;
        } else if (windInterval != ALL_LEVELS) {
            try {
                float spacing = Misc.parseFloat(windInterval);
                if (!Float.isNaN(spacing)) {
                    float maxPVal = (float)maxP.getValue();
                    float minPVal = (float)minP.getValue();
                    vals = Misc.computeTicks(maxPVal, minPVal, minPVal, spacing);
                }
            }
            catch (Exception spacing) {
                // empty catch block
            }
        }
        if (vals != null) {
            try {
                spacingSet = new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{vals}, vals.length, (CoordinateSystem)null, new Unit[]{pUnit}, (ErrorEstimate[])null);
            }
            catch (VisADException spacing) {
                // empty catch block
            }
        }
        try {
            this.aeroDisplay.setWindLevels(spacingSet);
        }
        catch (Exception e) {
            LogUtil.printMessage("AerologicalDisplay.setWindLevels got " + e.toString());
            e.printStackTrace();
        }
    }

    public static String getTypeLabel(String displayType) {
        return SoundingViewManager.getTypeLabel(displayType);
    }

    public void setSoundingView(SoundingViewManager value) {
        this.soundingView = value;
    }

    public SoundingViewManager getSoundingView() {
        return this.soundingView;
    }

    public void setHodographView(HodographViewManager value) {
        this.hodoView = value;
    }

    public HodographViewManager getHodographView() {
        return this.hodoView;
    }

    public boolean getShowUAndVWinds() {
        return this.showUAndVWinds;
    }

    public void setShowUAndVWinds(boolean show) {
        this.showUAndVWinds = show;
        if (this.soundingTable != null) {
            this.soundingTable.setShowUVComps(show);
        }
    }

    @Override
    public ViewManager getViewManagerForCapture(String what) throws Exception {
        this.setMainPanelDimensions();
        if (what != null && what.toLowerCase().contains("hodo")) {
            if (!this.getIdv().getArgsManager().getIsOffScreen()) {
                GuiUtils.showComponentInTabs(this.hodoView.getComponent());
            }
            return this.getHodographView();
        }
        if (!this.getIdv().getArgsManager().getIsOffScreen()) {
            GuiUtils.showComponentInTabs(this.getMainPanel());
        }
        return this.getSoundingView();
    }

    private static abstract class MyActionImpl
    extends ActionImpl {
        public DataReference reference;
        public AerologicalReadoutTable readoutTable;

        public MyActionImpl(String name, AerologicalReadoutTable readoutTable, DataReference ref) throws ReferenceException, RemoteException, VisADException {
            super(name);
            this.reference = ref;
            this.readoutTable = readoutTable;
            this.addReference(ref);
        }

        protected DataReference getDataReference() {
            return this.reference;
        }

        protected Real getReal() throws VisADException, RemoteException {
            return (Real)this.reference.getData();
        }

        protected void doRemove() {
            try {
                this.removeReference(this.reference);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ParcelModeInfo {
        private final String label;
        private final ParcelMode mode;

        private ParcelModeInfo(String label, ParcelMode mode) {
            this.label = label;
            this.mode = mode;
        }

        public String toString() {
            return this.label;
        }
    }
}

