/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.collab;

import java.io.IOException;
import java.net.Socket;
import ucar.unidata.collab.Client;
import ucar.unidata.collab.Server;
import ucar.unidata.idv.collab.CollabClient;
import ucar.unidata.idv.collab.CollabManager;

public class CollabServer
extends Server {
    private CollabManager collabManager;

    public CollabServer(CollabManager collabManager, int port) {
        super(port);
        this.collabManager = collabManager;
    }

    @Override
    protected Client createClient(Socket clientSocket) throws IOException {
        return new CollabClient(this.collabManager, clientSocket){

            @Override
            public void handleServerMessage(String msg) {
                CollabServer.this.collabManager.handleMessage(this, msg);
            }
        };
    }

    @Override
    public void handleIncomingMessage(Client client, String message) {
        this.collabManager.handleMessage((CollabClient)client, message);
    }

    @Override
    protected void notifyServerStop() {
        super.notifyServerStop();
        this.collabManager.serverStopped();
    }

    @Override
    protected void notifyServerStart() {
        super.notifyServerStart();
        this.collabManager.serverStarted();
    }

    @Override
    protected void notifyClientAdd(Client client) {
        super.notifyClientAdd(client);
        this.collabManager.clientAdded((CollabClient)client);
    }

    @Override
    protected void notifyClientRemove(Client client) {
        super.notifyClientRemove(client);
        this.collabManager.clientRemoved((CollabClient)client);
    }
}

