/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.collab;

import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.Misc;

public class CollabMsgType {
    boolean blocked = false;
    String id;
    String description;
    private boolean shouldRelay;
    private static List messageTypes = new ArrayList();

    public static CollabMsgType createRelay(String id, String desc) {
        return CollabMsgType.create(id, desc, true);
    }

    public static CollabMsgType createNoRelay(String id, String desc) {
        return CollabMsgType.create(id, desc, false);
    }

    private static CollabMsgType create(String id, String desc, boolean shouldRelay) {
        CollabMsgType type = new CollabMsgType(id, desc, shouldRelay);
        messageTypes.add(type);
        return type;
    }

    private CollabMsgType(String id, String desc, boolean shouldRelay) {
        this.id = id;
        this.description = desc;
        this.shouldRelay = shouldRelay;
    }

    public static CollabMsgType find(String typeId) {
        for (int i = 0; i < messageTypes.size(); ++i) {
            CollabMsgType msgType = (CollabMsgType)messageTypes.get(i);
            if (!msgType.idEquals(typeId)) continue;
            return msgType;
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other instanceof CollabMsgType) {
            return Misc.equals(this.id, ((CollabMsgType)other).id);
        }
        return false;
    }

    public boolean idEquals(String otherId) {
        return Misc.equals(this.id, otherId);
    }

    public String toString() {
        return this.id;
    }

    public void setBlocked(boolean value) {
        this.blocked = value;
    }

    public boolean getBlocked() {
        return this.blocked;
    }

    public void setShouldRelay(boolean value) {
        this.shouldRelay = value;
    }

    public boolean getShouldRelay() {
        return this.shouldRelay;
    }
}

