/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.collab;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ucar.unidata.collab.Client;
import ucar.unidata.collab.Server;
import ucar.unidata.collab.Sharable;
import ucar.unidata.collab.SharableListener;
import ucar.unidata.collab.SharableManager;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.IdvManager;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.ViewManager;
import ucar.unidata.idv.collab.CaptureEvent;
import ucar.unidata.idv.collab.CaptureManager;
import ucar.unidata.idv.collab.CollabClient;
import ucar.unidata.idv.collab.CollabMsgType;
import ucar.unidata.idv.collab.CollabServer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectListener;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.AnimationWidget;

public class CollabManager
extends IdvManager
implements SharableListener {
    private String collabUniqueId;
    private int uniqueCnt = 0;
    private CaptureManager captureManager;
    public static String PREF_HOSTNAME = "collab.prop.hostname";
    public static String PREF_PORT = "collab.prop.port";
    public static String PREF_ACCEPTALL = "collab.prop.acceptall";
    public static final String MSG_DELIMITER = ":";
    public static final CollabMsgType MSG_NEWUSER = CollabMsgType.createNoRelay("collab.newuser", "Announce a new user");
    public static final CollabMsgType MSG_ACKNEWUSER = CollabMsgType.createNoRelay("collab.acknewuser", "Acknowledge a new user");
    public static final CollabMsgType MSG_CLOSE = CollabMsgType.createNoRelay("collab.close", "Close this connection");
    public static final CollabMsgType MSG_BUNDLE = CollabMsgType.createNoRelay("collab.bundle", "Load application state");
    public static final CollabMsgType MSG_DATASOURCE = CollabMsgType.createRelay("collab.datasource", "Load a data source");
    public static final CollabMsgType MSG_DISPLAY = CollabMsgType.createRelay("collab.display", "Create a display");
    public static final CollabMsgType MSG_MESSAGE = CollabMsgType.createRelay("collab.message", "Chat text");
    public static final CollabMsgType MSG_STATE = CollabMsgType.createRelay("collab.state", "Change the state of an object");
    public static final CollabMsgType MSG_NEWWINDOW = CollabMsgType.createRelay("collab.newwindow", "Create a new window");
    public static final CollabMsgType MSG_REMOVEDATASOURCE = CollabMsgType.createRelay("collab.remove.datasource", "Remove a data source");
    public static final CollabMsgType MSG_REMOVEDISPLAYCONTROL = CollabMsgType.createRelay("collab.remove.displaycontrol", "Remove a display control");
    public static final CollabMsgType MSG_ACTION = CollabMsgType.createRelay("collab.action", "Do an action");
    private Object MUTEX = new Object();
    private JTextArea chatTextArea;
    private boolean haveShowChatOnce = false;
    private boolean chatTabIsRed = false;
    private Color chatTabColor;
    private int logMsgCnt = 0;
    private JTextArea logTextArea = new JTextArea(10, 30);
    private JTabbedPane tabbedPane;
    int connectPaneIdx = 0;
    int clientsPaneIdx = 0;
    int chatPaneIdx = 0;
    int logPaneIdx = 0;
    private static final String LBL_STARTSERVER = "Start server";
    private static final String LBL_STOPSERVER = "Stop server";
    private static final String LBL_SERVERISRUNNING = "Server status: Server is listening for connections";
    private static final String LBL_SERVERISSTOPPED = "Server status: Server is not listening for connections";
    private JButton stopStartBtn = new JButton("Start server");
    private JTextField hostnameFld = new JTextField(20);
    private JTextField portFld;
    private JLabel serverStatusLbl = new JLabel("Server status: Server is not listening for connections");
    private JPanel clientsPanel;
    private JCheckBox okToSendCbx = new JCheckBox("Ok to send changes", true);
    private JCheckBox okToRcvCbx = new JCheckBox("Ok to receive changes", true);
    private JCheckBox acceptAllCbx = new JCheckBox("Accept new connections without asking");
    private JCheckBox okToRelayCbx = new JCheckBox("Ok to relay changes", true);
    private CollabServer server;
    private String hostname;
    private Hashtable seenMessageIds = new Hashtable();
    private int seenMessagesCnt = 0;
    private int port = Server.DEFAULT_PORT;
    private boolean receivingCollabMessage = false;

    public CollabManager(IntegratedDataViewer idv) {
        super(idv);
        boolean doServer = this.getArgsManager().getDoCollabServer();
        this.hostname = this.getArgsManager().getCollabHostName();
        this.port = this.getArgsManager().getCollabPort();
        this.collabUniqueId = Misc.getUniqueId();
        this.captureManager = new CaptureManager(idv, this);
        if (Misc.equals(this.hostname, "?")) {
            this.hostname = GuiUtils.getInput(null, "Hostname to connect to: ", "");
        }
        this.server = new CollabServer(this, this.port);
        if (this.hostname != null && !this.connectTo(this.hostname)) {
            if (doServer) {
                LogUtil.userMessage("The connection to: " + this.hostname + " failed. Listening for connections.");
            } else {
                boolean serverOk = GuiUtils.showYesNoDialog(null, "The connect to: " + this.hostname + " failed. Do you want to listen for connections?", "Connection Failed");
                if (serverOk) {
                    doServer = true;
                }
            }
        }
        if (doServer || this.hostname != null && !this.server.hasClients()) {
            this.startServer();
        }
        SharableManager.addSharableListener(this);
    }

    public void connect() {
        String collabHostName = GuiUtils.getInput(null, "Hostname to connect to: ", this.hostname != null ? this.hostname : "");
        if (collabHostName != null) {
            this.hostname = collabHostName.trim();
            this.hostnameFld.setText(this.hostname);
            this.connectTo(collabHostName);
        }
    }

    protected void writeState(CollabClient client) {
        try {
            client.write(this.makeMsg(MSG_BUNDLE, this.getPersistenceManager().getBundleXml(false)));
        }
        catch (Exception exc) {
            CollabManager.logException("Writing initial state.", exc);
        }
    }

    private int getPort() {
        if (this.portFld != null) {
            String s = this.portFld.getText().trim();
            try {
                this.port = new Integer(s);
            }
            catch (NumberFormatException nfe) {
                LogUtil.userMessage("Invalid format:" + s);
            }
        }
        return this.port;
    }

    protected boolean connectTo(String collabHostName) {
        try {
            CollabClient tmpClient = new CollabClient(this, collabHostName, this.getPort());
            tmpClient.setIsLocal(true);
            if (tmpClient.isConnectionOk()) {
                tmpClient.setValid(true);
                tmpClient.write(this.makeMsg(MSG_NEWUSER, ""));
                this.server.addClient(tmpClient);
                return true;
            }
        }
        catch (Exception exc) {
            CollabManager.logException("Creating client", exc);
        }
        return false;
    }

    @Override
    public void checkShareData(Sharable from, Object dataId, Object[] data) {
        if (!this.isEnabled() || from == null || this.receivingCollabMessage) {
            return;
        }
        XmlEncoder encoder = this.getIdv().getEncoderForWrite();
        this.populateEncoderWithDataSources(encoder);
        String contents = from.getUniqueId() + MSG_DELIMITER + dataId + MSG_DELIMITER + encoder.toXml(data);
        this.write(MSG_STATE, contents);
    }

    public boolean getOkToRelay() {
        return this.getOkToReceive() && this.okToRelayCbx.isSelected();
    }

    private boolean getOkToSend() {
        return this.okToSendCbx.isSelected();
    }

    private boolean getOkToReceive() {
        return this.okToRcvCbx.isSelected();
    }

    protected boolean isEnabled() {
        return this.captureManager.doingCapture() || this.haveClients();
    }

    protected boolean haveClients() {
        return this.server != null && this.server.hasClients();
    }

    public void showConnect() {
        this.showWindow();
        this.tabbedPane.setSelectedIndex(this.connectPaneIdx);
    }

    public void showClients() {
        this.showWindow();
        this.tabbedPane.setSelectedIndex(this.clientsPaneIdx);
    }

    public void showChat() {
        this.showWindow();
        this.tabbedPane.setSelectedIndex(this.chatPaneIdx);
    }

    public void showLog() {
        this.showWindow();
        this.tabbedPane.setSelectedIndex(this.logPaneIdx);
    }

    public void showCapture() {
        this.captureManager.showCaptureWindow();
    }

    public void runCaptureFile(String filename) {
        this.captureManager.runCaptureFile(filename);
    }

    public void disconnectAll() {
        List clients = this.server.getClients();
        for (int i = 0; i < clients.size(); ++i) {
            this.disconnect((CollabClient)clients.get(i));
        }
    }

    private void disconnect(CollabClient client) {
        try {
            client.write(this.makeMsg(MSG_CLOSE, ""));
            client.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillClientPanel() {
        if (this.clientsPanel == null) {
            this.clientsPanel = new JPanel();
            this.clientsPanel.setLayout(new BorderLayout());
            this.clientsPanel.setPreferredSize(new Dimension(100, 100));
        } else {
            this.clientsPanel.removeAll();
        }
        List clients = this.server.getClients();
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        for (int i = 0; i < clients.size(); ++i) {
            CollabClient client = (CollabClient)clients.get(i);
            JButton disconnectBtn = new JButton("Disconnect");
            disconnectBtn.addActionListener(new ObjectListener(client){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CollabManager.this.disconnect((CollabClient)this.theObject);
                }
            });
            comps.add(disconnectBtn);
            JCheckBox okToSendCbx = new JCheckBox("Ok to send", client.getOkToSend());
            okToSendCbx.addActionListener(new ObjectListener(client){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Client theClient;
                    theClient.setOkToSend(!(theClient = (Client)this.theObject).getOkToSend());
                }
            });
            comps.add(okToSendCbx);
            JCheckBox okToReceiveCbx = new JCheckBox("Ok to receive", client.getOkToReceive());
            okToReceiveCbx.addActionListener(new ObjectListener(client){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Client theClient;
                    theClient.setOkToReceive(!(theClient = (Client)this.theObject).getOkToReceive());
                }
            });
            comps.add(okToReceiveCbx);
            comps.add(new JLabel("   " + client.getName() + " on:" + client));
        }
        JPanel inner = clients.size() == 0 ? GuiUtils.top(new JLabel("No clients")) : GuiUtils.doLayout(comps, 4, GuiUtils.WT_NNNY, GuiUtils.WT_N);
        JScrollPane sp = new JScrollPane(GuiUtils.top(inner), 20, 30);
        this.clientsPanel.add("North", new JLabel("Clients"));
        this.clientsPanel.add("Center", sp);
        this.clientsPanel.validate();
        this.clientsPanel.repaint();
    }

    protected void clientAdded(CollabClient client) {
        this.writeLog("New client:" + client);
        if (!client.getIsLocal() && client.getValid()) {
            this.writeState(client);
        }
    }

    protected void clientRemoved(CollabClient client) {
        this.writeLog("Client gone:" + client);
        this.fillClientPanel();
    }

    protected void serverStopped() {
        this.writeLog("Server stopped");
        this.setServerStateLabels();
    }

    protected void serverStarted() {
        this.writeLog("Server started");
        this.setServerStateLabels();
    }

    private void setServerStateLabels() {
        if (this.server.getIsRunning()) {
            this.stopStartBtn.setText(LBL_STOPSERVER);
            this.serverStatusLbl.setText(LBL_SERVERISRUNNING);
        } else {
            this.stopStartBtn.setText(LBL_STARTSERVER);
            this.serverStatusLbl.setText(LBL_SERVERISSTOPPED);
        }
    }

    public void showWindow() {
        super.show();
    }

    private void startServer() {
        try {
            this.server.startServer(this.getPort());
        }
        catch (IOException ioe) {
            CollabManager.logException("Starting the collaboration server", ioe);
        }
    }

    @Override
    protected JComponent doMakeContents() {
        this.chatTextArea = new JTextArea(10, 30){

            @Override
            public void paint(Graphics g) {
                if (CollabManager.this.chatTabIsRed) {
                    CollabManager.this.chatTabIsRed = false;
                    CollabManager.this.tabbedPane.setBackgroundAt(CollabManager.this.chatPaneIdx, CollabManager.this.chatTabColor);
                }
                super.paint(g);
            }
        };
        this.chatTextArea.setEditable(false);
        final JTextField inputFld = new JTextField(30);
        ActionListener sendListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String msg = inputFld.getText();
                CollabManager.this.sendText(msg);
                inputFld.setText("");
                CollabManager.this.writeChatText(CollabManager.this.getUserName(), msg);
                inputFld.requestFocus();
            }
        };
        JButton sendBtn = new JButton("Send");
        sendBtn.addActionListener(sendListener);
        inputFld.addActionListener(sendListener);
        JScrollPane sp = new JScrollPane(this.chatTextArea, 20, 30);
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CollabManager.this.chatTextArea.setEditable(true);
                CollabManager.this.chatTextArea.setText("");
                CollabManager.this.chatTextArea.setEditable(false);
            }
        });
        JPanel bottom = GuiUtils.inset((Component)GuiUtils.leftCenterRight(GuiUtils.rLabel("Input:  "), inputFld, sendBtn), 4);
        JPanel chatContents = GuiUtils.topCenterBottom(GuiUtils.left(clearBtn), sp, bottom);
        this.setServerStateLabels();
        this.portFld = new JTextField("" + this.port, 5);
        this.stopStartBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CollabManager.this.server.getIsRunning()) {
                    CollabManager.this.server.stopServer();
                } else {
                    CollabManager.this.startServer();
                }
                CollabManager.this.setServerStateLabels();
            }
        });
        this.fillClientPanel();
        ActionListener connectListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String hostname = CollabManager.this.hostnameFld.getText().trim();
                if (!CollabManager.this.connectTo(hostname)) {
                    LogUtil.userMessage("The connection to: " + hostname + " failed.");
                }
            }
        };
        if (this.hostname != null) {
            this.hostnameFld.setText(this.hostname);
        }
        JButton connectBtn = new JButton("Connect to:");
        connectBtn.addActionListener(connectListener);
        this.hostnameFld.addActionListener(connectListener);
        JPanel connectPanel = GuiUtils.left(GuiUtils.hflow(Misc.newList(connectBtn, this.hostnameFld, new JLabel(" (Enter hostname)"))));
        JButton writeStateBtn = new JButton("Write current state");
        writeStateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CollabManager.this.writeState();
            }
        });
        JPanel startServerPanel = GuiUtils.left(GuiUtils.hflow(Misc.newList(GuiUtils.rLabel("Port: "), this.portFld, this.stopStartBtn, this.acceptAllCbx)));
        JPanel serverPanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{startServerPanel, this.serverStatusLbl}, 1, GuiUtils.WT_N, GuiUtils.WT_N));
        serverPanel = GuiUtils.topCenter(new JLabel("Or you can start your own server so others can connect to your IDV: "), serverPanel);
        JPanel connectContents = GuiUtils.top(GuiUtils.vbox(new JLabel("You can either connect to another IDV server: "), connectPanel, GuiUtils.vbox(new JLabel(" "), new JLabel(" ")), serverPanel));
        JPanel clientsWidgets = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.okToSendCbx, this.okToRcvCbx, this.okToRelayCbx, writeStateBtn}, 1, GuiUtils.WT_N, GuiUtils.WT_N));
        JPanel clientsContents = GuiUtils.topCenter(clientsWidgets, this.clientsPanel);
        this.logTextArea.setEditable(false);
        JScrollPane logSp = new JScrollPane(this.logTextArea, 20, 30);
        JButton clearLogBtn = new JButton("Clear");
        clearLogBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CollabManager.this.clearLog();
            }
        });
        JPanel logContents = GuiUtils.topCenterBottom(GuiUtils.cLabel("Collaboration log"), logSp, GuiUtils.wrap(clearLogBtn));
        this.tabbedPane = new JTabbedPane();
        int panePaneIdx = 0;
        this.tabbedPane.add("Connect", GuiUtils.inset((Component)connectContents, 4));
        this.connectPaneIdx = panePaneIdx++;
        this.tabbedPane.add("Clients", GuiUtils.inset((Component)clientsContents, 4));
        this.clientsPaneIdx = panePaneIdx++;
        this.tabbedPane.add("Chat", GuiUtils.inset((Component)chatContents, 4));
        this.chatPaneIdx = panePaneIdx++;
        this.tabbedPane.add("Log", GuiUtils.inset((Component)logContents, 4));
        this.logPaneIdx = panePaneIdx++;
        this.chatTabColor = this.tabbedPane.getBackgroundAt(this.chatPaneIdx);
        JButton helpBtn = new JButton("Help");
        helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CollabManager.this.showHelp();
            }
        });
        JPanel buttons = GuiUtils.center(GuiUtils.wrap(helpBtn));
        this.contents = GuiUtils.centerBottom(this.tabbedPane, buttons);
        return this.contents;
    }

    @Override
    public String getWindowTitle() {
        return "Collaboration Window";
    }

    private void showHelp() {
        this.getIdvUIManager().showHelp("idv.collab");
    }

    private void clearLog() {
        this.logTextArea.setEditable(true);
        this.logTextArea.setText("");
        this.logTextArea.setEditable(false);
        this.logMsgCnt = 0;
    }

    public void sendText(String msg) {
        this.write(MSG_MESSAGE, msg);
    }

    public void writeRemoveDataSource(DataSource dataSource) {
        try {
            this.write(MSG_REMOVEDATASOURCE, dataSource.getUniqueId());
        }
        catch (Exception exc) {
            CollabManager.logException("Sending state", exc);
        }
    }

    public void writeRemoveDisplayControl(DisplayControl display) {
        try {
            this.write(MSG_REMOVEDISPLAYCONTROL, display.getUniqueId());
        }
        catch (Exception exc) {
            CollabManager.logException("Sending state", exc);
        }
    }

    public void writeState() {
        try {
            this.write(MSG_BUNDLE, this.getPersistenceManager().getBundleXml(false));
        }
        catch (Exception exc) {
            CollabManager.logException("Sending state", exc);
        }
    }

    public void newWindow(ViewManager vm) {
        String vmXml = this.getIdv().encodeObject(vm, true);
        this.write(MSG_NEWWINDOW, vmXml);
    }

    public void write(CollabMsgType type, String message) {
        if (type.getBlocked()) {
            return;
        }
        if (!this.getOkToSend()) {
            return;
        }
        if (!this.isEnabled() || this.receivingCollabMessage) {
            return;
        }
        String msg = this.makeMsg(type, message);
        if (this.captureManager.doingCapture()) {
            this.captureManager.addEvent(new CaptureEvent(msg));
        }
        if (this.haveClients()) {
            this.server.write(msg);
        }
    }

    protected String getUserName() {
        return this.getStateManager().getUserName();
    }

    protected String makeMsg(CollabMsgType type, String body1) {
        String msgId = this.collabUniqueId + "_" + this.uniqueCnt++;
        this.haveISeenThisMessage(msgId);
        return msgId + MSG_DELIMITER + type + MSG_DELIMITER + this.getUserName() + MSG_DELIMITER + body1;
    }

    protected void handleMessage(CollabClient from, String msg) {
        this.handleMessage(from, msg, true);
    }

    private boolean haveISeenThisMessage(String id) {
        if (this.seenMessageIds.get(id) != null) {
            return true;
        }
        if (this.seenMessagesCnt > 1000) {
            this.seenMessageIds = new Hashtable();
        }
        ++this.seenMessagesCnt;
        this.seenMessageIds.put(id, id);
        return false;
    }

    protected void handleMessage(CollabClient from, String msg, boolean checkIfMessageHasBeenSeen) {
        this.receivingCollabMessage = true;
        try {
            this.handleMessageInner(from, msg, checkIfMessageHasBeenSeen);
        }
        catch (Exception exc) {
            CollabManager.logException("Handling collab message", exc);
        }
        this.receivingCollabMessage = false;
    }

    protected void handleMessageInner(CollabClient fromClient, String msg, boolean checkIfMessageHasBeenSeen) throws Exception {
        int idx = msg.indexOf(MSG_DELIMITER);
        if (idx < 0) {
            return;
        }
        String[] msgArray = StringUtil.split(msg, MSG_DELIMITER, 4);
        if (msgArray == null) {
            return;
        }
        String fromUniqueId = msgArray[0];
        if (checkIfMessageHasBeenSeen && this.haveISeenThisMessage(fromUniqueId)) {
            return;
        }
        CollabMsgType msgType = CollabMsgType.find(msgArray[1]);
        if (msgType == null) {
            this.writeLog("Unknown message type:" + msgArray[1]);
            return;
        }
        if (msgType.getBlocked()) {
            return;
        }
        if (!this.getOkToReceive() && !msgType.equals(MSG_MESSAGE)) {
            return;
        }
        String from = msgArray[2];
        String contents = msgArray[3];
        try {
            this.handleMessageInnerInner(fromClient, msgType, from, contents);
        }
        catch (Exception exc) {
            CollabManager.logException("Handling collab message: " + msgType, exc);
            return;
        }
        if (msgType.getShouldRelay() && this.getOkToRelay()) {
            this.server.write(msg, fromClient);
        }
    }

    protected void handleMessageInnerInner(CollabClient fromClient, CollabMsgType msgType, String from, String contents) throws Exception {
        String logMsg = null;
        if (msgType.equals(MSG_CLOSE)) {
            fromClient.close();
            return;
        }
        if (msgType.equals(MSG_NEWUSER)) {
            if (!this.acceptAllCbx.isSelected()) {
                JLabel label1 = new JLabel("User: " + from + " on machine: " + fromClient.toString() + " is requesting a connection.");
                JLabel label2 = new JLabel("Do you want to connect?");
                JPanel dialogContents = GuiUtils.inset((Component)GuiUtils.vbox((Component)GuiUtils.left(label1), GuiUtils.left(label2)), 4);
                boolean ok = GuiUtils.showYesNoDialog(null, "Connection Request", dialogContents, null);
                if (!ok) {
                    fromClient.write(this.makeMsg(MSG_ACKNEWUSER, "no"));
                    fromClient.close();
                    return;
                }
            }
            fromClient.setValid(true);
            fromClient.setName(from);
            fromClient.write(this.makeMsg(MSG_ACKNEWUSER, "ok"));
            this.writeState(fromClient);
            this.fillClientPanel();
            return;
        }
        if (!fromClient.getValid()) {
            return;
        }
        if (msgType.equals(MSG_ACKNEWUSER)) {
            if (!contents.equals("ok")) {
                LogUtil.userMessage("The connection was rejected");
                fromClient.close();
                return;
            }
            fromClient.setName(from);
            this.fillClientPanel();
        } else if (msgType.equals(MSG_DATASOURCE) || msgType.equals(MSG_DISPLAY)) {
            XmlEncoder encoder = this.getIdv().getEncoderForRead();
            this.populateEncoderWithDataSources(encoder);
            Object object = encoder.toObject(contents);
            if (object == null) {
                return;
            }
            if (object instanceof DataSource) {
                this.getDataManager().addDataSource((DataSource)object);
                logMsg = "Received new data source  from " + from;
            } else if (object instanceof DisplayControl) {
                DisplayControl displayControl = (DisplayControl)object;
                if (!this.haveDisplayControl(displayControl)) {
                    displayControl.initAfterUnPersistence(this.getIdv(), new Hashtable());
                    logMsg = "Received new display  from " + from;
                }
            } else {
                System.err.println("Unknown object:" + object.getClass().getName());
            }
        } else if (msgType.equals(MSG_NEWWINDOW)) {
            ViewManager newViewManager = (ViewManager)this.getIdv().decodeObject(contents);
            try {
                newViewManager.initAfterUnPersistence(this.getIdv());
            }
            catch (Exception exc) {
                CollabManager.logException("Unpersisting VM", exc);
            }
            this.getIdvUIManager().createNewWindow(Misc.newList(newViewManager), false);
        } else if (msgType.equals(MSG_STATE)) {
            String[] stateArray = StringUtil.split(contents, MSG_DELIMITER, 3);
            if (stateArray == null) {
                return;
            }
            String sharableId = stateArray[0];
            String dataId = stateArray[1];
            String xml = stateArray[2];
            XmlEncoder encoder = this.getIdv().getEncoderForRead();
            this.populateEncoderWithDataSources(encoder);
            Object[] data = (Object[])encoder.toObject(xml);
            if (data == null) {
                return;
            }
            Sharable sharable = this.findSharable(sharableId);
            if (sharable != null) {
                logMsg = "Received state change from " + from + " for " + sharable.getClass().getName();
                sharable.receiveShareData(null, dataId, data);
            } else {
                logMsg = "Unknown state change recipient: " + stateArray[2];
            }
        } else if (msgType.equals(MSG_REMOVEDATASOURCE)) {
            String sharableId = contents;
            Sharable sharable = this.findSharable(sharableId);
            if (sharable == null) {
                logMsg = "Unknown data source: " + sharableId;
            } else {
                MSG_REMOVEDATASOURCE.setBlocked(true);
                this.getIdv().removeDataSource((DataSource)((Object)sharable));
                MSG_REMOVEDATASOURCE.setBlocked(false);
            }
        } else if (msgType.equals(MSG_REMOVEDISPLAYCONTROL)) {
            String sharableId = contents;
            Sharable sharable = this.findSharable(sharableId);
            if (sharable == null) {
                logMsg = "Unknown display control: " + sharableId;
            } else {
                MSG_REMOVEDISPLAYCONTROL.setBlocked(true);
                ((DisplayControl)sharable).doRemove();
                MSG_REMOVEDISPLAYCONTROL.setBlocked(false);
            }
        } else if (msgType.equals(MSG_BUNDLE)) {
            try {
                this.getPersistenceManager().decodeXml(contents, true, null, false);
                logMsg = "Received bundle from " + from;
            }
            catch (Throwable exc) {
                CollabManager.logException("Unable to evaluate bundle", exc);
            }
        } else if (msgType.equals(MSG_MESSAGE)) {
            if (this.haveShowChatOnce) {
                this.showWindow();
            } else {
                this.showChat();
            }
            this.haveShowChatOnce = true;
            this.writeChatText(from, contents);
            if (this.tabbedPane.getSelectedIndex() != this.chatPaneIdx && !this.chatTabIsRed) {
                this.chatTabIsRed = true;
                this.tabbedPane.setBackgroundAt(this.chatPaneIdx, Color.red);
            }
        } else if (!msgType.equals(MSG_ACTION)) {
            System.err.println("Unknown message type:" + msgType);
        }
        this.writeLog(logMsg);
    }

    protected void writeChatText(String from, String msg) {
        this.chatTextArea.setEditable(true);
        this.chatTextArea.append(from + MSG_DELIMITER + msg + "\n");
        this.chatTextArea.setText(this.chatTextArea.getText());
        this.chatTextArea.setEditable(false);
    }

    public boolean haveDisplayControl(DisplayControl displayControl) {
        String uniqueId = displayControl.getUniqueId();
        List displayControls = this.getIdv().getDisplayControls();
        for (int i = 0; i < displayControls.size(); ++i) {
            if (!Misc.equals(uniqueId, ((DisplayControl)displayControls.get(i)).getUniqueId())) continue;
            return true;
        }
        return false;
    }

    protected Sharable findSharable(String id, List sharables) {
        for (int i = 0; i < sharables.size(); ++i) {
            Sharable sharable = (Sharable)sharables.get(i);
            if (!Misc.equals(sharable.getUniqueId(), id)) continue;
            return sharable;
        }
        return null;
    }

    protected Sharable findSharable(String id) {
        Sharable sharable = this.findSharable(id, this.getIdv().getDisplayControls());
        if (sharable != null) {
            return sharable;
        }
        sharable = this.findSharable(id, this.getIdv().getDataSources());
        if (sharable != null) {
            return sharable;
        }
        List<ViewManager> viewManagers = this.getVMManager().getViewManagers();
        for (int i = 0; i < viewManagers.size(); ++i) {
            ViewManager vm = viewManagers.get(i);
            if (Misc.equals(vm.getUniqueId(), id)) {
                return vm;
            }
            AnimationWidget animationWidget = vm.getAnimationWidget();
            if (animationWidget == null || !Misc.equals(animationWidget.getUniqueId(), id)) continue;
            return animationWidget;
        }
        return null;
    }

    private void writeLog(String logMsg) {
        if (logMsg == null) {
            return;
        }
        if (this.logMsgCnt++ > 100) {
            this.clearLog();
        }
        this.logTextArea.setEditable(true);
        this.logTextArea.append(logMsg + "\n");
        this.logTextArea.setEditable(false);
    }

    public void controlHasBeenInitialized(DisplayControl control) {
        if (control != null && this.isEnabled()) {
            XmlEncoder encoder = this.getIdv().getEncoderForWrite();
            this.populateEncoderWithDataSources(encoder);
            String displayXml = XmlUtil.toString(encoder.toElement(control));
            this.write(MSG_DISPLAY, displayXml);
        }
    }

    private XmlEncoder populateEncoderWithDataSources(XmlEncoder encoder) {
        List currentSources = this.getIdv().getDataSources();
        for (int i = 0; i < currentSources.size(); ++i) {
            DataSource source = (DataSource)currentSources.get(i);
            encoder.defineObjectId(source, source.getUniqueId());
        }
        return encoder;
    }
}

