/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.collab;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import ucar.unidata.idv.IdvConstants;
import ucar.unidata.idv.IntegratedDataViewer;
import ucar.unidata.idv.collab.CaptureEvent;
import ucar.unidata.idv.collab.CollabClient;
import ucar.unidata.idv.collab.CollabManager;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class CaptureManager {
    private IntegratedDataViewer idv;
    private CollabManager collabManager;
    private JFrame captureWindow;
    private Component captureContents;
    private static ImageIcon startIcon;
    private static ImageIcon stopIcon;
    private static ImageIcon rewindIcon;
    private static ImageIcon stepIcon;
    private List captureList = new ArrayList();
    private boolean doingCapture = false;
    private JButton captureBtn = new JButton("Start event capture");
    private JButton writeCaptureBtn;
    private JButton clearCaptureBtn;
    private JLabel captureLabel;
    private JRadioButton oneXBtn;
    private JRadioButton twoXBtn;
    private JRadioButton fiveXBtn;
    private JRadioButton tenXBtn;
    private JCheckBox skipLongDelaysCbx;
    private JCheckBox playForeverCbx;
    private JButton loadCaptureBtn;
    private JButton playReplayBtn;
    private JButton rewindReplayBtn;
    private JButton stepReplayBtn;
    private JLabel replayTimeLabel;
    private JLabel replayEventLabel;
    private boolean playingCapture = false;
    private int currentReplayId = 0;
    private List replayList;
    private int replayIndex = 0;
    private CollabClient replayClient;

    public CaptureManager(IntegratedDataViewer idv, CollabManager collabManager) {
        this.idv = idv;
        this.collabManager = collabManager;
        this.replayClient = new CollabClient();
        this.replayClient.setValid(true);
    }

    protected boolean doingCapture() {
        return this.doingCapture;
    }

    protected void addEvent(CaptureEvent event) {
        this.captureList.add(event);
        this.captureLabel.setText(StringUtil.padRight("Events: " + (this.captureList.size() + 1), 20));
    }

    private void loadCapture() {
        String filename = FileManager.getReadFile(IdvConstants.FILTER_CPT);
        if (filename == null) {
            return;
        }
        this.loadCaptureFile(filename);
    }

    public boolean loadCaptureFile(String filename) {
        List tmpList;
        this.stopCapture();
        this.showCaptureWindow();
        String xml = IOUtil.readContents(filename, this.getClass(), null);
        if (xml == null) {
            LogUtil.userMessage("Could not read the given file: " + filename);
            return false;
        }
        try {
            tmpList = (List)this.idv.decodeObject(xml);
        }
        catch (Exception exc) {
            CollabManager.logException("Failed to create capture list", exc);
            return false;
        }
        this.replayList = tmpList;
        this.replayIndex = 0;
        this.checkReplayButtons();
        return true;
    }

    public void runCaptureFile(String filename) {
        if (!this.loadCaptureFile(filename)) {
            return;
        }
        this.startReplay();
    }

    private void stopReplay() {
        this.playingCapture = false;
        this.checkReplayButtons();
    }

    private void startReplay() {
        ++this.currentReplayId;
        Misc.run(new Runnable(){

            @Override
            public void run() {
                CaptureManager.this.startReplayInner(CaptureManager.this.currentReplayId);
            }
        });
    }

    private int getSpeed() {
        if (this.oneXBtn.isSelected()) {
            return 1;
        }
        if (this.twoXBtn.isSelected()) {
            return 2;
        }
        if (this.fiveXBtn.isSelected()) {
            return 5;
        }
        if (this.tenXBtn.isSelected()) {
            return 10;
        }
        return 1;
    }

    private void startReplayInner(int replayId) {
        if (this.playingCapture) {
            return;
        }
        this.playingCapture = true;
        this.checkReplayButtons();
        long lastTimestamp = 0L;
        this.checkReplayLabel();
        int cnt = 0;
        while (true) {
            if (this.replayIndex < this.replayList.size()) {
                CaptureEvent event = (CaptureEvent)this.replayList.get(this.replayIndex);
                long timestamp = event.getTimestamp();
                if (cnt != 0) {
                    try {
                        long sleep = (timestamp - lastTimestamp) / (long)this.getSpeed();
                        if (this.skipLongDelaysCbx.isSelected() && sleep > 1000L) {
                            sleep = 1000L;
                        }
                        Thread.currentThread();
                        Thread.sleep(sleep);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++cnt;
                if (this.currentReplayId != replayId) {
                    return;
                }
                if (!this.playingCapture) {
                    return;
                }
                if (this.replayIndex >= this.replayList.size()) {
                    return;
                }
                this.checkReplayLabel();
                lastTimestamp = timestamp;
                this.collabManager.handleMessage(this.replayClient, event.getMessage(), false);
                ++this.replayIndex;
                continue;
            }
            if (!this.playForeverCbx.isSelected()) break;
            this.replayIndex = 0;
        }
        this.playingCapture = false;
        this.checkReplayButtons();
    }

    private void stepReplay() {
        if (this.replayList == null || this.replayIndex >= this.replayList.size()) {
            return;
        }
        this.collabManager.handleMessage(this.replayClient, ((CaptureEvent)this.replayList.get(this.replayIndex)).getMessage(), false);
        ++this.replayIndex;
        this.checkReplayButtons();
    }

    private void checkReplayLabel() {
        if (this.replayList == null || this.replayList.size() == 0) {
            this.replayTimeLabel.setText(StringUtil.padRight("", 40));
            this.replayEventLabel.setText(StringUtil.padRight("", 20));
            this.rewindReplayBtn.setEnabled(false);
        } else {
            if (this.replayIndex == 0) {
                this.rewindReplayBtn.setEnabled(false);
            } else {
                this.rewindReplayBtn.setEnabled(true);
            }
            CaptureEvent event1 = (CaptureEvent)this.replayList.get(0);
            CaptureEvent eventn = (CaptureEvent)this.replayList.get(this.replayList.size() - 1);
            String totalTime = this.getTimeString(event1, eventn);
            String timeMsg = this.replayIndex > 0 && this.replayIndex < this.replayList.size() ? this.getTimeString(event1, (CaptureEvent)this.replayList.get(this.replayIndex)) + "/" + totalTime : totalTime;
            this.replayTimeLabel.setText(StringUtil.padRight("Time: " + timeMsg, 40));
            this.replayEventLabel.setText(StringUtil.padLeft("Event: " + this.replayIndex + "/" + this.replayList.size(), 20));
        }
    }

    private String getTimeString(CaptureEvent event1, CaptureEvent event2) {
        double timeDiff = ((double)event2.getTimestamp() - (double)event1.getTimestamp()) / 1000.0;
        int minutes = (int)(timeDiff / 60.0);
        int seconds = (int)(timeDiff % 60.0);
        String timeMsg = minutes == 0 ? seconds + " seconds" : minutes + ":" + (seconds <= 9 ? "0" : "") + seconds;
        return timeMsg;
    }

    private void checkReplayButtons() {
        if (this.doingCapture) {
            this.playReplayBtn.setEnabled(false);
            this.stepReplayBtn.setEnabled(false);
        } else {
            this.captureBtn.setEnabled(!this.playingCapture);
            this.writeCaptureBtn.setEnabled(!this.playingCapture);
            this.clearCaptureBtn.setEnabled(!this.playingCapture);
            this.loadCaptureBtn.setEnabled(!this.playingCapture);
            if (this.playingCapture) {
                this.playReplayBtn.setIcon(stopIcon);
            } else {
                this.playReplayBtn.setIcon(startIcon);
            }
            if (this.replayList == null || this.replayList.size() == 0) {
                this.playReplayBtn.setEnabled(false);
                this.stepReplayBtn.setEnabled(false);
            } else {
                this.playReplayBtn.setEnabled(this.replayIndex < this.replayList.size());
                this.stepReplayBtn.setEnabled(!this.playingCapture && this.replayIndex < this.replayList.size());
            }
        }
        this.checkReplayLabel();
    }

    private void stopCapture() {
        this.doingCapture = false;
        this.captureBtn.setText("Start Capture");
        this.checkReplayButtons();
    }

    private void writeCapture() {
        String filename = FileManager.getWriteFile(IdvConstants.FILTER_CPT, ".cpt");
        if (filename != null) {
            String xml = this.idv.encodeObject(this.captureList, true, true);
            try {
                IOUtil.writeFile(filename, xml);
            }
            catch (Exception exc) {
                CollabManager.logException("Writing file:" + filename, exc);
                return;
            }
        }
    }

    private void clearCapture() {
        this.captureList = new ArrayList();
        this.captureLabel.setText(StringUtil.padRight("Events: 0", 20));
    }

    private void startCapture() {
        this.captureBtn.setText("Stop Capture");
        this.doingCapture = true;
        this.checkReplayButtons();
    }

    private Component doMakeCaptureContents() {
        if (this.captureContents != null) {
            return this.captureContents;
        }
        if (startIcon == null) {
            String imgp = "/auxdata/ui/icons/";
            startIcon = GuiUtils.getImageIcon(imgp + "Play24.gif");
            stopIcon = GuiUtils.getImageIcon(imgp + "Stop24.gif");
            rewindIcon = GuiUtils.getImageIcon(imgp + "Rewind24.gif");
            stepIcon = GuiUtils.getImageIcon(imgp + "StepForward24.gif");
        }
        this.captureBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CaptureManager.this.doingCapture()) {
                    CaptureManager.this.stopCapture();
                } else {
                    CaptureManager.this.startCapture();
                }
            }
        });
        this.loadCaptureBtn = new JButton("Load Captured Events");
        this.loadCaptureBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaptureManager.this.loadCapture();
            }
        });
        this.captureLabel = new JLabel(StringUtil.padRight("Events: 0", 20));
        this.writeCaptureBtn = new JButton("Write Captured Events");
        this.writeCaptureBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaptureManager.this.writeCapture();
            }
        });
        this.clearCaptureBtn = new JButton("Clear Captured Events");
        this.clearCaptureBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaptureManager.this.clearCapture();
            }
        });
        JPanel capturePanel = GuiUtils.vbox((Component)GuiUtils.left(GuiUtils.hflow(Misc.newList(this.captureBtn, this.writeCaptureBtn, this.clearCaptureBtn), 4, 4)), GuiUtils.left(this.captureLabel));
        capturePanel.setBorder(new TitledBorder(new EtchedBorder(1), "Capture"));
        this.skipLongDelaysCbx = new JCheckBox("Skip long delays");
        ButtonGroup speedGroup = new ButtonGroup();
        this.oneXBtn = new JRadioButton("1X", true);
        speedGroup.add(this.oneXBtn);
        this.twoXBtn = new JRadioButton("2X");
        speedGroup.add(this.twoXBtn);
        this.fiveXBtn = new JRadioButton("5X");
        speedGroup.add(this.fiveXBtn);
        this.tenXBtn = new JRadioButton("10X");
        speedGroup.add(this.tenXBtn);
        JPanel speedPanel = GuiUtils.left(GuiUtils.hflow(Misc.newList(new JLabel("Speed:"), this.oneXBtn, this.twoXBtn, this.fiveXBtn, this.tenXBtn)));
        this.replayTimeLabel = new JLabel("                ");
        this.replayEventLabel = new JLabel("                ");
        this.playReplayBtn = GuiUtils.getImageButton(startIcon);
        this.playReplayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CaptureManager.this.playingCapture) {
                    CaptureManager.this.stopReplay();
                } else {
                    CaptureManager.this.startReplay();
                }
            }
        });
        this.rewindReplayBtn = GuiUtils.getImageButton(rewindIcon);
        this.rewindReplayBtn.setToolTipText("Reset to the beginning");
        this.rewindReplayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaptureManager.this.replayIndex = 0;
                CaptureManager.this.checkReplayButtons();
            }
        });
        this.stepReplayBtn = GuiUtils.getImageButton(stepIcon);
        this.stepReplayBtn.setToolTipText("Step forward one event");
        this.stepReplayBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CaptureManager.this.stepReplay();
            }
        });
        this.playForeverCbx = new JCheckBox("Keep playing       ");
        JPanel labelPanel = GuiUtils.left(this.replayTimeLabel);
        this.checkReplayButtons();
        JPanel buttonsPanel = GuiUtils.hflow(Misc.newList(this.rewindReplayBtn, this.playReplayBtn, this.stepReplayBtn, this.playForeverCbx));
        JPanel replayPanel = GuiUtils.leftCenter(buttonsPanel, labelPanel);
        JPanel playPanel = GuiUtils.vbox(GuiUtils.left(this.loadCaptureBtn), GuiUtils.left(replayPanel), GuiUtils.left(this.skipLongDelaysCbx), GuiUtils.left(speedPanel));
        playPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Replay"));
        GuiUtils.tmpInsets = new Insets(8, 0, 8, 0);
        this.captureContents = GuiUtils.top(GuiUtils.doLayout(new Component[]{capturePanel, playPanel}, 1, GuiUtils.WT_Y, GuiUtils.WT_N));
        return this.captureContents;
    }

    public void showCaptureWindow() {
        if (this.captureWindow == null) {
            if (this.captureContents == null) {
                this.captureContents = this.doMakeCaptureContents();
            }
            this.captureWindow = new JFrame("Capture Window");
            GuiUtils.packWindow(this.captureWindow, this.captureContents, true);
        }
        this.captureWindow.setVisible(true);
        this.captureWindow.toFront();
    }
}

