/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.util.Misc;
import ucar.unidata.util.NamedThing;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;

public class AddeServer
extends NamedThing {
    public static final String TYPE_NONE = "none";
    public static final String TYPE_ANY = "any";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_RADAR = "radar";
    public static final String TYPE_POINT = "point";
    public static final String TYPE_WXTEXT = "wxtext";
    private static final String TAG_SERVERS = "servers";
    private static final String TAG_SERVER = "server";
    private static final String TAG_TYPE = "type";
    private static final String TAG_GROUP = "group";
    private static final String TAG_GROUPS = "groups";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ACTIVE = "active";
    private static final String ATTR_NAMES = "names";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_TYPE = "type";
    private List groups = new ArrayList();
    private boolean isLocal = false;
    private boolean active = true;

    public AddeServer() {
    }

    public AddeServer(String name) {
        this(name, name);
    }

    public AddeServer(String name, String description) {
        super(name, description);
    }

    private Element toXml(Document doc, boolean localOnly) throws Exception {
        Element serverNode = doc.createElement(TAG_SERVER);
        serverNode.setAttribute(ATTR_NAME, this.getName());
        serverNode.setAttribute(ATTR_ACTIVE, "" + this.getActive());
        if (this.getDescription() != null) {
            serverNode.setAttribute(ATTR_DESCRIPTION, this.getDescription());
        }
        int cnt = 0;
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            if (localOnly && !g.getIsLocal()) continue;
            ++cnt;
            Element descNode = doc.createElement(TAG_GROUP);
            descNode.setAttribute(ATTR_NAMES, g.getName());
            descNode.setAttribute(ATTR_ACTIVE, "" + g.getActive());
            descNode.setAttribute("type", g.getType());
            if (g.getDescription() != null) {
                descNode.setAttribute(ATTR_DESCRIPTION, g.getDescription());
            }
            serverNode.appendChild(descNode);
        }
        if (cnt == 0 && localOnly && !this.getIsLocal()) {
            return null;
        }
        return serverNode;
    }

    public static Element toXml(List servers, boolean localOnly) throws Exception {
        Document doc = XmlUtil.makeDocument();
        Element root = doc.createElement(TAG_SERVERS);
        for (int i = 0; i < servers.size(); ++i) {
            AddeServer server = (AddeServer)servers.get(i);
            Element node = server.toXml(doc, localOnly);
            if (node == null) continue;
            root.appendChild(node);
        }
        return root;
    }

    private static void processXml(AddeServer server, Element root) {
        List typeNodes = XmlUtil.findChildren(root, "type");
        for (int i = 0; i < typeNodes.size(); ++i) {
            Element typeNode = (Element)typeNodes.get(i);
            String type = XmlUtil.getAttribute(typeNode, ATTR_NAME);
            AddeServer.processGroups(server, typeNode, type);
        }
        AddeServer.processGroups(server, root, null);
    }

    public static List coalesce(List servers) {
        ArrayList<AddeServer> result = new ArrayList<AddeServer>();
        Hashtable<String, AddeServer> seen = new Hashtable<String, AddeServer>();
        for (int i = 0; i < servers.size(); ++i) {
            AddeServer server = (AddeServer)servers.get(i);
            AddeServer gotIt = (AddeServer)seen.get(server.getName());
            if (gotIt != null) {
                gotIt.addGroups(server.getGroups());
                continue;
            }
            seen.put(server.getName(), server);
            result.add(server);
        }
        return result;
    }

    private static void processGroups(AddeServer server, Element root, String type) {
        List descNodes = XmlUtil.findChildren(root, TAG_GROUP);
        for (int j = 0; j < descNodes.size(); ++j) {
            String name;
            Element descNode = (Element)descNodes.get(j);
            String theType = type;
            if (theType == null) {
                theType = XmlUtil.getAttribute(descNode, "type");
            }
            List<String> names = StringUtil.split(XmlUtil.getAttribute((Node)descNode, ATTR_NAMES, ""), ",", true, true);
            for (int nameIdx = 0; nameIdx < names.size(); ++nameIdx) {
                name = names.get(nameIdx);
                if (name.length() <= 0) continue;
                Group group = new Group(theType, name, name);
                group.setActive(XmlUtil.getAttribute((Node)descNode, ATTR_ACTIVE, true));
                server.addGroup(group);
            }
            name = XmlUtil.getAttribute((Node)descNode, ATTR_NAME, (String)null);
            if (name == null || name.length() <= 0) continue;
            Group group = new Group(theType, name, XmlUtil.getAttribute((Node)descNode, ATTR_DESCRIPTION, name));
            group.setActive(XmlUtil.getAttribute((Node)descNode, ATTR_ACTIVE, true));
            server.addGroup(group);
        }
    }

    public static List processXml(Element root) {
        ArrayList<AddeServer> servers = new ArrayList<AddeServer>();
        List serverNodes = XmlUtil.findChildren(root, TAG_SERVER);
        for (int i = 0; i < serverNodes.size(); ++i) {
            Element serverNode = (Element)serverNodes.get(i);
            String name = XmlUtil.getAttribute(serverNode, ATTR_NAME);
            String desc = XmlUtil.getAttribute((Node)serverNode, ATTR_DESCRIPTION, name);
            AddeServer server = new AddeServer(name, desc);
            server.setActive(XmlUtil.getAttribute((Node)serverNode, ATTR_ACTIVE, true));
            AddeServer.processXml(server, serverNode);
            servers.add(server);
        }
        return servers;
    }

    public static AddeServer findServer(List servers, String name) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < servers.size(); ++i) {
            AddeServer server = (AddeServer)servers.get(i);
            if (!Misc.equals(server.getName(), name)) continue;
            return server;
        }
        return null;
    }

    public static List getServersWithType(String type, List servers) {
        ArrayList<AddeServer> result = new ArrayList<AddeServer>();
        for (int i = 0; i < servers.size(); ++i) {
            AddeServer server = (AddeServer)servers.get(i);
            if (!Misc.equals(type, TYPE_ANY) && !server.hasType(type)) continue;
            result.add(server);
        }
        return result;
    }

    public void setIsLocal(boolean value) {
        this.isLocal = value;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean getActive() {
        return this.active;
    }

    public boolean hasType(String type) {
        return this.getGroupsWithType(type).size() > 0;
    }

    public void addGroup(Group group) {
        if (!this.groups.contains(group)) {
            this.groups.add(group);
        }
    }

    public void addGroups(List groupsToAdd) {
        for (int i = 0; i < groupsToAdd.size(); ++i) {
            Group g = (Group)groupsToAdd.get(i);
            this.addGroup(g);
        }
    }

    public void setGroups(List value) {
        this.groups = value;
    }

    public List getGroups() {
        return this.groups;
    }

    public Group findGroup(String name) {
        name = name.trim();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            if (!g.getName().equals(name)) continue;
            return g;
        }
        return null;
    }

    public List getGroupsWithType(String type) {
        return this.getGroupsWithType(type, true);
    }

    public List getGroupsWithType(String type, boolean onlyActive) {
        ArrayList<Group> result = new ArrayList<Group>();
        for (int i = 0; i < this.groups.size(); ++i) {
            Group g = (Group)this.groups.get(i);
            if (onlyActive && !g.getActive()) continue;
            if (type == null || type.equals(TYPE_ANY)) {
                result.add(g);
                continue;
            }
            if (!g.getType().equals(type)) continue;
            result.add(g);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AddeServer)) {
            return false;
        }
        AddeServer that = (AddeServer)o;
        return Misc.equals(this.groups, that.groups);
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                List servers = AddeServer.processXml(XmlUtil.getRoot(args[i], AddeServer.class));
                System.err.println(XmlUtil.toString(AddeServer.toXml(servers, false)));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static class Group
    extends NamedThing {
        private boolean isLocal = false;
        private String type = "none";
        private boolean active = true;

        public Group() {
        }

        public Group(String type, String name, String desc) {
            super(name, desc);
            this.type = type;
        }

        public void setType(String value) {
            this.type = value;
        }

        public String getType() {
            return this.type;
        }

        public void setIsLocal(boolean value) {
            this.isLocal = value;
        }

        public boolean getIsLocal() {
            return this.isLocal;
        }

        public void setActive(boolean value) {
            this.active = value;
        }

        public boolean getActive() {
            return this.active;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            Group that = (Group)o;
            return Misc.equals(this.type, that.type);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Misc.hashcode(this.type);
        }

        @Override
        public String toString() {
            String s = super.toString();
            if (this.isLocal) {
                // empty if block
            }
            return s;
        }
    }
}

