/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddePointDataChooser;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.quantities.CommonUnits;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class AddeRaobPointDataChooser
extends AddePointDataChooser {
    private static String[] levelNames = new String[]{"SFC", "1000", "925", "850", "700", "500", "400", "300", "250", "200", "150", "100", "70", "50", "30", "20", "10"};
    private static int[] levelValues = new int[]{1001, 1000, 925, 850, 700, 500, 400, 300, 250, 200, 150, 100, 70, 50, 30, 20, 10};
    private List levels = null;
    private boolean zeroAndTwelveZOnly = true;

    public AddeRaobPointDataChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.makeLevels();
    }

    private List makeLevels() {
        this.levels = new ArrayList();
        try {
            for (int i = 0; i < levelValues.length; ++i) {
                this.levels.add(new TwoFacedObject((Object)levelNames[i], new Real(RealType.getRealType("Pressure", CommonUnits.MILLIBAR), levelValues[i], CommonUnits.MILLIBAR)));
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return this.levels;
    }

    @Override
    protected JComponent getExtraTimeComponent() {
        JCheckBox timeSubset = GuiUtils.makeCheckbox("00 & 12Z only", this, "zeroAndTwelveZOnly");
        return timeSubset;
    }

    @Override
    public String getDefaultStationModel() {
        return "observations>upper air";
    }

    @Override
    public boolean canDoLevels() {
        return true;
    }

    @Override
    public String getDataName() {
        return "RAOB Point Data";
    }

    @Override
    protected String getTimesRequest() {
        StringBuffer buf = this.getGroupUrl("pointdata", this.getGroup());
        this.appendKeyValue(buf, "descr", this.getDescriptor());
        if (this.getZeroAndTwelveZOnly()) {
            this.appendKeyValue(buf, "select", "'TIME 00,12'");
        }
        this.appendKeyValue(buf, "pos", "0");
        this.appendKeyValue(buf, "num", "ALL");
        this.appendKeyValue(buf, "param", "DAY TIME");
        return buf.toString();
    }

    @Override
    protected TwoFacedObject[] getDefaultDatasets() {
        return new TwoFacedObject[]{new TwoFacedObject((Object)"Upper Air Data", "RTPTSRC/UPPERMAND")};
    }

    @Override
    public float getRelativeTimeIncrement() {
        return this.getZeroAndTwelveZOnly() ? 12.0f : 3.0f;
    }

    public boolean getZeroAndTwelveZOnly() {
        return this.zeroAndTwelveZOnly;
    }

    public void setZeroAndTwelveZOnly(boolean value) {
        this.zeroAndTwelveZOnly = value;
        if (this.getDoAbsoluteTimes()) {
            this.readTimes();
        }
    }

    @Override
    public List getLevels() {
        if (this.levels == null) {
            this.makeLevels();
        }
        return this.levels;
    }
}

