/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeImageChooser;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.metdata.Station;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class AddeRadarChooser
extends AddeImageChooser {
    protected static final String VALUE_LIST = "list";
    private static final String[] RADAR_PROPS = new String[]{"UNIT"};
    private static final String[] RADAR_LABELS = new String[]{"Data Type:"};
    private boolean readingStations = false;
    private Object readStationTask;
    private List nexradStations = this.getIdv().getResourceManager().findLocationsByType("radar");

    public AddeRadarChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected String getGroupType() {
        return "radar";
    }

    @Override
    public boolean showAdvancedInTab() {
        return false;
    }

    @Override
    public String getDataName() {
        return "Radar Data";
    }

    @Override
    public String getDescriptorLabel() {
        return "Product";
    }

    protected int getImageListSize() {
        return 6;
    }

    @Override
    protected void getComponents(List comps) {
        ArrayList extraComps = new ArrayList();
        super.getComponents(extraComps);
        extraComps.addAll(this.processPropertyComponents());
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel extra = GuiUtils.doLayout(extraComps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        JComponent stationMap = this.getStationMap();
        stationMap.setPreferredSize(new Dimension(230, 200));
        stationMap = this.registerStatusComp("stations", stationMap);
        this.addServerComp(stationMap);
        JComponent timesPanel = this.addServerComp(this.makeTimesPanel(false, true));
        JPanel panel = GuiUtils.centerRight(stationMap, GuiUtils.topCenter(GuiUtils.filler(250, 1), GuiUtils.top(extra)));
        comps.add(this.addServerComp(GuiUtils.valignLabel("Stations:")));
        comps.add(panel);
        comps.add(GuiUtils.valignLabel("Times:"));
        comps.add(timesPanel);
    }

    @Override
    protected JComponent doMakeContents() {
        ArrayList comps = new ArrayList();
        comps.addAll(this.processServerComponents());
        this.getComponents(comps);
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel imagePanel = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_NYN);
        return GuiUtils.centerBottom(imagePanel, this.getDefaultButtons(this));
    }

    @Override
    protected void addTimesComponent(List comps) {
    }

    @Override
    public String getDatasetName() {
        return this.getSelectedStation() + " (" + super.getDatasetName() + ")";
    }

    @Override
    protected void connectToServer() {
        this.clearStations();
        super.connectToServer();
        this.setAvailableStations();
    }

    @Override
    protected boolean canReadTimes() {
        return super.canReadTimes() && this.getSelectedStation() != null;
    }

    @Override
    protected String[] getAdvancedProps() {
        return RADAR_PROPS;
    }

    @Override
    protected String[] getAdvancedLabels() {
        return RADAR_LABELS;
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.getState() != 2) {
            this.clearStations();
        }
        if (this.readStationTask != null) {
            if (this.taskOk(this.readStationTask)) {
                this.setStatus("Reading available stations from server");
            } else {
                this.readStationTask = null;
                this.setState(0);
            }
        }
    }

    @Override
    protected void newSelectedStations(List stations) {
        super.newSelectedStations(stations);
        this.descriptorChanged();
    }

    @Override
    protected void descriptorChanged() {
        if (!this.getHaveStations()) {
            this.setAvailableStations();
        }
        super.descriptorChanged();
    }

    private void setAvailableStations() {
        this.readStationTask = this.startTask();
        this.clearSelectedStations();
        this.updateStatus();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                AddeRadarChooser.this.showWaitCursor();
                List stations = AddeRadarChooser.this.readStations();
                if (AddeRadarChooser.this.stopTaskAndIsOk(AddeRadarChooser.this.readStationTask)) {
                    AddeRadarChooser.this.readStationTask = null;
                    if (stations != null) {
                        AddeRadarChooser.this.getStationMap().setStations(stations);
                    } else {
                        AddeRadarChooser.this.clearStations();
                    }
                    AddeRadarChooser.this.updateStatus();
                    AddeRadarChooser.this.revalidate();
                } else {
                    AddeRadarChooser.this.setState(0);
                }
                AddeRadarChooser.this.showNormalCursor();
            }
        });
    }

    private List readStations() {
        ArrayList<Object> stations = new ArrayList<Object>();
        try {
            if (this.descriptorNames == null || this.descriptorNames.length == 0) {
                return stations;
            }
            StringBuffer buff = this.getGroupUrl("imagedir", this.getGroup());
            String descrForIds = this.descriptorNames[0];
            Hashtable dtable = this.getDescriptorTable();
            Iterator iter = dtable.keySet().iterator();
            String group = this.getGroup().toLowerCase();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String descriptor = ((String)dtable.get(name)).toLowerCase();
                if (group.indexOf("tdw") >= 0 && descriptor.equals("tr0")) {
                    descrForIds = name;
                    break;
                }
                if (!descriptor.equals("n0q") && !descriptor.equals("n0r") && !descriptor.startsWith("bref")) continue;
                descrForIds = name;
                break;
            }
            this.appendKeyValue(buff, "descr", this.getDescriptorFromSelection(descrForIds));
            this.appendKeyValue(buff, "ID", VALUE_LIST);
            if (this.archiveDay != null) {
                this.appendKeyValue(buff, "DAY", this.archiveDay);
            }
            Hashtable<String, String> seen = new Hashtable<String, String>();
            AreaDirectoryList dirList = new AreaDirectoryList(buff.toString());
            for (AreaDirectory ad : dirList.getDirs()) {
                String stationId = McIDASUtil.intBitsToString(ad.getValue(20)).trim();
                if (seen.get(stationId) != null) continue;
                seen.put(stationId, stationId);
                Object station = this.findStation(stationId);
                if (station == null) continue;
                stations.add(station);
            }
        }
        catch (AreaFileException e) {
            String msg = e.getMessage();
            if (msg.toLowerCase().indexOf("no images meet the selection criteria") >= 0) {
                LogUtil.userErrorMessage("No stations could be found on the server");
                stations = new ArrayList();
                this.setState(0);
            }
            this.handleConnectionError(e);
        }
        return stations;
    }

    private Object findStation(String stationId) {
        for (int i = 0; i < this.nexradStations.size(); ++i) {
            NamedStationTable table = (NamedStationTable)this.nexradStations.get(i);
            Station station = table.get(stationId);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    @Override
    public void doCancel() {
        this.readStationTask = null;
        super.doCancel();
    }

    @Override
    protected String makeRequestString(AreaDirectory ad, boolean doTimes, int cnt) {
        StringBuffer buf = this.getGroupUrl("imagedata", this.getGroup());
        buf.append(this.makeDateTimeString(ad, cnt, doTimes));
        String[] props = new String[]{"descr", "ID", "UNIT", "SPAC", "MAG", "SIZE"};
        buf.append(this.makeProps(props, ad));
        return buf.toString();
    }

    @Override
    protected String[] getBaseUrlProps() {
        return new String[]{"descr", "ID", "UNIT", "SPAC", "BAND"};
    }

    @Override
    protected String getDefaultPropValue(String prop, AreaDirectory ad, boolean forDisplay) {
        if (prop.equals("ID")) {
            return this.getSelectedStation();
        }
        return super.getDefaultPropValue(prop, ad, forDisplay);
    }

    @Override
    protected String getPropertiesDescription() {
        StringBuffer buf = new StringBuffer();
        if (this.unitComboBox != null) {
            buf.append(this.getAdvancedLabels()[0]);
            buf.append(" ");
            buf.append(this.unitComboBox.getSelectedItem().toString());
        }
        return buf.toString();
    }

    @Override
    protected void getDataSourceProperties(Hashtable ht) {
        super.getDataSourceProperties(ht);
        ht.put("prop.imagetype", "radar");
    }
}

