/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.view.station.StationLocationMap;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.visad.UtcDate;
import visad.DateTime;

public class AddeProfilerDataChooser
extends AddeChooser {
    private static final String GROUP = "RTPTSRC";
    private static final String PROFILER_6MIN = "6 minute";
    private static final String PROFILER_12MIN = "12 minute";
    private static final String PROFILER_30MIN = "30 minute";
    private static final String PROFILER_1HR = "Hourly";
    private JComboBox dataIntervalBox;
    private XmlResourceCollection stationResources;

    public AddeProfilerDataChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.initProfiler();
    }

    private void initProfiler() {
        Object[] intervals = new TwoFacedObject[]{new TwoFacedObject((Object)PROFILER_1HR, PROFILER_1HR), new TwoFacedObject((Object)PROFILER_30MIN, PROFILER_30MIN), new TwoFacedObject((Object)PROFILER_12MIN, PROFILER_12MIN), new TwoFacedObject((Object)PROFILER_6MIN, PROFILER_6MIN)};
        this.dataIntervalBox = new JComboBox();
        GuiUtils.setListData(this.dataIntervalBox, intervals);
        this.dataIntervalBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                AddeProfilerDataChooser.this.setState(0);
            }
        });
        ArrayList<JComponent> allComps = new ArrayList<JComponent>();
        this.getStationMap().setPreferredSize(new Dimension(200, 200));
        this.clearOnChange(this.dataIntervalBox);
        this.addTopComponents(allComps, "Data Interval:", this.dataIntervalBox);
        JPanel timesPanel = this.makeTimesPanel();
        StationLocationMap stationMap = this.getStationMap();
        stationMap.setPreferredSize(new Dimension(230, 180));
        allComps.add(GuiUtils.valignLabel("Stations:"));
        allComps.add(stationMap);
        allComps.add(GuiUtils.valignLabel("Times:"));
        allComps.add(this.addServerComp(timesPanel));
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel top = GuiUtils.doLayout(allComps, 2, GuiUtils.WT_NY, GuiUtils.WT_NYN);
        this.contents = GuiUtils.centerBottom(top, this.getDefaultButtons());
        this.updateStatus();
    }

    @Override
    public String getDataName() {
        return "Profiler Data";
    }

    @Override
    public void readTimes() {
        this.setState(1);
        StringBuffer buf = this.getGroupUrl("pointdata", GROUP);
        this.appendKeyValue(buf, "descr", this.getDataSourceInterval());
        this.appendKeyValue(buf, "select", "'IDA BLMM'");
        this.appendKeyValue(buf, "num", "ALL");
        this.appendKeyValue(buf, "param", "DAY TIME");
        SortedSet<DateTime> uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        try {
            AddePointDataReader apr = new AddePointDataReader(buf.toString());
            int[][] data = apr.getData();
            String[] units = apr.getUnits();
            if (!units[0].equals("CYD") || !units[1].equals("HMS")) {
                throw new Exception("can't handle date/time units");
            }
            int numObs = data[0].length;
            for (int i = 0; i < numObs; ++i) {
                try {
                    DateTime dt = new DateTime(McIDASUtil.mcDayTimeToSecs(data[0][i], data[1][i]));
                    uniqueTimes.add(dt);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setState(2);
        }
        catch (Exception excp) {
            this.handleConnectionError(excp);
            return;
        }
        if (this.getDoAbsoluteTimes()) {
            if (!uniqueTimes.isEmpty()) {
                this.setAbsoluteTimes(new ArrayList(uniqueTimes));
                this.getTimesList().setSelectionMode(1);
            }
            int selectedIndex = this.getAbsoluteTimes().size() - 1;
            int firstIndex = Math.max(0, selectedIndex - this.getDefaultRelativeTimeIndex());
            this.setSelectedAbsoluteTime(selectedIndex, firstIndex);
        }
    }

    private String getDayTimeSelectString() {
        StringBuffer buf = new StringBuffer();
        if (this.getDoAbsoluteTimes()) {
            List times = this.getSelectedAbsoluteTimes();
            if (times.size() == 0) {
                return "";
            }
            if (times.get(0) instanceof String) {
                return "";
            }
            buf.append("time ");
            String dataInterval = this.getDataSourceInterval();
            if (dataInterval.equals("PROFHOURLY")) {
                for (int i = 0; i < times.size(); ++i) {
                    buf.append(UtcDate.getHH((DateTime)times.get(i)));
                    if (i == times.size() - 1) continue;
                    buf.append(",");
                }
            } else {
                for (int kk = 0; kk < times.size(); ++kk) {
                    buf.append(UtcDate.getHMS((DateTime)times.get(kk)));
                    if (kk >= times.size() - 1) continue;
                    buf.append(",");
                }
            }
        } else {
            buf.append("%relative%");
        }
        return buf.toString();
    }

    private void doSetTimes() {
    }

    @Override
    protected int getNumTimesToSelect() {
        return 5;
    }

    @Override
    public void handleUpdate() throws Exception {
        this.readTimes();
        this.updateStatus();
        this.showNormalCursor();
        this.doSetTimes();
        this.saveServerState();
    }

    @Override
    protected StationLocationMap createStationMap() {
        return new StationLocationMap(true, null, "%NAME%"){

            @Override
            public void setDeclutter(boolean declutter) {
                super.setDeclutter(declutter);
                AddeProfilerDataChooser.this.updateStatus();
            }
        };
    }

    @Override
    protected ProjectionRect getDefaultProjectionRect() {
        return new ProjectionRect(-2000.0, -1800.0, 2500.0, 1800.0);
    }

    @Override
    protected void initStationMap(StationLocationMap stationMap) {
        super.initStationMap(stationMap);
        if (this.stationResources == null) {
            List resources = Misc.newList("/ucar/unidata/idv/resources/stations/profilerstns.xml");
            this.stationResources = new XmlResourceCollection("", resources);
        }
        NamedStationTable stationTable = NamedStationTable.createStationTable(this.stationResources.getRoot(0));
        List listOfTables = NamedStationTable.createStationTables(this.stationResources);
        if (listOfTables.size() > 0) {
            NamedStationTable profStations = (NamedStationTable)listOfTables.get(0);
            stationMap.setStations(new ArrayList(profStations.values()));
        }
    }

    public String getSelectedTimes() {
        return this.getDayTimeSelectString();
    }

    public String getSelectedInterval() {
        return TwoFacedObject.getIdString(this.dataIntervalBox.getSelectedItem());
    }

    @Override
    protected int getDefaultRelativeTimeIndex() {
        return 11;
    }

    @Override
    public float getRelativeTimeIncrement() {
        String currentType = this.getSelectedInterval();
        if (currentType.equals(PROFILER_30MIN)) {
            return 0.5f;
        }
        if (currentType.equals(PROFILER_12MIN)) {
            return 0.2f;
        }
        if (currentType.equals(PROFILER_6MIN)) {
            return 0.1f;
        }
        return 1.0f;
    }

    public String getDataSourceInterval() {
        String interval = this.getSelectedInterval();
        if (interval.equals(PROFILER_30MIN) || interval.equals(PROFILER_12MIN) || interval.equals(PROFILER_6MIN)) {
            return "PROF6MIN";
        }
        return "PROFHOURLY";
    }

    @Override
    protected void appendMiscKeyValues(StringBuffer buff) {
        this.appendKeyValue(buff, "pos", this.getDoRelativeTimes() ? "ALL" : "0");
        super.appendMiscKeyValues(buff);
    }

    @Override
    public void doLoadInThread() {
        this.showWaitCursor();
        try {
            List selectedStations = this.getSelectedStations();
            Hashtable<String, Object> profilersourceHT = new Hashtable<String, Object>();
            profilersourceHT.put("data_interval", this.getSelectedInterval());
            profilersourceHT.put("datasourceinterval", this.getDataSourceInterval());
            profilersourceHT.put("profilerserver", this.getServer());
            profilersourceHT.put("profilertimes", this.getSelectedTimes());
            profilersourceHT.put(AddeUtil.NUM_RELATIVE_TIMES, this.getRelativeTimeIndices());
            profilersourceHT.put(AddeUtil.RELATIVE_TIME_INCREMENT, new Float(this.getRelativeTimeIncrement()));
            if (this.getDoAbsoluteTimes()) {
                profilersourceHT.put(AddeUtil.ABSOLUTE_TIMES, this.getSelectedAbsoluteTimes());
            }
            profilersourceHT.put("misckeywords", this.getMiscKeywords());
            profilersourceHT.put("Chooser_Do_Time_Matching", this.getDoTimeDrivers());
            this.makeDataSource(selectedStations, "ADDE.PROFILER", profilersourceHT);
            this.saveServerState();
        }
        catch (Exception excp) {
            this.logException("Unable to open Profiler dataset", excp);
        }
        this.showNormalCursor();
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.setDoTimeDrivers(false);
    }
}

