/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.ui.symbol.StationModelManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.UtcDate;
import visad.DateTime;

public class AddePointDataChooser
extends AddeChooser {
    public static String DATASET_NAME_KEY = "name";
    public static String DATA_TYPE = "ADDE.POINT";
    protected JComboBox dataTypes;
    protected JComboBox stationModelBox;
    protected JComboBox levelBox = null;
    private static final String METAR = "Surface (METAR) Data";
    private static final String SYNOPTIC = "Synoptic Data";
    private static final String SHIPBUOY = "Ship/Buoy Data";
    private StationModelManager stationModelManager;
    public static String LEVELS = "data levels";
    public static String SELECTED_LEVEL = "selected level";
    protected JComboBox relTimeIncBox;
    private JComponent relTimeIncComp;
    private float relativeTimeIncrement = 1.0f;

    public AddePointDataChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.init(this.getIdv().getStationModelManager());
    }

    private void init(StationModelManager stationModelManager) {
        this.stationModelManager = stationModelManager;
        Vector stationModels = new Vector(stationModelManager.getStationModels());
        this.stationModelBox = new JComboBox(stationModels);
        for (int i = 0; i < stationModels.size(); ++i) {
            if (!stationModels.get(i).toString().equalsIgnoreCase(this.getDefaultStationModel())) continue;
            this.stationModelBox.setSelectedItem(stationModels.get(i));
            break;
        }
        Object selected = null;
        Object[] defaultDatasets = this.getDefaultDatasets();
        String[] serverState = this.getDefaultServerSelection();
        if (serverState != null) {
            for (Object dataset : defaultDatasets) {
                if (!String.valueOf(((TwoFacedObject)dataset).getId()).startsWith(serverState[1])) continue;
                selected = dataset;
                break;
            }
        }
        this.dataTypes = GuiUtils.getEditableBox(Misc.toList(defaultDatasets), selected);
        this.dataTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                AddePointDataChooser.this.setState(0);
                String currentType = AddePointDataChooser.this.dataTypes.getSelectedItem().toString();
                String currentName = AddePointDataChooser.this.getDataName();
                if (currentType.indexOf(AddePointDataChooser.SYNOPTIC) >= 0) {
                    AddePointDataChooser.this.setRelativeTimeIncrement(3.0f);
                } else if (currentName != null && currentName.contains("GLM Lightning Data")) {
                    AddePointDataChooser.this.setRelativeTimeIncrement(5.0f);
                } else {
                    AddePointDataChooser.this.setRelativeTimeIncrement(1.0f);
                }
            }
        });
        if (this.canDoLevels()) {
            this.levelBox = GuiUtils.getEditableBox(this.getLevels(), null);
        }
    }

    @Override
    protected JComponent doMakeContents() {
        ArrayList<JComponent> allComps = new ArrayList<JComponent>();
        this.clearOnChange(this.dataTypes);
        this.addTopComponents(allComps, "Data Type:", this.dataTypes);
        JPanel timesComp = this.makeTimesPanel();
        allComps.add(this.addServerComp(GuiUtils.valignLabel("Times:")));
        allComps.add(this.addServerComp(timesComp));
        if (this.canDoLevels()) {
            allComps.add(this.addServerComp(GuiUtils.rLabel("Level:")));
            allComps.add(this.addServerComp(GuiUtils.left(this.levelBox)));
        }
        JComponent top = GuiUtils.formLayout(allComps, GRID_INSETS);
        return GuiUtils.top(GuiUtils.centerBottom(top, this.getDefaultButtons()));
    }

    @Override
    protected String getDefaultDisplayType() {
        return "stationmodelcontrol";
    }

    @Override
    public void doLoadInThread() {
        this.showWaitCursor();
        try {
            StationModel selectedStationModel = this.getSelectedStationModel();
            String source = this.getRequestUrl();
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            this.getDataSourceProperties(ht);
            ht.put("Chooser_Do_Time_Matching", this.getDoTimeDrivers());
            ht.put("prop.stationmodelname", selectedStationModel.getName());
            ht.put(DATASET_NAME_KEY, this.getDatasetName());
            ht.put("data name", this.getDataName());
            if (source.indexOf("%relative%") >= 0) {
                ht.put(AddeUtil.NUM_RELATIVE_TIMES, this.getRelativeTimeIndices());
                ht.put(AddeUtil.RELATIVE_TIME_INCREMENT, new Float(this.getRelativeTimeIncrement()));
            }
            if (this.getDoAbsoluteTimes()) {
                ht.put(AddeUtil.ABSOLUTE_TIMES, this.getSelectedAbsoluteTimes());
            }
            if (source.indexOf("%level%") >= 0) {
                ht.put(LEVELS, this.getLevels());
                ht.put(SELECTED_LEVEL, this.getSelectedLevel());
            }
            this.makeDataSource(source, DATA_TYPE, ht);
            this.saveServerState();
        }
        catch (Exception excp) {
            this.logException("Unable to open ADDE point dataset", excp);
        }
        this.showNormalCursor();
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.setDoTimeDrivers(false);
    }

    @Override
    protected JPanel makeTimesPanel() {
        return super.makeTimesPanel(true);
    }

    @Override
    protected JComponent getExtraRelativeTimeComponent() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox box = (JComboBox)ae.getSource();
                if (GuiUtils.anySelected(box)) {
                    AddePointDataChooser.this.setRelativeTimeIncrement(AddePointDataChooser.this.getRelBoxValue());
                }
            }
        };
        String[] nums = new String[]{".5", "1", "3", "6", "12", "24"};
        float[] vals = new float[]{0.5f, 1.0f, 3.0f, 6.0f, 12.0f, 24.0f};
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        for (int i = 0; i < nums.length; ++i) {
            l.add(new TwoFacedObject((Object)nums[i], new Float(vals[i])));
        }
        this.relTimeIncBox = GuiUtils.getEditableBox(l, new Float(this.relativeTimeIncrement));
        this.relTimeIncBox.addActionListener(listener);
        this.relTimeIncBox.setToolTipText("Set the increment between most recent times");
        this.relTimeIncComp = GuiUtils.hbox((Component)new JLabel("Increment: "), (Component)this.relTimeIncBox, GuiUtils.lLabel(this.getRelTimeIncLabel()));
        return GuiUtils.left(this.relTimeIncComp);
    }

    public String getRelTimeIncLabel() {
        return " hours";
    }

    private float getRelBoxValue() {
        Object o;
        float value = this.relativeTimeIncrement;
        if (this.relTimeIncBox != null && (o = this.relTimeIncBox.getSelectedItem()) != null) {
            String val = TwoFacedObject.getIdString(o);
            value = (float)Misc.parseNumber(val);
        }
        return value;
    }

    public StationModel getSelectedStationModel() {
        return (StationModel)this.stationModelBox.getSelectedItem();
    }

    protected String getDescriptor() {
        String dataset = TwoFacedObject.getIdString(this.dataTypes.getSelectedItem());
        int index = dataset.indexOf(47);
        if (index == -1) {
            throw new IllegalArgumentException("Bad dataset: \"" + dataset + "\"");
        }
        return dataset.substring(index + 1);
    }

    @Override
    protected String getGroup() {
        String dataset = TwoFacedObject.getIdString(this.dataTypes.getSelectedItem());
        int index = dataset.indexOf(47);
        if (index == -1) {
            throw new IllegalArgumentException("Bad dataset: \"" + dataset + "\"");
        }
        return dataset.substring(0, index);
    }

    public String getRequestUrl() {
        StringBuffer request = this.getGroupUrl("pointdata", this.getGroup());
        this.appendKeyValue(request, "descr", this.getDescriptor());
        this.appendRequestSelectClause(request);
        this.appendKeyValue(request, "num", "all");
        this.appendKeyValue(request, "pos", this.getDoRelativeTimes() ? "ALL" : "0");
        return request.toString();
    }

    public List getLevels() {
        return new ArrayList();
    }

    public Object getSelectedLevel() {
        if (this.levelBox != null) {
            return this.levelBox.getSelectedItem();
        }
        return null;
    }

    protected void appendRequestSelectClause(StringBuffer buf) {
        StringBuffer selectValue = new StringBuffer();
        selectValue.append("'");
        selectValue.append(this.getDayTimeSelectString());
        if (this.getDescriptor().equalsIgnoreCase("SFCHOURLY")) {
            selectValue.append(";type 0");
        }
        selectValue.append(";");
        if (this.canDoLevels()) {
            selectValue.append("%level%");
            selectValue.append(";");
        }
        selectValue.append("%latlonbox%");
        selectValue.append("'");
        this.appendKeyValue(buf, "select", selectValue.toString());
    }

    public boolean canDoLevels() {
        return false;
    }

    @Override
    public void handleUpdate() throws Exception {
        this.readTimes();
        this.saveServerState();
    }

    protected String getTimesRequest() {
        StringBuffer buf = this.getGroupUrl("pointdata", this.getGroup());
        this.appendKeyValue(buf, "descr", this.getDescriptor());
        this.appendKeyValue(buf, "select", "'LAT 38 42;LON 70 75'");
        this.appendKeyValue(buf, "pos", "0");
        if (this.getDoAbsoluteTimes()) {
            this.appendKeyValue(buf, "num", "all");
        }
        this.appendKeyValue(buf, "param", "day time");
        return buf.toString();
    }

    @Override
    public String getDataName() {
        return "Point Data";
    }

    @Override
    public void readTimes() {
        this.clearTimesList();
        SortedSet<DateTime> uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        this.setState(1);
        try {
            AddePointDataReader apr = new AddePointDataReader(this.getTimesRequest());
            int[][] data = apr.getData();
            String[] units = apr.getUnits();
            if (!units[0].equals("CYD") || !units[1].equals("HMS")) {
                throw new Exception("can't handle date/time units");
            }
            int numObs = data[0].length;
            for (int i = 0; i < numObs; ++i) {
                try {
                    DateTime dt = new DateTime(McIDASUtil.mcDayTimeToSecs(data[0][i], data[1][i]));
                    uniqueTimes.add(dt);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setState(2);
        }
        catch (Exception excp) {
            this.handleConnectionError(excp);
            return;
        }
        if (this.getDoAbsoluteTimes()) {
            if (!uniqueTimes.isEmpty()) {
                this.setAbsoluteTimes(new ArrayList(uniqueTimes));
            }
            int selectedIndex = this.getAbsoluteTimes().size() - 1;
            this.setSelectedAbsoluteTime(selectedIndex);
        }
    }

    @Override
    protected int getNumTimesToSelect() {
        return 1;
    }

    @Override
    protected boolean haveTimeSelected() {
        return !this.getDoAbsoluteTimes() || this.getHaveAbsoluteTimesSelected();
    }

    protected String getDayTimeSelectString() {
        StringBuffer buf = new StringBuffer();
        if (this.getDoAbsoluteTimes()) {
            buf.append("time ");
            List times = this.getSelectedAbsoluteTimes();
            for (int i = 0; i < times.size(); ++i) {
                DateTime dt = (DateTime)times.get(i);
                buf.append(UtcDate.getHMS(dt));
                if (i == times.size() - 1) continue;
                buf.append(",");
            }
        } else {
            buf.append(this.getRelativeTimeId());
        }
        return buf.toString();
    }

    protected String getRelativeTimeId() {
        return "%relative%";
    }

    public String getDatasetName() {
        return this.dataTypes.getSelectedItem().toString();
    }

    @Override
    public String getDataType() {
        return "POINT";
    }

    @Override
    public float getRelativeTimeIncrement() {
        return this.relativeTimeIncrement;
    }

    public void setRelativeTimeIncrement(float increment) {
        this.relativeTimeIncrement = increment;
        if (this.relTimeIncBox != null) {
            this.relTimeIncBox.setSelectedItem(new Float(this.relativeTimeIncrement));
        }
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        this.enableWidgets();
    }

    @Override
    protected void enableWidgets() {
        super.enableWidgets();
        if (this.relTimeIncComp != null) {
            GuiUtils.enableTree(this.relTimeIncComp, this.getDoRelativeTimes());
        }
    }

    protected TwoFacedObject[] getDefaultDatasets() {
        return new TwoFacedObject[]{new TwoFacedObject((Object)METAR, "RTPTSRC/SFCHOURLY"), new TwoFacedObject((Object)SYNOPTIC, "RTPTSRC/SYNOPTIC"), new TwoFacedObject((Object)SHIPBUOY, "RTPTSRC/SHIPBUOY"), new TwoFacedObject((Object)"Archived Surface (METAR) Data", "PTSRCALL/SFCHOURLY"), new TwoFacedObject((Object)"Archived Synoptic Data", "PTSRCALL/SYNOPTIC"), new TwoFacedObject((Object)"Archived Ship/Buoy Data", "PTSRCALL/SHIPBUOY")};
    }

    public String getDefaultStationModel() {
        return "observations>metar";
    }

    @Override
    protected void handleConnectionError(Exception excp) {
        String message = excp.getMessage().toLowerCase();
        if (message.indexOf("with position 0") >= 0) {
            LogUtil.userErrorMessage("Unable to handle archive dataset");
            return;
        }
        super.handleConnectionError(excp);
    }

    @Override
    protected String getGroupType() {
        return "point";
    }
}

