/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddePointDataChooser;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.UtcDate;
import visad.DateTime;

public class AddeLightningDataChooser
extends AddePointDataChooser {
    public AddeLightningDataChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public String getDefaultStationModel() {
        return "flash";
    }

    @Override
    public String getDataName() {
        return "Lightning Data";
    }

    @Override
    protected TwoFacedObject[] getDefaultDatasets() {
        return new TwoFacedObject[]{new TwoFacedObject((Object)"NLDN", "LGT/NLDN"), new TwoFacedObject((Object)"USPLN", "LGT/USPLN")};
    }

    @Override
    public float getRelativeTimeIncrement() {
        return 0.5f;
    }

    @Override
    protected String getDayTimeSelectString() {
        StringBuffer buf = new StringBuffer();
        if (this.getDoAbsoluteTimes()) {
            buf.append("time ");
            List times = this.getSelectedAbsoluteTimes();
            DateTime dt = (DateTime)times.get(0);
            buf.append(UtcDate.getHMS(dt));
            buf.append(" ");
            dt = (DateTime)times.get(times.size() - 1);
            buf.append(UtcDate.getHMS(dt));
        } else {
            buf.append(this.getRelativeTimeId());
        }
        return buf.toString();
    }

    @Override
    protected String getRelativeTimeId() {
        return "%relative_range%";
    }

    @Override
    protected int getAbsoluteTimeSelectMode() {
        return 1;
    }

    @Override
    public void readTimes() {
        this.clearTimesList();
        ArrayList<DateTime> uniqueTimes = new ArrayList<DateTime>();
        this.setState(1);
        try {
            float hours = this.getRelativeTimeIncrement();
            int numTimes = (int)(24.0f / hours);
            DateTime currentDay = new DateTime(new Date());
            int day = Integer.parseInt(UtcDate.formatUtcDate(currentDay, "yyyyDDD"));
            for (int i = 0; i < numTimes; ++i) {
                int hour = McIDASUtil.mcDoubleToPackedInteger((float)i * hours);
                try {
                    DateTime dt = new DateTime(McIDASUtil.mcDayTimeToSecs(day, hour));
                    uniqueTimes.add(dt);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setState(2);
        }
        catch (Exception excp) {
            this.handleConnectionError(excp);
            return;
        }
        if (this.getDoAbsoluteTimes()) {
            if (!uniqueTimes.isEmpty()) {
                this.setAbsoluteTimes(new ArrayList(uniqueTimes));
            }
            int selectedIndex = this.getAbsoluteTimes().size() - 1;
            this.setSelectedAbsoluteTime(selectedIndex);
        }
    }
}

