/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.AddeSatBands;
import edu.wisc.ssec.mcidas.adde.DataSetInfo;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.BandInfo;
import ucar.unidata.data.imagery.ImageDataset;
import ucar.unidata.idv.IdvResourceManager;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.ui.imagery.ImageSelector;
import ucar.unidata.util.Format;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlNodeList;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.UtcDate;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.data.CalendarDateTimeSet;
import visad.DateTime;
import visad.Set;
import visad.VisADException;

public class AddeImageChooser
extends AddeChooser
implements ImageSelector {
    private static final int SIZE_THRESHOLD = 30;
    private static final String ARCHIVE_TIME_LABEL = "Select Day";
    private Font monoFont = null;
    private static final int DEFAULT_MAG = 0;
    private JComponent descriptorLabel;
    private static final String PLACE_CENTER = "CENTER";
    private static final String PLACE_ULEFT = "ULEFT";
    private static final String PLACE_LLEFT = "LLEFT";
    private static final String PLACE_URIGHT = "URIGHT";
    private static final String PLACE_LRIGHT = "LRIGHT";
    public static final String DESCRIPTOR_TABLE = "DESCRIPTOR_TABLE";
    protected static final String FILE_SATBAND = "SATBAND";
    protected static final String PROP_BAND = "BAND";
    protected static final String PROP_ID = "ID";
    protected static final String PROP_KEY = "key";
    protected static final String PROP_LATLON = "LATLON";
    protected static final String PROP_LINEELE = "LINELE";
    protected static final String PROP_LINELE = "LINELE";
    protected static final String PROP_LOC = "LOC";
    protected static final String PROP_MAG = "MAG";
    protected static final String PROP_NUM = "NUM";
    protected static final String PROP_PLACE = "PLACE";
    protected static final String PROP_SIZE = "SIZE";
    protected static final String PROP_SPAC = "SPAC";
    protected static final String PROP_UNIT = "UNIT";
    protected static final String PROP_NAV = "NAV";
    private static final String[] ADVANCED_PROPS = new String[]{"UNIT", "BAND", "PLACE", "LOC", "SIZE", "MAG", "NAV"};
    private static final String[] ADVANCED_LABELS = new String[]{"Data Type:", "Channel:", "Placement:", "Location:", "Image Size:", "Magnification:", "Navigation Type:"};
    protected static final String TAG_DEFAULT = "default";
    protected static final String VALUE_DEFAULT = "default";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_PATTERN = "pattern";
    protected static final String LABEL_SELECT = " -- Select -- ";
    private boolean amSettingProperties = false;
    private Object readTimesTask;
    protected String archiveDay = null;
    private PreferenceList descList;
    private JPanel propPanel;
    private JComponent archiveDayComponent;
    private JLabel archiveDayLabel;
    private Hashtable propToComps = new Hashtable();
    private List resourceMaps;
    private XmlResourceCollection addeDefaults;
    private String centerPoint;
    private SimpleDateFormat archiveDayFormatter;
    protected ArrayList compsThatNeedDescriptor = new ArrayList();
    protected JComboBox descriptorComboBox;
    private boolean ignoreDescriptorChange = false;
    protected String[] descriptorNames;
    protected LatLonWidget latLonWidget;
    JSlider lineMagSlider;
    JLabel lineMagLbl;
    JSlider elementMagSlider;
    JLabel elementMagLbl;
    JLabel propertiesLabel;
    private double baseNumLines = 0.0;
    JLabel sizeLbl;
    private double baseNumElements = 0.0;
    JTextField numElementsFld;
    JTextField numLinesFld;
    protected JTextField centerLineFld;
    protected JTextField centerElementFld;
    private JToggleButton lockBtn;
    private JButton fullResBtn;
    private JLabel centerLineLbl;
    private JLabel centerElementLbl;
    private JLabel centerLatLbl;
    private JLabel centerLonLbl;
    int MAX_BANDS = 100;
    AreaDirectory lastAD;
    AreaDirectory propertiesAD;
    AreaDirectory prevPropertiesAD;
    protected Hashtable descriptorTable;
    protected Hashtable bandTable;
    protected Hashtable bandDirs;
    private Vector imageDescriptors;
    private static final int MAX_SIZE = 700;
    protected JComboBox unitComboBox;
    private JLabel placeLbl;
    private String place;
    private GuiUtils.CardLayoutPanel locationPanel;
    protected JComboBox navComboBox;
    private Hashtable sensorToBandToName;
    private boolean useSatBandInfo = true;
    private AddeSatBands satBandInfo;
    protected JComboBox bandComboBox;
    private static final String ALL = "ALL";
    private static final TwoFacedObject ALLBANDS = new TwoFacedObject((Object)"All Bands", "ALL");
    private static final TwoFacedObject ALLUNITS = new TwoFacedObject((Object)"All Types", "ALL");
    private int currentTimestep = 0;
    private double linesToElements = 1.0;
    private static final int SLIDER_MAX = 29;
    private List<BandInfo> bandInfos;
    private Object MUTEX = new Object();

    public AddeImageChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.addeDefaults = this.getImageDefaults();
    }

    protected XmlResourceCollection getImageDefaults() {
        return this.getIdv().getResourceManager().getXmlResources(IdvResourceManager.RSC_IMAGEDEFAULTS);
    }

    @Override
    protected String[] getButtonLabels() {
        return new String[]{this.getLoadCommandName(), GuiUtils.CMD_UPDATE, GuiUtils.CMD_HELP};
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        if (this.getDoAbsoluteTimes()) {
            this.setPropertiesState(this.getASelectedTime());
        } else {
            this.setPropertiesState(this.lastAD);
        }
        if (this.getState() != 2) {
            this.setDescriptors(null);
            return;
        }
        if (!this.haveDescriptorSelected()) {
            if (!this.usingStations() || this.haveStationSelected()) {
                String name = this.getDescriptorLabel().toLowerCase();
                if (StringUtil.startsWithVowel(name)) {
                    this.setStatus("Please select an " + name, "imagetype");
                } else {
                    this.setStatus("Please select a " + name, "imagetype");
                }
            }
        } else if (this.readTimesTask != null) {
            if (this.taskOk(this.readTimesTask)) {
                this.setStatus("Reading available times from server");
            }
        } else if (this.getDoAbsoluteTimes() && !this.haveTimeSelected()) {
            this.setStatus("Please select one or more times");
        }
        this.enableWidgets();
    }

    protected boolean timesOk() {
        if (this.getDoAbsoluteTimes() && !this.haveTimeSelected()) {
            return false;
        }
        return this.lastAD != null;
    }

    protected String[] getAdvancedProps() {
        return ADVANCED_PROPS;
    }

    protected String[] getAdvancedLabels() {
        return ADVANCED_LABELS;
    }

    @Override
    public void logException(String msg, Exception exc) {
        LogUtil.logException(msg, exc);
    }

    @Override
    public String getDataName() {
        return "Image Data";
    }

    public String getDescriptorLabel() {
        return "Image Type";
    }

    public String getDatasetName() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSelectedDescriptor());
        if (this.bandComboBox != null && this.bandComboBox.getItemCount() > 1) {
            buf.append(" (");
            buf.append(this.bandComboBox.getSelectedItem());
            buf.append(")");
        }
        return buf.toString();
    }

    protected boolean canReadTimes() {
        return this.haveDescriptorSelected();
    }

    protected void descriptorChanged() {
        this.readTimes();
        this.updateStatus();
    }

    protected boolean haveDescriptorSelected() {
        if (!GuiUtils.anySelected(this.descriptorComboBox)) {
            return false;
        }
        return this.getDescriptor() != null;
    }

    @Override
    public void handleConnect() throws Exception {
        this.setState(1);
        this.connectToServer();
        this.updateStatus();
    }

    @Override
    public void handleUpdate() throws Exception {
        if (this.getState() != 2) {
            this.handleConnect();
        } else {
            this.descriptorChanged();
        }
    }

    @Override
    protected void clearTimesList() {
        this.lastAD = null;
        super.clearTimesList();
    }

    public void showGroups() {
        List groups = this.readGroups();
        if (groups == null || groups.size() == 0) {
            LogUtil.userMessage("No public datasets found on " + this.getServer());
            return;
        }
        final JDialog dialog = GuiUtils.createDialog("Server Groups", true);
        final String[] selected = new String[]{null};
        ArrayList<JButton> comps = new ArrayList<JButton>();
        for (int i = 0; i < groups.size(); ++i) {
            final String group = groups.get(i).toString();
            JButton btn = new JButton(group);
            comps.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    selected[0] = group;
                    dialog.dispose();
                }
            });
        }
        JButton closeBtn = new JButton("Close");
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        JComponent buttons = GuiUtils.vbox(comps);
        buttons = new JScrollPane(GuiUtils.vbox(comps));
        int xsize = ((JComponent)comps.get((int)0)).getPreferredSize().width;
        buttons.setPreferredSize(new Dimension(xsize + 50, 150));
        JPanel top = GuiUtils.inset((Component)new JLabel("Available data sets on server: " + this.getServer()), 5);
        JPanel bottom = GuiUtils.inset((Component)closeBtn, 5);
        JPanel contents = GuiUtils.topCenterBottom(top, buttons, GuiUtils.wrap(bottom));
        dialog.setLocation(200, 200);
        dialog.getContentPane().add(contents);
        dialog.pack();
        dialog.setVisible(true);
        if (selected[0] != null) {
            this.groupSelector.setSelectedItem(selected[0]);
            this.doConnect();
        }
    }

    public void getArchiveDay() {
        final JDialog dialog = GuiUtils.createDialog("Set Archive Day", true);
        final DateTimePicker dtp = new DateTimePicker((Date)null, false);
        if (this.archiveDay != null) {
            if (this.archiveDayFormatter == null) {
                this.archiveDayFormatter = new SimpleDateFormat("yyyy-MM-dd");
            }
            Date d = null;
            try {
                d = this.archiveDayFormatter.parse(this.archiveDay);
                dtp.setDate(d);
            }
            catch (Exception e) {
                this.logException("parsing archive day " + this.archiveDay, e);
            }
        }
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String cmd = ae.getActionCommand();
                if (cmd.equals(GuiUtils.CMD_REMOVE)) {
                    AddeImageChooser.this.archiveDay = null;
                    AddeImageChooser.this.archiveDayLabel.setText(AddeImageChooser.ARCHIVE_TIME_LABEL);
                    AddeImageChooser.this.setDoAbsoluteTimes(true);
                    AddeImageChooser.this.descriptorChanged();
                }
                if (cmd.equals(GuiUtils.CMD_OK)) {
                    try {
                        DateTime dt = new DateTime(dtp.getDate());
                        AddeImageChooser.this.archiveDay = UtcDate.getYMD(dt);
                        AddeImageChooser.this.archiveDayLabel.setText(AddeImageChooser.this.archiveDay);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    AddeImageChooser.this.setDoAbsoluteTimes(true);
                    AddeImageChooser.this.descriptorChanged();
                }
                dialog.dispose();
            }
        };
        JPanel buttons = GuiUtils.makeButtons(listener, new String[]{GuiUtils.CMD_OK, GuiUtils.CMD_REMOVE, GuiUtils.CMD_CANCEL});
        JPanel contents = GuiUtils.topCenterBottom(GuiUtils.inset((Component)GuiUtils.lLabel("Please select a day for this dataset:"), 10), GuiUtils.inset((Component)dtp, 10), buttons);
        Point p = new Point(200, 200);
        if (this.archiveDayComponent != null) {
            try {
                p = this.archiveDayComponent.getLocationOnScreen();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        dialog.setLocation(p);
        dialog.getContentPane().add(contents);
        dialog.pack();
        dialog.setVisible(true);
    }

    protected void connectToServer() {
        this.setDescriptors(null);
        this.archiveDay = null;
        if (this.archiveDayLabel != null) {
            this.archiveDayLabel.setText(ARCHIVE_TIME_LABEL);
        }
        this.setDoAbsoluteTimes(false);
        if (!this.canAccessServer()) {
            return;
        }
        this.readSatBands();
        this.readDescriptors();
        this.readTimes();
        this.saveServerState();
        this.ignoreStateChangedEvents = true;
        if (this.descList != null) {
            this.descList.saveState(this.groupSelector);
        }
        this.ignoreStateChangedEvents = false;
    }

    @Override
    public boolean canDoCancel() {
        return true;
    }

    @Override
    protected JComponent doMakeContents() {
        List allComps = this.processServerComponents();
        this.getComponents(allComps);
        allComps.addAll(this.processPropertyComponents());
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel imagePanel = GuiUtils.doLayout(allComps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        return GuiUtils.top(GuiUtils.centerBottom(imagePanel, this.getDefaultButtons(this)));
    }

    protected List processServerComponents() {
        if (this.groupSelector != null) {
            this.clearOnChange(this.groupSelector);
        }
        this.descriptorLabel = this.addServerComp(GuiUtils.rLabel(this.getDescriptorLabel() + ":"));
        this.descriptorComboBox = new JComboBox();
        this.descriptorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AddeImageChooser.this.ignoreDescriptorChange) {
                    if (e.getStateChange() == 1) {
                        AddeImageChooser.this.descriptorChanged();
                    }
                }
            }
        });
        JButton showBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/About16.gif", this, "showGroups", null, true);
        showBtn.setToolTipText("List the public datasets available on the server");
        JPanel extraTop = GuiUtils.hbox(this.groupSelector, showBtn);
        ArrayList comps = new ArrayList();
        this.addTopComponents(comps, "Dataset:", extraTop);
        return comps;
    }

    protected List processPropertyComponents() {
        ArrayList<JComponent> bottomComps = new ArrayList<JComponent>();
        this.getBottomComponents(bottomComps);
        if (this.getSimpleMode()) {
            bottomComps = new ArrayList();
            bottomComps.add(GuiUtils.rLabel("Properties:"));
            this.propertiesLabel = GuiUtils.lLabel(" ");
            JButton editButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Edit16.gif", this, "showPropPanel", null, true);
            editButton.setToolTipText("Click to edit properties");
            bottomComps.add(GuiUtils.leftCenter(editButton, this.propertiesLabel));
        }
        for (int i = 0; i < bottomComps.size(); ++i) {
            this.addDescComp((JComponent)bottomComps.get(i));
        }
        return bottomComps;
    }

    public boolean showAdvancedInTab() {
        return true;
    }

    public void showSettings(JComponent holder) {
        if (holder instanceof JTabbedPane) {
            ((JTabbedPane)holder).setSelectedIndex(0);
        } else {
            CardLayout cardLayout = (CardLayout)holder.getLayout();
            cardLayout.show(holder, "settings");
        }
    }

    public void showAdvanced(JComponent holder) {
        if (holder instanceof JTabbedPane) {
            ((JTabbedPane)holder).setSelectedIndex(1);
        } else {
            CardLayout cardLayout = (CardLayout)holder.getLayout();
            cardLayout.show(holder, "advanced");
        }
    }

    protected void getBottomComponents(List bottomComps) {
        Object[] propArray = this.getAdvancedProps();
        String[] labelArray = this.getAdvancedLabels();
        Insets dfltGridSpacing = new Insets(4, 0, 4, 0);
        String dfltLblSpacing = " ";
        boolean haveBand = Misc.toList(propArray).contains(PROP_BAND);
        boolean haveNav = Misc.toList(propArray).contains(PROP_NAV);
        for (int propIdx = 0; propIdx < propArray.length; ++propIdx) {
            JComponent propComp = null;
            Object prop = propArray[propIdx];
            if (((String)prop).equals(PROP_UNIT)) {
                this.unitComboBox = new JComboBox();
                propComp = this.unitComboBox;
                this.addPropComp(PROP_UNIT, propComp);
                GuiUtils.setPreferredWidth(this.unitComboBox, 100);
                if (haveBand) {
                    this.bandComboBox = new JComboBox();
                    this.bandComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddeImageChooser.this.setAvailableUnits(AddeImageChooser.this.propertiesAD, AddeImageChooser.this.getSelectedBand());
                        }
                    });
                    this.addPropComp(PROP_BAND, this.bandComboBox);
                    propComp = GuiUtils.hbox((Component)propComp, (Component)this.padLabel("Channel:"), (Component)this.bandComboBox, 5);
                }
            } else if (!((String)prop).equals(PROP_BAND) && !((String)prop).equals(PROP_PLACE)) {
                if (((String)prop).equals(PROP_LOC)) {
                    this.placeLbl = GuiUtils.getFixedWidthLabel("");
                    this.changePlace(PLACE_CENTER);
                    this.addPropComp(PROP_PLACE, this.placeLbl);
                    this.latLonWidget = new LatLonWidget();
                    this.centerLineFld = new JTextField("", 3);
                    this.centerElementFld = new JTextField("", 3);
                    this.fullResBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/arrow_out.png", this, "setToFullResolution");
                    this.fullResBtn.setContentAreaFilled(false);
                    this.fullResBtn.setToolTipText("Set to full resolution");
                    final JButton centerPopupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/MapIcon16.png", this.getClass());
                    centerPopupBtn.setToolTipText("Center on current displays");
                    centerPopupBtn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            AddeImageChooser.this.getIdv().getIdvUIManager().popupCenterMenu(centerPopupBtn, AddeImageChooser.this.latLonWidget);
                        }
                    });
                    JPanel centerPopup = GuiUtils.inset((Component)centerPopupBtn, new Insets(0, 0, 0, 4));
                    GuiUtils.tmpInsets = dfltGridSpacing;
                    Component[] componentArray = new Component[6];
                    this.centerLatLbl = GuiUtils.rLabel(" Lat:" + dfltLblSpacing);
                    componentArray[0] = this.centerLatLbl;
                    componentArray[1] = this.latLonWidget.getLatField();
                    this.centerLonLbl = GuiUtils.rLabel(" Lon:" + dfltLblSpacing);
                    componentArray[2] = this.centerLonLbl;
                    componentArray[3] = this.latLonWidget.getLonField();
                    componentArray[4] = new JLabel(" ");
                    componentArray[5] = centerPopup;
                    JPanel latLonPanel = GuiUtils.hbox(componentArray);
                    Component[] componentArray2 = new Component[4];
                    this.centerLineLbl = GuiUtils.rLabel(" Line:" + dfltLblSpacing);
                    componentArray2[0] = this.centerLineLbl;
                    componentArray2[1] = this.centerLineFld;
                    this.centerElementLbl = GuiUtils.rLabel(" Element:" + dfltLblSpacing);
                    componentArray2[2] = this.centerElementLbl;
                    componentArray2[3] = this.centerElementFld;
                    JPanel lineElementPanel = GuiUtils.hbox(componentArray2);
                    this.locationPanel = new GuiUtils.CardLayoutPanel();
                    this.locationPanel.addCard(latLonPanel);
                    this.locationPanel.addCard(lineElementPanel);
                    JButton locPosButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Refresh16.gif", this, "cyclePlace", null, true);
                    locPosButton.setToolTipText("Change place type");
                    JButton locTypeButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Refresh16.gif", this.locationPanel, "flip", null, true);
                    locTypeButton.setToolTipText("Toggle between Latitude/Longitude and Line/Element");
                    propComp = GuiUtils.hbox(new Component[]{locPosButton, this.placeLbl, locTypeButton, this.locationPanel}, 5);
                    this.addPropComp(PROP_LOC, propComp);
                } else if (((String)prop).equals(PROP_MAG)) {
                    boolean oldAmSettingProperties = this.amSettingProperties;
                    this.amSettingProperties = true;
                    ChangeListener lineListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent evt) {
                            if (AddeImageChooser.this.amSettingProperties) {
                                return;
                            }
                            AddeImageChooser.this.lineMagSliderChanged(!AddeImageChooser.this.getLockButton().isSelected());
                        }
                    };
                    ChangeListener elementListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent evt) {
                            if (AddeImageChooser.this.amSettingProperties) {
                                return;
                            }
                            AddeImageChooser.this.elementMagSliderChanged(true);
                        }
                    };
                    JComponent[] lineMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, lineListener);
                    this.lineMagSlider = (JSlider)lineMagComps[1];
                    this.lineMagSlider.setMajorTickSpacing(1);
                    this.lineMagSlider.setSnapToTicks(true);
                    this.lineMagSlider.setExtent(1);
                    lineMagComps[0].setToolTipText("Change the line magnification");
                    JComponent[] elementMagComps = GuiUtils.makeSliderPopup(-29, 1, 0, elementListener);
                    this.elementMagSlider = (JSlider)elementMagComps[1];
                    this.elementMagSlider.setExtent(1);
                    this.elementMagSlider.setMajorTickSpacing(1);
                    this.elementMagSlider.setSnapToTicks(true);
                    elementMagComps[0].setToolTipText("Change the element magnification");
                    this.lineMagSlider.setToolTipText("Slide to set line magnification factor");
                    this.lineMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft("1", 3));
                    this.elementMagSlider.setToolTipText("Slide to set element magnification factor");
                    this.elementMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft("1", 3));
                    this.amSettingProperties = oldAmSettingProperties;
                    GuiUtils.tmpInsets = new Insets(0, 0, 0, 0);
                    JPanel magPanel = GuiUtils.doLayout(new Component[]{this.lineMagLbl, GuiUtils.inset((Component)lineMagComps[0], new Insets(0, 4, 0, 0)), new JLabel("    X"), this.elementMagLbl, GuiUtils.inset((Component)elementMagComps[0], new Insets(0, 4, 0, 0)), GuiUtils.inset((Component)this.getLockButton(), new Insets(0, 10, 0, 0))}, 7, GuiUtils.WT_N, GuiUtils.WT_N);
                    propComp = magPanel;
                    this.addPropComp(PROP_MAG, propComp);
                    if (haveNav) {
                        this.navComboBox = new JComboBox();
                        GuiUtils.setListData(this.navComboBox, Misc.newList(new TwoFacedObject((Object)"Default", "X"), new TwoFacedObject((Object)"Lat/Lon", "LALO")));
                        this.addPropComp(PROP_NAV, this.navComboBox);
                        boolean showNav = false;
                        showNav = this.getProperty("includeNavComp", false);
                        if (showNav) {
                            propComp = GuiUtils.hbox((Component)propComp, (Component)GuiUtils.inset((Component)new JLabel("Navigation Type:"), new Insets(0, 10, 0, 5)), (Component)this.navComboBox, 5);
                        }
                    }
                } else if (((String)prop).equals(PROP_SIZE)) {
                    this.numLinesFld = new JTextField("", 4);
                    this.numElementsFld = new JTextField("", 4);
                    this.numLinesFld.setToolTipText("Number of lines");
                    this.numElementsFld.setToolTipText("Number of elements");
                    GuiUtils.tmpInsets = dfltGridSpacing;
                    this.sizeLbl = GuiUtils.lLabel("");
                    JPanel sizePanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.numLinesFld, new JLabel(" X "), this.numElementsFld, GuiUtils.filler(10, 1), this.fullResBtn, this.sizeLbl}, 7, GuiUtils.WT_N, GuiUtils.WT_N));
                    propComp = sizePanel;
                    this.addPropComp(PROP_SIZE, propComp);
                }
            }
            if (propComp == null || propIdx != 5) continue;
            this.navComboBox.setToolTipText("choose LALO if you are using Level 1B or POES ADDE servers");
            bottomComps.add(GuiUtils.rLabel(labelArray[propIdx + 1]));
            bottomComps.add(GuiUtils.left(this.navComboBox));
        }
        GuiUtils.tmpInsets = new Insets(3, 4, 0, 4);
        this.propPanel = GuiUtils.doLayout(bottomComps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
        this.enableWidgets();
    }

    private JToggleButton getLockButton() {
        if (this.lockBtn == null) {
            this.lockBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link.png", "/auxdata/ui/icons/link_break.png", 0, 0, true);
            this.lockBtn.setContentAreaFilled(false);
            this.lockBtn.setSelected(true);
            this.lockBtn.setToolTipText("Unlock to automatically change size when changing magnification");
        }
        return this.lockBtn;
    }

    public void setToFullResolution() {
        if (this.propertiesAD == null) {
            return;
        }
        this.amSettingProperties = true;
        this.numLinesFld.setText("" + this.propertiesAD.getLines());
        this.numElementsFld.setText("" + this.propertiesAD.getElements());
        this.changePlace(PLACE_CENTER);
        if (this.useLatLon()) {
            this.locationPanel.flip();
        }
        this.centerLineFld.setText("" + (this.propertiesAD.getLines() / 2 - 1));
        this.centerElementFld.setText("" + (this.propertiesAD.getElements() / 2 - 1));
        this.setMagSliders(1, 1);
        this.amSettingProperties = false;
    }

    public void cyclePlace() {
        if (this.place.equals(PLACE_CENTER)) {
            this.changePlace(PLACE_ULEFT);
        } else {
            this.changePlace(PLACE_CENTER);
        }
    }

    public void changePlace(String newPlace) {
        this.place = newPlace;
        String s = this.translatePlace(this.place) + "=";
        this.placeLbl.setText(StringUtil.padRight(s, 12));
    }

    private void elementMagSliderChanged(boolean recomputeLineEleRatio) {
        int value = this.getElementMagValue();
        if (Math.abs(value) < 29) {
            int lineMag = this.getLineMagValue();
            this.linesToElements = lineMag > value ? Math.abs((double)lineMag / (double)value) : Math.abs((double)value / (double)lineMag);
        }
        this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
        if (!this.getLockButton().isSelected()) {
            if (value > 0) {
                this.numElementsFld.setText("" + (int)(this.baseNumElements * (double)value));
            } else {
                this.numElementsFld.setText("" + (int)(this.baseNumElements / (double)(-value)));
            }
        }
    }

    private void lineMagSliderChanged(boolean autoSetSize) {
        try {
            int value = this.getLineMagValue();
            this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
            if (autoSetSize) {
                if (value > 0) {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines * (double)value));
                } else {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines / (double)(-value)));
                }
            }
            value = value == 1 ? (this.linesToElements < 1.0 ? (int)((double)(-value) / this.linesToElements) : (int)((double)value * this.linesToElements)) : (value > 1 ? (int)((double)value * this.linesToElements) : (int)((double)value / this.linesToElements));
            value = value > 0 ? value - 1 : value + 1;
            this.amSettingProperties = true;
            this.elementMagSlider.setValue(value);
            this.amSettingProperties = false;
            this.elementMagSliderChanged(false);
        }
        catch (Exception exc) {
            this.logException("Setting line magnification", exc);
        }
    }

    public void showPropPanel() {
        int ok = GuiUtils.makeDialog(null, "Properties", this.propPanel, null, new String[]{GuiUtils.CMD_APPLY, GuiUtils.CMD_CANCEL});
        if (ok != 0) {
            this.setPropertiesState(this.propertiesAD, true);
        }
        this.updatePropertiesLabel();
    }

    private int getLineMagValue() {
        return this.getMagValue(this.lineMagSlider);
    }

    private int getElementMagValue() {
        return this.getMagValue(this.elementMagSlider);
    }

    @Override
    protected void absoluteTimesSelectionChanged() {
        if (!this.getDoAbsoluteTimes()) {
            return;
        }
        if (this.getIdv().getProperty("idv.chooser.addeimage.updateontimechange", true)) {
            this.setPropertiesState(this.getASelectedTime(), false);
        }
    }

    protected void getComponents(List comps) {
        comps.add(this.descriptorLabel);
        comps.add(GuiUtils.left(this.registerStatusComp("imagetype", this.descriptorComboBox)));
        this.addTimesComponent(comps);
    }

    protected void addTimesComponent(List comps) {
        comps.add(this.addServerComp(GuiUtils.valignLabel("Times:")));
        comps.add(this.addServerComp(this.makeTimesPanel(true)));
    }

    @Override
    protected JComponent getExtraAbsoluteTimeComponent() {
        JButton archiveDayBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/Archive.gif", this, "getArchiveDay", null, true);
        archiveDayBtn.setToolTipText("Select a day for archive datasets");
        this.archiveDayLabel = new JLabel(ARCHIVE_TIME_LABEL);
        this.archiveDayComponent = GuiUtils.hbox(this.archiveDayLabel, archiveDayBtn);
        return GuiUtils.right(this.archiveDayComponent);
    }

    protected JComponent addPropComp(String propId, JComponent comp) {
        Object oldComp = this.propToComps.get(propId);
        if (oldComp != null) {
            throw new IllegalStateException("Already have a component defined:" + propId);
        }
        this.propToComps.put(propId, comp);
        return comp;
    }

    protected boolean usePropFromUser(String propId) {
        return this.propToComps.get(propId) != null;
    }

    protected JComponent addDescComp(JComponent comp) {
        this.compsThatNeedDescriptor.add(comp);
        return comp;
    }

    protected AreaDirectory getASelectedTime() {
        AddeImageDescriptor aid;
        List selected;
        if (this.haveTimeSelected() && (selected = this.getSelectedAbsoluteTimes()).size() > 0 && (aid = (AddeImageDescriptor)selected.get(0)) != null) {
            return aid.getDirectory();
        }
        return null;
    }

    @Override
    protected int getDefaultRelativeTimeIndex() {
        return 4;
    }

    protected boolean isPolar(AddeImageDescriptor aid) {
        String sourceType = aid.getDirectory().getSourceType();
        return sourceType.startsWith("MOD") || sourceType.equals("AMSU") || sourceType.equals("AVHR") || sourceType.equals("AVH3") || sourceType.equals("TIRO") || sourceType.equals("HIR3");
    }

    @Override
    protected void enableWidgets() {
        boolean descriptorState;
        boolean bl = descriptorState = this.getState() == 2 && this.canReadTimes();
        if (this.drivercbx != null) {
            this.drivercbx.setSelected(false);
            this.enableTimeWidgets();
        }
        boolean isPolar = false;
        if (this.imageDescriptors != null) {
            isPolar = this.isPolar((AddeImageDescriptor)this.imageDescriptors.get(0));
        }
        for (int i = 0; i < this.compsThatNeedDescriptor.size(); ++i) {
            JComponent comp = (JComponent)this.compsThatNeedDescriptor.get(i);
            GuiUtils.enableTree(comp, isPolar);
            if (isPolar) {
                this.navComboBox.setSelectedIndex(1);
                continue;
            }
            this.navComboBox.setSelectedIndex(0);
        }
        boolean timesOk = this.timesOk();
        if (this.propPanel != null) {
            GuiUtils.enableTree(this.propPanel, timesOk);
        }
        String[] propArray = this.getAdvancedProps();
        String[] labelArray = this.getAdvancedLabels();
        if (timesOk) {
            this.checkCenterEnabled();
        }
        this.checkTimesLists();
        this.enableAbsoluteTimesList(this.getDoAbsoluteTimes() && descriptorState);
        this.getRelativeTimesChooser().setEnabled(!this.getDoAbsoluteTimes() && descriptorState);
        if (this.archiveDayComponent != null) {
            GuiUtils.enableTree(this.archiveDayComponent, this.getDoAbsoluteTimes());
        }
        this.revalidate();
    }

    private boolean useLatLon() {
        return this.locationPanel.getVisibleIndex() == 0;
    }

    private void checkCenterEnabled() {
    }

    protected String getDescriptor() {
        return this.getDescriptorFromSelection(this.getSelectedDescriptor());
    }

    protected String getDescriptorFromSelection(String selection) {
        if (this.descriptorTable == null) {
            return null;
        }
        if (selection == null) {
            return null;
        }
        return (String)this.descriptorTable.get(selection);
    }

    public String getSelectedDescriptor() {
        String selection = (String)this.descriptorComboBox.getSelectedItem();
        if (selection == null) {
            return null;
        }
        if (selection.equals(LABEL_SELECT)) {
            return null;
        }
        return selection;
    }

    protected String getSelectedUnit() {
        String selection = (String)((TwoFacedObject)this.unitComboBox.getSelectedItem()).getId();
        return selection;
    }

    @Override
    public String getDataType() {
        return "IMAGE";
    }

    public String getDatasetDescription() {
        return this.getDatasetName();
    }

    @Override
    public void readTimes() {
        this.clearTimesList();
        if (!this.canReadTimes()) {
            return;
        }
        Misc.run(new Runnable(){

            @Override
            public void run() {
                AddeImageChooser.this.updateStatus();
                AddeImageChooser.this.showWaitCursor();
                try {
                    AddeImageChooser.this.readTimesInner();
                }
                catch (Exception e) {
                    AddeImageChooser.this.handleConnectionError(e);
                }
                AddeImageChooser.this.showNormalCursor();
                AddeImageChooser.this.updateStatus();
            }
        });
    }

    @Override
    public void doCancel() {
        this.readTimesTask = null;
        this.setState(0);
        super.doCancel();
    }

    private void readTimesInner() {
        String descriptor = this.getDescriptor();
        String pos = this.getDoAbsoluteTimes() || this.archiveDay != null ? "all" : "0";
        StringBuffer addeCmdBuff = this.getGroupUrl("imagedir", this.getGroup());
        String id = this.getSelectedStation();
        if (id != null) {
            this.appendKeyValue(addeCmdBuff, PROP_ID, id);
        }
        this.appendKeyValue(addeCmdBuff, "descr", descriptor);
        this.appendKeyValue(addeCmdBuff, "pos", "" + pos);
        if (this.archiveDay != null) {
            this.appendKeyValue(addeCmdBuff, "DAY", this.archiveDay);
        }
        this.loadImages(addeCmdBuff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImages(String url) {
        this.readTimesTask = this.startTask();
        this.updateStatus();
        Object task = this.readTimesTask;
        try {
            AreaDirectoryList adir = new AreaDirectoryList(url);
            boolean ok = this.stopTaskAndIsOk(task);
            if (!Misc.equals(this.readTimesTask, task) || !ok) {
                return;
            }
            this.readTimesTask = null;
            Object object = this.MUTEX;
            synchronized (object) {
                int i;
                AreaDirectory[][] dirs = adir.getSortedDirs();
                int numImages = dirs.length;
                this.imageDescriptors = new Vector();
                this.bandTable = new Hashtable(numImages);
                this.bandDirs = new Hashtable();
                int len = dirs[0].length;
                this.bandDirs = new Hashtable(len);
                for (i = 0; i < len; ++i) {
                    AreaDirectory dir = dirs[0][i];
                    int ilen = dirs[0][i].getBands().length;
                    for (int j = 0; j < ilen; ++j) {
                        int bindex = dirs[0][i].getBands()[j];
                        this.bandDirs.put(bindex, dir);
                    }
                }
                this.lastAD = null;
                for (i = 0; i < numImages; ++i) {
                    int bandIndex = 0;
                    this.lastAD = dirs[i][0];
                    int[] allBands = new int[this.MAX_BANDS];
                    Vector[] allCals = new Vector[this.MAX_BANDS];
                    for (int j = 0; j < dirs[i].length; ++j) {
                        int nbands = dirs[i][j].getNumberOfBands();
                        int[] abands = dirs[i][j].getBands();
                        Vector[] vb = dirs[i][j].getCalInfo();
                        for (int k = 0; k < nbands; ++k) {
                            allBands[bandIndex] = abands[k];
                            allCals[bandIndex++] = vb[k];
                        }
                    }
                    int[] bands = new int[bandIndex];
                    System.arraycopy(allBands, 0, bands, 0, bandIndex);
                    Vector[] cals = new Vector[bandIndex];
                    System.arraycopy(allCals, 0, cals, 0, bandIndex);
                    this.lastAD.setCalInfo(cals);
                    this.bandTable.put(this.lastAD, bands);
                    AddeImageDescriptor aid = new AddeImageDescriptor(this.lastAD, null);
                    this.imageDescriptors.add(aid);
                }
                Collections.sort(this.imageDescriptors);
                if (this.getDoAbsoluteTimes()) {
                    this.setAbsoluteTimes(this.imageDescriptors);
                }
            }
            this.setState(2);
        }
        catch (McIDASException e) {
            this.stopTask(task);
            this.readTimesTask = null;
            this.handleConnectionError(e);
        }
    }

    @Override
    protected void setSelectedTimes(DateTime[] times) {
        if (times == null || times.length == 0) {
            return;
        }
        ArrayList selectedIndices = new ArrayList();
        DateTime[] imageTimes = new DateTime[this.imageDescriptors.size()];
        for (int idIdx = 0; idIdx < this.imageDescriptors.size(); ++idIdx) {
            AddeImageDescriptor aid = (AddeImageDescriptor)this.imageDescriptors.get(idIdx);
            imageTimes[idIdx] = aid.getImageTime();
        }
        if (imageTimes.length > 0) {
            try {
                CalendarDateTimeSet imageSet = CalendarDateTime.makeTimeSet(imageTimes);
                int numTimes = times.length;
                double[][] timesValues = new double[1][numTimes];
                for (int i = 0; i < times.length; ++i) {
                    timesValues[0][i] = times[i].getValue(imageSet.getSetUnits()[0]);
                }
                this.setSelectedAbsoluteTimes(((Set)imageSet).doubleToIndex(timesValues));
            }
            catch (VisADException ve) {
                this.logException("Unable to set times from display", ve);
            }
        }
    }

    private void resetDescriptorBox() {
        this.ignoreDescriptorChange = true;
        this.descriptorComboBox.setSelectedItem(LABEL_SELECT);
        this.ignoreDescriptorChange = false;
    }

    private void setCenterLocation(AddeImageDescriptor aid) {
        String latPoint = "";
        String lonPoint = "";
        if (aid != null) {
            AreaDirectory ad = aid.getDirectory();
            latPoint = "" + ad.getCenterLatitude();
            lonPoint = "" + ad.getCenterLongitude();
        }
        if (!latPoint.trim().equals("")) {
            this.latLonWidget.setLat(latPoint);
        }
        if (!lonPoint.trim().equals("")) {
            this.latLonWidget.setLon(lonPoint);
        }
    }

    @Override
    protected boolean getGoodToGo() {
        if (this.getDoAbsoluteTimes()) {
            return this.getHaveAbsoluteTimesSelected();
        }
        return this.canReadTimes() && this.lastAD != null;
    }

    private void readDescriptors() {
        try {
            StringBuffer buff = this.getGroupUrl("datasetinfo", this.getGroup());
            DataSetInfo dsinfo = new DataSetInfo(buff.toString());
            this.descriptorTable = dsinfo.getDescriptionTable();
            Object[] names = new String[this.descriptorTable.size()];
            Enumeration enumeration = this.descriptorTable.keys();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                names[i] = enumeration.nextElement().toString();
                ++i;
            }
            Arrays.sort(names);
            this.setDescriptors((String[])names);
            this.setState(2);
        }
        catch (Exception e) {
            this.handleConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescriptors(String[] names) {
        Object object = this.WIDGET_MUTEX;
        synchronized (object) {
            this.ignoreDescriptorChange = true;
            this.descriptorComboBox.removeAllItems();
            this.descriptorNames = names;
            if (names == null || names.length == 0) {
                return;
            }
            this.descriptorComboBox.addItem(LABEL_SELECT);
            for (int j = 0; j < names.length; ++j) {
                this.descriptorComboBox.addItem(names[j]);
            }
            this.ignoreDescriptorChange = false;
        }
    }

    @Override
    public List getImageList() {
        if (!this.timesOk()) {
            return null;
        }
        ArrayList<AddeImageDescriptor> images = new ArrayList<AddeImageDescriptor>();
        try {
            if (this.getDoRelativeTimes()) {
                AddeImageDescriptor firstDescriptor = (AddeImageDescriptor)this.imageDescriptors.get(0);
                int[] relativeTimesIndices = this.getRelativeTimeIndices();
                for (int i = 0; i < relativeTimesIndices.length; ++i) {
                    AddeImageDescriptor aid = new AddeImageDescriptor(relativeTimesIndices[i], firstDescriptor);
                    AddeImageInfo aii = this.makeImageInfo(aid.getDirectory(), true, relativeTimesIndices[i]);
                    aid.setImageInfo(aii);
                    aid.setSource(aii.getURLString());
                    images.add(aid);
                }
            } else {
                List selectedTimes = this.getSelectedAbsoluteTimes();
                for (int i = 0; i < selectedTimes.size(); ++i) {
                    AddeImageDescriptor aid = new AddeImageDescriptor((AddeImageDescriptor)selectedTimes.get(i));
                    AddeImageInfo aii = this.makeImageInfo(aid.getDirectory(), false, i);
                    aid.setImageInfo(aii);
                    aid.setSource(aii.getURLString());
                    images.add(aid);
                }
            }
        }
        catch (Exception exc) {
            this.logException("Error occured", exc);
            return null;
        }
        return images;
    }

    protected String makeDateTimeString(AreaDirectory ad, int cnt, boolean doTimes) {
        if (!doTimes) {
            return "&POS=" + (cnt == 0 ? cnt : -cnt);
        }
        return this.makeDateTimeString(ad);
    }

    protected String makeDateTimeString(AreaDirectory ad) {
        try {
            DateTime dt = new DateTime(ad.getNominalTime());
            String jday = UtcDate.getYMD(dt);
            String time = UtcDate.getHMS(dt);
            return "&DAY=" + jday + "&TIME=" + time + " " + time + " I ";
        }
        catch (VisADException ve) {
            return "";
        }
    }

    private void initializeAddeDefaults() {
        this.resourceMaps = new ArrayList();
        if (this.addeDefaults == null) {
            return;
        }
        for (int resourceIdx = 0; resourceIdx < this.addeDefaults.size(); ++resourceIdx) {
            Element root = this.addeDefaults.getRoot(resourceIdx);
            if (root == null) continue;
            Hashtable<String, Element> resourceMap = new Hashtable<String, Element>();
            this.resourceMaps.add(resourceMap);
            XmlNodeList defaultNodes = XmlUtil.getElements(root, "default");
            for (int nodeIdx = 0; nodeIdx < defaultNodes.size(); ++nodeIdx) {
                Element dfltNode = (Element)defaultNodes.item(nodeIdx);
                String pattern = XmlUtil.getAttribute((Node)dfltNode, ATTR_PATTERN, (String)null);
                if (pattern == null) {
                    pattern = XmlUtil.getAttribute(dfltNode, ATTR_NAME);
                }
                if (pattern != null) {
                    pattern = pattern.toLowerCase();
                }
                resourceMap.put(pattern, dfltNode);
            }
        }
    }

    protected String getDefault(String property, String dflt) {
        String[] pair;
        if (this.resourceMaps == null) {
            this.initializeAddeDefaults();
        }
        property = property.toLowerCase();
        Object userDefault = null;
        String server = this.getServer();
        String group = this.getGroup();
        String descriptor = this.getDescriptor();
        String[] keys = new String[]{userDefault, server + ":" + group + "/" + descriptor, group + "/" + descriptor, server + ":" + group + "/*", group + "/*", server + ":*/" + descriptor, "*/" + descriptor, descriptor, server + ":*/*", server, "*"};
        if (server != null && (property.equals("user") || property.equals("proj")) && (pair = (String[])this.passwords.get(server)) != null) {
            if (property.equals("user")) {
                return pair[0];
            }
            return pair[1];
        }
        for (int resourceIdx = 0; resourceIdx < this.resourceMaps.size(); ++resourceIdx) {
            Hashtable resourceMap = (Hashtable)this.resourceMaps.get(resourceIdx);
            for (int keyIdx = 0; keyIdx < keys.length; ++keyIdx) {
                String value;
                Element defaultNode;
                String key = keys[keyIdx];
                if (key == null || (defaultNode = (Element)resourceMap.get(key = key.toLowerCase())) == null || (value = XmlUtil.getAttribute((Node)defaultNode, property, (String)null)) == null) continue;
                if (value.equals("default")) {
                    return dflt;
                }
                return value;
            }
        }
        return dflt;
    }

    @Override
    protected void appendMiscKeyValues(StringBuffer buff) {
        this.appendKeyValue(buff, "compress", this.getPropValue("compress", null));
        this.appendKeyValue(buff, "port", this.getPropValue("port", null));
        this.appendKeyValue(buff, "debug", this.getPropValue("debug", null));
        this.appendKeyValue(buff, "version", this.getPropValue("version", null));
        this.appendKeyValue(buff, "user", this.getPropValue("user", null));
        this.appendKeyValue(buff, "proj", this.getPropValue("proj", null));
    }

    protected String getSizeString(AreaDirectory ad) {
        String retString = "700 700";
        if (ad != null) {
            int x = ad.getElements();
            int y = ad.getLines();
            if (x < 700 && y < 700) {
                retString = x + " " + y;
            } else if (x >= 700 && y >= 700) {
                retString = "700 700";
            } else if (x >= 700 && y < 700) {
                retString = "700 " + y;
            } else if (x < 700 && y >= 700) {
                retString = x + " " + 700;
            }
        }
        return retString;
    }

    protected boolean checkForValidValues() {
        String msg;
        if (this.usePropFromUser(PROP_LOC) && this.useLatLon() && (msg = this.latLonWidget.isValidValues()) != null && msg.length() > 0) {
            LogUtil.userMessage(msg);
            return false;
        }
        return true;
    }

    protected String makeRequestString(AreaDirectory ad) {
        return this.makeRequestString(ad, true, 0);
    }

    protected String makeRequestString(AreaDirectory ad, boolean doTimes, int cnt) {
        StringBuffer buf = this.getGroupUrl("imagedata", this.getGroup());
        buf.append(this.makeDateTimeString(ad, cnt, doTimes));
        if (this.usePropFromUser(PROP_LOC)) {
            if (this.useLatLon()) {
                this.appendKeyValue(buf, PROP_LATLON, this.getUserPropValue(PROP_LATLON, ad));
            } else {
                this.appendKeyValue(buf, "LINELE", this.getUserPropValue("LINELE", ad));
            }
        } else {
            this.appendKeyValue(buf, this.getDefault(PROP_KEY, "LINELE"), this.getPropValue(PROP_LOC, ad));
        }
        String[] props = new String[]{"descr", PROP_SIZE, PROP_UNIT, PROP_SPAC, PROP_BAND, PROP_MAG, PROP_PLACE, PROP_NAV};
        buf.append(this.makeProps(props, ad));
        return buf.toString();
    }

    protected String getBaseUrl(AreaDirectory ad, boolean doTimes, int cnt) {
        StringBuffer buf = this.getGroupUrl("imagedata", this.getGroup());
        buf.append(this.makeDateTimeString(ad, cnt, doTimes));
        buf.append(this.makeProps(this.getBaseUrlProps(), ad));
        return buf.toString();
    }

    protected String[] getBaseUrlProps() {
        return new String[]{"descr", PROP_UNIT, PROP_SPAC, PROP_BAND, PROP_NAV};
    }

    protected String makeProps(String[] props, AreaDirectory ad) {
        StringBuffer buf = new StringBuffer();
        for (int propIdx = 0; propIdx < props.length; ++propIdx) {
            this.appendKeyValue(buf, props[propIdx], this.getPropValue(props[propIdx], ad));
        }
        return buf.toString();
    }

    protected String getPropValue(String prop, AreaDirectory ad) {
        if (this.usePropFromUser(prop)) {
            return this.getUserPropValue(prop, ad);
        }
        if (prop.equals(PROP_SIZE)) {
            int[] size = this.getSize(ad);
            return size[0] + " " + size[1];
        }
        String value = this.getDefault(prop, this.getDefaultPropValue(prop, ad, false));
        return value;
    }

    protected String getUserPropValue(String prop, AreaDirectory ad) {
        Object selected;
        if (prop.equals(PROP_LATLON) && this.latLonWidget != null) {
            return Format.dfrac(this.latLonWidget.getLat(), 5) + " " + Format.dfrac(this.latLonWidget.getLon(), 5);
        }
        if (prop.equals(PROP_PLACE) && this.placeLbl != null) {
            return this.place;
        }
        if (prop.equals("LINELE") && this.centerLineFld != null) {
            return this.centerLineFld.getText().trim() + " " + this.centerElementFld.getText().trim();
        }
        if (prop.equals(PROP_SIZE) && this.numLinesFld != null) {
            return this.numLinesFld.getText().trim() + " " + this.numElementsFld.getText().trim();
        }
        if (prop.equals(PROP_MAG) && this.lineMagSlider != null) {
            return this.getLineMagValue() + " " + this.getElementMagValue();
        }
        if (prop.equals(PROP_BAND) && this.bandComboBox != null && (selected = this.bandComboBox.getSelectedItem()) != null) {
            if (selected.equals(ALLBANDS)) {
                return ALLBANDS.toString();
            }
            return "" + ((BandInfo)selected).getBandNumber();
        }
        if (prop.equals(PROP_UNIT)) {
            return this.getSelectedUnit();
        }
        if (prop.equals(PROP_NAV)) {
            return TwoFacedObject.getIdString(this.navComboBox.getSelectedItem());
        }
        return null;
    }

    protected String getDefaultPropValue(String prop, AreaDirectory ad, boolean forDisplay) {
        if (prop.equals("user")) {
            return "idv";
        }
        if (prop.equals(PROP_PLACE)) {
            return PLACE_CENTER;
        }
        if (prop.equals("proj")) {
            return "0";
        }
        if (prop.equals("descr")) {
            return this.getDescriptor();
        }
        if (prop.equals("version")) {
            return "1";
        }
        if (prop.equals("compress")) {
            return "gzip";
        }
        if (prop.equals("port")) {
            return this.getPort();
        }
        if (prop.equals("debug")) {
            return "false";
        }
        if (prop.equals(PROP_SIZE)) {
            if (ad != null) {
                return ad.getLines() + " " + ad.getElements();
            }
            return "700 700";
        }
        if (prop.equals(PROP_MAG)) {
            return "1 1";
        }
        if (prop.equals("LINELE")) {
            if (ad == null) {
                return "0 0";
            }
            return ad.getLines() / 2 - 1 + " " + (ad.getElements() / 2 - 1);
        }
        if (prop.equals(PROP_LOC) || prop.equals(PROP_LATLON)) {
            if (ad == null) {
                return "0 0";
            }
            return ad.getCenterLatitude() + " " + ad.getCenterLongitude();
        }
        if (prop.equals(PROP_BAND)) {
            if (forDisplay) {
                return this.getBandName(ad, ((int[])this.bandTable.get(ad))[0]);
            }
            return "" + ((int[])this.bandTable.get(ad))[0];
        }
        if (prop.equals(PROP_SPAC)) {
            return this.getSelectedUnit().equalsIgnoreCase("BRIT") ? "1" : "4";
        }
        if (prop.equals(PROP_UNIT)) {
            return "X";
        }
        if (prop.equals(PROP_NAV)) {
            return "X";
        }
        return "";
    }

    protected void setImageInfoProps(AddeImageInfo aii, String[] props, AreaDirectory ad) {
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i];
            String value = this.getPropValue(prop, ad);
            if (prop.equals("user")) {
                aii.setUser(value);
                continue;
            }
            if (prop.equals("proj")) {
                aii.setProject(Integer.parseInt(value));
                continue;
            }
            if (prop.equals("descr")) {
                aii.setDescriptor(value);
                continue;
            }
            if (prop.equals("version")) {
                aii.setVersion(value);
                continue;
            }
            if (prop.equals("compress")) {
                int compVal = 112;
                if (value.equals("none") || value.equals("1")) {
                    compVal = 500;
                } else if (value.equals("compress") || value.equals("2") || value.equals("true")) {
                    compVal = 503;
                }
                aii.setCompression(compVal);
                continue;
            }
            if (prop.equals("port")) {
                aii.setPort(Integer.parseInt(value));
                continue;
            }
            if (prop.equals("debug")) {
                aii.setDebug(Boolean.getBoolean(value));
                continue;
            }
            if (prop.equals(PROP_SPAC)) {
                aii.setSpacing(Integer.parseInt(value));
                continue;
            }
            if (prop.equals(PROP_UNIT)) {
                if (value.equals(ALLUNITS.getId())) {
                    value = this.getDefault(prop, this.getDefaultPropValue(prop, ad, false));
                }
                aii.setUnit(value);
                continue;
            }
            if (prop.equals(PROP_BAND)) {
                if (value.equals(ALLBANDS.toString()) || value.equals(ALLBANDS.toString())) {
                    value = this.getDefault(prop, this.getDefaultPropValue(prop, ad, false));
                }
                aii.setBand(value);
                continue;
            }
            if (prop.equals(PROP_NAV)) {
                aii.setNavType(value);
                continue;
            }
            if (!prop.equals(PROP_ID)) continue;
            aii.setId(value);
        }
    }

    public String getSelectedBandName() {
        return this.getBandName(this.propertiesAD, this.getSelectedBand());
    }

    private void clearPropertiesWidgets() {
        if (this.latLonWidget != null) {
            this.latLonWidget.getLatField().setText("");
            this.latLonWidget.getLonField().setText("");
        }
        if (this.centerLineFld != null) {
            this.centerLineFld.setText("");
            this.centerElementFld.setText("");
        }
        if (this.numLinesFld != null) {
            if (this.sizeLbl != null) {
                this.sizeLbl.setText("");
            }
            this.numLinesFld.setText("");
            this.numElementsFld.setText("");
        }
        if (this.unitComboBox != null) {
            GuiUtils.setListData(this.unitComboBox, new Vector());
        }
        if (this.bandComboBox != null) {
            GuiUtils.setListData(this.bandComboBox, new Vector());
        }
        this.setMagSliders(0, 0);
        if (this.placeLbl != null) {
            this.changePlace(PLACE_CENTER);
        }
        if (this.navComboBox != null) {
            this.navComboBox.setSelectedIndex(0);
        }
        this.baseNumLines = 0.0;
        this.baseNumElements = 0.0;
    }

    private void setPropertiesState(AreaDirectory ad) {
        this.setPropertiesState(ad, false);
    }

    protected int[] getSize(AreaDirectory ad) {
        String elems;
        List<String> toks;
        this.baseNumLines = ad.getLines();
        this.baseNumElements = ad.getElements();
        String sizeDefault = this.getDefault(PROP_SIZE, null);
        List<String> list = toks = sizeDefault != null ? StringUtil.split(sizeDefault, " ", true, true) : null;
        if (toks == null || toks.size() == 0) {
            return new int[]{(int)this.baseNumLines, (int)this.baseNumElements};
        }
        String lines = "" + toks.get(0);
        if (lines.equalsIgnoreCase(ALL)) {
            lines = "" + (int)this.baseNumLines;
        }
        int numLines = new Integer(lines.trim());
        String string = elems = toks.size() > 1 ? "" + toks.get(1) : "" + (int)this.baseNumElements;
        if (elems.equalsIgnoreCase(ALL)) {
            elems = "" + this.baseNumElements;
        }
        int numElements = new Integer(elems.trim());
        return new int[]{(int)Math.min((double)numLines, this.baseNumLines), (int)Math.min((double)numElements, this.baseNumElements)};
    }

    private void setPropertiesState(AreaDirectory ad, boolean force) {
        if (this.amSettingProperties) {
            return;
        }
        this.prevPropertiesAD = this.propertiesAD;
        this.propertiesAD = ad;
        if (!force && this.checkPropertiesEqual(this.prevPropertiesAD, this.propertiesAD)) {
            return;
        }
        this.amSettingProperties = true;
        if (ad == null) {
            this.clearPropertiesWidgets();
            this.amSettingProperties = false;
            return;
        }
        String[] propArray = this.getAdvancedProps();
        String[] labelArray = this.getAdvancedLabels();
        if (this.numLinesFld != null) {
            int[] size = this.getSize(ad);
            this.numLinesFld.setText("" + size[0]);
            this.numElementsFld.setText("" + size[1]);
            if (this.sizeLbl != null) {
                String label = "  Raw size: " + ad.getLines() + " X " + ad.getElements();
                this.sizeLbl.setText(label);
            }
        }
        if (this.latLonWidget != null) {
            this.latLonWidget.getLatField().setText("" + ad.getCenterLatitude());
            this.latLonWidget.getLonField().setText("" + ad.getCenterLongitude());
        }
        if (this.centerLineFld != null) {
            this.centerLineFld.setText("" + ad.getLines() / 2);
            this.centerElementFld.setText("" + ad.getElements() / 2);
        }
        List<BandInfo> bandList = null;
        int[] bands = (int[])this.bandTable.get(ad);
        if (bands != null) {
            bandList = this.makeBandInfos(ad, bands);
        }
        this.bandInfos = bandList;
        if (this.bandComboBox != null) {
            List<BandInfo> comboList = bandList;
            if (bandList.size() > 1) {
                comboList = new ArrayList<BandInfo>();
                comboList.addAll(bandList);
                comboList.add((BandInfo)((Object)ALLBANDS));
            }
            GuiUtils.setListData(this.bandComboBox, comboList);
        }
        this.setAvailableUnits(ad, this.getSelectedBand());
        for (int propIdx = 0; propIdx < propArray.length; ++propIdx) {
            String prop = propArray[propIdx];
            String value = this.getDefault(prop, this.getDefaultPropValue(prop, ad, false));
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if (prop.equals(PROP_LOC)) {
                String key = this.getDefault(PROP_KEY, PROP_LATLON);
                boolean usingLineElement = key.equals("LINELE");
                if (usingLineElement) {
                    this.locationPanel.show(1);
                } else {
                    this.locationPanel.show(0);
                }
                value = usingLineElement ? this.getDefault(PROP_LOC, this.getDefaultPropValue("LINELE", ad, false)) : this.getDefault(PROP_LOC, this.getDefaultPropValue(PROP_LATLON, ad, false));
                String[] pair = this.getPair(value);
                if (pair == null) continue;
                if (usingLineElement) {
                    this.centerLineFld.setText(pair[0]);
                    this.centerElementFld.setText(pair[1]);
                    continue;
                }
                this.latLonWidget.setLat(pair[0]);
                this.latLonWidget.setLon(pair[1]);
                continue;
            }
            if (prop.equals(PROP_BAND)) {
                if (value.equalsIgnoreCase((String)ALLBANDS.getId())) {
                    this.bandComboBox.setSelectedItem(ALLBANDS);
                    continue;
                }
                int bandNum = 0;
                try {
                    bandNum = Integer.parseInt(value);
                }
                catch (NumberFormatException usingLineElement) {
                    // empty catch block
                }
                int index = BandInfo.findIndexByNumber(bandNum, bandList);
                if (index == -1) continue;
                this.bandComboBox.setSelectedIndex(index);
                continue;
            }
            if (prop.equals(PROP_PLACE)) {
                this.changePlace(value);
                continue;
            }
            if (prop.equals(PROP_MAG)) {
                String[] pair = this.getPair(value);
                if (pair != null) {
                    this.setMagSliders(new Integer(pair[0]), new Integer(pair[1]));
                    continue;
                }
                this.setMagSliders(0, 0);
                continue;
            }
            if (!prop.equals(PROP_NAV) || this.navComboBox == null) continue;
            this.navComboBox.setSelectedIndex(value.equalsIgnoreCase("LALO") ? 1 : 0);
        }
        this.updatePropertiesLabel();
        this.amSettingProperties = false;
    }

    private void setMagSliders(int lineValue, int elementValue) {
        if (this.lineMagSlider != null) {
            if (lineValue > 0) {
                --lineValue;
            } else if (lineValue < 0) {
                ++lineValue;
            }
            if (elementValue > 0) {
                --elementValue;
            } else if (elementValue < 0) {
                ++elementValue;
            }
            this.lineMagSlider.setValue(lineValue);
            this.elementMagSlider.setValue(elementValue);
            this.lineMagLbl.setText(StringUtil.padLeft("" + this.getLineMagValue(), 3));
            this.elementMagLbl.setText(StringUtil.padLeft("" + this.getElementMagValue(), 3));
            this.linesToElements = Math.abs((double)lineValue / (double)elementValue);
            if (Double.isNaN(this.linesToElements)) {
                this.linesToElements = 1.0;
            }
        }
    }

    private int getMagValue(JSlider slider) {
        int value = slider.getValue();
        if (value >= 0) {
            return value + 1;
        }
        return value - 1;
    }

    private String[] getPair(String v) {
        if (v == null) {
            return null;
        }
        List<String> toks = StringUtil.split(v = v.trim(), " ", true, true);
        if (toks == null || toks.size() == 0) {
            return null;
        }
        String tok1 = toks.get(0).toString();
        return new String[]{tok1, toks.size() > 1 ? toks.get(1).toString() : tok1};
    }

    private int getSelectedBand() {
        Object bi;
        Object object = bi = this.bandComboBox == null ? null : this.bandComboBox.getSelectedItem();
        if (bi == null || bi.equals(ALLBANDS)) {
            return 0;
        }
        return 0;
    }

    private String translatePlace(String place) {
        if ((place = place.toUpperCase()).equals(PLACE_ULEFT)) {
            return "Upper left";
        }
        if (place.equals(PLACE_LLEFT)) {
            return "Lower left";
        }
        if (place.equals(PLACE_URIGHT)) {
            return "Upper right";
        }
        if (place.equals(PLACE_LRIGHT)) {
            return "Lower right";
        }
        if (place.equals(PLACE_CENTER)) {
            return "Center";
        }
        return place;
    }

    private String getBandName(AreaDirectory ad, int band) {
        if (this.useSatBandInfo) {
            if (this.satBandInfo == null) {
                return "Band: " + band;
            }
            String[] descrs = this.satBandInfo.getBandDescr(ad.getSensorID(), ad.getSourceType());
            if (descrs != null && band >= 0 && band < descrs.length) {
                return descrs[band];
            }
            return "Band: " + band;
        }
        if (this.sensorToBandToName == null) {
            return "Band: " + band;
        }
        Hashtable bandToName = (Hashtable)this.sensorToBandToName.get(new Integer(ad.getSensorID()));
        String name = null;
        Integer bandInteger = new Integer(band);
        if (bandToName != null) {
            name = (String)bandToName.get(bandInteger);
        }
        if (name == null) {
            name = "Band: " + band;
        }
        return name;
    }

    private void setAvailableUnits(AreaDirectory ad, int band) {
        List<TwoFacedObject> l = this.getAvailableUnits(ad, band);
        l.add(ALLUNITS);
        GuiUtils.setListData(this.unitComboBox, l);
        TwoFacedObject tfo = null;
        if (this.bandComboBox != null && this.getSelectedBand() == 0) {
            tfo = ALLUNITS;
        } else {
            String preferredUnit = this.getDefault(PROP_UNIT, ALL);
            tfo = TwoFacedObject.findId(preferredUnit, l);
        }
        if (tfo != null) {
            this.unitComboBox.setSelectedItem(tfo);
        }
    }

    private List<TwoFacedObject> getAvailableUnits(AreaDirectory ad, int band) {
        int index;
        if (ad == null) {
            return new ArrayList<TwoFacedObject>();
        }
        int[] bands = (int[])this.bandTable.get(ad);
        int n = index = bands == null ? 0 : Arrays.binarySearch(bands, band);
        if (index < 0) {
            index = 0;
        }
        Vector<TwoFacedObject> l = new Vector<TwoFacedObject>();
        Vector v = ad.getCalInfo()[index];
        TwoFacedObject tfo = null;
        int preferredUnitIndex = 0;
        String preferredUnit = this.getDefault(PROP_UNIT, "BRIT");
        if (v != null && v.size() / 2 > 0) {
            for (int i = 0; i < v.size() / 2; ++i) {
                String name = (String)v.get(2 * i);
                String desc = (String)v.get(2 * i + 1);
                desc = desc.substring(0, 1).toUpperCase() + desc.substring(1).toLowerCase();
                tfo = new TwoFacedObject((Object)desc, name);
                l.add(tfo);
                if (!name.equalsIgnoreCase(preferredUnit)) continue;
                preferredUnitIndex = i;
            }
        } else {
            l.add(new TwoFacedObject((Object)"Raw Value", "RAW"));
        }
        return l;
    }

    private void readSatBands() {
        this.satBandInfo = null;
        this.sensorToBandToName = null;
        List lines = null;
        try {
            StringBuffer buff = this.getUrl("text");
            this.appendKeyValue(buff, "file", FILE_SATBAND);
            lines = this.readTextLines(buff.toString());
            if (lines == null) {
                return;
            }
            if (this.useSatBandInfo) {
                this.satBandInfo = new AddeSatBands(StringUtil.listToStringArray(lines));
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        if (lines == null) {
            return;
        }
        this.sensorToBandToName = new Hashtable();
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).toString().startsWith("Sat")) continue;
            List<String> satIds = StringUtil.split(lines.get(i).toString(), " ", true, true);
            satIds.remove(0);
            Hashtable<Integer, String> bandToName = new Hashtable<Integer, String>();
            int j = i + 1;
            while (j < lines.size()) {
                String line = lines.get(i).toString();
                if ((line = line.trim()).startsWith("EndSat")) break;
                int idx = line.indexOf(" ");
                if (idx >= 0) {
                    String bandTok = line.substring(0, idx);
                    try {
                        bandToName.put(Integer.decode(bandTok.trim()), line.substring(idx).trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++j;
                ++i;
            }
            for (j = 0; j < satIds.size(); ++j) {
                Integer sensorId = new Integer(satIds.get(j).toString());
                this.sensorToBandToName.put(sensorId, bandToName);
            }
        }
    }

    protected AddeImageInfo makeImageInfo(AreaDirectory dir, boolean isRelative, int num) {
        AddeImageInfo info = new AddeImageInfo(this.getServer(), "imagedata", this.getGroup(), this.getDescriptor());
        if (isRelative) {
            info.setDatasetPosition(num == 0 ? 0 : -num);
        } else {
            info.setStartDate(dir.getNominalTime());
        }
        this.setImageInfoProps(info, this.getMiscKeyProps(), dir);
        this.setImageInfoProps(info, this.getBaseUrlProps(), dir);
        String locKey = this.getDefault(PROP_KEY, "LINELE");
        String locValue = null;
        if (this.usePropFromUser(PROP_LOC)) {
            if (this.useLatLon()) {
                locKey = PROP_LATLON;
                locValue = this.getUserPropValue(PROP_LATLON, dir);
            } else {
                locKey = "LINELE";
                locValue = this.getUserPropValue("LINELE", dir);
            }
        } else {
            locValue = this.getPropValue("LINELE", dir);
        }
        info.setLocateKey(locKey);
        info.setLocateValue(locValue);
        String placeKey = PLACE_CENTER;
        if (this.usePropFromUser(PROP_PLACE)) {
            placeKey = this.getPropValue(PROP_PLACE, dir);
        }
        info.setPlaceValue(placeKey);
        String magKey = this.getPropValue(PROP_MAG, dir);
        int lmag = 1;
        int emag = 1;
        StringTokenizer tok = new StringTokenizer(magKey);
        lmag = (int)Misc.parseNumber((String)tok.nextElement());
        emag = tok.hasMoreTokens() ? (int)Misc.parseNumber((String)tok.nextElement()) : lmag;
        info.setLineMag(lmag);
        info.setElementMag(emag);
        int lines = dir.getLines();
        int elems = dir.getElements();
        String sizeKey = this.getPropValue(PROP_SIZE, dir);
        tok = new StringTokenizer(sizeKey);
        String size = (String)tok.nextElement();
        if (!size.equalsIgnoreCase("all")) {
            lines = (int)Misc.parseNumber(size);
            elems = tok.hasMoreTokens() ? (int)Misc.parseNumber((String)tok.nextElement()) : lines;
        }
        info.setLines(lines);
        info.setElements(elems);
        return info;
    }

    private boolean checkPropertiesEqual(AreaDirectory ad1, AreaDirectory ad2) {
        if (ad1 == null) {
            return false;
        }
        if (ad2 == null) {
            return false;
        }
        return Misc.equals(ad1, ad2) || ad1.getLines() == ad2.getLines() && ad1.getElements() == ad2.getElements() && Arrays.equals(ad1.getBands(), ad2.getBands());
    }

    private void updatePropertiesLabel() {
        if (this.propertiesLabel != null) {
            this.propertiesLabel.setText(this.getPropertiesDescription());
        }
    }

    protected String getPropertiesDescription() {
        StringBuffer buf = new StringBuffer();
        Object[] propArray = this.getAdvancedProps();
        List list = Misc.toList(propArray);
        if (list.contains(PROP_BAND)) {
            buf.append(this.getSelectedBandName());
            buf.append(", ");
        }
        if (list.contains(PROP_SIZE)) {
            buf.append("Size: ");
            String sizeKey = this.getUserPropValue(PROP_SIZE, this.propertiesAD);
            StringTokenizer tok = new StringTokenizer(sizeKey);
            if (tok.hasMoreTokens()) {
                String size = ((String)tok.nextElement()).trim();
                buf.append(size);
                buf.append("x");
                if (!size.equalsIgnoreCase("all")) {
                    if (tok.hasMoreTokens()) {
                        buf.append(((String)tok.nextElement()).trim());
                    } else {
                        buf.append(size);
                    }
                }
            }
        }
        return buf.toString();
    }

    @Override
    protected void handleConnectionError(Exception excp) {
        String message = excp.getMessage().toLowerCase();
        String cause = excp.getCause().getMessage().toLowerCase();
        if (excp instanceof AreaFileException && (message.indexOf("must be used with archived datasets") >= 0 || cause.indexOf("must be used with archived datasets") >= 0)) {
            this.getArchiveDay();
        } else if (excp instanceof AreaFileException && this.archiveDay != null && (message.indexOf("error generating list") >= 0 || message.indexOf("no images satisfy") >= 0)) {
            LogUtil.userMessage("No data available, choose another day");
            this.getArchiveDay();
        } else {
            this.resetDescriptorBox();
            super.handleConnectionError(excp);
        }
    }

    public Hashtable getDescriptorTable() {
        return this.descriptorTable;
    }

    private List<BandInfo> makeBandInfos(AreaDirectory ad, int[] bands) {
        ArrayList<BandInfo> l = new ArrayList<BandInfo>();
        if (ad != null && bands != null) {
            for (int i = 0; i < bands.length; ++i) {
                int band = bands[i];
                BandInfo bi = new BandInfo(ad.getSensorID(), band);
                bi.setBandDescription(this.getBandName(ad, band));
                bi.setCalibrationUnits(this.getAvailableUnits(ad, band));
                bi.setPreferredUnit(this.getDefault(PROP_UNIT, "BRIT"));
                l.add(bi);
            }
        }
        return l;
    }

    public List<BandInfo> getSelectedBandInfos() {
        TwoFacedObject tfo;
        ArrayList<BandInfo> selectedBandInfos = new ArrayList();
        ArrayList<TwoFacedObject> selectedUnits = null;
        if (this.unitComboBox != null && !(tfo = (TwoFacedObject)this.unitComboBox.getSelectedItem()).equals(ALLUNITS)) {
            selectedUnits = new ArrayList<TwoFacedObject>();
            selectedUnits.add(tfo);
        }
        if (this.getSelectedBand() == 0) {
            if (selectedUnits != null) {
                Iterator<BandInfo> iter = this.bandInfos.iterator();
                while (iter.hasNext()) {
                    BandInfo newBI = new BandInfo(iter.next());
                    newBI.setCalibrationUnits(selectedUnits);
                    newBI.setPreferredUnit((String)((TwoFacedObject)selectedUnits.get(0)).getId());
                    selectedBandInfos.add(newBI);
                }
            } else {
                selectedBandInfos = this.bandInfos;
            }
        } else {
            int index = BandInfo.findIndexByNumber(this.getSelectedBand(), this.bandInfos);
            BandInfo selectedBandInfo = null;
            if (index != -1) {
                selectedBandInfo = this.bandInfos.get(index);
            }
            if (selectedBandInfo != null) {
                if (selectedUnits != null) {
                    BandInfo newBI = new BandInfo(selectedBandInfo);
                    newBI.setCalibrationUnits(selectedUnits);
                    newBI.setPreferredUnit((String)((TwoFacedObject)selectedUnits.get(0)).getId());
                    selectedBandInfos.add(newBI);
                } else {
                    selectedBandInfos.add(selectedBandInfo);
                }
            }
        }
        return selectedBandInfos;
    }

    @Override
    protected String getDefaultDisplayType() {
        return null;
    }

    @Override
    public void doLoadInThread() {
        int numPixels;
        if (!this.checkForValidValues()) {
            return;
        }
        if (!this.getGoodToGo()) {
            this.updateStatus();
            return;
        }
        List imageList = this.getImageList();
        if (imageList == null || imageList.size() == 0) {
            return;
        }
        final int[] dim = new int[]{0, 0};
        AddeImageDescriptor aid = (AddeImageDescriptor)imageList.get(0);
        dim[0] = aid.getImageInfo().getElements();
        dim[1] = aid.getImageInfo().getLines();
        int bytesPerPixel = aid.getImageInfo().getSpacing();
        double megs = (double)(bytesPerPixel * (numPixels = dim[0] * dim[1] * imageList.size())) / 1000000.0;
        if (megs > 30.0) {
            final JCheckBox maintainSize = new JCheckBox("Maintain spatial extent", false);
            final JLabel sizeLbl = new JLabel(StringUtil.padRight("  " + (int)((double)((int)megs * 100) / 100.0) + " MB", 14));
            GuiUtils.setFixedWidthFont(sizeLbl);
            final List[] listHolder = new List[]{imageList};
            JSlider slider = new JSlider(2, (int)megs, (int)megs);
            slider.setMajorTickSpacing((int)(megs - 2.0) / 10);
            slider.setMinorTickSpacing((int)(megs - 2.0) / 10);
            slider.setSnapToTicks(true);
            final long timeNow = System.currentTimeMillis();
            ChangeListener sizeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    if (System.currentTimeMillis() - timeNow < 500L) {
                        return;
                    }
                    JSlider slider = (JSlider)evt.getSource();
                    int pixelsPerImage = 1000000 * slider.getValue() / listHolder[0].size() / 4;
                    double aspect = (double)dim[1] / (double)dim[0];
                    int nx = (int)Math.sqrt((double)pixelsPerImage / aspect);
                    int ny = (int)(aspect * (double)nx);
                    if (maintainSize.isSelected()) {
                        AddeImageChooser.this.lineMagSlider.setValue(AddeImageChooser.this.getLineMagValue() - 1);
                        AddeImageChooser.this.lineMagSliderChanged(true);
                    } else {
                        AddeImageChooser.this.numElementsFld.setText("" + nx);
                        AddeImageChooser.this.numLinesFld.setText("" + ny);
                    }
                    listHolder[0] = AddeImageChooser.this.getImageList();
                    AddeImageDescriptor aid = (AddeImageDescriptor)listHolder[0].get(0);
                    dim[0] = aid.getImageInfo().getElements();
                    dim[1] = aid.getImageInfo().getLines();
                    int bytesPerPixel = aid.getImageInfo().getSpacing();
                    int numPixels = dim[0] * dim[1] * listHolder[0].size();
                    int nmegs = (int)((double)(bytesPerPixel * numPixels) / 1000000.0);
                    sizeLbl.setText(StringUtil.padRight("  " + nmegs + " MB", 14));
                }
            };
            slider.addChangeListener(sizeListener);
            JPanel msgContents = GuiUtils.vbox(new JLabel("<html>You are about to load " + (int)megs + " MB of imagery.<br>Are you sure you want to do this?<p><hr><p></html>"), GuiUtils.inset((Component)GuiUtils.leftCenterRight(new JLabel("Change Size: "), GuiUtils.inset((Component)slider, 5), sizeLbl), 5));
            if (!GuiUtils.askOkCancel("Image Size", msgContents)) {
                return;
            }
            imageList = listHolder[0];
        }
        ImageDataset ids = new ImageDataset(this.getDatasetName(), imageList);
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("Chooser_Do_Time_Matching", this.getDoTimeDrivers());
        this.getDataSourceProperties(ht);
        String bandName = this.getSelectedBandName();
        if (bandName != null && !bandName.equals(ALLBANDS.toString())) {
            ht.put("data name", bandName);
        }
        ht.put("allBands", this.bandDirs);
        this.makeDataSource(ids, "ADDE.IMAGE", ht);
        this.saveServerState();
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.setDoTimeDrivers(false);
    }

    @Override
    protected void getDataSourceProperties(Hashtable ht) {
        super.getDataSourceProperties(ht);
        ht.put(DATASET_NAME_KEY, this.getDatasetName());
        ht.put("bandinfo", this.getSelectedBandInfos());
    }
}

