/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.adde.DataSetInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddePointDataChooser;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.UtcDate;
import visad.DateTime;
import visad.VisADException;

public class AddeGLMDataChooser
extends AddePointDataChooser {
    private JComponent descriptorLabel;
    protected JComboBox descriptorComboBox;
    private boolean ignoreDescriptorChange = false;
    protected String[] descriptorNames;
    protected static final String LABEL_SELECT = " -- Select -- ";
    private PreferenceList descList;
    protected Hashtable descriptorTable;
    private JComponent relTimeIncComp;

    public AddeGLMDataChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.setRelativeTimeIncrement(5.0f);
    }

    @Override
    public String getDefaultStationModel() {
        return "location";
    }

    @Override
    public String getDataName() {
        return "GLM Lightning Data";
    }

    @Override
    protected TwoFacedObject[] getDefaultDatasets() {
        return new TwoFacedObject[]{new TwoFacedObject((Object)"RTGOESR", "RTGOESR"), new TwoFacedObject((Object)"RTGOESS", "RTGOESS")};
    }

    public float getRelativeTimeIncrement1() {
        return 0.083333336f;
    }

    @Override
    protected String getDayTimeSelectString() {
        StringBuffer buf = new StringBuffer();
        if (this.getDoAbsoluteTimes()) {
            buf.append("time ");
            List times = this.getSelectedAbsoluteTimes();
            DateTime dt = (DateTime)times.get(0);
            buf.append(UtcDate.getHMS(dt));
            buf.append(" ");
            dt = (DateTime)times.get(times.size() - 1);
            buf.append(UtcDate.getHMS(dt));
        } else {
            buf.append(this.getRelativeTimeId());
        }
        return buf.toString();
    }

    @Override
    protected String getRelativeTimeId() {
        return "%relative%";
    }

    @Override
    protected int getAbsoluteTimeSelectMode() {
        return 1;
    }

    @Override
    protected String getGroup() {
        String dataset = TwoFacedObject.getIdString(this.dataTypes.getSelectedItem());
        int index = dataset.indexOf(47);
        return dataset;
    }

    protected String getDescriptor1() {
        String dataset = TwoFacedObject.getIdString(this.descriptorComboBox.getSelectedItem());
        int index = dataset.indexOf(47);
        return dataset;
    }

    @Override
    protected String getDescriptor() {
        return this.getDescriptorFromSelection(this.getSelectedDescriptor());
    }

    protected String getDescriptorFromSelection(String selection) {
        if (this.descriptorTable == null) {
            return null;
        }
        if (selection == null) {
            return null;
        }
        return (String)this.descriptorTable.get(selection);
    }

    public String getSelectedDescriptor() {
        String selection = (String)this.descriptorComboBox.getSelectedItem();
        if (selection == null) {
            return null;
        }
        if (selection.equals(LABEL_SELECT)) {
            return null;
        }
        return selection;
    }

    @Override
    public void readTimes() {
        this.clearTimesList();
        SortedSet<DateTime> uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
        this.setState(1);
        try {
            GregorianCalendar utcCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            Date now = new Date();
            utcCalendar.setTime(now);
            int curHour = utcCalendar.get(11);
            int curMin = utcCalendar.get(12);
            float min = this.getRelativeTimeIncrement();
            int numTimes = (int)(1440.0f / min);
            int minB = 2;
            utcCalendar.add(12, -minB);
            int sec = utcCalendar.get(13);
            utcCalendar.add(13, -sec);
            try {
                DateTime dt = new DateTime(utcCalendar.getTime());
                uniqueTimes.add(dt);
            }
            catch (Exception dt) {
                // empty catch block
            }
            for (int i = 1; i < numTimes; ++i) {
                utcCalendar.add(12, -((int)min));
                try {
                    DateTime dt = new DateTime(utcCalendar.getTime());
                    uniqueTimes.add(dt);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setState(2);
        }
        catch (Exception excp) {
            this.handleConnectionError(excp);
            return;
        }
        if (this.getDoAbsoluteTimes()) {
            if (!uniqueTimes.isEmpty()) {
                this.setAbsoluteTimes(new ArrayList(uniqueTimes));
            }
            int selectedIndex = this.getAbsoluteTimes().size() - 1;
            this.setSelectedAbsoluteTime(selectedIndex);
        }
    }

    @Override
    protected JComponent doMakeContents() {
        ArrayList<JComponent> allComps = new ArrayList<JComponent>();
        this.clearOnChange(this.dataTypes);
        this.addTopComponents(allComps, "Group:", this.dataTypes);
        this.descriptorLabel = this.addServerComp(GuiUtils.rLabel(this.getDescriptorLabel() + ":"));
        this.descriptorComboBox = new JComboBox();
        this.descriptorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AddeGLMDataChooser.this.ignoreDescriptorChange) {
                    if (e.getStateChange() == 1) {
                        AddeGLMDataChooser.this.descriptorChanged();
                    }
                }
            }
        });
        allComps.add(this.descriptorLabel);
        allComps.add(this.addServerComp(this.descriptorComboBox));
        JPanel timesComp = this.makeTimesPanel();
        allComps.add(this.addServerComp(GuiUtils.valignLabel("Times:")));
        allComps.add(this.addServerComp(timesComp));
        JComponent top = GuiUtils.formLayout(allComps, GRID_INSETS);
        return GuiUtils.top(GuiUtils.centerBottom(top, this.getDefaultButtons()));
    }

    public String getDescriptorLabel() {
        return "GLM Type";
    }

    protected void descriptorChanged() {
        this.readTimes();
        this.updateStatus();
    }

    @Override
    protected boolean getGoodToGo() {
        if (this.getDoAbsoluteTimes()) {
            return this.getHaveAbsoluteTimesSelected();
        }
        return this.canReadTimes();
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        this.enableWidgets();
    }

    @Override
    protected void enableWidgets() {
        boolean descriptorState;
        boolean bl = descriptorState = (this.getState() == 2 || this.getState() == 1) && this.canReadTimes();
        if (this.drivercbx != null) {
            this.drivercbx.setSelected(false);
            this.enableTimeWidgets();
        }
        this.checkTimesLists();
        this.enableAbsoluteTimesList(this.getDoAbsoluteTimes() && descriptorState);
        this.getRelativeTimesChooser().setEnabled(!this.getDoAbsoluteTimes() && descriptorState);
        if (this.descriptorComboBox.getItemCount() > 0) {
            GuiUtils.enableTree(this.descriptorComboBox, true);
        } else {
            GuiUtils.enableTree(this.descriptorComboBox, false);
        }
        this.revalidate();
    }

    protected boolean canReadTimes() {
        return this.haveDescriptorSelected();
    }

    protected boolean haveDescriptorSelected() {
        if (!GuiUtils.anySelected(this.descriptorComboBox)) {
            return false;
        }
        return this.getDescriptor() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDescriptors(String[] names) {
        Object object = this.WIDGET_MUTEX;
        synchronized (object) {
            this.ignoreDescriptorChange = true;
            this.descriptorComboBox.removeAllItems();
            this.descriptorNames = names;
            if (names == null || names.length == 0) {
                return;
            }
            this.descriptorComboBox.addItem(LABEL_SELECT);
            for (int j = 0; j < names.length; ++j) {
                this.descriptorComboBox.addItem(names[j]);
            }
            this.ignoreDescriptorChange = false;
        }
    }

    @Override
    public void handleConnect() throws Exception {
        this.setState(1);
        this.connectToServer();
        this.setState(2);
        this.updateStatus();
    }

    protected void connectToServer() {
        this.setDescriptors(null);
        this.setDoAbsoluteTimes(false);
        if (!this.canAccessServer()) {
            return;
        }
        this.readDescriptors();
        this.saveServerState();
        this.ignoreStateChangedEvents = true;
        if (this.descList != null) {
            this.descList.saveState(this.groupSelector);
        }
        this.ignoreStateChangedEvents = false;
    }

    private void readDescriptors() {
        try {
            StringBuffer buff = this.getGroupUrl("datasetinfo", this.getGroup());
            buff.append("&type=").append(this.getDataType());
            DataSetInfo dsinfo = new DataSetInfo(buff.toString());
            this.descriptorTable = dsinfo.getDescriptionTable();
            Object[] names = new String[this.descriptorTable.size()];
            Enumeration enumeration = this.descriptorTable.keys();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                names[i] = enumeration.nextElement().toString();
                ++i;
            }
            Arrays.sort(names);
            this.setDescriptors((String[])names);
            this.setState(2);
        }
        catch (Exception e) {
            this.handleConnectionError(e);
        }
    }

    @Override
    protected String getTimesRequest() {
        StringBuffer buf = this.getGroupUrl("POINT", this.getGroup());
        this.appendKeyValue(buf, "descr", this.getDescriptor());
        this.appendKeyValue(buf, "pos", "ALL");
        if (this.getDoAbsoluteTimes()) {
            this.appendKeyValue(buf, "num", "all");
            this.appendKeyValue(buf, "select", "'DAY " + this.getJulianDay() + ";TIME " + this.getTimeRange() + "'");
        }
        this.appendKeyValue(buf, "param", "DAY TIME");
        return buf.toString();
    }

    private String getJulianDay() {
        String retString = "";
        try {
            DateTime dt = new DateTime();
            retString = UtcDate.formatUtcDate(dt, "yyyyDDD");
        }
        catch (VisADException ve) {
            this.handleConnectionError(ve);
        }
        int bday = Integer.parseInt(retString);
        String dayRange = String.valueOf(bday) + " " + retString;
        return dayRange;
    }

    private String getTimeRange() {
        String retString = "";
        try {
            DateTime dt = new DateTime();
            retString = UtcDate.formatUtcDate(dt, "HHmmss");
        }
        catch (VisADException ve) {
            this.handleConnectionError(ve);
        }
        int btime = Integer.parseInt(retString) - 1000;
        String timeRange = String.valueOf(btime) + " " + retString;
        return timeRange;
    }

    @Override
    public String getRequestUrl() {
        StringBuffer request = this.getGroupUrl("point", this.getGroup());
        this.appendKeyValue(request, "descr", this.getDescriptor());
        this.appendRequestSelectClause(request);
        this.appendKeyValue(request, "num", "all");
        this.appendKeyValue(request, "pos", "1");
        return request.toString();
    }

    @Override
    protected JComponent getExtraRelativeTimeComponent() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JComboBox box = (JComboBox)ae.getSource();
                if (GuiUtils.anySelected(box)) {
                    AddeGLMDataChooser.this.setRelativeTimeIncrement(AddeGLMDataChooser.this.getRelBoxValue());
                    AddeGLMDataChooser.this.readTimes();
                }
            }
        };
        String[] nums = new String[]{"1", "10", "15", "20", "25", "30"};
        float[] vals = new float[]{1.0f, 10.0f, 15.0f, 20.0f, 25.0f, 30.0f};
        ArrayList<TwoFacedObject> l = new ArrayList<TwoFacedObject>();
        for (int i = 0; i < nums.length; ++i) {
            l.add(new TwoFacedObject((Object)nums[i], new Float(vals[i])));
        }
        this.relTimeIncBox = GuiUtils.getEditableBox(l, new Float(this.getRelativeTimeIncrement()));
        this.relTimeIncBox.addActionListener(listener);
        this.relTimeIncBox.setToolTipText("Set the increment between most recent times");
        this.relTimeIncComp = GuiUtils.hbox((Component)new JLabel("Increment: "), (Component)this.relTimeIncBox, GuiUtils.lLabel(this.getRelTimeIncLabel()));
        return GuiUtils.left(this.relTimeIncComp);
    }

    private float getRelBoxValue() {
        Object o;
        float value = this.getRelativeTimeIncrement();
        if (this.relTimeIncBox != null && (o = this.relTimeIncBox.getSelectedItem()) != null) {
            String val = TwoFacedObject.getIdString(o);
            value = (float)Misc.parseNumber(val);
        }
        return value;
    }

    @Override
    public String getRelTimeIncLabel() {
        return " minutes";
    }

    @Override
    public void doLoadInThread() {
        this.showWaitCursor();
        try {
            StationModel selectedStationModel = this.getSelectedStationModel();
            String source = this.getRequestUrl();
            source = source.replaceAll("group", "GROUP");
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            this.getDataSourceProperties(ht);
            ht.put("Chooser_Do_Time_Matching", this.getDoTimeDrivers());
            ht.put("prop.stationmodelname", selectedStationModel.getName());
            ht.put(DATASET_NAME_KEY, this.getDatasetName() + "/" + this.getDescriptor());
            ht.put("data name", this.getDataName());
            ht.put(AddeUtil.RELATIVE_TIME_INCREMENT, new Double((double)this.getRelativeTimeIncrement() / 60.0));
            if (source.indexOf("%relative%") >= 0) {
                ht.put(AddeUtil.NUM_RELATIVE_TIMES, this.getRelativeTimeIndices());
            }
            if (this.getDoAbsoluteTimes()) {
                ht.put(AddeUtil.ABSOLUTE_TIMES, this.getSelectedAbsoluteTimes());
            }
            if (source.indexOf("%level%") >= 0) {
                ht.put(LEVELS, this.getLevels());
                ht.put(SELECTED_LEVEL, this.getSelectedLevel());
            }
            this.makeDataSource(source, DATA_TYPE, ht);
            this.saveServerState();
        }
        catch (Exception excp) {
            this.logException("Unable to open ADDE point dataset", excp);
        }
        this.showNormalCursor();
        this.drivercbx.setSelected(false);
        this.enableTimeWidgets();
        this.setDoTimeDrivers(false);
    }

    @Override
    protected String getDefaultDisplayType() {
        return null;
    }
}

