/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.ui.ChooserList;
import ucar.unidata.util.GuiUtils;

public class AddeFrontChooser
extends AddeChooser {
    ChooserList timesList;
    JRadioButton forecastBtn;
    JRadioButton observedBtn;

    public AddeFrontChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        this.setHaveData(true);
    }

    @Override
    protected JComponent doMakeContents() {
        List servers = this.getIdv().getIdvChooserManager().getAddeServers("any");
        this.forecastBtn = new JRadioButton("Forecast Fronts", false);
        this.observedBtn = new JRadioButton("Analysis Fronts", true);
        GuiUtils.buttonGroup(this.observedBtn, this.forecastBtn);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        comps.add(GuiUtils.rLabel("Server:"));
        comps.add(GuiUtils.left(this.getServerSelector()));
        comps.add(GuiUtils.rLabel("Latest:"));
        comps.add(GuiUtils.left(GuiUtils.hbox(this.observedBtn, this.forecastBtn)));
        this.timesList = new ChooserList();
        this.timesList.setSelectionMode(0);
        Vector<String> items = new Vector<String>();
        for (int i = 0; i < 10; ++i) {
            if (i == 0) {
                items.add("Most recent day");
                continue;
            }
            items.add(i + 1 + " most recent days");
        }
        this.timesList.setListData(items);
        this.timesList.setSelectedIndex(0);
        this.timesList.getScroller().setPreferredSize(new Dimension(200, 100));
        JComponent buttons = this.getDefaultButtons();
        this.setHaveData(true);
        JComponent contents = GuiUtils.formLayout(comps, GRID_INSETS);
        return GuiUtils.topLeft(GuiUtils.vbox(contents, buttons));
    }

    @Override
    public void setStatus(String msg, String what) {
        super.setStatus("Press \"Add Source\" to load the selected front data", "buttons");
    }

    @Override
    public void doLoadInThread() {
        ArrayList<String> urls = new ArrayList<String>();
        int index = this.timesList.getSelectedIndex();
        String server = this.getServer();
        String type = this.forecastBtn.isSelected() ? "SRP" : "SUS&wmo=ASUS01";
        for (int i = 0; i <= index; ++i) {
            String url = "adde://" + server + "/wxtext?group=RTWXTEXT&apro=COD&astn=" + type + "&day=%DAY-" + i + "%";
            urls.add(url);
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("TITLE", this.forecastBtn.isSelected() ? "Forecast Front" : "Analysis Fronts");
        this.makeDataSource(urls, "TEXT.FRONT", ht);
        this.saveServerState();
    }
}

