/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser.adde;

import edu.wisc.ssec.mcidas.adde.AddeTextReader;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;
import ucar.unidata.idv.IdvObjectStore;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.TimesChooser;
import ucar.unidata.idv.chooser.adde.AddeServer;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class AddeChooser
extends TimesChooser {
    private static final String PREF_SERVERSTATE = "idv.chooser.adde.serverstate";
    private static final boolean MARK_AS_INACTIVE = true;
    private List addeServers;
    private static final int TIMES_RELATIVERANGE = 0;
    private static final int TIMES_ABSOLUTE = 1;
    private static final int TIMES_RELATIVE = 2;
    protected static final String CMD_CONNECT = "cmd.connect";
    protected static final String FILE_PUBLICSRV = "PUBLIC.SRV";
    protected static final String REQ_POINTDATA = "pointdata";
    protected static final String REQ_IMAGEDIR = "imagedir";
    protected static final String REQ_TEXT = "text";
    protected static final String REQ_DATASETINFO = "datasetinfo";
    protected static final String REQ_IMAGEDATA = "imagedata";
    protected static final String DEFAULT_COMPRESS = "gzip";
    protected static final String DEFAULT_PORT = "112";
    protected static final String DEFAULT_DEBUG = "false";
    protected static final String DEFAULT_VERSION = "1";
    protected static final String DEFAULT_USER = "idv";
    protected static final String DEFAULT_PROJ = "0";
    protected static final String PROP_FILE = "file";
    protected static final String PROP_COMPRESS = "compress";
    protected static final String PROP_DEBUG = "debug";
    protected static final String PROP_DESCR = "descr";
    protected static final String PROP_GROUP = "group";
    protected static final String PROP_NUM = "num";
    protected static final String PROP_PARAM = "param";
    protected static final String PROP_PORT = "port";
    public static final String PROP_ADDEPORT = "adde.port";
    protected static final String PROP_POS = "pos";
    protected static final String PROP_DAY = "DAY";
    protected static final String PROP_TIME = "TIME";
    protected static final String PROP_HMS = "HMS";
    protected static final String PROP_CYD = "CYD";
    protected static final String PROP_PROJ = "proj";
    protected static final String PROP_SELECT = "select";
    protected static final String PROP_USER = "user";
    protected static final String PROP_VERSION = "version";
    protected static final String MSG_TIMES = "Please select one or more times";
    protected static final String LABEL_DATAINTERVAL = "Data Interval:";
    protected static final String LABEL_DATASET = "Dataset:";
    protected static final String LABEL_DATATYPE = "Data Type:";
    protected static final String LABEL_SERVER = "Server:";
    protected static final String LABEL_STATIONS = "Stations:";
    protected static final String LABEL_TIMES = "Times:";
    public static String NEW_SELECTION = "AddeChooser.NEW_SELECTION";
    protected static final int STATE_UNCONNECTED = 0;
    protected static final int STATE_CONNECTING = 1;
    protected static final int STATE_CONNECTED = 2;
    public static final int STATUS_OK = 0;
    public static final int STATUS_NEEDSLOGIN = 1;
    public static final int STATUS_ERROR = 2;
    protected boolean ignoreStateChangedEvents = false;
    public static String DATASET_NAME_KEY = "name";
    public static final String DATA_NAME_KEY = "data name";
    public static final String PROP_DATANAME = "dataname";
    protected Object WIDGET_MUTEX = new Object();
    protected Hashtable passwords = new Hashtable();
    private int state = 0;
    private JComboBox serverSelector;
    public static int serverTimeStamp = 0;
    private int myServerTimeStamp = serverTimeStamp;
    protected JComboBox groupSelector;
    private List compsThatNeedServer = new ArrayList();

    public AddeChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
        this.simpleMode = !this.getProperty("showdetails", true);
        this.addeServers = this.getIdv().getIdvChooserManager().getAddeServers(this.getGroupType());
        this.serverSelector = new JComboBox(new Vector(this.addeServers)){

            @Override
            public void paint(Graphics g) {
                if (AddeChooser.this.myServerTimeStamp != serverTimeStamp) {
                    AddeChooser.this.myServerTimeStamp = serverTimeStamp;
                    Misc.runInABit(10L, AddeChooser.this, "updateServerList", null);
                }
                super.paint(g);
            }
        };
        this.serverSelector.setEditable(true);
        this.serverSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AddeChooser.this.ignoreStateChangedEvents) {
                    AddeChooser.this.setGroups();
                }
            }
        });
        this.serverSelector.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                AddeServer server = AddeChooser.this.getAddeServer();
                if (server == null) {
                    return;
                }
                ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                items.add(GuiUtils.makeMenuItem("Remove local server: " + server.getName(), AddeChooser.this, "removeServer", server));
                JPopupMenu popup = GuiUtils.makePopupMenu(items);
                popup.show(AddeChooser.this.serverSelector, e.getX(), e.getY());
            }
        });
        this.groupSelector = new JComboBox();
        this.groupSelector.setToolTipText("Right click to remove group");
        this.groupSelector.setEditable(true);
        this.groupSelector.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    Object selected = AddeChooser.this.groupSelector.getSelectedItem();
                    if (selected == null || !(selected instanceof AddeServer.Group)) {
                        return;
                    }
                    AddeServer.Group group = (AddeServer.Group)selected;
                    ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
                    items.add(GuiUtils.makeMenuItem("Remove local group: " + group.getName(), AddeChooser.this, "removeGroup", group));
                    final AddeServer server = AddeChooser.this.getAddeServer();
                    if (server != null) {
                        List groups = server.getGroupsWithType(AddeChooser.this.getGroupType(), false);
                        for (int i = 0; i < groups.size(); ++i) {
                            final AddeServer.Group inactiveGroup = (AddeServer.Group)groups.get(i);
                            if (inactiveGroup.getActive()) continue;
                            JMenuItem mi = new JMenuItem("Re-activate group: " + inactiveGroup);
                            items.add(mi);
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent ae) {
                                    AddeChooser.this.getIdv().getIdvChooserManager().activateAddeServerGroup(server, inactiveGroup);
                                    AddeChooser.this.setGroups();
                                    AddeChooser.this.groupSelector.setSelectedItem(inactiveGroup);
                                }
                            });
                        }
                    }
                    if (items.size() == 0) {
                        items.add(new JMenuItem("Not a local group"));
                    }
                    JPopupMenu popup = GuiUtils.makePopupMenu(items);
                    popup.show(AddeChooser.this.groupSelector, e.getX(), e.getY());
                }
            }
        });
        this.loadServerState();
        this.setGroups();
    }

    public void updateServerList() {
        boolean old = this.ignoreStateChangedEvents;
        this.ignoreStateChangedEvents = true;
        List newList = this.getIdv().getIdvChooserManager().getAddeServers(this.getGroupType());
        if (Misc.equals(newList, this.addeServers)) {
            this.ignoreStateChangedEvents = old;
            return;
        }
        this.addeServers = this.getIdv().getIdvChooserManager().getAddeServers(this.getGroupType());
        Object selected = this.serverSelector.getSelectedItem();
        GuiUtils.setListData(this.serverSelector, this.addeServers);
        if (selected != null && this.addeServers.contains(selected)) {
            this.serverSelector.setSelectedItem(selected);
        }
        this.setGroups();
        this.ignoreStateChangedEvents = old;
    }

    protected String getGroupType() {
        return "any";
    }

    public void removeGroup(AddeServer.Group group) {
        AddeServer server = this.getAddeServer();
        if (server == null) {
            return;
        }
        this.getIdv().getIdvChooserManager().removeAddeServerGroup(server, group, true);
        this.setGroups();
    }

    public void removeServer(AddeServer server) {
        this.getIdv().getIdvChooserManager().removeAddeServer(server, true);
        this.updateServerList();
    }

    private AddeServer getAddeServer() {
        Object selected = this.serverSelector.getSelectedItem();
        if (selected != null && selected instanceof AddeServer) {
            return (AddeServer)selected;
        }
        return null;
    }

    protected void setGroups() {
        AddeServer server = this.getAddeServer();
        if (server != null) {
            Object selected = this.groupSelector.getSelectedItem();
            List groups = server.getGroupsWithType(this.getGroupType());
            GuiUtils.setListData(this.groupSelector, groups);
            if (selected != null && groups.contains(selected)) {
                this.groupSelector.setSelectedItem(selected);
            }
        } else {
            GuiUtils.setListData(this.groupSelector, new Vector());
        }
    }

    protected void clearOnChange(JComboBox box) {
        box.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!AddeChooser.this.ignoreStateChangedEvents) {
                    AddeChooser.this.setState(0);
                }
            }
        });
    }

    public void handleConnect() throws Exception {
        this.handleUpdate();
        this.drivercbx.setSelected(false);
    }

    public void handleUpdate() throws Exception {
    }

    public void handleConnectFromThread() {
        this.showWaitCursor();
        try {
            this.handleConnect();
        }
        catch (Exception exc) {
            this.handleConnectionError(exc);
        }
        this.showNormalCursor();
    }

    public void handleUpdateFromThread() {
        this.showWaitCursor();
        try {
            this.handleUpdate();
        }
        catch (Exception exc) {
            this.handleConnectionError(exc);
        }
        this.showNormalCursor();
    }

    protected final void doConnect() {
        Misc.run(this, "handleConnectFromThread");
    }

    @Override
    public final void doUpdate() {
        Misc.run(this, "handleUpdateFromThread");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CMD_CONNECT)) {
            this.doConnect();
        } else {
            super.actionPerformed(ae);
        }
    }

    protected String[] getDefaultServerSelection() {
        String id = this.getId();
        String stateProp = "idv.chooser.adde.serverstate." + id;
        IdvObjectStore store = this.getIdv().getStore();
        String[] serverState = (String[])store.get(stateProp);
        if (serverState == null) {
            String serverProp = "idv.defaultselection." + id + ".server";
            String groupProp = "idv.defaultselection." + id + ".group";
            String server = (String)store.get(serverProp);
            String group = (String)store.get(groupProp);
            if (server != null && group != null) {
                serverState = new String[]{server, group};
            }
        }
        return serverState;
    }

    protected void loadServerState() {
        AddeServer.Group group;
        if (this.addeServers == null) {
            return;
        }
        String[] serverState = this.getDefaultServerSelection();
        if (serverState == null) {
            return;
        }
        AddeServer server = AddeServer.findServer(this.addeServers, serverState[0]);
        if (server == null) {
            return;
        }
        this.serverSelector.setSelectedItem(server);
        this.setGroups();
        if (serverState[1] != null && (group = server.findGroup(serverState[1])) != null) {
            this.groupSelector.setSelectedItem(group);
        }
    }

    public void saveServerState() {
        String id = this.getId();
        String server = this.getServer();
        String[] serverState = new String[]{server, this.getGroup()};
        this.getIdv().getStore().put("idv.chooser.adde.serverstate." + id, (Object)serverState);
        this.getIdv().getStore().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableComps() {
        Object object = this.WIDGET_MUTEX;
        synchronized (object) {
            boolean newEnabledState = this.state == 2;
            for (int i = 0; i < this.compsThatNeedServer.size(); ++i) {
                JComponent comp = (JComponent)this.compsThatNeedServer.get(i);
                if (comp.isEnabled() == newEnabledState) continue;
                GuiUtils.enableTree(comp, newEnabledState);
            }
        }
    }

    protected void addTopComponents(List comps, String label, JComponent extra) {
        this.addTopComponents(comps, GuiUtils.hbox((Component)this.padLabel(label), (Component)extra, 5));
    }

    protected void addTopComponents(List comps, Component extra) {
        if (extra == null) {
            extra = GuiUtils.filler();
        }
        comps.add(GuiUtils.rLabel(LABEL_SERVER));
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel right = GuiUtils.doLayout(new Component[]{this.serverSelector, extra, this.getConnectButton()}, 3, GuiUtils.WT_YN, GuiUtils.WT_N);
        comps.add(GuiUtils.left(right));
    }

    @Override
    protected void updateStatus() {
        super.updateStatus();
        Misc.run(new Runnable(){

            @Override
            public void run() {
                AddeChooser.this.enableComps();
            }
        });
        if (this.state != 2) {
            this.clearTimesList();
        }
        if (this.state == 0) {
            this.setStatus("Please connect to the server", "connect");
        } else if (this.state == 1) {
            this.setStatus("Connecting to server: " + this.getServer());
        } else if (this.getGoodToGo()) {
            this.setStatus("Press \"Add Source\" to load the selected " + this.getDataName().toLowerCase(), "buttons");
        } else if (this.getState() == 2) {
            if (this.usingStations() && this.stationMap.getStations().size() > 0 && this.getSelectedStations().size() == 0) {
                if (this.stationMap.getMultipleSelect()) {
                    this.setStatus("Please select one or more stations", "stations");
                } else {
                    this.setStatus("Please select a station", "stations");
                }
                if (this.stationMap.getDeclutter()) {
                    // empty if block
                }
            } else if (!this.haveTimeSelected()) {
                this.setStatus(MSG_TIMES);
            }
        }
        this.setHaveData(this.getGoodToGo());
    }

    public String getDataName() {
        return "ADDE data";
    }

    public String getDataSetName() {
        return "ADDE data";
    }

    public String getDataType() {
        return "";
    }

    @Override
    protected String getLoadToolTip() {
        return "Load the selected " + this.getDataName().toLowerCase();
    }

    public String getServer() {
        Object selected = this.serverSelector.getSelectedItem();
        if (selected == null) {
            return null;
        }
        if (selected instanceof AddeServer) {
            AddeServer server = (AddeServer)selected;
            return server.getName();
        }
        String serverName = selected.toString();
        AddeServer server = this.getIdv().getIdvChooserManager().addAddeServer(serverName);
        this.addeServers = this.getIdv().getIdvChooserManager().getAddeServers(this.getGroupType());
        Object selectedGroup = this.groupSelector.getSelectedItem();
        AddeServer.Group group = null;
        if (selectedGroup != null) {
            group = this.getIdv().getIdvChooserManager().addAddeServerGroup(server, selectedGroup.toString(), this.getGroupType());
        }
        boolean old = this.ignoreStateChangedEvents;
        this.ignoreStateChangedEvents = true;
        GuiUtils.setListData(this.serverSelector, this.addeServers);
        this.serverSelector.setSelectedItem(server);
        this.setGroups();
        if (group != null) {
            this.groupSelector.setSelectedItem(group);
        }
        this.ignoreStateChangedEvents = old;
        return server.getName();
    }

    protected String getGroup() {
        Object selected = this.groupSelector.getSelectedItem();
        if (selected == null) {
            return null;
        }
        if (selected instanceof AddeServer.Group) {
            AddeServer.Group group = (AddeServer.Group)selected;
            return group.getName();
        }
        String groupName = selected.toString().trim();
        if (groupName.length() > 0) {
            this.getServer();
            AddeServer server = this.getAddeServer();
            if (server != null) {
                AddeServer.Group group = this.getIdv().getIdvChooserManager().addAddeServerGroup(server, groupName, this.getGroupType());
                if (!group.getActive()) {
                    this.getIdv().getIdvChooserManager().activateAddeServerGroup(server, group);
                }
                this.setGroups();
                this.groupSelector.setSelectedItem(group);
            }
        }
        return groupName;
    }

    public JComboBox getServerSelector() {
        return this.serverSelector;
    }

    protected List readTextLines(String url) {
        AddeTextReader reader = new AddeTextReader(url);
        if (!reader.getStatus().equals("OK")) {
            return null;
        }
        return reader.getLinesOfText();
    }

    protected List readGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            String dataType = this.getDataType();
            String type = dataType.length() > 0 ? "TYPE=" + dataType : "TYPE=NOTYPE";
            StringBuffer buff = this.getUrl(REQ_TEXT);
            this.appendKeyValue(buff, PROP_FILE, FILE_PUBLICSRV);
            List lines = this.readTextLines(buff.toString());
            if (lines == null) {
                return null;
            }
            Hashtable<String, String> seen = new Hashtable<String, String>();
            for (int i = 0; i < lines.size(); ++i) {
                String group;
                String tok;
                int idx;
                List<String> toks;
                String line = lines.get(i).toString();
                if (line.indexOf(type) < 0 || (toks = StringUtil.split(line, ",", true, true)).size() == 0 || (idx = (tok = toks.get(0)).indexOf("=")) < 0 || !tok.substring(0, idx).trim().equals("N1") || seen.get(group = tok.substring(idx + 1).trim()) != null) continue;
                seen.put(group, group);
                groups.add(group);
            }
        }
        catch (Exception e) {
            return null;
        }
        return groups;
    }

    protected void handleUnknownDataSetError() {
        List groups = null;
        if (groups == null) {
            LogUtil.userErrorMessage("Dataset not found on server: " + this.getServer());
        } else {
            LogUtil.userErrorMessage("Dataset not found on server: " + this.getServer() + "\nPossible data sets:\n" + "   " + StringUtil.join("\n   ", groups));
        }
        this.setState(0);
    }

    protected void handleConnectionError(Exception excp) {
        String message = excp.getMessage();
        if (excp instanceof AddeURLException) {
            this.handleUnknownDataSetError();
        } else if (message.toLowerCase().indexOf("unknownhostexception") >= 0) {
            LogUtil.userErrorMessage("Could not access server: " + this.getServer());
        } else if (message.toLowerCase().indexOf("server unable to resolve this dataset") >= 0) {
            this.handleUnknownDataSetError();
        } else {
            if (message.toLowerCase().indexOf("no images satisfy") >= 0 || message.toLowerCase().indexOf("error generating list of files") >= 0) {
                LogUtil.userErrorMessage("No data available for the selection");
                return;
            }
            LogUtil.logException("Error connecting to: " + this.getServer(), excp);
        }
        if (this.getState() != 2) {
            this.setState(0);
        }
    }

    protected void setState(int newState) {
        this.state = newState;
        this.updateStatus();
    }

    protected int getState() {
        return this.state;
    }

    protected JComponent addServerComp(JComponent comp) {
        this.compsThatNeedServer.add(comp);
        return comp;
    }

    public boolean canDoCancel() {
        return false;
    }

    protected JComponent getConnectButton() {
        JButton connectBtn = new JButton("Connect");
        connectBtn.setActionCommand(CMD_CONNECT);
        connectBtn.addActionListener(this);
        JComponent buttonComp = connectBtn;
        this.registerStatusComp("connect", buttonComp);
        if (this.canDoCancel()) {
            this.cancelButton = GuiUtils.getImageButton("/auxdata/ui/icons/Exit16.gif", this.getClass());
            this.cancelButton.setEnabled(false);
            this.cancelButton.setActionCommand(GuiUtils.CMD_CANCEL);
            this.cancelButton.addActionListener(this);
            buttonComp = GuiUtils.hbox(buttonComp, this.cancelButton);
        }
        return buttonComp;
    }

    @Override
    public void readTimes() {
    }

    protected boolean getGoodToGo() {
        if (this.state != 2) {
            return false;
        }
        if (this.stationMap != null && !this.haveStationSelected()) {
            return false;
        }
        return this.haveTimeSelected();
    }

    protected void appendKeyValue(StringBuffer buf, String name, String value) {
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != '?') {
            buf.append("&");
        }
        buf.append(name);
        buf.append("=");
        buf.append(value);
    }

    protected int checkIfServerIsOk() {
        try {
            StringBuffer buff = this.getUrl(REQ_TEXT);
            this.appendKeyValue(buff, PROP_FILE, FILE_PUBLICSRV);
            URL url = new URL(buff.toString());
            URLConnection urlc = url.openConnection();
            InputStream is = urlc.getInputStream();
            is.close();
            return 0;
        }
        catch (AddeURLException ae) {
            String aes = ae.toString();
            if (aes.indexOf("Invalid project number") >= 0) {
                LogUtil.userErrorMessage("Invalid project number");
                return 1;
            }
            if (aes.indexOf("Invalid user id") >= 0) {
                LogUtil.userErrorMessage("Invalid user ID");
                return 1;
            }
            if (aes.indexOf("Accounting data") >= 0) {
                return 1;
            }
            if (aes.indexOf("cannot run server 'txtgserv") >= 0) {
                return 0;
            }
            LogUtil.userErrorMessage("Error connecting to server. " + ae.getMessage());
            return 2;
        }
        catch (Exception exc) {
            this.logException("Connecting to server:" + this.getServer(), exc);
            return 2;
        }
    }

    protected boolean canAccessServer() {
        int status;
        JTextField projFld = null;
        JTextField userFld = null;
        JPanel contents = null;
        JLabel label = null;
        boolean firstTime = true;
        while ((status = this.checkIfServerIsOk()) != 0) {
            if (status == 2) {
                this.setState(0);
                return false;
            }
            if (projFld == null) {
                projFld = new JTextField("", 10);
                userFld = new JTextField("", 10);
                GuiUtils.tmpInsets = GuiUtils.INSETS_5;
                contents = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("User ID:"), userFld, GuiUtils.rLabel("Project #:"), projFld}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
                label = new JLabel(" ");
                contents = GuiUtils.topCenter(label, contents);
                contents = GuiUtils.inset((Component)contents, 5);
            }
            String lbl = firstTime ? "The server: " + this.getServer() + " requires a user ID & project number for access" : "Authentication for server: " + this.getServer() + " failed. Please try again";
            label.setText(lbl);
            if (!GuiUtils.showOkCancelDialog(null, "ADDE Project/User name", contents, null)) {
                this.setState(0);
                return false;
            }
            firstTime = false;
            String userName = userFld.getText().trim();
            String project = projFld.getText().trim();
            if (userName.length() <= 0 || project.length() <= 0) continue;
            this.passwords.put(this.getServer(), new String[]{userName, project});
        }
        return true;
    }

    protected StringBuffer getUrl(String requestType) {
        StringBuffer buff = new StringBuffer("adde://" + this.getServer() + "/" + requestType + "?");
        this.appendMiscKeyValues(buff);
        return buff;
    }

    protected StringBuffer getGroupUrl(String requestType, String group) {
        StringBuffer buff = this.getUrl(requestType);
        this.appendKeyValue(buff, PROP_GROUP, group);
        return buff;
    }

    protected String getPort() {
        String prop = this.getIdv().getProperty(PROP_ADDEPORT, null);
        if (prop != null) {
            return prop;
        }
        return DEFAULT_PORT;
    }

    protected void appendMiscKeyValues(StringBuffer buff) {
        this.appendKeyValue(buff, PROP_COMPRESS, DEFAULT_COMPRESS);
        this.appendKeyValue(buff, PROP_PORT, this.getPort());
        this.appendKeyValue(buff, PROP_DEBUG, DEFAULT_DEBUG);
        this.appendKeyValue(buff, PROP_VERSION, DEFAULT_VERSION);
        this.appendKeyValue(buff, PROP_USER, DEFAULT_USER);
        this.appendKeyValue(buff, PROP_PROJ, DEFAULT_PROJ);
    }

    protected String[] getMiscKeyProps() {
        return new String[]{PROP_COMPRESS, PROP_PORT, PROP_DEBUG, PROP_VERSION, PROP_USER, PROP_PROJ};
    }

    public String getMiscKeywords() {
        StringBuffer buff = new StringBuffer();
        this.appendMiscKeyValues(buff);
        return buff.toString();
    }

    @Override
    protected int getDefaultRelativeTimeIndex() {
        return 0;
    }

    @Override
    protected void enableWidgets() {
        super.enableWidgets();
        if (this.drivercbx != null) {
            this.drivercbx.setSelected(false);
            this.enableTimeWidgets();
        }
        boolean connected = this.getState() == 2;
        GuiUtils.enableTree(this.timesContainer, connected);
    }
}

