/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.DataSource;
import ucar.unidata.idv.chooser.ChooserRunnable;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.MenuHandler;
import ucar.unidata.idv.chooser.ThreddsHandler;
import ucar.unidata.idv.chooser.WmsHandler;
import ucar.unidata.idv.chooser.XmlHandler;
import ucar.unidata.idv.ui.DataSelector;
import ucar.unidata.ui.DatasetUI;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.xml.XmlUtil;

public class XmlChooser
extends IdvChooser
implements ActionListener {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(XmlChooser.class.getName());
    public static final String PROP_CHOOSER_URL = "idv.chooser.url";
    public static final String TAG_ERROR = "error";
    public static final String ATTR_URL = "url";
    private static final String CMD_BROWSE = "cmd.browse";
    protected int timestamp = 0;
    private List handlers = new ArrayList();
    private Document document;
    private String xmlContents;
    private int historyIdx = -1;
    private JButton backBtn;
    private JButton fwdBtn;
    private PreferenceList urlListHandler;
    private JComboBox urlBox;
    private boolean okToDoUrlListEvents = true;
    private JPanel handlerHolder;
    private JPanel myContents;
    private String initialUrlPath = this.chooserNode != null ? XmlUtil.getAttribute((Node)this.chooserNode, "url", "") : "";
    private DataSelector dataSelector;

    public XmlChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        String tmp = (String)dataSource.getProperty(PROP_CHOOSER_URL);
        if (tmp != null) {
            this.initialUrlPath = tmp;
        }
    }

    private boolean haveHandler() {
        return this.historyIdx >= 0 && this.historyIdx < this.handlers.size();
    }

    @Override
    protected void updateStatus() {
        if (this.haveHandler()) {
            XmlHandler handler = (XmlHandler)this.handlers.get(this.historyIdx);
            handler.updateStatus();
        } else {
            this.setStatus("");
        }
    }

    @Override
    public void setHaveData(boolean have) {
        super.setHaveData(have);
        this.updateStatus();
    }

    @Override
    protected boolean shouldDoUpdateOnFirstDisplay() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(CMD_BROWSE)) {
            String filename = FileManager.getReadFile(FILTER_XML);
            if (filename == null) {
                return;
            }
            this.urlBox.setSelectedItem(filename);
        } else if (cmd.equals(GuiUtils.CMD_OK)) {
            this.doLoad();
        } else {
            super.actionPerformed(ae);
        }
    }

    public void initSubProperties(Hashtable properties) {
        properties.put("prop.chooserclassname", this.getClass().getName());
        properties.put(PROP_CHOOSER_URL, this.urlBox.getSelectedItem());
    }

    @Override
    protected boolean makeDataSource(Object definingObject, String dataType, Hashtable properties) {
        properties.put(PROP_CHOOSER_URL, this.urlBox.getSelectedItem());
        return super.makeDataSource(definingObject, dataType, properties);
    }

    @Override
    protected JComponent doMakeContents() {
        this.urlListHandler = this.getPreferenceList("idv.data.catalog.list");
        final XmlChooser xmlChooser = this;
        ActionListener catListListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!XmlChooser.this.okToDoUrlListEvents) {
                    return;
                }
                xmlChooser.actionPerformed(ae);
            }
        };
        this.urlBox = this.urlListHandler.createComboBox(GuiUtils.CMD_UPDATE, catListListener, true);
        GuiUtils.setPreferredWidth(this.urlBox, 200);
        JButton browseButton = new JButton("Select File...");
        browseButton.setToolTipText("Choose a catalog from disk");
        browseButton.setActionCommand(CMD_BROWSE);
        browseButton.addActionListener(this);
        GuiUtils.setHFill();
        JPanel catListPanel = GuiUtils.doLayout(new Component[]{this.urlBox}, 1, GuiUtils.WT_Y, GuiUtils.WT_N);
        this.backBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("/auxdata/ui/icons/Left16.gif", this.getClass()));
        this.backBtn.setToolTipText("View previous selection");
        GuiUtils.makeMouseOverBorder(this.backBtn);
        this.backBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XmlChooser.this.goBack();
            }
        });
        this.fwdBtn = GuiUtils.getImageButton(GuiUtils.getImageIcon("/auxdata/ui/icons/Right16.gif", this.getClass()));
        GuiUtils.makeMouseOverBorder(this.fwdBtn);
        this.fwdBtn.setToolTipText("View next selection");
        this.fwdBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XmlChooser.this.goForward();
            }
        });
        this.checkButtons();
        JComponent bottomButtons = this.getDefaultButtons();
        this.handlerHolder = new JPanel();
        this.handlerHolder.setLayout(new BorderLayout());
        if (this.getIdv().getArgsManager().getInitCatalogs().size() > 0) {
            this.initialUrlPath = (String)this.getIdv().getArgsManager().getInitCatalogs().get(0);
            this.urlBox.setSelectedItem(this.initialUrlPath);
        } else if (this.initialUrlPath != null && this.initialUrlPath.length() > 0) {
            this.makeUiFromPath(this.initialUrlPath);
        } else {
            this.makeBlankTree();
        }
        JPanel navButtons = GuiUtils.hbox(this.backBtn, this.fwdBtn);
        GuiUtils.tmpInsets = GRID_INSETS;
        JPanel catPanel = GuiUtils.doLayout(new Component[]{new JLabel("Catalogs:"), catListPanel, browseButton}, 3, GuiUtils.WT_NYN, GuiUtils.WT_N);
        JPanel topPanel = GuiUtils.leftCenter(navButtons, catPanel);
        this.myContents = GuiUtils.topCenterBottom(topPanel, this.handlerHolder, bottomButtons);
        return this.myContents;
    }

    public boolean makeUiFromPath(String xmlPath) {
        return this.makeUiFromPath(xmlPath, ++this.timestamp);
    }

    public boolean makeUiFromPath(String xmlPath, int myTimestamp) {
        boolean ok = true;
        try {
            if (xmlPath.length() > 0) {
                this.showWaitCursor();
                this.xmlContents = IOUtil.readContents(xmlPath, NULL_STRING);
                this.showNormalCursor();
                if (myTimestamp != this.timestamp) {
                    return false;
                }
                if (this.xmlContents == null) {
                    this.xmlContents = XmlUtil.tag(TAG_ERROR, XmlUtil.attr("label", "Could not load url: " + xmlPath));
                    ok = false;
                }
                if (this.xmlContents.indexOf("<") >= 0) {
                    this.document = XmlUtil.getDocument(this.xmlContents);
                }
                if (this.document == null || this.document.getDocumentElement() == null) {
                    xmlPath = xmlPath.indexOf("?") < 0 ? xmlPath + "?request=GetCapabilities&service=WMS" : xmlPath + "&request=GetCapabilities&service=WMS";
                    this.xmlContents = IOUtil.readContents(xmlPath, NULL_STRING);
                    this.document = XmlUtil.getDocument(this.xmlContents);
                }
                if (this.document == null || this.document.getDocumentElement() == null) {
                    throw new IllegalArgumentException("Could not process XML from:" + xmlPath);
                }
                this.makeUi(this.document, this.document.getDocumentElement(), xmlPath);
            } else {
                this.makeUi(null, null, xmlPath);
            }
        }
        catch (Exception exc) {
            if (myTimestamp != this.timestamp) {
                return false;
            }
            this.logException("Creating ui:" + xmlPath, exc);
            return false;
        }
        return ok;
    }

    protected void makeUi(Document doc, Element xmlRoot, String path) {
        this.document = doc;
        this.setHaveData(false);
        if (xmlRoot == null) {
            return;
        }
        this.setSelected(path);
        XmlHandler handler = null;
        String tagName = XmlUtil.getLocalName(xmlRoot);
        if (tagName.equals("WMT_MS_Capabilities") || tagName.equals("WMS_Capabilities")) {
            handler = new WmsHandler(this, xmlRoot, path);
        } else {
            if (tagName.equals(TAG_ERROR)) {
                String error = XmlUtil.getAttribute((Node)xmlRoot, "label", "Error");
                LogUtil.userErrorMessage("Error: " + error);
                return;
            }
            if (tagName.equals("catalog")) {
                handler = new ThreddsHandler(this, xmlRoot, path);
            } else if (tagName.equals("menus")) {
                handler = new MenuHandler(this, xmlRoot, path);
            } else {
                throw new IllegalArgumentException("Unknown xml:" + (this.xmlContents.length() > 100 ? this.xmlContents.substring(0, 100) : this.xmlContents) + " ...");
            }
        }
        JComponent contents = handler.getContents();
        contents.setPreferredSize(new Dimension(200, 250));
        this.addToContents(contents);
        this.addToHistory(handler);
        this.updateStatus();
    }

    private void setSelected(String xmlPath) {
        this.okToDoUrlListEvents = false;
        this.urlBox.setSelectedItem(xmlPath);
        this.okToDoUrlListEvents = true;
    }

    private void go() {
        if (this.haveHandler()) {
            XmlHandler handler = (XmlHandler)this.handlers.get(this.historyIdx);
            this.setSelected(handler.getPath());
            this.addToContents(handler.getContents());
            this.checkButtons();
        }
    }

    public void goBack() {
        --this.historyIdx;
        if (this.historyIdx < 0) {
            this.historyIdx = 0;
        }
        this.go();
    }

    public void goForward() {
        ++this.historyIdx;
        if (this.historyIdx >= this.handlers.size()) {
            this.historyIdx = this.handlers.size() - 1;
        }
        this.go();
    }

    private void checkButtons() {
        this.fwdBtn.setEnabled(this.historyIdx < this.handlers.size() - 1);
        this.backBtn.setEnabled(this.historyIdx > 0);
    }

    protected void handleAction(String action) {
        this.handleAction(action, new Hashtable());
    }

    protected void handleAction(String action, Hashtable properties) {
        this.handleActions(Misc.newList(new PropertiedAction(action, properties)));
    }

    protected void handleActions(final List actions) {
        Misc.run(new ChooserRunnable(this){

            @Override
            public void run() {
                XmlChooser.this.showWaitCursor();
                try {
                    XmlChooser.this.handleActionsInThread(actions);
                }
                catch (Exception exc) {
                    XmlChooser.this.logException("Creating data source", exc);
                }
                XmlChooser.this.showNormalCursor();
                if (this.getCanceled()) {
                    // empty if block
                }
            }
        });
    }

    protected void handleActionsInThread(List actions) {
        boolean didone = false;
        String invalidSource = null;
        for (int i = 0; i < actions.size(); ++i) {
            PropertiedAction action = (PropertiedAction)actions.get(i);
            boolean isValidAction = this.idv.handleAction(action.action, action.properties);
            if (isValidAction) {
                didone = true;
                continue;
            }
            if (invalidSource != null) continue;
            invalidSource = action.action;
        }
        if (didone) {
            this.closeChooser();
        } else if (invalidSource != null && invalidSource.endsWith(".xml")) {
            this.makeUiFromPath(invalidSource);
        }
    }

    @Override
    public void doUpdate() {
        if (this.okToDoUrlListEvents) {
            Misc.run(this, "doUpdateInner");
        }
    }

    public void doUpdateInner() {
        String selected = this.urlBox.getSelectedItem().toString().trim();
        if (selected.length() == 0) {
            if (this.handlers.size() > 0) {
                this.goBack();
            } else {
                this.makeBlankTree();
            }
            return;
        }
        if (this.makeUiFromPath(selected)) {
            this.urlListHandler.saveState(this.urlBox);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doLoadInThread() {
        block8: {
            this.showWaitCursor();
            try {
                Object handler = this.handlers.get(this.historyIdx);
                if (handler instanceof ThreddsHandler) {
                    ((ThreddsHandler)handler).doLoad();
                    break block8;
                }
                if (handler instanceof WmsHandler) {
                    ((WmsHandler)handler).doLoad();
                    break block8;
                }
                if (handler instanceof DatasetUI) {
                    String action = ((DatasetUI)handler).processActionTemplate();
                    if (action == null) {
                        return;
                    }
                    this.handleAction(action);
                } else if (!(handler instanceof XmlTree)) {
                    // empty if block
                }
            }
            catch (Exception exc) {
                this.logException("Loading data", exc);
            }
        }
        this.showNormalCursor();
    }

    private void addToHistory(XmlHandler handler) {
        int howManyToRemove = this.handlers.size() - this.historyIdx - 1;
        for (int cnt = 0; cnt < howManyToRemove; ++cnt) {
            Misc.removeLast(this.handlers);
        }
        this.handlers.add(handler);
        this.historyIdx = this.handlers.size() - 1;
        this.checkButtons();
    }

    private void makeBlankTree() {
        XmlTree blankTree = new XmlTree(null, true, "");
        this.addToContents(GuiUtils.inset((Component)GuiUtils.topCenter(new JPanel(), blankTree.getScroller()), 5));
    }

    private void addToContents(JComponent comp) {
        this.handlerHolder.removeAll();
        comp.setPreferredSize(new Dimension(200, 300));
        this.handlerHolder.add((Component)comp, "Center");
        if (this.myContents != null) {
            this.myContents.invalidate();
            this.myContents.validate();
            this.myContents.repaint();
        }
    }

    public String getXml() {
        return this.xmlContents;
    }

    public Document getDocument() {
        return this.document;
    }

    public static class PropertiedAction {
        String action;
        Hashtable properties;

        public PropertiedAction(String action) {
            this(action, new Hashtable());
        }

        public PropertiedAction(String action, Hashtable properties) {
            this.action = action;
            this.properties = properties;
        }
    }
}

