/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.gis.WmsSelection;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.idv.chooser.XmlChooser;
import ucar.unidata.idv.chooser.XmlHandler;
import ucar.unidata.ui.XmlTree;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WmsUtil;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import ucar.unidata.xml.XmlUtil;

public class WmsHandler
extends XmlHandler {
    private NavigatedMapPanel mapPanel;
    int versionMajor = 1;
    int versionMinor = 0;
    JCheckBox mergeLayerCbx;

    public WmsHandler(XmlChooser chooser, Element root, String path) {
        super(chooser, root, path);
        String version = XmlUtil.getAttribute(root, "version");
        List<String> tokens = StringUtil.split(version, ".");
        if (tokens.size() > 0) {
            this.versionMajor = new Integer(tokens.get(0));
        }
        if (tokens.size() > 1) {
            this.versionMinor = new Integer(tokens.get(1));
        }
    }

    @Override
    protected void updateStatus() {
        if (this.chooser.getHaveData()) {
            this.chooser.setStatus("Press \"" + "Add Source" + "\" to load the selected WMS layer", "buttons");
        } else {
            this.chooser.setStatus("Please select a WMS layer");
        }
    }

    void doTreeClick(Element node) {
        Element bboxNode;
        boolean isLoadable = WmsUtil.isLoadable(node);
        this.chooser.setHaveData(isLoadable);
        this.mapPanel.setDrawBounds(null, null);
        if (isLoadable && (bboxNode = WmsUtil.findBbox(node)) != null) {
            ProjectionRect rect = new ProjectionRect(XmlUtil.getAttribute((Node)bboxNode, "minx", -180.0), XmlUtil.getAttribute((Node)bboxNode, "miny", -90.0), XmlUtil.getAttribute((Node)bboxNode, "maxx", 180.0), XmlUtil.getAttribute((Node)bboxNode, "maxy", 90.0));
            this.mapPanel.setDrawBounds(this.getUpperLeft(rect), this.getLowerRight(rect));
        }
    }

    private LatLonPoint getUpperLeft(ProjectionRect r) {
        return new LatLonPointImpl(r.getMaxPoint().getY(), r.getMinPoint().getX());
    }

    private LatLonPoint getLowerRight(ProjectionRect r) {
        return new LatLonPointImpl(r.getMinPoint().getY(), r.getMaxPoint().getX());
    }

    @Override
    protected JComponent doMakeContents() {
        this.mergeLayerCbx = new JCheckBox("Merge Layers", false);
        this.mapPanel = new NavigatedMapPanel();
        this.mapPanel.setPreferredSize(new Dimension(250, 250));
        this.tree = new XmlTree(this.root, true, this.path){

            @Override
            public void doDoubleClick(XmlTree theTree, Element node) {
                WmsHandler.this.processNodes(Misc.newList(node));
            }

            @Override
            public void doClick(XmlTree theTree, Element node) {
                WmsHandler.this.doTreeClick(node);
            }

            @Override
            public void doRightClick(XmlTree theTree, Element node, MouseEvent event) {
                JPopupMenu popup = new JPopupMenu();
                WmsHandler.this.makePopupMenu(theTree, node, popup);
                popup.show((Component)event.getSource(), event.getX(), event.getY());
            }

            @Override
            protected boolean shouldRecurse(Element xmlNode) {
                String tagName = xmlNode.getTagName();
                if (!tagName.equals("Layer")) {
                    return super.shouldRecurse(xmlNode);
                }
                List styleChildren = XmlUtil.findChildren(xmlNode, "Style");
                return styleChildren.size() == 0 || styleChildren.size() > 1;
            }
        };
        this.tree.setMultipleSelect(true);
        this.tree.addTagsToProcess(Misc.newList("Layer", "Style"));
        this.tree.addTagsToNotProcessButRecurse(Misc.newList("Capability", "WMT_MS_Capabilities", "WMS_Capabilities"));
        this.tree.defineLabelChild("Layer", "Title");
        this.tree.defineLabelChild("Style", "Title");
        this.tree.defineTooltipChild("Layer", "Abstract");
        this.tree.defineTooltipChild("Style", "Abstract");
        JPanel left = GuiUtils.topCenter(this.mergeLayerCbx, this.tree.getScroller());
        JPanel right = GuiUtils.topCenter(GuiUtils.inset((Component)GuiUtils.lLabel("Image Bounds:"), 5), this.mapPanel);
        return GuiUtils.hsplit((Component)left, (Component)right, 250);
    }

    private void makePopupMenu(XmlTree theTree, final Element node, JPopupMenu popup) {
        JMenuItem mi = new JMenuItem("Load");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WmsHandler.this.processNodes(Misc.newList(node));
            }
        });
        popup.add(mi);
    }

    private void processNodes(List<Element> selectedNodes) {
        if (selectedNodes.size() == 0) {
            return;
        }
        boolean mergeLayers = this.mergeLayerCbx.isSelected();
        String[] message = new String[]{null};
        List<WmsSelection> infos = WmsUtil.processNode(this.root, selectedNodes, message, mergeLayers);
        if (message[0] != null) {
            XmlChooser.userMessage(message[0]);
            return;
        }
        String title = this.path;
        Element titleNode = XmlUtil.findDescendantFromPath(this.root, "Service.Title");
        if (titleNode != null) {
            title = XmlUtil.getChildText(titleNode);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("TITLE", title);
        this.chooser.makeDataSource(infos, "WMS", properties);
        this.chooser.closeChooser();
    }

    @Override
    public void doLoad() {
        this.processNodes(this.tree.getSelectedElements());
    }

    public static void convertToKml(String url) throws Exception {
        Element root = XmlUtil.getRoot(url, WmsHandler.class);
        System.err.println("root:" + XmlUtil.toString(root));
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String url = args[i];
            WmsHandler.convertToKml(url);
        }
    }
}

