/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.idv.chooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.util.StringUtil;

public class UrlChooser
extends IdvChooser
implements ActionListener {
    public static final String PREF_URLLIST = "idv.urllist";
    private PreferenceList prefList;
    private JComboBox box;
    private JTextArea textArea;
    private JScrollPane textScroller;
    private JComponent urlPanel;
    private JComponent textPanel;
    private boolean showBox = true;
    private JButton switchBtn;
    private GuiUtils.CardLayoutPanel cardLayoutPanel;
    private JLabel urlLabel;

    public UrlChooser(IdvChooserManager mgr, Element root) {
        super(mgr, root);
    }

    @Override
    public boolean canDoUpdate() {
        return false;
    }

    @Override
    protected String getLoadToolTip() {
        return "Load the URL";
    }

    @Override
    protected JComponent doMakeContents() {
        JComboBox dsComp = this.getDataSourcesComponent();
        this.prefList = this.getPreferenceList(PREF_URLLIST);
        JComponent urlButtons = this.getDefaultButtons();
        this.textArea = new JTextArea(5, 30);
        this.textScroller = new JScrollPane(this.textArea);
        this.textScroller.setPreferredSize(new Dimension(200, 100));
        this.textScroller.setMinimumSize(new Dimension(200, 100));
        this.box = this.prefList.createComboBox("Add Source", this);
        JPanel boxWrapper = GuiUtils.doLayout(new Component[]{this.box}, 1, GuiUtils.WT_Y, GuiUtils.WT_N);
        boxWrapper.setPreferredSize(new Dimension(200, 40));
        this.urlLabel = GuiUtils.rLabel("URL:");
        this.urlPanel = GuiUtils.top(boxWrapper);
        this.textPanel = this.textScroller;
        this.switchBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/DownDown.gif", this, "switchFields");
        this.cardLayoutPanel = new GuiUtils.CardLayoutPanel();
        this.cardLayoutPanel.addCard(this.urlPanel);
        this.cardLayoutPanel.addCard(this.textPanel);
        JPanel widgetPanel = GuiUtils.centerRight(this.cardLayoutPanel, GuiUtils.top(this.switchBtn));
        JComponent mainContents = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Data Source Type:"), GuiUtils.left(dsComp), GuiUtils.top(GuiUtils.inset((Component)this.urlLabel, new Insets(10, 0, 0, 0))), widgetPanel}, GRID_INSETS);
        mainContents = GuiUtils.vbox(mainContents, urlButtons);
        this.setHaveData(true);
        this.setStatus("Press \"Add Source\" to load the URL", "buttons");
        return GuiUtils.top(mainContents);
    }

    @Override
    public void setStatus(String msg, String what) {
        super.setStatus("Press \"Add Source\" to load the URL", "buttons");
    }

    public void switchFields() {
        boolean bl = this.showBox = !this.showBox;
        if (this.showBox) {
            this.urlLabel.setText("URL:");
            this.cardLayoutPanel.show(this.urlPanel);
            this.switchBtn.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/DownDown.gif"));
        } else {
            this.urlLabel.setText("URLS:");
            this.cardLayoutPanel.show(this.textPanel);
            this.switchBtn.setIcon(GuiUtils.getImageIcon("/auxdata/ui/icons/UpUp.gif"));
        }
    }

    private void loadURL() {
        this.showWaitCursor();
        this.loadURLInner();
        this.showNormalCursor();
    }

    private void loadURLInner() {
        String url = "";
        String dataSourceId = this.getDataSourceId();
        if (this.showBox) {
            Object selectedItem = this.box.getSelectedItem();
            if (selectedItem != null) {
                url = selectedItem.toString().trim();
            }
            if (url.length() == 0 && dataSourceId == null) {
                UrlChooser.userMessage("Please specify a url");
                return;
            }
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (dataSourceId != null) {
            properties.put("datatypeid", dataSourceId);
        }
        if (this.showBox) {
            if (this.idv.handleAction(url, properties)) {
                this.closeChooser();
                this.prefList.saveState(this.box);
            }
        } else {
            List<String> urls = StringUtil.split(this.textArea.getText(), "\n", true, true);
            if (urls.size() > 0 && this.makeDataSource(urls, dataSourceId, properties)) {
                this.closeChooser();
            }
        }
    }

    @Override
    public void doLoadInThread() {
        this.loadURL();
    }
}

